/*
                        Endeavour User & Group ID
 */

#ifndef EDV_ID_H
#define EDV_ID_H

#include <glib.h>


typedef struct _edv_uid_struct		edv_uid_struct;
#define EDV_UID(p)			((edv_uid_struct *)(p))
typedef struct _edv_gid_struct		edv_gid_struct;
#define EDV_GID(p)			((edv_gid_struct *)(p))


/*
 *	User ID:
 */
struct _edv_uid_struct {

	gchar		*name;
	gchar		*password;		/* Crypted */

	gint		user_id,
			group_id;

	gchar		*government_name;	/* "Government/legal/provisional/real" name */
	gchar		*home_directory;
	gchar		*shell_program;

};

/*
 *	Group ID:
 */
struct _edv_gid_struct {

	gchar		*name;
	gchar		*password;		/* Crypted */

	gint		group_id;

	GList		*group_members_list;	/* List of gchar * group
						 * member names */

};


/* User ID */
extern edv_uid_struct *EDVUIDNew(void);
extern void EDVUIDDelete(edv_uid_struct *uid);

extern GList *EDVUIDGetSystem(void);

extern edv_uid_struct *EDVUIDMatchByUID(
	GList *uids_list,
	const gint user_id, gint *n
);
extern edv_uid_struct *EDVUIDMatchByGID(
	GList *uids_list,
	const gint group_id, gint *n
);
extern gint EDVUIDNameToUID(GList *uids_list, const gchar *user_name);
extern gchar *EDVUIDGetNameFromUID(
	GList *uids_list,
	const gint user_id, gint *n
);
extern gchar *EDVUIDGetNameFromGID(
	GList *uids_list,
	const gint group_id, gint *n
);


/* Group ID */
extern edv_gid_struct *EDVGIDNew(void);
extern void EDVGIDDelete(edv_gid_struct *gid);

extern GList *EDVGIDGetSystem(void);

extern edv_gid_struct *EDVGIDMatchByGID(
	GList *gids_list,
	const gint group_id, gint *n
);
extern gint EDVGIDNameToGID(GList *gids_list, const gchar *group_name);
extern gchar *EDVGIDGetNameFromGID(
	GList *gids_list,
	const gint group_id, gint *n
);


#endif	/* EDV_ID_H */
