/*
		       Endeavour Process Execution

	To run a program specified by the MIME Type of a given disk object
	path or name.
 */

#ifndef EDV_OPEN_H
#define EDV_OPEN_H

#include <gtk/gtk.h>
#include "edv_types.h"


extern gchar *EDVOpenFormatCommand(
        edv_core_struct *core, const gchar *cmd, GList *paths_list
);

extern gint EDVOpen(
	edv_core_struct *core,
	GList *paths_list,
	const gchar *command_name,
	GtkWidget *toplevel,
	const gboolean verbose,
	gchar **stdout_path_rtn, gchar **stderr_path_rtn
);

extern gint EDVOpenWith(
	edv_core_struct *core,
	GList *paths_list,
	const gchar *command_name,
	GtkWidget *toplevel,
	const gboolean verbose,
	gchar **stdout_path_rtn, gchar **stderr_path_rtn
);

extern gint EDVOpenCommand(
        edv_core_struct *core,
        GList *paths_list,
        const gchar *command,
        GtkWidget *toplevel,
        const gboolean verbose,
        gchar **stdout_path_rtn, gchar **stderr_path_rtn
);


#endif	/* EDV_OPEN_H */
