/*
			       Event Notification
 */

#ifndef EDV_NOTIFY_H
#define EDV_NOTIFY_H

#include "edv_context.h"


/*
 *	Queues an "object_added_notify" command.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The path specifies the full path to the object that was
 *	added.
 */
extern void EDVNotifyQueueObjectAdded(
	edv_context_struct *ctx,
	const gchar *path
);

/*
 *	Queues an "object_modified_notify" command.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The path specifies the full path to the object that was
 *	modified (it may not exist in cases of renaming or moving).
 *
 *	The new_path specifies the full path to the new path of the
 *	modified object. If new_path is NULL then only path will be
 *	sent (hinting that the name of the object was not modified).
 */
extern void EDVNotifyQueueObjectModified(
	edv_context_struct *ctx,
	const gchar *path,
	const gchar *new_path
);

/*
 *	Queues an "object_removed_notify" command.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The path specifies the full path to the object that was
 *	removed.
 */
extern void EDVNotifyQueueObjectRemoved(
	edv_context_struct *ctx,
	const gchar *path
);


/*
 *	Queues an "object_mounted_notify" command.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The path specifies the full path to the mount path.
 */
extern void EDVNotifyQueueObjectMounted(
	edv_context_struct *ctx,
	const gchar *path
);

/*
 *	Queues an "object_unmounted_notify" command.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The path specifies the full path to the mount path.
 */
extern void EDVNotifyQueueObjectUnmounted(
	edv_context_struct *ctx,
	const gchar *path
);


/*
 *	Queues a "recycled_object_added_notify" command.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The index specifies the index of the recycled object.
 */
extern void EDVNotifyQueueRecycledObjectAdded(
	edv_context_struct *ctx,
	const guint index
);

/*
 *	Queues a "recycled_object_removed_notify" command.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The index specifies the index of the recycled object.
 */
extern void EDVNotifyQueueRecycledObjectRemoved(
	edv_context_struct *ctx,
	const guint index
);


/*
 *	Queues a "reconfigured_notify" command.
 *
 *	The ctx specifies the Endeavour 2 Context.
 */
extern void EDVNotifyQueueReconfiguredNotify(
	edv_context_struct *ctx
);


#endif	/* EDV_NOTIFY_H */
