#ifndef __MAINLOOP_H__
#define __MAINLOOP_H__

/* This file is used by all renderers that define thier own * mainloop.
 * Hense, rendgtk includes this file. */

/* Main loop control functions. */
typedef void (*MainLoopFunc) (void);
typedef void (*ExitFunc) (int errcode);

/* Define all the IO handling functions and enums that * each mainloop will
 * need to create. */
typedef enum {
    EIO_READ = 1 << 0,
    EIO_WRITE = 1 << 1,
    EIO_ERROR = 1 << 2
} EIOCond;

typedef int (*EIOFunc) (int fd, EIOCond cond, void *data);
typedef void *(*EIOAddFunc) (int fd, EIOCond cond, EIOFunc, void *data);
typedef void (*EIORemoveFunc) (void *tag);

typedef struct {
    gchar *loopname;		/* Function name/string. */
    MainLoopFunc mainloop;	/* The main loop program. */
    ExitFunc exitall;		/* Kill entity. FIXME MW */
    EIOAddFunc io_add;		/* Used to add io watchers. */
    EIORemoveFunc io_remove;	/* Used to remove a io watcher. */
} EntityMainLoop;


extern EntityMainLoop *entity_mainloop;

/* Mainloop registration code, called from inside the init funcrions of *
 * renderers that need a mainloop. */
void
 mainloop_register (gchar * loopname,
		    MainLoopFunc mainloop,
		    EIOAddFunc ioadd, EIORemoveFunc ioremove);

void
 entity_mainloop_run (void);

void *entity_mainloop_io_add (int fd, EIOCond cond, EIOFunc, void *data);

void
 entity_mainloop_io_remove (void *tag);

gint entity_mainloop_is_registered (void);

void
 entity_mainloop_exit (void);

#endif				/* __MAINLOOP_H__ */


