#!/usr/bin/env entity

<object>
  <window ondelete="entity:exit" title="Clock">
    <valign>
      <object onbuttonpress="context_menu" name="clock" dragable="true" expand="false">
        <popupmenu name="context">
	  <menuitem label="Remove" onselect="entity:exit"/>
	</popupmenu>
	<label name="time" text = "00:00:00"/>
	<timer interval = "100" action="update_clock"/>
        <timer interval = "6000" action="update_tooltip"/>
	<perl>
	    use Time::localtime;
	    
	    sub update_clock
	      {
	        my $str = sprintf ("%02d:%02d:%02d", localtime->hour(), 
		                   localtime->min(), localtime->sec());
		
		my $label = enode ("label.time");
		$label->attrib("text" => $str);
		
	      }
	    update_clock ();
	    
	    sub update_tooltip
	      {
	        my $datestr = ctime();
		enode ("object")->attrib ("tooltip" => $datestr);
	      }
	    update_tooltip ();
	    
	    sub context_menu
	      {
	        my ($node, $button) = @_;
				
		if ($button == 3) {
		  enode ("popupmenu.context")->attrib ("popup" => "true");
		}
	      }
	      
	</perl>
      </object>
    </valign>
  </window>
</object>
