#include <gtk/gtk.h>
#include <stdlib.h>
#include "entity.h"
#include "gtk-common.h"
#include "gtk-widget-attr.h"


static void
rendgtk_calendar_doubleclick_date_callback (GtkWidget * widget, gpointer user_data)
{
    ENode *node = user_data;
    gchar *function = NULL;

    function = enode_attrib_str (node, "ondateselect", NULL);

    if (function)
	enode_call_ignore_return (node, function, "");
}


static void
rendgtk_calendar_date_get (ENode *node, gchar *value)
{
    GtkWidget *calendar;
    char buf[128];
    guint year, month, day;
    
    calendar = enode_get_kv (node, "top-widget");
    if (!calendar)
	return;

    gtk_calendar_get_date (GTK_CALENDAR (calendar), &year, &month, &day);
    
    g_snprintf (buf, sizeof (buf), "%u", year);
    enode_attrib_quiet (node, "year", ebuf_new_with_str (buf));

    /* Month comes back offset from 0.. the only one that does */
    g_snprintf (buf, sizeof (buf), "%u", month + 1);
    enode_attrib_quiet (node, "month", ebuf_new_with_str (buf));
    
    g_snprintf (buf, sizeof (buf), "%u", day);
    enode_attrib_quiet (node, "day", ebuf_new_with_str (buf));
}

static gint
rendgtk_calendar_day_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *calendar;

    calendar = enode_get_kv (node, "top-widget");
    if (!calendar)
	return (TRUE);

    gtk_calendar_select_day (GTK_CALENDAR (calendar), erend_get_integer(value));
	
    return (TRUE);
}

static gint
rendgtk_calendar_month_set (ENode * node, EBuf * attr, EBuf * value)
{
    guint yearnum;
    guint monthnum;
    guint daynum;
    GtkWidget *calendar;

    calendar = enode_get_kv (node, "top-widget");
    if (!calendar)
	return (TRUE);

    gtk_calendar_get_date (GTK_CALENDAR (calendar), &yearnum, &monthnum, &daynum);
    gtk_calendar_select_month (GTK_CALENDAR (calendar), erend_get_integer (value) - 1, yearnum);
	
    return (TRUE);
}

static gint
rendgtk_calendar_year_set (ENode * node, EBuf * attr, EBuf * value)
{
    guint yearnum;
    guint monthnum;
    guint daynum;
    GtkWidget *calendar;

    calendar = enode_get_kv (node, "top-widget");
    if (!calendar)
	return (TRUE);

    gtk_calendar_get_date (GTK_CALENDAR (calendar), &yearnum, &monthnum, &daynum);
    gtk_calendar_select_month (GTK_CALENDAR (calendar), monthnum, erend_get_integer (value));
	
    return (TRUE);
}

#if 0

static void
rendgtk_button_onmouseenter_callback (GtkWidget * widget, gpointer user_data)
{
    ENode *node = user_data;
    gchar *function = NULL;

    function = enode_attrib_str (node, "onmouseenter", NULL);

    enode_call_ignore_return (node, function, "");
}

static void
rendgtk_button_onmouseleave_callback (GtkWidget * widget, gpointer user_data)
{
    ENode *node = user_data;
    gchar *function = NULL;

    function = enode_attrib_str (node, "onmouseleave", NULL);

    enode_call_ignore_return (node, function, "");
}

#endif 

static void
rendgtk_calendar_render (ENode * node)
{
    GtkWidget *calendar;

    EDEBUG (("calendar-renderer", "in rendgtk_calendar_render"));

    calendar = gtk_calendar_new ();

    enode_set_kv (node, "top-widget", calendar);

    gtk_signal_connect (GTK_OBJECT (calendar), "day_selected_double_click",
			rendgtk_calendar_doubleclick_date_callback, node);

    enode_attribs_sync (node);

    rendgtk_show_cond (node, calendar);
}


void
calendar_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr;

    element = g_new0 (Element, 1);
    element->render_func = rendgtk_calendar_render;
    element->destroy_func = rendgtk_element_destroy;
    element->parent_func = rendgtk_box_pack;
    element->tag = "calendar";
    element->description = "Create a new calendar widget";
    element_register (element);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "ondateselect";
    e_attr->description = "When a day is double-clicked, call this function.";
    e_attr->value_desc = "function";
    e_attr->possible_values = "(calendar_node)";
    element_register_attrib (element, e_attr);
    
    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "day";
    e_attr->description = "Get/set the currently selected day from the calendar.";
    e_attr->value_desc = "integer";
    e_attr->get_attr_func = rendgtk_calendar_date_get;
    e_attr->set_attr_func = rendgtk_calendar_day_set;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "month";
    e_attr->description = "Get/set the currently selected month from the calendar.";
    e_attr->value_desc = "integer";
    e_attr->get_attr_func = rendgtk_calendar_date_get;
    e_attr->set_attr_func = rendgtk_calendar_month_set;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "year";
    e_attr->description = "Get/set the currently selected year from the calendar.";
    e_attr->value_desc = "integer";
    e_attr->get_attr_func = rendgtk_calendar_date_get;
    e_attr->set_attr_func = rendgtk_calendar_year_set;
    element_register_attrib (element, e_attr);

    rendgtk_widget_attr_register (element, GTK_TYPE_CALENDAR);
    /* rendgtk_containerbox_attr_register (element); */
}


