#include <gtk/gtk.h>
#include "entity.h"
#include "gtk-common.h"
#include "gtk-widget-attr.h"


static gint
rendgtk_notepage_title_attr_set (ENode * node, EBuf * attr, EBuf * value);

/* 
 * static gint rendgtk_page_attr_set (ENode * node, gchar * attr, gchar *
 * value) { return TRUE; } */


static void
rendgtk_page_render (ENode * node)
{
    GtkWidget *vbox;
    GtkWidget *label_w;

    char *title;

    vbox = gtk_vbox_new (FALSE, 0);

    enode_set_kv (node, "top-widget", vbox);
    enode_set_kv (node, "bottom-widget", vbox);



    title = enode_attrib_str (node, "title", NULL);
    if (!title)
	title = "";

    label_w = gtk_label_new (title);
    enode_set_kv (node, "bottom-widget-label", label_w);

    gtk_widget_show (vbox);
    enode_attribs_sync (node);
}

static void
rendgtk_page_destroy (ENode * node)
{
    GtkWidget *page;
    GtkWidget *notebook;
    int page_num;

    if (!node->parent)
	return;

    page = enode_get_kv (node, "top-widget");
    if (!page)
	return;

    notebook = enode_get_kv (node->parent, "top-widget");
    if (!notebook)
	return;

    page_num = gtk_notebook_page_num (GTK_NOTEBOOK (notebook), page);

    gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), page_num);
}

static gint
rendgtk_notepage_title_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *page;
    GtkWidget *notebook;

    page = enode_get_kv (node, "top-widget");
    if (!page)
	return TRUE;

    notebook = enode_get_kv (node->parent, "top-widget");
    if (!notebook)
	return TRUE;

    gtk_notebook_set_tab_label_text (GTK_NOTEBOOK (notebook), page, value->str);
    return TRUE;
}

static gint
rendgtk_notepage_selected_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *page;
    GtkWidget *notebook;
    gint page_num;

    page = enode_get_kv (node, "top-widget");
    if (!page)
	return TRUE;

    notebook = enode_get_kv (node->parent, "top-widget");
    if (!notebook)
	return TRUE;

    page_num = gtk_notebook_page_num (GTK_NOTEBOOK (notebook), page);
    gtk_notebook_set_page (GTK_NOTEBOOK (notebook), page_num);

    return TRUE;
}

static int
rendgtk_notebook_switch_page_callback (GtkNotebook * notebook,
				       GtkNotebookPage * page, gint page_num,
				       ENode * node)
{
    ENode *child;
    GSList *list;
    ENode *node_page = NULL;
    gchar *onselect = NULL;
    int i = 0;
    gchar *stopselect;

    EDEBUG (("notebook-renderer", "page_num = %i", page_num));

    /* See if we should stop a selection once. Gtk notebooks are FUN! NOT! */
    stopselect = enode_get_kv (node, "rendgtk-notebook-stop-select-once");
    if (stopselect) {
	enode_set_kv (node, "rendgtk-notebook-stop-select-once", NULL);
	return FALSE;
    }

    for (list = node->children; list; list = list->next) {
	child = (ENode *) list->data;

	if (page_num != i)
	    enode_attrib_quiet (child, "selected", ebuf_new_with_false ());
	else {
	    enode_attrib_quiet (child, "selected", ebuf_new_with_true ());
	    node_page = child;
	    onselect = enode_attrib_str (node_page, "onselect", NULL);
	}

	i++;
    }

    if (!onselect)
	onselect = enode_attrib_str (node, "onselect", NULL);
    if (onselect && node_page)
	enode_call_ignore_return (node_page, onselect, "n", page_num);

    return FALSE;
}

static void
rendgtk_notebook_render (ENode * node)
{
    GtkWidget *notebook;

    notebook = gtk_notebook_new ();

    enode_set_kv (node, "top-widget", notebook);
    enode_set_kv (node, "bottom-widget", notebook);

    enode_attribs_sync (node);

    /* Connect this AFTER we set all the attribs because for some reason *
     * gtk wants to emit this signal on create. GACK! */
    gtk_signal_connect (GTK_OBJECT (notebook), "switch-page",
			GTK_SIGNAL_FUNC (rendgtk_notebook_switch_page_callback),
			node);


    rendgtk_show_cond (node, notebook);
}

static void
rendgtk_notebook_parent (ENode * parent_node, ENode * child_node)
{
    GtkWidget *notebook;
    GtkWidget *vbox;
    GtkWidget *label;

    if (ebuf_equal_str (child_node->element, "notepage")) {
        notebook = enode_get_kv (parent_node, "top-widget");
        vbox = enode_get_kv (child_node, "top-widget");

        label = enode_get_kv (child_node, "bottom-widget-label");

        enode_set_kv (parent_node, "rendgtk-notebook-stop-select-once", "1");

        gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox, label);
    }
}


void
notebook_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr;

    element = g_new0 (Element, 1);
    element->render_func = rendgtk_notebook_render;
    element->destroy_func = rendgtk_element_destroy;
    element->parent_func = rendgtk_notebook_parent;
    element->tag = "notebook";
    element->description = "Create a new notebook widget.";
    element_register (element);
    rendgtk_widget_attr_register (element, GTK_TYPE_NOTEBOOK);

    element = g_new0 (Element, 1);
    element->render_func = rendgtk_page_render;
    element->destroy_func = rendgtk_page_destroy;
    element->parent_func = rendgtk_box_pack;
    element->tag = "notepage";
    element->description = "Create a new page in a notebook.";
    element_register (element);
    rendgtk_widget_attr_register (element, GTK_TYPE_WIDGET);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "title";
    e_attr->description = "Sets the title for the notepage.";
    e_attr->value_desc = "string";
    e_attr->set_attr_func = rendgtk_notepage_title_attr_set;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "selected";
    e_attr->description = "Set if this page is the current notepage.";
    e_attr->value_desc = "string";
    e_attr->set_attr_func = rendgtk_notepage_selected_attr_set;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "onselect";
    e_attr->description = "Function to call when a notepage is selected.";
    e_attr->value_desc = "function";
    e_attr->possible_values = "(notebook_page)";
    e_attr->set_attr_func = NULL;
    element_register_attrib (element, e_attr);

}
