#include <gtk/gtk.h>
#include "entity.h"
#include "gtk-common.h"
#include "gtk-widget-attr.h"



/*--element

Element Name: <[vh]pane>

created a resizeable paned area.

%widget%

*/
static gint
rendgtk_pane_set_handle_size (ENode * node, EBuf * attr, EBuf * value)
{
    GtkPaned *pane;
    int new_val;

    pane = enode_get_kv (node, "top-widget");

    if (!pane) {
        return (TRUE);
    }
    
    new_val = erend_get_integer (value);
    if (new_val > 4)
        gtk_paned_set_handle_size (pane,new_val);
    
    return (TRUE);
}
static gint
rendgtk_pane_set_gutter_size (ENode * node, EBuf * attr, EBuf * value)
{
    GtkPaned *pane;
    int new_val;
    
    pane = enode_get_kv (node, "top-widget");
    if (!pane) {
        return (TRUE);
    }
    
    new_val = erend_get_integer (value);
    if (new_val > 4)
        gtk_paned_set_gutter_size (pane,new_val);
    
    return (TRUE);
}

static void
rendgtk_pane_parenter (ENode * parent_node, ENode * child_node)
{
    GtkWidget *pane;
    GtkWidget *widget;
    gint loc;

    pane = enode_get_kv (parent_node, "top-widget");
    widget = enode_get_kv (child_node, "top-widget");
    if (!pane || !widget)
	return;

    /* Find the location of child in the xml. */
    loc = g_slist_index (parent_node->children, child_node);

    if (0 == loc) {
	gtk_paned_add1 (GTK_PANED (pane), widget);
    } else if (1 == loc) {
	gtk_paned_add2 (GTK_PANED (pane), widget);
    } else {
	g_warning ("Unfortunately, GtkPane's can only have two children.");
    }
}

static void
rendgtk_pane_render (ENode * node)
{
    GtkWidget *pane;		/* The new pane. */
    EBuf *gutter;
    EBuf *handle;
    int gutter_size = 10;
    int handle_size = 10;
    
    
    if (ebuf_equal_str (node->element, "vpane"))
	pane = gtk_vpaned_new ();
    else
	pane = gtk_hpaned_new ();

    gutter = enode_attrib (node, "gutter_size", NULL);
    if (ebuf_not_empty (gutter))
        gutter_size = erend_get_float (gutter);
    
    handle = enode_attrib (node, "handle_size", NULL);
    if (ebuf_not_empty (gutter))
        handle_size = erend_get_float (handle);
    
    if (gutter_size > 4)
        gtk_paned_set_gutter_size (GTK_PANED (pane), gutter_size);
    
    if (handle_size > 4)
        gtk_paned_set_handle_size (GTK_PANED (pane), handle_size);

    enode_set_kv (node, "top-widget", pane);
    enode_set_kv (node, "buttom-widget", pane);

    enode_attribs_sync (node);

    rendgtk_show_cond (node, pane);
}

void
pane_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr;
    element = g_new0 (Element, 1);
    element->render_func = rendgtk_pane_render;
    element->destroy_func = NULL;
    element->parent_func = rendgtk_pane_parenter;
    element->tag = "vpane";
    element->description = "Create a new vertical pane.";
    element_register (element);
    rendgtk_widget_attr_register (element, GTK_TYPE_PANED);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "handle-size";
    e_attr->description = "Set handle size.";
    e_attr->value_desc = "integer";
    e_attr->possible_values = "5,*";
    e_attr->set_attr_func = rendgtk_pane_set_handle_size;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "gutter-size";
    e_attr->description = "Set gutter size.";
    e_attr->value_desc = "integer";
    e_attr->possible_values = "5,*";
    e_attr->set_attr_func = rendgtk_pane_set_gutter_size;
    element_register_attrib (element, e_attr);

    element = g_new0 (Element, 1);
    element->render_func = rendgtk_pane_render;
    element->destroy_func = NULL;
    element->parent_func = rendgtk_pane_parenter;
    element->tag = "hpane";
    element->description = "Create a new horizontal pane.";
    element_register (element);
    rendgtk_widget_attr_register (element, GTK_TYPE_PANED);
}
