/**SDL renderer's register functions here. **/

/* Our generic SDL item structure that the window will render. */
typedef struct _sdl_item sdl_item;

struct _sdl_item
{
  int type;
  char * name;
  SDL_Surface * surface;
  int x;
  int y;
  int width;
  int height;
  int old_x;
  int old_y;
  Uint32 color;
  int needs_refresh;
};

/* Item types defined here. */
#define SDL_SPRITE	1
#define SDL_RECTANGLE	2

/* Item register functions here. */
void sdl_sprite_register (void);
void sdl_rectangle_register (void);
void sdl_mouse_register (void);
void sdl_keys_register (void);


/* Rendering functions here. */
void sdl_sprite_render (SDL_Rect *dest, SDL_Surface * screen, sdl_item * item);
void sdl_rectangle_render (SDL_Rect *dest, SDL_Surface * screen,
	sdl_item * item);

/* Other render type functions. */
void sdl_keys_call_sets (ENode * node, Uint8 * keys);
