# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2006 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a pixmap cache for icons.
"""

from qt import QPixmap

class PixmapCache:
    """
    Class implementing a pixmap cache for icons.
    """
    def __init__(self):
        """
        Constructor
        """
        self.pixmapCache = {}

    def getPixmap(self, key):
        """
        Public method to retrieve a pixmap.
        
        @param key name of the wanted pixmap (string)
        @return the requested pixmap (QPixmap)
        """
        try:
            return self.pixmapCache[key]
        except KeyError:
            self.pixmapCache[key] = QPixmap.fromMimeSource(key)
            return self.pixmapCache[key]
            
pixCache = PixmapCache()

def getPixmap(key, cache = pixCache):
    """
    Module function to retrieve a pixmap.
    
    @param key name of the wanted pixmap (string)
    @return the requested pixmap (QPixmap)
    """
    return cache.getPixmap(key)
