# -*- coding: utf-8 -*-

# Copyright (c) 2005 - 2006 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to enter the revisions for the svn diff command.
"""

from qt import *

from RevisionSelectionForm import RevisionSelectionForm


class SvnRevisionSelectionDialog(RevisionSelectionForm):
    """
    Class implementing a dialog to enter the revisions for the svn diff command.
    """
    def __init__(self,parent = None):
        """
        Constructor
        
        @param parent parent widget of the dialog (QWidget)
        """
        RevisionSelectionForm.__init__(self,parent,modal=1)
        
        dummy = self.trUtf8("Dummy")

    def handleOldChanged(self, val):
        """
        Privat slot to handle the valueChanged(int) signal of the first spinbox.
        
        @param val value of the spinbox (integer)
        """
        self.newSpinBox.setEnabled(val > 0)
    
    def getRevisions(self):
        """
        Public method to get the revisions.
        
        @return list of one or two integers or None
        """
        rev1 = self.oldSpinBox.value()
        rev2 = self.newSpinBox.value()
        
        if rev1 == 0:
            return None
        elif rev2 == 0:
            return [rev1]
        else:
            return [rev1, rev2]
