#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2006 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Eric3 UI Previewer

This is the main Python script that performs the neccessary initialization
of the ui previewer and starts the Qt event loop. This is a standalone version
of the integrated ui previewer.
"""

import sys

from Utilities import Startup

def createMainWidget(argv, qtDir):
    """
    Function to create the main widget.
    
    @param argv list of commandline parameters (list of strings)
    @param qtDir directory of the Qt installation (string)
    @return reference to the main widget (QWidget)
    """
    from Tools.UIPreviewer import UIPreviewer
    
    if len(argv) > 1:
        fn = argv[1]
    else:
        fn = None
    
    previewer = UIPreviewer(fn, None, 'UIPreviewer')
    return previewer

def main():
    """
    Main entry point into the application.
    """
    appinfo = Startup.makeAppInfo(sys.argv,
                                  "Eric3 UI Previewer",
                                  "file",
                                  "UI file previewer")
    res = Startup.simpleAppStartup(sys.argv,
                                   appinfo,
                                   createMainWidget,
                                   [('!+file', '')])
    sys.exit(res)

if __name__ == '__main__':
    main()
