/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-subapp-types.h,v 1.10 2005/02/01 02:32:01 hoa Exp $
 */

#ifndef ETPAN_SUBAPP_TYPES_H

#define ETPAN_SUBAPP_TYPES_H

#include "etpan-app-types.h"
#include <ncurses.h>

/*
  these 3 headers MUST be included before <sys/select.h>
  to insure compatibility with Mac OS X (this is true for 10.2)
*/
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/select.h>
#include <time.h>

struct etpan_subapp {
  struct etpan_subapp_driver * driver;
  struct etpan_app * app;
  struct etpan_subapp * parent;

  double relative_left;
  double relative_top;
  double relative_width;
  double relative_height;
  
  int left;
  int top;
  int width;
  int height;
  
  int display_left;
  int display_top;
  int display_width;
  int display_height;
  
  int show_cursor;
  
  int enabled;
  
  int display_init;
  
  void * data;
  
  char * title;
  
  int cursor_x;
  int cursor_y;
  
  carray * thread_list;
};

struct etpan_subapp_driver {
  char * name;
  
  int always_handle_key;
  int always_on_top;
  
  int (* init)(struct etpan_subapp * app);
  void (* done)(struct etpan_subapp * app);
  int (* display_init)(struct etpan_subapp * app);
  void (* display_done)(struct etpan_subapp * app);
  int (* get_idle_delay)(struct etpan_subapp * app);
  int (* get_idle_udelay)(struct etpan_subapp * app, struct timeval * delay);
  void (* idle)(struct etpan_subapp * app);
  void (* set_fd)(struct etpan_subapp * app, fd_set * fds, int * maxfd);
  void (* handle_fd)(struct etpan_subapp * app, fd_set * fds);
  void (* handle_key)(struct etpan_subapp * app, int key);
  void (* handle_resize)(struct etpan_subapp * app);
  void (* display)(struct etpan_subapp * app, WINDOW * w);
  void (* set_color)(struct etpan_subapp * app);
  void (* enter)(struct etpan_subapp * app, struct etpan_subapp * old_app);
  void (* leave)(struct etpan_subapp * app, struct etpan_subapp * new_app);
};

/*
  if get_idle_delay() return -1, it is infinite.
*/

#define KEY_META(x) ((x) | 0x80)
#define KEY_CTRL(x) (((x) & ~0x20) & 0x1f)

#endif
