/*
 * Copyright 2005 Scalix, Inc. (www.scalix.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 *
 * Authors:	Christian Kellner <Christian.Kellner@scalix.com>
 *          Carsten Guenther <Carsten.Guenther@scalix.com>
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib-object.h>
#include <libedataserver/e-data-server-module.h>
#include <libedata-book/e-book-backend-factory.h>

#include <libescalix/scalix.h>
#include "e-book-backend-scalix.h"

E_BOOK_BACKEND_FACTORY_SIMPLE (scalix, SCALIX, e_book_backend_scalix_new)

static GType scalix_type;

void
eds_module_initialize (GTypeModule * module)
{
    libescalix_init (TRUE);
    scalix_type = _scalix_factory_get_type (module);
}

void
eds_module_shutdown (void)
{
}

void
eds_module_list_types (const GType ** types, int *num_types)
{
    *types = &scalix_type;
    *num_types = 1;
}
