#
# spec file for package ext2resize
# 
#   Copyright (C) 2002 Andreas Dilger <adilger@clusterfs.com>
#   Copyright (C) 1999, 2000, 2001 Andreas Dilger <adilger@turbolinux.com>
#


Name:         ext2resize
Release:      1
Packager:     adilger@clusterfs.com
Copyright:    GPL Copyright (C) 1999 Lennert Buytenhek, 1999-2002 Andreas Dilger
Group:        System Environment/Base
Provides:     ext2resize ext2online
Autoreqprov:  on
%define ver   1.1.19
Version:      %{ver}
Summary:      Second extended filesystem offline and online resize tools
URL:          http://sourceforge.net/projects/ext2resize/
Source:       http://sourceforge.net/projects/ext2resize/ext2resize-%{ver}.tar.bz2
BuildRoot:    /var/tmp/%{name}-%{version}-%{release}

%description
Programs and man pages for tools that resize second extended (ext2)
filesystems (including journalled ext2 filesystems, also called ext3).
Included are tools for offline (unmounted) and online (mounted)
resize of filesystems.  Online filesystem resizing requires support
in the kernel (patches for which are included herein).

%prep
%setup -n ext2resize-%{ver}

%build
./configure --prefix=/ --mandir=%{_mandir}
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr/share/man/man8
make DESTDIR=$RPM_BUILD_ROOT install

%files
%docdir /usr/doc/packages/ext2resize
%doc AUTHORS ChangeLog COPYING doc/HOWTO README THANKS doc/TODO
/sbin/ext2resize
/sbin/ext2prepare
/sbin/ext2online
%{_mandir}/man8/ext2resize.8.gz
%{_mandir}/man8/ext2prepare.8.gz
%{_mandir}/man8/ext2online.8.gz

%changelog
* Thu Sep 30 2004 Stephen C. Tweedie <sct@redhat.com> 1.1.19-1
- Release 1.1.19
 - Various build fixes for gcc-3.4

* Tue May 29 2001 - Brian Murrell <brian@mountainviewdata.com>
- Specify BuildRoot
- Make install in DESTDIR
- Clean BuildRoot before installing
- %files -> manpages with .gz suffix

* Thu Oct 12 2000 - Andreas Dilger <adilger@turbolinux.com>
- original RPM spec file
