/*  bin2src.c -
 *		convert to C source file from binary data file
 *
 *			Date:	1999 Jan 30
 *			Auther: KIMURA Takamichi<takamiti@tsden.org>
 *
 *  $Id: bin2src.c,v 1.1.1.1 2000/11/29 11:58:06 takamiti Exp $
 *
 *	options:
 *		-o = output file name(if ommited, out to "stdout")
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <sys/types.h>
#include "extipl.h"

#define DOT_INC			".inc"

static int bin2src(FILE *, char *, off_t, int);
static int parse_line(char *, char **, char **);


main(argc, argv)
int argc;
char **argv;
{
    FILE *templet, *output;
    char line[LBUF_SIZE], *outfile, *av[64], *work;
    char **s, *p;
    int n, i, ac;
    long skip, len;

    outfile =  NULL;
    while (--argc > 0 && *(*(++argv)) == '-') {
	p = *argv + 1;
	while (*p) {
	    s = NULL;
	    switch(*p) {
	    case 'o': s = &outfile;	break;
	    default:  exit(1);
	    }
	    if (s != NULL) {
		++p;
		if (*p) *s = p;
		else if (++argv, --argc != 0)
		    *s = *argv;
		else
		    exit(1);
		break;
	    }
	}
    }

    if (*argv == NULL || (templet = fopen(*argv, "r")) == NULL) {
	fprintf(stderr, "can not open templet file\n");
	exit(1);
    }

    if (outfile == NULL) {
	output = stdout;
    } else {
	if ((output = fopen(outfile, "w")) == NULL) {
	    fprintf(stderr, "can not open output file\n");
	    exit(1);
	}
    }
    n = 1;
    while(n > 0 && fgets(line, LBUF_SIZE, templet) != NULL) {
	if (*line == '.' && (ac = parse_line(line, av, &work)) > 0) {
	    if (ac >= 2 && strcmp(av[0], DOT_INC) == 0) {
	        skip = 0;
		len = SECTOR_SIZE;
		for(i = 2; i < ac; i++) {
		    if (strncmp(av[i], "skip=", 5) == 0) {
			skip = atol(av[i] + 5);
		    }
		    if (strncmp(av[i], "len=", 4) == 0) {
			len = atol(av[i] + 4);
		    }
		}
		if (skip < 0) skip = 0;
		if (len < 0) len = SECTOR_SIZE;
		n = bin2src(output, av[1], (off_t)skip, (int)len);
	    } else
		fputs(line, output);
	    free(work);
	    if (n < 0) break;
	} else
	    fputs(line, output);
    }
    fclose(output);
    fclose(templet);
    if (n < 0) {
	unlink(outfile);
	exit(1);
    }
    exit(0);
}

static int bin2src(fp, name, skip, len)
FILE *fp;
char *name;
off_t skip;
int len;
{
    int fd, n, m, i;
    char buf[SECTOR_SIZE], *p;

    if ((fd = open(name, O_RDONLY)) < 0) {
	perror(name);
	return(-1);
    }
    lseek(fd, skip, SEEK_SET);
    m = 0;
    do {
	n = (len <= SECTOR_SIZE) ? len : SECTOR_SIZE;
	len -= n;
	if ((n = read(fd, buf, n)) < 0) return(-1);
	if (n == 0) break;
	m += n;
	for(p = buf, i = 0; i < n; i++, p++) {
	    if (i % 8 == 0)
		fprintf(fp, "%s", i == 0 ? "\t" : "\n\t");
	    fprintf(fp, "0x%02X, ", *p & 0xff);
	}
	if (n == SECTOR_SIZE) fprintf(fp, "\n");
    } while(len > 0);
    close(fd);
    fprintf(fp, "\n\t/* %d bytes */\n", m);
    return(m);
}

static int parse_line(buf, av, dst)
char *buf, **av, **dst;
{
    int quote, ac;
    char *s;

    if ((s = *dst = strdup(buf)) == NULL)
	return(-1);

    quote = ac = 0;
    while(*buf) {
	while(*buf && (isspace(*buf) || *buf == '\n')) buf++;
	*av = s;
	while(*buf) {
	    if (quote == 0 && (isspace(*buf) || *buf == '\n')) break;
	    switch(*buf) {
	    case '"':
		    quote = 1 - quote;
	    case '\\':
		    buf++;
		    if (*buf == 0) break;
	    default:
		    *s++ = *buf++;
		    break;
	    }
	}
	*s++ = 0;
	ac++;
	av++;
    }
    av = NULL;
    if (quote || ac == 0) {
	free(*dst);
	*dst = NULL;
	if (quote) return(-1);
    }
    return(ac);
}
