#!/bin/sh

prg=$(basename $0)

#if [ "x$1" = "x" -o ! -d "$1" -o "x$2" = "x" ]; then
if [ -z "$1" -o ! -d "$1" -o -z "$2" -o -z "$3" ]; then
	echo "Usage: $prg dir oldlang newlang"
	exit 1
fi

dirname=$1
oldlang=$2
newlang=$3
sedrules=$(basename $0 .sh).$newlang.sed

if [ ! -f $sedrules ]; then
	echo "Error: Can't read sed rulesfile $sedrules."
	exit 1
fi

# Isolate all language files (don't do this automatically...!)
#for x in `find * -type f | grep -v cache | grep 'en_GB'`; do mkdir -p /tmp/ezlangtmp/`dirname $x`; cp -r $x /tmp/ezlangtmp/`dirname $x`; done

# rename to proper locale name (ignored on multiple runs)
for x in `find $dirname -name "*$oldlang*"`; do
	[ $x = $dirname ] && continue
	mv $x $(echo $x | sed "s/\($dirname.*\)$oldlang/\1$newlang/") #"
done

# Use super-sed if available (wins a few seconds)
ssed=`which ssed`

for file in `find $dirname -type f`; do
	if [ -n "$ssed" ]; then
		cat $file | $ssed -f $sedrules -i $file
	else
		cat $file | sed -f $sedrules > $file.tmp
		mv $file.tmp $file
	fi
done

#After this you should patch with the .diff (if any).
