/***************************************************************************
                          FLManager.cpp  -  description
                             -------------------
    begin                : Sun Jul 15 2001
    copyright            : (C) 2001,2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "FLManager.h"
#include "FLFieldMetaData.h"
#include "FLRelationMetaData.h"
#include "FLCompoundKey.h"
#include "FLSqlQuery.h"
#include "FLApplication.h"
#include "FLParameterQuery.h"
#include "FLGroupByQuery.h"
#include "FLUtil.h"
#include "FLAction.h"
#include "FLSqlCursor.h"

FLManager::FLManager ()
{
}

FLManager::~FLManager ()
{
}

bool FLManager::existsTable (const QString & n)
{
  QStringList::iterator it;
  QStringList
	tables =
	QSqlDatabase::database ()->
	tables ();

  for (it = tables.begin (); it != tables.end (); it++)
	if (n == (*it))
	  return true;

  return false;
}

FLTableMetaData *
FLManager::createTable (FLTableMetaData * tmd)
{
  if (!tmd)
	return 0;

  QString primaryKey (QString::null);
  QString sql = "CREATE TABLE " + tmd->name () + "(";
  QString seq;
  QSqlQuery q;

  FLFieldMetaData *field;

  FLTableMetaData::FLFieldMetaDataList * fieldList = tmd->fieldList ();

  // Codigo para comprobar que no hay ms de un campo tipo Unlock
  // por Andrs Otn Urbano
  unsigned int unlocks = 0;
  for (unsigned int i = 0; i < fieldList->count (); i++)
	{
	  field = fieldList->at (i);
	  if (field->type () == FLFieldMetaData::Unlock)
		unlocks++;
	}
  if (unlocks > 1)
	{
	  qWarning ("FLManager : " + qApp->tr ("No se ha podido crear la tabla ") + tmd->name ());
	  qWarning ("FLManager : " + qApp->tr ("Hay ms de un campo tipo unlock. Solo puede haber uno."));
	  return 0;
	}
  //Fin del codigo de comprobacin

  for (unsigned int i = 0; i < fieldList->count (); i++)
	{
	  field = fieldList->at (i);
	  if (field->type () == FLFieldMetaData::Sequence)	// Las secuencias tienen un tratamiento especial
		{
		  createSequence (tmd->name () + "_" + field->name ());
		}
	  sql += field->name ();
	  switch (field->type ())
		{
		case QVariant::Int:
		  sql += " INT2";
		  break;

		case QVariant::UInt:
		case FLFieldMetaData::Sequence:	// Se crean igual que el tipo uint
		  sql += " INT4";
		  break;

		case QVariant::Bool:
		case FLFieldMetaData::Unlock:	//Tipo bool para bloqueo de registros (Andrs Otn Urbano)
		  sql += " BOOLEAN";
		  break;

		case QVariant::Double:
		  sql += " FLOAT8";
		  break;

		case QVariant::Time:
		  sql += " TIME";
		  break;

		case QVariant::Date:
		  sql += " DATE";
		  break;

		case QVariant::Pixmap:
		  sql += " TEXT";
		  break;

		case QVariant::String:
		  sql += " VARCHAR";
		  break;

		case QVariant::StringList:
		  sql += " TEXT";
		  break;

		case FLFieldMetaData::Serial:
		  seq = tmd->name () + "_" + field->name () + "_seq";
		  q.exec ("SELECT relname FROM pg_class WHERE relname='" + seq + "';");
		  if (!q.next ())
			q.exec ("CREATE SEQUENCE " + seq + ";");
		  sql += " INT4 DEFAULT NEXTVAL('" + seq + "')";
		  break;
		}

	  int longitud = field->length ();

	  if (longitud > 0)
		sql += "(" + QString::number (longitud) + ")";

	  if (field->isUnique ())
		sql += " UNIQUE";

	  if (!field->allowNull ())
		sql += " NOT NULL";
	  else
		sql += " NULL";

	  if (field->isPrimaryKey ())
		{
		  if (primaryKey.isEmpty ())
			{
			  sql += " PRIMARY KEY";
			  primaryKey = field->name ();
			}
		  else
			{
			  qWarning (qApp->tr ("FLManager : Tabla -> ") + tmd->name () +
						qApp->tr
						(" . Se ha intentado poner una segunda clave primaria para el campo ")
						+ field->name () + qApp->tr (" , pero el campo ") +
						primaryKey +
						qApp->tr
						(" ya es clave primaria. Slo puede existir una clave primaria en FLTableMetaData, use FLCompoundKey para crear claves compuestas."));
			  return 0;
			}
		}

	  if (fieldList->next () != 0)
		sql += ",";
	}

  sql += ");";

  if (!q.exec (sql))
	{
	  qWarning ("FLManager : " + qApp->tr ("No se ha podido crear la tabla ") + tmd->name ());
	  qWarning ("FLManager : SQL - " + sql);
	  return 0;
	}

  return tmd;
}

FLTableMetaData *
FLManager::createTable (const QString & n)
{
  FLTableMetaData *tmd = metadata (n);

  return createTable (tmd);
}

bool FLManager::createSequence (const QString & name)
{
  QDomDocument
  doc (name);
  QFile
	fi;
  QDomElement
	docElem;
  QTextStream
	t;

  // Comprobamos que exista la tabla
  if (!existsTable ("flsequences"))
	{
	  fi.setName (FLDATA "/facturalux/tables/flsequences.mtd");
	  if (!fi.open (IO_ReadOnly))
		qWarning ("FLManager : " + qApp->tr ("Los meta datos para flsequences no estn definidos"));
	  else
		{
		  t.setDevice (&fi);
		  if (!doc.setContent (t.read ()))
			qWarning ("FLManager : " + qApp->tr ("Error al cargar los meta datos para flsequences"));
		  else
			{
			  docElem = doc.documentElement ();
			  createTable (metadata (&docElem));
			}
		}
	}
  // Ahora creamos la sequencia
  QSqlCursor
  c ("flsequences");
  c.setFilter ("seqname='" + name + "'");
  c.select ();
  if (c.next ())
	{
	  // Ya existe
	  return true;
	}
  else
	{
	  // La creamos
	  QSqlQuery
		q;
	  if (!q.exec ("INSERT INTO flsequences(seqname,valor) VALUES('" + name + "','1');"))
		{
		  qWarning ("FLManager : " + qApp->tr ("No se pudo crear la secuencia " + name));
		  return true;
		}
	}
  return true;
}

bool
FLManager::checkMetaData (const QString & n)
{
  QDomDocument doc (n);
  QFile fi (FLDATA "/facturalux/tables/" + n + ".mtd");
  QDomElement docElem;

  if (!fi.open (IO_ReadOnly))
	{
	  fi.close ();
	  qWarning ("FLManager : " + qApp->tr ("Los meta datos para ") + n + qApp->tr (" no estn definidos"));
	  return true;
	}
  QTextStream t (&fi);
  QString mtd1 = t.read ();
  fi.close ();

  if (!existsTable ("flmetadata"))
	{
	  fi.setName (FLDATA "/facturalux/tables/flmetadata.mtd");
	  if (!fi.open (IO_ReadOnly))
		qWarning ("FLManager : " + qApp->tr ("Los meta datos para flmetadata no estn definidos"));
	  else
		{
		  t.setDevice (&fi);
		  if (!doc.setContent (t.read ()))
			qWarning ("FLManager : " + qApp->tr ("Error al cargar los meta datos para flmetadata"));
		  else
			{
			  docElem = doc.documentElement ();
			  createTable (metadata (&docElem));
			}
		}
	}

  QString mtd2;
  QSqlCursor c ("flmetadata");
  c.setFilter ("tabla='" + n + "'");
  c.select ();
  if (c.next ())
	{
	  QSqlRecord *buffer = c.editBuffer (true);
	  mtd2 = buffer->value ("xml").toString ();
	}
  else
	return true;

  return checkMetaData (mtd1, mtd2);
}

bool
FLManager::alterTable (const QString & mtd1, const QString & mtd2)
{
  FLTableMetaData *oldMTD;
  FLTableMetaData *newMTD;
  QDomDocument doc ("doc");
  QDomElement docElem;

  if (!doc.setContent (mtd1))
	{
	  qWarning ("FLManager : " + qApp->tr ("Error al cargar los meta datos en mtodo alterTable"));
	  return false;
	}
  else
	{
	  docElem = doc.documentElement ();
	  oldMTD = metadata (&docElem);
	}

  if (!doc.setContent (mtd2))
	{
	  qWarning ("FLManager : " + qApp->tr ("Error al cargar los meta datos en mtodo alterTable"));
	  return false;
	}
  else
	{
	  docElem = doc.documentElement ();
	  newMTD = metadata (&docElem);
	}

  if (oldMTD->name () != newMTD->name ())
	{
	  qWarning ("FLManager : " + qApp->tr ("En mtodo alterTable, los nombres de las tablas nueva y vieja difieren."));
	  return false;
	}

  if (!existsTable (oldMTD->name ()))
	{
	  qWarning ("FLManager : " + qApp->tr ("En mtodo alterTable, la tabla ") + oldMTD->name () +
				qApp->tr (" antigua de donde importar los registros no existe."));
	  return false;
	}

  FLTableMetaData::FLFieldMetaDataList * fieldList = oldMTD->fieldList ();
  FLFieldMetaData *oldField;

  QString renameOld = oldMTD->name ().left (6) + QDateTime::currentDateTime ().toString ("ddhhssz");
  QSqlQuery q;

  if (!q.exec ("ALTER TABLE " + oldMTD->name () + " RENAME TO " + renameOld + ";"))
	{
	  qWarning ("FLManager : " + qApp->tr ("En mtodo alterTable, no se ha podido renombrar la tabla antigua."));
	  return false;
	}

  if (!q.exec ("DROP INDEX " + oldMTD->name () + "_pkey;"))
	{
	  qWarning ("FLManager : " + qApp->tr ("En mtodo alterTable, no se ha podido borrar el ndice de la tabla antigua."));
	  return false;
	}

  if (!createTable (newMTD))
	return false;

  QSqlCursor oldCursor (renameOld);
  oldCursor.setMode (QSqlCursor::ReadOnly);
  QSqlCursor newCursor (newMTD->name ());
  newCursor.setMode (QSqlCursor::Insert);

  QApplication::setOverrideCursor (Qt::WaitCursor);
  oldCursor.select ();
  int totalSteps = oldCursor.size ();
  QProgressDialog progress (qApp->tr ("Reestructurando registros..."), 0, totalSteps, qApp->mainWidget (), 0, true);
  progress.setCaption (qApp->tr ("Tabla modificada"));

  int step = 0;
  QSqlRecord *oldBuffer;
  QSqlRecord *newBuffer;
  QString sequence;
  fieldList = newMTD->fieldList ();
  FLFieldMetaData *newField;

  if (!fieldList)
	{
	  qWarning ("FLManager : " + qApp->tr ("En mtodo alterTable, los nuevos metadatos no tienen campos."));
	  return false;
	}

  if (fieldList->isEmpty ())
	{
	  qWarning ("FLManager : " + qApp->tr ("En mtodo alterTable, los nuevos metadatos no tienen campos."));
	  return false;
	}

  while (oldCursor.next ())
	{
	  oldBuffer = oldCursor.editBuffer (true);
	  newBuffer = newCursor.primeInsert ();

	  for (unsigned int i = 0; i < fieldList->count (); i++)
		{
		  newField = fieldList->at (i);
		  oldField = oldMTD->field (newField->name ());
		  if (!oldField)
			continue;
		  newBuffer->setValue (newField->name (), oldBuffer->value (newField->name ()));
		}

	  newCursor.insert (false);

	  progress.setProgress (++step);
	}

  progress.setProgress (totalSteps);

  if (newMTD)
	delete newMTD;

  if (oldMTD)
	delete oldMTD;

  QApplication::restoreOverrideCursor ();

  return true;
}

bool
FLManager::alterTable (const QString & n)
{
  QDomDocument doc (n);
  QFile fi (FLDATA "/facturalux/tables/" + n + ".mtd");
  QDomElement docElem;

  if (!fi.open (IO_ReadOnly))
	{
	  fi.close ();
	  qWarning ("FLManager : " + qApp->tr ("Los meta datos para ") + n + qApp->tr (" no estn definidos"));
	  return false;
	}
  QTextStream t (&fi);
  QString mtd = t.read ();
  fi.close ();

  if (!existsTable ("flmetadata"))
	{
	  fi.setName (FLDATA "/facturalux/tables/flmetadata.mtd");
	  if (!fi.open (IO_ReadOnly))
		qWarning ("FLManager : " + qApp->tr ("Los meta datos para flmetadata no estn definidos"));
	  else
		{
		  t.setDevice (&fi);
		  if (!doc.setContent (t.read ()))
			qWarning ("FLManager : " + qApp->tr ("Error al cargar los meta datos para flmetadata"));
		  else
			{
			  docElem = doc.documentElement ();
			  if (!createTable (metadata (&docElem)))
				return false;
			}
		}
	}

  QSqlCursor c ("flmetadata");
  QSqlRecord *buffer;
  c.setFilter ("tabla='" + n + "'");
  c.select ();
  if (c.next ())
	{
	  buffer = c.editBuffer (true);
	  return alterTable (buffer->value ("xml").toString (), mtd);
	}
  else
	return false;
}

void
FLManager::metadataField (QDomElement * field, FLTableMetaData::FLFieldMetaDataList * fl, FLCompoundKey * ckl)
{
  if (!field || !fl || !ckl)
	return;

  bool ck = false;
  QString n, a;
  bool aN = true, iPK = true, c = false, v = true, ed = false, iNX = false, uNI = false, coun = false;
  int t = QVariant::Int, l = 0, pI = 4, pD = 0;
  QVariant dV = QVariant();
  
  FLFieldMetaData::FLRelationMetaDataList * relationList = 0;
  FLFieldMetaData *assocWith = 0;
  QString assocBy = QString::null;

  QDomNode no = field->firstChild ();

  while (!no.isNull ())
	{
	  QDomElement e = no.toElement ();

	  if (!e.isNull ())
		{
		  if (e.tagName () == "name")
			{
			  n = e.text ();
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "alias")
			{
			  QString s = e.text ().left (e.text ().length () - 2);

			  a = s.right (s.length () - 30);
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "null")
			{
			  aN = (e.text () == "true");
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "pk")
			{
			  iPK = (e.text () == "true");
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "type")
			{
			  if (e.text () == "int")
				t = QVariant::Int;
			  else if (e.text () == "uint")
				t = QVariant::UInt;
			  else if (e.text () == "bool")
				t = QVariant::Bool;
			  else if (e.text () == "double")
				t = QVariant::Double;
			  else if (e.text () == "time")
				t = QVariant::Time;
			  else if (e.text () == "date")
				t = QVariant::Date;
			  else if (e.text () == "pixmap")
				t = QVariant::Pixmap;
			  else if (e.text () == "string")
				t = QVariant::String;
			  else if (e.text () == "stringlist")
				t = QVariant::StringList;
			  else if (e.text () == "unlock")	// Tipo aadido por Andrs Otn Urbano
				t = FLFieldMetaData::Unlock;
			  else if (e.text () == "serial")
				t = FLFieldMetaData::Serial;
			  else if (e.text () == "sequence")	// Tipo de datos, aadida por Ral A. Betancort Santana
				t = FLFieldMetaData::Sequence;
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "length")
			{
			  l = e.text ().toInt ();
			  no = no.nextSibling ();
			  continue;
			}
        if (e.tagName () == "default")
			{
			  dV = QVariant(e.text ());
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "counter")	// Propiedad aadida por Andrs Otn Urbano
			{
			  coun = (e.text () == "true");
			  no = no.nextSibling ();
			  continue;
			}
  		  if (e.tagName () == "calculated")
			{
			  c = (e.text () == "true");
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "visible")
			{
			  v = (e.text () == "true");
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "editable")	// Propiedad definible para edicin directa
			{					// Aadido por Ral A. Betancort Santana
			  ed = (e.text () == "true");
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "partI")
			{
			  pI = e.text ().toInt ();
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "partD")
			{
			  pD = e.text ().toInt ();
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "index")
			{
			  iNX = (e.text () == "true");
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "unique")
			{
			  uNI = (e.text () == "true");
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "ck")
			{
			  ck = (e.text () == "true");
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "relation")
			{
			  if (!relationList)
				relationList = new FLFieldMetaData::FLRelationMetaDataList;
			  relationList->append (metadataRelation (&e));
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "associated")
			{
			  QDomNode noas = e.firstChild ();

			  while (!noas.isNull ())
				{
				  QDomElement eas = noas.toElement ();

				  if (!eas.isNull ())
					{
					  if (eas.tagName () == "with")
						{
						  if (fl)
							{
							  FLFieldMetaData *field;

							  for (unsigned int i = 0; i < fl->count (); i++)
								{
								  field = fl->at (i);
								  if (field->name () == eas.text ())
									{
									  assocWith = field;
									  break;
									}
								}
							}
						  noas = noas.nextSibling ();
						  continue;
						}
					  if (eas.tagName () == "by")
						{
						  assocBy = eas.text ();
						  noas = noas.nextSibling ();
						  continue;
						}
					}
				  noas = noas.nextSibling ();
				}
			  no = no.nextSibling ();
			  continue;
			}
		}
	  no = no.nextSibling ();
	}

  FLFieldMetaData *f = new FLFieldMetaData (n, qApp->translate ("MetaData", a), aN, iPK, t, l, c, v, ed, pI, pD, iNX, uNI, coun, dV);

  f->setRelationList (relationList);

  if (assocWith && !assocBy.isNull ())
	f->setAssociatedField (assocWith, assocBy);

  if (fl)
	fl->append (f);

  if (ck)
	ckl->addFieldMD (f);
}

FLRelationMetaData *
FLManager::metadataRelation (QDomElement * relation)
{
  if (!relation)
	return 0;

  QString fT, fF;
  int rC = FLRelationMetaData::RELATION_M1;
  bool dC = false, uC = false;

  QDomNode no = relation->firstChild ();

  while (!no.isNull ())
	{
	  QDomElement e = no.toElement ();

	  if (!e.isNull ())
		{
		  if (e.tagName () == "table")
			{
			  fT = e.text ();
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "field")
			{
			  fF = e.text ();
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "card")
			{
			  if (e.text () == "1M")
				{
				  rC = FLRelationMetaData::RELATION_1M;
				}
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "delC")
			{
			  dC = (e.text () == "true");
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "updC")
			{
			  uC = (e.text () == "true");
			  no = no.nextSibling ();
			  continue;
			}
		}
	  no = no.nextSibling ();
	}

  return new FLRelationMetaData (fT, fF, rC, dC, uC);
}

FLTableMetaData *
FLManager::metadata (QDomElement * mtd)
{
  if (!mtd)
	return 0;

  QString name, a, f;

  FLTableMetaData::FLFieldMetaDataList * fieldList = 0;
  FLCompoundKey *cK = 0;

  QDomNode no = mtd->firstChild ();

  while (!no.isNull ())
	{
	  QDomElement e = no.toElement ();

	  if (!e.isNull ())
		{
		  if (e.tagName () == "name")
			{
			  name = e.text ();
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "alias")
			{
			  QString s = e.text ().left (e.text ().length () - 2);

			  a = s.right (s.length () - 30);
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "form")
			{
			  f = e.text ();
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "field")
			{
			  if (!fieldList)
				fieldList = new FLTableMetaData::FLFieldMetaDataList;
			  if (!cK)
				cK = new FLCompoundKey ();
			  metadataField (&e, fieldList, cK);
			  no = no.nextSibling ();
			  continue;
			}
		}
	  no = no.nextSibling ();
	}

  FLTableMetaData *tmd = new FLTableMetaData (name, qApp->translate ("MetaData", a), f);

  tmd->setFieldList (fieldList);
  tmd->addCompoundKey (cK);
  return tmd;
}

FLTableMetaData *
FLManager::metadata (const QString & n)
{
  QDomDocument doc (n);
  QFile fi (FLDATA "/facturalux/tables/" + n + ".mtd");
  QDomElement docElem;

  if (!fi.open (IO_ReadOnly))
	{
	  fi.close ();
	  qWarning ("FLManager : " + qApp->tr ("Los meta datos para ") + n + qApp->tr (" no estn definidos"));
	  return 0;
	}
  QTextStream t (&fi);
  QString stream = t.read ();
  fi.close ();

  if (!existsTable ("flmetadata"))
	{
	  fi.setName (FLDATA "/facturalux/tables/flmetadata.mtd");
	  if (!fi.open (IO_ReadOnly))
		qWarning ("FLManager : " + qApp->tr ("Los meta datos para flmetadata no estn definidos"));
	  else
		{
		  t.setDevice (&fi);
		  if (!doc.setContent (t.read ()))
			qWarning ("FLManager : " + qApp->tr ("Error al cargar los meta datos para flmetadata"));
		  else
			{
			  docElem = doc.documentElement ();
			  if (!createTable (metadata (&docElem)))
				return 0;
			}
		}
	}

  QSqlCursor c ("flmetadata");
  QSqlRecord *buffer;
  c.setFilter ("tabla='" + n + "'");
  c.select ();
  if (!c.next ())
	{
	  buffer = c.primeInsert ();
	  buffer->setValue ("tabla", n);
	  buffer->setValue ("xml", stream);
	  buffer->setValue ("bloqueo", false);
	  c.insert ();
	}
  else
	{
	  buffer = c.primeUpdate ();
	  if (buffer->value ("bloqueo").toBool ())
		{
		  QMessageBox::warning (qApp->mainWidget (),
								qApp->tr ("Tabla bloqueada"),
								qApp->tr ("La tabla ") + n + qApp->tr (" est bloqueada, puede ser que ahora se est ajustando su\n") +
								qApp->tr ("estructura por modificaciones.\n\nIntntelo ms tarde, y si el bloqueo ") +
								qApp->tr ("persiste consulte\nal administrador del sistema.\n"), QMessageBox::Ok, 0, 0);
		  return 0;
		}

	  QString s = buffer->value ("xml").toString ();
	  if (!checkMetaData (s, stream))
		{
		  buffer->setValue ("bloqueo", true);
		  c.update ();
		  buffer = c.primeUpdate ();
		  if (alterTable (s, stream))
			buffer->setValue ("xml", stream);
		  buffer->setValue ("bloqueo", false);
		  c.update ();
		}
	}

  if (!doc.setContent (stream))
	{
	  qWarning ("FLManager : " + qApp->tr ("Error al cargar los metadatos para ") + n);
	  return 0;
	}

  docElem = doc.documentElement ();
  FLTableMetaData *ret = metadata (&docElem);
  return ret;
}

FLGroupByQuery *
FLManager::queryGroup (QDomElement * group)
{
  if (!group)
	return 0;

  QString level = QString::null, field = QString::null;

  QDomNode no = group->firstChild ();

  while (!no.isNull ())
	{
	  QDomElement e = no.toElement ();

	  if (!e.isNull ())
		{
		  if (e.tagName () == "level")
			{
			  level = e.text ();
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "field")
			{
			  field = e.text ();
			  no = no.nextSibling ();
			  continue;
			}
		}
	  no = no.nextSibling ();
	}

  return new FLGroupByQuery (level.toInt (), field);
}

FLParameterQuery *
FLManager::queryParameter (QDomElement * parameter)
{
  if (!parameter)
	return 0;

  QString name = QString::null, alias = QString::null;
  int t = QVariant::Int;

  QDomNode no = parameter->firstChild ();

  while (!no.isNull ())
	{
	  QDomElement e = no.toElement ();

	  if (!e.isNull ())
		{
		  if (e.tagName () == "name")
			{
			  name = e.text ();
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "alias")
			{
			  QString s = e.text ().left (e.text ().length () - 2);

			  alias = s.right (s.length () - 29);
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "type")
			{
			  if (e.text () == "int")
				t = QVariant::Int;
			  if (e.text () == "uint")
				t = QVariant::UInt;
			  if (e.text () == "bool")
				t = QVariant::Bool;
			  if (e.text () == "double")
				t = QVariant::Double;
			  if (e.text () == "time")
				t = QVariant::Time;
			  if (e.text () == "date")
				t = QVariant::Date;
			  if (e.text () == "pixmap")
				t = QVariant::Pixmap;
			  if (e.text () == "string")
				t = QVariant::String;
			  if (e.text () == "stringlist")
				t = QVariant::StringList;
			  if (e.text () == "serial")
				t = FLFieldMetaData::Serial;
			  if (e.text () == "sequence")
				t = FLFieldMetaData::Sequence;
			  no = no.nextSibling ();
			  continue;
			}
		}
	  no = no.nextSibling ();
	}

  return new FLParameterQuery (name, qApp->translate ("Queries", alias), t);
}

FLSqlQuery *
FLManager::query (const QString & n)
{
  QDomDocument doc (n);
  QFile fi (FLDATA "/facturalux/queries/" + n + ".qry");

  if (!fi.open (IO_ReadOnly))
	{
	  qWarning ("FLManager : " + qApp->tr ("La consulta ") + n + qApp->tr (" no est definida"));
	  return 0;
	}
  QTextStream t (&fi);

  if (!doc.setContent (t.read ()))
	{
	  fi.close ();
	  qWarning ("FLManager : " + qApp->tr ("Error al cargar la consulta ") + n);
	  return 0;
	}
  fi.close ();

  FLSqlQuery *q = new FLSqlQuery ();

  QDomElement docElem = doc.documentElement ();
  QDomNode no = docElem.firstChild ();

  while (!no.isNull ())
	{
	  QDomElement e = no.toElement ();

	  if (!e.isNull ())
		{
		  if (e.tagName () == "name")
			{
			  q->setName (e.text ());
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "select")
			{
			  q->setSelect (e.text ());
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "from")
			{
			  q->setFrom (e.text ());
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "where")
			{
			  q->setWhere (e.text ());
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "param")
			{
			  q->addParameter (queryParameter (&e));
			  no = no.nextSibling ();
			  continue;
			}
		  if (e.tagName () == "group")
			{
			  q->addGroup (queryGroup (&e));
			  no = no.nextSibling ();
			  continue;
			}
		}
	  no = no.nextSibling ();
	}

  return q;
}

FLAction *
FLManager::action (const QString & n)
{
  FLAction *a = new FLAction ();
  QDomDocument doc (n);
  QFile fi (FLDATA "/facturalux/actions.xml");

  if (!fi.open (IO_ReadOnly))
	{
	  qWarning ("FLManager : " + qApp->tr ("No existe el fichero actions.xml. Este fichero es necesario para funcionar, ejecute make install"));
	  return 0;
	}
  QTextStream t (&fi);

  if (!doc.setContent (t.read ()))
	{
	  fi.close ();
	  qWarning ("FLManager : " + qApp->tr ("Error al cargar las acciones"));
	  return 0;
	}
  fi.close ();

  QDomElement docElem = doc.documentElement ();
  QDomNode no = docElem.firstChild ();

  while (!no.isNull ())
	{
	  QDomElement e = no.toElement ();

	  if (!e.isNull ())
		{
		  if (e.tagName () == "action")
			{
			  QDomNode no2 = e.firstChild ();

			  while (!no2.isNull ())
				{
				  QDomElement e2 = no2.toElement ();

				  if (!e2.isNull ())
					{
					  if (e2.tagName () == "name")
						{
						  if (e2.text () != n)
							break;
						  a->setName (e2.text ());
						  no2 = no2.nextSibling ();
						  continue;
						}
					  if (e2.tagName () == "process")
						{
						  a->setProcess (e2.text ());
						  no2 = no2.nextSibling ();
						  continue;
						}
					  if (e2.tagName () == "masterprocess")
						{
						  a->setMasterProcess (e2.text ());
						  no2 = no2.nextSibling ();
						  continue;
						}
					  if (e2.tagName () == "table")
						{
						  a->setTable (e2.text ());
						  no2 = no2.nextSibling ();
						  continue;
						}
					  if (e2.tagName () == "form")
						{
						  a->setForm (e2.text ());
						  no2 = no2.nextSibling ();
						  continue;
						}
					  if (e2.tagName () == "caption")
						{
						  a->setCaption (e2.text ());
						  no2 = no2.nextSibling ();
						  continue;
						}
					}
				  no2 = no.nextSibling ();
				}
			  no = no.nextSibling ();
			  continue;
			}
		}
	  no = no.nextSibling ();
	}

  return a;
}

QString
FLManager::formatValueLike (FLFieldMetaData * fMD, const QVariant & v)
{
  QString res;

  if (!fMD)
	return res;

  switch (fMD->type ())
	{
	case QVariant::Bool:
	  if (v.toString ().left (1).upper () == qApp->tr ("S").left (1).upper ())
		res = "'t%'";
	  else if (v.toString ().left (1).upper () == qApp->tr ("No").left (1).upper ())
		res = "'f%'";
	  break;
	case QVariant::Date:
	  res = "'%" + FLUtil::dateDMAtoAMD (v.toString ()) + "'";
	  break;
	case QVariant::Time:
	  if (v.toTime ().isValid ())
		res = "'" + v.toTime ().toString (Qt::ISODate) + "%'";
	  else
		res = "NULL";
	  break;
	default:
	  res = "'" + v.toString () + "%'";
	}

  return res;
}

QString
FLManager::formatValueLike (int t, const QVariant & v)
{
  QString res;

  switch (t)
	{
	case QVariant::Bool:
	  if (v.toString ().left (1).upper () == qApp->tr ("S").left (1).upper ())
		res = "'t%'";
	  else if (v.toString ().left (1).upper () == qApp->tr ("No").left (1).upper ())
		res = "'f%'";
	  break;
	case QVariant::Date:
	  res = "'%" + FLUtil::dateDMAtoAMD (v.toString ()) + "'";
	  break;
	case QVariant::Time:
	  if (v.toTime ().isValid ())
		res = "'" + v.toTime ().toString (Qt::ISODate) + "%'";
	  else
		res = "NULL";
	  break;
	default:
	  res = "'" + v.toString () + "%'";
	}

  return res;
}

QString
FLManager::formatValue (FLFieldMetaData * fMD, const QVariant & v)
{
  QString res;

  if (!fMD)
	return res;

  switch (fMD->type ())
	{
	case QVariant::Bool:
	  if (v.toString ().left (1).upper () == qApp->tr ("S").left (1).upper ())
		res = "'t'";
	  else if (v.toString ().left (1).upper () == qApp->tr ("No").left (1).upper ())
		res = "'f'";
	  break;
	case QVariant::Date:
	  res = "'" + FLUtil::dateDMAtoAMD (v.toString ()) + "'";
	  break;
	case QVariant::Time:
	  if (v.toTime ().isValid ())
		res = "'" + v.toTime ().toString (Qt::ISODate) + "'";
	  else
		res = "NULL";
	  break;
	default:
	  res = "'" + v.toString () + "'";
	}

  return res;
}

QString
FLManager::formatValue (int t, const QVariant & v)
{
  QString res = QString::null;

  switch (t)
	{
	case QVariant::Bool:
	  if (v.toString ().left (1).upper () == qApp->tr ("S").left (1).upper ())
		res = "'t'";
	  else if (v.toString ().left (1).upper () == qApp->tr ("No").left (1).upper ())
		res = "'f'";
	  break;
	case QVariant::Date:
	  res = "'" + FLUtil::dateDMAtoAMD (v.toString ()) + "'";
	  break;
	case QVariant::Time:
	  if (v.toTime ().isValid ())
		res = "'" + v.toTime ().toString (Qt::ISODate) + "'";
	  else
		res = "NULL";
	  break;
	default:
	  res = "'" + v.toString () + "'";
	}

  return res;
}
