/***************************************************************************
                          FLRelationMetaData.h  -  description
                             -------------------
    begin                : Mon Jul 2 2001
    copyright            : (C) 2001,2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FLRELATIONMETADATA_H
#define FLRELATIONMETADATA_H

#include <qstring.h>

/** Mantiene la descripcion/metadatos de las relaciones de un campo.

    	Esta clase solo tiene sentido cuando es parte de un objeto FLFieldMetaData.
    	IMPORTANTE: Aunque las relaciones grficamente slo se dibujan en un sentido
    	, ya que el otro se obvia, cuando haya que definirlas con cdigo es preciso
    	indicar la relacin en ambos sentidos.
    	
 	Ejemplo: Si tenemos ALMACENES <-M----1> PAISES, tenemos que especificar
 	que ALMACENES est relacionado M1 con PAISES, y tambin que PAISES est
 	relacionado 1M con ALMAENES, en cdigo quedara as:
 	
 	- Para la tabla ALMACENES
 		\code
 		....
 		FLTableMetaData *tmd = new FLTableMetaData (n, tr ("Almacenes"), "almacenes.ui");
      	FLFieldMetaData *f;
		FLRelationMetaData *r;
	
		f = new FLFieldMetaData ("codpais", tr ("Pais"), true, false, QVariant::String, 3);
      	r = new FLRelationMetaData ("flpaises", "codpais", FLRelationMetaData::RELATION_M1);
		f->addRelationMD (r);
		tmd->addFieldMD (f);
		....
	      \endcode
	
	- Para la tabla PAISES
      	\code
      	....
      	FLTableMetaData *tmd = new FLTableMetaData (n, tr ("Paises"), "paises.ui");
		FLFieldMetaData *f;
		FLRelationMetaData *r;
	
	 	f = new FLFieldMetaData ("codpais", tr ("Cdigo"), false, true, QVariant::String, 20);
       	r = new FLRelationMetaData ("flalmacenes", "codpais", FLRelationMetaData::RELATION_1M);
	 	f->addRelationMD (r);
	 	tmd->addFieldMD (f); 	
	 	....
	      \endcode
	
    	@author Federico Albujer Zornoza
    	@version 0.4 */
class FLRelationMetaData
{
	public:

	/** Constantes de tipos de cardinalidades de una relacion */
  	enum Cardinality
  	{
		/** Uno a muchos */
    		RELATION_1M = 0,
		/** Muchos a uno */
    		RELATION_M1 = 1
  	};

	/** constructor

      	@param fT	Tabla fornea relacionada
      	@param fR	Campo forneo relacionado
      	@param rC	Cardinalidad de la relacion
      	@param dC  Borrado en cascada, slo se tiene en cuenta en cardinalidades M1
      	@param uC  Actulizaciones en cascada, slo se tiene en cuenta en cardinalidades M1 */
    	FLRelationMetaData (const QString & fT, const QString & fF, const int rC,const bool dC=false, const bool uC=false);

	/** destructor */
   	~FLRelationMetaData ();

    	/** Establece el nombre del campo relacionado.

        	@param fN	Nombre del campo relacionado. */
    	void setField(const QString& fN)
    	{
        	field_=fN.lower();
    	}

    	/** Obtiene en el nombre del campo de la relacion.

        	@return	Devuelve el nombre del campo relacionado*/
    	const QString& field() const
    	{
        	return field_;
    	}

	/** Obtiene el nombre de la tabla fornea.

      	@return	Devuelve el nombre de la tabla de la base de datos con la que se est relacionada */
  	const QString & foreignTable () const
  	{
    		return foreignTable_;
  	}

	/** Obtiene el nombre de la campo forneo.

      	@return	Devuelve el nombre del campo de la tabla fornea con la que est relacionada */
  	const QString & foreignField () const
  	{
    		return foreignField_;
  	}

	/** Obtiene la cardinalidad de la relacion.

      	@return	Devuelve la cardinalidad de la relacion, mirando desde la tabla donde se
				define este objeto hacia la fornea */
  	const int cardinality () const
  	{
    		return cardinality_;
  	}

  	/** Obtiene si la relacin implica borrados en cascada, slo se tiene en cuenta en cardinalidades M1.

      	@return	Devuelve TRUE si la relacion implica borrados en cascada, FALSE en caso contrario */
  	const bool deleteCascade () const
  	{
    		return (deleteCascade_ && cardinality_==RELATION_M1);
  	}
  	
  	/** Obtiene si la relacin implica modificaciones en cascada, slo se tiene en cuenta en cardinalidades M1.

      	@return	Devuelve TRUE si la relacion implica modificaciones en cascada, FALSE en caso contrario */
  	const bool updateCascade () const
  	{
    		return (updateCascade_ && cardinality_==RELATION_M1);
  	}
  	
	private:

	/** Nombre del campo a relacionar */
	QString field_;
	
	/** Nombre de la tabla fornea a relacionar */
	QString foreignTable_;

	/** Nombre del campo forneo relacionado */
	QString foreignField_;

	/** Cardinalidad de la relacin */
	int cardinality_;
	
	/** Indica si los borrados sern en cascada, en relaciones M1 */
	bool deleteCascade_;
	
	/** Indica si las modificaciones sern en cascada, en relaciones M1 */
	bool updateCascade_;
};

#endif
