/***************************************************************************
                          FLReportEngine.h  -  description
                             -------------------
    begin                : jue jun 27 2002
    copyright            : (C) 2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FLREPORTENGINE_H
#define FLREPORTENGINE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qdom.h>
#include <qstringlist.h>
#include <qfile.h>

#include "../kugar/mreportengine.h"

class FLSqlCursor;
class FLSqlQuery;

/** Motor de generacin de informes. Hereda de MReportEngine.

    Extiende la funcionalidad de MReportEngine, para crear el origen
    de datos (una estructura XML) de Kugar a partir de una tabla o una consulta.
    El origen de una tabla o una consulta son objetos del tipo FLSqlCursor para tablas
    y FLSqlQuery para consultas. El formato de los informes se sigue tomando de un
    fichero XML segn el formato prefijado por Kugar.

    @author Federico Albujer Zornoza
    @version 0.4*/
class FLReportEngine : public MReportEngine
{
    Q_OBJECT

    public:
	
    /** constructor */
    FLReportEngine();

    /** desctructor */
    ~FLReportEngine();

    /** Establece los datos del informe a partir de una consulta

         @param q   Objeto FLSqlQuery con la consulta de la que se toman los datos
         @return    TRUE si todo ha ido bien */
    bool setReportData( FLSqlQuery * q );

    /** Establece los datos del informe a partir de una tabla

         @param t   Objeto FLSqlCursor con  la tabla de la que se toman los datos
         @return    TRUE si todo ha ido bien*/
    bool setReportData( FLSqlCursor * t );

    /** Establece la plantilla para el informe.

        El nombre de la plantilla corresponde con el nombre del fichero con extesin ".kut".

        @param  t   Nombre dela plantilla
        @return    TRUE si todo ha ido bien*/
    bool setFLReportTemplate( const QString & t);

    private:

    /** Aade los datos del registro activo de la consulta dada al origen de datos del informe.

        Todos los campos del registro son agregados a la estructura XML con los datos de origen
        del informe, en un elemento tipo "Row", indicando a que nivel pertenece el registro segn
        el parmetro l. La consulta debe pasarse en un estado vlido, es decir, con un registro activo.

        @param  q Consulta de la que tomar su registro activo para agregar datos al informe
        @param  l   Nivel al  que pertenece el registro */
    void addRowToReportData( FLSqlQuery * q,  const int l);

    /** Agrupa los registros de la consulta recursivamente segn el nivel de agrupamiento, y los
        va sacando al objeo raiz XML, en el orden adecuado.

        La consulta debe pasarse en un estado vlido, es decir, con un registro activo */
    void groupBy(int level, int levelMax, FLSqlQuery *q, QString vA);

    /** Elemento raz XML con los datos del informe */
    QDomElement  root_;
};

#endif
