/***************************************************************************
                          FLUtil.h  -  description
                             -------------------
    begin                : Sun Jan 27 2002
    copyright            : (C) 2002 by Federico Albujer Zornoza,
                                Eloy Ordua Gonzlez, Andrs Otn Urbano
    email                : mail@infosial.com
 ***************************************************************************/
/***************************************************************************
                          enletra.h  -  fichero en C original, con rutinas utlizadas en esta
                                             clase.
                             -------------------
    begin                : Mon Jan 21 2002
    copyright            : (C) 2002 by Eloy Ordua Gonzlez
    email                : eloy.o@colvet.es

Funciones contenidas en el fichero original 'enletra.h', que corresponden con los
mtodos de FLUtil del mismo nombre:
	unidades
	decenas
	centenas
	unidadesmillar
	decenasmillar
	centenasmillar
	enletra-------------->  Esta es la que se llama para poner los numeros en letra
                                        con la sintaxis siguiente enletra( Numero, buffer)

                                        Numero es el numero que queremos nombrar
					     buffer es un puntero a char para dejar el resultado

					     En este buffer no se comprueba el desbordamiento por lo que
					     si no es lo suficientemente grande originara un error.


Para poder nombrar los decimales se ha de hacer de la forma siguiente
se llama la funcion en letra con el numero a convertir (los decimales los quita la funcion
por estar moldeada a datos de tipo long
se recoge el buffer y se le aade el nombre de la moneda y el texto  " y " si hay decimales
si tiene decimales se vuelve a llamar solo con los decimales y se aade " centimos "
se aade el nombre de la moneda " Euros "
Ej: queremos nombrar 125.36

char *Euros [300];
char *Centimos[50];
enletra (125.36, Euros);           // en Euros habra: "ciento venticinco"
strcat (Euros, " Euros ");         // en Euros habra: "ciento venticinco Euros "
if (Haydecimales ){
	strcat ( Euros, " y ")             // en Euros habra: "ciento venticinco Euros y "
	enletra (36, Centimos);            // en centimos habra: "treinta y seis"
	strcat ( Euros, Centimos);         // en Euros habra: "ciento venticinco Euros y treinta y seis"
	strcat ( Euros, "centimos")        // finalmente quedara "ciento venticinco Euros y treinta y seis centimos"
}
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FLUTIL_H
#define FLUTIL_H

#include <qstring.h>
#include <qstringlist.h>
#include <qregexp.h>
#include <qapplication.h>

/** Clase con mtodos, herramientas y utiles necesarios para ciertas operaciones.

	Es esta clase se encontrarn mtodos genricos que
	realizan operaciones muy especficas pero que
	son necesarios para ciertos procesos habituales
	en las distintas tareas a desempear en la gestin
	empresarial.

  	@author Federico Albujer Zornoza, Eloy Ordua Gonlez, Andrs Otn Urbano
  	@version 0.4 */
class FLUtil
{
    public:

    /** constructor */
    FLUtil();
	
    /** destructor */
    ~FLUtil();
	
    /** Obtiene la parte entera de un nmero.
	
        Dado un nmero devuelve la parte entera correspondiente, es decir,
        cifras en la parte izquierda de la coma decimal.

        @param n Nmero del que obtener la parte entera. Debe ser positivo.
        @return La parte entera del nmero, que puede ser cero. */
    static long partInteger( double n );
	
    /** Obtiene la parte decimal de un nmero.

        Dado un nmero devuelve la parte decimal correspondiente, es decir,
        cifras en la parte derecha de la coma decimal.

        @param n Nmero del que obtener la parte decimal. Debe ser positivo.
        @return La parte decimal del nmero, que puede ser cero. */
    static long partDecimal( double n );

    /** Enunciado de las unidades de un nmero.

        @param  n   Nmero a tratar. Debe ser positivo. */
    static QString unidades (long n);

    /** Enunciado de las centenas de millar de un nmero.

        @param  n   Nmero a tratar. Debe ser positivo. */
    static QString centenamillar (long n);

    /** Enunciado de las decenas de un nmero.

        @param  n   Nmero a tratar. Debe ser positivo. */
    static QString decenas (long n);

    /** Enunciado de las centenas de un nmero.

        @param  n   Nmero a tratar. Debe ser positivo. */
    static QString centenas (long n);

    /** Enunciado de las unidades de millar de un nmero.

        @param  n   Nmero a tratar. Debe ser positivo. */
    static QString unidadesmillar (long n);

    /** Enunciado de las decenas de millar de un nmero.

        @param  n   Nmero a tratar. Debe ser positivo. */
    static QString decenasmillar (long n);

    /** Obtiene la expresin en texto de como se enuncia un nmero, en castellano.

        Dado un nmero entero, devuelve su expresin en texto de como se
        enuncia de forma hablada; por ejemplo dado el nmero 130,
        devolver la cadena de texto "ciento treinta".

        @param n Nmero a transladar a su forma hablada. Debe ser positivo.
        @return Cadena de texto con su expresin hablada. */
    static QString enLetra( long n );

    /** Obtiene la expresin en texto de como se enuncia una cantida monetaria, en castellano
          y en Euros.

        Dado un nmero doble, devuelve su expresin en texto de como se
        enuncia de forma hablada en euros; por ejemplo dado el nmero 130.25,
        devolver la cadena de texto "ciento treinta eruos con veinticinco cntimos".

        @param n Nmero a transladar a su forma hablada. Debe ser positivo.
        @return Cadena de texto con su expresin hablada. */
    static QString enLetraMonedaEuro( double n );

    /** Obtiene la letra asociada al nmero del D.N.I. espaol.

        @param  n  Numero de D.N.I
        @return Caracter asociado al nemro de D.N.I */
    static QChar letraDni (long n);

    /** Obtiene el nmero del digito de control, para cuentas bancarias.

        Los nmeros de las cuentas corrientes se organizan de la forma siguiente:

        4 Digitos----->Cdigo del banco  (ej. 0136 Banco Arabe espaol)
        4 Digitos----->Cdigo de la oficina
        1 Digito de control------>de los 8 primeros digitos
        1 Digito de control------>del nmero de cuenta (de los 10 ultimos digitos)
        10 Digitos del nmero de la cuenta

        Para comprobar el numero de cuenta se pasa primero los 8 primeros digitos
        obteniendo asi el primer digito de control, despus se pasan los 10 digitos
        del nmero de la cuenta obteniendo el segundo digito de control.

        @param  n  Nmero del que se debe obtener el dgito de control
        @return Caracter con el dgito de control asociado al nmero dado */
    static QChar calcularDC (const QString & n);

    /** Convierte fechas del tipo DD-MM-AAAA, DD/MM/AAAA o
        DDMMAAAA al tipo AAAA-MM-DD.

        @param  f Cadena de texto con la fecha a transformar
        @return Cadena de texto con la fecha transformada */
    static QString dateDMAtoAMD( const QString & f );

    /** Formatea una cadena de texto ponindole separadores de miles.

            La cadena que se pasa se supone que un nmero, convirtiendola
            con QString::toDouble(), si la cadena no es nmero el resultado es imprevisible.
            El separador de miles es la coma y el de decimale el punto.

            @param s Cadena de texto a la que se le quieren poder separadores de miles.
            @return Devuelve la cadena formateada con los separadores de miles */
    static QString formatoMiles(const QString & s);

    /** Devuelve si el numero de tarjeta de Credito es valido

          El parametro que se pasa es la cadena de texto que contiene el numero de tarjeta.
          @param num Cadena de texto con el numero de tarjeta.
          @return Devuelve verdadero si el numero de tarjeta es valido. */
    bool numCreditCard(QString num);
};

#endif
