/*
 * rtpsession.h - Headers for RTP plugin session implementation
 *
 * Farsight RTP/AVP/SAVP/AVPF Module
 * Copyright (C) 2005,2006 Collabora Ltd.
 * Copyright (C) 2005,2006 Nokia Corporation
 *   @author Rob Taylor <rob.taylor@collabora.co.uk>
 *   @author Philippe Kalaf <philippe.kalaf@collabora.co.uk>
 * Copyright (C) 2005 INdT 
 *   @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __FARSIGHT_RTP_SESSION_H__
#define __FARSIGHT_RTP_SESSION_H__

#include "farsight-session.h"

G_BEGIN_DECLS

/* TYPE MACROS */
#define FARSIGHT_TYPE_RTP_SESSION \
  (farsight_rtp_session_get_type())
#define FARSIGHT_RTP_SESSION(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), FARSIGHT_TYPE_RTP_SESSION, FarsightRTPSession))
#define FARSIGHT_RTP_SESSION_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), FARSIGHT_TYPE_RTP_SESSION, FarsightRTPSessionClass))
#define FARSIGHT_IS_RTP_SESSION(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), FARSIGHT_TYPE_RTP_SESSION))
#define FARSIGHT_IS_RTP_SESSION_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), FARSIGHT_TYPE_RTP_SESSION))
#define FARSIGHT_RTP_SESSION_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), FARSIGHT_TYPE_RTP_SESSION, FarsightRTPSessionClass))

typedef struct _FarsightRTPSessionClass FarsightRTPSessionClass;

struct _FarsightRTPSessionClass
{
  FarsightSessionClass parent_class;
};

struct _FarsightRTPSession
{
  FarsightSession parent;
};

GType farsight_rtp_session_get_type (void);

G_END_DECLS

#endif
