/*
 * options.h : fbgetty options 
 * Part of fbgetty 
 * Copyright (C) 1999 2000 2001 Yann Droneaud <ydroneaud@meuh.eu.org>. 
 *
 * fbgetty is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * fbgetty is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 */

#ifndef _FBGETTY_OPTIONS_H_
#define _FBGETTY_OPTIONS_H_

/*
 * default values for some options
 * could be overriden by config.h (with configure script options)
 */

#ifndef LOGIN_PROGRAM
# define LOGIN_PROGRAM "/bin/login"
#endif

#ifndef LOGIN_PROMPT
# ifdef FBGETTY_UNSTABLE
#  define LOGIN_PROMPT "%n login (" PACKAGE_VERSION "): "
# else /* !FBGETTY_UNSTABLE */
#  define LOGIN_PROMPT "%n login: "
# endif /* !FBGETTY_UNSTABLE */
#endif /* LOGIN_PROMPT */

#ifndef ISSUE_FILE
# define ISSUE_FILE "/etc/issue"
#endif

#ifndef ISSUE_REFRESH
# define ISSUE_REFRESH TRUE /* refresh */
#endif

#ifndef LOGIN_TIMEOUT
# define LOGIN_TIMEOUT 0 /* No time out */
#endif

#ifndef TTY_DEVICE
# define TTY_DEVICE NULL
#endif

#ifdef USE_FRAME_BUFFER
# ifndef FB_DEVICE
#  define FB_DEVICE NULL
# endif
#endif /* USE_FRAME_BUFFER */

/* get the definition of the fgoption structure */
#include <fbgetty/generated/options.h>

/* all features are centralized in fgoptions */
extern fbgetty_options_t *fgoptions;

/* parse the command line, then the environment, 
   merge all type of option in the fgoptions variable (see above) */
void parse_options(int argc, char *argv[]);

/* free an fgoptions structure */
fbgetty_options_t *
fgoptions_free(fbgetty_options_t *op);

/* create (allocate) a new fbgetty_options_t variable
 * This function also call fgoptions_init
 */
fbgetty_options_t *
fgoptions_create(void);

/*
 * set all fields of the structure to unset (NULL or -1 depending of the type) 
 */
int 
fgoptions_init(fbgetty_options_t *);

#ifndef __GLIBC__
extern char *program_invocation_short_name;
extern char *program_invocation_name;
#endif

#endif /* _FBGETTY_OPTIONS_H_ */
