# FIAIF is an Intelligent firewall, version: $Revision: 1.191 $
#
# RPM specification file.
#
# Author:	Anders Fugmann <afu@fugmann.dhs.org>
# 
# FIAIF is an Intelligent firewall
# Copyright (C) 2002-2003 Anders Peter Fugmann
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# Debian rpm hack.
%define          _sysconfdir /etc
# Mandrake rpm hack
%define		_unpackaged_files_terminate_build 0

Summary:	Fiaif is an Intelligent Firewall for iptables based Linux systems
Summary(pl):	Fiaif - inteligentny firewall bazuj?cy na iptables
Name:		fiaif
Version:	1.20.1
Release:	0.1
License:	GPL
Group:		Networking/Utilities
Source0:	http://www.fiaif.net/dist/%{name}_%{version}.tar.gz
URL:		http://www.fiaif.net/
Packager:       Anders Fugmann <afu@fugmann.dhs.org>
BuildArch:	noarch
Requires:	iptables >= 1.2.6a, 
Requires:       bash >= 2.04
Requires:       sed
Requires:       grep
Requires:       textutils
Requires:       sh-utils
Requires:       bind-utils
Requires:       mktemp
Requires:       crontabs
Requires:       /bin/awk
Requires(post,preun):	/sbin/chkconfig
Prereq:         /sbin/chkconfig
#PreReq:         rpm-helper
Conflicts:	ipmasq, knetfilter, firewall-easy, shorewall, firewall-init
BuildRoot:	%{_tmppath}/%{name}-%{version}-root-%(id -u -n)

%description
The Goal of  FIAIF is to provide a  highly customizable script
for setting up an iptables based firewall.

Unlike  many  other scripts,  FIAIF  can  be truly  customized
allowing multiple  interfaces (or  rather zones). There  is no
limit  on  the number  of  zones.  All configuration  is  done
through configuration files. No  need to understand the script
behind it all.

The script makes heavy use  of state-full firewalling, and all
RELATED and ESTABLISHED packets are accepted on all chains. If
you which  to block  something out,  do not  accept it  in the
first place.

The script is written in BASH.  Though this is not the optimal
program to use, it means that you do not need to install extra
interpreters  on your  firewall.  This allows  you  to have  a
minimalistic installation on your firewall.

Install this package if your machine is ever on the internet.

%description -l pl
Celem FIAIF jest  udostpnienie wysoce  dostosowawczego skryptu
ustawiania regu ciany ogniowej opartej na netfiltrze.

W przeciwiestwie do innych skryptw, FIAIF umoliwia ustawianie 
regu na  wielu interfejsach,  a raczej strefach.  Nie ma limitu 
stref.  Ca  konfiguracj  przeprowadza  si  za pomoc  plikw 
konfiguracyjnych.  Nie ma potrzeby  rozumienia stojcego za nimi 
skryptu.

Skrypt mocno uywa  zabezpiecze typu  stateful,  przepuszczajc
wszystkie pakiety RELATED i ESTABLISHED na wszystkich acuchach.
eby co zablokowa, wystarczy nie akceptowa tego na pocztku.

Skrypt  napisany  jest w  bashu,   co  pozwala  na  zmniejszenie 
koniecznej instalacji na cianie ogniowej.

%prep
%setup -q -n %{name}-%{version}
rm -Rf $RPM_BUILD_ROOT
%build

%install
%{__make} install DESTDIR=$RPM_BUILD_ROOT
%{__make} install-config DESTDIR=$RPM_BUILD_ROOT
[ -f fiaif.ps ] && gzip -9 fiaif.ps
install -d $RPM_BUILD_ROOT{%{_sbindir},%{_mandir}/man8} \
	$RPM_BUILD_ROOT%{_sysconfdir}/rc.d/init.d
install prog/fiaif $RPM_BUILD_ROOT%{_sysconfdir}/rc.d/init.d/fiaif

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/chkconfig --add fiaif 
# Check is fiaif has been restarted yet.
if [ -f  %{_var}/lock/subsys/fiaif ]; then
    echo "Before restarting FIAIF, please go through the configuration"
    echo "and see if any updates are nessesary."
else
    echo "Configure fiaif and remove the line 'DONT_START=1'"
    echo "from /etc/fiaif/fiaif.conf, then execute"
    echo "'/etc/rc.d/init.d/fiaif start' to start fiaif."
fi

%preun
# Test that this is truly an remove.
if [ "$1" = "0" ]; then 
    if [ -f  %{_var}/lock/subsys/fiaif ]; then  
	/etc/rc.d/init.d/fiaif stop >&2  
    fi  
    /sbin/chkconfig --del fiaif  
fi

%files
%defattr(644,root,root,755)
%doc GPL.txt 
%doc changelog 
%doc doc/faq.txt 
%doc doc/DHCP.txt
%doc doc/upgrade.txt 
%doc doc/reporting_bugs.txt 
%doc /usr/share/doc/fiaif/DHCP.txt
%doc /usr/share/doc/fiaif/changelog
%doc /usr/share/doc/fiaif/changelog.gz
%doc /usr/share/doc/fiaif/copyright
%doc /usr/share/doc/fiaif/fiaif.ps.gz
%doc /usr/share/doc/fiaif/reporting_bugs.txt
%doc /usr/share/doc/fiaif/upgrade.txt

%dir %attr(0700,root,root) %{_sysconfdir}/fiaif/
%dir %attr(0700,root,root) %{_var}/lib/fiaif/

%config(noreplace) %verify(not size mtime md5) %attr(0600,root,root) %{_sysconfdir}/fiaif/zone.dmz
%config(noreplace) %verify(not size mtime md5) %attr(0600,root,root) %{_sysconfdir}/fiaif/zone.ext
%config(noreplace) %verify(not size mtime md5) %attr(0600,root,root) %{_sysconfdir}/fiaif/zone.int
%config(noreplace) %verify(not size mtime md5) %attr(0600,root,root) %{_sysconfdir}/fiaif/fiaif.conf
%config(noreplace) %verify(not size mtime md5) %attr(0600,root,root) %{_sysconfdir}/fiaif/reserved_networks
%config(noreplace) %verify(not size mtime md5) %attr(0600,root,root) %{_sysconfdir}/fiaif/private_networks
%config(noreplace) %verify(not size mtime md5) %attr(0600,root,root) %{_sysconfdir}/fiaif/aliases
%config(noreplace) %verify(not size mtime md5) %attr(0600,root,root) %{_sysconfdir}/fiaif/type_of_services
%config(noreplace) %verify(not size mtime md5) %attr(0644,root,root) %{_sysconfdir}/cron.daily/fiaif

%attr(0755,root,root) %{_sysconfdir}/rc.d/init.d/fiaif
%attr(0755,root,root) %{_sysconfdir}/init.d/fiaif
%attr(0755,root,root) %{_sbindir}/fiaif-scan
%attr(0755,root,root) %{_sbindir}/fiaif-update
%attr(0755,root,root) %{_sbindir}/fiaif-getdev

%dir %{_datadir}/fiaif
%{_datadir}/fiaif/traffic-shaping.sh
%{_datadir}/fiaif/functions.sh
%{_datadir}/fiaif/zones.sh
%{_datadir}/fiaif/iptables.sh
%{_datadir}/fiaif/proc-check.sh
%{_datadir}/fiaif/sanity_check.sh
%{_datadir}/fiaif/constants.sh
%{_datadir}/fiaif/cleanup_rules.sh
%{_datadir}/fiaif/aliases.sh
%{_datadir}/fiaif/zone_rules.awk
%{_datadir}/fiaif/fiaif_rules.awk
%{_datadir}/fiaif/syntax.awk
%{_datadir}/fiaif/cleanup_rules.awk
%{_datadir}/fiaif/VERSION

%{_mandir}/man8/fiaif.8*
%{_mandir}/man5/zone.conf.5*
%{_mandir}/man5/fiaif.conf.5*
%{_mandir}/man8/fiaif-scan.8*
%{_mandir}/man8/fiaif-update.8*
%{_mandir}/man8/fiaif-getdev.8*
%define date	%(echo `LC_ALL="C" date +"%a %b %d %Y"`)

%changelog
* Fri Dec 16 2005 Anders Fugmann <afu@fugmann.net>
- new upstream version 1.20.1
* Sun Dec 04 2005 Anders Fugmann <afu@fugmann.net>
- new upstream version 1.20.0
* Sun May 02 2004 Anders Fugmann <afu@fugmann.net>
- new upstream version 1.19.3
* Wed Feb 25 2004 Anders Fugmann <afu@fugmann.net>
- new upstream version 1.19.2
* Mon Feb 23 2004 Anders Fugmann <afu@fugmann.net>
- new upstream version 1.19.1
* Sun Feb 22 2004 Anders Fugmann <afu@fugmann.net>
- new upstream version 1.19.0
* Sat Jan 03 2004 Anders Fugmann <afu@fugmann.net>
- new upstream version 1.18.0
* Wed Oct 01 2003 Anders Fugmann <afu@fugmann.dhs.org>
- new upstream version 1.17.2
* Sun Sep 28 2003 Anders Fugmann <afu@fugmann.dhs.org>
- new upstream version 1.17.1
* Sun Sep 28 2003 Anders Fugmann <afu@fugmann.dhs.org>
- new upstream version 1.17.0
* Sun Aug 31 2003 Anders Fugmann <afu@fugmann.dhs.org>
- new upstream version 1.16.1
* Mon Aug 11 2003 Anders Fugmann <afu@fugmann.dhs.org>
- new upstream version 1.16.0
* Mon May 26 2003 Anders Fugmann <afu@fugmann.dhs.org>
- new upstream version 1.15.1
* Sun May 25 2003 Anders Fugmann <afu@fugmann.dhs.org>
- new upstream version 1.15.0
* Tue Apr 22 2003 Anders Fugmann <afu@fugmann.dhs.org>
- new upstream version 1.14.0
* Wed Apr 09 2003 Anders Fugmann <afu@fugmann.dhs.org>
- new upstream version 1.13.3
* Wed Apr 09 2003 Anders Fugmann <afu@fugmann.dhs.org>
- new upstream version 1.13.2
* Tue Apr 08 2003 Anders Fugmann <afu@fugmann.dhs.org>
- new upstream version 1.13.1
* Mon Apr 07 2003 Anders Fugmann <afu@fugmann.dhs.org>
- new upstream version 1.13.0
* Sun Apr 06 2003 Anders Fugmann <afu@fugmann.dhs.org>
- new upstream version 1.12.2
* Sun Mar 16 2003 Anders Fugmann <anders@fugmann.dhs.org>
- add aliases.sh
* Sat Mar 08 2003 Anders Fugmann <anders@fugmann.dhs.org>
- new upstream version 1.12.1
* Sat Mar 01 2003 Anders Fugmann <anders@fugmann.dhs.org>
- new upstream version 1.12.0
* Fri Feb 28 2003 Anders Fugmann <anders@fugmann.dhs.org>
- new upstream version 1.11.0
* Sat Feb 22 2003 Anders Fugmann <anders@fugmann.dhs.org>
- new upstream version 1.10.0
* Sat Feb 22 2003 Anders Fugmann <anders@fugmann.dhs.org>
- new upstream version 1.9.2
* Thu Feb 20 2003 Anders Fugmann <anders@fugmann.dhs.org>
- new upstream version 1.9.1
* Mon Feb 17 2003 Anders Fugmann <anders@fugmann.dhs.org>
- new upstream version 1.9.0
* Thu Feb 13 2003 Anders Fugmann <anders@fugmann.dhs.org>
- new upstream version 1.8.2
* Thu Feb 13 2003 Anders Fugmann <anders@fugmann.dhs.org>
- new upstream version 1.8.1
* Tue Feb 11 2003 Anders Fugmann <anders@fugmann.dhs.org>
- new upstream version 1.8.0
* Tue Feb 11 2003 Anders Fugmann <anders@fugmann.dhs.org>
- new upstream version 1.7.4
* Wed Jan 29 2003 Anders Fugmann <anders@fugmann.dhs.org>
- new upstream version 1.7.3
* Wed Jan 29 2003 Anders Fugmann <anders@fugmann.dhs.org>
- new upstream version 1.7.2
* Wed Jan 29 2003 Anders Fugmann <anders@fugmann.dhs.org>
- new upstream version 1.7.1
- Do not require dia when building
* Wed Jan 29 2003 Anders Fugmann <anders@fugmann.dhs.org>
- new upstream version 1.7.0
* Fri Jan 24 2003 Anders Fugmann <anders@fugmann.dhs.org>
- new upstream version 1.6.4
* Thu Jan 23 2003 Anders Fugmann <anders@fugmann.dhs.org>
- New build scripts
* Sat Jan 4 2003 Anders Fugmann <anders@fugmann.dhs.org>
- Dont use _preun_service. It breaks things on RH 8.0
* Mon Dec 30 2002 Anders Fugmann <anders@fugmann.dhs.org>
- Work better with mandrake (Thanks to Rmi Denis-Courmont)
* Thu Oct 24 2002 Anders Fugmann <anders@fugmann.dhs.org>
- Updated spec file based on changes from Sergiusz Pawlowicz.
* Sun Sep 08 2002 Anders Fugmann <anders@fugmann.dhs.org>
- Remove /var/state/fiaif/iptables en upgrading.
* Wed Jun 05 2002 Anders Fugmann <anders@fugmann.dhs.org>
- RPM done.
- See /usr/share/doc/fiaif/changelog for more information

