<?php
/*
    FibuSQL 0.4.1  -  (c) 2003 Martin Pitt <martin@piware.de>

    This software is protected by the GNU General Public License (see
    file COPYING).

    Backend module:
    o include common language file
    o open database
    o error handling functions
    o common HTTP/HTML functions
*/

include_once 'langinc.inc';

# If $result is a database error then print $msg error.
# use this function after the inclusion of pagehead-html.inc (when direct
# output is possible)
function check_res( $result, $msg )
{
    global $LANG_error, $LANG_dbmsg;

    if( DB::isError( $result ) ) {
	echo "<p class=\"error\">$LANG_error: $msg</p><p class=\"error\">$LANG_dbmsg: "
	    . $result->getMessage() . "</p></body></html>";
	exit;
    }
}

# If $result is a database error then set up $msg error.
# use this function before the inclusion of pagehead-html.inc; display
# of error is postponed until after the inclusion
function check_res_delay( $result, $msg )
{
    global $db_error, $db_msg;

    if( DB::isError( $result ) ) {
	if( !$db_error ) {
	    $db_error = $msg;
	    $db_msg = $result->getMessage();
	}
	return 1;
    }

    return null;
}

# checks if $HTTP_GET_VARS[$param] is an integer value and if so, returns it;
# otherwise returns null and clears HTTP_GET_VARS (thus cancelling any
# operations) unless $dontclear = 1.
# if $failtxt is given, the global variable $fail will be set to this value on
# failure.
function get_http_int( $param, $dontclear = 0, $failtxt = null )
{
    global $HTTP_GET_VARS;
    global $fail;

    if( is_numeric( $HTTP_GET_VARS[$param] ) )
	return intval( $HTTP_GET_VARS[$param] );
    else {
	if( !$dontclear ) $HTTP_GET_VARS = null;
	if( $failtxt ) $fail = $failtxt;
	return null;
    }
}

# analogous to get_http_int for float values
function get_http_float( $param, $dontclear = 0, $failtxt = null )
{
    global $HTTP_GET_VARS;
    global $fail;

    if( is_numeric( $HTTP_GET_VARS[$param] ) )
	return doubleval( $HTTP_GET_VARS[$param] );
    else {
	if( !$dontclear ) $HTTP_GET_VARS = null;
	if( $failtxt ) $fail = $failtxt;
	return null;
    }
}

# analogous to get_http_float for formatted float values
function get_http_formatfloat( $param, $dontclear = 0, $failtxt = null )
{
    global $HTTP_GET_VARS;
    global $fail;

    $x = parseval( $HTTP_GET_VARS[$param] );
    if( $x )
	return $x;
    else {
	if( !$dontclear ) $HTTP_GET_VARS = null;
	if( $failtxt ) $fail = $failtxt;
	return null;
    }
}
# quote special HTML characters
function htmlq( $s )
{
    return htmlspecialchars( $s, ENT_QUOTES, 'UTF-8' );
}

# return a currency-formatted value $v
function formatval( $v )
{
    global $HTTP_SESSION_VARS;
    if( !$HTTP_SESSION_VARS['thousandsep'] )
	$HTTP_SESSION_VARS['thousandsep'] = '';
    if( !$HTTP_SESSION_VARS['decimalsep'] )
	$HTTP_SESSION_VARS['decimalsep'] = '.';
    return number_format( $v, 2, $HTTP_SESSION_VARS['decimalsep'], $HTTP_SESSION_VARS['thousandsep'] );
}

# parse a currency-formatted value $v to a float; return null if invalid
function parseval( $v )
{
    global $HTTP_SESSION_VARS;
    if( !$HTTP_SESSION_VARS['thousandsep'] )
	$HTTP_SESSION_VARS['thousandsep'] = '';
    if( !$HTTP_SESSION_VARS['decimalsep'] )
	$HTTP_SESSION_VARS['decimalsep'] = '.';

    $x = str_replace( $HTTP_SESSION_VARS['thousandsep'], '', $v );
    $x = str_replace( $HTTP_SESSION_VARS['decimalsep'], '.', $x );
    if( is_numeric( $x ) )
	return doubleval( $x );
    else
	return null;
}

require_once 'DB.php';

error_reporting( 5 );
$db = DB::connect( $HTTP_SESSION_VARS['dbspec'], true );
?>
