#ifndef GUIUTILS_H
#define GUIUTILS_H

#ifndef GNOME_H
#include <gnome.h>
#endif

#ifndef SERVER_H
#include "server.h"
#endif

#ifndef USERLIST_H
#include "userlist.h"
#endif

#ifndef USERWIDGET_H
#include "userwidget.h"
#endif

/* Insert an item with a stock icon */
#define HOTLINE_UIITEM_STOCK(label, tooltip, callback, stock_id, accKey, accMod) \
        { GNOME_APP_UI_ITEM, label, tooltip, (gpointer)callback, NULL, NULL, \
                GNOME_APP_PIXMAP_STOCK, stock_id, accKey, accMod, NULL }


typedef struct {
  Connection *c;
  GnomeUIInfo *toolbar;
  GtkWidget *dock;
  GtkWidget *main;
  GtkWidget *label;
  char *config_path;
} NotebookPage;

GnomeUIInfo *gutils_dup_gnomeuiinfo_with_data(GnomeUIInfo *orig,
					      gpointer data);
void guiutils_raise_window(GtkWindow *w);
void gutils_clist_on_dblclick(GtkWidget *w,
			      void (*cb)(GtkWidget *,gint row,gpointer data),
			      gpointer data);

void guitils_text_add_popup_clear(GtkText *t);

void gutils_clist_add_popup_menu(GtkWidget *w,
				 GnomeUIInfo *info,
				 gpointer data);
void clist_popup_set_sensitive(GtkWidget *w,int pos,gboolean state);

NotebookPage *gutils_nbpage_new(char *config_path, GnomeUIInfo *toolbar,
				Connection *c,char *name,char *icon,
				gpointer toolbar_data);
void gutils_nbpage_destroy(NotebookPage *);
void gutils_nbpage_set_main(NotebookPage *,GtkWidget *);
void gutils_nbpage_set_main_with_userlist(NotebookPage *p,
					  GtkWidget *w,
					  UserWidget **uw);
void gutils_nbpage_to_front(NotebookPage *);
void gutils_nbpage_toolbar_set_sensitive(NotebookPage *,int,gboolean);
void guiutils_nbpage_highlight(NotebookPage *p);

void guiutils_nbpage_change_hook(GtkNotebook *notebook,
				 GtkNotebookPage *page,
				 gint page_num,
				 gpointer user_data);

#endif
