#ifndef _CDLGSRC_HH
#define _CDLGSRC_HH

#include <gtkmm.h>
#include <glibmm/ustring.h>
#include <config.h>
#include "dispatcher.h"
#include "CSync.h"

#ifdef WITHGCONF
#include "CGConf.h"
#endif

using Glib::ustring;


class CDlgSrc: public Gtk::Window, public CSync
{
private:
	Dispatcher2 <const char*, int> m_signalSrcAvail;

#ifdef WITHGCONF
	CGConfUI m_gconfUI;
#endif

protected:
	Gtk::TextView m_textviewSrc;


public:
	CDlgSrc();
	virtual ~CDlgSrc();
	

private:
	static ustring formatMsg(const char* szMsg, int nLen);

protected:
#ifdef WITHGCONF
	void on_value_changed(const ustring& strKey, const Gnome::Conf::Value& value);
	void on_butOk_clicked();
	bool on_delete(GdkEventAny*);
	void save_pos_and_size();
#endif
	void initGUI();
	void on_Src_avail(const char* szMsg, int nLen);
};

#endif
