<?

/*
 * FlatImageGallery
 * Copyright (C) 2004 Marco Segato
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the license, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 */
 
/*
 * Blocco per FlatNuke (http://flatnuke.sourceforge.net) di Simone Vellei che
 * permette di creare automaticamente una galleria di immagini a partire da 
 * quelle che ci sono nella directory dove e' presente questo file.
 *
 * Autore    Marco Segato  <segatom@yahoo.it>
 * Website   http://www.marcosegato.tk
 * Versione  0.3
 * Data      09/09/2004
 */

 
include ("config.php");
global $bgcolor2, $bgcolor3;
  
// previene che il blocco sia eseguito direttamente e redirige a index.php
if (eregi("section.php",$_SERVER['PHP_SELF']))
	{ Header("Location: ../../index.php");
	die();
	}

// opzione di sicurezza!
$req=$_SERVER["REQUEST_URI"];
if(strstr($req,"myforum="))
	die(_NONPUOI);

// EVITA DI COSTRUIRE SCRIPT AD HOC
// PER ALTERARE DATI IN POST
// controlla il numero dei post
$posts=count($_POST);
$from=$_SERVER["HTTP_REFERER"];
if(!eregi($siteurl,$from) and ($from!="") and $posts!=0)
	die(_NONPUOI);

// controlla se il web server ha le librerie GD
if(!function_exists("ImageCreate")){
	print("<b>Error</b>: No GD library found!");
	return;
}

// definizione lingua
switch($lang)
	{ case "": $txt_pagina = "Pagina "; break;
	case "it": $txt_pagina = "Pagina "; break;
	case "de": $txt_pagina = "Seite "; break;
	case "en": $txt_pagina = "Page "; break;
	case "es": $txt_pagina = "Pgina "; break;
	}

// directory dove sono presenti le immagini
$path = "sections/".$_GET['mod'];
// carico tutti i files immagine in un array
$dir = opendir($path);
$n_file = 0;
while ($filename = readdir($dir))
	{ if	(
			( eregi(".gif",$filename)
			OR eregi(".jpg",$filename)
			OR eregi(".jpeg",$filename)
			OR eregi(".png",$filename)
			)
			AND !eregi(".php",$filename)
		)
		{ $array_dir[$n_file] = $filename;
		$n_file++;
		}
	}
// ordinamento alfabetico dell'array
natcasesort($array_dir);
$array_dir = array_values($array_dir);
?>

<!-- menu_top select per cambio pagina -->
<div align="center">
	<form name="pagine_top" action=""><?=$txt_pagina?>
	<select name="pag_top" onchange="self.location=document.pagine_top.pag_top[document.pagine_top.pag_top.selectedIndex].value">
		<? for($i=0;$i<$n_file/9;$i++)
			{ if(!isset($_GET['pag']))
				echo "<option value=\"index.php?mod=".$_GET['mod']."&amp;pag=".($i+1)."\">".($i+1)."</option>";
			else if($_GET['pag'] == $i+1)
				echo "<option value=\"index.php?mod=".$_GET['mod']."&amp;pag=".($i+1)."\" selected>".($i+1)."</option>";
				else echo "<option value=\"index.php?mod=".$_GET['mod']."&amp;pag=".($i+1)."\">".($i+1)."</option>";
			}
		?>
	</select>
	</form>
</div>

<!-- tabella 9x9 thumbnails -->
<table align="center" width="100%" cellspacing="2" cellpadding="0" bgcolor="<?=$bgcolor2?>"><tbody>
	<? if(isset($_GET['pag']))				// determina qual e' la prima foto della pagina: 1,10,19...
		$max_x_pag = ($_GET['pag'] * 9) - 8;
	else $max_x_pag = 1;

	for ($i=$max_x_pag; $i<$max_x_pag+9 and $i<=$n_file; $i++)
		{ if($i%3 == 1)					// apertura nuova riga prima delle immagini numero 1,4,7...
			echo "<tr bgcolor=\"$bgcolor3\">";
		list($width, $height) = getimagesize($path."/".$array_dir[$i-1]);
		if($width>1000 OR $height>650)			// dimensione massima finestre con immagini: 1024x768
			{ $width_max = 1024;
			$height_max = 768;
			$scrollbars = "yes";
			}
			else 	{ $width_max = $width;
				$height_max = $height;
				$scrollbars = "no";
				}
		?>
		<td align="center" valign="bottom" width="225" height="225">	<!-- stampa casella con immagine -->
		  <a href="#" onClick="MyWindow=window.open('<?=$path."/".$array_dir[$i-1]?>', 'MyWindow', 'toolbar=no, location=no, directories=no, status=yes, menubar=no, scrollbars=<?=$scrollbars?>, resizable=no, width=<?=$width_max?>, height=<?=$height_max?>, left=10, top=10');">
			<img border="1" src="thumb.php?image=<?="$path/".$array_dir[$i-1]?>" alt="thumb">
		  </a>
		  <br><b><?=$array_dir[$i-1]?></b>
		  <br><?=round(filesize($path."/".$array_dir[$i-1]) / 1024, 1)." Kb, $width"."x$height"?>
		</td>
		<?
		if($i%3 == 0)					// chiusura della riga dopo le immagini numero 3,6,9...
			echo "</tr>";
		}
	while (($i-1)%3 != 0)					// stampa casella vuota per terminare correttamente la riga
		{ echo "<td width=\"225\" height=\"225\"></td>";
		$i++;
		}
	?>
</tbody></table><br>

<!-- menu_bottom select per cambio pagina -->
<div align="center">
	<form name="pagine_bottom" action=""><?=$txt_pagina?>
	<select name="pag_bottom" onchange="self.location=document.pagine_bottom.pag_bottom[document.pagine_bottom.pag_bottom.selectedIndex].value">
		<? for($i=0;$i<$n_file/9;$i++)
			{ if(!isset($_GET['pag']))
				echo "<option value=\"index.php?mod=".$_GET['mod']."&amp;pag=".($i+1)."\">".($i+1)."</option>";
			else if($_GET['pag'] == $i+1)
				echo "<option value=\"index.php?mod=".$_GET['mod']."&amp;pag=".($i+1)."\" selected>".($i+1)."</option>";
				else echo "<option value=\"index.php?mod=".$_GET['mod']."&amp;pag=".($i+1)."\">".($i+1)."</option>";
			}
		?>
	</select>
	</form>
	<!-- footer -->
	<br><hr size="1" width="98%">
<!--
	Powered by <a href="http://marcosegato.altervista.org" target="_blank">FlatImageGallery</a> 0.3<br>Copyright &#169; 2004 Marco Segato-->
</div>
<?
module_copyright("FlatGallery", "0.3", "Marco Segato", "msegato@yahooo.it", "http://marcosegato.altervista.org", "GNU/GPL");
?>
