/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Floater Bridge Network.
 *
 * The Initial Developer of the Original Code is
 * Geoff Pike <pike@EECS.Berkeley.EDU>.
 * Portions created by the Initial Developer are Copyright (C) 1996-2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the
 * terms of either the GNU General Public License Version 2 or later
 * (the "GPL"), in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of the MPL,
 * indicate your decision by deleting the provisions above and replace
 * them with the notice and other provisions required by the GPL. If
 * you do not delete the provisions above, a recipient may use your
 * version of this file under the terms of either the MPL or the GPL.
 * ***** END LICENSE BLOCK ***** */


/* #include <tcl.h> */
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "floater.h"

/* like malloc, but die gracefully if out of memory */
char *salloc(unsigned t)
{
  char *w;

  if ((w = malloc(t)) != NULL) return w;
  fatal("Out of memory!  Goodbye.\n", -3);
  return NULL; /* never reached */
}
    
/* like salloc, but zero out the region */
char *zsalloc(unsigned t)
{
  char *w = salloc(t);
  while (t-- > 0) w[t] = 0;
  return w;
}

/*****************************************************************************/

static stringlist *garbage = NULL;

/* free everything on the garbage list */
void destroygarbage(void)
{
  while (garbage != NULL) garbage = freestringlist(garbage);
}

/* mark something as garbage (it will be freed later) */
char *markgarbage(char *x)
{
  garbage = consstringlist(x, garbage);
  return x;
}

int floaterentrypoint(ClientData clientData, Tcl_Interp *interp,
		 int argc, const char *argv[])
{
  extern void tasks(void);
  int ret;

  /* "unnecessary," but retained to check "impossible" conditions */
  static int entry = 0;

  
  assert(entry == 0);

  /* recursion is not allowed between DISALLOW_REENTRY() and ALLOW_REENTRY() */
  DISALLOW_REENTRY();
  entry++;

  if (entry > 100)
    fatal("Excessive recursion caused by user's command",
	  (entry > 101) ? 102 : 101);

  UIsetstatusline();
  ret = (*((Tcl_CmdProc *) clientData))((ClientData) NULL, interp, argc, argv);
  if (entry == 1) tasks();
  UIsetstatusline();

  if (--entry == 0) destroygarbage();
  ALLOW_REENTRY();
  return ret;
}
