/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Floater Bridge Network.
 *
 * The Initial Developer of the Original Code is
 * Geoff Pike <pike@EECS.Berkeley.EDU>.
 * Portions created by the Initial Developer are Copyright (C) 1996-2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the
 * terms of either the GNU General Public License Version 2 or later
 * (the "GPL"), in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of the MPL,
 * indicate your decision by deleting the provisions above and replace
 * them with the notice and other provisions required by the GPL. If
 * you do not delete the provisions above, a recipient may use your
 * version of this file under the terms of either the MPL or the GPL.
 * ***** END LICENSE BLOCK ***** */
#include <shlobj.h>
#include "floater.h"

static void shortcut_fail(char *s)
{
  fatal(s, -4);
}

/*
Then it's time to get down to the real work of creating the
shortcut. The CreateShortCut::CreateIt function actually performs the
task. It takes three parameters:

     pszShortcutFile is the file that the shortcut will point to. 
     pszLink is the shortcut you are creating with a LNK extension. 
     pszDesc is the description of the file. This is the string
     "Shortcut to filename", where filename is the name of the
     shortcut target.  

As you can see in the following code, this function uses both the
IPersistFile interface, for actually saving the shortcut in the
system, and the IShellLink interface, for storing the path and the
description of the shortcut target:
*/

static HRESULT CreateShortCut_CreateIt (char *pszShortcutFile, char *pszLink, 
					char *icon, char *pszDesc)
{
  HRESULT hres;
  IShellLink *psl;

#if 1
  printf("Creating shortcut %s to %s, `%s'\n",
	 pszLink, pszShortcutFile, pszDesc);
#endif
#if 0
  status7("Creating shortcut ", pszLink, " to ", pszShortcutFile,
	  ", `", pszDesc, "'");
#endif
  
  CoInitialize(NULL);
  /* Create an IShellLink object and get a pointer to the IShellLink */
  /* interface (returned from CoCreateInstance). */
  hres = CoCreateInstance (&CLSID_ShellLink, NULL, CLSCTX_INPROC_SERVER,
			   &IID_IShellLink, &psl);
  if (SUCCEEDED (hres)) {
    IPersistFile *ppf;
      
    /* Query IShellLink for the IPersistFile interface for */
    /* saving the shortcut in persistent storage. */
    hres = psl->lpVtbl->QueryInterface(psl, &IID_IPersistFile, &ppf);
    if (SUCCEEDED (hres)) {
#define MAX_SILLY 1000
      WORD wsz [MAX_SILLY]; /* buffer for Unicode string*/
	  
      /* Set the path to the shortcut target. */
      hres = psl->lpVtbl->SetPath (psl, pszShortcutFile);
      if (! SUCCEEDED (hres))
	shortcut_fail("SetPath failed!");
	  
      /* Set the path to the icon. */
      hres = psl->lpVtbl->SetIconLocation(psl, icon, 0);
      if (! SUCCEEDED (hres))
	shortcut_fail("SetIconLocation failed!");

      /* Set the description of the shortcut. */
      hres = psl->lpVtbl->SetDescription (psl, pszDesc);
      if (! SUCCEEDED (hres))
	shortcut_fail("SetDescription failed!");
	  
      /* Ensure that the string consists of ANSI characters. */
      MultiByteToWideChar (CP_ACP, 0, pszLink, -1, wsz, MAX_SILLY);
#undef MAX_SILLY	  
      /* Save the shortcut via the IPersistFile::Save member function. */
      hres = ppf->lpVtbl->Save (ppf, wsz, TRUE);
	  
      if (! SUCCEEDED (hres))
	shortcut_fail("Save failed!");
	  
      /* Release the pointer to IPersistFile. */
      ppf->lpVtbl->Release (ppf);
    }
    /* Release the pointer to IShellLink. */
    psl->lpVtbl->Release (psl);
  }
  CoUninitialize();
  return hres;
} 

void create_shortcut(char *destfile, char *linkfile, char *icon, char *desc)
{
  CreateShortCut_CreateIt(destfile, linkfile, icon, desc);
}

/*
 *----------------------------------------------------------------------
 *
 * shortcut
 *
 *	Works under MS WINDOWS only.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	Creates a shortcut.
 *
 *----------------------------------------------------------------------
 */

	/* ARGSUSED */
int
shortcut(
    ClientData clientData,	/* Unused. */
    Tcl_Interp *interp,		/* Current interpreter. */
    int argc,			/* Number of arguments. */
    char **argv			/* Argument strings. */
)
{
  HRESULT hres;

  if (argc != 4) {
    Tcl_AppendResult(interp, "wrong # args: should be \"",
		     argv[0], " file linkfile description\"", (char *) NULL);
    return TCL_ERROR;
  }
  hres = CreateShortCut_CreateIt(argv[1], argv[2], NULL, argv[3]);
  return SUCCEEDED(hres) ? TCL_OK : TCL_ERROR;
}

/* Once you have created the shortcut, you might need to access and
manipulate it programmatically. This is referred to as resolving the
shortcut. I added a function to my sample that demonstrates how you
can resolve a shortcut. I used the same type of dialog box that I used
for creating the shortcut-and used almost exactly the same code to
fill the dialog box with the names of the files in the current
directory and prompt the user to choose a shortcut to resolve. The
only difference was a simple check to ensure that the user actually
picked a LNK file:

(omitted)

The ResolveShortCut::ResolveIt function resolves the shortcut. This
function takes two parameters:

	hwnd is the handle to the window that currently has the
	focus. This is used in case the user must be prompted to take an
	action. For instance, a message box is displayed if the user needs to
	insert a floppy disk, if the shortcut is on unshared media, or if
	network problems arise during the resolution of the shortcut.
	pszShortcutFile is the fully qualified path to the shortcut.

Like the function that created the shortcut, this function calls
CoCreateInstance and assumes that CoInitialize has already been
called. Notice that the following code needs to call into the
IPersistFile interface. The IShellLink object implements this
interface to store shortcut information. To get the path information
requested later in the code, the shortcut information must be loaded
first. Failing to load the shortcut information causes the calls to
GetPath and GetDescription to fail.
*/

#if 0
HRESULT ResolveShortCut_ResolveIt (HWND hwnd, LPCSTR pszShortcutFile)
{
  HRESULT hres;
  IShellLink *psl;
  char szGotPath [MAX_PATH];
  char szDescription [MAX_PATH];
  WIN32_FIND_DATA wfd;

  /* Get a pointer to the IShellLink interface. */
  hres = CoCreateInstance (CLSID_ShellLink, NULL, CLSCTX_INPROC_SERVER,
			   IID_IShellLink, (void **)&psl);
  if (SUCCEEDED (hres))
    {
      IPersistFile *ppf;
      
      /* Get a pointer to the IPersistFile interface. */
      hres = psl->QueryInterface (IID_IPersistFile, (void **)&ppf);
      
      if (SUCCEEDED (hres))
	{
	  WORD wsz [MAX_PATH]; /* buffer for Unicode string*/
	  
	  /* Ensure that the string consists of Unicode characters. */
	  MultiByteToWideChar (CP_ACP, 0, pszShortcutFile, -1, wsz,
			       MAX_PATH);
	  
	  /* Load the shortcut. */
	  hres = ppf->Load (wsz, STGM_READ);
	  
	  if (SUCCEEDED (hres))
	    {
	      /* Resolve the shortcut. */
	      hres = psl->Resolve (hwnd, SLR_ANY_MATCH);
	      if (SUCCEEDED (hres))
		{
		  strcpy (szGotPath, pszShortcutFile);
		  /* Get the path to the shortcut target. */
		  hres = psl->GetPath (szGotPath, MAX_PATH,
				       (WIN32_FIND_DATA *)&wfd, SLGP_SHORTPATH);
		  if (! SUCCEEDED (hres))
		    AfxMessageBox ("GetPath failed!");
		  else
		    AfxMessageBox (szGotPath);
		  /* Get the description of the target. */
		  hres = psl->GetDescription (szDescription, MAX_PATH);
		  if (! SUCCEEDED (hres))
		    AfxMessageBox ("GetDescription failed!");
		  else
		    AfxMessageBox (szDescription);
		}
	    }
	  /* Release the pointer to IPersistFile. */
	  ppf->Release ();
	}
      /* Release the pointer to IShellLink. */
      psl->Release ();
    }
  return hres;
}
#endif

#if 0
/*
 *-------------------------------------------------------------------------
 *
 * TclWinResolveShortcut --
 *
 *	Resolve a potential Windows shortcut to get the actual file or 
 *	directory in question.  
 *
 * Results:
 *	Returns 1 if the shortcut could be resolved, or 0 if there was
 *	an error or if the filename was not a shortcut.
 *	If bufferPtr did hold the name of a shortcut, it is modified to
 *	hold the resolved target of the shortcut instead.
 *
 * Side effects:
 *	Loads and unloads OLE package to determine if filename refers to
 *	a shortcut.
 *
 *-------------------------------------------------------------------------
 */

int
TclWinResolveShortcut(bufferPtr)
    Tcl_DString *bufferPtr;	/* Holds name of file to resolve.  On 
				 * return, holds resolved file name. */
{
    HRESULT hres; 
    IShellLink *psl; 
    IPersistFile *ppf; 
    WIN32_FIND_DATA wfd; 
    WCHAR wpath[MAX_PATH];
    char *path, *ext;
    char realFileName[MAX_PATH];

    /*
     * Windows system calls do not automatically resolve
     * shortcuts like UNIX automatically will with symbolic links.
     */

    path = Tcl_DStringValue(bufferPtr);
    ext = strrchr(path, '.');
    if ((ext == NULL) || (stricmp(ext, ".lnk") != 0)) {
	return 0;
    }

    CoInitialize(NULL);
    path = Tcl_DStringValue(bufferPtr);
    realFileName[0] = '\0';
    hres = CoCreateInstance(&CLSID_ShellLink, NULL, CLSCTX_INPROC_SERVER, 
	    &IID_IShellLink, &psl); 
    if (SUCCEEDED(hres)) { 
	hres = psl->lpVtbl->QueryInterface(psl, &IID_IPersistFile, &ppf);
	if (SUCCEEDED(hres)) { 
	    MultiByteToWideChar(CP_ACP, 0, path, -1, wpath, sizeof(wpath));
	    hres = ppf->lpVtbl->Load(ppf, wpath, STGM_READ); 
	    if (SUCCEEDED(hres)) {
		hres = psl->lpVtbl->Resolve(psl, NULL, 
			SLR_ANY_MATCH | SLR_NO_UI); 
		if (SUCCEEDED(hres)) { 
		    hres = psl->lpVtbl->GetPath(psl, realFileName, MAX_PATH, 
			    &wfd, 0);
		} 
	    } 
	    ppf->lpVtbl->Release(ppf); 
	} 
	psl->lpVtbl->Release(psl); 
    } 
    CoUninitialize();

    if (realFileName[0] != '\0') {
	Tcl_DStringSetLength(bufferPtr, 0);
	Tcl_DStringAppend(bufferPtr, realFileName, -1);
	return 1;
    }
    return 0;
}
#endif
