/* This program is under the GNU copyright 
 * Author Damiano Bolla (Italy)
 */
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <sys/ioctl.h>
#include <linux/fd.h>

struct floppy_struct fdparm;

#include "defines.h"

int main(int argc, char *argv[])
{
	struct archive_header arch;				/* Struct that holds all info */
	unsigned char *device;
	int inf;
	
	if(argc<2){
		fprintf(stderr,"No device specified. Using "DEFAULT_DEVICE"\n");
		device=DEFAULT_DEVICE;
	}
	else
	  device=strdup(argv[1]);
	
	if((inf = open(device, O_RDONLY))<0){
		fprintf(stderr, "floppycheck: Can't open device %s\n", device);
		exit(2);
	}
	
	ioctl(inf,FDGETPRM,&fdparm);
	printf("%s: %d tracks, %d sectors, %d heads --> %d bytes (%d KB).\n",
			 argv[0],fdparm.track,fdparm.sect,fdparm.head,
			 fdparm.size*512,fdparm.size/2);
	
	/* Read archive info struct from disk.*/
	read(inf,&arch,sizeof(struct archive_header));
	
	close(inf);
	
	/* Check whether this floppy is a floppybackup disk at all.*/
	if(strncmp(arch.magicbytes,MAGICBYTES,strlen(MAGICBYTES))){
		fprintf(stderr,"Not a floppybackup disk.\n");
		close(inf);
		exit(3);
	}
	
	printf("This disk belongs to a floppybackup archive.\n"
			 "Version        : %s\n"
			 "Archive name   : %s\n"
			 "Disk number    : %d\n"
			 "More disks?    : %s\n"
			 "Reserved bytes : %d\n"
			 "Databytes      : %d\n",
			 arch.version,
			 arch.name,
			 atoi(arch.fd_number)+1,
			 (arch.fd_more)?("Yes"):("No"),
			 sizeof(struct archive_header),
			 atoi(arch.fd_length));
	
	exit(0);
}
