// Copyright 2004 "Gilles Degottex"

// This file is part of "fmit"

// "fmit" is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// "fmit" is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA



#ifndef _CustomInstrumentTunerForm_h_
#define _CustomInstrumentTunerForm_h_

#include "InstrumentTunerForm.h"

#include "config.h"

#include <deque>
using namespace std;
#include <qtimer.h>
#include <qdial.h>
#include <qsettings.h>
#include <Music/Music.h>
#include <Music/TimeAnalysis.h>
#include <Music/FreqAnalysis.h>
#include <Music/MultiCumulativeDiffAlgo.h>
#include <Music/CumulativeDiffAlgo.h>
// #include <Music/BubbleAlgo.h>
using namespace Music;
#include "CaptureThread.h"
#include "DialView.h"
#include "GLGraph.h"
#include "GLErrorHistory.h"
#include "GLVolumeHistory.h"
#include "MicrotonalView.h"
#include "GLSample.h"
#include "GLFreqStruct.h"
#include "ConfigForm.h"

class CustomInstrumentTunerForm : public InstrumentTunerForm
{
	Q_OBJECT

  public:
	ConfigForm	m_config_form;

	CaptureThread m_capture_thread;
	virtual void pause(bool on);
	Algorithm*	m_selected_algo;
	MultiCumulativeDiffAlgo* m_algo_multidiff;
	CumulativeDiffAlgo* m_algo_diff;
	CombedFFT* m_algo_combedfft;

	DialView* m_dialTune;
	GLGraph* m_glGraph;
	GLErrorHistory* m_glErrorHistory;
	GLVolumeHistory* m_glVolumeHistory;
	GLSample* m_glSample;
	GLFreqStruct* m_glFreqStruct;
	MicrotonalView* m_microtonalView;

	bool m_first_time;
	double m_note_start;
	double m_gap_time;
	double m_test_freq;
	deque<double> m_queue;
	double m_freq;
	double m_compared_freq;
	void get_error_and_variance(double& error, double& error_var);
	double m_error;

	struct Analysis
	{
		double time;
		double freq;
		double diff;
		Analysis(double t, double f, double d) : time(t), freq(f), diff(d) {}
	};
	deque<Analysis> m_old_analysis;

	CustomInstrumentTunerForm();
	virtual void init();
	QSettings m_settings;
	void loadSettings();
	virtual void saveSettings();
	virtual void restoreFactorySettings();

	virtual void resizeEvent(QResizeEvent* e);
	virtual void keyPressEvent(QKeyEvent * e);

	virtual void update_views();
	virtual void configure();
	virtual void configure_ok();
	virtual void errorRaised(const QString& error);
	virtual void samplingRateChanged(int sampling_rate);
	virtual void noteRangeChanged();
	virtual void transportChanged(const QString& name);
	virtual void autoDetectTransport();
	virtual void alsaTransportSelected();
	virtual void jackTransportSelected();
	virtual void tuningFreqChanged(float);
	virtual void ui_spinAFreq_valueChanged(int);
	virtual void ui_spinAOffset_valueChanged(int);

	void toggleFullScreen();

	QTime m_time;
	void refresh();
	QTimer* m_timer_refresh;
	double m_last_refresh;

	virtual void refresh_views();
	double m_last_views_update;
	void refresh_data_sample();
	void refresh_data_harmonics();

	virtual void helpAbout();

	~CustomInstrumentTunerForm();
};

#endif // _CustomInstrumentTunerForm_h_

