#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /cvsroot/fnorb/fnorb/script/fnoptions.py,v $
# Version:      @(#)$RCSfile: fnoptions.py,v $ $Revision: 1.1 $
#
#############################################################################
""" Write the ORB options on stdout. """


# Standard/built-in modules.
import sys

# Fnorb modules.
from Fnorb.orb import CORBA


def main(argv):
    """ Do it! """

    # Initialise the ORB and get the options.
    options = CORBA.ORB_init(argv, CORBA.ORB_ID)._fnorb_options()

    # Find the length of the longest option name (partly so we can make it look
    # pretty - and partly 'cos I've been dying to use this solution for
    # finding the maximum length of a list of strings ;^)
    biggest = max(map(len, options.keys()))

    # Write them onto stdout! Yeah, I know - tough program ;^)
    print
    for (key, value) in options.items():
	print "%-*s  :  %s" % (biggest, key, value)
    print

    return 0

#############################################################################

if __name__ == '__main__':
    # Do it!
    sys.exit(main(sys.argv))

#############################################################################
