#!/usr/bin/env python


# Standard/built-in modules.
import sys

# Fnorb modules.
from Fnorb.orb import BOA, CORBA

# Stubs and skeletons generated by 'fnidl'.
import testinterop, testinterop_skel

class ExampleServer(testinterop_skel.TestChars_skel):

    def __init__(self):

	# Base class constructor.
	CORBA.Object_skel.__init__(self)

    def testWString(self, wstring):
        print "WString:", wstring
        return wstring

    def testWChar(self, wstring):
        print wstring
        return wstring

def main(argv):
    """ Do it! """

    print 'Initialising the ORB...'

    # Initialise the ORB.
    orb = CORBA.ORB_init(argv, CORBA.ORB_ID)

    print 'Initialising the BOA...'

    # Initialise the BOA.
    boa = BOA.BOA_init(argv, BOA.BOA_ID)

    print 'Creating object reference...'

    # Create an object reference ('fred' is the object key).
    obj = boa.create('fred', ExampleServer._FNORB_ID)

    print 'Creating implementation...'

    # Create an instance of the implementation class.
    impl = ExampleServer()

    print 'Activating the implementation...'

    # Activate the implementation (ie. connect the generated object reference
    # to the implementation).  Note that the implementation will not receive
    # any operation requests until we start the event loop (see below).
    boa.obj_is_ready(obj, impl)

    # Write the stringified object reference to a file (this is just a 'cheap
    # and cheerful' way of making the object reference available to the
    # client!).
    ref_file = open('Server.ref', 'w')
    ref_file.write(orb.object_to_string(obj))
    ref_file.close()

    print 'Server created and accepting requests...'

    # Start the event loop.
    boa._fnorb_mainloop()

    print 'Server complete!'

    return 0


#############################################################################

if __name__ == '__main__':
    # Do it!
    try:
	sys.exit(main(sys.argv))
    except KeyboardInterrupt:
	print
	print "Server done"

#############################################################################
