#include <Utils.h>

#include <fstream>

void
write_ex(std::ostream &os, const CORBA::Exception &ex)
{
#ifdef FN_ORBACUS
    os << ex << std::endl;
#elif defined(FN_OMNIORB) // FN_OMNIORB
    os << ex._name() << std::endl;
#elif defined(FN_TAO)     // FN_TAO
    os << "Exception caught" << std::endl; // TODO Find way to get name
#endif // FN_ORBACUS
}

void
write_wstring_data(std::ostream &os, const CORBA::WChar* ws)
{
#ifdef FN_ORBACUS

    for (unsigned int i = 0; i < OB::wcslen(ws); i++) {
	os << ws[i];
	if (i < OB::wcslen(ws)-1) {
	    os << ", ";
	}
    }

    os << std::endl;

#elif defined(FN_OMNIORB) // FN_OMNIORB

    for (int i = 0; i < _CORBA_WString_helper::len(ws); i++) {
	os << ws[i];
	if (i < _CORBA_WString_helper::len(ws)-1) {
	    os << ", ";
	}
    }

    os << std::endl;

#elif defined(FN_TAO) // FN_TAO

    for (unsigned int i = 0; i < ACE_OS::wslen(ws); i++) {
	os << ws[i];
	if (i < ACE_OS::wslen(ws)-1) {
	    os << ", ";
	}
    }

    os << std::endl;

#else

#error "Can't handle this orb!"

#endif // FN_ORBACUS
}

bool
wstring_compare(const CORBA::WChar* ws1, const CORBA::WChar* ws2)
{
#ifdef FN_ORBACUS

    return OB::wcscmp(ws1, ws2) == 0;

#elif defined(FN_OMNIORB) // FN_OMNIORB

    CORBA::ULong string1_len = _CORBA_WString_helper::len(ws1);
    CORBA::ULong string2_len = _CORBA_WString_helper::len(ws2);

    // If the lengths are different, we know the strings are different
    if (string1_len != string2_len) {
	return false;
    }

    // Check each character until the end is reached, or a mismatch is
    // encountered
    CORBA::ULong i;
    for (i = 0; i < string1_len; i++) {
	if (ws1[i] != ws2[i]) {
	    break;
	}
    }

    return i == string1_len; // That is, we reached the end with no
                             // differences

#elif defined(FN_TAO) // FN_TAO

    CORBA::ULong string1_len = ACE_OS::wslen(ws1);
    CORBA::ULong string2_len = ACE_OS::wslen(ws2);

    // If the lengths are different, we know the strings are different
    if (string1_len != string2_len) {
	return false;
    }

    // Check each character until the end is reached, or a mismatch is
    // encountered
    CORBA::ULong i;
    for (i = 0; i < string1_len; i++) {
	if (ws1[i] != ws2[i]) {
	    break;
	}
    }

    return i == string1_len; // That is, we reached the end with no
                             // differences

#else // FN_ORBACUS

#error "Can't handle this orb!"

#endif // FN_OMNIORB
}

CORBA::Object_ptr
get_ior_from_file(CORBA::ORB_ptr orb, const std::string &file_name)
{
#ifdef FN_ORBACUS

    CORBA::Object_ptr obj = orb->string_to_object("relfile:Server.ref");

    return obj;

#else // FN_ORBACUS

    std::ifstream file(file_name.c_str());
    std::string ior_string;
    file >> ior_string;

    std::cerr << ior_string << std::endl;

    CORBA::Object_ptr obj = orb->string_to_object(ior_string.c_str());

    return obj;

#endif // FN_ORBACUS
}

