
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static char b64revtb[256] = {
   -3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63,
   52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -2, -1, -1,
   -1,  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14,
   15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1,
   -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
   41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1,
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
};


size_t * raw_base64_decode(unsigned char *in, unsigned char *out) 
{
   unsigned int   result = 0, x;
   unsigned char  buf[3], *p = in, pad=0;

   int *err = 0;
   int strict = 0;
   size_t pos=0;

   while(!pad) {
      switch((x = b64revtb[*p++])) {
         case -3:
            if(((p-1)-in)%4) *err = 1;
            out[pos] = 0;
            return((size_t *)pos);
         case -2:
            if(((p-1)-in)%4 < 2) {
               *err = 1;
               return((size_t *)pos);
            } else if (((p-1)-in) %4 == 2) {
               if (*p != '=') {
                  *err = 1;
                  return((size_t *)pos);
               }
               buf[2] = 0;
               pad=2;
               result++;
               break;
            } else {
               pad = 1;
               result += 2;
               break;
            }
            return((size_t *)pos);
         case -1:
            if(strict) {
               *err=2;
               return((size_t *)pos);
            }
            break;
         default:
            switch(((p-1)-in)%4) {
               case 0:
                  buf[0] = x << 2;
                  break;
               case 1:
                  buf[0] |= (x >> 4);
                  buf[1]  =  x << 4 ;
                  break;
               case 2:
                  buf[1] |= (x >> 2);
                  buf[2]  =  x << 6 ;
                  break;
               case 3:
                  buf[2] |= x;
                  result += 3;
                  
                  for(x=0; x<3-pad; x++) {
                     out[pos++] = buf[x];
                  }
                  break;
            }
            break;
      }
   }

   for(x=0; x<3-pad; x++)
      out[pos++] = buf[x];
      
   return((size_t *)pos);
}

