#!/usr/bin/env python
#
#     foomatic-gui - GNOME2 interface to the foomatic printing system
#     Copyright (C) 2002-05 Chris Lawrence <lawrencc@debian.org>
#
#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
#
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
#
#     You should have received a copy of the GNU General Public License
#     along with this program; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# $Id: setup.py,v 1.8 2005/03/04 04:45:44 lordsutch Exp $

from distutils.core import setup
import foomatic
import os
import glob

i18n = []
for lang in glob.glob('*.po'):
    lang = lang[:-3]
    if lang == 'messages':
        continue
    i18n.append( ('share/locale/%s/LC_MESSAGES' % lang,
                  ['i18n/%s/LC_MESSAGES/foomatic-gui.mo' % lang]) )

setup(name='foomatic-gui', version=foomatic.__version__,
      description='Python and GNOME interface to the Foomatic printing system',
      author='Chris Lawrence', author_email='chris@lordsutch.com',
      url='http://blog.lordsutch.com/?topic=13',
      data_files=i18n+[('share/foomatic-gui',
                        ['foomatic-gui.glade', 'testpage.ps']),
                       ('share/applications', ['foomatic-gui.desktop']),
                       ('share/pixmaps', ['foomatic-gui-logo.png'])],
      license='GPL v2', packages=['foomatic'], scripts=['foomatic-gui',
                                                        'printconf'])
