{
    This file is assembled from all the Interface files.
}
{$mode macpas}
{$packenum 1}
{$macro on}
{$inline on}
{$CALLING MWPASCAL}

unit FPCMacOSAll;
interface
{$setc UNIVERSAL_INTERFACES_VERSION := $0342}
{$setc GAP_INTERFACES_VERSION := $0200}

{$ifc not defined USE_CFSTR_CONSTANT_MACROS}
    {$setc USE_CFSTR_CONSTANT_MACROS := TRUE}
{$endc}

{$ifc defined CPUPOWERPC and defined CPUI386}
	{$error Conflicting initial definitions for CPUPOWERPC and CPUI386}
{$endc}
{$ifc defined FPC_BIG_ENDIAN and defined FPC_LITTLE_ENDIAN}
	{$error Conflicting initial definitions for FPC_BIG_ENDIAN and FPC_LITTLE_ENDIAN}
{$endc}

{$ifc not defined __ppc__ and defined CPUPOWERPC}
	{$setc __ppc__ := 1}
{$elsec}
	{$setc __ppc__ := 0}
{$endc}
{$ifc not defined __i386__ and defined CPUI386}
	{$setc __i386__ := 1}
{$elsec}
	{$setc __i386__ := 0}
{$endc}

{$ifc defined __ppc__ and __ppc__ and defined __i386__ and __i386__}
	{$error Conflicting definitions for __ppc__ and __i386__}
{$endc}

{$ifc defined __ppc__ and __ppc__}
	{$setc TARGET_CPU_PPC := TRUE}
	{$setc TARGET_CPU_X86 := FALSE}
{$elifc defined __i386__ and __i386__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_X86 := TRUE}
{$elsec}
	{$error Neither __ppc__ nor __i386__ is defined.}
{$endc}
{$setc TARGET_CPU_PPC_64 := FALSE}

{$ifc defined FPC_BIG_ENDIAN}
	{$setc TARGET_RT_BIG_ENDIAN := TRUE}
	{$setc TARGET_RT_LITTLE_ENDIAN := FALSE}
{$elifc defined FPC_LITTLE_ENDIAN}
	{$setc TARGET_RT_BIG_ENDIAN := FALSE}
	{$setc TARGET_RT_LITTLE_ENDIAN := TRUE}
{$elsec}
	{$error Neither FPC_BIG_ENDIAN nor FPC_LITTLE_ENDIAN are defined.}
{$endc}
{$setc ACCESSOR_CALLS_ARE_FUNCTIONS := TRUE}
{$setc CALL_NOT_IN_CARBON := FALSE}
{$setc OLDROUTINENAMES := FALSE}
{$setc OPAQUE_TOOLBOX_STRUCTS := TRUE}
{$setc OPAQUE_UPP_TYPES := TRUE}
{$setc OTCARBONAPPLICATION := TRUE}
{$setc OTKERNEL := FALSE}
{$setc PM_USE_SESSION_APIS := TRUE}
{$setc TARGET_API_MAC_CARBON := TRUE}
{$setc TARGET_API_MAC_OS8 := FALSE}
{$setc TARGET_API_MAC_OSX := TRUE}
{$setc TARGET_CARBON := TRUE}
{$setc TARGET_CPU_68K := FALSE}
{$setc TARGET_CPU_MIPS := FALSE}
{$setc TARGET_CPU_SPARC := FALSE}
{$setc TARGET_OS_MAC := TRUE}
{$setc TARGET_OS_UNIX := FALSE}
{$setc TARGET_OS_WIN32 := FALSE}
{$setc TARGET_RT_MAC_68881 := FALSE}
{$setc TARGET_RT_MAC_CFM := FALSE}
{$setc TARGET_RT_MAC_MACHO := TRUE}
{$setc TYPED_FUNCTION_POINTERS := TRUE}
{$setc TYPE_BOOL := FALSE}
{$setc TYPE_EXTENDED := FALSE}
{$setc TYPE_LONGLONG := TRUE}

{unit ConditionalMacros}
{
     File:       ConditionalMacros.p
 
     Contains:   Set up for compiler independent conditionals
 
     Version:    Technology: Universal Interface Files
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   1993-2002 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}

{$ALIGN MAC68K}

{***************************************************************************************************
    UNIVERSAL_INTERFACES_VERSION
    
        0x0400 --> version 4.0 (Mac OS X only)
        0x0341 --> version 3.4.1 
        0x0340 --> version 3.4 
        0x0331 --> version 3.3.1
        0x0330 --> version 3.3
        0x0320 --> version 3.2
        0x0310 --> version 3.1
        0x0301 --> version 3.0.1
        0x0300 --> version 3.0
        0x0210 --> version 2.1
        This conditional did not exist prior to version 2.1
***************************************************************************************************}


{***************************************************************************************************

    TARGET_CPU_    
    These conditionals specify which microprocessor instruction set is being
    generated.  At most one of these is true, the rest are false.

        TARGET_CPU_PPC          - Compiler is generating PowerPC instructions
        TARGET_CPU_68K          - Compiler is generating 680x0 instructions
        TARGET_CPU_X86          - Compiler is generating x86 instructions
        TARGET_CPU_MIPS         - Compiler is generating MIPS instructions
        TARGET_CPU_SPARC        - Compiler is generating Sparc instructions
        TARGET_CPU_ALPHA        - Compiler is generating Dec Alpha instructions


    TARGET_OS_ 
    These conditionals specify in which Operating System the generated code will
    run. At most one of the these is true, the rest are false.

        TARGET_OS_MAC           - Generate code will run under Mac OS
        TARGET_OS_WIN32         - Generate code will run under 32-bit Windows
        TARGET_OS_UNIX          - Generate code will run under some unix 


    TARGET_RT_ 
    These conditionals specify in which runtime the generated code will
    run. This is needed when the OS and CPU support more than one runtime
    (e.g. MacOS on 68K supports CFM68K and Classic 68k).

        TARGET_RT_LITTLE_ENDIAN - Generated code uses little endian format for integers
        TARGET_RT_BIG_ENDIAN    - Generated code uses big endian format for integers    
        TARGET_RT_MAC_CFM       - TARGET_OS_MAC is true and CFM68K or PowerPC CFM (TVectors) are used
        TARGET_RT_MAC_MACHO     - TARGET_OS_MAC is true and Mach-O style runtime
        TARGET_RT_MAC_68881     - TARGET_OS_MAC is true and 68881 floating point instructions used  


    TARGET__API__ 
    These conditionals are used to differentiate between sets of API's on the same
    processor under the same OS.  The first section after _API_ is the OS.  The
    second section is the API set.  Unlike TARGET_OS_ and TARGET_CPU_, these
    conditionals are not mutally exclusive. This file will attempt to auto-configure
    all TARGET_API__ values, but will often need a TARGET_API__ value predefined
    in order to disambiguate.
    
        TARGET_API_MAC_OS8      - Code is being compiled to run on System 7 through Mac OS 8.x
        TARGET_API_MAC_CARBON   - Code is being compiled to run on Mac OS 8 and Mac OS X via CarbonLib
        TARGET_API_MAC_OSX      - Code is being compiled to run on Mac OS X


    PRAGMA_
    These conditionals specify whether the compiler supports particular #pragma's
    
        PRAGMA_IMPORT           - Compiler supports: #pragma import on/off/reset
        PRAGMA_ONCE             - Compiler supports: #pragma once
        PRAGMA_STRUCT_ALIGN     - Compiler supports: #pragma options align=mac68k/power/reset
        PRAGMA_STRUCT_PACK      - Compiler supports: #pragma pack(n)
        PRAGMA_STRUCT_PACKPUSH  - Compiler supports: #pragma pack(push, n)/pack(pop)
        PRAGMA_ENUM_PACK        - Compiler supports: #pragma options(!pack_enums)
        PRAGMA_ENUM_ALWAYSINT   - Compiler supports: #pragma enumsalwaysint on/off/reset
        PRAGMA_ENUM_OPTIONS     - Compiler supports: #pragma options enum=int/small/reset


    FOUR_CHAR_CODE
    This conditional does the proper byte swapping to assue that a four character code (e.g. 'TEXT')
    is compiled down to the correct value on all compilers.

        $61626364 (* 'abcd' *)  - Convert a four-char-code to the correct 32-bit value


    TYPE_
    These conditionals specify whether the compiler supports particular types.

        TYPE_LONGLONG               - Compiler supports "long long" 64-bit integers
        TYPE_BOOL                   - Compiler supports "bool"
        TYPE_EXTENDED               - Compiler supports "extended" 80/96 bit floating point
        TYPE_LONGDOUBLE_IS_DOUBLE   - Compiler implements "long double" same as "double"


    FUNCTION_
    These conditionals specify whether the compiler supports particular language extensions
    to function prototypes and definitions.

        FUNCTION_PASCAL         - Compiler supports "pascal void Foo()"
        FUNCTION_DECLSPEC       - Compiler supports "__declspec(xxx) void Foo()"
        FUNCTION_WIN32CC        - Compiler supports "void __cdecl Foo()" and "void __stdcall Foo()"

***************************************************************************************************}


{***************************************************************************************************
    Backward compatibility for clients expecting 2.x version on ConditionalMacros.h

    GENERATINGPOWERPC       - Compiler is generating PowerPC instructions
    GENERATING68K           - Compiler is generating 68k family instructions
    GENERATING68881         - Compiler is generating mc68881 floating point instructions
    GENERATINGCFM           - Code being generated assumes CFM calling conventions
    CFMSYSTEMCALLS          - No A-traps.  Systems calls are made using CFM and UPP's
    PRAGMA_ALIGN_SUPPORTED  - Compiler supports: #pragma options align=mac68k/power/reset
    PRAGMA_IMPORT_SUPPORTED - Compiler supports: #pragma import on/off/reset
    CGLUESUPPORTED          - Clients can use all lowercase toolbox functions that take C strings instead of pascal strings

***************************************************************************************************}


{***************************************************************************************************

    OLDROUTINENAMES         - "Old" names for Macintosh system calls are allowed in source code.
                              (e.g. DisposPtr instead of DisposePtr). The names of system routine
                              are now more sensitive to change because CFM binds by name.  In the 
                              past, system routine names were compiled out to just an A-Trap.  
                              Macros have been added that each map an old name to its new name.  
                              This allows old routine names to be used in existing source files,
                              but the macros only work if OLDROUTINENAMES is true.  This support
                              will be removed in the near future.  Thus, all source code should 
                              be changed to use the new names! You can set OLDROUTINENAMES to false
                              to see if your code has any old names left in it.
    
***************************************************************************************************}


{***************************************************************************************************

    TARGET_CARBON                   - default: false. Switches all of the above as described.  Overrides all others
                                    - NOTE: If you set TARGET_CARBON to 1, then the other switches will be setup by
                                            ConditionalMacros, and should not be set manually.

    If you wish to do development for pre-Carbon Systems, you can set the following:

    OPAQUE_TOOLBOX_STRUCTS          - default: false. True for Carbon builds, hides struct fields.
    OPAQUE_UPP_TYPES                - default: false. True for Carbon builds, UPP types are unique and opaque.
    ACCESSOR_CALLS_ARE_FUNCTIONS    - default: false. True for Carbon builds, enables accessor functions.
    CALL_NOT_IN_CARBON              - default: true.  False for Carbon builds, hides calls not supported in Carbon.
    
    Specifically, if you are building a non-Carbon application (one that links against InterfaceLib)
    but you wish to use some of the accessor functions, you can set ACCESSOR_CALLS_ARE_FUNCTIONS to 1
    and link with CarbonAccessors.o, which implements just the accessor functions. This will help you
    preserve source compatibility between your Carbon and non-Carbon application targets.
    
    MIXEDMODE_CALLS_ARE_FUNCTIONS   - deprecated.

***************************************************************************************************}


{unit MacTypes}
{
     File:       CarbonCore/MacTypes.h
 
     Contains:   Basic Macintosh data types.
 
     Version:    CarbonCore-654.0.85~1
 
     Copyright:   1985-2005 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}
{       Pascal Translation Updated:  Peter N Lewis, <peter@stairways.com.au>, August 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}


{*******************************************************************************

    Base integer types for all target OS's and CPU's
    
        UInt8            8-bit unsigned integer 
        SInt8            8-bit signed integer
        UInt16          16-bit unsigned integer 
        SInt16          16-bit signed integer           
        UInt32          32-bit unsigned integer 
        SInt32          32-bit signed integer   
        UInt64          64-bit unsigned integer 
        SInt64          64-bit signed integer   

********************************************************************************}
type
    SInt8 = ShortInt;
    UInt8 = Byte;
    SInt16 = Integer;
    UInt16 = Word;
    SInt32 = LongInt;
    UInt32 = Longword;
    SInt64 = Int64;
    UInt64 = QWord;



{$ifc TARGET_RT_BIG_ENDIAN}

type
	wide = record
		case boolean of
			false:
				( hi:		SInt32;
					lo:		UInt32);
			true:
				( int:	SInt64)
	end;

	UnsignedWide = record
		case boolean of
			false:
				( hi:		UInt32;
					lo:		UInt32);
			true:
				( int:	UInt64)
	end;

{$elsec}

type
	wide = record
		case boolean of
			false:
				( lo:		UInt32;
					hi:		SInt32);
			true:
				( int:	SInt64)
	end;

	UnsignedWide = record
		case boolean of
			false:
				( lo:		UInt32;
					hi:		UInt32);
			true:
				( int:	UInt64)
	end;

{$endc}  {TARGET_RT_BIG_ENDIAN}



type
    SInt8Ptr = ^SInt8;
    UInt8Ptr = ^UInt8;
    SInt16Ptr = ^SInt16;
    UInt16Ptr = ^UInt16;
    SInt32Ptr = ^SInt32;
    UInt32Ptr = ^UInt32;
    SInt64Ptr = ^SInt64;
    UInt64Ptr = ^UInt64;
    widePtr = ^wide;
    UnsignedWidePtr = ^UnsignedWide;

	{	*******************************************************************************
	
	    Special types for pascal
	    
	        ByteParameter       UInt8 passed as an 8-bit parameter
	        
	    Note:   The conventions for Pascal on 68K require that a UInt8 when
	            passed as a parameter occupy 16-bits on the stack, whereas 
	            an SInt8 would only occupy 8-bits.  To make C and Pascal
	            compatable, in pascal all function parameters of type UInt8
	            or equivalent are changed to ByteParameter.
	
	********************************************************************************	}
	ByteParameter = SInt8;

// For interfaces that use Cs "bool" type, which is a 32 bit number
	CBool = SInt32; 

{*******************************************************************************

    Base fixed point types 
    
        Fixed           16-bit signed integer plus 16-bit fraction
        UnsignedFixed   16-bit unsigned integer plus 16-bit fraction
        Fract           2-bit signed integer plus 30-bit fraction
        ShortFixed      8-bit signed integer plus 8-bit fraction
        
********************************************************************************}
type
	Fixed = SInt32;
	FixedPtr = ^Fixed;
	Fract = SInt32;
	FractPtr = ^Fract;
	UnsignedFixed = UInt32;
	UnsignedFixedPtr = ^UnsignedFixed;
	ShortFixed = SInt16;
	ShortFixedPtr = ^ShortFixed;


{*******************************************************************************

    Base floating point types 
    
        Float32         32 bit IEEE float:  1 sign bit, 8 exponent bits, 23 fraction bits
        Float64         64 bit IEEE float:  1 sign bit, 11 exponent bits, 52 fraction bits  
        Float80         80 bit MacOS float: 1 sign bit, 15 exponent bits, 1 integer bit, 63 fraction bits
        Float96         96 bit 68881 float: 1 sign bit, 15 exponent bits, 16 pad bits, 1 integer bit, 63 fraction bits
        
    Note: These are fixed size floating point types, useful when writing a floating
          point value to disk.  If your compiler does not support a particular size 
          float, a struct is used instead.
          Use of of the NCEG types (e.g. double_t) or an ANSI C type (e.g. double) if
          you want a floating point representation that is natural for any given
          compiler, but might be a different size on different compilers.

********************************************************************************}
type
	Float32 = Single;
	Float32Ptr = ^Float32;
	Float64 = Double;
	Float64Ptr = ^Float64;
	LongDouble = Double;
	Float80 = record
		exp: SInt16;
		man: array [0..3] of UInt16;
	end;

type
	Float96 = record
		exp: SInt16;
		filler: SInt16;
		man: array [0..3] of UInt16;
	end;
type
	Float32Point = record
		x: Float32;
		y: Float32;
	end;

{*******************************************************************************

    MacOS Memory Manager types
    
        Ptr             Pointer to a non-relocatable block
        Handle          Pointer to a master pointer to a relocatable block
        Size            The number of bytes in a block (signed for historical reasons)
        
********************************************************************************}
type
	Ptr = ^SInt8;
	PtrPtr = ^Ptr;       
	Handle = ^Ptr;
	Size = SInt32;
	SizePtr = ^Size;
	UnivPtr = Pointer;
	UnivPtrPtr = ^UnivPtr;

{*******************************************************************************

    Higher level basic types
    
        OSErr                   16-bit result error code
        OSStatus                32-bit result error code
        LogicalAddress          Address in the clients virtual address space
        ConstLogicalAddress     Address in the clients virtual address space that will only be read
        PhysicalAddress         Real address as used on the hardware bus
        BytePtr                 Pointer to an array of bytes
        ByteCount               The size of an array of bytes
        ByteOffset              An offset into an array of bytes
        ItemCount               32-bit iteration count
        OptionBits              Standard 32-bit set of bit flags
        PBVersion               ?
        Duration                32-bit millisecond timer for drivers
        AbsoluteTime            64-bit clock
        ScriptCode              A particular set of written characters (e.g. Roman vs Cyrillic) and their encoding
        LangCode                A particular language (e.g. English), as represented using a particular ScriptCode
        RegionCode              Designates a language as used in a particular region (e.g. British vs American
                                English) together with other region-dependent characteristics (e.g. date format)
        FourCharCode            A 32-bit value made by packing four 1 byte characters together
        OSType                  A FourCharCode used in the OS and file system (e.g. creator)
        ResType                 A FourCharCode used to tag resources (e.g. 'DLOG')
        
********************************************************************************}
type
	OSErr = SInt16;
	OSStatus = SInt32;
	LogicalAddress = UnivPtr;
	ConstLogicalAddress = UnivPtr;
	PhysicalAddress = UnivPtr;
	BytePtr = UInt8Ptr;
	ByteCount = UInt32;
 	ByteCountPtr = ^ByteCount;
	ByteOffset = UInt32;
 	ByteOffsetPtr = ^ByteOffset;
	Duration = SInt32;
	AbsoluteTime = UnsignedWide;
	AbsoluteTimePtr = ^AbsoluteTime;
	OptionBits = UInt32;
	OptionBitsPtr = ^OptionBits;
	ItemCount = UInt32;
 	ItemCountPtr = ^ItemCount;
	PBVersion = UInt32;
	ScriptCode = SInt16;
 	ScriptCodePtr = ^ScriptCode;
	LangCode = SInt16;
 	LangCodePtr = ^LangCode;
	RegionCode = SInt16;
 	RegionCodePtr = ^RegionCode;
	FourCharCode = UInt32;
	OSType = FourCharCode;
	ResType = FourCharCode;
	OSTypePtr = ^OSType;
	ResTypePtr = ^ResType;
{*******************************************************************************

    Boolean types and values
    
        Boolean         Mac OS historic type, sizeof(Boolean)==1
        bool            Defined in stdbool.h, ISO C/C++ standard type
        false           Now defined in stdbool.h
        true            Now defined in stdbool.h
        
********************************************************************************}
type
{ "Boolean", "true", and "false" are built into the Pascal language }
	BooleanPtr = ^Boolean;
{*******************************************************************************

    Function Pointer Types
    
        ProcPtr                 Generic pointer to a function
        Register68kProcPtr      Pointer to a 68K function that expects parameters in registers
        UniversalProcPtr        Pointer to classic 68K code or a RoutineDescriptor
        
        ProcHandle              Pointer to a ProcPtr
        UniversalProcHandle     Pointer to a UniversalProcPtr
        
********************************************************************************}
type
	ProcPtr = Ptr;
	Register68kProcPtr = ProcPtr;
	UniversalProcPtr = ProcPtr;

type
	ProcHandle = ^ProcPtr;
	UniversalProcHandle = ^UniversalProcPtr;


{*******************************************************************************

    Common Constants
    
        noErr                   OSErr: function performed properly - no error
        kNilOptions             OptionBits: all flags false
        kInvalidID              KernelID: NULL is for pointers as kInvalidID is for ID's
        kVariableLengthArray    array bounds: variable length array

    Note: kVariableLengthArray is used in array bounds to specify a variable length array.
          It is ususally used in variable length structs when the last field is an array
          of any size.  Before ANSI C, we used zero as the bounds of variable length 
          array, but zero length array are illegal in ANSI C.  Example usage:
    
        struct FooList 
        (
            short   listLength;
            Foo     elements[kVariableLengthArray];
        );
        
********************************************************************************}
const
	noErr = 0;

const
	kNilOptions = 0;

const
	kInvalidID = 0;
const
	kVariableLengthArray = 1;

const
	kUnknownType = $3F3F3F3F; { "????" QuickTime 3.0: default unknown ResType or OSType }


{*******************************************************************************

    String Types and Unicode Types
    
        UnicodeScalarValue,     A complete Unicode character in UTF-32 format, with
        UTF32Char               values from 0 through 0x10FFFF (excluding the surrogate
                                range 0xD800-0xDFFF and certain disallowed values).

        UniChar,                A 16-bit Unicode code value in the default UTF-16 format.
        UTF16Char               UnicodeScalarValues 0-0xFFFF are expressed in UTF-16
                                format using a single UTF16Char with the same value.
                                UnicodeScalarValues 0x10000-0x10FFFF are expressed in
                                UTF-16 format using a pair of UTF16Chars - one in the
                                high surrogate range (0xD800-0xDBFF) followed by one in
                                the low surrogate range (0xDC00-0xDFFF). All of the
                                characters defined in Unicode versions through 3.0 are
                                in the range 0-0xFFFF and can be expressed using a single
                                UTF16Char, thus the term "Unicode character" generally
                                refers to a UniChar = UTF16Char.

        UTF8Char                An 8-bit code value in UTF-8 format. UnicodeScalarValues
                                0-0x7F are expressed in UTF-8 format using one UTF8Char
                                with the same value. UnicodeScalarValues above 0x7F are
                                expressed in UTF-8 format using 2-4 UTF8Chars, all with
                                values in the range 0x80-0xF4 (UnicodeScalarValues
                                0x100-0xFFFF use two or three UTF8Chars,
                                UnicodeScalarValues 0x10000-0x10FFFF use four UTF8Chars).

        UniCharCount            A count of UTF-16 code values in an array or buffer.

        StrNNN                  Pascal string holding up to NNN bytes
        StringPtr               Pointer to a pascal string
        StringHandle            Pointer to a StringPtr
        ConstStringPtr          Pointer to a read-only pascal string
        ConstStrNNNParam        For function parameters only - means string is const
        
        CStringPtr              Pointer to a C string           (in C:  char*)
        ConstCStringPtr         Pointer to a read-only C string (in C:  const char*)
        
    Note: The length of a pascal string is stored as the first byte.
          A pascal string does not have a termination byte.
          A pascal string can hold at most 255 bytes of data.
          The first character in a pascal string is offset one byte from the start of the string. 
          
          A C string is terminated with a byte of value zero.  
          A C string has no length limitation.
          The first character in a C string is the zeroth byte of the string. 
          
        
********************************************************************************}
type
	UnicodeScalarValue = UInt32;
	UTF32Char = UInt32;
	UniChar = UInt16;
	UTF16Char = UInt16;
	UTF8Char = UInt8;
	UniCharPtr = ^UniChar;
	ConstUniCharPtr = UniCharPtr;
	UniCharCount = UInt32;
	UniCharCountPtr = ^UniCharCount;
	Str15 = STRING[15];
	Str27 = STRING[27];
	Str31 = STRING[31];
	Str32 = STRING[32];
	Str36 = STRING[36];
	Str63 = STRING[63];
	Str255 = STRING[255];
	{	
	    The type Str32 is used in many AppleTalk based data structures.
	    It holds up to 32 one byte chars.  The problem is that with the
	    length byte it is 33 bytes long.  This can cause weird alignment
	    problems in structures.  To fix this the type "Str32Field" has
	    been created.  It should only be used to hold 32 chars, but
	    it is 34 bytes long so that there are no alignment problems.
		}
    Str32Field = Str32;
	{	
	    QuickTime 3.0:
	    The type StrFileName is used to make MacOS structs work 
	    cross-platform.  For example FSSpec or SFReply previously
	    contained a Str63 field.  They now contain a StrFileName
	    field which is the same when targeting the MacOS but is
	    a 256 char buffer for Win32 and unix, allowing them to
	    contain long file names.
		}
type
	StrFileName = Str63;
	StringPtr = ^Str255;
	StringHandle = ^StringPtr;
	ConstStringPtr = StringPtr;
	CStringPtr = PChar;
	ConstCStringPtr = CStringPtr;
	CStringPtrPtr = ^CStringPtr;
	ConstCStringPtrPtr = ^ConstCStringPtr;
	ConstStr255Param = Str255;
	ConstStr63Param = Str63;
	ConstStr36Param = Str36;
	ConstStr32Param = Str32;
	ConstStr31Param = Str31;
	ConstStr27Param = Str27;
	ConstStr15Param = Str15;
	ConstStrFileNameParam = ConstStr63Param;

{*******************************************************************************

    Process Manager type ProcessSerialNumber (previously in Processes.h)

********************************************************************************}
{ type for unique process identifier }
type
	ProcessSerialNumber = record
		highLongOfPSN: UInt32;
		lowLongOfPSN: UInt32;
	end;
	ProcessSerialNumberPtr = ^ProcessSerialNumber;
{*******************************************************************************

    Quickdraw Types
    
        Point               2D Quickdraw coordinate, range: -32K to +32K
        Rect                Rectangular Quickdraw area
        Style               Quickdraw font rendering styles
        StyleParameter      Style when used as a parameter (historical 68K convention)
        StyleField          Style when used as a field (historical 68K convention)
        CharParameter       Char when used as a parameter (historical 68K convention)
        
    Note:   The original Macintosh toolbox in 68K Pascal defined Style as a SET.  
            Both Style and CHAR occupy 8-bits in packed records or 16-bits when 
            used as fields in non-packed records or as parameters. 
        
********************************************************************************}
type
	Point = record
		case SInt16 of
		0: (
			v: SInt16;
			h: SInt16;
		   );
		1: (
			vh: array [0..1] of SInt16;
			);
	end;
	PointPtr = ^Point;
type
	Rect = record
		case SInt16 of
		0: (
			top: SInt16;
			left: SInt16;
			bottom: SInt16;
			right: SInt16;
		   );
		1: (
			topLeft: Point;
			botRight: Point;
		   );
	end;
	RectPtr = ^Rect;
type
	FixedPoint = record
		x: Fixed;
		y: Fixed;
	end;
	FixedPointPtr = ^FixedPoint;
type
	FixedRect = record
		left: Fixed;
		top: Fixed;
		right: Fixed;
		bottom: Fixed;
	end;
	FixedRectPtr = ^FixedRect;

type
	CharParameter = Char;
const
	normal = 0;
	bold = 1;
	italic = 2;
	underline = 4;
	outline = 8;
	shadow = $10;
	condense = $20;
	extend = $40;

type
	Style = SInt8;
	StyleParameter = SInt16;
	StyleField = Style;


{*******************************************************************************

    QuickTime TimeBase types (previously in Movies.h)
    
        TimeValue           Count of units
        TimeScale           Units per second
        CompTimeValue       64-bit count of units (always a struct) 
        TimeValue64         64-bit count of units (long long or struct) 
        TimeBase            An opaque reference to a time base
        TimeRecord          Package of TimeBase, duration, and scale
        
********************************************************************************}
type
	TimeValue = SInt32;
	TimeScale = SInt32;
	CompTimeValue = wide;
	CompTimeValuePtr = ^CompTimeValue;
	TimeValue64 = SInt64;
	TimeValue64Ptr = ^TimeValue64;
	TimeBase = ^SInt32; { an opaque 32-bit type }
	TimeBasePtr = ^TimeBase;
	TimeRecord = record
		value: CompTimeValue;                  { units (duration or absolute) }
		scale: TimeScale;                  { units per second }
		base: TimeBase;                   { refernce to the time base }
	end;
	TimeRecordPtr = ^TimeRecord;

{*******************************************************************************

    MacOS versioning structures
    
        VersRec                 Contents of a 'vers' resource
        VersRecPtr              Pointer to a VersRecPtr
        VersRecHndl             Resource Handle containing a VersRec
        NumVersion              Packed BCD version representation (e.g. "4.2.1a3" is 0x04214003)
        UniversalProcPtr        Pointer to classic 68K code or a RoutineDescriptor
        
        ProcHandle              Pointer to a ProcPtr
        UniversalProcHandle     Pointer to a UniversalProcPtr
        
********************************************************************************}
{$ifc TARGET_RT_BIG_ENDIAN}
type
	NumVersion = packed record
{ Numeric version part of 'vers' resource }
		majorRev: UInt8;               {1st part of version number in BCD}
		minorAndBugRev: UInt8;         {2nd & 3rd part of version number share a byte}
		stage: UInt8;                  {stage code: dev, alpha, beta, final}
		nonRelRev: UInt8;              {revision level of non-released version}
	end;
{$elsec}
type
	NumVersion = packed record
{ Numeric version part of 'vers' resource accessable in little endian format }
		nonRelRev: UInt8;              {revision level of non-released version}
		stage: UInt8;                  {stage code: dev, alpha, beta, final}
		minorAndBugRev: UInt8;         {2nd & 3rd part of version number share a byte}
		majorRev: UInt8;               {1st part of version number in BCD}
	end;
{$endc}  {TARGET_RT_BIG_ENDIAN}
	NumVersionPtr = ^NumVersion;

const
{ Version Release Stage Codes }
	developStage = $20;
	alphaStage = $40;
	betaStage = $60;
	finalStage = $80;

type
	NumVersionVariant = record
		case SInt16 of
																		{  NumVersionVariant is a wrapper so NumVersion can be accessed as a 32-bit value  }
		0: (
			parts:				NumVersion;
			);
		1: (
			whole:				UInt32;
			);
	end;
	NumVersionVariantPtr = ^NumVersionVariant;
	NumVersionVariantHandle = ^NumVersionVariantPtr;
	VersRec = record
{ 'vers' resource format }
		numericVersion: NumVersion;         {encoded version number}
		countryCode: SInt16;            {country code from intl utilities}
		shortVersion: Str255;           {version number string - worst case}
		reserved: Str255;               {longMessage string packed after shortVersion}
	end;
	VersRecPtr = ^VersRec;
type
	VersRecHndl = ^VersRecPtr;
{********************************************************************************

    Old names for types
        
********************************************************************************}
type
	Byte = UInt8;
	SignedByte = SInt8;
	extended80 = Float80;
	extended80Ptr = ^extended80;
	extended96 = Float96;
	extended96Ptr = ^extended96;
	VHSelect = SInt8;
{********************************************************************************

    Debugger functions
    
********************************************************************************}
{
 *  Debugger()
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in CoreServices.framework
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 }
procedure Debugger; external name '_Debugger';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  DebugStr()
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in CoreServices.framework
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 }
procedure DebugStr( const (*var*) debuggerMsg: Str255 ); external name '_DebugStr';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  debugstr()
 *  
 *  Availability:
 *    Mac OS X:         not available
 *    CarbonLib:        not available
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 }


{ Only for Mac OS native drivers }
{
 *  SysDebug()
 *  
 *  Availability:
 *    Mac OS X:         not available
 *    CarbonLib:        not available
 *    Non-Carbon CFM:   in DriverServicesLib 1.0 and later
 }


{
 *  SysDebugStr()
 *  
 *  Availability:
 *    Mac OS X:         not available
 *    CarbonLib:        not available
 *    Non-Carbon CFM:   in DriverServicesLib 1.0 and later
 }



{ SADE break points }
{
 *  SysBreak()
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in CoreServices.framework
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 }
procedure SysBreak; external name '_SysBreak';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  SysBreakStr()
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in CoreServices.framework
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 }
procedure SysBreakStr( const (*var*) debuggerMsg: Str255 ); external name '_SysBreakStr';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  SysBreakFunc()
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in CoreServices.framework
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 }
procedure SysBreakFunc( const (*var*) debuggerMsg: Str255 ); external name '_SysBreakFunc';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)






{unit Math64}
{
     File:       Math64.p
 
     Contains:   64-bit SInt16 math Interfaces.
 
     Version:    Technology: Mac OS 9
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   1994-2002 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}


{
 *  S64Max()
 *  
 *  Discussion:
 *    Returns largest possible SInt64 value
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function S64Max: SInt64; external name '_S64Max';

{
 *  S64Min()
 *  
 *  Discussion:
 *    Returns smallest possible SInt64 value
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function S64Min: SInt64; external name '_S64Min';


{
 *  S64Add()
 *  
 *  Discussion:
 *    Adds two integers, producing an SInt16 result.  If an overflow
 *    occurs the result is congruent mod (2^64) as if the operands and
 *    result were unsigned.  No overflow is signaled.
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function S64Add(left: SInt64; right: SInt64): SInt64; external name '_S64Add';


{
 *  S64Subtract()
 *  
 *  Discussion:
 *    Subtracts two integers, producing an SInt16 result.  If an
 *    overflow occurs the result is congruent mod (2^64) as if the
 *    operands and result were unsigned.  No overflow is signaled.
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function S64Subtract(left: SInt64; right: SInt64): SInt64; external name '_S64Subtract';


{
 *  S64Negate()
 *  
 *  Discussion:
 *    Returns the additive inverse of a signed number (i.e. it returns
 *    0 - the number).  S64Negate (S64Min) is not representable (in
 *    fact, it returns S64Min).
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function S64Negate(value: SInt64): SInt64; external name '_S64Negate';


{$ifc NOT TYPE_LONGLONG}
{
 *  S64Absolute()
 *  
 *  Discussion:
 *    Returns the absolute value of the number (i.e. the number if it
 *    is positive, or 0 - the number if it is negative). Disabled for
 *    compilers that support long long until llabs() is available
 *    everywhere.
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function S64Absolute(value: SInt64): SInt64; external name '_S64Absolute';

{$endc}

{
 *  S64Multiply()
 *  
 *  Discussion:
 *    Multiplies two signed numbers, producing a signed result. 
 *    Overflow is ignored and the low-order part of the product is
 *    returned.  The sign of the result is not guaranteed to be correct
 *    if the magnitude of the product is not representable.
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function S64Multiply(left: SInt64; right: SInt64): SInt64; external name '_S64Multiply';


{$ifc CALL_NOT_IN_CARBON}
{
 *  S64Mod()
 *  
 *  Discussion:
 *    Returns the remainder of divide of dividend by divisor.  The sign
 *    of the remainder is the same as the sign of the dividend (i.e.,
 *    it takes the absolute values of the operands, does the division,
 *    then fixes the sign of the quotient and remainder).
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function S64Mod(dividend: SInt64; divisor: SInt64): SInt64; external name '_S64Mod';


{$endc}  {CALL_NOT_IN_CARBON}

{
 *  S64Divide()
 *  
 *  Discussion:
 *    Divides dividend by divisor, returning the quotient.  The
 *    remainder is returned in *remainder if remainder (the pointer) is
 *    non-NULL. The sign of the remainder is the same as the sign of
 *    the dividend (i.e. it takes the absolute values of the operands,
 *    does the division, then fixes the sign of the quotient and
 *    remainder).  If the divisor is zero, then S64Max() will be
 *    returned (or S64Min() if the dividend is negative), and the
 *    remainder will be the dividend; no error is reported.
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function S64Divide(dividend: SInt64; divisor: SInt64; remainder: SInt64Ptr): SInt64; external name '_S64Divide';


{
 *  S64Set()
 *  
 *  Discussion:
 *    Given an SInt32, returns an SInt64 with the same value.  Use this
 *    routine instead of coding 64-bit constants (at least when the
 *    constant will fit in an SInt32).
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function S64Set(value: SInt32): SInt64; external name '_S64Set';


{
 *  S64SetU()
 *  
 *  Discussion:
 *    Given a UInt32, returns a SInt64 with the same value.
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function S64SetU(value: UInt32): SInt64; external name '_S64SetU';

{
 *  S32Set()
 *  
 *  Discussion:
 *    Given an SInt64, returns an SInt32 by discarding the high-order
 *    32 bits.
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function S32Set(value: SInt64): SInt32; external name '_S32Set';


{
 *  S64And()
 *  
 *  Discussion:
 *    Returns one if left and right are non-zero, otherwise returns zero
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function S64And(left: SInt64; right: SInt64): boolean; external name '_S64And';


{
 *  S64Or()
 *  
 *  Discussion:
 *    Returns one if left or right are non-zero, otherwise returns zero
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function S64Or(left: SInt64; right: SInt64): boolean; external name '_S64Or';


{
 *  S64Eor()
 *  
 *  Discussion:
 *    Returns one if left xor right are non-zero, otherwise returns zero
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function S64Eor(left: SInt64; right: SInt64): boolean; external name '_S64Eor';


{
 *  S64Not()
 *  
 *  Discussion:
 *    Returns one if value is non-zero, otherwisze returns zero.
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function S64Not(value: SInt64): boolean; external name '_S64Not';


{
 *  S64Compare()
 *  
 *  Discussion:
 *    Given two signed numbers, left and right, returns an SInt32 that
 *    compares with zero the same way left compares with right.  If you
 *    wanted to perform a comparison on 64-bit integers of the
 *    form:
 *    operand_1 <operation> operand_2
 *    then you could use an expression of the form:
 *     xxxS64Compare(operand_1,operand_2) <operation> 0
 *    to test for the same condition. CAUTION: DO NOT depend on the
 *    exact value returned by this routine. Only the sign (i.e.
 *    positive, zero, or negative) of the result is guaranteed.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function S64Compare(left: SInt64; right: SInt64): SInt32; external name '_S64Compare';


{
 *  S64BitwiseAnd()
 *  
 *  Discussion:
 *    bitwise AND
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function S64BitwiseAnd(left: SInt64; right: SInt64): SInt64; external name '_S64BitwiseAnd';


{
 *  S64BitwiseOr()
 *  
 *  Discussion:
 *    bitwise OR
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function S64BitwiseOr(left: SInt64; right: SInt64): SInt64; external name '_S64BitwiseOr';


{
 *  S64BitwiseEor()
 *  
 *  Discussion:
 *    bitwise XOR
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function S64BitwiseEor(left: SInt64; right: SInt64): SInt64; external name '_S64BitwiseEor';


{
 *  S64BitwiseNot()
 *  
 *  Discussion:
 *    bitwise negate
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function S64BitwiseNot(value: SInt64): SInt64; external name '_S64BitwiseNot';


{
 *  S64ShiftRight()
 *  
 *  Discussion:
 *    Arithmetic shift of value by the lower 7 bits of the shift.
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function S64ShiftRight(value: SInt64; shift: UInt32): SInt64; external name '_S64ShiftRight';


{
 *  S64ShiftLeft()
 *  
 *  Discussion:
 *    Logical shift of value by the lower 7 bits of the shift.
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function S64ShiftLeft(value: SInt64; shift: UInt32): SInt64; external name '_S64ShiftLeft';


{
 *  U64Max()
 *  
 *  Discussion:
 *    Returns largest possible UInt64 value
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function U64Max: UInt64; external name '_U64Max';

{
 *  U64Add()
 *  
 *  Discussion:
 *    Adds two unsigned integers, producing an SInt16 result.  If an
 *    overflow occurs the result is congruent mod (2^64) as if the
 *    operands and result were unsigned.  No overflow is signaled.
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function U64Add(left: UInt64; right: UInt64): UInt64; external name '_U64Add';

{
 *  U64Subtract()
 *  
 *  Discussion:
 *    Subtracts two unsigned integers, producing an SInt16 result.  If
 *    an overflow occurs the result is congruent mod (2^64) as if the
 *    operands and result were unsigned.  No overflow is signaled.
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function U64Subtract(left: UInt64; right: UInt64): UInt64; external name '_U64Subtract';


{
 *  U64Multiply()
 *  
 *  Discussion:
 *    Multiplies two unsigned numbers, producing a signed result. 
 *    Overflow is ignored and the low-order part of the product is
 *    returned.  The sign of the result is not guaranteed to be correct
 *    if the magnitude of the product is not representable.
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function U64Multiply(left: UInt64; right: UInt64): UInt64; external name '_U64Multiply';


{$ifc CALL_NOT_IN_CARBON}
{
 *  U64Mod()
 *  
 *  Discussion:
 *    Returns the remainder of divide of dividend by divisor.  The sign
 *    of the remainder is the same as the sign of the dividend (i.e.,
 *    it takes the absolute values of the operands, does the division,
 *    then fixes the sign of the quotient and remainder).
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function U64Mod(dividend: UInt64; divisor: UInt64): UInt64; external name '_U64Mod';


{$endc}  {CALL_NOT_IN_CARBON}

{
 *  U64Divide()
 *  
 *  Discussion:
 *    Divides dividend by divisor, returning the quotient.  The
 *    remainder is returned in *remainder if remainder (the pointer) is
 *    non-NULL. The sign of the remainder is the same as the sign of
 *    the dividend (i.e. it takes the absolute values of the operands,
 *    does the division, then fixes the sign of the quotient and
 *    remainder).  If the divisor is zero, then U64Max() will be
 *    returned (or U64Min() if the dividend is negative), and the
 *    remainder will be the dividend; no error is reported.
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function U64Divide(dividend: UInt64; divisor: UInt64; remainder: UInt64Ptr): UInt64; external name '_U64Divide';


{
 *  U64Set()
 *  
 *  Discussion:
 *    Given an SInt32, returns an UInt64 with the same value.  Use this
 *    routine instead of coding 64-bit constants (at least when the
 *    constant will fit in an SInt32).
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function U64Set(value: SInt32): UInt64; external name '_U64Set';


{
 *  U64SetU()
 *  
 *  Discussion:
 *    Given a UInt32, returns a UInt64 with the same value.
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function U64SetU(value: UInt32): UInt64; external name '_U64SetU';

{
 *  U32SetU()
 *  
 *  Discussion:
 *    Given an UInt64, returns an UInt32 by discarding the high-order
 *    32 bits.
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function U32SetU(value: UInt64): UInt32; external name '_U32SetU';


{
 *  U64And()
 *  
 *  Discussion:
 *    Returns one if left and right are non-zero, otherwise returns zero
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function U64And(left: UInt64; right: UInt64): boolean; external name '_U64And';


{
 *  U64Or()
 *  
 *  Discussion:
 *    Returns one if left or right are non-zero, otherwise returns zero
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function U64Or(left: UInt64; right: UInt64): boolean; external name '_U64Or';


{
 *  U64Eor()
 *  
 *  Discussion:
 *    Returns one if left xor right are non-zero, otherwise returns zero
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function U64Eor(left: UInt64; right: UInt64): boolean; external name '_U64Eor';


{
 *  U64Not()
 *  
 *  Discussion:
 *    Returns one if value is non-zero, otherwisze returns zero.
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function U64Not(value: UInt64): boolean; external name '_U64Not';


{
 *  U64Compare()
 *  
 *  Discussion:
 *    Given two unsigned numbers, left and right, returns an SInt32
 *    that compares with zero the same way left compares with right. 
 *    If you wanted to perform a comparison on 64-bit integers of the
 *    form:
 *    operand_1 <operation> operand_2
 *    then you could use an expression of the form:
 *     xxxU64Compare(operand_1,operand_2) <operation> 0
 *    to test for the same condition. CAUTION: DO NOT depend on the
 *    exact value returned by this routine. Only the sign (i.e.
 *    positive, zero, or negative) of the result is guaranteed.
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function U64Compare(left: UInt64; right: UInt64): SInt32; external name '_U64Compare';

{
 *  U64BitwiseAnd()
 *  
 *  Discussion:
 *    bitwise AND
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function U64BitwiseAnd(left: UInt64; right: UInt64): UInt64; external name '_U64BitwiseAnd';


{
 *  U64BitwiseOr()
 *  
 *  Discussion:
 *    bitwise OR
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function U64BitwiseOr(left: UInt64; right: UInt64): UInt64; external name '_U64BitwiseOr';


{
 *  U64BitwiseEor()
 *  
 *  Discussion:
 *    bitwise XOR
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function U64BitwiseEor(left: UInt64; right: UInt64): UInt64; external name '_U64BitwiseEor';


{
 *  U64BitwiseNot()
 *  
 *  Discussion:
 *    bitwise negate
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function U64BitwiseNot(value: UInt64): UInt64; external name '_U64BitwiseNot';


{
 *  U64ShiftRight()
 *  
 *  Discussion:
 *    Arithmetic shift of value by the lower 7 bits of the shift.
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function U64ShiftRight(value: UInt64; shift: UInt32): UInt64; external name '_U64ShiftRight';


{
 *  U64ShiftLeft()
 *  
 *  Discussion:
 *    Logical shift of value by the lower 7 bits of the shift.
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function U64ShiftLeft(value: UInt64; shift: UInt32): UInt64; external name '_U64ShiftLeft';


{
 *  UInt64ToSInt64()
 *  
 *  Discussion:
 *    converts UInt64 -> SInt64
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function UInt64ToSInt64(value: UInt64): SInt64; external name '_UInt64ToSInt64';


{
 *  SInt64ToUInt64()
 *  
 *  Discussion:
 *    converts SInt64 -> UInt64
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function SInt64ToUInt64(value: SInt64): UInt64; external name '_SInt64ToUInt64';


{$ALIGN MAC68K}


{unit MixedMode}
{
     File:       CarbonCore/MixedMode.h
 
     Contains:   Mixed Mode Manager Interfaces.
 
     Version:    CarbonCore-654.0.85~1
 
     Copyright:   1992-2005 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}
{      Pascal Translation Updated:  Peter N Lewis, <peter@stairways.com.au>, November 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}

{
    ===========================================================================
    
    Notes on Mixed Mode and Mac OS X
    
    Mac OS X doesn't have mixed mode, nor the Mixed Mode Manager, because
    everything running is PowerPC code.  Therefore, there is little need for
    anything in this file unless the code still needs to run on Mac OS 9.x
    CarbonLib, and on Mac OS X.

    =========================================================================== 
}
{ Mixed Mode constants }
{ Current Routine Descriptor Version }
const
	kRoutineDescriptorVersion = 7;

{ MixedModeMagic Magic Cookie/Trap number }
const
	_MixedModeMagic = $AAFE;

{ MixedModeState Version for CFM68K Mixed Mode }
const
	kCurrentMixedModeStateRecord = 1;

{ Calling Conventions }
type
	CallingConventionType = UInt16;
const
	kPascalStackBased = 0;
	kCStackBased = 1;
	kRegisterBased = 2;
	kD0DispatchedPascalStackBased = 8;
	kD1DispatchedPascalStackBased = 12;
	kD0DispatchedCStackBased = 9;
	kStackDispatchedPascalStackBased = 14;
	kThinkCStackBased = 5;

{ ISA Types }
type
	ISAType = SInt8;
const
	kM68kISA = 0;
	kPowerPCISA = 1;

const
	kX86ISA = 2;

{ RTA Types }
type
	RTAType = SInt8;
const
	kOld68kRTA = 0 shl 4;
	kPowerPCRTA = 0 shl 4;
	kCFM68kRTA = 1 shl 4;

const
	kX86RTA = 2 shl 4;


const
{$ifc TARGET_CPU_PPC}
	GetCurrentISA = kPowerPCISA;
	GetCurrentRTA = kPowerPCRTA;
{$elsec}
	{$ifc TARGET_CPU_X86}
		GetCurrentISA = kX86ISA;
		GetCurrentRTA = kX86RTA;
	{$endc}
{$endc}
	GetCurrentArchitecture = GetCurrentISA or GetCurrentRTA;

{ Constants for specifing 68k registers }
const
	kRegisterD0 = 0;
	kRegisterD1 = 1;
	kRegisterD2 = 2;
	kRegisterD3 = 3;
	kRegisterD4 = 8;
	kRegisterD5 = 9;
	kRegisterD6 = 10;
	kRegisterD7 = 11;
	kRegisterA0 = 4;
	kRegisterA1 = 5;
	kRegisterA2 = 6;
	kRegisterA3 = 7;
	kRegisterA4 = 12;
	kRegisterA5 = 13;
	kRegisterA6 = 14;   { A7 is the same as the PowerPC SP }
	kCCRegisterCBit = 16;
	kCCRegisterVBit = 17;
	kCCRegisterZBit = 18;
	kCCRegisterNBit = 19;
	kCCRegisterXBit = 20;

type
	registerSelectorType = UInt16;
{ SizeCodes we use everywhere }
const
	kNoByteCode = 0;
	kOneByteCode = 1;
	kTwoByteCode = 2;
	kFourByteCode = 3;

{ Mixed Mode Routine Records }
type
	ProcInfoType = UInt32;
{ Routine Flag Bits }
type
	RoutineFlagsType = UInt16;
const
	kProcDescriptorIsAbsolute = $00;
	kProcDescriptorIsRelative = $01;

const
	kFragmentIsPrepared = $00;
	kFragmentNeedsPreparing = $02;

const
	kUseCurrentISA = $00;
	kUseNativeISA = $04;

const
	kPassSelector = $00;
	kDontPassSelector = $08;

const
	kRoutineIsNotDispatchedDefaultRoutine = $00;
	kRoutineIsDispatchedDefaultRoutine = $10;

const
	kProcDescriptorIsProcPtr = $00;
	kProcDescriptorIsIndex = $20;

type
	RoutineRecord = record
		procInfo: ProcInfoType;               { calling conventions }
		reserved1: SInt8;              { Must be 0 }
		ISA: ISAType;                    { Instruction Set Architecture }
		routineFlags: RoutineFlagsType;           { Flags for each routine }
		procDescriptor: ProcPtr;         { Where is the thing were calling? }
		reserved2: UInt32;              { Must be 0 }
		selector: UInt32;               { For dispatched routines, the selector }
	end;
	RoutineRecordPtr = ^RoutineRecord;
	RoutineRecordHandle = ^RoutineRecordPtr;
{ Mixed Mode Routine Descriptors }
{ Definitions of the Routine Descriptor Flag Bits }
type
	RDFlagsType = UInt8;
const
	kSelectorsAreNotIndexable = $00;
	kSelectorsAreIndexable = $01;

{ Routine Descriptor Structure }
type
	RoutineDescriptor = record
		goMixedModeTrap: UInt16;        { Our A-Trap }
		version: SInt8;                { Current Routine Descriptor version }
		routineDescriptorFlags: RDFlagsType; { Routine Descriptor Flags }
		reserved1: UInt32;              { Unused, must be zero }
		reserved2: UInt8;              { Unused, must be zero }
		selectorInfo: UInt8;           { If a dispatched routine, calling convention, else 0 }
		routineCount: UInt16;           { Number of routines in this RD }
		routineRecords: array [0..0] of RoutineRecord;      { The individual routines }
	end;
	RoutineDescriptorPtr = ^RoutineDescriptor;
	RoutineDescriptorHandle= ^RoutineDescriptorPtr;
{ 68K MixedModeStateRecord }
type
	MixedModeStateRecordPtr = ^MixedModeStateRecord;
	MixedModeStateRecord = record
		state1: UInt32;
		state2: UInt32;
		state3: UInt32;
		state4: UInt32;
	end;
{
 *  NewRoutineDescriptor()   *** DEPRECATED ***
 *  
 *  Discussion:
 *    This function is deprecated on Mac OS X and in CarbonLib because
 *    routine descriptors existed to allow 68k code and PowerPC code to
 *    call each other and get parameter marshalling and other OS
 *    services.  Mac OS X is entirely PowerPC native, and does not
 *    require the use of mixed mode.
 *    You should remove any calls to NewRoutineDescriptor() from your
 *    sources, and replace them with theProc parameter itself.
 *  
 *  Availability:
 *    Mac OS X:         not available but deprecated in 10.4
 *    CarbonLib:        not available
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 }


{
 *  DisposeRoutineDescriptor()   *** DEPRECATED ***
 *  
 *  Discussion:
 *    DisposeRoutineDescriptor() is deprecated on Mac OS X. 
 *    RoutineDescriptors are no longer used.
 *    You should delete any calls to DisposeRoutineDescriptor() from
 *    your sources.
 *  
 *  Availability:
 *    Mac OS X:         not available but deprecated in 10.4
 *    CarbonLib:        not available
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 }

function NewRoutineDescriptor( theProc: ProcPtr; theProcInfo: ProcInfoType; theISA: ISAType ): UniversalProcPtr; inline;
procedure DisposeRoutineDescriptor( theUPP: UniversalProcPtr ); inline;

{ Mixed Mode ProcInfos }
const
{ Calling Convention Offsets }
	kCallingConventionWidth = 4;
	kCallingConventionPhase = 0;
	kCallingConventionMask = $0F; { Result Offsets }
	kResultSizeWidth = 2;
	kResultSizePhase = kCallingConventionWidth;
	kResultSizeMask = $30; { Parameter offsets & widths }
	kStackParameterWidth = 2;
	kStackParameterPhase = kCallingConventionWidth + kResultSizeWidth;
	kStackParameterMask = $FFFFFFC0; { Register Result Location offsets & widths }
	kRegisterResultLocationWidth = 5;
	kRegisterResultLocationPhase = kCallingConventionWidth + kResultSizeWidth; { Register Parameter offsets & widths }
	kRegisterParameterWidth = 5;
	kRegisterParameterPhase = kCallingConventionWidth + kResultSizeWidth + kRegisterResultLocationWidth;
	kRegisterParameterMask = $7FFFF800;
	kRegisterParameterSizePhase = 0;
	kRegisterParameterSizeWidth = 2;
	kRegisterParameterWhichPhase = kRegisterParameterSizeWidth;
	kRegisterParameterWhichWidth = 3;    { Dispatched Stack Routine Selector offsets & widths }
	kDispatchedSelectorSizeWidth = 2;
	kDispatchedSelectorSizePhase = kCallingConventionWidth + kResultSizeWidth; { Dispatched Stack Routine Parameter offsets }
	kDispatchedParameterPhase = kCallingConventionWidth + kResultSizeWidth + kDispatchedSelectorSizeWidth; { Special Case offsets & widths }
	kSpecialCaseSelectorWidth = 6;
	kSpecialCaseSelectorPhase = kCallingConventionWidth;
	kSpecialCaseSelectorMask = $03F0;

const
	kSpecialCase = $000F; { (CallingConventionType) }

const
{ all of the special cases enumerated.  The selector field is 6 bits wide }
	kSpecialCaseHighHook = 0;
	kSpecialCaseCaretHook = 0;    { same as kSpecialCaseHighHook }
	kSpecialCaseEOLHook = 1;
	kSpecialCaseWidthHook = 2;
	kSpecialCaseTextWidthHook = 2;    { same as kSpecialCaseWidthHook }
	kSpecialCaseNWidthHook = 3;
	kSpecialCaseDrawHook = 4;
	kSpecialCaseHitTestHook = 5;
	kSpecialCaseTEFindWord = 6;
	kSpecialCaseProtocolHandler = 7;
	kSpecialCaseSocketListener = 8;
	kSpecialCaseTERecalc = 9;
	kSpecialCaseTEDoText = 10;
	kSpecialCaseGNEFilterProc = 11;
	kSpecialCaseMBarHook = 12;


{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
 *
 *  Macros for building ProcInfos.  Examples:
 *  
 *  
 *  uppModalFilterProcInfo = kPascalStackBased
 *       | RESULT_SIZE(SIZE_CODE(sizeof(Boolean)))
 *       | STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(DialogRef)))
 *       | STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(EventRecord*)))
 *       | STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(short*))),
 *
 *  uppDeskHookProcInfo = kRegisterBased
 *       | REGISTER_ROUTINE_PARAMETER(1, kRegisterD0, SIZE_CODE(sizeof(Boolean)))
 *       | REGISTER_ROUTINE_PARAMETER(2, kRegisterA0, SIZE_CODE(sizeof(EventRecord*)))
 *
 *  uppGXSpoolResourceProcInfo = kCStackBased
 *       | RESULT_SIZE(SIZE_CODE(sizeof(OSErr)))
 *       | STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(gxSpoolFile)))
 *       | STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(Handle)))
 *       | STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(ResType)))
 *       | STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(long)))
 *
 *  uppTEFindWordProcInfo = SPECIAL_CASE_PROCINFO( 6 ),
 *
 }


// Lots of #defines not converted over, request if needed.


{unit Multiprocessing}
{
     File:       Multiprocessing.p
 
     Contains:   Multiprocessing interfaces
 
     Version:    Technology: Multiprocessing API version 2.4, integrated NanoKernel support
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   1995-2002 DayStar Digital, Inc.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
   ===========================================================================================
   *** WARNING: You must properly check the availability of MP services before calling them!
   See the section titled "Checking API Availability".
   ===========================================================================================
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN POWER}


{
   ===========================================================================================
   This is the header file for version 2.4 of the Mac OS multiprocessing support.  This version
   has been totally reimplemented and has significant new services.  The main goal of the
   reimplementation has been to transfer task management into the core operating system to provide
   much more reliable and more efficient operation, including on single processor machines.
   The memory management has also been massively improved, it is much faster and wastes much
   less space.  New services include POSIX style per-task storage, timers with millisecond and
   microsecond resolutions, memory allocation at a specified alignment, and system pageable
   and RAM resident memory pools.  See the MP API documentation for details.
   The old "DayStar" debugging services (whose names began with an underscore) have been
   removed from this header.  A very few are still implemented for binary compatibility, or in
   cases where they happened to be exposed inappropriately.  (E.g. _MPIsFullyInitialized must
   be called to see if the MP API is ReallyTruly usable.)  New code and recompiles of old
   code should avoid use of these defunct services, except for _MPIsFullyInitialized.
   ===========================================================================================
}


{
   ===========================================================================================
   The following services are from the original MP API and remain supported in version 2.0:
    MPProcessors
    MPCreateTask
    MPTerminateTask
    MPCurrentTaskID
    MPYield
    MPExit
    MPCreateQueue
    MPDeleteQueue
    MPNotifyQueue
    MPWaitOnQueue
    MPCreateSemaphore
    MPCreateBinarySemaphore     (In C only, a macro that calls MPCreateSemaphore.)
    MPDeleteSemaphore
    MPSignalSemaphore
    MPWaitOnSemaphore
    MPCreateCriticalRegion
    MPDeleteCriticalRegion
    MPEnterCriticalRegion
    MPExitCriticalRegion
    MPAllocate                  (Deprecated, use MPAllocateAligned for new builds.)
    MPFree
    MPBlockCopy
    MPLibraryIsLoaded           (In C only, a macro.)
    _MPIsFullyInitialized       (See comments about checking for MP API availability.)
   ===========================================================================================
}


{
   ===========================================================================================
   The following services are new in version 2.0:
    MPProcessorsScheduled
    MPSetTaskWeight
    MPTaskIsPreemptive
    MPAllocateTaskStorageIndex
    MPDeallocateTaskStorageIndex
    MPSetTaskStorageValue
    MPGetTaskStorageValue
    MPSetQueueReserve
    MPCreateEvent
    MPDeleteEvent
    MPSetEvent
    MPWaitForEvent
    UpTime
    DurationToAbsolute
    AbsoluteToDuration
    MPDelayUntil
    MPCreateTimer
    MPDeleteTimer
    MPSetTimerNotify
    MPArmTimer
    MPCancelTimer
    MPSetExceptionHandler
    MPThrowException
    MPDisposeTaskException
    MPExtractTaskState
    MPSetTaskState
    MPRegisterDebugger
    MPUnregisterDebugger
    MPAllocateAligned           (Preferred over MPAllocate.)
    MPGetAllocatedBlockSize
    MPBlockClear
    MPDataToCode
    MPRemoteCall                (Preferred over _MPRPC.)
   ===========================================================================================
}


{
   ===========================================================================================
   The following services are new in version 2.1:
    MPCreateNotification
    MPDeleteNotification
    MPModifyNotification
    MPCauseNotification
    MPGetNextTaskID
    MPGetNextCpuID
   ===========================================================================================
}


{
   ===========================================================================================
   The following services are "unofficial" extensions to the original API.  They are not in
   the multiprocessing API documentation, but were in previous versions of this header.  They
   remain supported in version 2.0.  They may not be supported in other environments.
    _MPRPC                      (Deprecated, use MPRemoteCall for new builds.)
    _MPAllocateSys              (Deprecated, use MPAllocateAligned for new builds.)
    _MPTaskIsToolboxSafe
    _MPLibraryVersion
    _MPLibraryIsCompatible
   ===========================================================================================
}


{
   ===========================================================================================
   The following services were in previous versions of this header for "debugging only" use.
   They are NOT implemented in version 2.0.  For old builds they can be accessed by defining
   the symbol MPIncludeDefunctServices to have a nonzero value.
    _MPInitializePrintf
    _MPPrintf
    _MPDebugStr
    _MPStatusPString
    _MPStatusCString
   ===========================================================================================
}


{
   
   ===========================================================================================
   General Types and Constants
   ===========================
}


const
	MPLibrary_MajorVersion		= 2;							{  ! When these change be sure to update the build versions }
	MPLibrary_MinorVersion		= 4;							{  !  used in the startup check in MPInitializeAPI! }
	MPLibrary_Release			= 1;
	MPLibrary_DevelopmentRevision = 1;


type
	MPProcessID    = ^SInt32; { an opaque 32-bit type }
	MPProcessIDPtr = ^MPProcessID;  { when a var xx:MPProcessID parameter can be nil, it is changed to xx: MPProcessIDPtr }
	MPTaskID    = ^SInt32; { an opaque 32-bit type }
	MPTaskIDPtr = ^MPTaskID;  { when a var xx:MPTaskID parameter can be nil, it is changed to xx: MPTaskIDPtr }
	MPQueueID    = ^SInt32; { an opaque 32-bit type }
	MPQueueIDPtr = ^MPQueueID;  { when a var xx:MPQueueID parameter can be nil, it is changed to xx: MPQueueIDPtr }
	MPSemaphoreID    = ^SInt32; { an opaque 32-bit type }
	MPSemaphoreIDPtr = ^MPSemaphoreID;  { when a var xx:MPSemaphoreID parameter can be nil, it is changed to xx: MPSemaphoreIDPtr }
	MPCriticalRegionID    = ^SInt32; { an opaque 32-bit type }
	MPCriticalRegionIDPtr = ^MPCriticalRegionID;  { when a var xx:MPCriticalRegionID parameter can be nil, it is changed to xx: MPCriticalRegionIDPtr }
	MPTimerID    = ^SInt32; { an opaque 32-bit type }
	MPTimerIDPtr = ^MPTimerID;  { when a var xx:MPTimerID parameter can be nil, it is changed to xx: MPTimerIDPtr }
	MPEventID    = ^SInt32; { an opaque 32-bit type }
	MPEventIDPtr = ^MPEventID;  { when a var xx:MPEventID parameter can be nil, it is changed to xx: MPEventIDPtr }
	MPAddressSpaceID    = ^SInt32; { an opaque 32-bit type }
	MPAddressSpaceIDPtr = ^MPAddressSpaceID;  { when a var xx:MPAddressSpaceID parameter can be nil, it is changed to xx: MPAddressSpaceIDPtr }
	MPNotificationID    = ^SInt32; { an opaque 32-bit type }
	MPNotificationIDPtr = ^MPNotificationID;  { when a var xx:MPNotificationID parameter can be nil, it is changed to xx: MPNotificationIDPtr }
	MPCoherenceID    = ^SInt32; { an opaque 32-bit type }
	MPCoherenceIDPtr = ^MPCoherenceID;  { when a var xx:MPCoherenceID parameter can be nil, it is changed to xx: MPCoherenceIDPtr }
	MPCpuID    = ^SInt32; { an opaque 32-bit type }
	MPCpuIDPtr = ^MPCpuID;  { when a var xx:MPCpuID parameter can be nil, it is changed to xx: MPCpuIDPtr }
	MPAreaID    = ^SInt32; { an opaque 32-bit type }
	MPAreaIDPtr = ^MPAreaID;  { when a var xx:MPAreaID parameter can be nil, it is changed to xx: MPAreaIDPtr }
	MPConsoleID    = ^SInt32; { an opaque 32-bit type }
	MPConsoleIDPtr = ^MPConsoleID;  { when a var xx:MPConsoleID parameter can be nil, it is changed to xx: MPConsoleIDPtr }
	MPOpaqueID    = ^SInt32; { an opaque 32-bit type }
	MPOpaqueIDPtr = ^MPOpaqueID;  { when a var xx:MPOpaqueID parameter can be nil, it is changed to xx: MPOpaqueIDPtr }

const
																{  Values for MPOpaqueIDClass. }
	kOpaqueAnyID				= 0;
	kOpaqueProcessID			= 1;
	kOpaqueTaskID				= 2;
	kOpaqueTimerID				= 3;
	kOpaqueQueueID				= 4;
	kOpaqueSemaphoreID			= 5;
	kOpaqueCriticalRegionID		= 6;
	kOpaqueCpuID				= 7;
	kOpaqueAddressSpaceID		= 8;
	kOpaqueEventID				= 9;
	kOpaqueCoherenceID			= 10;
	kOpaqueAreaID				= 11;
	kOpaqueNotificationID		= 12;
	kOpaqueConsoleID			= 13;


type
	MPOpaqueIDClass						= UInt32;


const
	kMPNoID						= 0;							{  New code should use kInvalidID everywhere. }


type
	MPTaskOptions						= OptionBits;
	TaskStorageIndex					= UInt32;
	TaskStorageValue					= UInt32;
	MPSemaphoreCount					= ItemCount;
	MPTaskWeight						= UInt32;
	MPEventFlags						= UInt32;
	MPEventFlagsPtr						= ^MPEventFlags; { when a VAR xx: MPEventFlags parameter can be nil, it is changed to xx: MPEventFlagsPtr }
	MPExceptionKind						= UInt32;
	MPTaskStateKind						= UInt32;
	MPPageSizeClass						= UInt32;


const
	kDurationImmediate			= 0;
	kDurationForever			= $7FFFFFFF;
	kDurationMillisecond		= 1;
	kDurationMicrosecond		= -1;


	{
	   
	   ===========================================================================================
	   Process/Processor Services
	   ==========================
	}


	{
	 *  MPProcessors()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 and later
	 	}
function MPProcessors: ItemCount; external name '_MPProcessors';

{  The physical total. }

{
 *  MPProcessorsScheduled()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPProcessorsScheduled: ItemCount; external name '_MPProcessorsScheduled';

{  Those currently in use. }

{
   
   ===========================================================================================
   Tasking Services
   ================
}


const
																{  For MPCreateTask options }
	kMPCreateTaskTakesAllExceptionsMask = $00000002;
	kMPCreateTaskNotDebuggableMask = $00000004;
	kMPCreateTaskValidOptionsMask = $00000006;


	{  ------------------------------------------------------------------------------------------- }


type
{$ifc TYPED_FUNCTION_POINTERS}
	TaskProc = function(parameter: UnivPtr): OSStatus;
{$elsec}
	TaskProc = ProcPtr;
{$endc}


	{
	 *  MPCreateTask()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 and later
	 	}
function MPCreateTask(entryPoint: TaskProc; parameter: UnivPtr; stackSize: ByteCount; notifyQueue: MPQueueID; terminationParameter1: UnivPtr; terminationParameter2: UnivPtr; options: MPTaskOptions; task: MPTaskIDPtr): OSStatus; external name '_MPCreateTask';


{
 *  MPTerminateTask()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPTerminateTask(task: MPTaskID; terminationStatus: OSStatus): OSStatus; external name '_MPTerminateTask';


{
 *  MPSetTaskWeight()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPSetTaskWeight(task: MPTaskID; weight: MPTaskWeight): OSStatus; external name '_MPSetTaskWeight';


{
 *  MPTaskIsPreemptive()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPTaskIsPreemptive(taskID: MPTaskID): boolean; external name '_MPTaskIsPreemptive';

{  May be kInvalidID. }

{
 *  MPExit()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure MPExit(status: OSStatus); external name '_MPExit';


{
 *  MPYield()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure MPYield; external name '_MPYield';


{
 *  MPCurrentTaskID()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPCurrentTaskID: MPTaskID; external name '_MPCurrentTaskID';


{
 *  MPSetTaskType()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.3 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPSetTaskType(task: MPTaskID; taskType: OSType): OSStatus; external name '_MPSetTaskType';


{  ------------------------------------------------------------------------------------------- }


{
   ---------------------------------------------------
   ! The task storage services are new in version 2.0.
}


{
 *  MPAllocateTaskStorageIndex()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPAllocateTaskStorageIndex(var index: TaskStorageIndex): OSStatus; external name '_MPAllocateTaskStorageIndex';


{
 *  MPDeallocateTaskStorageIndex()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPDeallocateTaskStorageIndex(index: TaskStorageIndex): OSStatus; external name '_MPDeallocateTaskStorageIndex';


{
 *  MPSetTaskStorageValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPSetTaskStorageValue(index: TaskStorageIndex; value: TaskStorageValue): OSStatus; external name '_MPSetTaskStorageValue';


{
 *  MPGetTaskStorageValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPGetTaskStorageValue(index: TaskStorageIndex): TaskStorageValue; external name '_MPGetTaskStorageValue';


{
   
   ===========================================================================================
   Synchronization Services
   ========================
}


{
 *  MPCreateQueue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPCreateQueue(var queue: MPQueueID): OSStatus; external name '_MPCreateQueue';


{
 *  MPDeleteQueue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPDeleteQueue(queue: MPQueueID): OSStatus; external name '_MPDeleteQueue';


{
 *  MPNotifyQueue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPNotifyQueue(queue: MPQueueID; param1: UnivPtr; param2: UnivPtr; param3: UnivPtr): OSStatus; external name '_MPNotifyQueue';


{
 *  MPWaitOnQueue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPWaitOnQueue(queue: MPQueueID; param1: UnivPtr; param2: UnivPtr; param3: UnivPtr; timeout: Duration): OSStatus; external name '_MPWaitOnQueue';


{
 *  MPSetQueueReserve()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPSetQueueReserve(queue: MPQueueID; count: ItemCount): OSStatus; external name '_MPSetQueueReserve';


{  ------------------------------------------------------------------------------------------- }


{
 *  MPCreateSemaphore()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPCreateSemaphore(maximumValue: MPSemaphoreCount; initialValue: MPSemaphoreCount; var semaphore: MPSemaphoreID): OSStatus; external name '_MPCreateSemaphore';


{
 *  MPDeleteSemaphore()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPDeleteSemaphore(semaphore: MPSemaphoreID): OSStatus; external name '_MPDeleteSemaphore';


{
 *  MPSignalSemaphore()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPSignalSemaphore(semaphore: MPSemaphoreID): OSStatus; external name '_MPSignalSemaphore';


{
 *  MPWaitOnSemaphore()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPWaitOnSemaphore(semaphore: MPSemaphoreID; timeout: Duration): OSStatus; external name '_MPWaitOnSemaphore';


{  ------------------------------------------------------------------------------------------- }


{
 *  MPCreateCriticalRegion()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPCreateCriticalRegion(var criticalRegion: MPCriticalRegionID): OSStatus; external name '_MPCreateCriticalRegion';


{
 *  MPDeleteCriticalRegion()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPDeleteCriticalRegion(criticalRegion: MPCriticalRegionID): OSStatus; external name '_MPDeleteCriticalRegion';


{
 *  MPEnterCriticalRegion()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPEnterCriticalRegion(criticalRegion: MPCriticalRegionID; timeout: Duration): OSStatus; external name '_MPEnterCriticalRegion';


{
 *  MPExitCriticalRegion()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPExitCriticalRegion(criticalRegion: MPCriticalRegionID): OSStatus; external name '_MPExitCriticalRegion';


{  ------------------------------------------------------------------------------------------- }


{
 *  MPCreateEvent()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPCreateEvent(var event: MPEventID): OSStatus; external name '_MPCreateEvent';


{
 *  MPDeleteEvent()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPDeleteEvent(event: MPEventID): OSStatus; external name '_MPDeleteEvent';


{
 *  MPSetEvent()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPSetEvent(event: MPEventID; flags: MPEventFlags): OSStatus; external name '_MPSetEvent';


{
 *  MPWaitForEvent()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPWaitForEvent(event: MPEventID; flags: MPEventFlagsPtr; timeout: Duration): OSStatus; external name '_MPWaitForEvent';

{
   
   ===========================================================================================
   Notification Services (API)
   =====================
}


{
 *  MPCreateNotification()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPCreateNotification(var notificationID: MPNotificationID): OSStatus; external name '_MPCreateNotification';


{
 *  MPDeleteNotification()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPDeleteNotification(notificationID: MPNotificationID): OSStatus; external name '_MPDeleteNotification';


{
 *  MPModifyNotification()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPModifyNotification(notificationID: MPNotificationID; anID: MPOpaqueID; notifyParam1: UnivPtr; notifyParam2: UnivPtr; notifyParam3: UnivPtr): OSStatus; external name '_MPModifyNotification';


{
 *  MPModifyNotificationParameters()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.3 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPModifyNotificationParameters(notificationID: MPNotificationID; kind: MPOpaqueIDClass; notifyParam1: UnivPtr; notifyParam2: UnivPtr; notifyParam3: UnivPtr): OSStatus; external name '_MPModifyNotificationParameters';


{
 *  MPCauseNotification()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPCauseNotification(notificationID: MPNotificationID): OSStatus; external name '_MPCauseNotification';


{
   
   ===========================================================================================
   Timer Services
   ==============
}


{
   --------------------------------------------
   ! The timer services are new in version 2.0.
}


{
   Utilities you might want to use from DriverServices
    extern AbsoluteTime UpTime              ( void );
    extern AbsoluteTime DurationToAbsolute  ( Duration      duration );
    extern Duration     AbsoluteToDuration  ( AbsoluteTime  time );
}


const
																{  For MPArmTimer options }
	kMPPreserveTimerIDMask		= $00000001;
	kMPTimeIsDeltaMask			= $00000002;
	kMPTimeIsDurationMask		= $00000004;


	{
	 *  MPDelayUntil()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 and later
	 	}
function MPDelayUntil(var expirationTime: AbsoluteTime): OSStatus; external name '_MPDelayUntil';


{$ifc CALL_NOT_IN_CARBON}
{
 *  MPDelayUntilSys()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function MPDelayUntilSys(var expirationTime: AbsoluteTime): OSStatus; external name '_MPDelayUntilSys';


{$endc}  {CALL_NOT_IN_CARBON}

{
 *  MPCreateTimer()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPCreateTimer(var timerID: MPTimerID): OSStatus; external name '_MPCreateTimer';


{
 *  MPDeleteTimer()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPDeleteTimer(timerID: MPTimerID): OSStatus; external name '_MPDeleteTimer';


{
 *  MPSetTimerNotify()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPSetTimerNotify(timerID: MPTimerID; anID: MPOpaqueID; notifyParam1: UnivPtr; notifyParam2: UnivPtr; notifyParam3: UnivPtr): OSStatus; external name '_MPSetTimerNotify';


{
 *  MPArmTimer()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPArmTimer(timerID: MPTimerID; var expirationTime: AbsoluteTime; options: OptionBits): OSStatus; external name '_MPArmTimer';


{
 *  MPCancelTimer()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPCancelTimer(timerID: MPTimerID; timeRemaining: AbsoluteTimePtr): OSStatus; external name '_MPCancelTimer';


{
   
   ===========================================================================================
   Memory Services
   ===============
}


const
																{  Maximum allocation request size is 1GB. }
	kMPMaxAllocSize				= 1073741824;

																{  Values for the alignment parameter to MPAllocateAligned. }
	kMPAllocateDefaultAligned	= 0;
	kMPAllocate8ByteAligned		= 3;
	kMPAllocate16ByteAligned	= 4;
	kMPAllocate32ByteAligned	= 5;
	kMPAllocate1024ByteAligned	= 10;
	kMPAllocate4096ByteAligned	= 12;
	kMPAllocateMaxAlignment		= 16;							{  Somewhat arbitrary limit on expectations. }
	kMPAllocateAltiVecAligned	= 4;							{  The P.C. name. }
	kMPAllocateVMXAligned		= 4;							{  The older, common name. }
	kMPAllocateVMPageAligned	= 254;							{  Pseudo value, converted at runtime. }
	kMPAllocateInterlockAligned	= 255;							{  Pseudo value, converted at runtime. }


																{  Values for the options parameter to MPAllocateAligned. }
	kMPAllocateClearMask		= $0001;						{  Zero the allocated block. }
	kMPAllocateGloballyMask		= $0002;						{  Allocate from the globally visible pool. }
	kMPAllocateResidentMask		= $0004;						{  Allocate from the RAM-resident pool. }
	kMPAllocateNoGrowthMask		= $0010;						{  Do not attempt to grow the pool. }
	kMPAllocateNoCreateMask		= $0020;						{  Do not attempt to create the pool if it doesn't exist yet. }


	{  ------------------------------------------------------------------------------------------- }


	{
	 *  MPAllocateAligned()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 and later
	 	}
function MPAllocateAligned(size: ByteCount; alignment: ByteParameter; options: OptionBits): LogicalAddress; external name '_MPAllocateAligned';

{  ! MPAllocateAligned is new in version 2.0. }

{
 *  MPAllocate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPAllocate(size: ByteCount): LogicalAddress; external name '_MPAllocate';

{  Use MPAllocateAligned instead. }

{
 *  MPFree()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure MPFree(objct: LogicalAddress); external name '_MPFree';


{
 *  MPGetAllocatedBlockSize()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPGetAllocatedBlockSize(objct: LogicalAddress): ByteCount; external name '_MPGetAllocatedBlockSize';


{  ------------------------------------------------------------------------------------------- }


{
 *  MPBlockCopy()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure MPBlockCopy(source: LogicalAddress; destination: LogicalAddress; size: ByteCount); external name '_MPBlockCopy';


{
 *  MPBlockClear()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure MPBlockClear(address: LogicalAddress; size: ByteCount); external name '_MPBlockClear';

{  ! MPBlockClear is new in version 2.0. }

{
 *  MPDataToCode()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure MPDataToCode(address: LogicalAddress; size: ByteCount); external name '_MPDataToCode';

{  ! MPDataToCode is new in version 2.0. }
{
   
   ===========================================================================================
   Exception/Debugging Services
   ============================
}


{
   -------------------------------------------------------------------------------------------
   *** Important Note ***
   ----------------------
   
   The functions MPExtractTaskState and MPSetTaskState infer the size of the "info" buffer
   from the "kind" parameter.  A given value for MPTaskStateKind will always refer to a
   single specific physical buffer layout.  Should new register sets be added, or the size
   or number of any registers change, new values of MPTaskStateKind will be introduced to
   refer to the new buffer layouts.
   
   The following types for the buffers are in MachineExceptions. The correspondence between
   MPTaskStateKind values and MachineExceptions types is:
   
        kMPTaskStateRegisters               -> RegisterInformation
        kMPTaskStateFPU                     -> FPUInformation
        kMPTaskStateVectors                 -> VectorInformation
        kMPTaskStateMachine                 -> MachineInformation
        kMPTaskState32BitMemoryException    -> ExceptionInfo for old-style 32-bit memory exceptions
   
    For reference, on PowerPC the MachineExceptions types contain:
   
        RegisterInformation -> The GPRs, 32 values of 64 bits each.
        FPUInformation      -> The FPRs plus FPSCR, 32 values of 64 bits each, one value of
                                32 bits.
        VectorInformation   -> The AltiVec vector registers plus VSCR and VRSave, 32 values
                                of 128 bits each, one value of 128 bits, and one 32 bit value.
        MachineInformation  -> The CTR, LR, PC, each of 64 bits.  The CR, XER, MSR, MQ,
                                exception kind, and DSISR, each of 32 bits.  The 64 bit DAR.
        ExceptionInfo       -> Only memory exceptions are specified, 4 fields of 32 bits each.
                                Note that this type only covers memory exceptions on 32-bit CPUs!
   The following types are declared here:
        kMPTaskStateTaskInfo                -> MPTaskInfo
}


const
																{  Values for the TaskStateKind to MPExtractTaskState and MPSetTaskState. }
	kMPTaskStateRegisters		= 0;							{  The task general registers. }
	kMPTaskStateFPU				= 1;							{  The task floating point registers }
	kMPTaskStateVectors			= 2;							{  The task vector registers }
	kMPTaskStateMachine			= 3;							{  The task machine registers }
	kMPTaskState32BitMemoryException = 4;						{  The task memory exception information for 32-bit CPUs. }
	kMPTaskStateTaskInfo		= 5;							{  Static and dynamic information about the task. }


																{  Option bits and numbers for MPDisposeTaskException. }
	kMPTaskPropagate			= 0;							{  The exception is propagated. }
	kMPTaskResumeStep			= 1;							{  The task is resumed and single step is enabled. }
	kMPTaskResumeBranch			= 2;							{  The task is resumed and branch stepping is enabled. }
	kMPTaskResumeMask			= $0000;						{  The task is resumed. }
	kMPTaskPropagateMask		= $01;							{  The exception is propagated. }
	kMPTaskResumeStepMask		= $02;							{  The task is resumed and single step is enabled. }
	kMPTaskResumeBranchMask		= $04;							{  The task is resumed and branch stepping is enabled. }


																{  For kMPTaskStateTaskInfo, the task's runState }
	kMPTaskBlocked				= 0;							{  Task is blocked (queued on resource) }
	kMPTaskReady				= 1;							{  Task is runnable }
	kMPTaskRunning				= 2;							{  Task is running }

																{  For kMPTaskStateTaskInfo, the version of the MPTaskInfo structure requested. }
	kMPTaskInfoVersion			= 3;


type
	MPTaskInfoPtr = ^MPTaskInfo;
	MPTaskInfo = record
		version:				PBVersion;								{  Version 3 of the data structure requested }
		name:					OSType;									{  Task name }
		queueName:				OSType;									{  Task's queue owner name }
		runState:				UInt16;									{  Running, ready, blocked }
		lastCPU:				UInt16;									{  Address of CPU where task previously ran }
		weight:					UInt32;									{  Processing weight: 1 - 10,000 }
		processID:				MPProcessID;							{  Owning process ID }
		cpuTime:				AbsoluteTime;							{  Accumulated task time }
		schedTime:				AbsoluteTime;							{  Time when last scheduled }
		creationTime:			AbsoluteTime;							{  Time when task created }
		codePageFaults:			ItemCount;								{  Page faults from code execution }
		dataPageFaults:			ItemCount;								{  Page faults from data access }
		preemptions:			ItemCount;								{  Number of times task was preempted }
		cpuID:					MPCpuID;								{  ID of CPU where task previously ran. }
		blockedObject:			MPOpaqueID;								{  ID of blocked object. }
		spaceID:				MPAddressSpaceID;						{  Address space ID of this task. }
		stackBase:				LogicalAddress;							{  Base of stack (lowest address). }
		stackLimit:				LogicalAddress;							{  Stack limit (highest address). }
		stackCurr:				LogicalAddress;							{  Current stack address. }
	end;

	{
	    Upon a task exception, the following message is sent to the designated queue:
	      1. The MPTaskID, 
	      2. The exception kind. These are enumerated in the interfaces header MachineExceptions.h 
	      3. N/A
	}


	{  ------------------------------------------------------------------------------------------- }


	{
	 *  MPSetExceptionHandler()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 and later
	 	}
function MPSetExceptionHandler(task: MPTaskID; exceptionQ: MPQueueID): OSStatus; external name '_MPSetExceptionHandler';


{
 *  MPDisposeTaskException()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPDisposeTaskException(task: MPTaskID; action: OptionBits): OSStatus; external name '_MPDisposeTaskException';


{
 *  MPExtractTaskState()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPExtractTaskState(task: MPTaskID; kind: MPTaskStateKind; info: UnivPtr): OSStatus; external name '_MPExtractTaskState';


{
 *  MPSetTaskState()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPSetTaskState(task: MPTaskID; kind: MPTaskStateKind; info: UnivPtr): OSStatus; external name '_MPSetTaskState';


{
 *  MPThrowException()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPThrowException(task: MPTaskID; kind: MPExceptionKind): OSStatus; external name '_MPThrowException';


{  ------------------------------------------------------------------------------------------- }


type
	MPDebuggerLevel 			= UInt32;
const
	kMPLowLevelDebugger			= $00000000;					{  MacsBug-like }
	kMPMidLevelDebugger			= $10000000;					{  Jasik-like }
	kMPHighLevelDebugger		= $20000000;					{  Metrowerks-like }


	{
	 *  MPRegisterDebugger()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 and later
	 	}
function MPRegisterDebugger(queue: MPQueueID; level: MPDebuggerLevel): OSStatus; external name '_MPRegisterDebugger';


{
 *  MPUnregisterDebugger()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function MPUnregisterDebugger(queue: MPQueueID): OSStatus; external name '_MPUnregisterDebugger';


{
   
   ===========================================================================================
   Remote Call Services
   ====================
}


type
{$ifc TYPED_FUNCTION_POINTERS}
	MPRemoteProcedure = function(parameter: UnivPtr): Ptr;
{$elsec}
	MPRemoteProcedure = ProcPtr;
{$endc}

	MPRemoteContext						= UInt8;

const
	kMPAnyRemoteContext			= 0;
	kMPOwningProcessRemoteContext = 1;
	kMPInterruptRemoteContext	= 2;
	kMPAsyncInterruptRemoteContext = 3;


	{
	 *  MPRemoteCall()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in MPLibrary 2.0 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 and later
	 	}
function MPRemoteCall(remoteProc: MPRemoteProcedure; parameter: UnivPtr; context: ByteParameter): Ptr; external name '_MPRemoteCall';

{  ! MPRemoteCall is new in version 2.0. }
{
   
   ===========================================================================================
   Checking API Availability
   =========================
}


{
   ===========================================================================================
   *** WARNING: You must properly check the availability of MP services before calling them!
   ===========================================================================================
   
   Checking for the availability of the MP API is rather ugly.  This is a historical problem,
   caused by the original implementation letting itself get prepared when it really wasn't
   usable and complicated by some important clients then depending on weak linking to "work".
   (And further complicated by CFM not supporting "deferred" imports, which is how many
   programmers think weak imports work.)
   
   The end result is that the MP API library may get prepared by CFM but be totally unusable.
   This means that if you import from the MP API library, you cannot simply check for a
   resolved import to decide if MP services are available.  Worse, if you explicitly prepare
   the MP API library you cannot assume that a noErr result from GetSharedLibrary means that
   MP services are available.
   
    If you import from the MP API library you MUST:
   
        Use the MPLibraryIsLoaded macro (or equivalent code in languages other than C) to tell
        if the MP API services are available.  It is not sufficient to simply check that an
        imported symbol is resolved as is commonly done for other libraries.  The macro expands
        to the expression:
   
            ( ( (UInt32)_MPIsFullyInitialized != (UInt32)kUnresolvedCFragSymbolAddress ) &&
              ( _MPIsFullyInitialized () ) )
   
        This checks if the imported symbol _MPIsFullyInitialized is resolved and if resolved
        calls it.  Both parts must succeed for the MP API services to be available.
   
    If you explicitly prepare the MP API library you MUST:
   
        Use code similar to the following example to tell if the MP API services are available.
        It is not sufficient to depend on just a noErr result from GetSharedLibrary.
   
            OSErr                       err;
            Boolean                     mpIsAvailable           = false;
            CFragConnectionID           connID                  = kInvalidID;
            MPIsFullyInitializedProc    mpIsFullyInitialized    = NULL;
   
            err = GetSharedLibrary  ( "\pMPLibrary", kCompiledCFragArch, kReferenceCFrag,
                                      &connID, NULL, NULL );
   
            if ( err == noErr ) (
                err = FindSymbol    ( connID, "\p_MPIsFullyInitialized",
                                      (Ptr *) &mpIsFullyInitialized, NULL );
            )
   
            if ( err == noErr ) (
                mpIsAvailable = (* mpIsFullyInitialized) ();
            )
   
   ===========================================================================================
}


{
 *  _MPIsFullyInitialized()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function _MPIsFullyInitialized: boolean; external name '__MPIsFullyInitialized';


type
{$ifc TYPED_FUNCTION_POINTERS}
	MPIsFullyInitializedProc = function: boolean;
{$elsec}
	MPIsFullyInitializedProc = ProcPtr;
{$endc}

	{
	   ===========================================================================================
	   The MPLibraryIsLoaded service is a macro under C that expands to the logical expression:
	        ( (UInt32)MPProcessors != (UInt32)kUnresolvedCFragSymbolAddress )
	   The intention is to check if the imported symbol MPProcessors is resolved.  For other
	   languages use the equivalent expression.
	   ===========================================================================================
	}
	{
	   
	   ===========================================================================================
	   Miscellaneous Services
	   ======================
	}


	{
	 *  _MPLibraryVersion()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 and later
	 	}
procedure _MPLibraryVersion(versionCString: ConstCStringPtrPtr; major: UInt32Ptr; minor: UInt32Ptr; release: UInt32Ptr; revision: UInt32Ptr); external name '__MPLibraryVersion';


{
   
   ===========================================================================================
   Unofficial Services
   ===================
}


{
   ===========================================================================================
   *** WARNING ***
   These services are not part of the officially documented multiprocessing API.  They may not
   be avaliable in future versions of Mac OS multiprocessing support, or in environments that
   have a different underlying OS architecture such as Mac OS on top of a microkernel, the
   Mac OS Blue Box under Mac OS X, native MP support in Mac OS X, etc.
   ===========================================================================================
}

{$ifc CALL_NOT_IN_CARBON}
{$ifc CALL_NOT_IN_CARBON}
{
 *  _MPAllocateSys()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function _MPAllocateSys(size: ByteCount): LogicalAddress; external name '__MPAllocateSys';

{  Use MPAllocateAligned instead. }
{
 *  _MPRPC()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function _MPRPC(remoteProc: MPRemoteProcedure; parameter: UnivPtr): Ptr; external name '__MPRPC';

{  Use _MPRemoteCall instead. }
{
 *  _MPTaskIsToolboxSafe()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function _MPTaskIsToolboxSafe(task: MPTaskID): boolean; external name '__MPTaskIsToolboxSafe';

{$endc}  {CALL_NOT_IN_CARBON}
{$endc}  {CALL_NOT_IN_CARBON}

{
 *  _MPLibraryIsCompatible()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibrary 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function _MPLibraryIsCompatible(versionCString: ConstCStringPtr; major: UInt32; minor: UInt32; release: UInt32; revision: UInt32): boolean; external name '__MPLibraryIsCompatible';


{
   
   ===========================================================================================
   Defunct Services
   ================
}

{$ifc CALL_NOT_IN_CARBON}
{$ifc undefined MPIncludeDefunctServices}
{$setc MPIncludeDefunctServices := 0}
{$endc}
{$ifc MPIncludeDefunctServices}
{$ifc CALL_NOT_IN_CARBON}
{
 *  _MPDebugStr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibraryObsolete 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
procedure _MPDebugStr(const (*var*) msg: Str255); external name '__MPDebugStr';

{
 *  _MPStatusPString()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibraryObsolete 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function _MPStatusPString(status: OSStatus): StringPtr; external name '__MPStatusPString';

{
 *  _MPStatusCString()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MPLibraryObsolete 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function _MPStatusCString(status: OSStatus): ConstCStringPtr; external name '__MPStatusCString';


{$endc}  {CALL_NOT_IN_CARBON}
{$endc}  {MPIncludeDefunctServices}
{$endc}  {CALL_NOT_IN_CARBON}

{  =========================================================================================== }


{$ALIGN MAC68K}


{unit NameRegistry}
{
     File:       NameRegistry.p
 
     Contains:   NameRegistry Interfaces
 
     Version:    Technology: MacOS
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   1993-2002 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN POWER}

{******************************************************************************
 * 
 * Foundation Types
 *
 }
{ Value of a property }

type
	RegPropertyValue					= Ptr;
	{	 Length of property value 	}
	RegPropertyValueSize				= UInt32;
	{	******************************************************************************
	 * 
	 * RegEntryID   :   The Global x-Namespace Entry Identifier
	 *
	 	}
	RegEntryIDPtr = ^RegEntryID;
	RegEntryID = record
		contents:				array [0..3] of UInt32;
	end;

	{	******************************************************************************
	 *
	 * Root Entry Name Definitions  (Applies to all Names in the RootNameSpace)
	 *
	 *   Names are a colon-separated list of name components.  Name components
	 *    may not themselves contain colons.  
	 *   Names are presented as null-terminated ASCII character strings.
	 *   Names follow similar parsing rules to Apple file system absolute
	 *    and relative paths.  However the '::' parent directory syntax is
	 *    not currently supported.
	 	}
	{	 Max length of Entry Name 	}

const
	kRegCStrMaxEntryNameLength	= 47;

	{	 Entry Names are single byte ASCII 	}

type
	RegCStrEntryName					= char;
	RegCStrEntryNamePtr					= ^char;
	{  length of RegCStrEntryNameBuf =  kRegCStrMaxEntryNameLength+1 }
	RegCStrEntryNameBuf					= packed array [0..47] of char;
	RegCStrPathName						= char;
	RegPathNameSize						= UInt32;

const
	kRegPathNameSeparator		= 58;							{  0x3A  }
	kRegEntryNameTerminator		= $00;							{  '\0'  }
	kRegPathNameTerminator		= $00;							{  '\0'  }

	{	******************************************************************************
	 *
	 * Property Name and ID Definitions
	 *  (Applies to all Properties Regardless of NameSpace)
	 	}
	kRegMaximumPropertyNameLength = 31;							{  Max length of Property Name  }
	kRegPropertyNameTerminator	= $00;							{  '\0'  }


type
	RegPropertyNameBuf					= packed array [0..31] of char;
	RegPropertyName						= char;
	RegPropertyNamePtr					= ^char;
	{	******************************************************************************
	 *
	 * Iteration Operations
	 *
	 *  These specify direction when traversing the name relationships
	 	}
	RegIterationOp						= UInt32;
	RegEntryIterationOp					= RegIterationOp;

const
																{  Absolute locations }
	kRegIterRoot				= $00000002;					{  "Upward" Relationships  }
	kRegIterParents				= $00000003;					{  include all  parent(s) of entry  }
																{  "Downward" Relationships }
	kRegIterChildren			= $00000004;					{  include all children  }
	kRegIterSubTrees			= $00000005;					{  include all sub trees of entry  }
	kRegIterDescendants			= $00000005;					{  include all descendants of entry  }
																{  "Horizontal" Relationships  }
	kRegIterSibling				= $00000006;					{  include all siblings  }
																{  Keep doing the same thing }
	kRegIterContinue			= $00000001;

	{	******************************************************************************
	 *
	 * Name Entry and Property Modifiers
	 *
	 *
	 *
	 * Modifiers describe special characteristics of names
	 * and properties.  Modifiers might be supported for
	 * some names and not others.
	 * 
	 * Device Drivers should not rely on functionality
	 * specified as a modifier.
	 	}

type
	RegModifiers						= UInt32;
	RegEntryModifiers					= RegModifiers;
	RegPropertyModifiers				= RegModifiers;

const
	kRegNoModifiers				= $00000000;					{  no entry modifiers in place  }
	kRegUniversalModifierMask	= $0000FFFF;					{  mods to all entries  }
	kRegNameSpaceModifierMask	= $00FF0000;					{  mods to all entries within namespace  }
	kRegModifierMask			= $FF000000;					{  mods to just this entry  }

	{	 Universal Property Modifiers 	}
	kRegPropertyValueIsSavedToNVRAM = $00000020;				{  property is non-volatile (saved in NVRAM)  }
	kRegPropertyValueIsSavedToDisk = $00000040;					{  property is non-volatile (saved on disk)  }

	{	 NameRegistry version, Gestalt/PEF-style -- MUST BE KEPT IN SYNC WITH MAKEFILE !! 	}
	LatestNR_PEFVersion			= $01030000;					{  latest NameRegistryLib version (Gestalt/PEF-style)  }

	{	 ///////////////////////
	//
	// The Registry API
	//
	/////////////////////// 	}
	{	 NameRegistry dispatch indexes 	}
	kSelectRegistryEntryIDInit	= 0;
	kSelectRegistryEntryIDCompare = 1;
	kSelectRegistryEntryIDCopy	= 2;
	kSelectRegistryEntryIDDispose = 3;
	kSelectRegistryCStrEntryCreate = 4;
	kSelectRegistryEntryDelete	= 5;
	kSelectRegistryEntryCopy	= 6;
	kSelectRegistryEntryIterateCreate = 7;
	kSelectRegistryEntryIterateDispose = 8;
	kSelectRegistryEntryIterateSet = 9;
	kSelectRegistryEntryIterate	= 10;
	kSelectRegistryEntrySearch	= 11;
	kSelectRegistryCStrEntryLookup = 12;
	kSelectRegistryEntryToPathSize = 13;
	kSelectRegistryCStrEntryToPath = 14;
	kSelectRegistryCStrEntryToName = 15;
	kSelectRegistryPropertyCreate = 16;
	kSelectRegistryPropertyDelete = 17;
	kSelectRegistryPropertyRename = 18;
	kSelectRegistryPropertyIterateCreate = 19;
	kSelectRegistryPropertyIterateDispose = 20;
	kSelectRegistryPropertyIterate = 21;
	kSelectRegistryPropertyGetSize = 22;
	kSelectRegistryPropertyGet	= 23;
	kSelectRegistryPropertySet	= 24;
	kSelectRegistryEntryGetMod	= 25;
	kSelectRegistryEntrySetMod	= 26;
	kSelectRegistryPropertyGetMod = 27;
	kSelectRegistryPropertySetMod = 28;
	kSelectRegistryEntryMod		= 29;
	kSelectRegistryEntryPropertyMod = 30;						{  if you add more selectors here, remember to change 'kSelectRegistryHighestSelector' below }
	kSelectRegistryHighestSelector = 30;


	{	 ///////////////////////
	//
	// Entry Management
	//
	/////////////////////// 	}

	{	-------------------------------
	 * EntryID handling
	 	}
	{	
	 * Initialize an EntryID to a known invalid state
	 *   note: invalid != uninitialized
	 	}
{$ifc CALL_NOT_IN_CARBON}
	{
	 *  RegistryEntryIDInit()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
	 *    CarbonLib:        not available
	 *    Mac OS X:         not available
	 	}
function RegistryEntryIDInit(var id: RegEntryID): OSStatus; external name '_RegistryEntryIDInit';
{
 * Compare EntryID's for equality or if invalid
 *
 * If a NULL value is given for either id1 or id2, the other id 
 * is compared with an invalid ID.  If both are NULL, the id's 
 * are consided equal (result = true). 
 }
{
 *  RegistryEntryIDCompare()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryEntryIDCompare(const (*var*) id1: RegEntryID; const (*var*) id2: RegEntryID): boolean; external name '_RegistryEntryIDCompare';
{
 * Copy an EntryID
 }
{
 *  RegistryEntryIDCopy()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryEntryIDCopy(const (*var*) src: RegEntryID; var dst: RegEntryID): OSStatus; external name '_RegistryEntryIDCopy';
{
 * Free an ID so it can be reused.
 }
{
 *  RegistryEntryIDDispose()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryEntryIDDispose(var id: RegEntryID): OSStatus; external name '_RegistryEntryIDDispose';
{-------------------------------
 * Adding and removing entries
 *
 * If (parentEntry) is NULL, the name is assumed
 * to be a rooted path. It is rooted to an anonymous, unnamed root.
 }
{
 *  RegistryCStrEntryCreate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryCStrEntryCreate(const (*var*) parentEntry: RegEntryID; const (*var*) name: RegCStrPathName; var newEntry: RegEntryID): OSStatus; external name '_RegistryCStrEntryCreate';
{
 *  RegistryEntryDelete()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryEntryDelete(const (*var*) id: RegEntryID): OSStatus; external name '_RegistryEntryDelete';
{
 *  RegistryEntryCopy()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryEntryCopy(var parentEntryID: RegEntryID; var sourceDevice: RegEntryID; var destDevice: RegEntryID): OSStatus; external name '_RegistryEntryCopy';
{---------------------------
 * Traversing the namespace
 *
 * To support arbitrary namespace implementations in the future,
 * I have hidden the form that the place pointer takes.  The previous
 * interface exposed the place pointer by specifying it as a
 * RegEntryID.
 *
 * I have also removed any notion of returning the entries
 * in a particular order, because an implementation might
 * return the names in semi-random order.  Many name service
 * implementations will store the names in a hashed lookup
 * table.
 *
 * Writing code to traverse some set of names consists of
 * a call to begin the iteration, the iteration loop, and
 * a call to end the iteration.  The begin call initializes
 * the iteration cookie data structure.  The call to end the 
 * iteration should be called even in the case of error so 
 * that allocated data structures can be freed.
 *
 *  Create(...)
 *  do (
 *      Iterate(...);
 *  ) while (!done);
 *  Dispose(...);
 *
 * This is the basic code structure for callers of the iteration
 * interface.
 }
{$endc}  {CALL_NOT_IN_CARBON}


type
	RegEntryIter    = ^SInt32; { an opaque 32-bit type }
	RegEntryIterPtr = ^RegEntryIter;  { when a var xx:RegEntryIter parameter can be nil, it is changed to xx: RegEntryIterPtr }
	{	 
	 * create/dispose the iterator structure
	 *   defaults to root with relationship = kRegIterDescendants
	 	}
{$ifc CALL_NOT_IN_CARBON}
	{
	 *  RegistryEntryIterateCreate()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
	 *    CarbonLib:        not available
	 *    Mac OS X:         not available
	 	}
function RegistryEntryIterateCreate(var cookie: RegEntryIter): OSStatus; external name '_RegistryEntryIterateCreate';
{
 *  RegistryEntryIterateDispose()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryEntryIterateDispose(var cookie: RegEntryIter): OSStatus; external name '_RegistryEntryIterateDispose';
{ 
 * set Entry Iterator to specified entry
 }
{
 *  RegistryEntryIterateSet()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryEntryIterateSet(var cookie: RegEntryIter; const (*var*) startEntryID: RegEntryID): OSStatus; external name '_RegistryEntryIterateSet';
{
 * Return each value of the iteration
 *
 * return entries related to the current entry
 * with the specified relationship
 }
{
 *  RegistryEntryIterate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryEntryIterate(var cookie: RegEntryIter; relationship: RegEntryIterationOp; var foundEntry: RegEntryID; var done: boolean): OSStatus; external name '_RegistryEntryIterate';
{
 * return entries with the specified property
 *
 * A NULL RegPropertyValue pointer will return an
 * entry with the property containing any value.
 }
{
 *  RegistryEntrySearch()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryEntrySearch(var cookie: RegEntryIter; relationship: RegEntryIterationOp; var foundEntry: RegEntryID; var done: boolean; const (*var*) propertyName: RegPropertyName; propertyValue: UnivPtr; propertySize: RegPropertyValueSize): OSStatus; external name '_RegistryEntrySearch';
{--------------------------------
 * Find a name in the namespace
 *
 * This is the fast lookup mechanism.
 * NOTE:  A reverse lookup mechanism
 *    has not been provided because
 *        some name services may not
 *        provide a fast, general reverse
 *        lookup.
 }
{
 *  RegistryCStrEntryLookup()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryCStrEntryLookup(const (*var*) searchPointID: RegEntryID; const (*var*) pathName: RegCStrPathName; var foundEntry: RegEntryID): OSStatus; external name '_RegistryCStrEntryLookup';
{---------------------------------------------
 * Convert an entry to a rooted name string
 *
 * A utility routine to turn an Entry ID
 * back into a name string.
 }
{
 *  RegistryEntryToPathSize()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryEntryToPathSize(const (*var*) entryID: RegEntryID; var pathSize: RegPathNameSize): OSStatus; external name '_RegistryEntryToPathSize';
{
 *  RegistryCStrEntryToPath()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryCStrEntryToPath(const (*var*) entryID: RegEntryID; var pathName: RegCStrPathName; pathSize: RegPathNameSize): OSStatus; external name '_RegistryCStrEntryToPath';
{
 * Parse a path name.
 *
 * Retrieve the last component of the path, and
 * return a spec for the parent.
 }
{
 *  RegistryCStrEntryToName()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryCStrEntryToName(const (*var*) entryID: RegEntryID; var parentEntry: RegEntryID; var nameComponent: RegCStrEntryName; var done: boolean): OSStatus; external name '_RegistryCStrEntryToName';
{ //////////////////////////////////////////////////////
//
// Property Management
//
////////////////////////////////////////////////////// }
{-------------------------------
 * Adding and removing properties
 }
{
 *  RegistryPropertyCreate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryPropertyCreate(const (*var*) entryID: RegEntryID; const (*var*) propertyName: RegPropertyName; propertyValue: UnivPtr; propertySize: RegPropertyValueSize): OSStatus; external name '_RegistryPropertyCreate';
{
 *  RegistryPropertyDelete()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryPropertyDelete(const (*var*) entryID: RegEntryID; const (*var*) propertyName: RegPropertyName): OSStatus; external name '_RegistryPropertyDelete';
{
 *  RegistryPropertyRename()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryPropertyRename(const (*var*) entry: RegEntryID; const (*var*) oldName: RegPropertyName; const (*var*) newName: RegPropertyName): OSStatus; external name '_RegistryPropertyRename';
{---------------------------
 * Traversing the Properties of a name
 *
 }
{$endc}  {CALL_NOT_IN_CARBON}


type
	RegPropertyIter    = ^SInt32; { an opaque 32-bit type }
	RegPropertyIterPtr = ^RegPropertyIter;  { when a var xx:RegPropertyIter parameter can be nil, it is changed to xx: RegPropertyIterPtr }
{$ifc CALL_NOT_IN_CARBON}
	{
	 *  RegistryPropertyIterateCreate()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
	 *    CarbonLib:        not available
	 *    Mac OS X:         not available
	 	}
function RegistryPropertyIterateCreate(const (*var*) entry: RegEntryID; var cookie: RegPropertyIter): OSStatus; external name '_RegistryPropertyIterateCreate';
{
 *  RegistryPropertyIterateDispose()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryPropertyIterateDispose(var cookie: RegPropertyIter): OSStatus; external name '_RegistryPropertyIterateDispose';
{
 *  RegistryPropertyIterate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryPropertyIterate(var cookie: RegPropertyIter; var foundProperty: RegPropertyName; var done: boolean): OSStatus; external name '_RegistryPropertyIterate';
{
 * Get the value of the specified property for the specified entry.
 *
 }
{
 *  RegistryPropertyGetSize()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryPropertyGetSize(const (*var*) entryID: RegEntryID; const (*var*) propertyName: RegPropertyName; var propertySize: RegPropertyValueSize): OSStatus; external name '_RegistryPropertyGetSize';
{
 * (*propertySize) is the maximum size of the value returned in the buffer
 * pointed to by (propertyValue).  Upon return, (*propertySize) is the size of the
 * value returned.
 }
{
 *  RegistryPropertyGet()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryPropertyGet(const (*var*) entryID: RegEntryID; const (*var*) propertyName: RegPropertyName; propertyValue: UnivPtr; var propertySize: RegPropertyValueSize): OSStatus; external name '_RegistryPropertyGet';
{
 *  RegistryPropertySet()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryPropertySet(const (*var*) entryID: RegEntryID; const (*var*) propertyName: RegPropertyName; propertyValue: UnivPtr; propertySize: RegPropertyValueSize): OSStatus; external name '_RegistryPropertySet';
{ //////////////////////////////////////////////////////
//
// Modifier Management
//
////////////////////////////////////////////////////// }
{
 * Modifiers describe special characteristics of names
 * and properties.  Modifiers might be supported for
 * some names and not others.
 * 
 * Device Drivers should not rely on functionality
 * specified as a modifier.  These interfaces
 * are for use in writing Experts.
 }
{
 * Get and Set operators for entry modifiers
 }
{
 *  RegistryEntryGetMod()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryEntryGetMod(const (*var*) entry: RegEntryID; var modifiers: RegEntryModifiers): OSStatus; external name '_RegistryEntryGetMod';
{
 *  RegistryEntrySetMod()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryEntrySetMod(const (*var*) entry: RegEntryID; modifiers: RegEntryModifiers): OSStatus; external name '_RegistryEntrySetMod';
{
 * Get and Set operators for property modifiers
 }
{
 *  RegistryPropertyGetMod()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryPropertyGetMod(const (*var*) entry: RegEntryID; const (*var*) name: RegPropertyName; var modifiers: RegPropertyModifiers): OSStatus; external name '_RegistryPropertyGetMod';
{
 *  RegistryPropertySetMod()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryPropertySetMod(const (*var*) entry: RegEntryID; const (*var*) name: RegPropertyName; modifiers: RegPropertyModifiers): OSStatus; external name '_RegistryPropertySetMod';
{
 * Iterator operator for entry modifier search
 }
{
 *  RegistryEntryMod()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryEntryMod(var cookie: RegEntryIter; relationship: RegEntryIterationOp; var foundEntry: RegEntryID; var done: boolean; matchingModifiers: RegEntryModifiers): OSStatus; external name '_RegistryEntryMod';
{
 * Iterator operator for entries with matching 
 * property modifiers
 }
{
 *  RegistryEntryPropertyMod()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in NameRegistryLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function RegistryEntryPropertyMod(var cookie: RegEntryIter; relationship: RegEntryIterationOp; var foundEntry: RegEntryID; var done: boolean; matchingModifiers: RegPropertyModifiers): OSStatus; external name '_RegistryEntryPropertyMod';

{$endc}  {CALL_NOT_IN_CARBON}

{$ALIGN MAC68K}


{unit PEFBinaryFormat}
{
     File:       PEFBinaryFormat.p
 
     Contains:   PEF Types and Macros
 
     Version:    Technology: Master Interfaces
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   1993-2002 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}


{ -------------------------------------------------------------------------------------------- }
{ Almost all types are padded for natural alignment.  However the PEFExportedSymbol type is    }
{ 10 bytes long, containing two 32 bit fields and one 16 bit field.  Arrays of it must be      }
{ packed, so it requires "68K" alignment.  Setting this globally to 68K should also help       }
{ ensure consistent treatment across compilers.                                                }

{ ======================================================================================== }
{ Overall Structure }
{ ================= }

{ -------------------------------------------------------------------------------------------- }
{ This header contains a complete set of types and macros for dealing with the PEF executable  }
{ format.  While some description is provided, this header is not meant as a primary source    }
{ of documentation on PEF.  An excellent specification of PEF can be found in the Macintosh    }
{ Runtime Architectures book.  This header is primarily a physical format description.  Thus   }
{ it depends on as few other headers as possible and structure fields have obvious sizes.      }
{                                                                                              }
{ The physical storage for a PEF executable is known as a "container".  This refers to just    }
{ the executable itself, not the file etc.  E.g. if five DLLs are packaged in a single file's  }
{ data fork, that one data fork has five containers within it.                                 }
{                                                                                              }
{ A PEF container consists of an overall header, followed by one or more section headers,      }
{ followed by the section name table, followed by the contents for the sections.  Some kinds   }
{ of sections have specific internal representation.  The "loader" section is the most common  }
{ of these special sections.  It contains information on the exports, imports, and runtime     }
{ relocations required to prepare the executable.  PEF containers are self contained, all      }
{ portions are located via relative offsets.                                                   }
{                                                                                              }
{                                                                                              }
{          +-------------------------------+                                                   }
{          |       Container Header        |   40 bytes                                        }
{          +-------------------------------+                                                   }
{          |       Section 0 header        |   28 bytes each                                   }
{          |...............................|                                                   }
{          |           - - - -             |                                                   }
{          |...............................|                                                   }
{          |       Section n-1 header      |                                                   }
{          +-------------------------------+                                                   }
{          |       Section Name Table      |                                                   }
{          +-------------------------------+                                                   }
{          |       Section x raw data      |                                                   }
{          +-------------------------------+                                                   }
{          |           - - - -             |                                                   }
{          +-------------------------------+                                                   }
{          |       Section y raw data      |                                                   }
{          +-------------------------------+                                                   }
{                                                                                              }
{                                                                                              }
{ The sections are implicitly numbered from 0 to n according to the order of their headers.    }
{ The headers of the instantiated sections must precede those of the non-instantiated          }
{ sections.  The ordering of the raw data is independent of the section header ordering.       }
{ Each section header contains the offset for that section's raw data.                         }

{ =========================================================================================== }
{ Container Header }
{ ================ }


type
	PEFContainerHeaderPtr = ^PEFContainerHeader;
	PEFContainerHeader = record
		tag1:					OSType;									{  Must contain 'Joy!'. }
		tag2:					OSType;									{  Must contain 'peff'.  (Yes, with two 'f's.) }
		architecture:			OSType;									{  The ISA for code sections.  Constants in CodeFragments.h. }
		formatVersion:			UInt32;									{  The physical format version. }
		dateTimeStamp:			UInt32;									{  Macintosh format creation/modification stamp. }
		oldDefVersion:			UInt32;									{  Old definition version number for the code fragment. }
		oldImpVersion:			UInt32;									{  Old implementation version number for the code fragment. }
		currentVersion:			UInt32;									{  Current version number for the code fragment. }
		sectionCount:			UInt16;									{  Total number of section headers that follow. }
		instSectionCount:		UInt16;									{  Number of instantiated sections. }
		reservedA:				UInt32;									{  Reserved, must be written as zero. }
	end;


const
	kPEFTag1					= $4A6F7921 (* 'Joy!' *);						{  For non-Apple compilers: 0x4A6F7921. }
	kPEFTag2					= $70656666 (* 'peff' *);						{  For non-Apple compilers: 0x70656666. }
	kPEFVersion					= $00000001;


	kPEFFirstSectionHeaderOffset = 40;


	{	 =========================================================================================== 	}
	{	 Section Headers 	}
	{	 =============== 	}


type
	PEFSectionHeaderPtr = ^PEFSectionHeader;
	PEFSectionHeader = record
		nameOffset:				SInt32;									{  Offset of name within the section name table, -1 => none. }
		defaultAddress:			UInt32;									{  Default address, affects relocations. }
		totalLength:			UInt32;									{  Fully expanded size in bytes of the section contents. }
		unpackedLength:			UInt32;									{  Size in bytes of the "initialized" part of the contents. }
		containerLength:		UInt32;									{  Size in bytes of the raw data in the container. }
		containerOffset:		UInt32;									{  Offset of section's raw data. }
		sectionKind:			SInt8;									{  Kind of section contents/usage. }
		shareKind:				SInt8;									{  Sharing level, if a writeable section. }
		alignment:				SInt8;									{  Preferred alignment, expressed as log 2. }
		reservedA:				SInt8;									{  Reserved, must be zero. }
	end;


const
																{  Values for the sectionKind field. }
																{     Section kind values for instantiated sections. }
	kPEFCodeSection				= 0;							{  Code, presumed pure & position independent. }
	kPEFUnpackedDataSection		= 1;							{  Unpacked writeable data. }
	kPEFPackedDataSection		= 2;							{  Packed writeable data. }
	kPEFConstantSection			= 3;							{  Read-only data. }
	kPEFExecDataSection			= 6;							{  Intermixed code and writeable data. }
																{  Section kind values for non-instantiated sections. }
	kPEFLoaderSection			= 4;							{  Loader tables. }
	kPEFDebugSection			= 5;							{  Reserved for future use. }
	kPEFExceptionSection		= 7;							{  Reserved for future use. }
	kPEFTracebackSection		= 8;							{  Reserved for future use. }


																{  Values for the shareKind field. }
	kPEFProcessShare			= 1;							{  Shared within a single process. }
	kPEFGlobalShare				= 4;							{  Shared across the entire system. }
	kPEFProtectedShare			= 5;							{  Readable across the entire system, writeable only to privileged code. }


	{	 =========================================================================================== 	}
	{	 Packed Data Contents 	}
	{	 ==================== 	}

	{	 -------------------------------------------------------------------------------------------- 	}
	{	 The raw contents of a packed data section are a sequence of byte codes.  The basic format    	}
	{	 has a 3 bit opcode followed by a 5 bit count.  Additional bytes might be used to contain     	}
	{	 counts larger than 31, and to contain a second or third count.  Further additional bytes     	}
	{	 contain actual data values to transfer.                                                      	}
	{	                                                                                              	}
	{	 All counts are represented in a variable length manner.  A zero in the initial 5 bit count   	}
	{	 indicates the actual value follows.  In this case, and for the second and third counts, the  	}
	{	 count is represented as a variable length sequence of bytes.  The bytes are stored in big    	}
	{	 endian manner, most significant part first.  The high order bit is set in all but the last   	}
	{	 byte.  The value is accumulated by shifting the current value up 7 bits and adding in the    	}
	{	 low order 7 bits of the next byte.                                                           	}

																{  The packed data opcodes. }
	kPEFPkDataZero				= 0;							{  Zero fill "count" bytes. }
	kPEFPkDataBlock				= 1;							{  Block copy "count" bytes. }
	kPEFPkDataRepeat			= 2;							{  Repeat "count" bytes "count2"+1 times. }
	kPEFPkDataRepeatBlock		= 3;							{  Interleaved repeated and unique data. }
	kPEFPkDataRepeatZero		= 4;							{  Interleaved zero and unique data. }


	kPEFPkDataOpcodeShift		= 5;
	kPEFPkDataCount5Mask		= $1F;
	kPEFPkDataMaxCount5			= 31;
	kPEFPkDataVCountShift		= 7;
	kPEFPkDataVCountMask		= $7F;
	kPEFPkDataVCountEndMask		= $80;


	{	 -------------------------------------------------------------------------------------------- 	}
	{	 The following code snippet can be used to input a variable length count.                     	}
	{	                                                                                              	}
	{	      count = 0;                                                                              	}
	{	      do (                                                                                    	}
	{	          byte = *bytePtr++;                                                                  	}
	{	          count = (count << kPEFPkDataVCountShift) | (byte & kPEFPkDataVCountMask);           	}
	{	      ) while ( (byte & kPEFPkDataVCountEndMask) != 0 );                                      	}
	{	                                                                                              	}
	{	 The following code snippet can be used to output a variable length count to a byte array.    	}
	{	 This is more complex than the input code because the chunks are output in big endian order.  	}
	{	 Think about handling values like 0 or 0x030000.                                              	}
	{	                                                                                              	}
	{	      count = 1;.                                                                             	}
	{	      tempValue = value >> kPEFPkDataCountShift;                                              	}
	{	      while ( tempValue != 0 ) (                                                              	}
	{	          count += 1;                                                                         	}
	{	          tempValue = tempValue >> kPEFPkDataCountShift;                                      	}
	{	      )                                                                                       	}
	{	                                                                                              	}
	{	      bytePtr += count;                                                                       	}
	{	      tempPtr = bytePtr - 1;                                                                  	}
	{	      *tempPtr-- = value;     // ! No need to mask, only the low order byte is stored.        	}
	{	      for ( count -= 1; count != 0; count -= 1 ) (                                            	}
	{	          value = value >> kPEFPkDataCountShift;                                              	}
	{	          *tempPtr-- = value | kPEFPkDataCountEndMask;                                        	}
	{	      )                                                                                       	}

	{	 =========================================================================================== 	}
	{	 Loader Section 	}
	{	 ============== 	}

	{	 -------------------------------------------------------------------------------------------- 	}
	{	 The loader section contains information needed to prepare the code fragment for execution.   	}
	{	 This includes this fragment's exports, the import libraries and the imported symbols from    	}
	{	 each library, and the relocations for the writeable sections.                                	}
	{	                                                                                              	}
	{	          +-----------------------------------+               <-- containerOffset --------+   	}
	{	          |       Loader Info Header          |   56 bytes                                |   	}
	{	          |-----------------------------------|                                           |   	}
	{	          |       Imported Library 0          |   24 bytes each                           |   	}
	{	          |...................................|                                           |   	}
	{	          |           - - -                   |                                           |   	}
	{	          |...................................|                                           |   	}
	{	          |       Imported Library l-1        |                                           |   	}
	{	          |-----------------------------------|                                           |   	}
	{	          |       Imported Symbol 0           |   4 bytes each                            |   	}
	{	          |...................................|                                           |   	}
	{	          |           - - -                   |                                           |   	}
	{	          |...................................|                                           |   	}
	{	          |       Imported Symbol i-1         |                                           |   	}
	{	          |-----------------------------------|                                           |   	}
	{	          |       Relocation Header 0         |   12 bytes each                           |   	}
	{	          |...................................|                                           |   	}
	{	          |           - - -                   |                                           |   	}
	{	          |...................................|                                           |   	}
	{	          |       Relocation Header r-1       |                                           |   	}
	{	          |-----------------------------------|               <-- + relocInstrOffset -----|   	}
	{	          |       Relocation Instructions     |                                           |   	}
	{	          |-----------------------------------|               <-- + loaderStringsOffset --|   	}
	{	          |       Loader String Table         |                                           |   	}
	{	          |-----------------------------------|               <-- + exportHashOffset -----+   	}
	{	          |       Export Hash Slot 0          |   4 bytes each                                	}
	{	          |...................................|                                               	}
	{	          |           - - -                   |                                               	}
	{	          |...................................|                                               	}
	{	          |       Export Hash Slot h-1        |                                               	}
	{	          |-----------------------------------|                                               	}
	{	          |       Export Symbol Key 0         |   4 bytes each                                	}
	{	          |...................................|                                               	}
	{	          |           - - -                   |                                               	}
	{	          |...................................|                                               	}
	{	          |       Export Symbol Key e-1       |                                               	}
	{	          |-----------------------------------|                                               	}
	{	          |       Export Symbol 0             |   10 bytes each                               	}
	{	          |...................................|                                               	}
	{	          |           - - -                   |                                               	}
	{	          |...................................|                                               	}
	{	          |       Export Symbol e-1           |                                               	}
	{	          +-----------------------------------+                                               	}


type
	PEFLoaderInfoHeaderPtr = ^PEFLoaderInfoHeader;
	PEFLoaderInfoHeader = record
		mainSection:			SInt32;									{  Section containing the main symbol, -1 => none. }
		mainOffset:				UInt32;									{  Offset of main symbol. }
		initSection:			SInt32;									{  Section containing the init routine's TVector, -1 => none. }
		initOffset:				UInt32;									{  Offset of the init routine's TVector. }
		termSection:			SInt32;									{  Section containing the term routine's TVector, -1 => none. }
		termOffset:				UInt32;									{  Offset of the term routine's TVector. }
		importedLibraryCount:	UInt32;									{  Number of imported libraries.  ('l') }
		totalImportedSymbolCount: UInt32;								{  Total number of imported symbols.  ('i') }
		relocSectionCount:		UInt32;									{  Number of sections with relocations.  ('r') }
		relocInstrOffset:		UInt32;									{  Offset of the relocation instructions. }
		loaderStringsOffset:	UInt32;									{  Offset of the loader string table. }
		exportHashOffset:		UInt32;									{  Offset of the export hash table. }
		exportHashTablePower:	UInt32;									{  Export hash table size as log 2.  (Log2('h')) }
		exportedSymbolCount:	UInt32;									{  Number of exported symbols.  ('e') }
	end;

	{	 =========================================================================================== 	}
	{	 Imported Libraries 	}
	{	 ------------------ 	}
	PEFImportedLibraryPtr = ^PEFImportedLibrary;
	PEFImportedLibrary = record
		nameOffset:				UInt32;									{  Loader string table offset of library's name. }
		oldImpVersion:			UInt32;									{  Oldest compatible implementation version. }
		currentVersion:			UInt32;									{  Current version at build time. }
		importedSymbolCount:	UInt32;									{  Imported symbol count for this library. }
		firstImportedSymbol:	UInt32;									{  Index of first imported symbol from this library. }
		options:				SInt8;									{  Option bits for this library. }
		reservedA:				SInt8;									{  Reserved, must be zero. }
		reservedB:				UInt16;									{  Reserved, must be zero. }
	end;


const
																{  Bits for the PEFImportedLibrary options field. }
	kPEFWeakImportLibMask		= $40;							{  The imported library is allowed to be missing. }
	kPEFInitLibBeforeMask		= $80;							{  The imported library must be initialized first. }


	{	 =========================================================================================== 	}
	{	 Imported Symbols 	}
	{	 ---------------- 	}

	{	 -------------------------------------------------------------------------------------------- 	}
	{	 The PEFImportedSymbol type has the following bit field layout.                               	}
	{	                                                                                              	}
	{	                                                                     3                        	}
	{	       0             7 8                                             1                        	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                       	}
	{	      | symbol class  | offset of symbol name in loader string table  |                       	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                       	}
	{	      |<-- 8 bits --->|<-- 24 bits ---------------------------------->|                       	}


type
	PEFImportedSymbolPtr = ^PEFImportedSymbol;
	PEFImportedSymbol = record
		classAndName:			UInt32;
	end;


const
	kPEFImpSymClassShift		= 24;
	kPEFImpSymNameOffsetMask	= $00FFFFFF;
	kPEFImpSymMaxNameOffset		= $00FFFFFF;					{  16,777,215 }


																{  Imported and exported symbol classes. }
	kPEFCodeSymbol				= $00;
	kPEFDataSymbol				= $01;
	kPEFTVectorSymbol			= $02;
	kPEFTOCSymbol				= $03;
	kPEFGlueSymbol				= $04;
	kPEFUndefinedSymbol			= $0F;
	kPEFWeakImportSymMask		= $80;


	{	 =========================================================================================== 	}
	{	 Exported Symbol Hash Table 	}
	{	 -------------------------- 	}

	{	 -------------------------------------------------------------------------------------------- 	}
	{	 Exported symbols are described in four parts, optimized for speed of lookup.  These parts    	}
	{	 are the "export hash table", the "export key table", the "export symbol table", and the      	}
	{	 "export name table".  Overall they contain a flattened representation of a fairly normal     	}
	{	 hashed symbol table.                                                                         	}
	{	                                                                                              	}
	{	 The export hash table is an array of small fixed size elements.  The number of elements is   	}
	{	 a power of 2.  A 32 bit hash word for a symbol is converted into an index into this array.   	}
	{	 Each hash slot contains a count of the number of exported symbols that map to this slot and  	}
	{	 the index of the first of those symbols in the key and symbol tables.  Of course some hash   	}
	{	 slots will have a zero count.                                                                	}
	{	                                                                                              	}
	{	 The key and symbol tables are also arrays of fixed size elements, one for each exported      	}
	{	 symbol.  Their entries are grouped by hash slot, those elements mapping to the same hash     	}
	{	 slot are contiguous.  The key table contains just the full 32 bit hash word for each         	}
	{	 exported symbol.  The symbol table contains the offset of the symbol's name in the string    	}
	{	 table and other information about the exported symbol.                                       	}
	{	                                                                                              	}
	{	 To look up an export you take the hashword and compute the hash slot index.  You then scan   	}
	{	 the indicated portion of the key table for matching hashwords.  If a hashword matches, you   	}
	{	 look at the corresponding symbol table entry to find the full symbol name.  If the names     	}
	{	 match the symbol is found.                                                                   	}

	{	 -------------------------------------------------------------------------------------------- 	}
	{	 The following function may be used to compute the hash table size.  Signed values are used   	}
	{	 just to avoid potential code generation overhead for unsigned division.                      	}
	{	                                                                                              	}
	{	      UInt8   PEFComputeHashTableExponent ( SInt32    exportCount )                           	}
	{	      (                                                                                       	}
	{	          SInt32  exponent;                                                                   	}
	{	                                                                                              	}
	{	          const SInt32    kExponentLimit      = 16;   // Arbitrary, but must not exceed 30.   	}
	{	          const SInt32    kAverageChainLimit  = 10;   // Arbitrary, for space/time tradeoff.  	}
	{	                                                                                              	}
	{	          for ( exponent = 0; exponent < kExponentLimit; exponent += 1 ) (                    	}
	{	              if ( (exportCount / (1 << exponent)) < kAverageChainLimit ) break;              	}
	{	          )                                                                                   	}
	{	                                                                                              	}
	{	          return exponent;                                                                    	}
	{	                                                                                              	}
	{	      )   // PEFComputeHashTableExponent ()                                                   	}

	{	 -------------------------------------------------------------------------------------------- 	}
	{	 The PEFExportedSymbolHashSlot type has the following bit field layout.                       	}
	{	                                                                                              	}
	{	                                 1 1                                 3                        	}
	{	       0                         3 4                                 1                        	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                       	}
	{	      | symbol count              | index of first export key         |                       	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                       	}
	{	      |<-- 14 bits -------------->|<-- 18 bits ---------------------->|                       	}


type
	PEFExportedSymbolHashSlotPtr = ^PEFExportedSymbolHashSlot;
	PEFExportedSymbolHashSlot = record
		countAndStart:			UInt32;
	end;


const
	kPEFHashSlotSymCountShift	= 18;
	kPEFHashSlotFirstKeyMask	= $0003FFFF;
	kPEFHashSlotMaxSymbolCount	= $00003FFF;					{   16,383 }
	kPEFHashSlotMaxKeyIndex		= $0003FFFF;					{  262,143 }


	{	 =========================================================================================== 	}
	{	 Exported Symbol Hash Key 	}
	{	 ------------------------ 	}


type
	PEFSplitHashWordPtr = ^PEFSplitHashWord;
	PEFSplitHashWord = record
		nameLength:				UInt16;
		hashValue:				UInt16;
	end;

	PEFExportedSymbolKeyPtr = ^PEFExportedSymbolKey;
	PEFExportedSymbolKey = record
		case SInt16 of
		0: (
			fullHashWord:		UInt32;
			);
		1: (
			splitHashWord:		PEFSplitHashWord;
			);
	end;


const
	kPEFHashLengthShift			= 16;
	kPEFHashValueMask			= $0000FFFF;
	kPEFHashMaxLength			= $0000FFFF;					{  65,535 }


	{	 ---------------------------------------------------------------------------------------------------- 	}
	{	 The following function computes the full 32 bit hash word.                                           	}
	{	                                                                                                      	}
	{	      UInt32  PEFComputeHashWord  ( BytePtr   nameText,       // ! First "letter", not length byte.   	}
	{	                                    UInt32    nameLength )    // ! The text may be zero terminated.   	}
	{	      (                                                                                               	}
	{	          BytePtr charPtr     = nameText;                                                             	}
	{	          SInt32  hashValue   = 0;        // ! Signed to match old published algorithm.               	}
	{	          UInt32  length      = 0;                                                                    	}
	{	          UInt32  limit;                                                                              	}
	{	          UInt32  result;                                                                             	}
	{	          UInt8   currChar;                                                                           	}
	{	                                                                                                      	}
	{	          #define PseudoRotate(x)  ( ( (x) << 1 ) - ( (x) >> 16 ) )                                   	}
	{	                                                                                                      	}
	{	          for ( limit = nameLength; limit > 0; limit -= 1 ) (                                         	}
	{	              currChar = *charPtr++;                                                                  	}
	{	              if ( currChar == NULL ) break;                                                          	}
	{	              length += 1;                                                                            	}
	{	              hashValue = PseudoRotate ( hashValue ) ^ currChar;                                      	}
	{	          )                                                                                           	}
	{	                                                                                                      	}
	{	          result  = (length << kPEFHashLengthShift) |                                                 	}
	{	                    ((UInt16) ((hashValue ^ (hashValue >> 16)) & kPEFHashValueMask));                 	}
	{	                                                                                                      	}
	{	          return result;                                                                              	}
	{	                                                                                                      	}
	{	      )   // PEFComputeHashWord ()                                                                    	}

	{	 =========================================================================================== 	}
	{	 Exported Symbols 	}
	{	 ---------------- 	}


type
	PEFExportedSymbolPtr = ^PEFExportedSymbol;
	PEFExportedSymbol = record
																		{  ! This structure is 10 bytes long and arrays are packed. }
		classAndName:			UInt32;									{  A combination of class and name offset. }
		symbolValue:			UInt32;									{  Typically the symbol's offset within a section. }
		sectionIndex:			SInt16;									{  The index of the section, or pseudo-section, for the symbol. }
	end;

	{	 -------------------------------------------------------------------------------------------- 	}
	{	 The classAndName field of the PEFExportedSymbol type has the following bit field layout.     	}
	{	                                                                                              	}
	{	                                                                     3                        	}
	{	       0             7 8                                             1                        	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                       	}
	{	      | symbol class  | offset of symbol name in loader string table  |                       	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                       	}
	{	      |<-- 8 bits --->|<-- 24 bits ---------------------------------->|                       	}


const
	kPEFExpSymClassShift		= 24;
	kPEFExpSymNameOffsetMask	= $00FFFFFF;
	kPEFExpSymMaxNameOffset		= $00FFFFFF;					{  16,777,215 }


																{  Negative section indices indicate pseudo-sections. }
	kPEFAbsoluteExport			= -2;							{  The symbol value is an absolute address. }
	kPEFReexportedImport		= -3;							{  The symbol value is the index of a reexported import. }


	{	 =========================================================================================== 	}
	{	 Loader Relocations 	}
	{	 ================== 	}

	{	 -------------------------------------------------------------------------------------------- 	}
	{	 The relocations for a section are defined by a sequence of instructions for an abstract      	}
	{	 machine that is specifically geared to performing relocations commonly needed for the "CFM"  	}
	{	 code generation model.  These instructions occur in 16 bit chunks.  Most instructions have   	}
	{	 just a single chunk.  Instructions that are larger than 16 bits have an opcode and some of   	}
	{	 the operands in the first chunk, with other operands in following chunks.                    	}
	{	                                                                                              	}
	{	 ! Note that the multi-chunk relocations have separate "Compose" macros for each chunk.  The  	}
	{	 ! macros have the same basic name with a positional suffix of "_1st", "_2nd", etc.           	}


type
	PEFRelocChunk						= UInt16;
	PEFLoaderRelocationHeaderPtr = ^PEFLoaderRelocationHeader;
	PEFLoaderRelocationHeader = record
		sectionIndex:			UInt16;									{  Index of the section to be fixed up. }
		reservedA:				UInt16;									{  Reserved, must be zero. }
		relocCount:				UInt32;									{  Number of 16 bit relocation chunks. }
		firstRelocOffset:		UInt32;									{  Offset of first relocation instruction. }
	end;

	{	 -------------------------------------------------------------------------------------------- 	}
	{	 ! Note that the relocCount field is the number of 16 bit relocation chunks, i.e. 1/2 the     	}
	{	 ! total number of bytes of relocation instructions.  While most relocation instructions are  	}
	{	 ! 16 bits long, some are longer so the number of complete relocation instructions may be     	}
	{	 ! less than the relocCount value.                                                            	}

	{	 ------------------------------------------------------------------------------------ 	}
	{	 The PEFRelocField macro is a utility for extracting relocation instruction fields.   	}

	{	 =========================================================================================== 	}
	{	 Basic Relocation Opcodes 	}
	{	 ------------------------ 	}
	{	 -------------------------------------------------------------------------------------------- 	}
	{	 The number of opcode bits varies from 2 to 7.  The enumeration and switch table given here   	}
	{	 are defined in terms of the most significant 7 bits of the first instruction chunk.  An      	}
	{	 instruction is decoded by using the most significant 7 bits as an index into the opcode      	}
	{	 table, which in turn contains appropriately masked forms of the most significant 7 bits.     	}
	{	 The macro PEFRelocBasicOpcode assumes a declaration of the form.                             	}
	{	                                                                                              	}
	{	      UInt8 kPEFRelocBasicOpcodes [kPEFRelocBasicOpcodeRange] = ( PEFMaskedBasicOpcodes );    	}


const
	kPEFRelocBasicOpcodeRange	= 128;


	{	 -------------------------------------------------------------------------------------------- 	}
	{	 The relocation opcodes, clustered by major and minor groups.  The instructions within a      	}
	{	 cluster all have the same bit field layout.  The enumeration values use the high order 7     	}
	{	 bits of the relocation instruction.  Unused low order bits are set to zero.                  	}
	kPEFRelocBySectDWithSkip	= $00;							{  Binary: 00x_xxxx }
	kPEFRelocBySectC			= $20;							{  Binary: 010_0000, group is "RelocRun" }
	kPEFRelocBySectD			= $21;							{  Binary: 010_0001 }
	kPEFRelocTVector12			= $22;							{  Binary: 010_0010 }
	kPEFRelocTVector8			= $23;							{  Binary: 010_0011 }
	kPEFRelocVTable8			= $24;							{  Binary: 010_0100 }
	kPEFRelocImportRun			= $25;							{  Binary: 010_0101 }
	kPEFRelocSmByImport			= $30;							{  Binary: 011_0000, group is "RelocSmIndex" }
	kPEFRelocSmSetSectC			= $31;							{  Binary: 011_0001 }
	kPEFRelocSmSetSectD			= $32;							{  Binary: 011_0010 }
	kPEFRelocSmBySection		= $33;							{  Binary: 011_0011 }
	kPEFRelocIncrPosition		= $40;							{  Binary: 100_0xxx }
	kPEFRelocSmRepeat			= $48;							{  Binary: 100_1xxx }
	kPEFRelocSetPosition		= $50;							{  Binary: 101_000x }
	kPEFRelocLgByImport			= $52;							{  Binary: 101_001x }
	kPEFRelocLgRepeat			= $58;							{  Binary: 101_100x }
	kPEFRelocLgSetOrBySection	= $5A;							{  Binary: 101_101x }
	kPEFRelocUndefinedOpcode	= $FF;							{  Used in masking table for all undefined values. }


	{	 ---------------------------------------------------------------------------- 	}
	{	 The RelocLgSetOrBySection instruction has an additional 4 bits of subopcode  	}
	{	 beyond the 7 used by the dispatch table.  To be precise it has 6 plus 4 but  	}
	{	 the dispatch table ignores the 7th bit, so the subdispatch is on all 4 extra 	}
	{	 subopcode bits.                                                              	}
	kPEFRelocLgBySectionSubopcode = $00;						{  Binary: 0000 }
	kPEFRelocLgSetSectCSubopcode = $01;							{  Binary: 0001 }
	kPEFRelocLgSetSectDSubopcode = $02;							{  Binary: 0010 }


	{	 -------------------------------------------------------------------------------------------- 	}
	{	 The initial values for the opcode "masking" table.  This has the enumeration values from     	}
	{	 above with appropriate replications for "don't care" bits.  It is almost certainly shorter   	}
	{	 and faster to look up the masked value in a table than to use a branch tree.                 	}

	{	 =========================================================================================== 	}
	{	 RelocBySectDWithSkip Instruction (DDAT) 	}
	{	 --------------------------------------- 	}

	{	 -------------------------------------------------------------------------------------------- 	}
	{	 The "RelocBySectDWithSkip" (DDAT) instruction has the following bit field layout.            	}
	{	                                                                                              	}
	{	                           1         1                                                        	}
	{	       0 1 2             9 0         5                                                        	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                                                       	}
	{	      |0 0| skip count    | rel count |                                                       	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                                                       	}
	{	      | 2 |<-- 8 bits --->|<--  6 --->|                                                       	}
	{	                                                                                              	}
	{	 ! Note that the stored skip count and reloc count are the actual values!                     	}
	kPEFRelocWithSkipMaxSkipCount = 255;
	kPEFRelocWithSkipMaxRelocCount = 63;


	{	 =========================================================================================== 	}
	{	 RelocRun Group (CODE, DATA, DESC, DSC2, VTBL, SYMR) 	}
	{	 --------------------------------------------------- 	}

	{	 -------------------------------------------------------------------------------------------- 	}
	{	 The "RelocRun" group includes the "RelocBySectC" (CODE), "RelocBySectD" (DATA),              	}
	{	 "RelocTVector12" (DESC), "RelocTVector8" (DSC2), "RelocVTable8" (VTBL), and                  	}
	{	 "RelocImportRun" (SYMR) instructions.  This group has the following bit field layout.        	}
	{	                                                                                              	}
	{	                                     1                                                        	}
	{	       0   2 3     6 7               5                                                        	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                                                       	}
	{	      |0 1 0| subop.| run length      |                                                       	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                                                       	}
	{	      |  3  |<- 4 ->|<-- 9 bits ----->|                                                       	}
	{	                                                                                              	}
	{	 ! Note that the stored run length is the actual value minus 1, but the macros deal with the  	}
	{	 ! actual value!                                                                              	}
	kPEFRelocRunMaxRunLength	= 512;


	{	 =========================================================================================== 	}
	{	 RelocSmIndex Group (SYMB, CDIS, DTIS, SECN) 	}
	{	 ------------------------------------------- 	}

	{	 -------------------------------------------------------------------------------------------- 	}
	{	 The "RelocSmIndex" group includes the "RelocSmByImport" (SYMB), "RelocSmSetSectC" (CDIS),    	}
	{	 "RelocSmSetSectD" (DTIS) and "RelocSmBySection" (SECN) instructions.  This group has the     	}
	{	 following bit field layout.                                                                  	}
	{	                                                                                              	}
	{	                                     1                                                        	}
	{	       0   2 3     6 7               5                                                        	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                                                       	}
	{	      |0 1 1| subop.| index           |                                                       	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                                                       	}
	{	      |  3  |<- 4 ->|<-- 9 bits ----->|                                                       	}
	{	                                                                                              	}
	{	 ! Note that the stored index is the actual value!                                            	}
	kPEFRelocSmIndexMaxIndex	= 511;


	{	 =========================================================================================== 	}
	{	 RelocIncrPosition Instruction (DELT) 	}
	{	 ------------------------------------ 	}

	{	 -------------------------------------------------------------------------------------------- 	}
	{	 The "RelocIncrPosition" (DELT) instruction has the following bit field layout.               	}
	{	                                                                                              	}
	{	                                     1                                                        	}
	{	       0     3 4                     5                                                        	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                                                       	}
	{	      |1 0 0 0| offset                |                                                       	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                                                       	}
	{	      |<- 4 ->|<-- 12 bits ---------->|                                                       	}
	{	                                                                                              	}
	{	 ! Note that the stored offset is the actual value minus 1, but the macros deal with the      	}
	{	 ! actual value!                                                                              	}
	kPEFRelocIncrPositionMaxOffset = 4096;


	{	 =========================================================================================== 	}
	{	 RelocSmRepeat Instruction (RPT) 	}
	{	 ------------------------------- 	}

	{	 -------------------------------------------------------------------------------------------- 	}
	{	 The "RelocSmRepeat" (RPT) instruction has the following bit field layout.                    	}
	{	                                                                                              	}
	{	                                     1                                                        	}
	{	       0     3 4     7 8             5                                                        	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                                                       	}
	{	      |1 0 0 1| chnks | repeat count  |                                                       	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                                                       	}
	{	      |<- 4 ->|<- 4 ->|<-- 8 bits --->|                                                       	}
	{	                                                                                              	}
	{	 ! Note that the stored chunk count and repeat count are the actual values minus 1, but the   	}
	{	 ! macros deal with the actual values!                                                        	}
	kPEFRelocSmRepeatMaxChunkCount = 16;
	kPEFRelocSmRepeatMaxRepeatCount = 256;


	{	 =========================================================================================== 	}
	{	 RelocSetPosition Instruction (LABS) 	}
	{	 ----------------------------------- 	}

	{	 -------------------------------------------------------------------------------------------- 	}
	{	 The "RelocSetPosition" (LABS) instruction has the following bit field layout.                	}
	{	                                                                                              	}
	{	                                     1                                   1                    	}
	{	       0         5 6                 5     0                             5                    	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                   	}
	{	      |1 0 1 0 0 0| offset (high)     |   | offset (low)                  |                   	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                   	}
	{	      |<-- 6 ---->|<-- 10 bits ------>|   |<-- 16 bits ------------------>|                   	}
	{	                                                                                              	}
	{	 ! Note that the stored offset is the actual value!                                           	}
	kPEFRelocSetPosMaxOffset	= $03FFFFFF;					{  67,108,863 }


	{	 =========================================================================================== 	}
	{	 RelocLgByImport Instruction (LSYM) 	}
	{	 ---------------------------------- 	}

	{	 -------------------------------------------------------------------------------------------- 	}
	{	 The "RelocLgByImport" (LSYM) instruction has the following bit field layout.                 	}
	{	                                                                                              	}
	{	                                     1                                   1                    	}
	{	       0         5 6                 5     0                             5                    	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                   	}
	{	      |1 0 1 0 0 1| index (high)      |   | index (low)                   |                   	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                   	}
	{	      |<-- 6 ---->|<-- 10 bits ------>|   |<-- 16 bits ------------------>|                   	}
	{	                                                                                              	}
	{	 ! Note that the stored offset is the actual value!                                           	}
	kPEFRelocLgByImportMaxIndex	= $03FFFFFF;					{  67,108,863 }


	{	 =========================================================================================== 	}
	{	 RelocLgRepeat Instruction (LRPT) 	}
	{	 -------------------------------- 	}

	{	 -------------------------------------------------------------------------------------------- 	}
	{	 The "RelocLgRepeat" (LRPT) instruction has the following bit field layout.                   	}
	{	                                                                                              	}
	{	                           1         1                                   1                    	}
	{	       0         5 6     9 0         5     0                             5                    	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                   	}
	{	      |1 0 1 1 0 0| chnks | rpt (high)|   | repeat count (low)            |                   	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                   	}
	{	      |<--  6 --->|<- 4 ->|<--  6 --->|   |<-- 16 bits ------------------>|                   	}
	{	                                                                                              	}
	{	 ! Note that the stored chunk count is the actual value minus 1, but the macros deal with     	}
	{	 ! the actual value!  The stored repeat count is the actual value!                            	}
	kPEFRelocLgRepeatMaxChunkCount = 16;
	kPEFRelocLgRepeatMaxRepeatCount = $003FFFFF;				{  4,194,303 }


	{	 =========================================================================================== 	}
	{	 RelocLgSetOrBySection Group (LSEC) 	}
	{	 ---------------------------------- 	}

	{	 -------------------------------------------------------------------------------------------- 	}
	{	 The "RelocLgSetOrBySection" (LSEC) instruction is a group including the "RelocLgBySection",  	}
	{	 "RelocLgSetSectC" and "RelocLgSetSectD" instructions.  This group has the following bit      	}
	{	 field layout.                                                                                	}
	{	                                                                                              	}
	{	                           1         1                                   1                    	}
	{	       0         5 6     9 0         5     0                             5                    	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                   	}
	{	      |1 0 1 1 0 1| subop | idx (high)|   | index (low)                   |                   	}
	{	      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                   	}
	{	      |<--  6 --->|<- 4 ->|<--  6 --->|   |<-- 16 bits ------------------>|                   	}
	{	                                                                                              	}
	{	 ! Note that the stored index is the actual value!                                            	}
	kPEFRelocLgSetOrBySectionMaxIndex = $003FFFFF;				{  4,194,303 }


{$ALIGN MAC68K}


{unit PLStringFuncs}
{
     File:       PLStringFuncs.p
 
     Contains:   Pascal string manipulation routines that parallel ANSI C string.h
 
     Version:    Technology: Mac OS
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   1999-2002 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}

{
 *  PLstrcmp()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function PLstrcmp(const (*var*) str1: Str255; const (*var*) str2: Str255): SInt16; external name '_PLstrcmp';

{
 *  PLstrncmp()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function PLstrncmp(const (*var*) str1: Str255; const (*var*) str2: Str255; num: SInt16): SInt16; external name '_PLstrncmp';

{
 *  PLstrcpy()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function PLstrcpy(str1: StringPtr; const (*var*) str2: Str255): StringPtr; external name '_PLstrcpy';

{
 *  PLstrncpy()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function PLstrncpy(str1: StringPtr; const (*var*) str2: Str255; num: SInt16): StringPtr; external name '_PLstrncpy';

{
 *  PLstrcat()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function PLstrcat(str1: StringPtr; const (*var*) str2: Str255): StringPtr; external name '_PLstrcat';

{
 *  PLstrncat()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function PLstrncat(str1: StringPtr; const (*var*) str2: Str255; num: SInt16): StringPtr; external name '_PLstrncat';

{
 *  PLstrchr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function PLstrchr(const (*var*) str1: Str255; ch1: SInt16): Ptr; external name '_PLstrchr';

{
 *  PLstrrchr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function PLstrrchr(const (*var*) str1: Str255; ch1: SInt16): Ptr; external name '_PLstrrchr';

{
 *  PLstrpbrk()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function PLstrpbrk(const (*var*) str1: Str255; const (*var*) str2: Str255): Ptr; external name '_PLstrpbrk';

{
 *  PLstrspn()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function PLstrspn(const (*var*) str1: Str255; const (*var*) str2: Str255): SInt16; external name '_PLstrspn';

{
 *  PLstrstr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function PLstrstr(const (*var*) str1: Str255; const (*var*) str2: Str255): Ptr; external name '_PLstrstr';

{
 *  PLstrlen()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function PLstrlen(const (*var*) str: Str255): SInt16; external name '_PLstrlen';

{
 *  PLpos()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function PLpos(const (*var*) str1: Str255; const (*var*) str2: Str255): SInt16; external name '_PLpos';


{$ALIGN MAC68K}


{unit SFNTLayoutTypes}
{
     File:       SFNTLayoutTypes.p
 
     Contains:   SFNT file layout structures and constants.
 
     Version:    Technology: Mac OS 9 / Carbon
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   1994-2002 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}

{ ----------------------------------------------------------------------------------------- }
{ CONSTANTS }
{
    The following values can be used to set run feature values. Note that unless the
    feature is defaulted differently in different fonts, the zero value for the
    selectors represents the default value.  Check the following URL site for further info:
    "http://fonts.apple.com/Registry"
}


{
 *  Summary:
 *    Feature types
 }

const
	kAllTypographicFeaturesType	= 0;
	kLigaturesType				= 1;
	kCursiveConnectionType		= 2;
	kLetterCaseType				= 3;
	kVerticalSubstitutionType	= 4;
	kLinguisticRearrangementType = 5;
	kNumberSpacingType			= 6;
	kSmartSwashType				= 8;
	kDiacriticsType				= 9;
	kVerticalPositionType		= 10;
	kFractionsType				= 11;
	kOverlappingCharactersType	= 13;
	kTypographicExtrasType		= 14;
	kMathematicalExtrasType		= 15;
	kOrnamentSetsType			= 16;
	kCharacterAlternativesType	= 17;
	kDesignComplexityType		= 18;
	kStyleOptionsType			= 19;
	kCharacterShapeType			= 20;
	kNumberCaseType				= 21;
	kTextSpacingType			= 22;
	kTransliterationType		= 23;
	kAnnotationType				= 24;
	kKanaSpacingType			= 25;
	kIdeographicSpacingType		= 26;
	kUnicodeDecompositionType	= 27;
	kRubyKanaType				= 28;
	kCJKSymbolAlternativesType	= 29;
	kIdeographicAlternativesType = 30;
	kCJKVerticalRomanPlacementType = 31;
	kItalicCJKRomanType			= 32;
	kCJKRomanSpacingType		= 103;
	kLastFeatureType			= -1;


	{
	 *  Summary:
	 *    Selectors for feature type kAllTypographicFeaturesType
	 	}
	kAllTypeFeaturesOnSelector	= 0;
	kAllTypeFeaturesOffSelector	= 1;


	{
	 *  Summary:
	 *    Selectors for feature type kLigaturesType
	 	}
	kRequiredLigaturesOnSelector = 0;
	kRequiredLigaturesOffSelector = 1;
	kCommonLigaturesOnSelector	= 2;
	kCommonLigaturesOffSelector	= 3;
	kRareLigaturesOnSelector	= 4;
	kRareLigaturesOffSelector	= 5;
	kLogosOnSelector			= 6;
	kLogosOffSelector			= 7;
	kRebusPicturesOnSelector	= 8;
	kRebusPicturesOffSelector	= 9;
	kDiphthongLigaturesOnSelector = 10;
	kDiphthongLigaturesOffSelector = 11;
	kSquaredLigaturesOnSelector	= 12;
	kSquaredLigaturesOffSelector = 13;
	kAbbrevSquaredLigaturesOnSelector = 14;
	kAbbrevSquaredLigaturesOffSelector = 15;
	kSymbolLigaturesOnSelector	= 16;
	kSymbolLigaturesOffSelector	= 17;


	{
	 *  Summary:
	 *    Selectors for feature type kCursiveConnectionType
	 	}
	kUnconnectedSelector		= 0;
	kPartiallyConnectedSelector	= 1;
	kCursiveSelector			= 2;


	{
	 *  Summary:
	 *    Selectors for feature type kLetterCaseType
	 	}
	kUpperAndLowerCaseSelector	= 0;
	kAllCapsSelector			= 1;
	kAllLowerCaseSelector		= 2;
	kSmallCapsSelector			= 3;
	kInitialCapsSelector		= 4;
	kInitialCapsAndSmallCapsSelector = 5;


	{
	 *  Summary:
	 *    Selectors for feature type kVerticalSubstitutionType
	 	}
	kSubstituteVerticalFormsOnSelector = 0;
	kSubstituteVerticalFormsOffSelector = 1;


	{
	 *  Summary:
	 *    Selectors for feature type kLinguisticRearrangementType
	 	}
	kLinguisticRearrangementOnSelector = 0;
	kLinguisticRearrangementOffSelector = 1;


	{
	 *  Summary:
	 *    Selectors for feature type kNumberSpacingType
	 	}
	kMonospacedNumbersSelector	= 0;
	kProportionalNumbersSelector = 1;
	kThirdWidthNumbersSelector	= 2;
	kQuarterWidthNumbersSelector = 3;


	{
	 *  Summary:
	 *    Selectors for feature type kSmartSwashType
	 	}
	kWordInitialSwashesOnSelector = 0;
	kWordInitialSwashesOffSelector = 1;
	kWordFinalSwashesOnSelector	= 2;
	kWordFinalSwashesOffSelector = 3;
	kLineInitialSwashesOnSelector = 4;
	kLineInitialSwashesOffSelector = 5;
	kLineFinalSwashesOnSelector	= 6;
	kLineFinalSwashesOffSelector = 7;
	kNonFinalSwashesOnSelector	= 8;
	kNonFinalSwashesOffSelector	= 9;


	{
	 *  Summary:
	 *    Selectors for feature type kDiacriticsType
	 	}
	kShowDiacriticsSelector		= 0;
	kHideDiacriticsSelector		= 1;
	kDecomposeDiacriticsSelector = 2;


	{
	 *  Summary:
	 *    Selectors for feature type kVerticalPositionType
	 	}
	kNormalPositionSelector		= 0;
	kSuperiorsSelector			= 1;
	kInferiorsSelector			= 2;
	kOrdinalsSelector			= 3;


	{
	 *  Summary:
	 *    Selectors for feature type kFractionsType
	 	}
	kNoFractionsSelector		= 0;
	kVerticalFractionsSelector	= 1;
	kDiagonalFractionsSelector	= 2;


	{
	 *  Summary:
	 *    Selectors for feature type kOverlappingCharactersType
	 	}
	kPreventOverlapOnSelector	= 0;
	kPreventOverlapOffSelector	= 1;


	{
	 *  Summary:
	 *    Selectors for feature type kTypographicExtrasType
	 	}
	kHyphensToEmDashOnSelector	= 0;
	kHyphensToEmDashOffSelector	= 1;
	kHyphenToEnDashOnSelector	= 2;
	kHyphenToEnDashOffSelector	= 3;
	kSlashedZeroOnSelector		= 4;
	kSlashedZeroOffSelector		= 5;
	kFormInterrobangOnSelector	= 6;
	kFormInterrobangOffSelector	= 7;
	kSmartQuotesOnSelector		= 8;
	kSmartQuotesOffSelector		= 9;
	kPeriodsToEllipsisOnSelector = 10;
	kPeriodsToEllipsisOffSelector = 11;


	{
	 *  Summary:
	 *    Selectors for feature type kMathematicalExtrasType
	 	}
	kHyphenToMinusOnSelector	= 0;
	kHyphenToMinusOffSelector	= 1;
	kAsteriskToMultiplyOnSelector = 2;
	kAsteriskToMultiplyOffSelector = 3;
	kSlashToDivideOnSelector	= 4;
	kSlashToDivideOffSelector	= 5;
	kInequalityLigaturesOnSelector = 6;
	kInequalityLigaturesOffSelector = 7;
	kExponentsOnSelector		= 8;
	kExponentsOffSelector		= 9;


	{
	 *  Summary:
	 *    Selectors for feature type kOrnamentSetsType
	 	}
	kNoOrnamentsSelector		= 0;
	kDingbatsSelector			= 1;
	kPiCharactersSelector		= 2;
	kFleuronsSelector			= 3;
	kDecorativeBordersSelector	= 4;
	kInternationalSymbolsSelector = 5;
	kMathSymbolsSelector		= 6;


	{
	 *  Summary:
	 *    Selectors for feature type kCharacterAlternativesType
	 	}
	kNoAlternatesSelector		= 0;


	{
	 *  Summary:
	 *    Selectors for feature type kDesignComplexityType
	 	}
	kDesignLevel1Selector		= 0;
	kDesignLevel2Selector		= 1;
	kDesignLevel3Selector		= 2;
	kDesignLevel4Selector		= 3;
	kDesignLevel5Selector		= 4;


	{
	 *  Summary:
	 *    Selectors for feature type kStyleOptionsType
	 	}
	kNoStyleOptionsSelector		= 0;
	kDisplayTextSelector		= 1;
	kEngravedTextSelector		= 2;
	kIlluminatedCapsSelector	= 3;
	kTitlingCapsSelector		= 4;
	kTallCapsSelector			= 5;


	{
	 *  Summary:
	 *    Selectors for feature type kCharacterShapeType
	 	}
	kTraditionalCharactersSelector = 0;
	kSimplifiedCharactersSelector = 1;
	kJIS1978CharactersSelector	= 2;
	kJIS1983CharactersSelector	= 3;
	kJIS1990CharactersSelector	= 4;
	kTraditionalAltOneSelector	= 5;
	kTraditionalAltTwoSelector	= 6;
	kTraditionalAltThreeSelector = 7;
	kTraditionalAltFourSelector	= 8;
	kTraditionalAltFiveSelector	= 9;
	kExpertCharactersSelector	= 10;


	{
	 *  Summary:
	 *    Selectors for feature type kNumberCaseType
	 	}
	kLowerCaseNumbersSelector	= 0;
	kUpperCaseNumbersSelector	= 1;


	{
	 *  Summary:
	 *    Selectors for feature type kTextSpacingType
	 	}
	kProportionalTextSelector	= 0;
	kMonospacedTextSelector		= 1;
	kHalfWidthTextSelector		= 2;
	kNormallySpacedTextSelector	= 3;


	{
	 *  Summary:
	 *    Selectors for feature type kTransliterationType
	 	}
	kNoTransliterationSelector	= 0;
	kHanjaToHangulSelector		= 1;
	kHiraganaToKatakanaSelector	= 2;
	kKatakanaToHiraganaSelector	= 3;
	kKanaToRomanizationSelector	= 4;
	kRomanizationToHiraganaSelector = 5;
	kRomanizationToKatakanaSelector = 6;
	kHanjaToHangulAltOneSelector = 7;
	kHanjaToHangulAltTwoSelector = 8;
	kHanjaToHangulAltThreeSelector = 9;


	{
	 *  Summary:
	 *    Selectors for feature type kAnnotationType
	 	}
	kNoAnnotationSelector		= 0;
	kBoxAnnotationSelector		= 1;
	kRoundedBoxAnnotationSelector = 2;
	kCircleAnnotationSelector	= 3;
	kInvertedCircleAnnotationSelector = 4;
	kParenthesisAnnotationSelector = 5;
	kPeriodAnnotationSelector	= 6;
	kRomanNumeralAnnotationSelector = 7;
	kDiamondAnnotationSelector	= 8;
	kInvertedBoxAnnotationSelector = 9;
	kInvertedRoundedBoxAnnotationSelector = 10;


	{
	 *  Summary:
	 *    Selectors for feature type kKanaSpacingType
	 	}
	kFullWidthKanaSelector		= 0;
	kProportionalKanaSelector	= 1;


	{
	 *  Summary:
	 *    Selectors for feature type kIdeographicSpacingType
	 	}
	kFullWidthIdeographsSelector = 0;
	kProportionalIdeographsSelector = 1;
	kHalfWidthIdeographsSelector = 2;


	{
	 *  Summary:
	 *    Selectors for feature type kUnicodeDecompositionType
	 	}
	kCanonicalCompositionOnSelector = 0;
	kCanonicalCompositionOffSelector = 1;
	kCompatibilityCompositionOnSelector = 2;
	kCompatibilityCompositionOffSelector = 3;
	kTranscodingCompositionOnSelector = 4;
	kTranscodingCompositionOffSelector = 5;


	{
	 *  Summary:
	 *    Selectors for feature type kRubyKanaType
	 	}
	kNoRubyKanaSelector			= 0;
	kRubyKanaSelector			= 1;


	{
	 *  Summary:
	 *    Selectors for feature type kCJKSymbolAlternativesType
	 	}
	kNoCJKSymbolAlternativesSelector = 0;
	kCJKSymbolAltOneSelector	= 1;
	kCJKSymbolAltTwoSelector	= 2;
	kCJKSymbolAltThreeSelector	= 3;
	kCJKSymbolAltFourSelector	= 4;
	kCJKSymbolAltFiveSelector	= 5;


	{
	 *  Summary:
	 *    Selectors for feature type kIdeographicAlternativesType
	 	}
	kNoIdeographicAlternativesSelector = 0;
	kIdeographicAltOneSelector	= 1;
	kIdeographicAltTwoSelector	= 2;
	kIdeographicAltThreeSelector = 3;
	kIdeographicAltFourSelector	= 4;
	kIdeographicAltFiveSelector	= 5;


	{
	 *  Summary:
	 *    Selectors for feature type kCJKVerticalRomanPlacementType
	 	}
	kCJKVerticalRomanCenteredSelector = 0;
	kCJKVerticalRomanHBaselineSelector = 1;


	{
	 *  Summary:
	 *    Selectors for feature type kItalicCJKRomanType
	 	}
	kNoCJKItalicRomanSelector	= 0;
	kCJKItalicRomanSelector		= 1;


	{
	 *  Summary:
	 *    Selectors for feature type kCJKRomanSpacingType
	 	}
	kHalfWidthCJKRomanSelector	= 0;
	kProportionalCJKRomanSelector = 1;
	kDefaultCJKRomanSelector	= 2;
	kFullWidthCJKRomanSelector	= 3;

	{	 --------------------------------------------------------------------------- 	}
	{	 ---------------- Table Specific Typedefs and Constants -------------------- 	}
	{	 --------------------------------------------------------------------------- 	}
	{	 FORMATS FOR TABLE: lookup tables - used within various other tables 	}
	kSFNTLookupSimpleArray		= 0;							{  a simple array indexed by glyph code  }
	kSFNTLookupSegmentSingle	= 2;							{  segment mapping to single value  }
	kSFNTLookupSegmentArray		= 4;							{  segment mapping to lookup array  }
	kSFNTLookupSingleTable		= 6;							{  sorted list of glyph, value pairs  }
	kSFNTLookupTrimmedArray		= 8;							{  a simple trimmed array indexed by glyph code  }


type
	SFNTLookupTableFormat				= UInt16;
	SFNTLookupValue						= UInt16;
	SFNTLookupOffset					= UInt16;
	SFNTLookupKind						= UInt32;
	{	
	    A BinarySearchHeader defines the five standard fields needed to perform quick
	    lookups in a lookup table (note that using UInt16s, and not ItemCounts or
	    similar types, is important here, since these tables are in fonts, and the
	    documented font formats specify 16-bit quantities).
		}
	SFNTLookupBinarySearchHeaderPtr = ^SFNTLookupBinarySearchHeader;
	SFNTLookupBinarySearchHeader = record
		unitSize:				UInt16;									{  size of a unit in bytes  }
		nUnits:					UInt16;									{  number of units in table  }
		searchRange:			UInt16;									{  (largest power of two <= nUnits) * unitSize  }
		entrySelector:			UInt16;									{  log2 (largest power of two <= nUnits)  }
		rangeShift:				UInt16;									{  (nUnits - largest power of two <= nUnits) * unitSize  }
	end;

	{	 A format 0 lookup table maps all glyphs in the font to lookup values 	}
	SFNTLookupArrayHeaderPtr = ^SFNTLookupArrayHeader;
	SFNTLookupArrayHeader = record
		lookupValues:			array [0..0] of SFNTLookupValue;
	end;

	{	 A format 8 lookup table maps some range of glyphs in the font to lookup values 	}
	SFNTLookupTrimmedArrayHeaderPtr = ^SFNTLookupTrimmedArrayHeader;
	SFNTLookupTrimmedArrayHeader = record
		firstGlyph:				UInt16;
		count:					UInt16;
		valueArray:				array [0..0] of SFNTLookupValue;
	end;

	{	
	    Format 2 and format 4 lookup tables map ranges of glyphs to either single lookup
	    values (format 2), or per-glyph lookup values (format 4). Since both formats
	    use the same kind of data, only one unified set of segment-related structures
	    is defined.
		}
	SFNTLookupSegmentPtr = ^SFNTLookupSegment;
	SFNTLookupSegment = record
		lastGlyph:				UInt16;
		firstGlyph:				UInt16;
		value:					array [0..0] of UInt16;
	end;

	SFNTLookupSegmentHeaderPtr = ^SFNTLookupSegmentHeader;
	SFNTLookupSegmentHeader = record
		binSearch:				SFNTLookupBinarySearchHeader;
		segments:				array [0..0] of SFNTLookupSegment;
	end;

	{	 A format 6 lookup table maps single glyphs to lookup values. 	}
	SFNTLookupSinglePtr = ^SFNTLookupSingle;
	SFNTLookupSingle = record
		glyph:					UInt16;
		value:					array [0..0] of UInt16;
	end;

	SFNTLookupSingleHeaderPtr = ^SFNTLookupSingleHeader;
	SFNTLookupSingleHeader = record
		binSearch:				SFNTLookupBinarySearchHeader;
		entries:				array [0..0] of SFNTLookupSingle;
	end;

	{	 The format-specific part of the subtable header 	}
	SFNTLookupFormatSpecificHeaderPtr = ^SFNTLookupFormatSpecificHeader;
	SFNTLookupFormatSpecificHeader = record
		case SInt16 of
		0: (
			theArray:			SFNTLookupArrayHeader;
			);
		1: (
			segment:			SFNTLookupSegmentHeader;
			);
		2: (
			single:				SFNTLookupSingleHeader;
			);
		3: (
			trimmedArray:		SFNTLookupTrimmedArrayHeader;
			);
	end;

	{	 The overall subtable header 	}
	SFNTLookupTablePtr = ^SFNTLookupTable;
	SFNTLookupTable = record
		format:					SFNTLookupTableFormat;					{  table format  }
		fsHeader:				SFNTLookupFormatSpecificHeader;			{  format specific header  }
	end;

	SFNTLookupTableHandle				= ^SFNTLookupTablePtr;
	{	 --------------------------------------------------------------------------- 	}
	{	 GENERAL FORMATS FOR STATE TABLES -- prefix "ST" 	}

const
	kSTClassEndOfText			= 0;
	kSTClassOutOfBounds			= 1;
	kSTClassDeletedGlyph		= 2;
	kSTClassEndOfLine			= 3;
	kSTSetMark					= $8000;
	kSTNoAdvance				= $4000;
	kSTMarkEnd					= $2000;
	kSTLigActionMask			= $3FFF;
	kSTRearrVerbMask			= $000F;


type
	STClass								= UInt8;
	STEntryIndex						= UInt8;
	STHeaderPtr = ^STHeader;
	STHeader = record
		filler:					SInt8;
		nClasses:				SInt8;
		classTableOffset:		UInt16;
		stateArrayOffset:		UInt16;
		entryTableOffset:		UInt16;
	end;

	STClassTablePtr = ^STClassTable;
	STClassTable = record
		firstGlyph:				UInt16;
		nGlyphs:				UInt16;
		classes:				SInt8;
	end;

	STEntryZeroPtr = ^STEntryZero;
	STEntryZero = record
		newState:				UInt16;
		flags:					UInt16;
	end;

	STEntryOnePtr = ^STEntryOne;
	STEntryOne = record
		newState:				UInt16;
		flags:					UInt16;
		offset1:				UInt16;
	end;

	STEntryTwoPtr = ^STEntryTwo;
	STEntryTwo = record
		newState:				UInt16;
		flags:					UInt16;
		offset1:				UInt16;
		offset2:				UInt16;
	end;

	{	 --------------------------------------------------------------------------- 	}
	{	 GENERAL FORMATS FOR STATE TABLES to be used with 'morx' tables -- prefix "STX" 	}

const
	kSTXHasLigAction			= $2000;


type
	STXClass							= UInt16;
	STXStateIndex						= UInt16;
	STXEntryIndex						= UInt16;
	STXHeaderPtr = ^STXHeader;
	STXHeader = record
		nClasses:				UInt32;
		classTableOffset:		UInt32;
		stateArrayOffset:		UInt32;
		entryTableOffset:		UInt32;
	end;

	STXClassTable						= SFNTLookupTable;
	STXClassTablePtr 					= ^STXClassTable;
	STXEntryZeroPtr = ^STXEntryZero;
	STXEntryZero = record
		newState:				STXStateIndex;
		flags:					UInt16;
	end;

	STXEntryOnePtr = ^STXEntryOne;
	STXEntryOne = record
		newState:				STXStateIndex;
		flags:					UInt16;
		index1:					UInt16;
	end;

	STXEntryTwoPtr = ^STXEntryTwo;
	STXEntryTwo = record
		newState:				STXStateIndex;
		flags:					UInt16;
		index1:					UInt16;
		index2:					UInt16;
	end;

	{	 --------------------------------------------------------------------------- 	}
	{	 FORMATS FOR TABLE: 'lcar' 	}
	{	 CONSTANTS 	}

const
	kLCARTag					= $6C636172;					{  'lcar'  }
	kLCARCurrentVersion			= $00010000;					{  current version number for 'lcar' table  }
	kLCARLinearFormat			= 0;
	kLCARCtlPointFormat			= 1;

	{	 TYPES 	}

type
	LcarCaretClassEntryPtr = ^LcarCaretClassEntry;
	LcarCaretClassEntry = record
		count:					UInt16;
		partials:				array [0..0] of UInt16;					{  these are either FUnits or control-point numbers  }
	end;

	LcarCaretTablePtr = ^LcarCaretTable;
	LcarCaretTable = record
		version:				Fixed;
		format:					UInt16;
		lookup:					SFNTLookupTable;
	end;

	{	 --------------------------------------------------------------------------- 	}
	{	 FORMATS FOR TABLE: 'just' 	}
	{	 CONSTANTS 	}

const
	kJUSTTag					= $6A757374;					{  'just'  }
	kJUSTCurrentVersion			= $00010000;
	kJUSTStandardFormat			= 0;
	kJUSTnoGlyphcode			= $FFFF;						{  used in a pcConditionalAddAction  }
	kJUSTpcDecompositionAction	= 0;
	kJUSTpcUnconditionalAddAction = 1;
	kJUSTpcConditionalAddAction	= 2;
	kJUSTpcGlyphStretchAction	= 3;
	kJUSTpcDuctilityAction		= 4;
	kJUSTpcGlyphRepeatAddAction	= 5;

	{	 Justification priority levels 	}
	kJUSTKashidaPriority		= 0;
	kJUSTSpacePriority			= 1;
	kJUSTLetterPriority			= 2;
	kJUSTNullPriority			= 3;
	kJUSTPriorityCount			= 4;

	{	 Justification flags 	}
	kJUSTOverridePriority		= $8000;
	kJUSTOverrideLimits			= $4000;
	kJUSTOverrideUnlimited		= $2000;
	kJUSTUnlimited				= $1000;
	kJUSTPriorityMask			= $0003;

	{	 TYPES 	}

type
	JustPCActionType					= UInt16;
	JustificationFlags					= UInt16;
	{	 A JustPCDecompositionAction defines a ligature decomposition action. 	}
	JustPCDecompositionActionPtr = ^JustPCDecompositionAction;
	JustPCDecompositionAction = record
		lowerLimit:				Fixed;
		upperLimit:				Fixed;
		order:					UInt16;
		count:					UInt16;
		glyphs:					array [0..0] of UInt16;
	end;

	{	 A JUSTPCUnconditionalAddAction defines an unconditional glyph add action. 	}
	JustPCUnconditionalAddAction		= UInt16;
	{	
	    A JUSTPCConditionalAddAction defines a glyph substitution and add action. If the addGlyph
	    is equal to kJUSTnoGlyphcode, then no glyph will be added, and the justification for
	    the line will be redone.
		}
	JustPCConditionalAddActionPtr = ^JustPCConditionalAddAction;
	JustPCConditionalAddAction = record
		substThreshhold:		Fixed;									{  threshhold of growth factor at which subst occurs  }
		addGlyph:				UInt16;
		substGlyph:				UInt16;
	end;

	{	 A PCDuctilityAction defines a ductile axis along which the glyph will be varied. 	}
	JustPCDuctilityActionPtr = ^JustPCDuctilityAction;
	JustPCDuctilityAction = record
		ductilityAxis:			UInt32;
		minimumLimit:			Fixed;
		noStretchValue:			Fixed;
		maximumLimit:			Fixed;
	end;

	{	
	    A PCGlyphRepetitionAction defines a glyph which will not be stretched or otherwise
	    transformed, but rather which will be emplaced however many times are needed to fill
	    the needed gap.
		}
	JustPCGlyphRepeatAddActionPtr = ^JustPCGlyphRepeatAddAction;
	JustPCGlyphRepeatAddAction = record
		flags:					UInt16;
		glyph:					UInt16;
	end;

	{	 PCActionSubrecords contain the actual postcompensation actions. 	}
	JustPCActionSubrecordPtr = ^JustPCActionSubrecord;
	JustPCActionSubrecord = record
		theClass:				UInt16;									{  justification class value associated with this rec  }
		theType:				JustPCActionType;
		length:					UInt32;
		data:					UInt32;									{  not really a UInt32; cast as ptr to appropriate action  }
	end;

	{	 The set of postcompensation records is defined in a PCAction struct. 	}
	JustPCActionPtr = ^JustPCAction;
	JustPCAction = record
		actionCount:			UInt32;									{  long for alignment purposes  }
		actions:				array [0..0] of JustPCActionSubrecord;
	end;

	{	
	    JustWidthDeltaEntry is the justification table entry structure.  The justClass value (which is
	    actually limited to 7 bits by the state table structure) is defined as a long for PPC alignment reasons.
		}
	JustWidthDeltaEntryPtr = ^JustWidthDeltaEntry;
	JustWidthDeltaEntry = record
		justClass:				UInt32;
		beforeGrowLimit:		Fixed;									{  ems AW can grow by at most on LT  }
		beforeShrinkLimit:		Fixed;									{  ems AW can shrink by at most on LT  }
		afterGrowLimit:			Fixed;									{  ems AW can grow by at most on RB  }
		afterShrinkLimit:		Fixed;									{  ems AW can shrink by at most on RB  }
		growFlags:				JustificationFlags;						{  flags controlling grow case  }
		shrinkFlags:			JustificationFlags;						{  flags controlling shrink case  }
	end;

	JustWidthDeltaGroupPtr = ^JustWidthDeltaGroup;
	JustWidthDeltaGroup = record
		count:					UInt32;
		entries:				array [0..0] of JustWidthDeltaEntry;
	end;

	{	 Overall structure of a postcompensation table is defined in PostcompTable. 	}
	JustPostcompTablePtr = ^JustPostcompTable;
	JustPostcompTable = record
		lookupTable:			SFNTLookupTable;
																		{  action records here  }
	end;

	JustDirectionTablePtr = ^JustDirectionTable;
	JustDirectionTable = record
		justClass:				UInt16;									{  offset to state table (0=none)  }
		widthDeltaClusters:		UInt16;									{  offset to clusters  }
		postcomp:				UInt16;									{  offset to postcomp table (0=none)  }
		lookup:					SFNTLookupTable;
	end;

	JustTablePtr = ^JustTable;
	JustTable = record
		version:				Fixed;
		format:					UInt16;
		horizHeaderOffset:		UInt16;
		vertHeaderOffset:		UInt16;
	end;

	{	 --------------------------------------------------------------------------- 	}
	{	 FORMATS FOR TABLE: 'opbd' 	}
	{	 CONSTANTS 	}

const
	kOPBDTag					= $6F706264;					{  'opbd'  }
	kOPBDCurrentVersion			= $00010000;
	kOPBDDistanceFormat			= 0;
	kOPBDControlPointFormat		= 1;

	{	 TYPES 	}

type
	OpbdTableFormat						= UInt16;
	{	
	    The OpbdSideValues struct is the lookup result from the FindSingle call for the
	    optical tables. It contains the 4 FUnit values that are relevant to the specified
	    glyph, or the 4 control gxPoint values.
		}
	OpbdSideValuesPtr = ^OpbdSideValues;
	OpbdSideValues = record
		leftSideShift:			SInt16;
		topSideShift:			SInt16;
		rightSideShift:			SInt16;
		bottomSideShift:		SInt16;
	end;

	OpbdTablePtr = ^OpbdTable;
	OpbdTable = record
		version:				Fixed;
		format:					OpbdTableFormat;
		lookupTable:			SFNTLookupTable;
	end;

	{	 --------------------------------------------------------------------------- 	}
	{	 FORMATS FOR TABLE: 'mort' 	}
	{	 CONSTANTS 	}

const
	kMORTTag					= $6D6F7274;					{  'mort'  }
	kMORTCurrentVersion			= $00010000;					{  current version number for 'mort' table  }
																{  Coverage masks  }
	kMORTCoverVertical			= $8000;
	kMORTCoverDescending		= $4000;
	kMORTCoverIgnoreVertical	= $2000;
	kMORTCoverTypeMask			= $000F;						{  Subtable types  }
	kMORTRearrangementType		= 0;
	kMORTContextualType			= 1;
	kMORTLigatureType			= 2;
	kMORTSwashType				= 4;
	kMORTInsertionType			= 5;							{  Ligature subtable constants  }
	kMORTLigLastAction			= $80000000;
	kMORTLigStoreLigature		= $40000000;
	kMORTLigFormOffsetMask		= $3FFFFFFF;
	kMORTLigFormOffsetShift		= 2;							{  Rearrangement subtable actions  }
	kMORTraNoAction				= 0;							{     no action    }
	kMORTraxA					= 1;							{       Ax => xA     }
	kMORTraDx					= 2;							{       xD => Dx     }
	kMORTraDxA					= 3;							{      AxD => DxA    }
	kMORTraxAB					= 4;							{    ABx => xAB    }
	kMORTraxBA					= 5;							{    ABx => xBA    }
	kMORTraCDx					= 6;							{    xCD => CDx    }
	kMORTraDCx					= 7;							{    xCD => DCx    }
	kMORTraCDxA					= 8;							{   AxCD => CDxA   }
	kMORTraDCxA					= 9;							{   AxCD => DCxA   }
	kMORTraDxAB					= 10;							{   ABxD => DxAB   }
	kMORTraDxBA					= 11;							{   ABxD => DxBA   }
	kMORTraCDxAB				= 12;							{  ABxCD => CDxAB  }
	kMORTraCDxBA				= 13;							{  ABxCD => CDxBA  }
	kMORTraDCxAB				= 14;							{  ABxCD => DCxAB  }
	kMORTraDCxBA				= 15;							{  ABxCD => DCxBA  }
																{  Insertion subtable constants  }
	kMORTDoInsertionsBefore		= $80;
	kMORTIsSplitVowelPiece		= $40;
	kMORTInsertionsCountMask	= $3F;
	kMORTCurrInsertKashidaLike	= $2000;
	kMORTMarkInsertKashidaLike	= $1000;
	kMORTCurrInsertBefore		= $0800;
	kMORTMarkInsertBefore		= $0400;
	kMORTMarkJustTableCountMask	= $3F80;
	kMORTMarkJustTableCountShift = 7;							{  JustTableIndex for marked character  }
	kMORTCurrJustTableCountMask	= $007F;
	kMORTCurrJustTableCountShift = 0;							{  JustTableIndex for current character  }
	kMORTCurrInsertCountMask	= $03E0;
	kMORTCurrInsertCountShift	= 5;							{  count to insert after current glyphRec  }
	kMORTMarkInsertCountMask	= $001F;
	kMORTMarkInsertCountShift	= 0;							{  count to insert after marked glyphRec  }

	{	 TYPES 	}

type
	MortSubtableMaskFlags				= UInt32;
	MortLigatureActionEntry				= UInt32;
	MortRearrangementSubtablePtr = ^MortRearrangementSubtable;
	MortRearrangementSubtable = record
		header:					STHeader;
	end;

	MortContextualSubtablePtr = ^MortContextualSubtable;
	MortContextualSubtable = record
		header:					STHeader;
		substitutionTableOffset: UInt16;
	end;

	MortLigatureSubtablePtr = ^MortLigatureSubtable;
	MortLigatureSubtable = record
		header:					STHeader;
		ligatureActionTableOffset: UInt16;
		componentTableOffset:	UInt16;
		ligatureTableOffset:	UInt16;
	end;

	MortSwashSubtablePtr = ^MortSwashSubtable;
	MortSwashSubtable = record
		lookup:					SFNTLookupTable;
	end;

	MortInsertionSubtablePtr = ^MortInsertionSubtable;
	MortInsertionSubtable = record
		header:					STHeader;
	end;

	MortSpecificSubtablePtr = ^MortSpecificSubtable;
	MortSpecificSubtable = record
		case SInt16 of
		0: (
			rearrangement:		MortRearrangementSubtable;
			);
		1: (
			contextual:			MortContextualSubtable;
			);
		2: (
			ligature:			MortLigatureSubtable;
			);
		3: (
			swash:				MortSwashSubtable;
			);
		4: (
			insertion:			MortInsertionSubtable;
			);
	end;

	MortSubtablePtr = ^MortSubtable;
	MortSubtable = record
		length:					UInt16;
		coverage:				UInt16;
		flags:					MortSubtableMaskFlags;
		u:						MortSpecificSubtable;
	end;

	MortFeatureEntryPtr = ^MortFeatureEntry;
	MortFeatureEntry = record
		featureType:			UInt16;
		featureSelector:		UInt16;
		enableFlags:			MortSubtableMaskFlags;
		disableFlags:			MortSubtableMaskFlags;
	end;

	MortChainPtr = ^MortChain;
	MortChain = record
		defaultFlags:			MortSubtableMaskFlags;					{  default flags for this chain  }
		length:					UInt32;									{  byte length of this chain  }
		nFeatures:				UInt16;									{  number of feature entries  }
		nSubtables:				UInt16;									{  number of subtables  }
		featureEntries:			array [0..0] of MortFeatureEntry;
																		{  the subtables follow  }
	end;

	MortTablePtr = ^MortTable;
	MortTable = record
		version:				Fixed;
		nChains:				UInt32;
		chains:					array [0..0] of MortChain;
	end;

	{	 --------------------------------------------------------------------------- 	}
	{	 FORMATS FOR TABLE: 'morx' (version 2 and beyond metamorphosis tables) 	}
	{	 CONSTANTS 	}

const
	kMORXTag					= $6D6F7278;					{  'morx'  }
	kMORXCurrentVersion			= $00020000;					{  version number for current 'morx' table  }
																{  Coverage masks  }
	kMORXCoverVertical			= $80000000;
	kMORXCoverDescending		= $40000000;
	kMORXCoverIgnoreVertical	= $20000000;
	kMORXCoverTypeMask			= $000000FF;

	{	 TYPES 	}

type
	MorxRearrangementSubtablePtr = ^MorxRearrangementSubtable;
	MorxRearrangementSubtable = record
		header:					STXHeader;
	end;

	MorxContextualSubtablePtr = ^MorxContextualSubtable;
	MorxContextualSubtable = record
		header:					STXHeader;
		substitutionTableOffset: UInt32;
	end;

	MorxLigatureSubtablePtr = ^MorxLigatureSubtable;
	MorxLigatureSubtable = record
		header:					STXHeader;
		ligatureActionTableOffset: UInt32;
		componentTableOffset:	UInt32;
		ligatureTableOffset:	UInt32;
	end;

	MorxInsertionSubtablePtr = ^MorxInsertionSubtable;
	MorxInsertionSubtable = record
		header:					STXHeader;
		insertionGlyphTableOffset: UInt32;
	end;

	MorxSpecificSubtablePtr = ^MorxSpecificSubtable;
	MorxSpecificSubtable = record
		case SInt16 of
		0: (
			rearrangement:		MorxRearrangementSubtable;
			);
		1: (
			contextual:			MorxContextualSubtable;
			);
		2: (
			ligature:			MorxLigatureSubtable;
			);
		3: (
			swash:				MortSwashSubtable;
			);
		4: (
			insertion:			MorxInsertionSubtable;
			);
	end;

	MorxSubtablePtr = ^MorxSubtable;
	MorxSubtable = record
		length:					UInt32;
		coverage:				UInt32;
		flags:					MortSubtableMaskFlags;
		u:						MorxSpecificSubtable;
	end;

	MorxChainPtr = ^MorxChain;
	MorxChain = record
		defaultFlags:			MortSubtableMaskFlags;					{  default flags for this chain  }
		length:					UInt32;									{  byte length of this chain  }
		nFeatures:				UInt32;									{  number of feature entries  }
		nSubtables:				UInt32;									{  number of subtables  }
		featureEntries:			array [0..0] of MortFeatureEntry;
																		{  the subtables follow  }
	end;

	MorxTablePtr = ^MorxTable;
	MorxTable = record
		version:				Fixed;
		nChains:				UInt32;
		chains:					array [0..0] of MorxChain;
	end;

	{	 --------------------------------------------------------------------------- 	}
	{	 FORMATS FOR TABLE: 'prop' 	}
	{	 CONSTANTS 	}

const
	kPROPTag					= $70726F70;					{  'prop'  }
	kPROPCurrentVersion			= $00020000;					{  current version number for 'prop' table  }
	kPROPPairOffsetShift		= 8;
	kPROPPairOffsetSign			= 7;
	kPROPIsFloaterMask			= $8000;						{  glyph is floater  }
	kPROPCanHangLTMask			= $4000;						{  glyph can hang left/top  }
	kPROPCanHangRBMask			= $2000;						{  glyph can hang right/bottom  }
	kPROPUseRLPairMask			= $1000;						{  if glyph lands in RL streak, use paired glyph  }
	kPROPPairOffsetMask			= $0F00;						{  4-bit signed offset to other pair member  }
	kPROPRightConnectMask		= $0080;						{  glyph connects to glyph on right  }
	kPROPZeroReserved			= $0060;						{  must be zero  }
	kPROPDirectionMask			= $001F;						{  direction bits  }

	{	 These are the Unicode direction classes (plus the Special European Number class). 	}
	kPROPLDirectionClass		= 0;							{  Left-to-Right  }
	kPROPRDirectionClass		= 1;							{  Right-to-Left  }
	kPROPALDirectionClass		= 2;							{  Right-to-Left Arabic Letter  }
	kPROPENDirectionClass		= 3;							{  European Number  }
	kPROPESDirectionClass		= 4;							{  European Number Seperator  }
	kPROPETDirectionClass		= 5;							{  European Number Terminator  }
	kPROPANDirectionClass		= 6;							{  Arabic Number  }
	kPROPCSDirectionClass		= 7;							{  Common Number Seperator  }
	kPROPPSDirectionClass		= 8;							{  Paragraph Seperator (also referred to as Block Separator)  }
	kPROPSDirectionClass		= 9;							{  Segment Seperator  }
	kPROPWSDirectionClass		= 10;							{  Whitespace  }
	kPROPONDirectionClass		= 11;							{  Other Neutral  }
	kPROPSENDirectionClass		= 12;							{  Special European Number (not a Unicode class)  }
	kPROPLREDirectionClass		= 13;							{  Left-to-Right Embeding  }
	kPROPLRODirectionClass		= 14;							{  Left-to-Right Override  }
	kPROPRLEDirectionClass		= 15;							{  Right-to-Left Embeding  }
	kPROPRLODirectionClass		= 16;							{  Right-to-Left Override  }
	kPROPPDFDirectionClass		= 17;							{  Pop Directional Format  }
	kPROPNSMDirectionClass		= 18;							{  Non-Spacing Mark  }
	kPROPBNDirectionClass		= 19;							{  Boundary Neutral  }
	kPROPNumDirectionClasses	= 20;							{  Number of Unicode directional types + Special European Number  }

	{	 TYPES 	}

type
	PropCharProperties					= UInt16;
	PropTablePtr = ^PropTable;
	PropTable = record
		version:				Fixed;
		format:					UInt16;
		defaultProps:			PropCharProperties;
		lookup:					SFNTLookupTable;
	end;

	PropLookupSegmentPtr = ^PropLookupSegment;
	PropLookupSegment = record
		lastGlyph:				UInt16;
		firstGlyph:				UInt16;
		value:					UInt16;
	end;

	PropLookupSinglePtr = ^PropLookupSingle;
	PropLookupSingle = record
		glyph:					UInt16;
		props:					PropCharProperties;
	end;

	{	 --------------------------------------------------------------------------- 	}
	{	 FORMATS FOR TABLE: 'trak' 	}
	{	 CONSTANTS 	}

const
	kTRAKTag					= $7472616B;					{  'trak'  }
	kTRAKCurrentVersion			= $00010000;					{  current version number for 'trak' table  }
	kTRAKUniformFormat			= 0;							{     kTRAKPerGlyphFormat         = 2 }

	{	 TYPES 	}

type
	TrakValue							= SInt16;
	TrakTableEntryPtr = ^TrakTableEntry;
	TrakTableEntry = record
		track:					Fixed;
		nameTableIndex:			UInt16;
		sizesOffset:			UInt16;									{  offset to array of TrackingValues  }
	end;

	TrakTableDataPtr = ^TrakTableData;
	TrakTableData = record
		nTracks:				UInt16;
		nSizes:					UInt16;
		sizeTableOffset:		UInt32;
		trakTable:				array [0..0] of TrakTableEntry;
	end;

	TrakTablePtr = ^TrakTable;
	TrakTable = record
		version:				Fixed;
		format:					UInt16;
		horizOffset:			UInt16;
		vertOffset:				UInt16;
	end;

	{	 --------------------------------------------------------------------------- 	}
	{	 FORMATS FOR TABLE: 'kern' 	}
	{	 CONSTANTS 	}

const
	kKERNTag					= $6B65726E;					{  'kern'  }
	kKERNCurrentVersion			= $00010000;
	kKERNVertical				= $8000;						{  set if this table has vertical kerning information  }
	kKERNResetCrossStream		= $8000;						{  this value in a cross-stream table means reset to zero  }
	kKERNCrossStream			= $4000;						{  set if this table contains cross-stream kerning values  }
	kKERNVariation				= $2000;						{  set if this table contains variation kerning values  }
	kKERNUnusedBits				= $1F00;						{  UNUSED, MUST BE ZERO  }
	kKERNFormatMask				= $00FF;						{  format of this subtable  }

	kKERNOrderedList			= 0;							{  ordered list of kerning pairs  }
	kKERNStateTable				= 1;							{  state table for n-way contextual kerning  }
	kKERNSimpleArray			= 2;							{  simple n X m array of kerning values  }
	kKERNIndexArray				= 3;							{  modifed version of SimpleArray  }

	{	 Message Type Flags 	}
	kKERNLineStart				= $00000001;					{  Array of glyphs starts a line  }
	kKERNLineEndKerning			= $00000002;					{  Array of glyphs ends a line  }
	kKERNNoCrossKerning			= $00000004;					{  Prohibit cross kerning  }
	kKERNNotesRequested			= $00000008;					{  Caller wants kerning notes  }
	kKERNNoStakeNote			= 1;							{  Indicates a glyph was involved in a kerning pair/group  }
	kKERNCrossStreamResetNote	= 2;							{  Indicates a return-to-baseline in cross-stream kerning  }
	kKERNNotApplied				= $00000001;					{  All kerning values were zero, kerning call had no effect  }

	{	 TYPES 	}

type
	KernTableFormat						= UInt8;
	KernSubtableInfo					= UInt16;
	KernKerningValue					= SInt16;
	KernArrayOffset						= UInt16;
	{	 header for version 0 kerning table 	}
	KernVersion0HeaderPtr = ^KernVersion0Header;
	KernVersion0Header = record
		version:				UInt16;									{  font version number (will be 0!)  }
		nTables:				UInt16;									{  number of subtables present  }
		firstSubtable:			array [0..0] of UInt16;					{  first subtable starts here  }
	end;

	{	 Header for a kerning table 	}
	KernTableHeaderPtr = ^KernTableHeader;
	KernTableHeader = record
		version:				Fixed;									{  font version number (currently 1.0)  }
		nTables:				SInt32;									{  number of subtables present  }
		firstSubtable:			array [0..0] of UInt16;					{  first subtable starts here  }
	end;

	KernTableHeaderHandle				= ^KernTableHeaderPtr;
	{	
	    F O R M A T   S P E C I F I C   D E F I N I T I O N S
	
	    kernOrderedList:
	    
	    The table is a sorted list of [left glyph, right glyph, value] triples.
	    There's enough information in the header so that the list can be
	    efficiently binary searched. 
		}
	{	 defines a single kerning pair of Glyphcodes  	}
	KernKerningPairPtr = ^KernKerningPair;
	KernKerningPair = record
		left:					UInt16;
		right:					UInt16;
	end;

	{	 a single list entry 	}
	KernOrderedListEntryPtr = ^KernOrderedListEntry;
	KernOrderedListEntry = record
		pair:					KernKerningPair;						{  the kerning pair  }
		value:					KernKerningValue;						{  the kerning value for the above pair  }
	end;

	{	 the header information for binary searching the list 	}
	KernOrderedListHeaderPtr = ^KernOrderedListHeader;
	KernOrderedListHeader = record
		nPairs:					UInt16;									{  number of kerning pairs in table  }
		searchRange:			UInt16;									{  (largest power of two <= nPairs) * entry size  }
		entrySelector:			UInt16;									{  log2 (largest power of two <= nPairs)  }
		rangeShift:				UInt16;									{  (nPairs - largest power of two <= nPairs) * entry size  }
		table:					array [0..0] of UInt16;					{  entries are first glyph, second glyph, and value  }
	end;

	{	 KernStateTable: like the the generic state tables 	}
	KernStateHeaderPtr = ^KernStateHeader;
	KernStateHeader = record
		header:					STHeader;								{  state table header  }
		valueTable:				UInt16;									{  offset to kerning value table  }
		firstTable:				SInt8;									{  first table starts here  }
	end;

	KernStateEntryPtr = ^KernStateEntry;
	KernStateEntry = record
		newState:				UInt16;
		flags:					UInt16;									{  flags per above enum  }
	end;

	{	
	    Kern offset table header.
	    The offset table is a trimmed array from firstGlyph to limitGlyph.
	    Glyphs outside of this range should get zero for right-hand glyphs
	    and the offset of the beginning of the kerning array for left-hand glyphs.
		}
	KernOffsetTablePtr = ^KernOffsetTable;
	KernOffsetTable = record
		firstGlyph:				UInt16;									{  first glyph in class range  }
		nGlyphs:				UInt16;									{  number of glyphs in class range  }
		offsetTable:			array [0..0] of KernArrayOffset;		{  offset table starts here  }
	end;

	{	 Header information for accessing offset tables and kerning array 	}
	{	
	    KernSimpleArray:
	    
	    The array is an nXm array of kenring values. Each row in the array
	    represents one left-hand glyph, and each column one right-hand glyph.
	    The zeroth row and column always represent glyphs that are out of bounds
	    and will always contain zero.
	    
	    A pair is looked up by indexing the left-hand glyph through the left
	    offset table, the right-hand glyph through the right offset table,
	    adding both offsets to the starting address of the kerning array,
	    and fetching the kerning value pointed to.
		}
	{	 Kern offset table header. 	}
	{	 The offset table is a trimmed array from firstGlyph to limitGlyph. 	}
	{	 Glyphs outside of this range should get zero for right-hand glyphs 	}
	{	 and the offset of the beginning of the kerning array for left- 	}
	{	 hand glyphs. 	}
	KernSimpleArrayHeaderPtr = ^KernSimpleArrayHeader;
	KernSimpleArrayHeader = record
		rowWidth:				UInt16;									{  width, in bytes, of a row in the table  }
		leftOffsetTable:		UInt16;									{  offset to left-hand offset table  }
		rightOffsetTable:		UInt16;									{  offset to right-hand offset table  }
		theArray:				KernArrayOffset;						{  offset to start of kerning array  }
		firstTable:				array [0..0] of UInt16;					{  first offset table starts here...  }
	end;

	{	 Index Array 	}
	KernIndexArrayHeaderPtr = ^KernIndexArrayHeader;
	KernIndexArrayHeader = record
		glyphCount:				UInt16;
		kernValueCount:			SInt8;
		leftClassCount:			SInt8;
		rightClassCount:		SInt8;
		flags:					SInt8;									{  set to 0 for now  }
		kernValue:				array [0..0] of SInt16;					{  actual kerning values reference by index in kernIndex  }
		leftClass:				SInt8;									{  maps left glyph to offset into kern index  }
		rightClass:				SInt8;									{  maps right glyph to offset into kern index  }
		kernIndex:				SInt8;									{  contains indicies into kernValue  }
	end;

	{	 format specific part of subtable header 	}
	KernFormatSpecificHeaderPtr = ^KernFormatSpecificHeader;
	KernFormatSpecificHeader = record
		case SInt16 of
		0: (
			orderedList:		KernOrderedListHeader;
			);
		1: (
			stateTable:			KernStateHeader;
			);
		2: (
			simpleArray:		KernSimpleArrayHeader;
			);
		3: (
			indexArray:			KernIndexArrayHeader;
			);
	end;

	{	 version 0 subtable header 	}
	KernVersion0SubtableHeaderPtr = ^KernVersion0SubtableHeader;
	KernVersion0SubtableHeader = record
		version:				UInt16;									{  kerning table version number  }
		length:					UInt16;									{  length in bytes (including this header)  }
		stInfo:					KernSubtableInfo;						{  sub-table info  }
		fsHeader:				KernFormatSpecificHeader;				{  format specific sub-header  }
	end;

	{	 Overall Subtable header format 	}
	KernSubtableHeaderPtr = ^KernSubtableHeader;
	KernSubtableHeader = record
		length:					SInt32;									{  length in bytes (including this header)  }
		stInfo:					KernSubtableInfo;						{  subtable info  }
		tupleIndex:				SInt16;									{  tuple index for variation subtables  }
		fsHeader:				KernFormatSpecificHeader;				{  format specific sub-header  }
	end;

	{	 --------------------------------------------------------------------------- 	}
	{	 FORMATS FOR TABLE: 'bsln' 	}
	{	 CONSTANTS 	}

const
	kBSLNTag					= $62736C6E;					{  'bsln'  }
	kBSLNCurrentVersion			= $00010000;					{  current version number for 'bsln' table  }
	kBSLNDistanceFormatNoMap	= 0;
	kBSLNDistanceFormatWithMap	= 1;
	kBSLNControlPointFormatNoMap = 2;
	kBSLNControlPointFormatWithMap = 3;

	{	 Baseline classes and constants 	}
	kBSLNRomanBaseline			= 0;
	kBSLNIdeographicCenterBaseline = 1;
	kBSLNIdeographicLowBaseline	= 2;
	kBSLNHangingBaseline		= 3;
	kBSLNMathBaseline			= 4;
	kBSLNLastBaseline			= 31;
	kBSLNNumBaselineClasses		= 32;
	kBSLNNoBaselineOverride		= 255;

	{	 TYPES 	}

type
	BslnBaselineClass					= UInt32;
	{	 The BslnBaselineRecord array defines the baseline deltas for the line. 	}
	BslnBaselineRecord					= array [0..31] of Fixed;
	{	
	    BslnFormat0Part is the format-specific data for a distance table with no mapping (i.e.
	    all the glyphs belong to the defaultBaseline).
		}
	BslnFormat0PartPtr = ^BslnFormat0Part;
	BslnFormat0Part = record
		deltas:					array [0..31] of SInt16;
	end;

	{	 BslnFormat1Part is the format-specific data for a distance table with a gxMapping. 	}
	BslnFormat1PartPtr = ^BslnFormat1Part;
	BslnFormat1Part = record
		deltas:					array [0..31] of SInt16;
		mappingData:			SFNTLookupTable;
	end;

	{	
	    BslnFormat2Part is the format-specific data for a control-point table with no
	    mapping (i.e. all the glyphs belong to the defaultBaseline). It specifies a single
	    glyph to use and the set of control points in that glyph that designate each of
	    the baselines.
		}
	BslnFormat2PartPtr = ^BslnFormat2Part;
	BslnFormat2Part = record
		stdGlyph:				UInt16;
		ctlPoints:				array [0..31] of SInt16;
	end;

	{	
	    BslnFormat3Part is the format-specific data for a distance table with a mapping. Like
	    format 2, it contains a single glyph and its set of control-point values for each
	    of the baselines.
		}
	BslnFormat3PartPtr = ^BslnFormat3Part;
	BslnFormat3Part = record
		stdGlyph:				UInt16;
		ctlPoints:				array [0..31] of SInt16;
		mappingData:			SFNTLookupTable;
	end;

	{	 The BslnFormatUnion is a union containing the format-specific parts of the baseline table. 	}
	BslnFormatUnionPtr = ^BslnFormatUnion;
	BslnFormatUnion = record
		case SInt16 of
		0: (
			fmt0Part:			BslnFormat0Part;
			);
		1: (
			fmt1Part:			BslnFormat1Part;
			);
		2: (
			fmt2Part:			BslnFormat2Part;
			);
		3: (
			fmt3Part:			BslnFormat3Part;
			);
	end;

	{	 The table format used in BaselineTable 	}
	BslnTableFormat						= UInt16;
	{	 BaselineTable defines the top-level format of the baseline table in the font. 	}
	BslnTablePtr = ^BslnTable;
	BslnTable = record
		version:				Fixed;
		format:					BslnTableFormat;
		defaultBaseline:		UInt16;
		parts:					BslnFormatUnion;
	end;

	{	 --------------------------------------------------------------------------- 	}
{$ALIGN MAC68K}


{unit SFNTTypes}
{
     File:       SFNTTypes.p
 
     Contains:   Font file structures.
 
     Version:    Technology: Mac OS 9 / Carbon
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   1994-2002 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}


type
	sfntDirectoryEntryPtr = ^sfntDirectoryEntry;
	sfntDirectoryEntry = record
		tableTag:				FourCharCode;
		checkSum:				UInt32;
		offset:					UInt32;
		length:					UInt32;
	end;

	{	 The search fields limits numOffsets to 4096. 	}
	sfntDirectoryPtr = ^sfntDirectory;
	sfntDirectory = record
		format:					FourCharCode;
		numOffsets:				UInt16;									{  number of tables  }
		searchRange:			UInt16;									{  (max2 <= numOffsets)*16  }
		entrySelector:			UInt16;									{  log2(max2 <= numOffsets)  }
		rangeShift:				UInt16;									{  numOffsets*16-searchRange }
		table:					array [0..0] of sfntDirectoryEntry;		{  table[numOffsets]  }
	end;


const
	sizeof_sfntDirectory		= 12;

	{	 Cmap - character id to glyph id mapping 	}
	cmapFontTableTag			= $636D6170 (* 'cmap' *);

	kFontUnicodePlatform		= 0;
	kFontMacintoshPlatform		= 1;
	kFontReservedPlatform		= 2;
	kFontMicrosoftPlatform		= 3;
	kFontCustomPlatform			= 4;

	kFontUnicodeDefaultSemantics = 0;
	kFontUnicodeV1_1Semantics	= 1;
	kFontISO10646_1993Semantics	= 2;

	kFontRomanScript			= 0;
	kFontJapaneseScript			= 1;
	kFontTraditionalChineseScript = 2;
	kFontChineseScript			= 2;
	kFontKoreanScript			= 3;
	kFontArabicScript			= 4;
	kFontHebrewScript			= 5;
	kFontGreekScript			= 6;
	kFontCyrillicScript			= 7;
	kFontRussian				= 7;
	kFontRSymbolScript			= 8;
	kFontDevanagariScript		= 9;
	kFontGurmukhiScript			= 10;
	kFontGujaratiScript			= 11;
	kFontOriyaScript			= 12;
	kFontBengaliScript			= 13;
	kFontTamilScript			= 14;
	kFontTeluguScript			= 15;
	kFontKannadaScript			= 16;
	kFontMalayalamScript		= 17;
	kFontSinhaleseScript		= 18;
	kFontBurmeseScript			= 19;
	kFontKhmerScript			= 20;
	kFontThaiScript				= 21;
	kFontLaotianScript			= 22;
	kFontGeorgianScript			= 23;
	kFontArmenianScript			= 24;
	kFontSimpleChineseScript	= 25;
	kFontTibetanScript			= 26;
	kFontMongolianScript		= 27;
	kFontGeezScript				= 28;
	kFontEthiopicScript			= 28;
	kFontAmharicScript			= 28;
	kFontSlavicScript			= 29;
	kFontEastEuropeanRomanScript = 29;
	kFontVietnameseScript		= 30;
	kFontExtendedArabicScript	= 31;
	kFontSindhiScript			= 31;
	kFontUninterpretedScript	= 32;

	kFontMicrosoftSymbolScript	= 0;
	kFontMicrosoftStandardScript = 1;
	kFontMicrosoftUCS4Script	= 10;


	kFontCustom8BitScript		= 0;
	kFontCustom816BitScript		= 1;
	kFontCustom16BitScript		= 2;

	{	 Language codes are zero based everywhere but within a 'cmap' table 	}
	kFontEnglishLanguage		= 0;
	kFontFrenchLanguage			= 1;
	kFontGermanLanguage			= 2;
	kFontItalianLanguage		= 3;
	kFontDutchLanguage			= 4;
	kFontSwedishLanguage		= 5;
	kFontSpanishLanguage		= 6;
	kFontDanishLanguage			= 7;
	kFontPortugueseLanguage		= 8;
	kFontNorwegianLanguage		= 9;
	kFontHebrewLanguage			= 10;
	kFontJapaneseLanguage		= 11;
	kFontArabicLanguage			= 12;
	kFontFinnishLanguage		= 13;
	kFontGreekLanguage			= 14;
	kFontIcelandicLanguage		= 15;
	kFontMalteseLanguage		= 16;
	kFontTurkishLanguage		= 17;
	kFontCroatianLanguage		= 18;
	kFontTradChineseLanguage	= 19;
	kFontUrduLanguage			= 20;
	kFontHindiLanguage			= 21;
	kFontThaiLanguage			= 22;
	kFontKoreanLanguage			= 23;
	kFontLithuanianLanguage		= 24;
	kFontPolishLanguage			= 25;
	kFontHungarianLanguage		= 26;
	kFontEstonianLanguage		= 27;
	kFontLettishLanguage		= 28;
	kFontLatvianLanguage		= 28;
	kFontSaamiskLanguage		= 29;
	kFontLappishLanguage		= 29;
	kFontFaeroeseLanguage		= 30;
	kFontFarsiLanguage			= 31;
	kFontPersianLanguage		= 31;
	kFontRussianLanguage		= 32;
	kFontSimpChineseLanguage	= 33;
	kFontFlemishLanguage		= 34;
	kFontIrishLanguage			= 35;
	kFontAlbanianLanguage		= 36;
	kFontRomanianLanguage		= 37;
	kFontCzechLanguage			= 38;
	kFontSlovakLanguage			= 39;
	kFontSlovenianLanguage		= 40;
	kFontYiddishLanguage		= 41;
	kFontSerbianLanguage		= 42;
	kFontMacedonianLanguage		= 43;
	kFontBulgarianLanguage		= 44;
	kFontUkrainianLanguage		= 45;
	kFontByelorussianLanguage	= 46;
	kFontUzbekLanguage			= 47;
	kFontKazakhLanguage			= 48;
	kFontAzerbaijaniLanguage	= 49;
	kFontAzerbaijanArLanguage	= 50;
	kFontArmenianLanguage		= 51;
	kFontGeorgianLanguage		= 52;
	kFontMoldavianLanguage		= 53;
	kFontKirghizLanguage		= 54;
	kFontTajikiLanguage			= 55;
	kFontTurkmenLanguage		= 56;
	kFontMongolianLanguage		= 57;
	kFontMongolianCyrLanguage	= 58;
	kFontPashtoLanguage			= 59;
	kFontKurdishLanguage		= 60;
	kFontKashmiriLanguage		= 61;
	kFontSindhiLanguage			= 62;
	kFontTibetanLanguage		= 63;
	kFontNepaliLanguage			= 64;
	kFontSanskritLanguage		= 65;
	kFontMarathiLanguage		= 66;
	kFontBengaliLanguage		= 67;
	kFontAssameseLanguage		= 68;
	kFontGujaratiLanguage		= 69;
	kFontPunjabiLanguage		= 70;
	kFontOriyaLanguage			= 71;
	kFontMalayalamLanguage		= 72;
	kFontKannadaLanguage		= 73;
	kFontTamilLanguage			= 74;
	kFontTeluguLanguage			= 75;
	kFontSinhaleseLanguage		= 76;
	kFontBurmeseLanguage		= 77;
	kFontKhmerLanguage			= 78;
	kFontLaoLanguage			= 79;
	kFontVietnameseLanguage		= 80;
	kFontIndonesianLanguage		= 81;
	kFontTagalogLanguage		= 82;
	kFontMalayRomanLanguage		= 83;
	kFontMalayArabicLanguage	= 84;
	kFontAmharicLanguage		= 85;
	kFontTigrinyaLanguage		= 86;
	kFontGallaLanguage			= 87;
	kFontOromoLanguage			= 87;
	kFontSomaliLanguage			= 88;
	kFontSwahiliLanguage		= 89;
	kFontRuandaLanguage			= 90;
	kFontRundiLanguage			= 91;
	kFontChewaLanguage			= 92;
	kFontMalagasyLanguage		= 93;
	kFontEsperantoLanguage		= 94;
	kFontWelshLanguage			= 128;
	kFontBasqueLanguage			= 129;
	kFontCatalanLanguage		= 130;
	kFontLatinLanguage			= 131;
	kFontQuechuaLanguage		= 132;
	kFontGuaraniLanguage		= 133;
	kFontAymaraLanguage			= 134;
	kFontTatarLanguage			= 135;
	kFontUighurLanguage			= 136;
	kFontDzongkhaLanguage		= 137;
	kFontJavaneseRomLanguage	= 138;
	kFontSundaneseRomLanguage	= 139;

	{	 The following are special "don't care" values to be used in interfaces 	}
	kFontNoPlatform				= $FFFFFFFF;
	kFontNoScript				= $FFFFFFFF;
	kFontNoLanguage				= $FFFFFFFF;


type
	sfntCMapSubHeaderPtr = ^sfntCMapSubHeader;
	sfntCMapSubHeader = record
		format:					UInt16;
		length:					UInt16;
		languageID:				UInt16;									{  base-1  }
	end;


const
	sizeof_sfntCMapSubHeader	= 6;


type
	sfntCMapEncodingPtr = ^sfntCMapEncoding;
	sfntCMapEncoding = record
		platformID:				UInt16;									{  base-0  }
		scriptID:				UInt16;									{  base-0  }
		offset:					UInt32;
	end;


const
	sizeof_sfntCMapEncoding		= 8;


type
	sfntCMapHeaderPtr = ^sfntCMapHeader;
	sfntCMapHeader = record
		version:				UInt16;
		numTables:				UInt16;
		encoding:				array [0..0] of sfntCMapEncoding;
	end;


const
	sizeof_sfntCMapHeader		= 4;

	{	 Name table 	}
	nameFontTableTag			= $6E616D65 (* 'name' *);

	kFontCopyrightName			= 0;
	kFontFamilyName				= 1;
	kFontStyleName				= 2;
	kFontUniqueName				= 3;
	kFontFullName				= 4;
	kFontVersionName			= 5;
	kFontPostscriptName			= 6;
	kFontTrademarkName			= 7;
	kFontManufacturerName		= 8;
	kFontDesignerName			= 9;
	kFontDescriptionName		= 10;
	kFontVendorURLName			= 11;
	kFontDesignerURLName		= 12;
	kFontLicenseDescriptionName	= 13;
	kFontLicenseInfoURLName		= 14;
	kFontLastReservedName		= 255;

	{	 The following is a special "don't care" value to be used in interfaces 	}
	kFontNoName					= $FFFFFFFF;


type
	sfntNameRecordPtr = ^sfntNameRecord;
	sfntNameRecord = record
		platformID:				UInt16;									{  base-0  }
		scriptID:				UInt16;									{  base-0  }
		languageID:				UInt16;									{  base-0  }
		nameID:					UInt16;									{  base-0  }
		length:					UInt16;
		offset:					UInt16;
	end;


const
	sizeof_sfntNameRecord		= 12;


type
	sfntNameHeaderPtr = ^sfntNameHeader;
	sfntNameHeader = record
		format:					UInt16;
		count:					UInt16;
		stringOffset:			UInt16;
		rec:					array [0..0] of sfntNameRecord;
	end;


const
	sizeof_sfntNameHeader		= 6;

	{	 Fvar table - font variations 	}
	variationFontTableTag		= $66766172 (* 'fvar' *);

	{	 These define each font variation 	}

type
	sfntVariationAxisPtr = ^sfntVariationAxis;
	sfntVariationAxis = record
		axisTag:				FourCharCode;
		minValue:				Fixed;
		defaultValue:			Fixed;
		maxValue:				Fixed;
		flags:					SInt16;
		nameID:					SInt16;
	end;


const
	sizeof_sfntVariationAxis	= 20;

	{	 These are named locations in style-space for the user 	}

type
	sfntInstancePtr = ^sfntInstance;
	sfntInstance = record
		nameID:					SInt16;
		flags:					SInt16;
		coord:					array [0..0] of Fixed;					{  [axisCount]  }
																		{  room to grow since the header carries a tupleSize field  }
	end;


const
	sizeof_sfntInstance			= 4;


type
	sfntVariationHeaderPtr = ^sfntVariationHeader;
	sfntVariationHeader = record
		version:				Fixed;									{  1.0 Fixed  }
		offsetToData:			UInt16;									{  to first axis = 16 }
		countSizePairs:			UInt16;									{  axis+inst = 2  }
		axisCount:				UInt16;
		axisSize:				UInt16;
		instanceCount:			UInt16;
		instanceSize:			UInt16;
																		{  other <count,size> pairs  }
		axis:					array [0..0] of sfntVariationAxis;		{  [axisCount]  }
		instance:				array [0..0] of sfntInstance;			{  [instanceCount]  other arrays of data  }
	end;


const
	sizeof_sfntVariationHeader	= 16;

	{	 Fdsc table - font descriptor 	}
	descriptorFontTableTag		= $66647363 (* 'fdsc' *);


type
	sfntFontDescriptorPtr = ^sfntFontDescriptor;
	sfntFontDescriptor = record
		name:					FourCharCode;
		value:					Fixed;
	end;

	sfntDescriptorHeaderPtr = ^sfntDescriptorHeader;
	sfntDescriptorHeader = record
		version:				Fixed;									{  1.0 in Fixed  }
		descriptorCount:		SInt32;
		descriptor:				array [0..0] of sfntFontDescriptor;
	end;


const
	sizeof_sfntDescriptorHeader	= 8;

	{	 Feat Table - layout feature table 	}
	featureFontTableTag			= $66656174 (* 'feat' *);


type
	sfntFeatureNamePtr = ^sfntFeatureName;
	sfntFeatureName = record
		featureType:			UInt16;
		settingCount:			UInt16;
		offsetToSettings:		SInt32;
		featureFlags:			UInt16;
		nameID:					UInt16;
	end;

	sfntFontFeatureSettingPtr = ^sfntFontFeatureSetting;
	sfntFontFeatureSetting = record
		setting:				UInt16;
		nameID:					UInt16;
	end;

	sfntFontRunFeaturePtr = ^sfntFontRunFeature;
	sfntFontRunFeature = record
		featureType:			UInt16;
		setting:				UInt16;
	end;

	sfntFeatureHeaderPtr = ^sfntFeatureHeader;
	sfntFeatureHeader = record
		version:				SInt32;									{  1.0  }
		featureNameCount:		UInt16;
		featureSetCount:		UInt16;
		reserved:				SInt32;									{  set to 0  }
		names:					array [0..0] of sfntFeatureName;
		settings:				array [0..0] of sfntFontFeatureSetting;
		runs:					array [0..0] of sfntFontRunFeature;
	end;

	{	 OS/2 Table 	}

const
	os2FontTableTag				= $4F532F32 (* 'OS/2' *);

	{	  Special invalid glyph ID value, useful as a sentinel value, for example 	}
	nonGlyphID					= 65535;

	{	  Data type used to access names from font name table 	}

type
	FontNameCode						= UInt32;
	FontNameCodePtr						= ^FontNameCode; { when a VAR xx: FontNameCode parameter can be nil, it is changed to xx: FontNameCodePtr }
	{	 Data types for encoding components as used in interfaces 	}
	FontPlatformCode					= UInt32;
	FontPlatformCodePtr					= ^FontPlatformCode; { when a VAR xx: FontPlatformCode parameter can be nil, it is changed to xx: FontPlatformCodePtr }
	FontScriptCode						= UInt32;
	FontScriptCodePtr					= ^FontScriptCode; { when a VAR xx: FontScriptCode parameter can be nil, it is changed to xx: FontScriptCodePtr }
	FontLanguageCode					= UInt32;
	FontLanguageCodePtr					= ^FontLanguageCode; { when a VAR xx: FontLanguageCode parameter can be nil, it is changed to xx: FontLanguageCodePtr }
	{	
	**  FontVariation is used to specify a coordinate along a variation axis. The name
	**  identifies the axes to be applied, and value is the setting to be used.
		}
	FontVariationPtr = ^FontVariation;
	FontVariation = record
		name:					FourCharCode;
		value:					Fixed;
	end;

{$ALIGN MAC68K}


{unit fenv}
{
 * Copyright (c) 2002 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * The contents of this file constitute Original Code as defined in and
 * are subject to the Apple Public Source License Version 1.1 (the
 * "License").  You may not use this file except in compliance with the
 * License.  Please obtain a copy of the License at
 * http://www.apple.com/publicsource and read it before using this file.
 * 
 * This Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 }
{   Pascal Translation Updated:  Peter N Lewis, <peter@stairways.com.au>, November 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}

 
{******************************************************************************
*                                                                              *
*     File:  fenv.h	                                                       *
*                                                                              *
*     Contains: typedefs and prototypes for C99 floating point environment.    *
*                                                                              *
******************************************************************************}


{
    A collection of functions designed to provide access to the floating
    point environment for numerical programming. It is modeled after
    the floating-point requirements in C9X.
    
    The file <fenv.h> declares many functions in support of numerical
    programming. Programs that test flags or run under
    non-default modes must do so under the effect of an enabling
    "fenv_access" pragma.
}

{*******************************************************************************
*                                                                               *
*    fenv_t         is a type for representing the entire floating-point        *
*                   environment in a single object.                             *
*                                                                               *
*    fexcept_t      is a type for representing the floating-point               *
*                   exception flag state collectively.                          *
*                                                                               *
*******************************************************************************}
{$ifc TARGET_CPU_PPC}
type
	fenv_t = UInt32;
	fexcept_t = UInt32;
{$elsec}
type
	fenv_t = record
    __control: UInt16;
    __status: UInt16;
	end;
	fexcept_t = UInt16;
{$endc}

{    Definitions of floating-point exception macros                          }
{$ifc TARGET_CPU_PPC}
const
	_FE_INEXACT = $02000000;
	_FE_DIVBYZERO = $04000000;
	_FE_UNDERFLOW = $08000000;
	_FE_OVERFLOW = $10000000;
	_FE_INVALID = $20000000;
	_FE_ALL_EXCEPT = $3E000000; // FE_INEXACT | FE_DIVBYZERO | FE_UNDERFLOW | FE_OVERFLOW | FE_INVALID
{$elsec}
const
  _FE_INEXACT = $0020;
  _FE_DIVBYZERO = $0004;
  _FE_UNDERFLOW = $0010;
  _FE_OVERFLOW = $0008;
  _FE_INVALID = $0001;
  _FE_ALL_EXCEPT = $003D; // FE_INEXACT | FE_DIVBYZERO | FE_UNDERFLOW | FE_OVERFLOW | FE_INVALID
{$endc}
const
	FE_INEXACT = _FE_INEXACT;
	FE_DIVBYZERO = _FE_DIVBYZERO;
	FE_UNDERFLOW = _FE_UNDERFLOW;
	FE_OVERFLOW = _FE_OVERFLOW;
	FE_INVALID = _FE_INVALID;
	FE_ALL_EXCEPT = _FE_ALL_EXCEPT;

{    Definitions of rounding direction macros                                }
{$ifc TARGET_CPU_PPC}
const
	_FE_TONEAREST = $00000000;
	_FE_TOWARDZERO = $00000001;
	_FE_UPWARD = $00000002;
	_FE_DOWNWARD = $00000003;
{$elsec}
const
  _FE_TONEAREST = $0000;
  _FE_TOWARDZERO = $0C00;
  _FE_UPWARD = $0800;
  _FE_DOWNWARD = $0400;
{$endc}
const
	FE_TONEAREST = _FE_TONEAREST;
	FE_TOWARDZERO = _FE_TOWARDZERO;
	FE_UPWARD = _FE_UPWARD;
	FE_DOWNWARD = _FE_DOWNWARD;

{ default environment object        }
var _FE_DFL_ENV: fenv_t; external name '__FE_DFL_ENV'; (* attribute const *)
// #define FE_DFL_ENV &_FE_DFL_ENV          { pointer to default environment    }

{******************************************************************************
*     The following functions provide access to the exception flags.  The      *
*     "int" input argument can be constructed by bitwise ORs of the exception  *
*     macros: for example: FE_OVERFLOW | FE_INEXACT.                           *
******************************************************************************}

{******************************************************************************
*     The function "feclearexcept" clears the supported exceptions represented *
*     by its argument.                                                         *
******************************************************************************}

function feclearexcept( excepts: SInt32 ): SInt32; external name '_feclearexcept';


{******************************************************************************
*    The function "fegetexceptflag" stores a representation of the exception   *
*     flags indicated by its integer argument through the fexcept_t pointer    *
*     argument.                                                                *
******************************************************************************}

function fegetexceptflag( var flagp: fexcept_t; excepts: SInt32 ): SInt32; external name '_fegetexceptflag';


{******************************************************************************
*     The function "feraiseexcept" raises the supported exceptions             *
*     represented by its argument.                                             *
******************************************************************************}

function feraiseexcept( excepts: SInt32 ): SInt32; external name '_feraiseexcept';


{******************************************************************************
*     The function "fesetexceptflag" sets or clears the exception flags indicated  *
*     by the its integer argument according to the representation in the       *
*     object pointed to by the fexcept_t pointer argument.  The value of the   *
*     object must have been set by a previous call to "fegetexceptflag".       *
*     This function does not raise exceptions; it just sets the state of       *
*     the flags.                                                               *
******************************************************************************}

function fesetexceptflag( (*const*) var flagp: fexcept_t; excepts: SInt32 ): SInt32; external name '_fesetexceptflag';


{******************************************************************************
*     The function "fetestexcept" determines which of the specified subset of  *
*     the exception flags are currently set.  The integer argument specifies   *
*     the exception flags to be queried as a bitwise OR of the exception       *
*     macros.  This function returns the bitwise OR of the exception macros    *
*     corresponding to the currently set exceptions included in "excepts".     *
******************************************************************************}

function fetestexcept( excepts: SInt32 ): SInt32; external name '_fetestexcept';


{******************************************************************************
*     The following functions provide control of rounding direction modes.     *
******************************************************************************}

{******************************************************************************
*     The function "fegetround" returns the value of the rounding direction    *
*     macro which represents the current rounding direction.                   *
******************************************************************************}

function fegetround: SInt32; external name '_fegetround';


{******************************************************************************
*     The function "fesetround" establishes the rounding direction represented *
*     by its argument.  It returns zero if and only if the argument matches    *
*     a rounding direction macro.  If not, the rounding direction is not       *
*     changed.                                                                 *
******************************************************************************}

function fesetround( round: SInt32 ): SInt32; external name '_fesetround';


{******************************************************************************
*    The following functions manage the floating-point environment, exception  *
*    flags and dynamic modes, as one entity.                                   *
******************************************************************************}

function fegetenv( var envp: fenv_t ): SInt32; external name '_fegetenv';
function feholdexcept( var envp: fenv_t ): SInt32; external name '_feholdexcept';
function fesetenv( (*const*) var envp: fenv_t ): SInt32; external name '_fesetenv';
function feupdateenv( (*const*) var envp: fenv_t ): SInt32; external name '_feupdateenv';


{unit fp}
{
     File:       fp.p
 
     Contains:   FPCE Floating-Point Definitions and Declarations.
 
     Version:    Technology: MathLib v2
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   1987-2002 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}

{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}



{*******************************************************************************
*                                                                               *
*    A collection of numerical functions designed to facilitate a wide          *
*    range of numerical programming as required by C9X.                         *
*                                                                               *
*    The <fp.h> declares many functions in support of numerical programming.    *
*    It provides a superset of <math.h> and <SANE.h> functions.  Some           *
*    functionality previously found in <SANE.h> and not in the FPCE <fp.h>      *
*    can be found in this <fp.h> under the heading "__NOEXTENSIONS__".          *
*                                                                               *
*    All of these functions are IEEE 754 aware and treat exceptions, NaNs,      *
*    positive and negative zero and infinity consistent with the floating-      *
*    point standard.                                                            *
*                                                                               *
*******************************************************************************}


{$ALIGN MAC68K}

{*******************************************************************************
*                                                                               *
*                            Efficient types                                    *
*                                                                               *
*    float_t         Most efficient type at least as wide as float              *
*    double_t        Most efficient type at least as wide as double             *
*                                                                               *
*      CPU            float_t(bits)                double_t(bits)               *
*    --------        -----------------            -----------------             *
*    PowerPC          float(32)                    double(64)                   *
*    68K              long double(80/96)           long double(80/96)           *
*    x86              double(64)                   double(64)                   *
*                                                                               *
*******************************************************************************}
{$ifc TARGET_CPU_PPC}

type
	float_t								= Float32;
	double_t							= Float64;
{$elsec}
  {$ifc TARGET_CPU_68K}
type
    float_t                             = extended;
    double_t                            = extended;
  {$elsec}
    {$ifc TARGET_CPU_X86}

type
	float_t								= Float64;
	double_t							= Float64;
    {$elsec}
      {$ifc TARGET_CPU_MIPS}

type
	float_t								= Double;
	double_t							= Double;
      {$elsec}
        {$ifc TARGET_CPU_ALPHA}

type
	float_t								= Double;
	double_t							= Double;
        {$elsec}
          {$ifc TARGET_CPU_SPARC}

type
	float_t								= Double;
	double_t							= Double;
          {$elsec}
{ Unsupported CPU }
          {$endc}
        {$endc}
      {$endc}
    {$endc}
  {$endc}
{$endc}

{*******************************************************************************
*                                                                               *
*                              Define some constants.                           *
*                                                                               *
*    HUGE_VAL            IEEE 754 value of infinity.                            *
*    INFINITY            IEEE 754 value of infinity.                            *
*    NAN                 A generic NaN (Not A Number).                          *
*    DECIMAL_DIG         Satisfies the constraint that the conversion from      *
*                        double to decimal and back is the identity function.   *
*                                                                               *
*******************************************************************************}
const
{$ifc TARGET_CPU_PPC}
    DECIMAL_DIG                         = 17; 
{$elsec}
    DECIMAL_DIG                         = 21;
{$endc}
{$ifc TARGET_OS_MAC}
{*******************************************************************************
*                                                                               *
*                            Trigonometric functions                            *
*                                                                               *
*   acos        result is in [0,pi].                                            *
*   asin        result is in [-pi/2,pi/2].                                      *
*   atan        result is in [-pi/2,pi/2].                                      *
*   atan2       Computes the arc tangent of y/x in [-pi,pi] using the sign of   *
*               both arguments to determine the quadrant of the computed value. *
*                                                                               *
*******************************************************************************}
{
 *  cos()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function cos(x: double_t): double_t; external name '_cos';

{
 *  sin()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function sin(x: double_t): double_t; external name '_sin';

{
 *  tan()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function tan(x: double_t): double_t; external name '_tan';

{
 *  acos()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function acos(x: double_t): double_t; external name '_acos';

{
 *  asin()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function asin(x: double_t): double_t; external name '_asin';

{
 *  atan()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function atan(x: double_t): double_t; external name '_atan';

{
 *  atan2()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function atan2(y: double_t; x: double_t): double_t; external name '_atan2';


{*******************************************************************************
*                                                                               *
*                              Hyperbolic functions                             *
*                                                                               *
*******************************************************************************}
{
 *  cosh()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function cosh(x: double_t): double_t; external name '_cosh';

{
 *  sinh()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function sinh(x: double_t): double_t; external name '_sinh';

{
 *  tanh()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function tanh(x: double_t): double_t; external name '_tanh';

{
 *  acosh()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function acosh(x: double_t): double_t; external name '_acosh';

{
 *  asinh()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function asinh(x: double_t): double_t; external name '_asinh';

{
 *  atanh()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function atanh(x: double_t): double_t; external name '_atanh';


{*******************************************************************************
*                                                                               *
*                              Exponential functions                            *
*                                                                               *
*   expm1       expm1(x) = exp(x) - 1.  But, for small enough arguments,        *
*               expm1(x) is expected to be more accurate than exp(x) - 1.       *
*   frexp       Breaks a floating-point number into a normalized fraction       *
*               and an integral power of 2.  It stores the SInt16 in the       *
*               object pointed by *exponent.                                    *
*   ldexp       Multiplies a floating-point number by an SInt16 power of 2.    *
*   log1p       log1p = log(1 + x). But, for small enough arguments,            *
*               log1p is expected to be more accurate than log(1 + x).          *
*   logb        Extracts the exponent of its argument, as a signed integral     *
*               value. A subnormal argument is treated as though it were first  *
*               normalized. Thus:                                               *
*                                  1   <=   x * 2^(-logb(x))   <   2            *
*   modf        Returns fractional part of x as function result and returns     *
*               integral part of x via iptr. Note C9X uses double not double_t. *
*   scalb       Computes x * 2^n efficently.  This is not normally done by      *
*               computing 2^n explicitly.                                       *
*                                                                               *
*******************************************************************************}
{
 *  exp()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function exp(x: double_t): double_t; external name '_exp';

{
 *  expm1()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function expm1(x: double_t): double_t; external name '_expm1';

{
 *  exp2()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function exp2(x: double_t): double_t; external name '_exp2';

{
 *  frexp()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function frexp(x: double_t; var exponent: SInt32): double_t; external name '_frexp';

{
 *  ldexp()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function ldexp(x: double_t; n: SInt32): double_t; external name '_ldexp';

{
 *  log()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function log(x: double_t): double_t; external name '_log';

{
 *  log2()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function log2(x: double_t): double_t; external name '_log2';

{
 *  log1p()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function log1p(x: double_t): double_t; external name '_log1p';

{
 *  log10()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function log10(x: double_t): double_t; external name '_log10';

{
 *  logb()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function logb(x: double_t): double_t; external name '_logb';

{
 *  modf()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function modf(x: double_t; var iptr: double_t): double_t; external name '_modf';

{
 *  modff()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function modff(x: Single; var iptrf: Single): Single; external name '_modff';


{
    Note: For compatiblity scalb(x,n) has n of type
            int  on Mac OS X 
            long on Mac OS
}

type
	_scalb_n_type						= SInt32;
	{
	 *  scalb()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in MathLib 1.0 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 and later
	 	}
function scalb(x: double_t; n: _scalb_n_type): double_t; external name '_scalb';


{*******************************************************************************
*                                                                               *
*                     Power and absolute value functions                        *
*                                                                               *
*   hypot       Computes the square root of the sum of the squares of its       *
*               arguments, without undue overflow or underflow.                 *
*   pow         Returns x raised to the power of y.  Result is more accurate    *
*               than using exp(log(x)*y).                                       *
*                                                                               *
*******************************************************************************}
{
 *  fabs()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function fabs(x: double_t): double_t; external name '_fabs';

{
 *  hypot()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function hypot(x: double_t; y: double_t): double_t; external name '_hypot';

{
 *  pow()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function pow(x: double_t; y: double_t): double_t; external name '_pow';

{
 *  sqrt()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function sqrt(x: double_t): double_t; external name '_sqrt';


{*******************************************************************************
*                                                                               *
*                        Gamma and Error functions                              *
*                                                                               *
*   erf         The error function.                                             *
*   erfc        Complementary error function.                                   *
*   gamma       The gamma function.                                             *
*   lgamma      Computes the base-e logarithm of the absolute value of          *
*               gamma of its argument x, for x > 0.                             *
*                                                                               *
*******************************************************************************}
{
 *  erf()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function erf(x: double_t): double_t; external name '_erf';

{
 *  erfc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function erfc(x: double_t): double_t; external name '_erfc';

{
 *  gamma()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function gamma(x: double_t): double_t; external name '_gamma';

{
 *  lgamma()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function lgamma(x: double_t): double_t; external name '_lgamma';


{*******************************************************************************
*                                                                               *
*                        Nearest SInt16 functions                              *
*                                                                               *
*   rint        Rounds its argument to an integral value in floating point      *
*               format, honoring the current rounding direction.                *
*                                                                               *
*   nearbyint   Differs from rint only in that it does not raise the inexact    *
*               exception. It is the nearbyint function recommended by the      *
*               IEEE floating-point standard 854.                               *
*                                                                               *
*   rinttol     Rounds its argument to the nearest long int using the current   *
*               rounding direction.  NOTE: if the rounded value is outside      *
*               the range of long int, then the result is undefined.            *
*                                                                               *
*   round       Rounds the argument to the nearest integral value in floating   *
*               point format similar to the Fortran "anint" function. That is:  *
*               add half to the magnitude and chop.                             *
*                                                                               *
*   roundtol    Similar to the Fortran function nint or to the Pascal round.    *
*               NOTE: if the rounded value is outside the range of long int,    *
*               then the result is undefined.                                   *
*                                                                               *
*   trunc       Computes the integral value, in floating format, nearest to     *
*               but no larger in magnitude than its argument.   NOTE: on 68K    *
*               compilers when using -elems881, trunc must return an int        *
*                                                                               *
*******************************************************************************}
{
 *  ceil()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function ceil(x: double_t): double_t; external name '_ceil';

{
 *  floor()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function floor(x: double_t): double_t; external name '_floor';

{
 *  rint()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function rint(x: double_t): double_t; external name '_rint';

{
 *  nearbyint()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function nearbyint(x: double_t): double_t; external name '_nearbyint';

{
 *  rinttol()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function rinttol(x: double_t): SInt32; external name '_rinttol';

{
 *  round()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function roundd(x: double_t): double_t; external name '_round';

{
 *  roundtol()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function roundtol(round: double_t): SInt32; external name '_roundtol';

{
    Note: For compatiblity trunc(x) has a return type of
            int       for classic 68K with FPU enabled
            double_t  everywhere else
}
{$ifc TARGET_RT_MAC_68881}

type
	_trunc_return_type					= SInt32;
{$elsec}

type
	_trunc_return_type					= double_t;
{$endc}  {TARGET_RT_MAC_68881}
	{
	 *  trunc()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in MathLib 1.0 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 and later
	 	}
function truncd(x: double_t): _trunc_return_type; external name '_trunc';


{*******************************************************************************
*                                                                               *
*                            Remainder functions                                *
*                                                                               *
*   remainder       IEEE 754 floating point standard for remainder.             *
*   remquo          SANE remainder.  It stores into 'quotient' the 7 low-order  *
*                   bits of the SInt16 quotient x/y, such that:                *
*                       -127 <= quotient <= 127.                                *
*                                                                               *
*******************************************************************************}
{
 *  fmod()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function fmod(x: double_t; y: double_t): double_t; external name '_fmod';

{
 *  remainder()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function remainder(x: double_t; y: double_t): double_t; external name '_remainder';

{
 *  remquo()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function remquo(x: double_t; y: double_t; var quo: SInt32): double_t; external name '_remquo';


{*******************************************************************************
*                                                                               *
*                             Auxiliary functions                               *
*                                                                               *
*   copysign        Produces a value with the magnitude of its first argument   *
*                   and sign of its second argument.  NOTE: the order of the    *
*                   arguments matches the recommendation of the IEEE 754        *
*                   floating point standard,  which is opposite from the SANE   *
*                   copysign function.                                          *
*                                                                               *
*   nan             The call 'nan("n-char-sequence")' returns a quiet NaN       *
*                   with content indicated through tagp in the selected         *
*                   data type format.                                           *
*                                                                               *
*   nextafter       Computes the next representable value after 'x' in the      *
*                   direction of 'y'.  if x == y, then y is returned.           *
*                                                                               *
*******************************************************************************}
{
 *  copysign()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function copysign(x: double_t; y: double_t): double_t; external name '_copysign';

{
 *  nan()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function nan(tagp: ConstCStringPtr): Double; external name '_nan';

{
 *  nanf()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function nanf(tagp: ConstCStringPtr): Single; external name '_nanf';

{
 *  nextafterd()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function nextafterd(x: Double; y: Double): Double; external name '_nextafterd';

{
 *  nextafterf()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function nextafterf(x: Single; y: Single): Single; external name '_nextafterf';


{
 *  __fpclassifyd()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function __fpclassifyd(x: Double): SInt32; external name '___fpclassifyd';

{
 *  __fpclassifyf()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function __fpclassifyf(x: Single): SInt32; external name '___fpclassifyf';

{
 *  __isnormald()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function __isnormald(x: Double): SInt32; external name '___isnormald';

{
 *  __isnormalf()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function __isnormalf(x: Single): SInt32; external name '___isnormalf';

{
 *  __isfinited()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function __isfinited(x: Double): SInt32; external name '___isfinited';

{
 *  __isfinitef()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function __isfinitef(x: Single): SInt32; external name '___isfinitef';

{
 *  __isnand()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function __isnand(x: Double): SInt32; external name '___isnand';

{
 *  __isnanf()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function __isnanf(x: Single): SInt32; external name '___isnanf';

{
 *  __signbitd()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function __signbitd(x: Double): SInt32; external name '___signbitd';

{
 *  __signbitf()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function __signbitf(x: Single): SInt32; external name '___signbitf';

{
 *  __inf()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function __inf: double_t; external name '___inf';


{*******************************************************************************
*                                                                               *
*                              Inquiry macros                                   *
*                                                                               *
*   fpclassify      Returns one of the FP_ values.                             *
*   isnormal        Non-zero if and only if the argument x is normalized.       *
*   isfinite        Non-zero if and only if the argument x is finite.           *
*   isnan           Non-zero if and only if the argument x is a NaN.            *
*   signbit         Non-zero if and only if the sign of the argument x is       *
*                   negative.  This includes, NaNs, infinities and zeros.       *
*                                                                               *
*******************************************************************************}

const
	FP_SNAN						= 0;							{       signaling NaN                          }
	FP_QNAN						= 1;							{       quiet NaN                              }
	FP_INFINITE					= 2;							{       + or - infinity                        }
	FP_ZERO						= 3;							{       + or - zero                            }
	FP_NORMAL					= 4;							{       all normal numbers                     }
	FP_SUBNORMAL				= 5;							{       denormal numbers                       }


	{	*******************************************************************************
	*                                                                               *
	*                      Max, Min and Positive Difference                         *
	*                                                                               *
	*   fdim        Determines the 'positive difference' between its arguments:     *
	*               ( x - y, if x > y ), ( +0, if x <= y ).  If one argument is     *
	*               NaN, then fdim returns that NaN.  if both arguments are NaNs,   *
	*               then fdim returns the first argument.                           *
	*                                                                               *
	*   fmax        Returns the maximum of the two arguments.  Corresponds to the   *
	*               max function in FORTRAN.  NaN arguments are treated as missing  *
	*               data.  If one argument is NaN and the other is a number, then   *
	*               the number is returned.  If both are NaNs then the first        *
	*               argument is returned.                                           *
	*                                                                               *
	*   fmin        Returns the minimum of the two arguments.  Corresponds to the   *
	*               min function in FORTRAN.  NaN arguments are treated as missing  *
	*               data.  If one argument is NaN and the other is a number, then   *
	*               the number is returned.  If both are NaNs then the first        *
	*               argument is returned.                                           *
	*                                                                               *
	*******************************************************************************	}
	{
	 *  fdim()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in MathLib 1.0 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 and later
	 	}
function fdim(x: double_t; y: double_t): double_t; external name '_fdim';

{
 *  fmax()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function fmax(x: double_t; y: double_t): double_t; external name '_fmax';

{
 *  fmin()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function fmin(x: double_t; y: double_t): double_t; external name '_fmin';


{******************************************************************************
*                                Constants                                     *
******************************************************************************}

{*******************************************************************************
*                                                                               *
*                              Non NCEG extensions                              *
*                                                                               *
*******************************************************************************}
{$ifc undefined __NOEXTENSIONS__}
{*******************************************************************************
*                                                                               *
*                              Financial functions                              *
*                                                                               *
*   compound        Computes the compound interest factor "(1 + rate)^periods"  *
*                   more accurately than the straightforward computation with   *
*                   the Power function.  This is SANE's compound function.      *
*                                                                               *
*   annuity         Computes the present value factor for an annuity            *
*                   "(1 - (1 + rate)^(-periods)) /rate" more accurately than    *
*                   the straightforward computation with the Power function.    *
*                   This is SANE's annuity function.                            *
*                                                                               *
*******************************************************************************}
{
 *  compound()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function compound(rate: double_t; periods: double_t): double_t; external name '_compound';

{
 *  annuity()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function annuity(rate: double_t; periods: double_t): double_t; external name '_annuity';


{*******************************************************************************
*                                                                               *
*                              Random function                                  *
*                                                                               *
*   randomx         A pseudorandom number generator.  It uses the iteration:    *
*                               (7^5*x)mod(2^31-1)                              *
*                                                                               *
*******************************************************************************}
{
 *  randomx()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function randomx(var x: double_t): double_t; external name '_randomx';


{******************************************************************************
*                              Relational operator                             *
******************************************************************************}
{      relational operator      }

type
	relop								= SInt16;

const
	GREATERTHAN					= 0;
	LESSTHAN					= 1;
	EQUALTO						= 2;
	UNORDERED					= 3;

	{
	 *  relation()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in MathLib 1.0 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 and later
	 	}
function relation(x: double_t; y: double_t): relop; external name '_relation';


{*******************************************************************************
*                                                                               *
*                         Binary to decimal conversions                         *
*                                                                               *
*   SIGDIGLEN   Significant decimal digits.                                     *
*                                                                               *
*   decimal     A record which provides an intermediate unpacked form for       *
*               programmers who wish to do their own parsing of numeric input   *
*               or formatting of numeric output.                                *
*                                                                               *
*   decform     Controls each conversion to a decimal string.  The style field  *
*               is either FLOATDECIMAL or FIXEDDECIMAL. If FLOATDECIMAL, the    *
*               value of the field digits is the number of significant digits.  *
*               If FIXEDDECIMAL value of the field digits is the number of      *
*               digits to the right of the decimal point.                       *
*                                                                               *
*   num2dec     Converts a double_t to a decimal record using a decform.        *
*   dec2num     Converts a decimal record d to a double_t value.                *
*   dec2str     Converts a decform and decimal to a string using a decform.     *
*   str2dec     Converts a string to a decimal struct.                          *
*   dec2d       Similar to dec2num except a double is returned (68k only).      *
*   dec2f       Similar to dec2num except a float is returned.                  *
*   dec2s       Similar to dec2num except a short is returned.                  *
*   dec2l       Similar to dec2num except a long is returned.                   *
*                                                                               *
*******************************************************************************}
const
    SIGDIGLEN                   = 36;
    DECSTROUTLEN                = 80;
type
    DecimalKindItem = (FLOATDECIMAL, FIXEDDECIMAL);
    DecimalKind = DecimalKindItem;

    decimal = record
        sgn:    0..1;           { sign 0 for +, 1 for -  }
        exp:    SInt16;
        sig:    Str36;
    end;

    decform = record
        style:  DecimalKind;
        digits: SInt16;
    end;

{
 *  num2dec()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure num2dec(const (*var*) f: decform; x: double_t; var d: decimal); external name '_num2dec';

{
 *  dec2num()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function dec2num(const (*var*) d: decimal): double_t; external name '_dec2num';

{
 *  dec2str()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure dec2str(const (*var*) f: decform; const (*var*) d: decimal; s: CStringPtr); external name '_dec2str';

{
 *  str2dec()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure str2dec(s: ConstCStringPtr; var ix: SInt16; var d: decimal; var vp: SInt16); external name '_str2dec';

{$ifc TARGET_CPU_68K}
{$ifc CALL_NOT_IN_CARBON}
{
 *  dec2d()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function dec2d(const (*var*) d: decimal): Double; external name '_dec2d';

{$endc}  {CALL_NOT_IN_CARBON}
{$endc}  {TARGET_CPU_68K}
{
 *  dec2f()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function dec2f(const (*var*) d: decimal): Single; external name '_dec2f';

{
 *  dec2s()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function dec2s(const (*var*) d: decimal): SInt16; external name '_dec2s';

{
 *  dec2l()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function dec2l(const (*var*) d: decimal): SInt32; external name '_dec2l';


{*******************************************************************************
*                                                                               *
*                         68k-only Transfer Function Prototypes                 *
*                                                                               *
*******************************************************************************}
{$ifc TARGET_CPU_68K}
{$ifc CALL_NOT_IN_CARBON}
{
 *  x96tox80()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
procedure x96tox80(const (*var*) x: extended96; var x80: extended80); external name '_x96tox80';

{
 *  x80tox96()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
procedure x80tox96(const (*var*) x80: extended80; var x: extended96); external name '_x80tox96';

{$endc}  {CALL_NOT_IN_CARBON}
{$endc}  {TARGET_CPU_68K}
{$endc}
{*******************************************************************************
*                                                                               *
*                         PowerPC-only Function Prototypes                      *
*                                                                               *
*******************************************************************************}

{$ifc TARGET_CPU_PPC}

{
 *  cosl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function cosl(x: LongDouble): LongDouble; external name '_cosl';


{
 *  sinl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function sinl(x: LongDouble): LongDouble; external name '_sinl';


{
 *  tanl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function tanl(x: LongDouble): LongDouble; external name '_tanl';


{
 *  acosl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function acosl(x: LongDouble): LongDouble; external name '_acosl';


{
 *  asinl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function asinl(x: LongDouble): LongDouble; external name '_asinl';


{
 *  atanl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function atanl(x: LongDouble): LongDouble; external name '_atanl';


{
 *  atan2l()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function atan2l(y: LongDouble; x: LongDouble): LongDouble; external name '_atan2l';


{
 *  coshl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function coshl(x: LongDouble): LongDouble; external name '_coshl';


{
 *  sinhl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function sinhl(x: LongDouble): LongDouble; external name '_sinhl';


{
 *  tanhl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function tanhl(x: LongDouble): LongDouble; external name '_tanhl';


{
 *  acoshl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function acoshl(x: LongDouble): LongDouble; external name '_acoshl';


{
 *  asinhl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function asinhl(x: LongDouble): LongDouble; external name '_asinhl';


{
 *  atanhl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function atanhl(x: LongDouble): LongDouble; external name '_atanhl';


{
 *  expl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function expl(x: LongDouble): LongDouble; external name '_expl';


{
 *  expm1l()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function expm1l(x: LongDouble): LongDouble; external name '_expm1l';


{
 *  exp2l()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function exp2l(x: LongDouble): LongDouble; external name '_exp2l';


{
 *  frexpl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function frexpl(x: LongDouble; var exponent: SInt32): LongDouble; external name '_frexpl';


{
 *  ldexpl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function ldexpl(x: LongDouble; n: SInt32): LongDouble; external name '_ldexpl';


{
 *  logl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function logl(x: LongDouble): LongDouble; external name '_logl';


{
 *  log1pl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function log1pl(x: LongDouble): LongDouble; external name '_log1pl';


{
 *  log10l()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function log10l(x: LongDouble): LongDouble; external name '_log10l';


{
 *  log2l()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function log2l(x: LongDouble): LongDouble; external name '_log2l';


{
 *  logbl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function logbl(x: LongDouble): LongDouble; external name '_logbl';


{
 *  scalbl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function scalbl(x: LongDouble; n: SInt32): LongDouble; external name '_scalbl';


{
 *  fabsl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function fabsl(x: LongDouble): LongDouble; external name '_fabsl';


{
 *  hypotl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function hypotl(x: LongDouble; y: LongDouble): LongDouble; external name '_hypotl';


{
 *  powl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function powl(x: LongDouble; y: LongDouble): LongDouble; external name '_powl';


{
 *  sqrtl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function sqrtl(x: LongDouble): LongDouble; external name '_sqrtl';


{
 *  erfl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function erfl(x: LongDouble): LongDouble; external name '_erfl';


{
 *  erfcl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function erfcl(x: LongDouble): LongDouble; external name '_erfcl';


{
 *  gammal()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function gammal(x: LongDouble): LongDouble; external name '_gammal';


{
 *  lgammal()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function lgammal(x: LongDouble): LongDouble; external name '_lgammal';


{
 *  ceill()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 2.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function ceill(x: LongDouble): LongDouble; external name '_ceill';


{
 *  floorl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function floorl(x: LongDouble): LongDouble; external name '_floorl';


{
 *  rintl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function rintl(x: LongDouble): LongDouble; external name '_rintl';


{
 *  nearbyintl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function nearbyintl(x: LongDouble): LongDouble; external name '_nearbyintl';


{
 *  rinttoll()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function rinttoll(x: LongDouble): SInt32; external name '_rinttoll';


{
 *  roundl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function roundl(x: LongDouble): LongDouble; external name '_roundl';


{
 *  roundtoll()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function roundtoll(x: LongDouble): SInt32; external name '_roundtoll';


{
 *  truncl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function truncl(x: LongDouble): LongDouble; external name '_truncl';


{
 *  remainderl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function remainderl(x: LongDouble; y: LongDouble): LongDouble; external name '_remainderl';


{
 *  remquol()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function remquol(x: LongDouble; y: LongDouble; var quo: SInt32): LongDouble; external name '_remquol';


{
 *  copysignl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function copysignl(x: LongDouble; y: LongDouble): LongDouble; external name '_copysignl';


{
 *  fdiml()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function fdiml(x: LongDouble; y: LongDouble): LongDouble; external name '_fdiml';


{
 *  fmaxl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function fmaxl(x: LongDouble; y: LongDouble): LongDouble; external name '_fmaxl';


{
 *  fminl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function fminl(x: LongDouble; y: LongDouble): LongDouble; external name '_fminl';

{$ifc undefined __NOEXTENSIONS__}
{
 *  relationl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function relationl(x: LongDouble; y: LongDouble): relop; external name '_relationl';


{
 *  num2decl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
procedure num2decl(const (*var*) f: decform; x: LongDouble; var d: decimal); external name '_num2decl';


{
 *  dec2numl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
function dec2numl(const (*var*) d: decimal): LongDouble; external name '_dec2numl';

{$endc}
{$endc}  {TARGET_CPU_PPC}
{$endc}  {TARGET_OS_MAC}

{$ifc undefined __NOEXTENSIONS__}
{    
        MathLib v2 has two new transfer functions: x80tod and dtox80.  They can 
        be used to directly transform 68k 80-bit extended data types to double
        and back for PowerPC based machines without using the functions
        x80told or ldtox80.  Double rounding may occur. 
    }
{
 *  x80tod()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function x80tod(const (*var*) x80: extended80): Double; external name '_x80tod';

{
 *  dtox80()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 2.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure dtox80((*const*) var x: Double; var x80: extended80); external name '_dtox80';

{$ifc TARGET_CPU_PPC}
{
 *  x80told()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
procedure x80told(const (*var*) x80: extended80; var x: LongDouble); external name '_x80told';


{
 *  ldtox80()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in MathLib 1.0 and later or as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         not available
 }
procedure ldtox80((*const*) var x: LongDouble; var x80: extended80); external name '_ldtox80';

{$endc} {TARGET_CPU_PPC}
{$endc}

{$ALIGN MAC68K}


{unit vBLAS}
{
     File:       vBLAS.p
 
     Contains:   Header for the Basic Linear Algebra Subprograms, with Apple extensions.
 
     Version:    Technology: All
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   2000-2002 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}
{  ========================================================================================================================== }


{
   =================================================================================================
   Definitions of the Basic Linear Algebra Subprograms (BLAS) as provided by Apple Computer.  At
   present this is a subset of the "legacy" FORTRAN and C interfaces.  Only single precision forms
   are provided, and only the most useful routines.  For example only the general matrix forms are
   provided, not the symmetric, Hermitian, or triangular forms.  A few additional functions, unique
   to Mac OS, have also been provided.  These are clearly documented as Apple extensions.
   Documentation on the BLAS standard, including reference implementations, can be found on the web
   starting from the BLAS FAQ page at these URLs (at least as of August 2000):
        http://www.netlib.org/blas/faq.html
        http://www.netlib.org/blas/blast-forum/blast-forum.html
   =================================================================================================
}


{
   =================================================================================================
   Matrix shape and storage
   ========================
   Keeping the various matrix shape and storage parameters straight can be difficult.  The BLAS
   documentation generally makes a distinction between the concpetual "matrix" and the physical
   "array".  However there are a number of places where this becomes fuzzy because of the overall
   bias towards FORTRAN's column major storage.  The confusion is made worse by style differences
   between the level 2 and level 3 functions.  It is amplified further by the explicit choice of row
   or column major storage in the C interface.
   The storage order does not affect the actual computation that is performed.  That is, it does not
   affect the results other than where they appear in memory.  It does affect the values passed
   for so-called "leading dimension" parameters, such as lda in sgemv.  These are always the major
   stride in storage, allowing operations on rectangular subsets of larger matrices.  For row major
   storage this is the number of columns in the parent matrix, and for column major storage this is
   the number of rows in the parent matrix.
   For the level 2 functions, which deal with only a single matrix, the matrix shape parameters are
   always M and N.  These are the logical shape of the matrix, M rows by N columns.  The transpose
   parameter, such as transA in sgemv, defines whether the regular matrix or its transpose is used
   in the operation.  This affects the implicit length of the input and output vectors.  For example,
   if the regular matrix A is used in sgemv, the input vector X has length N, the number of columns
   of A, and the output vector Y has length M, the number of rows of A.  The length of the input and
   output vectors is not affected by the storage order of the matrix.
   The level 3 functions deal with 2 input matrices and one output matrix, the matrix shape parameters
   are M, N, and K.  The logical shape of the output matrix is always M by N, while K is the common
   dimension of the input matrices.  Like level 2, the transpose parameters, such as transA and transB
   in sgemm, define whether the regular input or its transpose is used in the operation.  However
   unlike level 2, in level 3 the transpose parameters affect the implicit shape of the input matrix.
   Consider sgemm, which computes "C = (alpha * A * B) + (beta * C)", where A and B might be regular
   or transposed.  The logical shape of C is always M rows by N columns.  The physical shape depends
   on the storage order parameter.  Using column major storage the declaration of C (the array) in C
   (the language) would be something like "float C[N][M]".  The logical shape of A without transposition
   is M by K, and B is K by N.  The one storage order parameter affects all three matrices.
   For those readers still wondering about the style differences between level 2 and level 3, they
   involve whether the input or output shapes are explicit.  For level 2, the input matrix shape is
   always M by N.  The input and output vector lengths are implicit and vary according to the
   transpose parameter.  For level 3, the output matrix shape is always M by N.  The input matrix
   shapes are implicit and vary according to the transpose parameters.
   =================================================================================================
}


{  ========================================================================================================================== }


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}



{$ALIGN POWER}


{
   ==========================================================================================================================
   Types and constants
   ===================
}


type
	CBLAS_ORDER 				= SInt32;
const
	CblasRowMajor				= 101;
	CblasColMajor				= 102;


type
	CBLAS_TRANSPOSE 			= SInt32;
const
	CblasNoTrans				= 111;
	CblasTrans					= 112;
	CblasConjTrans				= 113;


type
	CBLAS_UPLO 					= SInt32;
const
	CblasUpper					= 121;
	CblasLower					= 122;


type
	CBLAS_DIAG 					= SInt32;
const
	CblasNonUnit				= 131;
	CblasUnit					= 132;


type
	CBLAS_SIDE 					= SInt32;
const
	CblasLeft					= 141;
	CblasRight					= 142;


	{
	   ------------------------------------------------------------------------------------------------------------------
	   IsAlignedCount   - True if an SInt16 is positive and a multiple of 4.  Negative strides are considered unaligned.
	   IsAlignedAddr    - True if an address is a multiple of 16.
	}


	{
	   ==========================================================================================================================
	   ==========================================================================================================================
	   Legacy BLAS Functions
	   ==========================================================================================================================
	   ==========================================================================================================================
	}


	{
	   ==========================================================================================================================
	   Level 1 Single Precision Functions
	   ==================================
	}


	{
	 *  cblas_sdot()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in vecLib 1.0.2 and later
	 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
	 *    Mac OS X:         in version 10.0 and later
	 	}
function cblas_sdot(N: SInt32; (*const*) var X: Single; incX: SInt32; (*const*) var Y: Single; incY: SInt32): Single; external name '_cblas_sdot';

{
 *  cblas_snrm2()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0.2 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
function cblas_snrm2(N: SInt32; (*const*) var X: Single; incX: SInt32): Single; external name '_cblas_snrm2';

{
 *  cblas_sasum()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0.2 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
function cblas_sasum(N: SInt32; (*const*) var X: Single; incX: SInt32): Single; external name '_cblas_sasum';

{
 *  cblas_isamax()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0.2 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
function cblas_isamax(N: SInt32; (*const*) var X: Single; incX: SInt32): SInt32; external name '_cblas_isamax';

{
 *  cblas_sswap()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0.2 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure cblas_sswap(N: SInt32; var X: Single; incX: SInt32; var Y: Single; incY: SInt32); external name '_cblas_sswap';

{
 *  cblas_scopy()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0.2 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure cblas_scopy(N: SInt32; (*const*) var X: Single; incX: SInt32; var Y: Single; incY: SInt32); external name '_cblas_scopy';

{
 *  cblas_saxpy()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0.2 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure cblas_saxpy(N: SInt32; alpha: Single; (*const*) var X: Single; incX: SInt32; var Y: Single; incY: SInt32); external name '_cblas_saxpy';

{
 *  cblas_srot()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0.2 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure cblas_srot(N: SInt32; var X: Single; incX: SInt32; var Y: Single; incY: SInt32; c: Single; s: Single); external name '_cblas_srot';

{
 *  cblas_sscal()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0.2 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure cblas_sscal(N: SInt32; alpha: Single; var X: Single; incX: SInt32); external name '_cblas_sscal';


{
   ==========================================================================================================================
   Level 1 Double Precision Functions
   ==================================
}


{  *** TBD *** }


{
   ==========================================================================================================================
   Level 1 Complex Single Precision Functions
   ==========================================
}


{  *** TBD *** }


{
   ==========================================================================================================================
   Level 2 Single Precision Functions
   ==================================
}


{
 *  cblas_sgemv()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0.2 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure cblas_sgemv(order: CBLAS_ORDER; transA: CBLAS_TRANSPOSE; M: SInt32; N: SInt32; alpha: Single; (*const*) var A: Single; lda: SInt32; (*const*) var X: Single; incX: SInt32; beta: Single; var Y: Single; incY: SInt32); external name '_cblas_sgemv';


{
   ==========================================================================================================================
   Level 2 Double Precision Functions
   ==================================
}


{  *** TBD *** }


{
   ==========================================================================================================================
   Level 2 Complex Single Precision Functions
   ==========================================
}


{  *** TBD *** }


{
   ==========================================================================================================================
   Level 3 Single Precision Functions
   ==================================
}


{
 *  cblas_sgemm()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0.2 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure cblas_sgemm(order: CBLAS_ORDER; transA: CBLAS_TRANSPOSE; transB: CBLAS_TRANSPOSE; M: SInt32; N: SInt32; K: SInt32; alpha: Single; (*const*) var A: Single; lda: SInt32; (*const*) var B: Single; ldb: SInt32; beta: Single; var C: Single; ldc: SInt32); external name '_cblas_sgemm';


{
   ==========================================================================================================================
   Level 3 Double Precision Functions
   ==================================
}


{  *** TBD *** }


{
   ==========================================================================================================================
   Level 3 Complex Single Precision Functions
   ==========================================
}


{  *** TBD *** }


{
   ==========================================================================================================================
   ==========================================================================================================================
   Latest Standard BLAS Functions
   ==========================================================================================================================
   ==========================================================================================================================
}


{  *** TBD *** }


{
   ==========================================================================================================================
   ==========================================================================================================================
   Additional Functions from Apple
   ==========================================================================================================================
   ==========================================================================================================================
}


{
   -------------------------------------------------------------------------------------------------
   These routines provide optimized, AltiVec-only support for common small matrix multiplications.
   They do not check for the availability of AltiVec instructions or parameter errors.  They just do
   the multiplication as fast as possible.  Matrices are presumed to use row major storage.  Because
   these are all square, column major matrices can be multiplied by simply reversing the parameters.
}


{
   ==========================================================================================================================
   Error handling
   ==============
}


{
   -------------------------------------------------------------------------------------------------
   The BLAS standard requires that parameter errors be reported and cause the program to terminate.
   The default behavior for the Mac OS implementation of the BLAS is to print a message in English
   to stdout using printf and call exit with EXIT_FAILURE as the status.  If this is adequate, then
   you need do nothing more or worry about error handling.
   The BLAS standard also mentions a function, cblas_xerbla, suggesting that a program provide its
   own implementation to override the default error handling.  This will not work in the shared
   library environment of Mac OS 9.  Instead the Mac OS implementation provides a means to install
   an error handler.  There can only be one active error handler, installing a new one causes any
   previous handler to be forgotten.  Passing a null function pointer installs the default handler.
   The default handler is automatically installed at startup and implements the default behavior
   defined above.
   An error handler may return, it need not abort the program.  If the error handler returns, the
   BLAS routine also returns immediately without performing any processing.  Level 1 functions that
   return a numeric value return zero if the error handler returns.
}


type
{$ifc TYPED_FUNCTION_POINTERS}
	BLASParamErrorProc = procedure(funcName: ConstCStringPtr; paramName: ConstCStringPtr; (*const*) var paramPos: SInt32; (*const*) var paramValue: SInt32);
{$elsec}
	BLASParamErrorProc = ProcPtr;
{$endc}

	{
	 *  SetBLASParamErrorProc()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in vecLib 1.0.2 and later
	 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
	 *    Mac OS X:         in version 10.0 and later
	 	}
procedure SetBLASParamErrorProc(ErrorProc: BLASParamErrorProc); external name '_SetBLASParamErrorProc';


{  ========================================================================================================================== }


{$ALIGN MAC68K}


{unit vDSP}
{
     File:       vDSP.p
 
     Contains:   AltiVec DSP Interfaces
 
     Version:    Technology: 1.0
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   2000-2002 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}



{$ALIGN MAC68K}


type
	DSPComplexPtr = ^DSPComplex;
	DSPComplex = record
		real:					Single;
		imag:					Single;
	end;

	DSPSplitComplexPtr = ^DSPSplitComplex;
	DSPSplitComplex = record
		realp:					^Single;
		imagp:					^Single;
	end;

	FFTSetup    = ^SInt32; { an opaque 32-bit type }
	FFTSetupPtr = ^FFTSetup;  { when a var xx:FFTSetup parameter can be nil, it is changed to xx: FFTSetupPtr }
	FFTDirection 				= SInt32;
const
	kFFTDirection_Forward		= 1;
	kFFTDirection_Inverse		= -1;


type
	FFTRadix 					= SInt32;
const
	kFFTRadix2					= 0;
	kFFTRadix3					= 1;
	kFFTRadix5					= 2;

	{	
	
	    The criteria to invoke the PowerPC vector implementation is subject to     
	    change and become less restrictive in the future.                          
	
		}
	{	
	
	    Functions create_fftsetup and destroy_fftsetup.
	
	    create_fftsetup will allocate memory and setup a weight array used by      
	    the FFT. The call destroy_fftsetup will free the array.                    
	
		}
	{
	 *  create_fftsetup()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in vecLib 1.0 and later
	 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
	 *    Mac OS X:         in version 10.0 and later
	 	}
function create_fftsetup(log2n: UInt32; radix: FFTRadix): FFTSetup; external name '_create_fftsetup';

{
 *  destroy_fftsetup()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure destroy_fftsetup(setup: FFTSetup); external name '_destroy_fftsetup';


{

    Functions ctoz and ztoc.
    
    ctoz converts a complex array to a complex-split array
    ztoc converts a complex-split array to a complex array
    
    Criteria to invoke PowerPC vector code:    
        1. size > 3
        2. strideC = 2
        3. strideZ = 1
        4. Z.realp and Z.imagp are relatively aligned.
        5. C is 8-byte aligned if Z.realp and Z.imagp are 4-byte- aligned
           or C is 16-byte aligned if Z.realp and Z.imagp are at least
           8-byte aligned.

}
{
 *  ctoz()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure ctoz(const (*var*) C: DSPComplex; strideC: SInt32; var Z: DSPSplitComplex; strideZ: SInt32; size: UInt32); external name '_ctoz';

{
 *  ztoc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure ztoc(const (*var*) Z: DSPSplitComplex; strideZ: SInt32; var C: DSPComplex; strideC: SInt32; size: UInt32); external name '_ztoc';


{

    Functions fft_zip and fft_zipt 
    
    In-place Split Complex Fourier Transform with or without temporary memory.
            
      Criteria to invoke PowerPC vector code:    
        
        1. ioData.realp and ioData.imagp must be 16-byte aligned.
        2. stride = 1
        3. 2 <= log2n <= 20
        4. bufferTemp.realp and bufferTemp.imagp must be 16-byte aligned.
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.  The size of temporary memory for each part
      is the lower value of 4*n and 16k.  Direction can be either
      kFFTDirection_Forward or kFFTDirection_Inverse.

}
{
 *  fft_zip()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure fft_zip(setup: FFTSetup; var ioData: DSPSplitComplex; stride: SInt32; log2n: UInt32; direction: FFTDirection); external name '_fft_zip';

{
 *  fft_zipt()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure fft_zipt(setup: FFTSetup; var ioData: DSPSplitComplex; stride: SInt32; var bufferTemp: DSPSplitComplex; log2n: UInt32; direction: FFTDirection); external name '_fft_zipt';


{

     Functions fft_zop and fft_zopt
     
     Out-of-place Split Complex Fourier Transform with or without temporary
     memory
            
      Criteria to invoke PowerPC vector code:  
        
        1. signal.realp and signal.imagp must be 16-byte aligned.
        2. signalStride = 1
        3. result.realp and result.imagp must be 16-byte aligned.
        4. strideResult = 1
        5. 2 <= log2n <= 20
        6. bufferTemp.realp and bufferTemp.imagp must be 16-byte aligned.
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.  The size of temporary memory for each part
      is the lower value of 4*n and 16k.  Direction can be either
      kFFTDirection_Forward or kFFTDirection_Inverse.

}
{
 *  fft_zop()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure fft_zop(setup: FFTSetup; var signal: DSPSplitComplex; signalStride: SInt32; var result: DSPSplitComplex; strideResult: SInt32; log2n: UInt32; direction: FFTDirection); external name '_fft_zop';

{
 *  fft_zopt()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure fft_zopt(setup: FFTSetup; var signal: DSPSplitComplex; signalStride: SInt32; var result: DSPSplitComplex; strideResult: SInt32; var bufferTemp: DSPSplitComplex; log2n: UInt32; direction: FFTDirection); external name '_fft_zopt';


{

    Functions fft_zrip and fft_zript
    
    In-Place Real Fourier Transform with or without temporary memory,
    split Complex Format
            
      Criteria to invoke PowerPC vector code:    
        1. ioData.realp and ioData.imagp must be 16-byte aligned.
        2. stride = 1
        3. 3 <= log2n <= 13
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.  The size of temporary memory for each part
      is the lower value of 4*n and 16k.  Direction can be either
      kFFTDirection_Forward or kFFTDirection_Inverse.

}
{
 *  fft_zrip()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure fft_zrip(setup: FFTSetup; var ioData: DSPSplitComplex; stride: SInt32; log2n: UInt32; direction: FFTDirection); external name '_fft_zrip';

{
 *  fft_zript()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure fft_zript(setup: FFTSetup; var ioData: DSPSplitComplex; stride: SInt32; var bufferTemp: DSPSplitComplex; log2n: UInt32; direction: FFTDirection); external name '_fft_zript';


{

    Functions fft_zrop and fft_zropt
    
    Out-of-Place Real Fourier Transform with or without temporary memory,
    split Complex Format
            
      Criteria to invoke PowerPC vector code:  
        1. signal.realp and signal.imagp must be 16-byte aligned.
        2. signalStride = 1
        3. result.realp and result.imagp must be be 16-byte aligned.
        4. strideResult = 1
        5. 3 <= log2n <= 13
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.  The size of temporary memory for each part
      is the lower value of 4*n and 16k.  Direction can be either
      kFFTDirection_Forward or kFFTDirection_Inverse.

}
{
 *  fft_zrop()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure fft_zrop(setup: FFTSetup; var signal: DSPSplitComplex; signalStride: SInt32; var result: DSPSplitComplex; strideResult: SInt32; log2n: UInt32; direction: FFTDirection); external name '_fft_zrop';

{
 *  fft_zropt()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure fft_zropt(setup: FFTSetup; var signal: DSPSplitComplex; signalStride: SInt32; var result: DSPSplitComplex; strideResult: SInt32; var bufferTemp: DSPSplitComplex; log2n: UInt32; direction: FFTDirection); external name '_fft_zropt';


{

    Functions fft2d_zip and fft2d_zipt
    
    In-place two dimensional Split Complex Fourier Transform with or without
    temporary memory
            
      Criteria to invoke PowerPC vector code:  
        1. ioData.realp and ioData.imagp must be 16-byte aligned.
        2. strideInRow = 1;
        3. strideInCol must be a multiple of 4
        4. 2 <= log2nInRow <= 12
        5. 2 <= log2nInCol <= 12
        6. bufferTemp.realp and bufferTemp.imagp must be 16-byte aligned.
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.  The size of temporary memory for each part
      is the lower value of 4*n and 16k.  ( log2n = log2nInRow + log2nInCol ) 
      Direction can be either kFFTDirection_Forward or kFFTDirection_Inverse.

}
{
 *  fft2d_zip()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure fft2d_zip(setup: FFTSetup; var ioData: DSPSplitComplex; strideInRow: SInt32; strideInCol: SInt32; log2nInCol: UInt32; log2nInRow: UInt32; direction: FFTDirection); external name '_fft2d_zip';

{
 *  fft2d_zipt()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure fft2d_zipt(setup: FFTSetup; var ioData: DSPSplitComplex; strideInRow: SInt32; strideInCol: SInt32; var bufferTemp: DSPSplitComplex; log2nInCol: UInt32; log2nInRow: UInt32; direction: FFTDirection); external name '_fft2d_zipt';


{

    Functions fft2d_zop and fft2d_zopt
    
    Out-of-Place two dimemsional Split Complex Fourier Transform with or
    without temporary memory
            
      Criteria to invoke PowerPC vector code:  
        
        1. signal.realp and signal.imagp must be 16-byte aligned.
        2. signalStrideInRow = 1;
        3. signalStrideInCol must be a multiple of 4
        4. result.realp and result.imagp must be 16-byte aligned.
        5. strideResultInRow = 1;
        6. strideResultInCol must be a multiple of 4
        7. 2 <= log2nInRow <= 12
        8. 2 <= log2nInCol <= 12
        9. bufferTemp.realp and bufferTemp.imagp must be 16-byte aligned.

      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.  The size of temporary memory for each part
      is the lower value of 4*n and 16k.  ( log2n = log2nInRow + log2nInCol ) 
      Direction can be either kFFTDirection_Forward or kFFTDirection_Inverse.

}
{
 *  fft2d_zop()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure fft2d_zop(setup: FFTSetup; var signal: DSPSplitComplex; signalStrideInRow: SInt32; signalStrideInCol: SInt32; var result: DSPSplitComplex; strideResultInRow: SInt32; strideResultInCol: SInt32; log2nInCol: UInt32; log2nInRow: UInt32; flag: SInt32); external name '_fft2d_zop';

{
 *  fft2d_zopt()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure fft2d_zopt(setup: FFTSetup; var signal: DSPSplitComplex; signalStrideInRow: SInt32; signalStrideInCol: SInt32; var result: DSPSplitComplex; strideResultInRow: SInt32; strideResultInCol: SInt32; var bufferTemp: DSPSplitComplex; log2nInCol: UInt32; log2nInRow: UInt32; flag: SInt32); external name '_fft2d_zopt';


{

    Functions fft2d_zrip and fft2d_zript
    
    In-place two dimensional Real Fourier Transform with or without temporary
    memory, Split Complex Format
            
      Criteria to invoke PowerPC vector code:  
        1. ioData.realp and ioData.imagp must be 16-byte aligned.
        2. strideInRow = 1;
        3. strideInCol must be a multiple of 4
        4. 3 <= log2nInRow <= 12
        5. 3 <= log2nInCol <= 13
        6. bufferTemp.realp and bufferTemp.imagp must be 16-byte aligned.

      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.  The size of temporary memory for each part
      is the lower value of 4*n and 16k.  ( log2n = log2nInRow + log2nInCol ) 
      Direction can be either kFFTDirection_Forward or kFFTDirection_Inverse.

}
{
 *  fft2d_zrip()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure fft2d_zrip(setup: FFTSetup; var ioData: DSPSplitComplex; strideInRow: SInt32; strideInCol: SInt32; log2nInCol: UInt32; log2nInRow: UInt32; direction: FFTDirection); external name '_fft2d_zrip';

{
 *  fft2d_zript()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure fft2d_zript(setup: FFTSetup; var ioData: DSPSplitComplex; strideInRow: SInt32; strideInCol: SInt32; var bufferTemp: DSPSplitComplex; log2nInCol: UInt32; log2nInRow: UInt32; direction: FFTDirection); external name '_fft2d_zript';


{

    Functions fft2d_zrop and fft2d_zropt
    
    Out-of-Place Two-Dimemsional Real Fourier Transform with or without
    temporary memory, Split Complex Format
            
      Criteria to invoke PowerPC vector code:  
        1. signal.realp and signal.imagp must be 16-byte aligned.
        2. signalStrideInRow = 1;
        3. signalStrideInCol must be a multiple of 4
        4. result.realp and result.imagp must be 16-byte aligned.
        5. strideResultInRow = 1;
        6. strideResultInCol must be a multiple of 4
        7. 3 <= log2nInRow <= 12
        8. 3 <= log2nInCol <= 13
        9. bufferTemp.realp and bufferTemp.imagp must be 16-byte aligned.

      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.  The size of temporary memory for each part
      is the lower value of 4*n and 16k.  ( log2n = log2nInRow + log2nInCol ) 
      Direction can be either kFFTDirection_Forward or kFFTDirection_Inverse.

}
{
 *  fft2d_zrop()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure fft2d_zrop(setup: FFTSetup; var signal: DSPSplitComplex; signalStrideInRow: SInt32; signalStrideInCol: SInt32; var result: DSPSplitComplex; strideResultInRow: SInt32; strideResultInCol: SInt32; log2nInCol: UInt32; log2nInRow: UInt32; flag: SInt32); external name '_fft2d_zrop';

{
 *  fft2d_zropt()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure fft2d_zropt(setup: FFTSetup; var signal: DSPSplitComplex; signalStrideInRow: SInt32; signalStrideInCol: SInt32; var result: DSPSplitComplex; strideResultInRow: SInt32; strideResultInCol: SInt32; var bufferTemp: DSPSplitComplex; log2nInCol: UInt32; log2nInRow: UInt32; flag: SInt32); external name '_fft2d_zropt';


{

    Function conv
    
    Floating Point Convolution and Correlation
      
      Criteria to invoke PowerPC vector code:  
        1. signal and result must have relative alignement.
        2. 4 <= lenFilter <= 256
        3. lenResult > 36
        4. signalStride = 1
        5. strideResult = 1
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.  strideFilter can be positive for
      correlation or negative for convolution.

}
{
 *  conv()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure conv((*const*) var signal: Single; signalStride: SInt32; (*const*) var filter: Single; strideFilter: SInt32; var result: Single; strideResult: SInt32; lenResult: SInt32; lenFilter: SInt32); external name '_conv';


{

    Function vadd
    
    Floating Point Add
    
      Criteria to invoke PowerPC vector code:  
        1. input1 and input2 and result are all relatively aligned.
        2. size >= 8
        3. stride1 = 1
        4. stride2 = 1
        5. strideResult = 1
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.

}
{
 *  vadd()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure vadd((*const*) var input1: Single; stride1: SInt32; (*const*) var input2: Single; stride2: SInt32; var result: Single; strideResult: SInt32; size: UInt32); external name '_vadd';


{

    Function vsub
    
     Floating Point Substract
      
      Criteria to invoke PowerPC vector code:  
        1. input1 and input2 and result are all relatively aligned.
        2. size >= 8
        3. stride1 = 1
        4. stride2 = 1
        5. strideResult = 1
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.

}
{
 *  vsub()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure vsub((*const*) var input1: Single; stride1: SInt32; (*const*) var input2: Single; stride2: SInt32; var result: Single; strideResult: SInt32; size: UInt32); external name '_vsub';


{

    Function vmul
    
    Floating Point Multiply
    
      Criteria to invoke PowerPC vector code:  
        1. input1 and input2 and result must be all relatively aligned.
        2. size >= 8
        3. stride1 = 1
        4. stride2 = 1
        5. strideResult = 1
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.

}
{
 *  vmul()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure vmul((*const*) var input1: Single; stride1: SInt32; (*const*) var input2: Single; stride2: SInt32; var result: Single; strideResult: SInt32; size: UInt32); external name '_vmul';


{

    Function vsmul
    
    Floating Point - Scalar Multiply
    
      Criteria to invoke PowerPC vector code:  
        1. input1 and result are all relatively aligned.
        2. size >= 8
        3. stride1 = 1
        5. strideResult = 1
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.

}
{
 *  vsmul()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure vsmul((*const*) var input1: Single; stride1: SInt32; (*const*) var input2: Single; var result: Single; strideResult: SInt32; size: UInt32); external name '_vsmul';


{

    Function vsq
    
    Floating Point Square
      
      Criteria to invoke PowerPC vector code:  
        1. input and result are relatively aligned.
        2. size >= 8
        3. strideInput = 1
        4. strideResult = 1
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.

}
{
 *  vsq()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure vsq((*const*) var input: Single; strideInput: SInt32; var result: Single; strideResult: SInt32; size: UInt32); external name '_vsq';


{

    Function vssq
    
    Floating Point Signed Square
      
      Criteria to invoke PowerPC vector code:  
        1. input and result must be all relatively aligned.
        2. size >= 8
        3. strideInput = 1
        4. strideResult = 1
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.

}
{
 *  vssq()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure vssq((*const*) var input: Single; strideInput: SInt32; var result: Single; strideResult: SInt32; size: UInt32); external name '_vssq';


{

    Function dotpr
    
    Floating Point Dot product
    
      Criteria to invoke PowerPC vector code:  
        1. input1 and input2 are relatively aligned.
        2. size >= 20
        3. stride1 = 1
        4. stride2 = 1
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.

}
{
 *  dotpr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure dotpr((*const*) var input1: Single; stride1: SInt32; (*const*) var input2: Single; stride2: SInt32; var result: Single; size: UInt32); external name '_dotpr';


{

    Function vam
    
    Floating Point vadd and Multiply
    
      Criteria to invoke PowerPC vector code:  
        1. input1, input2, input_3 and result are all relatively aligned.
        2. size >= 8
        3. stride1 = 1
        4. stride2 = 1
        5. stride_3 = 1
        6. strideResult = 1
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.

}
{
 *  vam()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure vam((*const*) var input1: Single; stride1: SInt32; (*const*) var input2: Single; stride2: SInt32; (*const*) var input3: Single; stride3: SInt32; var result: Single; strideResult: SInt32; size: UInt32); external name '_vam';


{

    Function zconv
    
    Split Complex Convolution and Correlation
      
      Criteria to invoke PowerPC vector code:  
        1. signal->realp, signal->imagp, result->realp, result->imagp
           must be relatively aligned.
        2. 4 <= lenFilter <= 128
        3. lenResult > 20
        4. signalStride = 1
        5. strideResult = 1
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.  strideFilter can be positive for correlation
      or negative for convolution

}
{
 *  zconv()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure zconv(var signal: DSPSplitComplex; signalStride: SInt32; var filter: DSPSplitComplex; strideFilter: SInt32; var result: DSPSplitComplex; strideResult: SInt32; lenResult: SInt32; lenFilter: SInt32); external name '_zconv';


{

    Function zvadd
    
    Split Complex vadd
      
      Criteria to invoke PowerPC vector code:  
        1. input1.realp, input1.imagp, input2.realp, input2.imagp,
           result.realp, result.imagp must be all relatively aligned.
        2. size >= 8
        3. stride1 = 1
        4. stride2 = 1
        5. strideResult = 1
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.

}
{
 *  zvadd()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure zvadd(var input1: DSPSplitComplex; stride1: SInt32; var input2: DSPSplitComplex; stride2: SInt32; var result: DSPSplitComplex; strideResult: SInt32; size: UInt32); external name '_zvadd';


{

    Function zvsub
    
    Split Complex Substract
      
      Criteria to invoke PowerPC vector code:  
        1. input1.realp, input1.imagp, input2.realp, input2.imagp,
           result.realp, result.imagp must be all relatively aligned.
        2. size >= 8
        3. stride1 = 1
        4. stride2 = 1
        5. strideResult = 1
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.

}
{
 *  zvsub()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure zvsub(var input1: DSPSplitComplex; stride1: SInt32; var input2: DSPSplitComplex; stride2: SInt32; var result: DSPSplitComplex; strideResult: SInt32; size: UInt32); external name '_zvsub';


{

    Function zvmul
    
    Split Complex Multiply
      
      Criteria to invoke PowerPC vector code:  
        1. input1.realp, input1.imagp, input2.realp, input2.imagp,
           result.realp, result.imagp must be all relatively aligned.
        2. size >= 8
        3. stride1 = 1
        4. stride2 = 1
        5. strideResult = 1

      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.  The conjugate value can be 1 or -1.

}
{
 *  zvmul()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure zvmul(var input1: DSPSplitComplex; stride1: SInt32; var input2: DSPSplitComplex; stride2: SInt32; var result: DSPSplitComplex; strideResult: SInt32; size: UInt32; conjugate: SInt32); external name '_zvmul';


{

    Function zdotpr
    
    Split Complex Dot product
    
      Criteria to invoke PowerPC vector code:  
        1. input1.realp, input1.imagp, input2.realp, input2.imagp are all
           relatively aligned.
        2. size >= 20
        3. stride1 = 1
        4. stride2 = 1
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.

}
{
 *  zdotpr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure zdotpr(var input1: DSPSplitComplex; stride1: SInt32; var input2: DSPSplitComplex; stride2: SInt32; var result: DSPSplitComplex; size: UInt32); external name '_zdotpr';


{

    Function zidotpr
    
    Split Complex Inner Dot product
    
      Criteria to invoke PowerPC vector code:  
        1. input1.realp, input1.imagp, input2.realp, input2.imagp must be
           all relatively aligned.
        2. size >= 20
        3. stride1 = 1
        4. stride2 = 1
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.

}
{
 *  zidotpr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure zidotpr(var input1: DSPSplitComplex; stride1: SInt32; var input2: DSPSplitComplex; stride2: SInt32; var result: DSPSplitComplex; size: UInt32); external name '_zidotpr';


{

    Function zrdotpr
    
    Split Complex - Real Dot product
      
      Criteria to invoke PowerPC vector code:  
        1. input1.realp, input1.imagp, input2 are must be relatively aligned.
        2. size >= 16
        3. stride1 = 1
        4. stride2 = 1
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.

}
{
 *  zrdotpr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure zrdotpr(var input1: DSPSplitComplex; stride1: SInt32; (*const*) var input2: Single; stride2: SInt32; var result: DSPSplitComplex; size: UInt32); external name '_zrdotpr';


{

    Function zvcma
    
    Split Complex Conjugate Multiply And vadd
    
      Criteria to invoke PowerPC vector code:  
        1. input1.realp, input1.imagp, input2.realp, input2.imagp,
          input_3.realp, input_3.imagp, result.realp, result.imagp
          must be all relatively aligned.
        2. size >= 8
        3. stride1 = 1
        4. stride2 = 1
        5. stride_3 = 1
        6. strideResult = 1
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.

}
{
 *  zvcma()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure zvcma(var input1: DSPSplitComplex; stride1: SInt32; var input2: DSPSplitComplex; stride2: SInt32; var input3: DSPSplitComplex; stride3: SInt32; var result: DSPSplitComplex; strideResult: SInt32; size: UInt32); external name '_zvcma';


{

    Function zrvadd
    
    Split Complex - Real Add
      
      Criteria to invoke PowerPC vector code:  
        1. input1.realp, input1.imagp, input2, result.realp, result.imagp
           are all relatively aligned.
        2. size >= 8
        3. stride1 = 1
        4. stride2 = 1
        5. strideResult = 1
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.

}
{
 *  zrvadd()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure zrvadd(var input1: DSPSplitComplex; stride1: SInt32; (*const*) var input2: Single; stride2: SInt32; var result: DSPSplitComplex; strideResult: SInt32; size: UInt32); external name '_zrvadd';


{

    Function zrvsub
    
    Split Complex - Real Substract
    
      Criteria to invoke PowerPC vector code:  
        1. input1.realp, input1.imagp, input2, result.realp, result.imagp
           must be all relatively aligned.
        2. size >= 8
        3. stride1 = 1
        4. stride2 = 1
        5. strideResult = 1
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.

}
{
 *  zrvsub()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure zrvsub(var input1: DSPSplitComplex; stride1: SInt32; (*const*) var input2: Single; stride2: SInt32; var result: DSPSplitComplex; strideResult: SInt32; size: UInt32); external name '_zrvsub';


{

    Function zrvmul
    
    Split Complex - Real Multiply
    
      Criteria to invoke PowerPC vector code:  
        1. input1.realp, input1.imagp, input2, result.realp, result.imagp
           must be all relatively aligned.
        2. size >= 8
        3. stride1 = 1
        4. stride2 = 1
        5. strideResult = 1
      
      If any of the above criteria are not satisfied, the PowerPC scalor code
      implementation will be used.

}
{
 *  zrvmul()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in vecLib 1.0 and later
 *    CarbonLib:        not in Carbon, but vecLib is compatible with Carbon
 *    Mac OS X:         in version 10.0 and later
 }
procedure zrvmul(var input1: DSPSplitComplex; stride1: SInt32; (*const*) var input2: Single; stride2: SInt32; var result: DSPSplitComplex; strideResult: SInt32; size: UInt32); external name '_zrvmul';


{$ifc undefined USE_NONE_APPLE_STANDARD_DATATYPES}
{$setc USE_NONE_APPLE_STANDARD_DATATYPES := 1}
{$endc}

{$ifc USE_NONE_APPLE_STANDARD_DATATYPES}

const
	FFT_FORWARD					= 1;
	FFT_INVERSE					= -1;

	FFT_RADIX2					= 0;
	FFT_RADIX3					= 1;
	FFT_RADIX5					= 2;


type
	COMPLEX								= DSPComplex;
	COMPLEXPtr 							= ^COMPLEX;
	COMPLEX_SPLIT						= DSPSplitComplex;
	COMPLEX_SPLITPtr 					= ^COMPLEX_SPLIT;
{$endc}  {USE_NONE_APPLE_STANDARD_DATATYPES}

{$ALIGN MAC68K}


{unit ABTypedefs}
{
 *  ABTypedefs.h
 *  AddressBook Framework
 *
 *  Copyright (c) 2002-2003 Apple Computer. All rights reserved.
 *
 }
{	  Pascal Translation:  Peter N Lewis, <peter@stairways.com.au>, 2004 }


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN MAC68K}
const
	kABMultiValueMask  = $100;

type
	ABPropertyType = SInt32;
const
    kABErrorInProperty           = 0;
    kABStringProperty            = 1;
    kABIntegerProperty           = 2;
    kABRealProperty              = 3;
    kABDateProperty              = 4;
    kABArrayProperty             = 5;
    kABDictionaryProperty        = 6;
    kABDataProperty              = 7;
    kABMultiStringProperty       = kABMultiValueMask or kABStringProperty;
    kABMultiIntegerProperty      = kABMultiValueMask or kABIntegerProperty;
    kABMultiRealProperty         = kABMultiValueMask or kABRealProperty;
    kABMultiDateProperty         = kABMultiValueMask or kABDateProperty;
    kABMultiArrayProperty        = kABMultiValueMask or kABArrayProperty;
    kABMultiDictionaryProperty   = kABMultiValueMask or kABDictionaryProperty;
    kABMultiDataProperty         = kABMultiValueMask or kABDataProperty;

// ================================================================
//      Search APIs
// ================================================================

type
	ABSearchComparison = SInt32;
const
        kABEqual = 0;
        kABNotEqual = 1;
        kABLessThan = 2;
        kABLessThanOrEqual = 3;
        kABGreaterThan = 4;
        kABGreaterThanOrEqual = 5;

        kABEqualCaseInsensitive = 6;
        kABContainsSubString = 7;
        kABContainsSubStringCaseInsensitive = 8;
        kABPrefixMatch = 9;
        kABPrefixMatchCaseInsensitive = 10;
// #if MAC_OS_X_VERSION_10_3 <= MAC_OS_X_VERSION_MAX_ALLOWED
        kABBitsInBitFieldMatch = 11;
// #endif

type
	ABSearchConjunction = SInt32;
const
        kABSearchAnd = 0;
        kABSearchOr = 1;

{unit AEDataModel}
{
     File:       AEDataModel.p
 
     Contains:   AppleEvent Data Model Interfaces.
 
     Version:    Technology: Mac OS 9
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   1996-2002 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}

{ Apple event descriptor types }

const
	typeBoolean					= $626F6F6C (* 'bool' *);
	typeChar					= $54455854 (* 'TEXT' *);

	{	 Preferred numeric Apple event descriptor types 	}
	typeSInt16					= $73686F72 (* 'shor' *);
	typeSInt32					= $6C6F6E67 (* 'long' *);
	typeUInt32					= $6D61676E (* 'magn' *);
	typeSInt64					= $636F6D70 (* 'comp' *);
	typeIEEE32BitFloatingPoint	= $73696E67 (* 'sing' *);
	typeIEEE64BitFloatingPoint	= $646F7562 (* 'doub' *);
	type128BitFloatingPoint		= $6C64626C (* 'ldbl' *);
	typeDecimalStruct			= $6465636D (* 'decm' *);

	{	 Non-preferred Apple event descriptor types 	}
	typeSMInt					= $73686F72 (* 'shor' *);
	typeShortInteger			= $73686F72 (* 'shor' *);
	typeInteger					= $6C6F6E67 (* 'long' *);
	typeLongInteger				= $6C6F6E67 (* 'long' *);
	typeMagnitude				= $6D61676E (* 'magn' *);
	typeComp					= $636F6D70 (* 'comp' *);
	typeSMFloat					= $73696E67 (* 'sing' *);
	typeShortFloat				= $73696E67 (* 'sing' *);
	typeFloat					= $646F7562 (* 'doub' *);
	typeLongFloat				= $646F7562 (* 'doub' *);
	typeExtended				= $65787465 (* 'exte' *);

	{	 More Apple event descriptor types 	}
	typeAEList					= $6C697374 (* 'list' *);
	typeAERecord				= $7265636F (* 'reco' *);
	typeAppleEvent				= $61657674 (* 'aevt' *);
	typeEventRecord				= $65767263 (* 'evrc' *);
	typeTrue					= $74727565 (* 'true' *);
	typeFalse					= $66616C73 (* 'fals' *);
	typeAlias					= $616C6973 (* 'alis' *);
	typeEnumerated				= $656E756D (* 'enum' *);
	typeType					= $74797065 (* 'type' *);
	typeAppParameters			= $61707061 (* 'appa' *);
	typeProperty				= $70726F70 (* 'prop' *);
	typeFSS						= $66737320 (* 'fss ' *);
	typeFSRef					= $66737266 (* 'fsrf' *);
	typeFileURL					= $6675726C (* 'furl' *);
	typeKeyword					= $6B657977 (* 'keyw' *);
	typeSectionH				= $73656374 (* 'sect' *);
	typeWildCard				= $2A2A2A2A (* '****' *);
	typeApplSignature			= $7369676E (* 'sign' *);
	typeQDRectangle				= $71647274 (* 'qdrt' *);
	typeFixed					= $66697864 (* 'fixd' *);
	typeProcessSerialNumber		= $70736E20 (* 'psn ' *);
	typeApplicationURL			= $6170726C (* 'aprl' *);
	typeNull					= $6E756C6C (* 'null' *);						{  null or nonexistent data  }

{$ifc CALL_NOT_IN_CARBON}
	{	 Deprecated addressing modes under Carbon 	}
	typeSessionID				= $73736964 (* 'ssid' *);
	typeTargetID				= $74617267 (* 'targ' *);
	typeDispatcherID			= $64737074 (* 'dspt' *);

{$endc}  {CALL_NOT_IN_CARBON}

	{	 Keywords for Apple event attributes 	}
	keyTransactionIDAttr		= $7472616E (* 'tran' *);
	keyReturnIDAttr				= $72746964 (* 'rtid' *);
	keyEventClassAttr			= $6576636C (* 'evcl' *);
	keyEventIDAttr				= $65766964 (* 'evid' *);
	keyAddressAttr				= $61646472 (* 'addr' *);
	keyOptionalKeywordAttr		= $6F70746B (* 'optk' *);
	keyTimeoutAttr				= $74696D6F (* 'timo' *);
	keyInteractLevelAttr		= $696E7465 (* 'inte' *);						{  this attribute is read only - will be set in AESend  }
	keyEventSourceAttr			= $65737263 (* 'esrc' *);						{  this attribute is read only - returned as typeShortInteger  }
	keyMissedKeywordAttr		= $6D697373 (* 'miss' *);						{  this attribute is read only  }
	keyOriginalAddressAttr		= $66726F6D (* 'from' *);						{  new in 1.0.1  }
	keyAcceptTimeoutAttr		= $6163746D (* 'actm' *);						{  new for Mac OS X  }


	{	  Constants used for specifying the factoring of AEDescLists. 	}
	kAEDescListFactorNone		= 0;
	kAEDescListFactorType		= 4;
	kAEDescListFactorTypeAndSize = 8;

	{	 Constants used creating an AppleEvent 	}
																{  Constant for the returnID param of AECreateAppleEvent  }
	kAutoGenerateReturnID		= -1;							{  AECreateAppleEvent will generate a session-unique ID  }
																{  Constant for transaction IDs  }
	kAnyTransactionID			= 0;							{  no transaction is in use  }

	{	 Apple event manager data types 	}

type
	DescType							= ResType;
	DescTypePtr					= ^DescType;
	AEKeyword							= FourCharCode;
	AEKeywordPtr					= ^AEKeyword;
{$ifc OPAQUE_TOOLBOX_STRUCTS}
	AEDataStorage    = ^SInt32; { an opaque 32-bit type }
	AEDataStoragePtr = ^AEDataStorage;  { when a var xx:AEDataStorage parameter can be nil, it is changed to xx: AEDataStoragePtr }
{$elsec}
	AEDataStorage						= Handle;
{$endc}  {OPAQUE_TOOLBOX_STRUCTS}

	AEDescPtr = ^AEDesc;
	AEDesc = record
		descriptorType:			DescType;
		dataHandle:				AEDataStorage;
	end;

	AEKeyDescPtr = ^AEKeyDesc;
	AEKeyDesc = record
		descKey:				AEKeyword;
		descContent:			AEDesc;
	end;

	{	 a list of AEDesc's is a special kind of AEDesc 	}
	AEDescList							= AEDesc;
	AEDescListPtr 						= ^AEDescList;
	{	 AERecord is a list of keyworded AEDesc's 	}
	AERecord							= AEDescList;
	AERecordPtr 						= ^AERecord;
	{	 an AEDesc which contains address data 	}
	AEAddressDesc						= AEDesc;
	AEAddressDescPtr 					= ^AEAddressDesc;
	{	 an AERecord that contains an AppleEvent, and related data types 	}
	AppleEvent							= AERecord;
	AppleEventPtr 						= ^AppleEvent;
	AEReturnID							= SInt16;
	AETransactionID						= SInt32;
	AEEventClass						= FourCharCode;
	AEEventID							= FourCharCode;
	AEArrayType							= SInt8;

const
	kAEDataArray				= 0;
	kAEPackedArray				= 1;
	kAEDescArray				= 3;
	kAEKeyDescArray				= 4;


	kAEHandleArray				= 2;


type
	AEArrayDataPtr = ^AEArrayData;
	AEArrayData = record
		case SInt16 of
		0: (
			kAEDataArray:		array [0..0] of SInt16;
			);
		1: (
			kAEPackedArray:		SInt8;
			);
		2: (
			kAEHandleArray:		array [0..0] of Handle;
			);
		3: (
			kAEDescArray:		array [0..0] of AEDesc;
			);
		4: (
			kAEKeyDescArray:	array [0..0] of AEKeyDesc;
			);
	end;

	AEArrayDataPointer					= ^AEArrayData;
	AEArrayDataPointerPtr 				= ^AEArrayDataPointer;
	{	*************************************************************************
	  These constants are used by AEMach and AEInteraction APIs.  They are not
	  strictly part of the data format, but are declared here due to layering.
	*************************************************************************	}
	AESendPriority 				= SInt16;
const
	kAENormalPriority			= $00000000;					{  post message at the end of the event queue  }
	kAEHighPriority				= $00000001;					{  post message at the front of the event queue (same as nAttnMsg)  }


type
	AESendMode 					= SInt32;
const
	kAENoReply					= $00000001;					{  sender doesn't want a reply to event  }
	kAEQueueReply				= $00000002;					{  sender wants a reply but won't wait  }
	kAEWaitReply				= $00000003;					{  sender wants a reply and will wait  }
	kAEDontReconnect			= $00000080;					{  don't reconnect if there is a sessClosedErr from PPCToolbox  }
	kAEWantReceipt				= $00000200;					{  (nReturnReceipt) sender wants a receipt of message  }
	kAENeverInteract			= $00000010;					{  server should not interact with user  }
	kAECanInteract				= $00000020;					{  server may try to interact with user  }
	kAEAlwaysInteract			= $00000030;					{  server should always interact with user where appropriate  }
	kAECanSwitchLayer			= $00000040;					{  interaction may switch layer  }
	kAEDontRecord				= $00001000;					{  don't record this event - available only in vers 1.0.1 and greater  }
	kAEDontExecute				= $00002000;					{  don't send the event for recording - available only in vers 1.0.1 and greater  }
	kAEProcessNonReplyEvents	= $00008000;					{  allow processing of non-reply events while awaiting synchronous AppleEvent reply  }


	{	 Constants for timeout durations 	}
	kAEDefaultTimeout			= -1;							{  timeout value determined by AEM  }
	kNoTimeOut					= -2;							{  wait until reply comes back, however long it takes  }


	{	*************************************************************************
	  These calls are used to set up and modify the coercion dispatch table.
	*************************************************************************	}

type
{$ifc TYPED_FUNCTION_POINTERS}
	AECoerceDescProcPtr = function(const (*var*) fromDesc: AEDesc; toType: DescType; handlerRefcon: SInt32; var toDesc: AEDesc): OSErr;
{$elsec}
	AECoerceDescProcPtr = ProcPtr;
{$endc}

{$ifc TYPED_FUNCTION_POINTERS}
	AECoercePtrProcPtr = function(typeCode: DescType; dataPtr: UnivPtr; dataSize: Size; toType: DescType; handlerRefcon: SInt32; var result: AEDesc): OSErr;
{$elsec}
	AECoercePtrProcPtr = ProcPtr;
{$endc}

{$ifc OPAQUE_UPP_TYPES}
	AECoerceDescUPP = ^SInt32; { an opaque UPP }
{$elsec}
	AECoerceDescUPP = UniversalProcPtr;
{$endc}	
{$ifc OPAQUE_UPP_TYPES}
	AECoercePtrUPP = ^SInt32; { an opaque UPP }
{$elsec}
	AECoercePtrUPP = UniversalProcPtr;
{$endc}	

const
	uppAECoerceDescProcInfo = $00003FE0;
	uppAECoercePtrProcInfo = $0003FFE0;
	{
	 *  NewAECoerceDescUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 and later
	 	}
function NewAECoerceDescUPP(userRoutine: AECoerceDescProcPtr): AECoerceDescUPP; external name '_NewAECoerceDescUPP'; { old name was NewAECoerceDescProc }
{
 *  NewAECoercePtrUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function NewAECoercePtrUPP(userRoutine: AECoercePtrProcPtr): AECoercePtrUPP; external name '_NewAECoercePtrUPP'; { old name was NewAECoercePtrProc }
{
 *  DisposeAECoerceDescUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure DisposeAECoerceDescUPP(userUPP: AECoerceDescUPP); external name '_DisposeAECoerceDescUPP';
{
 *  DisposeAECoercePtrUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure DisposeAECoercePtrUPP(userUPP: AECoercePtrUPP); external name '_DisposeAECoercePtrUPP';
{
 *  InvokeAECoerceDescUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function InvokeAECoerceDescUPP(const (*var*) fromDesc: AEDesc; toType: DescType; handlerRefcon: SInt32; var toDesc: AEDesc; userRoutine: AECoerceDescUPP): OSErr; external name '_InvokeAECoerceDescUPP'; { old name was CallAECoerceDescProc }
{
 *  InvokeAECoercePtrUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function InvokeAECoercePtrUPP(typeCode: DescType; dataPtr: UnivPtr; dataSize: Size; toType: DescType; handlerRefcon: SInt32; var result: AEDesc; userRoutine: AECoercePtrUPP): OSErr; external name '_InvokeAECoercePtrUPP'; { old name was CallAECoercePtrProc }
{ a AECoercionHandlerUPP is by default a AECoerceDescUPP.  If you are registering a 
    Ptr based coercion handler you will have to add a cast to AECoerceDescUPP from 
    your AECoercePtrUPP type.  A future release of the interfaces will fix this by
    introducing seperate Desc and Ptr coercion handler installation/remove/query routines. }

type
	AECoercionHandlerUPP				= AECoerceDescUPP;
	{
	 *  AEInstallCoercionHandler()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 and later
	 	}
function AEInstallCoercionHandler(fromType: DescType; toType: DescType; handler: AECoercionHandlerUPP; handlerRefcon: SInt32; fromTypeIsDesc: boolean; isSysHandler: boolean): OSErr; external name '_AEInstallCoercionHandler';
{
 *  AERemoveCoercionHandler()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AERemoveCoercionHandler(fromType: DescType; toType: DescType; handler: AECoercionHandlerUPP; isSysHandler: boolean): OSErr; external name '_AERemoveCoercionHandler';
{
 *  AEGetCoercionHandler()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEGetCoercionHandler(fromType: DescType; toType: DescType; var handler: AECoercionHandlerUPP; var handlerRefcon: SInt32; var fromTypeIsDesc: boolean; isSysHandler: boolean): OSErr; external name '_AEGetCoercionHandler';
{*************************************************************************
  The following calls provide for a coercion interface.
*************************************************************************}
{
 *  AECoercePtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AECoercePtr(typeCode: DescType; dataPtr: UnivPtr; dataSize: Size; toType: DescType; var result: AEDesc): OSErr; external name '_AECoercePtr';
{
 *  AECoerceDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AECoerceDesc(const (*var*) theAEDesc: AEDesc; toType: DescType; var result: AEDesc): OSErr; external name '_AECoerceDesc';
{*************************************************************************
 The following calls apply to any AEDesc. Every 'result' descriptor is
 created for you, so you will be responsible for memory management
 (including disposing) of the descriptors so created.  
*************************************************************************}
{ because AEDescs are opaque under Carbon, this AEInitializeDesc provides a
   'clean' way of initializating them to be empty. }
{
 *  AEInitializeDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.4 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure AEInitializeDesc(var desc: AEDesc); external name '_AEInitializeDesc';


{
 *  AECreateDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AECreateDesc(typeCode: DescType; dataPtr: UnivPtr; dataSize: Size; var result: AEDesc): OSErr; external name '_AECreateDesc';
{
 *  AEDisposeDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEDisposeDesc(var theAEDesc: AEDesc): OSErr; external name '_AEDisposeDesc';
{
 *  AEDuplicateDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEDuplicateDesc(const (*var*) theAEDesc: AEDesc; var result: AEDesc): OSErr; external name '_AEDuplicateDesc';
{*************************************************************************
  The following calls apply to AEDescList. Since AEDescList is a subtype of
  AEDesc, the calls in the previous section can also be used for AEDescList.
  All list and array indices are 1-based. If the data was greater than
  maximumSize in the routines below, then actualSize will be greater than
  maximumSize, but only maximumSize bytes will actually be retrieved.
*************************************************************************}
{
 *  AECreateList()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AECreateList(factoringPtr: UnivPtr; factoredSize: Size; isRecord: boolean; var resultList: AEDescList): OSErr; external name '_AECreateList';
{
 *  AECountItems()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AECountItems(const (*var*) theAEDescList: AEDescList; var theCount: SInt32): OSErr; external name '_AECountItems';
{
 *  AEPutPtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEPutPtr(var theAEDescList: AEDescList; index: SInt32; typeCode: DescType; dataPtr: UnivPtr; dataSize: Size): OSErr; external name '_AEPutPtr';
{
 *  AEPutDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEPutDesc(var theAEDescList: AEDescList; index: SInt32; const (*var*) theAEDesc: AEDesc): OSErr; external name '_AEPutDesc';
{
 *  AEGetNthPtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEGetNthPtr(const (*var*) theAEDescList: AEDescList; index: SInt32; desiredType: DescType; theAEKeywordPtr: AEKeywordPtr; typeCode: DescTypePtr; dataPtr: UnivPtr; maximumSize: Size; actualSize: SizePtr): OSErr; external name '_AEGetNthPtr';
{
 *  AEGetNthDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEGetNthDesc(const (*var*) theAEDescList: AEDescList; index: SInt32; desiredType: DescType; theAEKeywordPtr: AEKeywordPtr; var result: AEDesc): OSErr; external name '_AEGetNthDesc';
{
 *  AESizeOfNthItem()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AESizeOfNthItem(const (*var*) theAEDescList: AEDescList; index: SInt32; typeCode: DescTypePtr; dataSize: SizePtr): OSErr; external name '_AESizeOfNthItem';
{
 *  AEGetArray()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEGetArray(const (*var*) theAEDescList: AEDescList; arrayType: AEArrayType; arrayPtr: AEArrayDataPointer; maximumSize: Size; var itemType: DescType; var itemSize: Size; var itemCount: SInt32): OSErr; external name '_AEGetArray';
{
 *  AEPutArray()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEPutArray(var theAEDescList: AEDescList; arrayType: AEArrayType; const (*var*) arrayPtr: AEArrayData; itemType: DescType; itemSize: Size; itemCount: SInt32): OSErr; external name '_AEPutArray';
{
 *  AEDeleteItem()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEDeleteItem(var theAEDescList: AEDescList; index: SInt32): OSErr; external name '_AEDeleteItem';
{*************************************************************************
 The following calls apply to AERecord. Since AERecord is a subtype of
 AEDescList, the calls in the previous sections can also be used for
 AERecord an AERecord can be created by using AECreateList with isRecord
 set to true. 
*************************************************************************}
{************************************************************************
 AERecords can have an abitrary descriptorType.  This allows you to
 check if desc is truly an AERecord
***********************************************************************}
{
 *  AECheckIsRecord()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.4 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AECheckIsRecord(const (*var*) theDesc: AEDesc): boolean; external name '_AECheckIsRecord';

{
  Note: none of the key calls were available in the PowerPC 7.x IntefaceLib.
  In C, a #define is used to map key calls to param calls.  In pascal
  this mapping is done in externally linked glue code.
}
{$ifc CALL_NOT_IN_CARBON}
{
 *  AEPutKeyPtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function AEPutKeyPtr(var theAERecord: AERecord; theAEKeyword: AEKeyword; typeCode: DescType; dataPtr: UnivPtr; dataSize: Size): OSErr; external name '_AEPutKeyPtr';
{
 *  AEPutKeyDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function AEPutKeyDesc(var theAERecord: AERecord; theAEKeyword: AEKeyword; const (*var*) theAEDesc: AEDesc): OSErr; external name '_AEPutKeyDesc';
{
 *  AEGetKeyPtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function AEGetKeyPtr(const (*var*) theAERecord: AERecord; theAEKeyword: AEKeyword; desiredType: DescType; var typeCode: DescType; dataPtr: UnivPtr; maximumSize: Size; var actualSize: Size): OSErr; external name '_AEGetKeyPtr';
{
 *  AEGetKeyDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function AEGetKeyDesc(const (*var*) theAERecord: AERecord; theAEKeyword: AEKeyword; desiredType: DescType; var result: AEDesc): OSErr; external name '_AEGetKeyDesc';
{
 *  AESizeOfKeyDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function AESizeOfKeyDesc(const (*var*) theAERecord: AERecord; theAEKeyword: AEKeyword; var typeCode: DescType; var dataSize: Size): OSErr; external name '_AESizeOfKeyDesc';
{
 *  AEDeleteKeyDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function AEDeleteKeyDesc(var theAERecord: AERecord; theAEKeyword: AEKeyword): OSErr; external name '_AEDeleteKeyDesc';
{$endc}  {CALL_NOT_IN_CARBON}

{*************************************************************************
  The following calls create and manipulate the AppleEvent data type.
*************************************************************************}
{
 *  AECreateAppleEvent()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AECreateAppleEvent(theAEEventClass: AEEventClass; theAEEventID: AEEventID; const (*var*) target: AEAddressDesc; returnID: AEReturnID; transactionID: AETransactionID; var result: AppleEvent): OSErr; external name '_AECreateAppleEvent';
{*************************************************************************
  The following calls are used to pack and unpack parameters from records
  of type AppleEvent. Since AppleEvent is a subtype of AERecord, the calls
  in the previous sections can also be used for variables of type
  AppleEvent. The next six calls are in fact identical to the six calls
  for AERecord.
*************************************************************************}
{
 *  AEPutParamPtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEPutParamPtr(var theAppleEvent: AppleEvent; theAEKeyword: AEKeyword; typeCode: DescType; dataPtr: UnivPtr; dataSize: Size): OSErr; external name '_AEPutParamPtr';
{
 *  AEPutParamDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEPutParamDesc(var theAppleEvent: AppleEvent; theAEKeyword: AEKeyword; const (*var*) theAEDesc: AEDesc): OSErr; external name '_AEPutParamDesc';
{
 *  AEGetParamPtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEGetParamPtr(const (*var*) theAppleEvent: AppleEvent; theAEKeyword: AEKeyword; desiredType: DescType; actualType: DescTypePtr; dataPtr: UnivPtr; maximumSize: Size; actualSize: SizePtr): OSErr; external name '_AEGetParamPtr';
{
 *  AEGetParamDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEGetParamDesc(const (*var*) theAppleEvent: AppleEvent; theAEKeyword: AEKeyword; desiredType: DescType; var result: AEDesc): OSErr; external name '_AEGetParamDesc';
{
 *  AESizeOfParam()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AESizeOfParam(const (*var*) theAppleEvent: AppleEvent; theAEKeyword: AEKeyword; typeCode: DescTypePtr; dataSize: SizePtr): OSErr; external name '_AESizeOfParam';
{
 *  AEDeleteParam()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEDeleteParam(var theAppleEvent: AppleEvent; theAEKeyword: AEKeyword): OSErr; external name '_AEDeleteParam';
{*************************************************************************
 The following calls also apply to type AppleEvent. Message attributes are
 far more restricted, and can only be accessed through the following 5
 calls. The various list and record routines cannot be used to access the
 attributes of an event. 
*************************************************************************}
{
 *  AEGetAttributePtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEGetAttributePtr(const (*var*) theAppleEvent: AppleEvent; theAEKeyword: AEKeyword; desiredType: DescType; typeCode: DescTypePtr; dataPtr: UnivPtr; maximumSize: Size; actualSize: SizePtr): OSErr; external name '_AEGetAttributePtr';
{
 *  AEGetAttributeDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEGetAttributeDesc(const (*var*) theAppleEvent: AppleEvent; theAEKeyword: AEKeyword; desiredType: DescType; var result: AEDesc): OSErr; external name '_AEGetAttributeDesc';
{
 *  AESizeOfAttribute()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AESizeOfAttribute(const (*var*) theAppleEvent: AppleEvent; theAEKeyword: AEKeyword; typeCode: DescTypePtr; dataSize: SizePtr): OSErr; external name '_AESizeOfAttribute';
{
 *  AEPutAttributePtr()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEPutAttributePtr(var theAppleEvent: AppleEvent; theAEKeyword: AEKeyword; typeCode: DescType; dataPtr: UnivPtr; dataSize: Size): OSErr; external name '_AEPutAttributePtr';
{
 *  AEPutAttributeDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEPutAttributeDesc(var theAppleEvent: AppleEvent; theAEKeyword: AEKeyword; const (*var*) theAEDesc: AEDesc): OSErr; external name '_AEPutAttributeDesc';
{*************************************************************************
 AppleEvent Serialization Support

    AESizeOfFlattenedDesc, AEFlattenDesc, AEUnflattenDesc
    
    These calls will work for all AppleEvent data types and between different
    versions of the OS (including between Mac OS 9 and X)
    
    Basic types, AEDesc, AEList and AERecord are OK, but AppleEvent records
    themselves may not be reliably flattened for storage.
*************************************************************************}
{
   AEFlattenDesc
   Returns the amount of buffer space needed to flatten the
   AEDesc. Call this before AEFlattenDesc to make sure your
   buffer has enough room for the operation.
}

{
 *  AESizeOfFlattenedDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.4 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AESizeOfFlattenedDesc(const (*var*) theAEDesc: AEDesc): Size; external name '_AESizeOfFlattenedDesc';

{
   AEFlattenDesc
   Fills a buffer with a flattened representation of the
   AEDesc and returns the amount of buffer used in actualSize.
   If bufferSize was too small it returns errAEBufferTooSmall
   (-1741) and does not fill in any of the buffer. The resulting
   buffer is only useful with an AEUnflattenDesc call.
   
   Note: if you pass a NULL buffer pointer it returns noErr but
   fills in the actualSize field anyway.
}

{
 *  AEFlattenDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.4 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEFlattenDesc(const (*var*) theAEDesc: AEDesc; buffer: Ptr; bufferSize: Size; var actualSize: Size): OSStatus; external name '_AEFlattenDesc';

{
   AEUnflattenDesc
   Allocates an AEDesc (given a Null Desc) given a flattened
   data buffer. It assumes it was given a good buffer filled
   in by AEFlattenDesc. It returns paramErr if it discovers
   something fishy about the buffer.
}

{
 *  AEUnflattenDesc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.4 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEUnflattenDesc(buffer: Ptr; var result: AEDesc): OSStatus; external name '_AEUnflattenDesc';

{*************************************************************************
 The following calls are necessary to deal with opaque data in AEDescs, because the
 traditional way of dealing with a basic AEDesc has been to dereference the dataHandle
 directly.  This is not supported under Carbon.
*************************************************************************}
{$ifc ACCESSOR_CALLS_ARE_FUNCTIONS}
{
        AEGetDescData no longer supports automatic coercion. If you'd like to
        coerce the descriptor use AECoerceDesc.
    }
{
 *  AEGetDescData()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CarbonAccessors.o 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEGetDescData(const (*var*) theAEDesc: AEDesc; dataPtr: UnivPtr; maximumSize: Size): OSErr; external name '_AEGetDescData';

{
 *  AEGetDescDataSize()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CarbonAccessors.o 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEGetDescDataSize(const (*var*) theAEDesc: AEDesc): Size; external name '_AEGetDescDataSize';

{
 *  AEReplaceDescData()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CarbonAccessors.o 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AEReplaceDescData(typeCode: DescType; dataPtr: UnivPtr; dataSize: Size; var theAEDesc: AEDesc): OSErr; external name '_AEReplaceDescData';

{$endc}  {ACCESSOR_CALLS_ARE_FUNCTIONS}


{*************************************************************************
  A AEEventHandler is installed to process an AppleEvent 
*************************************************************************}

type
{$ifc TYPED_FUNCTION_POINTERS}
	AEEventHandlerProcPtr = function(const (*var*) theAppleEvent: AppleEvent; var reply: AppleEvent; handlerRefcon: SInt32): OSErr;
{$elsec}
	AEEventHandlerProcPtr = ProcPtr;
{$endc}

{$ifc OPAQUE_UPP_TYPES}
	AEEventHandlerUPP = ^SInt32; { an opaque UPP }
{$elsec}
	AEEventHandlerUPP = UniversalProcPtr;
{$endc}	

const
	uppAEEventHandlerProcInfo = $00000FE0;
	{
	 *  NewAEEventHandlerUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 and later
	 	}
function NewAEEventHandlerUPP(userRoutine: AEEventHandlerProcPtr): AEEventHandlerUPP; external name '_NewAEEventHandlerUPP'; { old name was NewAEEventHandlerProc }
{
 *  DisposeAEEventHandlerUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure DisposeAEEventHandlerUPP(userUPP: AEEventHandlerUPP); external name '_DisposeAEEventHandlerUPP';
{
 *  InvokeAEEventHandlerUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function InvokeAEEventHandlerUPP(const (*var*) theAppleEvent: AppleEvent; var reply: AppleEvent; handlerRefcon: SInt32; userRoutine: AEEventHandlerUPP): OSErr; external name '_InvokeAEEventHandlerUPP'; { old name was CallAEEventHandlerProc }
{$ALIGN MAC68K}


{unit AEMach}
{
     File:       AEMach.p
 
     Contains:   AppleEvent over mach_msg interfaces
 
     Version:    Technology: For Mac OS X
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   2000-2002 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}

{-
 * AE Mach API --
 *
 * AppleEvents on OS X are implemented in terms of mach messages.
 * To facilitate writing server processes that can send and receive
 * AppleEvents, the following APIs are provided.
 *
 * AppleEvents are directed to a well known port uniquely tied to a
 * process.  The AE framework will discover this port based on the
 * keyAddressAttr of the event (as specifed in AECreateAppleEvent by
 * the target parameter.)  If a port cannot be found,
 * procNotFound (-600) will be returned on AESend.
 *
 * Of note is a new attribute for an AppleEvent, typeReplyPortAttr.
 * This specifies the mach_port_t to which an AppleEvent reply
 * should be directed.  By default, replies are sent to the
 * processes registered port where they are culled from the normal  
 * event stream if there is an outstanding AESend + kAEWaitReply.
 * But it may be desirable for a client to specify their own port to
 * receive quued replies.
 * (In the case of AESendMessage with kAEWaitReply specified, an 
 * anonymous port will be used to block until the reply is received.)
 *
 * Not supplied is a convenience routine to block a server and
 * process AppleEvents.  This implementation will be detailed in a
 * tech note.
 *}

const
	typeReplyPortAttr			= $72657070 (* 'repp' *);

{$ifc TARGET_RT_MAC_MACHO}
{$ifc not undefined _MACH_MESSAGE_H_}
	{	-
	 * Return the mach_port_t that was registered with the bootstrap
	 * server for this process.  This port is considered public, and
	 * will be used by other applications to target your process.  You
	 * are free to use this mach_port_t to add to a port set, if and
	 * only if, you are not also using routines from HIToolbox.  In that
	 * case, HIToolbox retains control of this port and AppleEvents are
	 * dispatched through the main event loop.  
	 *	}
	{
	 *  AEGetRegisteredMachPort()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        not available
	 *    Mac OS X:         in version 10.0 and later
	 	}
function AEGetRegisteredMachPort: mach_port_t; external name '_AEGetRegisteredMachPort';

{-
 * Decode a mach_msg into an AppleEvent and its related reply.  (The
 * reply is set up from fields of the event.)  You can call this
 * routine if you wish to dispatch or handle the event yourself.  To
 * return a reply to the sender, you should call:
 *
 *  AESendMessage(reply, NULL, kAENoReply, kAENormalPriority, kAEDefaultTimeout);
 *
 * The contents of the header are invalid after this call.  
 *}
{
 *  AEDecodeMessage()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         in version 10.0 and later
 }
function AEDecodeMessage(var header: mach_msg_header_t; var event: AppleEvent; reply: AppleEventPtr): OSStatus; external name '_AEDecodeMessage';

{-
 * Decodes and dispatches an event to an event handler.  Handles
 * packaging and returning the reply to the sender.
 *
 * The contents of the header are invalid after this call.
 *}
{
 *  AEProcessMessage()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         in version 10.0 and later
 }
function AEProcessMessage(var header: mach_msg_header_t): OSStatus; external name '_AEProcessMessage';

{-
 * Send an AppleEvent to a target process.  If the target is the
 * current process (as specified by using typeProcessSerialNumber of
 * ( 0, kCurrentProcess ) it is dispatched directly to the
 * appropriate event handler in your process and not serialized.
 *}
{
 *  AESendMessage()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         in version 10.0 and later
 }
function AESendMessage(const (*var*) event: AppleEvent; reply: AppleEventPtr; sendMode: AESendMode; timeOutInTicks: SInt32): OSStatus; external name '_AESendMessage';

{$endc}  {_MACH_MESSAGE_H_}
{$endc}  {TARGET_RT_MAC_MACHO}

{$ALIGN MAC68K}


{unit AEUserTermTypes}
{
     File:       AEUserTermTypes.p
 
     Contains:   AppleEvents AEUT resource format Interfaces.
 
     Version:    Technology: System 7.5
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   1991-2002 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}


const
	kAEUserTerminology			= $61657574 (* 'aeut' *);						{   0x61657574   }
	kAETerminologyExtension		= $61657465 (* 'aete' *);						{   0x61657465   }
	kAEScriptingSizeResource	= $7363737A (* 'scsz' *);						{   0x7363737a   }
	kAEOSAXSizeResource			= $6F73697A (* 'osiz' *);

	kAEUTHasReturningParam		= 31;							{  if event has a keyASReturning param  }
	kAEUTOptional				= 15;							{  if something is optional  }
	kAEUTlistOfItems			= 14;							{  if property or reply is a list.  }
	kAEUTEnumerated				= 13;							{  if property or reply is of an enumerated type.  }
	kAEUTReadWrite				= 12;							{  if property is writable.  }
	kAEUTChangesState			= 12;							{  if an event changes state.  }
	kAEUTTightBindingFunction	= 12;							{  if this is a tight-binding precedence function.  }
																{  AppleScript 1.3: new bits for reply, direct parameter, parameter, and property flags  }
	kAEUTEnumsAreTypes			= 11;							{  if the enumeration is a list of types, not constants  }
	kAEUTEnumListIsExclusive	= 10;							{  if the list of enumerations is a proper set  }
	kAEUTReplyIsReference		= 9;							{  if the reply is a reference, not a value  }
	kAEUTDirectParamIsReference	= 9;							{  if the direct parameter is a reference, not a value  }
	kAEUTParamIsReference		= 9;							{  if the parameter is a reference, not a value  }
	kAEUTPropertyIsReference	= 9;							{  if the property is a reference, not a value  }
	kAEUTNotDirectParamIsTarget	= 8;							{  if the direct parameter is not the target of the event  }
	kAEUTParamIsTarget			= 8;							{  if the parameter is the target of the event  }
	kAEUTApostrophe				= 3;							{  if a term contains an apostrophe.  }
	kAEUTFeminine				= 2;							{  if a term is feminine gender.  }
	kAEUTMasculine				= 1;							{  if a term is masculine gender.  }
	kAEUTPlural					= 0;							{  if a term is plural.  }


type
	TScriptingSizeResourcePtr = ^TScriptingSizeResource;
	TScriptingSizeResource = record
		scriptingSizeFlags:		SInt16;
		minStackSize:			UInt32;
		preferredStackSize:		UInt32;
		maxStackSize:			UInt32;
		minHeapSize:			UInt32;
		preferredHeapSize:		UInt32;
		maxHeapSize:			UInt32;
	end;


const
	kLaunchToGetTerminology		= $8000;						{     If kLaunchToGetTerminology is 0, 'aete' is read directly from res file.  If set to 1, then launch and use 'gdut' to get terminology.  }
	kDontFindAppBySignature		= $4000;						{     If kDontFindAppBySignature is 0, then find app with signature if lost.  If 1, then don't  }
	kAlwaysSendSubject			= $2000;						{     If kAlwaysSendSubject 0, then send subject when appropriate. If 1, then every event has Subject Attribute  }

	{	 old names for above bits. 	}
	kReadExtensionTermsMask		= $8000;

																{  AppleScript 1.3: Bit positions for osiz resource  }
																{  AppleScript 1.3: Bit masks for osiz resources  }
	kOSIZDontOpenResourceFile	= 15;							{  If set, resource file is not opened when osax is loaded  }
	kOSIZdontAcceptRemoteEvents	= 14;							{  If set, handler will not be called with events from remote machines  }
	kOSIZOpenWithReadPermission	= 13;							{  If set, file will be opened with read permission only  }
	kOSIZCodeInSharedLibraries	= 11;							{  If set, loader will look for handler in shared library, not osax resources  }

{$ALIGN MAC68K}


{unit AIFF}
{
     File:       AIFF.p
 
     Contains:   Definition of AIFF file format components.
 
     Version:    Technology: System 8.5
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   1989-2002 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}


const
	AIFFID						= $41494646 (* 'AIFF' *);
	AIFCID						= $41494643 (* 'AIFC' *);
	FormatVersionID				= $46564552 (* 'FVER' *);
	CommonID					= $434F4D4D (* 'COMM' *);
	FORMID						= $464F524D (* 'FORM' *);
	SoundDataID					= $53534E44 (* 'SSND' *);
	MarkerID					= $4D41524B (* 'MARK' *);
	InstrumentID				= $494E5354 (* 'INST' *);
	MIDIDataID					= $4D494449 (* 'MIDI' *);
	AudioRecordingID			= $41455344 (* 'AESD' *);
	ApplicationSpecificID		= $4150504C (* 'APPL' *);
	CommentID					= $434F4D54 (* 'COMT' *);
	NameID						= $4E414D45 (* 'NAME' *);
	AuthorID					= $41555448 (* 'AUTH' *);
	CopyrightID					= $28632920 (* '(c) ' *);
	AnnotationID				= $414E4E4F (* 'ANNO' *);

	NoLooping					= 0;
	ForwardLooping				= 1;
	ForwardBackwardLooping		= 2;

																{  AIFF-C Versions  }
	AIFCVersion1				= $A2805140;

	{	 Compression Names 	}
	NoneName					= 'not compressed';
	ACE2to1Name					= 'ACE 2-to-1';
	ACE8to3Name					= 'ACE 8-to-3';
	MACE3to1Name				= 'MACE 3-to-1';
	MACE6to1Name				= 'MACE 6-to-1';
																{  Compression Types  }
	NoneType					= $4E4F4E45 (* 'NONE' *);
	ACE2Type					= $41434532 (* 'ACE2' *);
	ACE8Type					= $41434538 (* 'ACE8' *);
	MACE3Type					= $4D414333 (* 'MAC3' *);
	MACE6Type					= $4D414336 (* 'MAC6' *);


type
	ID									= UInt32;
	MarkerIdType						= SInt16;
	ChunkHeaderPtr = ^ChunkHeader;
	ChunkHeader = record
		ckID:					ID;
		ckSize:					SInt32;
	end;

	ContainerChunkPtr = ^ContainerChunk;
	ContainerChunk = record
		ckID:					ID;
		ckSize:					SInt32;
		formType:				ID;
	end;

	FormatVersionChunkPtr = ^FormatVersionChunk;
	FormatVersionChunk = record
		ckID:					ID;
		ckSize:					SInt32;
		timestamp:				UInt32;
	end;

	CommonChunkPtr = ^CommonChunk;
	CommonChunk = record
		ckID:					ID;
		ckSize:					SInt32;
		numChannels:			SInt16;
		numSampleFrames:		UInt32;
		sampleSize:				SInt16;
		sampleRate:				extended80;
	end;

	ExtCommonChunkPtr = ^ExtCommonChunk;
	ExtCommonChunk = record
		ckID:					ID;
		ckSize:					SInt32;
		numChannels:			SInt16;
		numSampleFrames:		UInt32;
		sampleSize:				SInt16;
		sampleRate:				extended80;
		compressionType:		ID;
		compressionName:		SInt8;									{  variable length array, Pascal string  }
	end;

	SoundDataChunkPtr = ^SoundDataChunk;
	SoundDataChunk = record
		ckID:					ID;
		ckSize:					SInt32;
		offset:					UInt32;
		blockSize:				UInt32;
	end;

	MarkerPtr = ^Marker;
	Marker = record
		id:						MarkerIdType;
		position:				UInt32;
		markerName:				Str255;
	end;

	MarkerChunkPtr = ^MarkerChunk;
	MarkerChunk = record
		ckID:					ID;
		ckSize:					SInt32;
		numMarkers:				UInt16;
		Markers:				array [0..0] of Marker;					{  variable length array  }
	end;

	AIFFLoopPtr = ^AIFFLoop;
	AIFFLoop = record
		playMode:				SInt16;
		beginLoop:				MarkerIdType;
		endLoop:				MarkerIdType;
	end;

	InstrumentChunkPtr = ^InstrumentChunk;
	InstrumentChunk = packed record
		ckID:					ID;
		ckSize:					SInt32;
		baseFrequency:			UInt8;
		detune:					UInt8;
		lowFrequency:			UInt8;
		highFrequency:			UInt8;
		lowVelocity:			UInt8;
		highVelocity:			UInt8;
		gain:					SInt16;
		sustainLoop:			AIFFLoop;
		releaseLoop:			AIFFLoop;
	end;

	MIDIDataChunkPtr = ^MIDIDataChunk;
	MIDIDataChunk = record
		ckID:					ID;
		ckSize:					SInt32;
		MIDIdata:				SInt8;									{  variable length array  }
	end;

	AudioRecordingChunkPtr = ^AudioRecordingChunk;
	AudioRecordingChunk = record
		ckID:					ID;
		ckSize:					SInt32;
		AESChannelStatus:		packed array [0..23] of UInt8;
	end;

	ApplicationSpecificChunkPtr = ^ApplicationSpecificChunk;
	ApplicationSpecificChunk = record
		ckID:					ID;
		ckSize:					SInt32;
		applicationSignature:	OSType;
		data:					SInt8;									{  variable length array  }
	end;

	CommentPtr = ^Comment;
	Comment = record
		timeStamp:				UInt32;
		marker:					MarkerIdType;
		count:					UInt16;
		text:					SInt8;									{  variable length array, Pascal string  }
	end;

	CommentsChunkPtr = ^CommentsChunk;
	CommentsChunk = record
		ckID:					ID;
		ckSize:					SInt32;
		numComments:			UInt16;
		comments:				array [0..0] of Comment;				{  variable length array  }
	end;

	TextChunkPtr = ^TextChunk;
	TextChunk = record
		ckID:					ID;
		ckSize:					SInt32;
		text:					SInt8;									{  variable length array, Pascal string  }
	end;

{$ALIGN MAC68K}


{unit AVLTree}
{
     File:       AVLTree.p
 
     Contains:   Prototypes for routines which create, destroy, allow for
 
     Version:    Universal Interfaces 3.4.2
 
     Copyright:   1999-2002 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}


type
	AVLFlags 					= UInt32;
const
	kAVLFlagUseHandleForDataStorageMask = $00000001;

	{	 The visit stage for AVLWalk() walkProcs 	}

type
	AVLVisitStage 				= UInt16;
const
	kAVLPreOrder				= 0;
	kAVLInOrder					= 1;
	kAVLPostOrder				= 2;

	{	 The order the tree is walked or disposed of. 	}

type
	AVLOrder 					= UInt16;
const
	kAVLLeftToRight				= 0;
	kAVLRightToLeft				= 1;

	{	 The type of the node being passed to a callback proc. 	}

type
	AVLNodeType 				= UInt16;
const
	kAVLIsTree					= 0;
	kAVLIsLeftBranch			= 1;
	kAVLIsRightBranch			= 2;
	kAVLIsLeaf					= 3;
	kAVLNullNode				= 4;

	errItemAlreadyInTree		= -960;
	errNotValidTree				= -961;
	errItemNotFoundInTree		= -962;
	errCanNotInsertWhileWalkProcInProgress = -963;
	errTreeIsLocked				= -964;
	errTreeIsCorrupt			= -965;

	{   The structure of a tree.  It's opaque; don't assume it's 52 bytes in size. }

type
	AVLTreeStructPtr = ^AVLTreeStruct;
	AVLTreeStruct = record
		signature:				OSType;
		privateStuff:			array [0..11] of UInt32;
	end;

	AVLTreePtr							= ^AVLTreeStruct;
	{
	    Every tree must have a function which compares the data for two items and returns < 0, 0, or >0
	    for the items - < 0 if the first item is 'before' the second item according to some criteria,
	    == 0 if the two items are identical according to the criteria, or > 0 if the first item is
	    'after' the second item according to the criteria.  The comparison function is also passed the
	    node type, but most of the time this can be ignored.
	}
{$ifc TYPED_FUNCTION_POINTERS}
	AVLCompareItemsProcPtr = function(tree: AVLTreePtr; i1: UnivPtr; i2: UnivPtr; nd_typ: AVLNodeType): SInt32;
{$elsec}
	AVLCompareItemsProcPtr = ProcPtr;
{$endc}

	{
	    Every tree must have a itemSizeProc; this routine gets passed a pointer to the item's data and
	    returns the size of the data.  If a tree contains records of a fixed size, this function can
	    just return sizeof( that-struct ); otherwise it should calculate the size of the item based on
	    the data for the item.
	}
{$ifc TYPED_FUNCTION_POINTERS}
	AVLItemSizeProcPtr = function(tree: AVLTreePtr; itemPtr: UnivPtr): UInt32;
{$elsec}
	AVLItemSizeProcPtr = ProcPtr;
{$endc}

	{
	    A tree may have an optional disposeItemProc, which gets called whenever an item is removed
	    from the tree ( via AVLRemove() or when AVLDispose() deletes all of the items in the tree ).
	    This might be useful if the nodes in the tree own 'resources'  ( like, open files ) which
	    should be released before the item is removed.
	}
{$ifc TYPED_FUNCTION_POINTERS}
	AVLDisposeItemProcPtr = procedure(tree: AVLTreePtr; dataP: UnivPtr);
{$elsec}
	AVLDisposeItemProcPtr = ProcPtr;
{$endc}

	{
	    The common way to iterate across all of the items in a tree is via AVLWalk(), which takes
	    a walkProcPtr.  This function will get called for every item in the tree three times, as
	    the tree is being walked across.  First, the walkProc will get called with visitStage ==
	    kAVLPreOrder, at which point internally the node of the tree for the given data has just
	    been reached.  Later, this function will get called with visitStage == kAVLInOrder, and
	    lastly this function will get called with visitStage == kAVLPostOrder.
	    The 'minimum' item in the tree will get called with visitStage == kInOrder first, followed
	    by the 'next' item in the tree, up until the last item in the tree structure is called.
	    In general, you'll only care about calls to this function when visitStage == kAVLInOrder.
	}
{$ifc TYPED_FUNCTION_POINTERS}
	AVLWalkProcPtr = function(tree: AVLTreePtr; dataP: UnivPtr; visitStage: AVLVisitStage; node: AVLNodeType; level: UInt32; balance: SInt32; refCon: UnivPtr): OSErr;
{$elsec}
	AVLWalkProcPtr = ProcPtr;
{$endc}

{$ifc OPAQUE_UPP_TYPES}
	AVLCompareItemsUPP = ^SInt32; { an opaque UPP }
{$elsec}
	AVLCompareItemsUPP = UniversalProcPtr;
{$endc}	
{$ifc OPAQUE_UPP_TYPES}
	AVLItemSizeUPP = ^SInt32; { an opaque UPP }
{$elsec}
	AVLItemSizeUPP = UniversalProcPtr;
{$endc}	
{$ifc OPAQUE_UPP_TYPES}
	AVLDisposeItemUPP = ^SInt32; { an opaque UPP }
{$elsec}
	AVLDisposeItemUPP = UniversalProcPtr;
{$endc}	
{$ifc OPAQUE_UPP_TYPES}
	AVLWalkUPP = ^SInt32; { an opaque UPP }
{$elsec}
	AVLWalkUPP = UniversalProcPtr;
{$endc}	

const
	uppAVLCompareItemsProcInfo = $00002FF0;
	uppAVLItemSizeProcInfo = $000003F0;
	uppAVLDisposeItemProcInfo = $000003C0;
	uppAVLWalkProcInfo = $000FEBE0;
	{
	 *  NewAVLCompareItemsUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 and later
	 	}
function NewAVLCompareItemsUPP(userRoutine: AVLCompareItemsProcPtr): AVLCompareItemsUPP; external name '_NewAVLCompareItemsUPP'; { old name was NewAVLCompareItemsProc }
{
 *  NewAVLItemSizeUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function NewAVLItemSizeUPP(userRoutine: AVLItemSizeProcPtr): AVLItemSizeUPP; external name '_NewAVLItemSizeUPP'; { old name was NewAVLItemSizeProc }
{
 *  NewAVLDisposeItemUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function NewAVLDisposeItemUPP(userRoutine: AVLDisposeItemProcPtr): AVLDisposeItemUPP; external name '_NewAVLDisposeItemUPP'; { old name was NewAVLDisposeItemProc }
{
 *  NewAVLWalkUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function NewAVLWalkUPP(userRoutine: AVLWalkProcPtr): AVLWalkUPP; external name '_NewAVLWalkUPP'; { old name was NewAVLWalkProc }
{
 *  DisposeAVLCompareItemsUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure DisposeAVLCompareItemsUPP(userUPP: AVLCompareItemsUPP); external name '_DisposeAVLCompareItemsUPP';
{
 *  DisposeAVLItemSizeUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure DisposeAVLItemSizeUPP(userUPP: AVLItemSizeUPP); external name '_DisposeAVLItemSizeUPP';
{
 *  DisposeAVLDisposeItemUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure DisposeAVLDisposeItemUPP(userUPP: AVLDisposeItemUPP); external name '_DisposeAVLDisposeItemUPP';
{
 *  DisposeAVLWalkUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure DisposeAVLWalkUPP(userUPP: AVLWalkUPP); external name '_DisposeAVLWalkUPP';
{
 *  InvokeAVLCompareItemsUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function InvokeAVLCompareItemsUPP(tree: AVLTreePtr; i1: UnivPtr; i2: UnivPtr; nd_typ: AVLNodeType; userRoutine: AVLCompareItemsUPP): SInt32; external name '_InvokeAVLCompareItemsUPP'; { old name was CallAVLCompareItemsProc }
{
 *  InvokeAVLItemSizeUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function InvokeAVLItemSizeUPP(tree: AVLTreePtr; itemPtr: UnivPtr; userRoutine: AVLItemSizeUPP): UInt32; external name '_InvokeAVLItemSizeUPP'; { old name was CallAVLItemSizeProc }
{
 *  InvokeAVLDisposeItemUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure InvokeAVLDisposeItemUPP(tree: AVLTreePtr; dataP: UnivPtr; userRoutine: AVLDisposeItemUPP); external name '_InvokeAVLDisposeItemUPP'; { old name was CallAVLDisposeItemProc }
{
 *  InvokeAVLWalkUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function InvokeAVLWalkUPP(tree: AVLTreePtr; dataP: UnivPtr; visitStage: AVLVisitStage; node: AVLNodeType; level: UInt32; balance: SInt32; refCon: UnivPtr; userRoutine: AVLWalkUPP): OSErr; external name '_InvokeAVLWalkUPP'; { old name was CallAVLWalkProc }
{
    Create an AVL tree.  The compareItemsProc and the sizeItemProc are required; disposeItemProc is
    optional and can be nil.  The refCon is stored with the list, and is passed back to the
    compareItemsProc, sizeItemProc, and disposeItemsProc calls.  The allocation of the tree ( and all
    nodes later added to the list with AVLInsert ) will be created in what is the current zone at the
    time AVLInit() is called.  Always call AVLDispose() to dispose of a list created with AVLInit().
}
{
 *  AVLInit()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AVLInit(flags: UInt32; compareItemsProc: AVLCompareItemsUPP; sizeItemProc: AVLItemSizeUPP; disposeItemProc: AVLDisposeItemUPP; refCon: UnivPtr; var tree: AVLTreePtr): OSErr; external name '_AVLInit';
{
    Dispose of an AVL tree.  This will dispose of each item in the tree in the order specified,
    call the tree's disposeProc proc for each item, and then dispose of the space allocated for
    the tree itself.
}
{
 *  AVLDispose()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AVLDispose(var tree: AVLTreePtr; order: AVLOrder): OSErr; external name '_AVLDispose';
{
    Iterate across all of the items in the tree, in the order specified.  kLeftToRight is
    basically lowest-to-highest order, kRightToLeft is highest-to-lowest order.  For each
    node in the tree, it will call the walkProc with three messages ( at the appropriate 
    time ).  First, with kAVLPreOrder when the walking gets to this node in the tree,
    before handling either the left or right subtree, secondly, with kAVLInOrder after
    handling one subtree but before handling the other, and lastly with kAVLPostOrder after
    handling both subtrees.  If you want to handle items in order, then only do something
    if the visit stage is kAVLInOrder.  You can only call AVLRemove() from inside a walkProc
    if visit stage is kAVLPostOrder ( because if you remove a node during the pre or in order
    stages you will corrupt the list ) OR if you return a non-zero result from the walkProc
    call which called AVLRemove() to immediately terminate the walkProc.  Do not call AVLInsert()
    to insert a node into the tree from inside a walkProc.
    The walkProc function gets called with the AVLTreePtr, a pointer to the data for the
    current node ( which you can change in place as long as you do not affect the order within
    the tree ), the visit stage, the type of the current node ( leaf node, right or left branch,
    or full tree ), the level within the tree ( the root is level 1 ), the balance for the
    current node, and the refCon passed to AVLWalk().  This refCon is different from the one passed
    into AVLInit(); use AVLGetRefCon() to get that refCon if you want it inside a walkProc.
    ( Most walkProcs will not care about the values for node type, level, or balance. )
}
{
 *  AVLWalk()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AVLWalk(tree: AVLTreePtr; walkProc: AVLWalkUPP; order: AVLOrder; walkRefCon: UnivPtr): OSErr; external name '_AVLWalk';
{   Return  the number of items in the given tree. }
{
 *  AVLCount()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AVLCount(tree: AVLTreePtr; var count: UInt32): OSErr; external name '_AVLCount';
{
    Return the one-based index-th item from the tree by putting it's data at dataPtr
    if dataPtr is non-nil, and it's size into *itemSize if itemSize is non-nil.
    If index is out of range, return errItemNotFoundInTree.  ( Internally, this does
    an AVLWalk(), so the tree can not be modified while this call is in progress ).
}
{
 *  AVLGetIndItem()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AVLGetIndItem(tree: AVLTreePtr; index: UInt32; dataPtr: UnivPtr; var itemSize: UInt32): OSErr; external name '_AVLGetIndItem';
{
    Insert the given item into the tree.  This will call the tree's sizeItemProc
    to determine how big the item at data is, and then will make a copy of the
    item and insert it into the tree in the appropriate place.  If an item already
    exists in the tree with the same key ( so that the compareItemsUPP returns 0
    when asked to compare this item to an existing one ), then it will return
    errItemNotFoundInTree.
}
{
 *  AVLInsert()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AVLInsert(tree: AVLTreePtr; data: UnivPtr): OSErr; external name '_AVLInsert';
{
    Remove any item from the tree with the given key.  If dataPtr != nil, then
    copy the item's data to dataPtr before removing it from the tree.  Before
    removing the item, call the tree's disposeItemProc to let it release anything
    used by the data in the tree.  It is not necessary to fill in a complete
    record for key, only that the compareItemsProc return 0 when asked to compare
    the data at key with the node in the tree to be deleted.  If the item cannot
    be found in the tree, this will return errItemNotFoundInTree.
}
{
 *  AVLRemove()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AVLRemove(tree: AVLTreePtr; key: UnivPtr; dataPtr: UnivPtr; var itemSize: UInt32): OSErr; external name '_AVLRemove';
{
    Find the item in the tree with the given key, and return it's data in
    dataPtr ( if dataPtr != nil ), and it's size in *itemSize ( if itemSize
    != nil ).  It is not necessary to fill in a complete record for key,
    only that the compareItemsProc return 0 when asked to compare the data
    at key with the node in the tree to be deleted.  If the item cannot
    be found in the tree, this will return errItemNotFoundInTree.
}
{
 *  AVLFind()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AVLFind(tree: AVLTreePtr; key: UnivPtr; dataPtr: UnivPtr; var itemSize: UInt32): OSErr; external name '_AVLFind';
{
    Get the refCon for the given tree ( set in AVLInit ) and return it.
    If the given tree is invalid, then return nil.
}
{
 *  AVLGetRefcon()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AVLGetRefcon(tree: AVLTreePtr; var refCon: UnivPtr): OSErr; external name '_AVLGetRefcon';
{
    Get the refCon for the given tree ( set in AVLInit ) and return it.
    If the given tree is invalid, then return nil.
}
{$ifc CALL_NOT_IN_CARBON}
{
 *  AVLLockTree()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.2.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function AVLLockTree(tree: AVLTreePtr): OSErr; external name '_AVLLockTree';
{
    Get the refCon for the given tree ( set in AVLInit ) and return it.
    If the given tree is invalid, then return nil.
}
{
 *  AVLUnlockTree()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.2.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function AVLUnlockTree(tree: AVLTreePtr): OSErr; external name '_AVLUnlockTree';
{
    Get the refCon for the given tree ( set in AVLInit ) and return it.
    If the given tree is invalid, then return nil.
}
{
 *  AVLCheckTree()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 9.2.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function AVLCheckTree(tree: AVLTreePtr): OSErr; external name '_AVLCheckTree';
{$endc}  {CALL_NOT_IN_CARBON}

{$ALIGN MAC68K}


{unit AXConstants}
{
 *  AXConstants.h
 *
 *  Created by John Louch on Tue Mar 26 2002.
 *  Copyright (c) 2002 Apple Computer, Inc. All rights reserved.
 *
 }
{	  Pascal Translation:  Peter N Lewis, <peter@stairways.com.au>, 2004 }


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN MAC68K}
// standard attributes
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXRoleAttribute CFSTRP('AXRole')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXRoleDescriptionAttribute CFSTRP('AXRoleDescription')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXSubroleAttribute CFSTRP('AXSubrole')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXHelpAttribute CFSTRP('AXHelp')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXTitleAttribute CFSTRP('AXTitle')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXValueAttribute CFSTRP('AXValue')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMinValueAttribute CFSTRP('AXMinValue')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMaxValueAttribute CFSTRP('AXMaxValue')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXEnabledAttribute CFSTRP('AXEnabled')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXFocusedAttribute CFSTRP('AXFocused')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXParentAttribute CFSTRP('AXParent')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXChildrenAttribute CFSTRP('AXChildren')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXSelectedChildrenAttribute CFSTRP('AXSelectedChildren')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXVisibleChildrenAttribute CFSTRP('AXVisibleChildren')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXWindowAttribute CFSTRP('AXWindow')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXPositionAttribute CFSTRP('AXPosition')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXSizeAttribute CFSTRP('AXSize')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXOrientationAttribute CFSTRP('AXOrientation')}
{$endc}

// text-specific attributes
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXTextAttribute CFSTRP('AXText')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXSelectedTextAttribute CFSTRP('AXSelectedText')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXSelectedTextRangeAttribute CFSTRP('AXSelectedTextRange')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXVisibleTextAttribute CFSTRP('AXVisibleText')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXVisibleCharacterRangeAttribute CFSTRP('AXVisibleCharacterRange')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXNumberOfCharactersAttribute CFSTRP('AXNumberOfCharacters')}
{$endc}

// window-specific attributes
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMainAttribute CFSTRP('AXMain')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMinimizedAttribute CFSTRP('AXMinimized')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXCloseButtonAttribute CFSTRP('AXCloseButton')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXZoomButtonAttribute CFSTRP('AXZoomButton')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMinimizeButtonAttribute CFSTRP('AXMinimizeButton')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXToolbarButtonAttribute CFSTRP('AXToolbarButton')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXProxyAttribute CFSTRP('AXProxy')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXGrowAreaAttribute CFSTRP('AXGrowArea')}
{$endc}

// new window-specific attributes
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXModalAttribute CFSTRP('AXModal')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXDefaultButtonAttribute CFSTRP('AXDefaultButton')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXCancelButtonAttribute CFSTRP('AXCancelButton')}
{$endc}

// menu-specific attributes
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMenuItemCmdCharAttribute CFSTRP('AXMenuItemCmdChar')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMenuItemCmdVirtualKeyAttribute CFSTRP('AXMenuItemCmdVirtualKey')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMenuItemCmdGlyphAttribute CFSTRP('AXMenuItemCmdGlyph')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMenuItemCmdModifiersAttribute CFSTRP('AXMenuItemCmdModifiers')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMenuItemMarkCharAttribute CFSTRP('AXMenuItemMarkChar')}
{$endc}

// application-specific attributes
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMenuBarAttribute CFSTRP('AXMenuBar')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXWindowsAttribute CFSTRP('AXWindows')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXFrontmostAttribute CFSTRP('AXFrontmost')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXHiddenAttribute CFSTRP('AXHidden')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMainWindowAttribute CFSTRP('AXMainWindow')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXFocusedWindowAttribute CFSTRP('AXFocusedWindow')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXFocusedUIElementAttribute CFSTRP('AXFocusedUIElement')}
{$endc} 

// misc attributes
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXHeaderAttribute CFSTRP('AXHeader')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXEditedAttribute CFSTRP('AXEdited')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXValueIncrementAttribute CFSTRP('AXValueIncrement')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXValueWrapsAttribute CFSTRP('AXValueWraps')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXTabsAttribute CFSTRP('AXTabs')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXTitleUIElementAttribute CFSTRP('AXTitleUIElement')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXHorizontalScrollBarAttribute CFSTRP('AXHorizontalScrollBar')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXVerticalScrollBarAttribute CFSTRP('AXVerticalScrollBar')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXOverflowButtonAttribute CFSTRP('AXOverflowButton')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXFilenameAttribute CFSTRP('AXFilename')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXExpandedAttribute CFSTRP('AXExpanded')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXSelectedAttribute CFSTRP('AXSelected')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXSplittersAttribute CFSTRP('AXSplitters')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXNextContentsAttribute CFSTRP('AXNextContents')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXDocumentAttribute CFSTRP('AXDocument')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXDecrementButtonAttribute CFSTRP('AXDecrementButton')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXIncrementButtonAttribute CFSTRP('AXIncrementButton')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXPreviousContentsAttribute CFSTRP('AXPreviousContents')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXContentsAttribute CFSTRP('AXContents')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXIncrementorAttribute CFSTRP('AXIncrementor')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXHourFieldAttribute CFSTRP('AXHourField')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMinuteFieldAttribute CFSTRP('AXMinuteField')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXSecondFieldAttribute CFSTRP('AXSecondField')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXAMPMFieldAttribute CFSTRP('AXAMPMField')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXDayFieldAttribute CFSTRP('AXDayField')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMonthFieldAttribute CFSTRP('AXMonthField')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXYearFieldAttribute CFSTRP('AXYearField')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXColumnTitlesAttribute CFSTRP('AXColumnTitles')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXURLAttribute CFSTRP('AXURL')}
{$endc}

// table/outline view attributes
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXRowsAttribute CFSTRP('AXRows')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXVisibleRowsAttribute CFSTRP('AXVisibleRows')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXSelectedRowsAttribute CFSTRP('AXSelectedRows')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXColumnsAttribute CFSTRP('AXColumns')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXVisibleColumnsAttribute CFSTRP('AXVisibleColumns')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXSelectedColumnsAttribute CFSTRP('AXSelectedColumns')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXSortDirectionAttribute CFSTRP('AXSortDirection')}
{$endc}

// outline attributes
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXDisclosingAttribute CFSTRP('AXDisclosing')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXDisclosedRowsAttribute CFSTRP('AXDisclosedRows')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXDisclosedByRowAttribute CFSTRP('AXDisclosedByRow')}
{$endc}

// system-wide attributes
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXFocusedApplicationAttribute CFSTRP('AXFocusedApplication')}
{$endc}

//
// Parameterized Attributes
//

// Text Suite Parameterized Attributes
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXLineForIndexParameterizedAttribute CFSTRP('AXLineForIndex')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXRangeForLineParameterizedAttribute CFSTRP('AXRangeForLine')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXStringForRangeParameterizedAttribute CFSTRP('AXStringForRange')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXRangeForPositionParameterizedAttribute CFSTRP('AXRangeForPosition')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXRangeForIndexParameterizedAttribute CFSTRP('AXRangeForIndex')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXBoundsForRangeParameterizedAttribute CFSTRP('AXBoundsForRange')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXRTFForRangeParameterizedAttribute CFSTRP('AXRTFForRange')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXStyleRangeForIndexParameterizedAttribute CFSTRP('AXStyleRangeForIndex')}
{$endc}

//
// standard values
//

// orientations (see kAXOrientationAttribute)
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXHorizontalOrientationValue CFSTRP('AXHorizontalOrientation')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXVerticalOrientationValue CFSTRP('AXVerticalOrientation')}
{$endc}

// standard actions
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXPressAction CFSTRP('AXPress')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXIncrementAction CFSTRP('AXIncrement')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXDecrementAction CFSTRP('AXDecrement')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXConfirmAction CFSTRP('AXConfirm')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXPickAction CFSTRP('AXPick')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXCancelAction CFSTRP('AXCancel')}
{$endc}

// new actions
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXRaiseAction CFSTRP('AXRaise')}
{$endc}

// standard roles
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXApplicationRole CFSTRP('AXApplication')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXSystemWideRole CFSTRP('AXSystemWide')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXWindowRole CFSTRP('AXWindow')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXSheetRole CFSTRP('AXSheet')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXDrawerRole CFSTRP('AXDrawer')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXGrowAreaRole CFSTRP('AXGrowArea')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXImageRole CFSTRP('AXImage')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXUnknownRole CFSTRP('AXUnknown')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXButtonRole CFSTRP('AXButton')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXRadioButtonRole CFSTRP('AXRadioButton')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXCheckBoxRole CFSTRP('AXCheckBox')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXPopUpButtonRole CFSTRP('AXPopUpButton')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMenuButtonRole CFSTRP('AXMenuButton')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXTabGroupRole CFSTRP('AXTabGroup')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXTableRole CFSTRP('AXTable')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXColumnRole CFSTRP('AXColumn')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXRowRole CFSTRP('AXRow')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXOutlineRole CFSTRP('AXOutline')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXBrowserRole CFSTRP('AXBrowser')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXScrollAreaRole CFSTRP('AXScrollArea')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXScrollBarRole CFSTRP('AXScrollBar')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXRadioGroupRole CFSTRP('AXRadioGroup')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXListRole CFSTRP('AXList')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXGroupRole CFSTRP('AXGroup')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXValueIndicatorRole CFSTRP('AXValueIndicator')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXComboBoxRole CFSTRP('AXComboBox')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXSliderRole CFSTRP('AXSlider')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXIncrementorRole CFSTRP('AXIncrementor')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXBusyIndicatorRole CFSTRP('AXBusyIndicator')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXProgressIndicatorRole CFSTRP('AXProgressIndicator')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXToolbarRole CFSTRP('AXToolbar')}
{$endc}

{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXTextFieldRole CFSTRP('AXTextField')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXTextAreaRole CFSTRP('AXTextArea')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXStaticTextRole CFSTRP('AXStaticText')}
{$endc}

{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMenuBarRole CFSTRP('AXMenuBar')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMenuBarItemRole CFSTRP('AXMenuBarItem')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMenuRole CFSTRP('AXMenu')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMenuItemRole CFSTRP('AXMenuItem')}
{$endc}

{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXSplitGroupRole CFSTRP('AXSplitGroup')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXSplitterRole CFSTRP('AXSplitter')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXColorWellRole CFSTRP('AXColorWell')}
{$endc}

{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXTimeFieldRole CFSTRP('AXTimeField')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXDateFieldRole CFSTRP('AXDateField')}
{$endc}

// standard subroles
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXCloseButtonSubrole CFSTRP('AXCloseButton')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMinimizeButtonSubrole CFSTRP('AXMinimizeButton')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXZoomButtonSubrole CFSTRP('AXZoomButton')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXToolbarButtonSubrole CFSTRP('AXToolbarButton')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXSecureTextFieldSubrole CFSTRP('AXSecureTextField')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXTableRowSubrole CFSTRP('AXTableRow')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXOutlineRowSubrole CFSTRP('AXOutlineRow')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXUnknownSubrole CFSTRP('AXUnknown')}
{$endc}

// new subroles
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXStandardWindowSubrole CFSTRP('AXStandardWindow')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXDialogSubrole CFSTRP('AXDialog')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXSystemDialogSubrole CFSTRP('AXSystemDialog')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXFloatingWindowSubrole CFSTRP('AXFloatingWindow')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXSystemFloatingWindowSubrole CFSTRP('AXSystemFloatingWindow')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXIncrementArrowSubrole CFSTRP('AXIncrementArrow')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXDecrementArrowSubrole CFSTRP('AXDecrementArrow')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXIncrementPageSubrole CFSTRP('AXIncrementPage')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXDecrementPageSubrole CFSTRP('AXDecrementPage')}
{$endc}

// focus notifications
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMainWindowChangedNotification CFSTRP('AXMainWindowChanged')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXFocusedWindowChangedNotification CFSTRP('AXFocusedWindowChanged')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXFocusedUIElementChangedNotification CFSTRP('AXFocusedUIElementChanged')}
{$endc}

// application notifications
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXApplicationActivatedNotification CFSTRP('AXApplicationActivated')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXApplicationDeactivatedNotification CFSTRP('AXApplicationDeactivated')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXApplicationHiddenNotification CFSTRP('AXApplicationHidden')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXApplicationShownNotification CFSTRP('AXApplicationShown')}
{$endc}

// window notifications
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXWindowCreatedNotification CFSTRP('AXWindowCreated')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXWindowMovedNotification CFSTRP('AXWindowMoved')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXWindowResizedNotification CFSTRP('AXWindowResized')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXWindowMiniaturizedNotification CFSTRP('AXWindowMiniaturized')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXWindowDeminiaturizedNotification CFSTRP('AXWindowDeminiaturized')}
{$endc}

// new drawer & sheet notifications
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXDrawerCreatedNotification CFSTRP('AXDrawerCreated')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXSheetCreatedNotification CFSTRP('AXSheetCreated')}
{$endc}

// element notifications
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXValueChangedNotification CFSTRP('AXValueChanged')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXUIElementDestroyedNotification CFSTRP('AXUIElementDestroyed')}
{$endc}

// menu notifications
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMenuOpenedNotification CFSTRP('AXMenuOpened')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMenuClosedNotification CFSTRP('AXMenuClosed')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXMenuItemSelectedNotification CFSTRP('AXMenuItemSelected')}
{$endc}


// obsolete constants will be removed soon
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXRelevanceIndicatorRole CFSTRP('AXRelevanceIndicator')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAXIsEditableAttribute CFSTRP('AXIsEditable')}
{$endc}

{unit AXErrors}
{
 *  AXError.h
 *
 *  Copyright (c) 2002 Apple Computer, Inc. All rights reserved.
 *
 }
{	  Pascal Translation:  Peter N Lewis, <peter@stairways.com.au>, 2004 }
{	  Unit name changed to AXErrors to avoid conflict with AXError type }


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN MAC68K}
const
    kAXErrorSuccess 				= 0;
    kAXErrorFailure				= -25200;
    kAXErrorIllegalArgument			= -25201;
    kAXErrorInvalidUIElement			= -25202;
    kAXErrorInvalidUIElementObserver		= -25203;
    kAXErrorCannotComplete			= -25204;
    kAXErrorAttributeUnsupported		= -25205;
    kAXErrorActionUnsupported			= -25206;
    kAXErrorNotificationUnsupported		= -25207;
    kAXErrorNotImplemented			= -25208;
    kAXErrorNotificationAlreadyRegistered	= -25209;
    kAXErrorNotificationNotRegistered		= -25210;
    kAXErrorAPIDisabled				= -25211;
    kAXErrorNoValue				= -25212;
    kAXErrorParameterizedAttributeUnsupported	= -25213;

type
  AXError = SInt32;

{unit AppleDiskPartitions}
{
     File:       AppleDiskPartitions.p
 
     Contains:   The Apple disk partition scheme as defined in Inside Macintosh: Volume V.
 
     Version:    Technology: Mac OS 9
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   2000-2002 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}

{ Block 0 Definitions }

const
	sbSIGWord					= $4552;						{  signature word for Block 0 ('ER')  }
	sbMac						= 1;							{  system type for Mac  }

	{	 Partition Map Signatures 	}
	pMapSIG						= $504D;						{  partition map signature ('PM')  }
	pdSigWord					= $5453;						{  partition map signature ('TS')  }
	oldPMSigWord				= $5453;
	newPMSigWord				= $504D;


	{	 Driver Descriptor Map 	}

type
	Block0Ptr = ^Block0;
	Block0 = packed record
		sbSig:					UInt16;									{  unique value for SCSI block 0  }
		sbBlkSize:				UInt16;									{  block size of device  }
		sbBlkCount:				UInt32;									{  number of blocks on device  }
		sbDevType:				UInt16;									{  device type  }
		sbDevId:				UInt16;									{  device id  }
		sbData:					UInt32;									{  not used  }
		sbDrvrCount:			UInt16;									{  driver descriptor count  }
		ddBlock:				UInt32;									{  1st driver's starting block  }
		ddSize:					UInt16;									{  size of 1st driver (512-byte blks)  }
		ddType:					UInt16;									{  system type (1 for Mac+)  }
		ddPad:					array [0..242] of UInt16;				{  array[0..242] of SInt16; not used  }
	end;

	{	 Driver descriptor 	}
	DDMapPtr = ^DDMap;
	DDMap = record
		ddBlock:				UInt32;									{  1st driver's starting block  }
		ddSize:					UInt16;									{  size of 1st driver (512-byte blks)  }
		ddType:					UInt16;									{  system type (1 for Mac+)  }
	end;

	{	 Constants for the ddType field of the DDMap structure. 	}

const
	kDriverTypeMacSCSI			= $0001;
	kDriverTypeMacATA			= $0701;
	kDriverTypeMacSCSIChained	= $FFFF;
	kDriverTypeMacATAChained	= $F8FF;

	{	 Partition Map Entry 	}

type
	PartitionPtr = ^Partition;
	Partition = packed record
		pmSig:					UInt16;									{  unique value for map entry blk  }
		pmSigPad:				UInt16;									{  currently unused  }
		pmMapBlkCnt:			UInt32;									{  # of blks in partition map  }
		pmPyPartStart:			UInt32;									{  physical start blk of partition  }
		pmPartBlkCnt:			UInt32;									{  # of blks in this partition  }
		pmPartName:				packed array [0..31] of UInt8;			{  ASCII partition name  }
		pmParType:				packed array [0..31] of UInt8;			{  ASCII partition type  }
		pmLgDataStart:			UInt32;									{  log. # of partition's 1st data blk  }
		pmDataCnt:				UInt32;									{  # of blks in partition's data area  }
		pmPartStatus:			UInt32;									{  bit field for partition status  }
		pmLgBootStart:			UInt32;									{  log. blk of partition's boot code  }
		pmBootSize:				UInt32;									{  number of bytes in boot code  }
		pmBootAddr:				UInt32;									{  memory load address of boot code  }
		pmBootAddr2:			UInt32;									{  currently unused  }
		pmBootEntry:			UInt32;									{  entry point of boot code  }
		pmBootEntry2:			UInt32;									{  currently unused  }
		pmBootCksum:			UInt32;									{  checksum of boot code  }
		pmProcessor:			packed array [0..15] of UInt8;			{  ASCII for the processor type  }
		pmPad:					array [0..187] of UInt16;				{  array[0..187] of SInt16; not used  }
	end;


	{	 Flags for the pmPartStatus field of the Partition data structure. 	}

const
	kPartitionAUXIsValid		= $00000001;
	kPartitionAUXIsAllocated	= $00000002;
	kPartitionAUXIsInUse		= $00000004;
	kPartitionAUXIsBootValid	= $00000008;
	kPartitionAUXIsReadable		= $00000010;
	kPartitionAUXIsWriteable	= $00000020;
	kPartitionAUXIsBootCodePositionIndependent = $00000040;
	kPartitionIsWriteable		= $00000020;
	kPartitionIsMountedAtStartup = $40000000;
	kPartitionIsStartup			= $80000000;
	kPartitionIsChainCompatible	= $00000100;
	kPartitionIsRealDeviceDriver = $00000200;
	kPartitionCanChainToNext	= $00000400;


	{	 Well known driver signatures, stored in the first four byte of pmPad. 	}
	kPatchDriverSignature		= $70744452 (* 'ptDR' *);						{  SCSI and ATA[PI] patch driver     }
	kSCSIDriverSignature		= $00010600;					{  SCSI  hard disk driver            }
	kATADriverSignature			= $77696B69 (* 'wiki' *);						{  ATA   hard disk driver            }
	kSCSICDDriverSignature		= $43447672 (* 'CDvr' *);						{  SCSI  CD-ROM    driver            }
	kATAPIDriverSignature		= $41545049 (* 'ATPI' *);						{  ATAPI CD-ROM    driver            }
	kDriveSetupHFSSignature		= $44535531 (* 'DSU1' *);						{  Drive Setup HFS partition         }


{$ALIGN MAC68K}


{unit Authorization}
{
 * Copyright (c) 2000-2002 Apple Computer, Inc. All Rights Reserved.
 * 
 * The contents of this file constitute Original Code as defined in and are
 * subject to the Apple Public Source License Version 1.2 (the 'License').
 * You may not use this file except in compliance with the License. Please obtain
 * a copy of the License at http://www.apple.com/publicsource and read it before
 * using this file.
 * 
 * This Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY of ANY KIND, EITHER EXPRESS
 * OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES, INCLUDING WITHOUT
 * LIMITATION, ANY WARRANTIES of MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see the License for the
 * specific language governing rights and limitations under the License.
 }
{	  Pascal Translation:  Peter N Lewis, <peter@stairways.com.au>, 2004 }


{
 *  Authorization.h -- APIs for implementing access control in applications
 *  and daemons.
 }


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN MAC68K}
{!
	@header Authorization
	Version 1.0 10/16/2000

	The Authorization API contains all the APIs that a application or tool that need pre-authorization or need an authorization desision made.
	
	A typical use cases are a preference panel that would start off calling AuthorizationCreate() (without UI) to get an authorization object.  Then call AuthorizationCopyRights() to figure out what is currently allowed.
	
	If any of the operations that the preference panel wishes to perform are currently not allowed the lock icon in the window would show up in the locked state.  Otherwise it would show up unlocked.
	
	When the user locks the lock AuthorizationFree() is called with the kAuthorizationFlagDestroyRights to destroy any authorization rights that have been aquired.
	
	When the user unlocks the lock AuthorizationCreate() is called with the kAuthorizationFlagInteractionAllowed and kAuthorizationFlagExtendRights flags to obtain all required rights.  The old authorization object can be freed by calling AuthorizationFree() with no flags.

}


{!
	@defined kAuthorizationEmptyEnvironment
	Parameter to specify to AuthorizationCreate when no environment is being provided.
}
const kAuthorizationEmptyEnvironment = nil;


{!
	@enum AuthorizationStatus
	Error codes returned by Authorization API.
}

{
    Note: the comments that appear after these errors are used to create SecErrorMessages.strings.
    The comments must not be multi-line, and should be in a form meaningful to an end user. If
    a different or additional comment is needed, it can be put in the header doc format, or on a
    line that does not start with errZZZ.
}

const
	errAuthorizationSuccess					= 0;      { The operation completed successfully. }
	errAuthorizationInvalidSet				= -60001; { The set parameter is invalid. }
	errAuthorizationInvalidRef				= -60002; { The authorization parameter is invalid. }
	errAuthorizationInvalidTag				= -60003; { The tag parameter is invalid. }
	errAuthorizationInvalidPointer			= -60004; { The authorizedRights parameter is invalid. }
	errAuthorizationDenied					= -60005; { The authorization was denied. }
	errAuthorizationCanceled				= -60006; { The authorization was cancelled by the user. }
	errAuthorizationInteractionNotAllowed	= -60007; { The authorization was denied since no user interaction was possible. }
	errAuthorizationInternal                = -60008; { something else went wrong }
	errAuthorizationExternalizeNotAllowed	= -60009; { authorization externalization denied }
	errAuthorizationInternalizeNotAllowed	= -60010; { authorization internalization denied }
	errAuthorizationInvalidFlags            = -60011; { invalid option flag(s) }
	errAuthorizationToolExecuteFailure      = -60031; { cannot execute privileged tool }
	errAuthorizationToolEnvironmentError    = -60032; { privileged tool environment error }
	errAuthorizationBadAddress				= -60033; { invalid socket address requested }


{!
	@enum AuthorizationFlags
	Optional flags passed in to serveral Authorization APIs. See the description of AuthorizationCreate, AuthorizationCopyRights and AuthorizationFree for a description of how they affect those calls.
}
const
	kAuthorizationFlagDefaults              = 0;
	kAuthorizationFlagInteractionAllowed	= (1 shl 0);
	kAuthorizationFlagExtendRights			= (1 shl 1);
	kAuthorizationFlagPartialRights			= (1 shl 2);
	kAuthorizationFlagDestroyRights			= (1 shl 3);
	kAuthorizationFlagPreAuthorize			= (1 shl 4);
	
	// private bits (do not use)
	kAuthorizationFlagNoData                = (1 shl 20);


{!
	@typedef AuthorizationFlags
	Optional flags passed in to AuthorizationCreate.
}
type AuthorizationFlags = UInt32;


{!
	@enum AuthorizationRightFlags
	Flags returned in the flags field of ItemSet Items when calling AuthorizationCopyRights().
}
const
	kAuthorizationFlagCanNotPreAuthorize = (1 shl 0);


{!
	@typedef AuthorizationRef
	Opaque reference to an authorization object.
}
type
	AuthorizationRef							= ^SInt32;


{!
	@typedef AuthorizationString
	A zero terminated string in UTF-8 encoding.
}
type AuthorizationString = CStringPtr;


{!
	@struct AuthorizationItem
	Each AuthorizationItem describes a single string-named item with optional
	parameter value. The value must be contiguous memory of valueLength bytes;
	internal structure is defined separately for each name.

	@field name name of the item, as an AuthorizationString. Mandatory.
	@field valueLength Number of bytes in parameter value. Must be 0 if no parameter value.
	@field value Pointer to the optional parameter value associated with name.
	Must be NULL if no parameter value.
	@field flags Reserved field. Must be set to 0 on creation. Do not modify after that.
}
type
	AuthorizationItem = record
		name: AuthorizationString;
		valueLength: UInt32;
		value: Ptr;
		flags: UInt32;
	end;
	AuthorizationItemPtr = ^AuthorizationItem;


{!
	@struct AuthorizationItemSet
	An AuthorizationItemSet structure represents a set of zero or more AuthorizationItems.  Since it is a set it should not contain any identical AuthorizationItems.

	@field count Number of items identified by items.
	@field items Pointer to an array of items.
}
type
	AuthorizationItemSet = record
		count: UInt32;
		items: AuthorizationItemPtr;
	end;
	AuthorizationItemSetPtr = ^AuthorizationItemSet;

{!
	@struct AuthorizationExternalForm
	An AuthorizationExternalForm structure can hold the externalized form of
	an AuthorizationRef. As such, it can be transmitted across IPC channels
	to other processes, which can re-internalize it to recover a valid AuthorizationRef
	handle.
	The data contained in an AuthorizationExternalForm should be considered opaque.

	SECURITY NOTE: Applications should take care to not disclose the AuthorizationExternalForm to
	potential attackers since it would authorize rights to them.
}
const kAuthorizationExternalFormLength = 32;

type
	AuthorizationExternalForm = record
		bytes: packed array[0..(kAuthorizationExternalFormLength)-1] of char;
	end;


{!
	@typedef AuthorizationRights
	An AuthorizationItemSet representing a set of rights each with an associated argument (value).
	Each argument value is as defined for the specific right they belong to.  Argument values may not contain pointers as the should be copyable to different address spaces.
}
type AuthorizationRights = AuthorizationItemSet;
type AuthorizationRightsPtr = ^AuthorizationRights;
type AuthorizationRightsPtrPtr = ^AuthorizationRightsPtr;


{!
	@typedef AuthorizationEnvironment
	An AuthorizationItemSet representing environmental information of potential use
	to authorization decisions.
}
type AuthorizationEnvironment = AuthorizationItemSet;
type AuthorizationEnvironmentPtr = ^AuthorizationEnvironment;


{!
    @function AuthorizationCreate
    Create a new autorization object which can be used in other authorization calls.  When the authorization is no longer needed AuthorizationFree should be called.

	When the kAuthorizationFlagInteractionAllowed flag is set, user interaction will happen when required.  Failing to set this flag will result in this call failing with a errAuthorizationInteractionNotAllowed status when interaction is required.

	Setting the kAuthorizationFlagExtendRights flag will extend the currently available rights. If this flag is set the returned AuthorizationRef will grant all the rights requested when errAuthorizationSuccess is returned. If this flag is not set the operation will almost certainly succeed, but no attempt will be made to make the requested rights availible.
		Call AuthorizationCopyRights to figure out which of the requested rights are granted by the returned AuthorizationRef.

	Setting the kAuthorizationFlagPartialRights flag will cause this call to succeed if only some of the requested rights are being granted by the returned AuthorizationRef. Unless this flag is set this API will fail if not all the requested rights could be obtained.

	Setting the kAuthorizationFlagDestroyRights flag will prevent any rights obtained during this call from being preserved after returning from this API (This is most useful when the authorization parameter is NULL and the caller doesn't want to affect the session state in any way).

	Setting the kAuthorizationFlagPreAuthorize flag will pre authorize the requested rights so that at a later time -- by calling AuthorizationMakeExternalForm() follow by AuthorizationCreateFromExternalForm() -- the obtained rights can be used in a different process.  Rights that can't be preauthorized will be treated as if they were authorized for the sake of returning an error (in other words if all rights are either authorized or could not be preauthorized this call will still succeed).
		The rights which could not be preauthorized are not currently authorized and may fail to authorize when a later call to AuthorizationCopyRights() is made, unless the kAuthorizationFlagExtendRights and kAuthorizationFlagInteractionAllowed flags are set.  Even then they might still fail if the user does not supply the correct credentials.
		The reason for passing in this flag is to provide correct audit trail information and to avoid unnecessary user interaction.

    @param rights (input/optional) An AuthorizationItemSet containing rights for which authorization is being requested.  If none are specified the resulting AuthorizationRef will authorize nothing at all.
    @param environment (input/optional) An AuthorizationItemSet containing enviroment state used when making the autorization decision.  See the AuthorizationEnvironment type for details.
    @param flags (input) options specified by the AuthorizationFlags enum.  set all unused bits to zero to allow for future expansion.
    @param authorization (output optional) A pointer to an AuthorizationRef to be returned.  When the returned AuthorizationRef is no longer needed AuthorizationFree should be called to prevent anyone from using the aquired rights.  If NULL is specified no new rights are returned, but the system will attempt to authorize all the requested rights and return the appropriate status.

    @result errAuthorizationSuccess 0 authorization or all requested rights succeeded.

	errAuthorizationDenied -60005 The authorization for one or more of the requested rights was denied.

	errAuthorizationCanceled -60006 The authorization was cancelled by the user.

	errAuthorizationInteractionNotAllowed -60007 The authorization was denied since no interaction with the user was allowed.
}
function AuthorizationCreate(rights: AuthorizationRightsPtr; environment: AuthorizationEnvironmentPtr; flags: AuthorizationFlags; var authorization: AuthorizationRef): OSStatus; external name '_AuthorizationCreate';


{!
    @function AuthorizationFree
    Destroy an AutorizationRef object. If the kAuthorizationFlagDestroyRights flag is passed,
	any rights associated with the authorization are lost. Otherwise, only local resources
	are released, and the rights may still be available to other clients.

	Setting the kAuthorizationFlagDestroyRights flag will prevent any rights that were obtained by the specified authorization object to be preserved after returning from this API.  This effectivaly locks down all potentially shared authorizations.

    @param authorization (input) The authorization object on which this operation is performed.
	
	@param flags (input) Bit mask of option flags to this call.

    @result errAuthorizationSuccess 0 No error.

    errAuthorizationInvalidRef -60002 The authorization parameter is invalid.
}
function AuthorizationFree(authorization: AuthorizationRef;flags: AuthorizationFlags): OSStatus; external name '_AuthorizationFree';

{!
	@function AuthorizationCopyRights
    Given a set of rights, return the subset that is currently authorized
    by the AuthorizationRef given.

	When the kAuthorizationFlagInteractionAllowed flag is set, user interaction will happen when required.  Failing to set this flag will result in this call failing with a errAuthorizationInteractionNotAllowed status when interaction is required.

	Setting the kAuthorizationFlagExtendRights flag will extend the currently available rights.

	Setting the kAuthorizationFlagPartialRights flag will cause this call to succeed if only some of the requested rights are being granted by the returned AuthorizationRef.  Unless this flag is set this API will fail if not all the requested rights could be obtained.

	Setting the kAuthorizationFlagDestroyRights flag will prevent any additional rights obtained during this call from being preserved after returning from this API.

	Setting the kAuthorizationFlagPreAuthorize flag will pre authorize the requested rights so that at a later time -- by calling AuthorizationMakeExternalForm() follow by AuthorizationCreateFromExternalForm() -- the obtained rights can be used in a different process.  Rights that can't be preauthorized will be treated as if they were authorized for the sake of returning an error (in other words if all rights are either authorized or could not be preauthorized this call will still succeed), and they will be returned in authorizedRights with their kAuthorizationFlagCanNotPreAuthorize bit in the flags field set to 1.
		The rights which could not be preauthorized are not currently authorized and may fail to authorize when a later call to AuthorizationCopyRights() is made, unless the kAuthorizationFlagExtendRights and kAuthorizationFlagInteractionAllowed flags are set.  Even then they might still fail if the user does not supply the correct credentials.
		The reason for passing in this flag is to provide correct audit trail information and to avoid unnecessary user interaction.

	Setting the kAuthorizationFlagPreAuthorize flag will pre authorize the requested rights so that at a later time -- by calling AuthorizationMakeExternalForm() follow by AuthorizationCreateFromExternalForm() -- the obtained rights can be used in a different process.  When this flags is specified rights that can't be preauthorized will be returned as if they were authorized with their kAuthorizationFlagCanNotPreAuthorize bit in the flags field set to 1.  These rights are not currently authorized and may fail to authorize later unless kAuthorizationFlagExtendRights and kAuthorizationFlagInteractionAllowed flags are set when the actual authorization is done.  And even then they might still fail if the user does not supply the correct credentials.

    @param authorization (input) The authorization object on which this operation is performed.
    @param rights (input) A rights set (see AuthorizationCreate).
    @param environment (input/optional) An AuthorizationItemSet containing enviroment state used when making the autorization decision.  See the AuthorizationEnvironment type for details.
    @param flags (input) options specified by the AuthorizationFlags enum.  set all unused bits to zero to allow for future expansion.
    @param authorizedRights (output/optional) A pointer to a newly allocated AuthorizationInfoSet in which the authorized subset of rights are returned (authorizedRights should be deallocated by calling AuthorizationFreeItemSet() when it is no longer needed).  If NULL the only information returned is the status.  Note that if the kAuthorizationFlagPreAuthorize flag was specified rights that could not be preauthorized are returned in authorizedRights, but their flags contains the kAuthorizationFlagCanNotPreAuthorize bit.

    @result errAuthorizationSuccess 0 No error.

	errAuthorizationInvalidRef -60002 The authorization parameter is invalid.

    errAuthorizationInvalidSet -60001 The rights parameter is invalid.

    errAuthorizationInvalidPointer -60004 The authorizedRights parameter is invalid.
}
function AuthorizationCopyRights(authorization: AuthorizationRef; const (*var*) rights: AuthorizationRights; environment: AuthorizationEnvironmentPtr; flags: AuthorizationFlags; authorizedRights: AuthorizationRightsPtrPtr): OSStatus; external name '_AuthorizationCopyRights';

{!
	@function AuthorizationCopyInfo
	Returns sideband information (e.g. access credentials) obtained from a call to AuthorizationCreate.  The format of this data depends of the tag specified.
	
    @param authorization (input) The authorization object on which this operation is performed.
    @param tag (input/optional) An optional string tag specifing which sideband information should be returned.  When NULL is specified all available information is returned.
    @param flags (input) options specified by the AuthorizationFlags enum.  set all unused bits to zero to allow for future expansion.
    @param info (output) A pointer to a newly allocated AuthorizationInfoSet in which the requested sideband infomation is returned (info should be deallocated by calling AuthorizationFreeItemSet() when it is no longer needed).

    @result errAuthorizationSuccess 0 No error.

    errAuthorizationInvalidRef -60002 The authorization parameter is invalid.

    errAuthorizationInvalidTag -60003 The tag parameter is invalid.

    errAuthorizationInvalidPointer -60004 The info parameter is invalid.
}
function AuthorizationCopyInfo(authorization: AuthorizationRef; tag: AuthorizationString; var info: AuthorizationItemSetPtr): OSStatus; external name '_AuthorizationCopyInfo';

{!
	@function AuthorizationMakeExternalForm
	Turn an Authorization into an external "byte blob" form so it can be
	transmitted to another process.
	Note that *storing* the external form somewhere will probably not do what
	you want, since authorizations are bounded by sessions, processes, and possibly
	time limits. This is for online transmission of authorizations.
	
	@param authorization The (valid) authorization reference to externalize
	@param extForm Pointer to an AuthorizationExternalForm variable to fill.
	
        @result errAuthorizationSuccess 0 No error.

        errAuthorizationExternalizeNotAllowed -60009 Externalizing this authorization is not allowed.

        errAuthorizationInvalidRef -60002 The authorization parameter is invalid.


}
function AuthorizationMakeExternalForm(authorization: AuthorizationRef; var extForm: AuthorizationExternalForm): OSStatus; external name '_AuthorizationMakeExternalForm';


{!
	@function AuthorizationCreateFromExternalForm
	Turn an Authorization into an external "byte blob" form so it can be
	transmitted to another process.
	Note that *storing* the external form somewhere will probably not do what
	you want, since authorizations are bounded by sessions, processes, and possibly
	time limits. This is for online transmission of authorizations.
	
	@param extForm Pointer to an AuthorizationExternalForm value.
	@param authorization Will be filled with a valid AuthorizationRef on success.
	
	@result errAuthorizationInternalizeNotAllowed -60010 Internalizing this authorization is not allowed.
}
function AuthorizationCreateFromExternalForm(const (*var*) extForm: AuthorizationExternalForm; var authorization: AuthorizationRef): OSStatus; external name '_AuthorizationCreateFromExternalForm';


{!
	@function AuthorizationFreeItemSet
	Release the memory allocated for an AuthorizationItemSet that was allocated
	by an API call.
	
    @param set The AuthorizationItemSet to deallocate.

    @result errAuthorizationSuccess 0 No error.

    errAuthorizationInvalidSet -60001 The set parameter is invalid.
}
function AuthorizationFreeItemSet(var setx: AuthorizationItemSet): OSStatus; external name '_AuthorizationFreeItemSet';


{!
	@function AuthorizationExecuteWithPrivileges
	Run an executable tool with enhanced privileges after passing
	suitable authorization procedures.
	
	@param authorization An authorization reference that is used to authorize
	access to the enhanced privileges. It is also passed to the tool for
	further access control.
	@param pathToTool Full pathname to the tool that should be executed
	with enhanced privileges.
	@param options Option bits (reserved). Must be zero.
	@param arguments An argv-style vector of strings to be passed to the tool.
	@param communicationsPipe Assigned a UNIX stdio FILE pointer for
	a bidirectional pipe to communicate with the tool. The tool will have
	this pipe as its standard I/O channels (stdin/stdout). If NULL, do not
	establish a communications pipe.
 }
type
  Arg10000Type = array[0..10000] of CStringPtr;
  Arg10000TypePtr = ^Arg10000Type;
function AuthorizationExecuteWithPrivileges(authorization: AuthorizationRef; pathToTool: CStringPtr; options: AuthorizationFlags; arguments: Arg10000TypePtr; communicationsPipe: UnivPtr): OSStatus; external name '_AuthorizationExecuteWithPrivileges';
// communicationsPipe not yet supported


{!
	@function AuthorizationCopyPrivilegedReference
	From within a tool launched via the AuthorizationExecuteWithPrivileges function
	ONLY, retrieve the AuthorizationRef originally passed to that function.
	While AuthorizationExecuteWithPrivileges already verified the authorization to
	launch your tool, the tool may want to avail itself of any additional pre-authorizations
	the caller may have obtained through that reference.
 }
function AuthorizationCopyPrivilegedReference(var authorization: AuthorizationRef; flags: AuthorizationFlags): OSStatus; external name '_AuthorizationCopyPrivilegedReference';

{unit AuthorizationTags}
{
 * Copyright (c) 2000-2002 Apple Computer, Inc. All Rights Reserved.
 * 
 * The contents of this file constitute Original Code as defined in and are
 * subject to the Apple Public Source License Version 1.2 (the 'License').
 * You may not use this file except in compliance with the License. Please obtain
 * a copy of the License at http://www.apple.com/publicsource and read it before
 * using this file.
 * 
 * This Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY of ANY KIND, EITHER EXPRESS
 * OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES, INCLUDING WITHOUT
 * LIMITATION, ANY WARRANTIES of MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see the License for the
 * specific language governing rights and limitations under the License.
 }
{	  Pascal Translation:  Peter N Lewis, <peter@stairways.com.au>, 2004 }


{
 *  AuthorizationTags.h -- Right tags for implementing access control in
 *  applications and daemons
 }


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN MAC68K}
{!
	@header AuthorizationTags
	Draft version 2 01/23/2001

	This header defines some of the supported rights tags to be used in the Authorization API.
}


{!
	@define kAuthorizationEnvironmentUsername
	The name of the AuthorizationItem that should be passed into the environment when specifying a username.  The value and valueLength should contain the username itself.
}
const kAuthorizationEnvironmentUsername = 'username';

{!
	@define kAuthorizationEnvironmentPassword
	The name of the AuthorizationItem that should be passed into the environment when specifying a password for a given username.  The value and valueLength should contain the actual password data.
}
const kAuthorizationEnvironmentPassword = 'password';

{!
	@define kAuthorizationEnvironmentShared
	The name of the AuthorizationItem that should be passed into the environment when specifying a username and password.  Adding this entry to the environment will cause the username/password to be added to the shared credential pool of the calling applications session.  This means that further calls by other applications in this session will automatically have this credential availible to them.  The value is ignored.
}
const kAuthorizationEnvironmentShared = 'shared';

{!
	@define kAuthorizationRightExecute
	The name of the AuthorizationItem that should be passed into the rights when preauthorizing for a call to AuthorizationExecuteWithPrivileges().
	
	You need to aquire this right to be able to perform a AuthorizationExecuteWithPrivileges() operation.  In addtion to this right you should obtain whatever rights the tool you are executing with privileges need to perform it's operation on your behalf.  Currently no options are supported but you should pass in the full path of the tool you wish to execute in the value and valueLength fields.  In the future we will limit the right to only execute the requested path, and we will display this information to the user.
}
const kAuthorizationRightExecute= 'system.privilege.admin';

{!
	@define kAuthorizationEnvironmentPrompt
	The name of the AuthorizationItem that should be passed into the environment when specifying a invocation specific additional text.  The value should be a localized UTF8 string.
}
const kAuthorizationEnvironmentPrompt = 'prompt';

{!
	@define kAuthorizationEnvironmentIcon
	The name of the AuthorizationItem that should be passed into the environment when specifying an alternate icon to be used.  The value should be a full path to and image NSImage can deal with.
}
const kAuthorizationEnvironmentIcon = 'icon';

{unit CFBase}
{	CFBase.h
	Copyright (c) 1998-2005, Apple, Inc. All rights reserved.
}
{       Pascal Translation Updated:  Peter N Lewis, <peter@stairways.com.au>, September 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}


var kCFCoreFoundationVersionNumber: Float64; external name '_kCFCoreFoundationVersionNumber'; (* attribute const *)

const
	kCFCoreFoundationVersionNumber10_0 = 196.4;
const
	kCFCoreFoundationVersionNumber10_0_3 = 196.5;
const
	kCFCoreFoundationVersionNumber10_1 = 226.0;
{ Note the next two do not follow the usual numbering policy from the base release }
const
	kCFCoreFoundationVersionNumber10_1_2 = 227.2;
const
	kCFCoreFoundationVersionNumber10_1_4 = 227.3;
const
	kCFCoreFoundationVersionNumber10_2 = 263.0;
const
	kCFCoreFoundationVersionNumber10_3 = 299.0;
const
	kCFCoreFoundationVersionNumber10_3_3 = 299.3;
const
	kCFCoreFoundationVersionNumber10_3_4 = 299.31;

{$ifc TARGET_CPU_PPC_64}
type
	CFTypeID = UInt32;
	CFOptionFlags = UInt64;
	CFHashCode = UInt32;
	CFIndex = SInt64;
	CFIndexPtr = ^CFIndex;
{$elsec}
type
	CFTypeID = UInt32;
	CFOptionFlags = UInt32;
	CFHashCode = UInt32;
	CFIndex = SInt32;
	CFIndexPtr = ^CFIndex;
{$endc}

{ Base "type" of all "CF objects", and polymorphic functions on them }
type
	CFTypeRef = ^SInt32; { an opaque 32-bit type }

type
	CFStringRef = ^SInt32; { an opaque 32-bit type }
	CFStringRefPtr = ^CFStringRef;
	CFMutableStringRef = ^SInt32; { an opaque 32-bit type }
	CFMutableStringRefPtr = ^CFMutableStringRef;

{
        Type to mean any instance of a property list type;
        currently, CFString, CFData, CFNumber, CFBoolean, CFDate,
        CFArray, and CFDictionary.
}
type
	CFPropertyListRef = CFTypeRef;

{ Values returned from comparison functions }
	CFComparisonResult = SInt32;
const
	kCFCompareLessThan = -1;
	kCFCompareEqualTo = 0;
	kCFCompareGreaterThan = 1;

{ A standard comparison function }
type
	CFComparatorFunction = function( val1: {const} UnivPtr; val2: {const} UnivPtr; context: UnivPtr ): CFComparisonResult;

{ Constant used by some functions to indicate failed searches. }
{ This is of type CFIndex. }
const
	kCFNotFound = -1;


{ Range type }
type
	CFRangePtr = ^CFRange;
	CFRange = record
		location: CFIndex;
		length: CFIndex;
	end;

function CFRangeMake( loc: CFIndex; len: CFIndex ): CFRange; external name '___CFRangeMake';

{ Private; do not use }
function __CFRangeMake( loc: CFIndex; len: CFIndex ): CFRange; external name '___CFRangeMake';


{#if MAC_OS_X_VERSION_10_2 <= MAC_OS_X_VERSION_MAX_ALLOWED}
{ Null representant }

type
	CFNullRef = ^SInt32; { an opaque 32-bit type }

function CFNullGetTypeID: CFTypeID; external name '_CFNullGetTypeID';

var kCFNull: CFNullRef; external name '_kCFNull'; (* attribute const *)	// the singleton null instance

{#endif}


{ Allocator API

   Most of the time when specifying an allocator to Create functions, the NULL
   argument indicates "use the default"; this is the same as using kCFAllocatorDefault
   or the return value from CFAllocatorGetDefault().  This assures that you will use
   the allocator in effect at that time.

   You should rarely use kCFAllocatorSystemDefault, the default default allocator.
}
type
	CFAllocatorRef = ^SInt32; { an opaque 32-bit type }
	CFAllocatorRefPtr = ^CFAllocatorRef;

{ This is a synonym for NULL, if you'd rather use a named constant. }
var kCFAllocatorDefault: CFAllocatorRef; external name '_kCFAllocatorDefault'; (* attribute const *)

{ Default system allocator; you rarely need to use this. }
var kCFAllocatorSystemDefault: CFAllocatorRef; external name '_kCFAllocatorSystemDefault'; (* attribute const *)

{ This allocator uses malloc(), realloc(), and free(). This should not be
   generally used; stick to kCFAllocatorDefault whenever possible. This
   allocator is useful as the "bytesDeallocator" in CFData or
   "contentsDeallocator" in CFString where the memory was obtained as a
   result of malloc() type functions.
}
var kCFAllocatorMalloc: CFAllocatorRef; external name '_kCFAllocatorMalloc'; (* attribute const *)

{ This allocator explicitly uses the default malloc zone, returned by
   malloc_default_zone(). It should only be used when an object is
   safe to be allocated in non-scanned memory.
 }
var kCFAllocatorMallocZone: CFAllocatorRef; external name '_kCFAllocatorMallocZone'; (* attribute const *)
(* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)

{ Null allocator which does nothing and allocates no memory. This allocator
   is useful as the "bytesDeallocator" in CFData or "contentsDeallocator"
   in CFString where the memory should not be freed. 
}
var kCFAllocatorNull: CFAllocatorRef; external name '_kCFAllocatorNull'; (* attribute const *)

{ Special allocator argument to CFAllocatorCreate() which means
   "use the functions given in the context to allocate the allocator
   itself as well". 
}
var kCFAllocatorUseContext: CFAllocatorRef; external name '_kCFAllocatorUseContext'; (* attribute const *)

type
	CFAllocatorRetainCallBack = function( info: {const} UnivPtr ): UnivPtr;
	CFAllocatorReleaseCallBack = procedure( info: {const} UnivPtr );
	CFAllocatorCopyDescriptionCallBack = function( info: {const} UnivPtr ): CFStringRef;
	CFAllocatorAllocateCallBack = function( allocSize: CFIndex; hint: CFOptionFlags; info: UnivPtr ): UnivPtr;
	CFAllocatorReallocateCallBack = function( ptr: UnivPtr; newsize: CFIndex; hint: CFOptionFlags; info: UnivPtr ): UnivPtr;
	CFAllocatorDeallocateCallBack = procedure( ptr: UnivPtr; info: UnivPtr );
	CFAllocatorPreferredSizeCallBack = function( size: CFIndex; hint: CFOptionFlags; info: UnivPtr ): CFIndex;
	CFAllocatorContextPtr = ^CFAllocatorContext;
	CFAllocatorContext = record
		version: CFIndex;
		info: UnivPtr;
		retain: CFAllocatorRetainCallBack;
		release: CFAllocatorReleaseCallBack;        
		copyDescription: CFAllocatorCopyDescriptionCallBack;
		allocate: CFAllocatorAllocateCallBack;
		reallocate: CFAllocatorReallocateCallBack;
		deallocate: CFAllocatorDeallocateCallBack;
		preferredSize: CFAllocatorPreferredSizeCallBack;
	end;

function CFAllocatorGetTypeID: CFTypeID; external name '_CFAllocatorGetTypeID';

{
	CFAllocatorSetDefault() sets the allocator that is used in the current
	thread whenever NULL is specified as an allocator argument. This means
	that most, if not all allocations will go through this allocator. It
	also means that any allocator set as the default needs to be ready to
	deal with arbitrary memory allocation requests; in addition, the size
	and number of requests will change between releases.

	An allocator set as the default will never be released, even if later
	another allocator replaces it as the default. Not only is it impractical
	for it to be released (as there might be caches created under the covers
	that refer to the allocator), in general it's also safer and more
	efficient to keep it around.

	If you wish to use a custom allocator in a context, it's best to provide
	it as the argument to the various creation functions rather than setting
	it as the default. Setting the default allocator is not encouraged.

	If you do set an allocator as the default, either do it for all time in
	your app, or do it in a nested fashion (by restoring the previous allocator
	when you exit your context). The latter might be appropriate for plug-ins
	or libraries that wish to set the default allocator.
}
procedure CFAllocatorSetDefault( allocator: CFAllocatorRef ); external name '_CFAllocatorSetDefault';

function CFAllocatorGetDefault: CFAllocatorRef; external name '_CFAllocatorGetDefault';

function CFAllocatorCreate( allocator: CFAllocatorRef; var context: CFAllocatorContext ): CFAllocatorRef; external name '_CFAllocatorCreate';

function CFAllocatorAllocate( allocator: CFAllocatorRef; size: CFIndex; hint: CFOptionFlags ): UnivPtr; external name '_CFAllocatorAllocate';

function CFAllocatorReallocate( allocator: CFAllocatorRef; ptr: UnivPtr; newsize: CFIndex; hint: CFOptionFlags ): UnivPtr; external name '_CFAllocatorReallocate';

procedure CFAllocatorDeallocate( allocator: CFAllocatorRef; ptr: UnivPtr ); external name '_CFAllocatorDeallocate';

function CFAllocatorGetPreferredSizeForSize( allocator: CFAllocatorRef; size: CFIndex; hint: CFOptionFlags ): CFIndex; external name '_CFAllocatorGetPreferredSizeForSize';

procedure CFAllocatorGetContext( allocator: CFAllocatorRef; var context: CFAllocatorContext ); external name '_CFAllocatorGetContext';


{ Polymorphic CF functions }

function CFGetTypeID( cf: CFTypeRef ): CFTypeID; external name '_CFGetTypeID';

function CFCopyTypeIDDescription( type_id: CFTypeID ): CFStringRef; external name '_CFCopyTypeIDDescription';

function CFRetain( cf: CFTypeRef ): CFTypeRef; external name '_CFRetain';

procedure CFRelease( cf: CFTypeRef ); external name '_CFRelease';

function CFGetRetainCount( cf: CFTypeRef ): CFIndex; external name '_CFGetRetainCount';

function CFMakeCollectable( cf: CFTypeRef ): CFTypeRef; external name '_CFMakeCollectable';
(* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)

function CFEqual( cf1: CFTypeRef; cf2: CFTypeRef ): Boolean; external name '_CFEqual';

function CFHash( cf: CFTypeRef ): CFHashCode; external name '_CFHash';

function CFCopyDescription( cf: CFTypeRef ): CFStringRef; external name '_CFCopyDescription';

function CFGetAllocator( cf: CFTypeRef ): CFAllocatorRef; external name '_CFGetAllocator';


{unit CFBinaryHeap}
{	CFBinaryHeap.h
	Copyright (c) 1998-2005, Apple, Inc. All rights reserved.
}
{   Pascal Translation Updated:  Peter N Lewis, <peter@stairways.com.au>, September 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}

{!
        @header CFBinaryHeap
        CFBinaryHeap implements a container which stores values sorted using
        a binary search algorithm.  CFBinaryHeaps can be useful as priority
	queues.
}


type
	CFBinaryHeapCompareContext = record
		version: CFIndex;
		info: UnivPtr;
		retain: function( info: {const} UnivPtr ): UnivPtr;
		release: procedure( info: {const} UnivPtr );
		copyDescription: function( info: {const} UnivPtr ): CFStringRef;
	end;
	CFBinaryHeapCompareContextPtr = ^CFBinaryHeapCompareContext;

{!
        @typedef CFBinaryHeapCallBacks
	Structure containing the callbacks for values of a CFBinaryHeap.
        @field version The version number of the structure type being passed
                in as a parameter to the CFBinaryHeap creation functions.
                This structure is version 0.
	@field retain The callback used to add a retain for the binary heap
		on values as they are put into the binary heap.
		This callback returns the value to use as the value in the
		binary heap, which is usually the value parameter passed to
		this callback, but may be a different value if a different
		value should be added to the binary heap. The binary heap's
		allocator is passed as the first argument.
	@field release The callback used to remove a retain previously added
		for the binary heap from values as they are removed from
		the binary heap. The binary heap's allocator is passed as the
		first argument.
	@field copyDescription The callback used to create a descriptive
		string representation of each value in the binary heap. This
		is used by the CFCopyDescription() function.
	@field compare The callback used to compare values in the binary heap for
		equality in some operations.
}
type
	CFBinaryHeapCallBacks = record
	    version: CFIndex;
		retain: function( allocator: CFAllocatorRef; info: {const} UnivPtr ): UnivPtr;
		release: procedure( allocator: CFAllocatorRef; info: {const} UnivPtr );
		copyDescription: function( info: {const} UnivPtr ): CFStringRef;
		compare: function( info1, info2: {const} UnivPtr; context: UnivPtr ): CFComparisonResult;
	end;
	CFBinaryHeapCallBacksPtr = ^CFBinaryHeapCallBacks;

{!
	@constant kCFStringBinaryHeapCallBacks
	Predefined CFBinaryHeapCallBacks structure containing a set
	of callbacks appropriate for use when the values in a CFBinaryHeap
	are all CFString types.
}
var kCFStringBinaryHeapCallBacks: CFBinaryHeapCallBacks; external name '_kCFStringBinaryHeapCallBacks'; (* attribute const *)

{!
	@typedef CFBinaryHeapApplierFunction
	Type of the callback function used by the apply functions of
		CFBinaryHeap.
	@param value The current value from the binary heap.
	@param context The user-defined context parameter given to the apply
		function.
}
type
	CFBinaryHeapApplierFunction = procedure( val: {const} UnivPtr; context: UnivPtr );

{!
	@typedef CFBinaryHeapRef
	This is the type of a reference to CFBinaryHeaps.
}
type
	CFBinaryHeapRef = ^SInt32; { an opaque 32-bit type }

{!
	@function CFBinaryHeapGetTypeID
	Returns the type identifier of all CFBinaryHeap instances.
}
function CFBinaryHeapGetTypeID: CFTypeID; external name '_CFBinaryHeapGetTypeID';

{!
	@function CFBinaryHeapCreate
	Creates a new mutable or fixed-mutable binary heap with the given values.
	@param allocator The CFAllocator which should be used to allocate
		memory for the binary heap and its storage for values. This
		parameter may be NULL in which case the current default
		CFAllocator is used. If this reference is not a valid
		CFAllocator, the behavior is undefined.
	@param capacity The maximum number of values that can be contained
		by the CFBinaryHeap. The binary heap starts empty, and can grow to this
		number of values (and it can have less). If this parameter
		is 0, the binary heap's maximum capacity is unlimited (or rather,
		only limited by address space and available memory
		constraints). If this parameter is negative, the behavior is
		undefined.
	@param callBacks A pointer to a CFBinaryHeapCallBacks structure
		initialized with the callbacks for the binary heap to use on
		each value in the binary heap. A copy of the contents of the
		callbacks structure is made, so that a pointer to a structure
		on the stack can be passed in, or can be reused for multiple
		binary heap creations. If the version field of this callbacks
		structure is not one of the defined ones for CFBinaryHeap, the
		behavior is undefined. The retain field may be NULL, in which
		case the CFBinaryHeap will do nothing to add a retain to values
		as they are put into the binary heap. The release field may be
		NULL, in which case the CFBinaryHeap will do nothing to remove
		the binary heap's retain (if any) on the values when the
		heap is destroyed or a key-value pair is removed. If the
		copyDescription field is NULL, the binary heap will create a
		simple description for a value. If the equal field is NULL, the
		binary heap will use pointer equality to test for equality of
		values. This callbacks parameter itself may be NULL, which is
		treated as if a valid structure of version 0 with all fields
		NULL had been passed in. Otherwise,
		if any of the fields are not valid pointers to functions
		of the correct type, or this parameter is not a valid
		pointer to a CFBinaryHeapCallBacks callbacks structure,
		the behavior is undefined. If any of the values put into the
		binary heap is not one understood by one of the callback functions
		the behavior when that callback function is used is undefined.
        @param compareContext A pointer to a CFBinaryHeapCompareContext structure.
	@result A reference to the new CFBinaryHeap.
}
function CFBinaryHeapCreate( allocator: CFAllocatorRef; capacity: CFIndex; callBacks: CFBinaryHeapCallBacksPtr; const (*var*) compareContext: CFBinaryHeapCompareContext ): CFBinaryHeapRef; external name '_CFBinaryHeapCreate';

{!
	@function CFBinaryHeapCreateCopy
	Creates a new mutable or fixed-mutable binary heap with the values from the given binary heap.
	@param allocator The CFAllocator which should be used to allocate
		memory for the binary heap and its storage for values. This
		parameter may be NULL in which case the current default
		CFAllocator is used. If this reference is not a valid
		CFAllocator, the behavior is undefined.
	@param capacity The maximum number of values that can be contained
		by the CFBinaryHeap. The binary heap starts empty, and can grow to this
		number of values (and it can have less). If this parameter
		is 0, the binary heap's maximum capacity is unlimited (or rather,
		only limited by address space and available memory
		constraints). If this parameter is negative, or less than the number of
                values in the given binary heap, the behavior is undefined.
	@param heap The binary heap which is to be copied. The values from the
		binary heap are copied as pointers into the new binary heap (that is,
		the values themselves are copied, not that which the values
		point to, if anything). However, the values are also
		retained by the new binary heap. The count of the new binary will
		be the same as the given binary heap. The new binary heap uses the same
		callbacks as the binary heap to be copied. If this parameter is
		not a valid CFBinaryHeap, the behavior is undefined.
	@result A reference to the new mutable or fixed-mutable binary heap.
}
function CFBinaryHeapCreateCopy( allocator: CFAllocatorRef; capacity: CFIndex; heap: CFBinaryHeapRef ): CFBinaryHeapRef; external name '_CFBinaryHeapCreateCopy';

{!
	@function CFBinaryHeapGetCount
	Returns the number of values currently in the binary heap.
	@param heap The binary heap to be queried. If this parameter is not a valid
		CFBinaryHeap, the behavior is undefined.
	@result The number of values in the binary heap.
}
function CFBinaryHeapGetCount( heap: CFBinaryHeapRef ): CFIndex; external name '_CFBinaryHeapGetCount';

{!
	@function CFBinaryHeapGetCountOfValue
	Counts the number of times the given value occurs in the binary heap.
	@param heap The binary heap to be searched. If this parameter is not a
		valid CFBinaryHeap, the behavior is undefined.
	@param value The value for which to find matches in the binary heap. The
		compare() callback provided when the binary heap was created is
		used to compare. If the compare() callback was NULL, pointer
		equality (in C, ==) is used. If value, or any of the values
		in the binary heap, are not understood by the compare() callback,
		the behavior is undefined.
	@result The number of times the given value occurs in the binary heap.
}
function CFBinaryHeapGetCountOfValue( heap: CFBinaryHeapRef; value: {const} UnivPtr ): CFIndex; external name '_CFBinaryHeapGetCountOfValue';

{!
	@function CFBinaryHeapContainsValue
	Reports whether or not the value is in the binary heap.
	@param heap The binary heap to be searched. If this parameter is not a
		valid CFBinaryHeap, the behavior is undefined.
	@param value The value for which to find matches in the binary heap. The
		compare() callback provided when the binary heap was created is
		used to compare. If the compare() callback was NULL, pointer
		equality (in C, ==) is used. If value, or any of the values
		in the binary heap, are not understood by the compare() callback,
		the behavior is undefined.
	@result true, if the value is in the specified binary heap, otherwise false.
}
function CFBinaryHeapContainsValue( heap: CFBinaryHeapRef; value: {const} UnivPtr ): Boolean; external name '_CFBinaryHeapContainsValue';

{!
	@function CFBinaryHeapGetMinimum
	Returns the minimum value is in the binary heap.  If the heap contains several equal
                minimum values, any one may be returned.
	@param heap The binary heap to be searched. If this parameter is not a
		valid CFBinaryHeap, the behavior is undefined.
	@result A reference to the minimum value in the binary heap, or NULL if the
                binary heap contains no values.
}
function CFBinaryHeapGetMinimum( heap: CFBinaryHeapRef ): UnivPtr; external name '_CFBinaryHeapGetMinimum';

{!
	@function CFBinaryHeapGetMinimumIfPresent
	Returns the minimum value is in the binary heap, if present.  If the heap contains several equal
                minimum values, any one may be returned.
	@param heap The binary heap to be searched. If this parameter is not a
		valid CFBinaryHeap, the behavior is undefined.
        @param value A C pointer to pointer-sized storage to be filled with the minimum value in 
                the binary heap.  If this value is not a valid C pointer to a pointer-sized block
                of storage, the result is undefined.  If the result of the function is false, the value
                stored at this address is undefined.
	@result true, if a minimum value was found in the specified binary heap, otherwise false.
}
function CFBinaryHeapGetMinimumIfPresent( heap: CFBinaryHeapRef; {const} value: {variable-size-array} UnivPtrPtr ): Boolean; external name '_CFBinaryHeapGetMinimumIfPresent';

{!
	@function CFBinaryHeapGetValues
	Fills the buffer with values from the binary heap.
	@param heap The binary heap to be queried. If this parameter is not a
		valid CFBinaryHeap, the behavior is undefined.
	@param values A C array of pointer-sized values to be filled with
		values from the binary heap. The values in the C array are ordered
		from least to greatest. If this parameter is not a valid pointer to a 
                C array of at least CFBinaryHeapGetCount() pointers, the behavior is undefined.
}
type 
	CFBinaryHeapValues = array[0..($7F000000 div SizeOf(Ptr))] of Ptr;
	CFBinaryHeapValuesPtr = ^CFBinaryHeapValues;
procedure CFBinaryHeapGetValues( heap: CFBinaryHeapRef; {const} values: {variable-size-array} CFBinaryHeapValuesPtr ); external name '_CFBinaryHeapGetValues';

{!
	@function CFBinaryHeapApplyFunction
	Calls a function once for each value in the binary heap.
	@param heap The binary heap to be operated upon. If this parameter is not a
		valid CFBinaryHeap, the behavior is undefined.
	@param applier The callback function to call once for each value in
		the given binary heap. If this parameter is not a
		pointer to a function of the correct prototype, the behavior
		is undefined. If there are values in the binary heap which the
		applier function does not expect or cannot properly apply
		to, the behavior is undefined. 
	@param context A pointer-sized user-defined value, which is passed
		as the second parameter to the applier function, but is
		otherwise unused by this function. If the context is not
		what is expected by the applier function, the behavior is
		undefined.
}
procedure CFBinaryHeapApplyFunction( heap: CFBinaryHeapRef; applier: CFBinaryHeapApplierFunction; context: UnivPtr ); external name '_CFBinaryHeapApplyFunction';

{!
	@function CFBinaryHeapAddValue
	Adds the value to the binary heap.
	@param heap The binary heap to which the value is to be added. If this parameter is not a
		valid mutable CFBinaryHeap, the behavior is undefined.
                If the binary heap is a fixed-capacity binary heap and it
		is full before this operation, the behavior is undefined.
	@param value The value to add to the binary heap. The value is retained by
		the binary heap using the retain callback provided when the binary heap
		was created. If the value is not of the sort expected by the
		retain callback, the behavior is undefined.
}
procedure CFBinaryHeapAddValue( heap: CFBinaryHeapRef; value: {const} UnivPtr ); external name '_CFBinaryHeapAddValue';

{!
	@function CFBinaryHeapRemoveMinimumValue
	Removes the minimum value from the binary heap.
	@param heap The binary heap from which the minimum value is to be removed. If this 
                parameter is not a valid mutable CFBinaryHeap, the behavior is undefined.
}
procedure CFBinaryHeapRemoveMinimumValue( heap: CFBinaryHeapRef ); external name '_CFBinaryHeapRemoveMinimumValue';

{!
	@function CFBinaryHeapRemoveAllValues
	Removes all the values from the binary heap, making it empty.
	@param heap The binary heap from which all of the values are to be
		removed. If this parameter is not a valid mutable CFBinaryHeap,
		the behavior is undefined.
}
procedure CFBinaryHeapRemoveAllValues( heap: CFBinaryHeapRef ); external name '_CFBinaryHeapRemoveAllValues';


{unit CFBitVector}
{	CFBitVector.h
	Copyright (c) 1998-2005, Apple, Inc. All rights reserved.
}
{       Pascal Translation:  Peter N Lewis, <peter@stairways.com.au>, 2004 }
{       Pascal Translation Updated:  Peter N Lewis, <peter@stairways.com.au>, September 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}


type
	CFBit = UInt32;

type
	CFBitVectorRef = ^SInt32; { an opaque 32-bit type }
	CFMutableBitVectorRef = ^SInt32; { an opaque 32-bit type }

function CFBitVectorGetTypeID: CFTypeID; external name '_CFBitVectorGetTypeID';

function CFBitVectorCreate( allocator: CFAllocatorRef; bytes: UnivPtr; numBits: CFIndex ): CFBitVectorRef; external name '_CFBitVectorCreate';
function CFBitVectorCreateCopy( allocator: CFAllocatorRef; bv: CFBitVectorRef ): CFBitVectorRef; external name '_CFBitVectorCreateCopy';
function CFBitVectorCreateMutable( allocator: CFAllocatorRef; capacity: CFIndex ): CFMutableBitVectorRef; external name '_CFBitVectorCreateMutable';
function CFBitVectorCreateMutableCopy( allocator: CFAllocatorRef; capacity: CFIndex; bv: CFBitVectorRef ): CFMutableBitVectorRef; external name '_CFBitVectorCreateMutableCopy';

function CFBitVectorGetCount( bv: CFBitVectorRef ): CFIndex; external name '_CFBitVectorGetCount';
function CFBitVectorGetCountOfBit( bv: CFBitVectorRef; range: CFRange; value: CFBit ): CFIndex; external name '_CFBitVectorGetCountOfBit';
function CFBitVectorContainsBit( bv: CFBitVectorRef; range: CFRange; value: CFBit ): Boolean; external name '_CFBitVectorContainsBit';
function CFBitVectorGetBitAtIndex( bv: CFBitVectorRef; idx: CFIndex ): CFBit; external name '_CFBitVectorGetBitAtIndex';
procedure CFBitVectorGetBits( bv: CFBitVectorRef; range: CFRange; bytes: UnivPtr ); external name '_CFBitVectorGetBits';
function CFBitVectorGetFirstIndexOfBit( bv: CFBitVectorRef; range: CFRange; value: CFBit ): CFIndex; external name '_CFBitVectorGetFirstIndexOfBit';
function CFBitVectorGetLastIndexOfBit( bv: CFBitVectorRef; range: CFRange; value: CFBit ): CFIndex; external name '_CFBitVectorGetLastIndexOfBit';

procedure CFBitVectorSetCount( bv: CFMutableBitVectorRef; count: CFIndex ); external name '_CFBitVectorSetCount';
procedure CFBitVectorFlipBitAtIndex( bv: CFMutableBitVectorRef; idx: CFIndex ); external name '_CFBitVectorFlipBitAtIndex';
procedure CFBitVectorFlipBits( bv: CFMutableBitVectorRef; range: CFRange ); external name '_CFBitVectorFlipBits';
procedure CFBitVectorSetBitAtIndex( bv: CFMutableBitVectorRef; idx: CFIndex; value: CFBit ); external name '_CFBitVectorSetBitAtIndex';
procedure CFBitVectorSetBits( bv: CFMutableBitVectorRef; range: CFRange; value: CFBit ); external name '_CFBitVectorSetBits';
procedure CFBitVectorSetAllBits( bv: CFMutableBitVectorRef; value: CFBit ); external name '_CFBitVectorSetAllBits';


{unit CFByteOrders}
{	CFByteOrder.h
	Copyright (c) 1995-2005, Apple, Inc. All rights reserved.
}
{   Pascal Translation:  Peter N Lewis, <peter@stairways.com.au>, August 2005 }
{   Pascal Translation Updated:  Peter N Lewis, <peter@stairways.com.au>, September 2005 }
{   Pascal Translation Updated:  Jonas Maebe, <jonas@freepascal.org>, April 2006 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}


type
	CFByteOrder = SInt32;
const
	CFByteOrderUnknown = 0;
	CFByteOrderLittleEndian = 1;
	CFByteOrderBigEndian = 2;

function CFByteOrderGetCurrent: CFByteOrder; inline;
function CFSwapInt16( arg: UInt16 ): UInt16; inline;
function CFSwapInt32( arg: UInt32 ): UInt32; inline;
function CFSwapInt64( arg: UInt64 ): UInt64; inline;

function CFSwapInt16BigToHost( arg: UInt16 ): UInt16; inline;
function CFSwapInt32BigToHost( arg: UInt32 ): UInt32; inline;
function CFSwapInt64BigToHost( arg: UInt64 ): UInt64; inline;
function CFSwapInt16HostToBig( arg: UInt16 ): UInt16; inline;
function CFSwapInt32HostToBig( arg: UInt32 ): UInt32; inline;
function CFSwapInt64HostToBig( arg: UInt64 ): UInt64; inline;

{$ifc TARGET_RT_BIG_ENDIAN}


{$elsec}



{$endc}

function CFSwapInt16LittleToHost( arg: UInt16 ): UInt16; inline;
function CFSwapInt32LittleToHost( arg: UInt32 ): UInt32; inline;
function CFSwapInt64LittleToHost( arg: UInt64 ): UInt64; inline;
function CFSwapInt16HostToLittle( arg: UInt16 ): UInt16; inline;
function CFSwapInt32HostToLittle( arg: UInt32 ): UInt32; inline;
function CFSwapInt64HostToLittle( arg: UInt64 ): UInt64; inline;

{$ifc TARGET_RT_LITTLE_ENDIAN}


{$elsec}



{$endc}

type
	CFSwappedFloat32 = record
		v: UInt32;
	end;
type
	CFSwappedFloat64 = record
		v: UInt64;
	end;

function CFConvertFloat32HostToSwapped( arg: Float32 ): CFSwappedFloat32; inline;
function CFConvertFloat32SwappedToHost( arg: Float32 ): CFSwappedFloat32; inline;
function CFConvertFloat64HostToSwapped( arg: Float64 ): CFSwappedFloat64; inline;
function CFConvertFloat64SwappedToHost( arg: Float64 ): CFSwappedFloat64; inline;
function CFConvertFloatHostToSwapped( arg: Float32 ): CFSwappedFloat32; inline;
function CFConvertFloatSwappedToHost( arg: Float32 ): CFSwappedFloat32; inline;
function CFConvertDoubleHostToSwapped( arg: Float64 ): CFSwappedFloat64; inline;
function CFConvertDoubleSwappedToHost( arg: Float64 ): CFSwappedFloat64; inline;

{$ifc TARGET_RT_LITTLE_ENDIAN}



{$elsec}


{$endc}


{unit CFData}
{	CFData.h
	Copyright (c) 1998-2005, Apple, Inc. All rights reserved.
}
{   Pascal Translation Updated:  Peter N Lewis, <peter@stairways.com.au>, September 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}


    
type
	CFDataRef = ^SInt32; { an opaque 32-bit type }
	CFDataRefPtr = ^CFDataRef;
	CFMutableDataRef = CFDataRef;
	CFMutableDataRefPtr = ^CFMutableDataRef;

function CFDataGetTypeID: CFTypeID; external name '_CFDataGetTypeID';

function CFDataCreate( allocator: CFAllocatorRef; bytes: UnivPtr; length: CFIndex ): CFDataRef; external name '_CFDataCreate';

function CFDataCreateWithBytesNoCopy( allocator: CFAllocatorRef; bytes: UnivPtr; length: CFIndex; bytesDeallocator: CFAllocatorRef ): CFDataRef; external name '_CFDataCreateWithBytesNoCopy';
    { Pass kCFAllocatorNull as bytesDeallocator to assure the bytes aren't freed }

function CFDataCreateCopy( allocator: CFAllocatorRef; theData: CFDataRef ): CFDataRef; external name '_CFDataCreateCopy';

function CFDataCreateMutable( allocator: CFAllocatorRef; capacity: CFIndex ): CFMutableDataRef; external name '_CFDataCreateMutable';

function CFDataCreateMutableCopy( allocator: CFAllocatorRef; capacity: CFIndex; theData: CFDataRef ): CFMutableDataRef; external name '_CFDataCreateMutableCopy';

function CFDataGetLength( theData: CFDataRef ): CFIndex; external name '_CFDataGetLength';

function CFDataGetBytePtr( theData: CFDataRef ): UnivPtr; external name '_CFDataGetBytePtr';

function CFDataGetMutableBytePtr( theData: CFMutableDataRef ): UnivPtr; external name '_CFDataGetMutableBytePtr';

procedure CFDataGetBytes( theData: CFDataRef; range: CFRange; buffer: UnivPtr ); external name '_CFDataGetBytes';

procedure CFDataSetLength( theData: CFMutableDataRef; length: CFIndex ); external name '_CFDataSetLength';

procedure CFDataIncreaseLength( theData: CFMutableDataRef; extraLength: CFIndex ); external name '_CFDataIncreaseLength';

procedure CFDataAppendBytes( theData: CFMutableDataRef; bytes: UnivPtr; length: CFIndex ); external name '_CFDataAppendBytes';

procedure CFDataReplaceBytes( theData: CFMutableDataRef; range: CFRange; newBytes: UnivPtr; newLength: CFIndex ); external name '_CFDataReplaceBytes';

procedure CFDataDeleteBytes( theData: CFMutableDataRef; range: CFRange ); external name '_CFDataDeleteBytes';


{unit CFDate}
{	CFDate.h
	Copyright (c) 1998-2005, Apple, Inc. All rights reserved.
}
{   Pascal Translation Updated:  Peter N Lewis, <peter@stairways.com.au>, September 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}


type
	CFTimeInterval = Float64;
	CFAbsoluteTime = CFTimeInterval;
	CFAbsoluteTimePtr = ^CFAbsoluteTime;
{ absolute time is the time interval since the reference date }
{ the reference date (epoch) is 00:00:00 1 January 2001. }

function CFAbsoluteTimeGetCurrent: CFAbsoluteTime; external name '_CFAbsoluteTimeGetCurrent';

var kCFAbsoluteTimeIntervalSince1970: CFTimeInterval; external name '_kCFAbsoluteTimeIntervalSince1970'; (* attribute const *)
var kCFAbsoluteTimeIntervalSince1904: CFTimeInterval; external name '_kCFAbsoluteTimeIntervalSince1904'; (* attribute const *)

type
	CFDateRef = ^SInt32; { an opaque 32-bit type }
	CFDateRefPtr = ^CFDateRef;

function CFDateGetTypeID: CFTypeID; external name '_CFDateGetTypeID';

function CFDateCreate( allocator: CFAllocatorRef; at: CFAbsoluteTime ): CFDateRef; external name '_CFDateCreate';

function CFDateGetAbsoluteTime( theDate: CFDateRef ): CFAbsoluteTime; external name '_CFDateGetAbsoluteTime';

function CFDateGetTimeIntervalSinceDate( theDate: CFDateRef; otherDate: CFDateRef ): CFTimeInterval; external name '_CFDateGetTimeIntervalSinceDate';

function CFDateCompare( theDate: CFDateRef; otherDate: CFDateRef; context: UnivPtr ): CFComparisonResult; external name '_CFDateCompare';

type
	CFTimeZoneRef = ^SInt32; { an opaque 32-bit type }
	CFTimeZoneRefPtr = ^CFTimeZoneRef;

type
	CFGregorianDate = record
		year: SInt32;
		month: SInt8;
		day: SInt8;
		hour: SInt8;
		minute: SInt8;
		second: Float64;
	end;
	CFGregorianDatePtr = ^CFGregorianDate;

type
	CFGregorianUnits = record
		years: SInt32;
		months: SInt32;
		days: SInt32;
		hours: SInt32;
		minutes: SInt32;
		seconds: Float64;
	end;
	CFGregorianUnitsPtr = ^CFGregorianUnits;

type
	CFGregorianUnitFlags = SInt32;
const
	kCFGregorianUnitsYears = 1 shl 0;
	kCFGregorianUnitsMonths = 1 shl 1;
	kCFGregorianUnitsDays = 1 shl 2;
	kCFGregorianUnitsHours = 1 shl 3;
	kCFGregorianUnitsMinutes = 1 shl 4;
	kCFGregorianUnitsSeconds = 1 shl 5;
	kCFGregorianAllUnits = $00FFFFFF;

function CFGregorianDateIsValid( gdate: CFGregorianDate; unitFlags: CFOptionFlags ): Boolean; external name '_CFGregorianDateIsValid';

function CFGregorianDateGetAbsoluteTime( gdate: CFGregorianDate; tz: CFTimeZoneRef ): CFAbsoluteTime; external name '_CFGregorianDateGetAbsoluteTime';

function CFAbsoluteTimeGetGregorianDate( at: CFAbsoluteTime; tz: CFTimeZoneRef ): CFGregorianDate; external name '_CFAbsoluteTimeGetGregorianDate';

function CFAbsoluteTimeAddGregorianUnits( at: CFAbsoluteTime; tz: CFTimeZoneRef; units: CFGregorianUnits ): CFAbsoluteTime; external name '_CFAbsoluteTimeAddGregorianUnits';

function CFAbsoluteTimeGetDifferenceAsGregorianUnits( at1: CFAbsoluteTime; at2: CFAbsoluteTime; tz: CFTimeZoneRef; unitFlags: CFOptionFlags ): CFGregorianUnits; external name '_CFAbsoluteTimeGetDifferenceAsGregorianUnits';

function CFAbsoluteTimeGetDayOfWeek( at: CFAbsoluteTime; tz: CFTimeZoneRef ): SInt32; external name '_CFAbsoluteTimeGetDayOfWeek';

function CFAbsoluteTimeGetDayOfYear( at: CFAbsoluteTime; tz: CFTimeZoneRef ): SInt32; external name '_CFAbsoluteTimeGetDayOfYear';

function CFAbsoluteTimeGetWeekOfYear( at: CFAbsoluteTime; tz: CFTimeZoneRef ): SInt32; external name '_CFAbsoluteTimeGetWeekOfYear';


{unit CFDictionary}
{	CFDictionary.h
	Copyright (c) 1998-2005, Apple, Inc. All rights reserved.
}
{   Pascal Translation Updated:  Peter N Lewis, <peter@stairways.com.au>, September 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}


{!
	@header CFDictionary
	CFDictionary implements a container which pairs pointer-sized keys
	with pointer-sized values. Values are accessed via arbitrary
	user-defined keys. A CFDictionary differs from a CFArray in that
	the key used to access a particular value in the dictionary remains
	the same as values are added to or removed from the dictionary,
	unless a value associated with its particular key is replaced or
	removed. In a CFArray, the key (or index) used to retrieve a
	particular value can change over time as values are added to or
	deleted from the array. Also unlike an array, there is no ordering
	among values in a dictionary. To enable later retrieval of a value,
	the key of the key-value pair should be constant (or treated as
	constant); if the key changes after being used to put a value in
	the dictionary, the value may not be retrievable. The keys of a
	dictionary form a set; that is, no two keys which are equal to
	one another are present in the dictionary at any time.

	Dictionaries come in two flavors, immutable, which cannot have
	values added to them or removed from them after the dictionary is
	created, and mutable, to which you can add values or from which
	remove values. Mutable dictionaries have two subflavors,
	fixed-capacity, for which there is a maximum number set at creation
	time of values which can be put into the dictionary, and variable
	capacity, which can have an unlimited number of values (or rather,
	limited only by constraints external to CFDictionary, like the
	amount of available memory). Fixed-capacity dictionaries can be
	somewhat higher performing, if you can put a definate upper limit
	on the number of values that might be put into the dictionary.

	As with all CoreFoundation collection types, dictionaries maintain
	hard references on the values you put in them, but the retaining and
	releasing functions are user-defined callbacks that can actually do
	whatever the user wants (for example, nothing).

	Although a particular implementation of CFDictionary may not use
	hashing and a hash table for storage of the values, the keys have
	a hash-code generating function defined for them, and a function
	to test for equality of two keys. These two functions together
	must maintain the invariant that if equal(X, Y), then hash(X) ==
	hash(Y). Note that the converse will not generally be true (but
	the contrapositive, if hash(X) != hash(Y), then !equal(X, Y),
	will be as required by Boolean logic). If the hash() and equal()
	key callbacks are NULL, the key is used as a pointer-sized integer,
	and pointer equality is used. Care should be taken to provide a
	hash() callback which will compute sufficiently dispersed hash
	codes for the key set for best performance.

	Computational Complexity
	The access time for a value in the dictionary is guaranteed to be at
	worst O(lg N) for any implementation, current and future, but will
	often be O(1) (constant time). Insertion or deletion operations
	will typically be constant time as well, but are O(N*lg N) in the
	worst case in some implementations. Access of values through a key
	is faster than accessing values directly (if there are any such
	operations). Dictionaries will tend to use significantly more memory
	than a array with the same number of values.
}


{!
	@typedef CFDictionaryKeyCallBacks
	Structure containing the callbacks for keys of a CFDictionary.
	@field version The version number of the structure type being passed
		in as a parameter to the CFDictionary creation functions.
		This structure is version 0.
	@field retain The callback used to add a retain for the dictionary
		on keys as they are used to put values into the dictionary.
		This callback returns the value to use as the key in the
		dictionary, which is usually the value parameter passed to
		this callback, but may be a different value if a different
		value should be used as the key. The dictionary's allocator
		is passed as the first argument.
	@field release The callback used to remove a retain previously added
		for the dictionary from keys as their values are removed from
		the dictionary. The dictionary's allocator is passed as the
		first argument.
	@field copyDescription The callback used to create a descriptive
		string representation of each key in the dictionary. This
		is used by the CFCopyDescription() function.
	@field equal The callback used to compare keys in the dictionary for
		equality.
	@field hash The callback used to compute a hash code for keys as they
		are used to access, add, or remove values in the dictionary.
}
type
	CFDictionaryRetainCallBack = function( allocator: CFAllocatorRef; value: {const} UnivPtr ): UnivPtr;
	CFDictionaryReleaseCallBack = procedure( allocator: CFAllocatorRef; value: {const} UnivPtr );
	CFDictionaryCopyDescriptionCallBack = function( value: {const} UnivPtr ): CFStringRef;
	CFDictionaryEqualCallBack = function( value1: {const} UnivPtr; value2: {const} UnivPtr ): Boolean;
	CFDictionaryHashCallBack = function( value: {const} UnivPtr ): CFHashCode;
	CFDictionaryKeyCallBacks = record
		version: CFIndex;
		retain: CFDictionaryRetainCallBack;
		release: CFDictionaryReleaseCallBack;
		copyDescription: CFDictionaryCopyDescriptionCallBack;
		equal: CFDictionaryEqualCallBack;
		hash: CFDictionaryHashCallBack;
	end;
	CFDictionaryKeyCallBacksPtr = ^CFDictionaryKeyCallBacks;

{!
	@constant kCFTypeDictionaryKeyCallBacks
	Predefined CFDictionaryKeyCallBacks structure containing a
	set of callbacks appropriate for use when the keys of a
	CFDictionary are all CFTypes.
}
var kCFTypeDictionaryKeyCallBacks: CFDictionaryKeyCallBacks; external name '_kCFTypeDictionaryKeyCallBacks'; (* attribute const *)

{!
	@constant kCFCopyStringDictionaryKeyCallBacks
	Predefined CFDictionaryKeyCallBacks structure containing a
	set of callbacks appropriate for use when the keys of a
	CFDictionary are all CFStrings, which may be mutable and
	need to be copied in order to serve as constant keys for
	the values in the dictionary.
}
var kCFCopyStringDictionaryKeyCallBacks: CFDictionaryKeyCallBacks; external name '_kCFCopyStringDictionaryKeyCallBacks'; (* attribute const *)

{!
	@typedef CFDictionaryValueCallBacks
	Structure containing the callbacks for values of a CFDictionary.
	@field version The version number of the structure type being passed
		in as a parameter to the CFDictionary creation functions.
		This structure is version 0.
	@field retain The callback used to add a retain for the dictionary
		on values as they are put into the dictionary.
		This callback returns the value to use as the value in the
		dictionary, which is usually the value parameter passed to
		this callback, but may be a different value if a different
		value should be added to the dictionary. The dictionary's
		allocator is passed as the first argument.
	@field release The callback used to remove a retain previously added
		for the dictionary from values as they are removed from
		the dictionary. The dictionary's allocator is passed as the
		first argument.
	@field copyDescription The callback used to create a descriptive
		string representation of each value in the dictionary. This
		is used by the CFCopyDescription() function.
	@field equal The callback used to compare values in the dictionary for
		equality in some operations.
}
type
	CFDictionaryValueCallBacks = record
		version: CFIndex;
		retain: CFDictionaryRetainCallBack;
		release: CFDictionaryReleaseCallBack;
		copyDescription: CFDictionaryCopyDescriptionCallBack;
		equal: CFDictionaryEqualCallBack;
	end;
	CFDictionaryValueCallBacksPtr = ^CFDictionaryValueCallBacks;

{!
	@constant kCFTypeDictionaryValueCallBacks
	Predefined CFDictionaryValueCallBacks structure containing a set
	of callbacks appropriate for use when the values in a CFDictionary
	are all CFTypes.
}
var kCFTypeDictionaryValueCallBacks: CFDictionaryValueCallBacks; external name '_kCFTypeDictionaryValueCallBacks'; (* attribute const *)

{!
	@typedef CFDictionaryApplierFunction
	Type of the callback function used by the apply functions of
		CFDictionarys.
	@param key The current key for the value.
	@param value The current value from the dictionary.
	@param context The user-defined context parameter given to the apply
		function.
}
type
	CFDictionaryApplierFunction = procedure( key: {const} UnivPtr; value: {const} UnivPtr; context: UnivPtr );

{!
	@typedef CFDictionaryRef
	This is the type of a reference to immutable CFDictionarys.
}
type
	CFDictionaryRef = ^SInt32; { an opaque 32-bit type }
	CFDictionaryRefPtr = ^CFDictionaryRef;

{!
	@typedef CFMutableDictionaryRef
	This is the type of a reference to mutable CFDictionarys.
}
type
	CFMutableDictionaryRef = CFDictionaryRef;
	CFMutableDictionaryRefPtr = ^CFMutableDictionaryRef;

{!
	@function CFDictionaryGetTypeID
	Returns the type identifier of all CFDictionary instances.
}
function CFDictionaryGetTypeID: CFTypeID; external name '_CFDictionaryGetTypeID';

{!
	@function CFDictionaryCreate
	Creates a new immutable dictionary with the given values.
	@param allocator The CFAllocator which should be used to allocate
		memory for the dictionary and its storage for values. This
		parameter may be NULL in which case the current default
		CFAllocator is used. If this reference is not a valid
		CFAllocator, the behavior is undefined.
	@param keys A C array of the pointer-sized keys to be used for
		the parallel C array of values to be put into the dictionary.
		This parameter may be NULL if the numValues parameter is 0.
		This C array is not changed or freed by this function. If
		this parameter is not a valid pointer to a C array of at
		least numValues pointers, the behavior is undefined.
	@param values A C array of the pointer-sized values to be in the
		dictionary. This parameter may be NULL if the numValues
		parameter is 0. This C array is not changed or freed by
		this function. If this parameter is not a valid pointer to
		a C array of at least numValues pointers, the behavior is
		undefined.
	@param numValues The number of values to copy from the keys and
		values C arrays into the CFDictionary. This number will be
		the count of the dictionary. If this parameter is
		negative, or greater than the number of values actually
		in the keys or values C arrays, the behavior is undefined.
	@param keyCallBacks A pointer to a CFDictionaryKeyCallBacks structure
		initialized with the callbacks for the dictionary to use on
		each key in the dictionary. The retain callback will be used
		within this function, for example, to retain all of the new
		keys from the keys C array. A copy of the contents of the
		callbacks structure is made, so that a pointer to a structure
		on the stack can be passed in, or can be reused for multiple
		dictionary creations. If the version field of this
		callbacks structure is not one of the defined ones for
		CFDictionary, the behavior is undefined. The retain field may
		be NULL, in which case the CFDictionary will do nothing to add
		a retain to the keys of the contained values. The release field
		may be NULL, in which case the CFDictionary will do nothing
		to remove the dictionary's retain (if any) on the keys when the
		dictionary is destroyed or a key-value pair is removed. If the
		copyDescription field is NULL, the dictionary will create a
		simple description for a key. If the equal field is NULL, the
		dictionary will use pointer equality to test for equality of
		keys. If the hash field is NULL, a key will be converted from
		a pointer to an integer to compute the hash code. This callbacks
		parameter itself may be NULL, which is treated as if a valid
		structure of version 0 with all fields NULL had been passed in.
		Otherwise, if any of the fields are not valid pointers to
		functions of the correct type, or this parameter is not a
		valid pointer to a CFDictionaryKeyCallBacks callbacks structure,
		the behavior is undefined. If any of the keys put into the
		dictionary is not one understood by one of the callback functions
		the behavior when that callback function is used is undefined.
	@param valueCallBacks A pointer to a CFDictionaryValueCallBacks structure
		initialized with the callbacks for the dictionary to use on
		each value in the dictionary. The retain callback will be used
		within this function, for example, to retain all of the new
		values from the values C array. A copy of the contents of the
		callbacks structure is made, so that a pointer to a structure
		on the stack can be passed in, or can be reused for multiple
		dictionary creations. If the version field of this callbacks
		structure is not one of the defined ones for CFDictionary, the
		behavior is undefined. The retain field may be NULL, in which
		case the CFDictionary will do nothing to add a retain to values
		as they are put into the dictionary. The release field may be
		NULL, in which case the CFDictionary will do nothing to remove
		the dictionary's retain (if any) on the values when the
		dictionary is destroyed or a key-value pair is removed. If the
		copyDescription field is NULL, the dictionary will create a
		simple description for a value. If the equal field is NULL, the
		dictionary will use pointer equality to test for equality of
		values. This callbacks parameter itself may be NULL, which is
		treated as if a valid structure of version 0 with all fields
		NULL had been passed in. Otherwise,
		if any of the fields are not valid pointers to functions
		of the correct type, or this parameter is not a valid
		pointer to a CFDictionaryValueCallBacks callbacks structure,
		the behavior is undefined. If any of the values put into the
		dictionary is not one understood by one of the callback functions
		the behavior when that callback function is used is undefined.
	@result A reference to the new immutable CFDictionary.
}
function CFDictionaryCreate( allocator: CFAllocatorRef; {const} keys: UnivPtrPtr; {const} values: UnivPtrPtr; numValues: CFIndex; {const} keyCallBacks: CFDictionaryKeyCallBacksPtr { can be NULL }; {const} valueCallBacks: CFDictionaryValueCallBacksPtr { can be NULL } ): CFDictionaryRef; external name '_CFDictionaryCreate';

{!
	@function CFDictionaryCreateCopy
	Creates a new immutable dictionary with the key-value pairs from
		the given dictionary.
	@param allocator The CFAllocator which should be used to allocate
		memory for the dictionary and its storage for values. This
		parameter may be NULL in which case the current default
		CFAllocator is used. If this reference is not a valid
		CFAllocator, the behavior is undefined.
	@param theDict The dictionary which is to be copied. The keys and values
		from the dictionary are copied as pointers into the new
		dictionary (that is, the values themselves are copied, not
		that which the values point to, if anything). However, the
		keys and values are also retained by the new dictionary using
		the retain function of the original dictionary.
		The count of the new dictionary will be the same as the
		given dictionary. The new dictionary uses the same callbacks
		as the dictionary to be copied. If this parameter is
		not a valid CFDictionary, the behavior is undefined.
	@result A reference to the new immutable CFDictionary.
}
function CFDictionaryCreateCopy( allocator: CFAllocatorRef; theDict: CFDictionaryRef ): CFDictionaryRef; external name '_CFDictionaryCreateCopy';

{!
	@function CFDictionaryCreateMutable
	Creates a new mutable dictionary.
	@param allocator The CFAllocator which should be used to allocate
		memory for the dictionary and its storage for values. This
		parameter may be NULL in which case the current default
		CFAllocator is used. If this reference is not a valid
		CFAllocator, the behavior is undefined.
	@param capacity The maximum number of values that can be contained by
		the CFDictionary. The dictionary starts empty, and can grow
		to this number of values (and it can have less). If this
		parameter is 0, the dictionary's maximum capacity is unlimited
		(or rather, only limited by address space and available memory
		constraints). If this parameter is negative, the behavior is
		undefined.
	@param keyCallBacks A pointer to a CFDictionaryKeyCallBacks structure
		initialized with the callbacks for the dictionary to use on
		each key in the dictionary. A copy of the contents of the
		callbacks structure is made, so that a pointer to a structure
		on the stack can be passed in, or can be reused for multiple
		dictionary creations. If the version field of this
		callbacks structure is not one of the defined ones for
		CFDictionary, the behavior is undefined. The retain field may
		be NULL, in which case the CFDictionary will do nothing to add
		a retain to the keys of the contained values. The release field
		may be NULL, in which case the CFDictionary will do nothing
		to remove the dictionary's retain (if any) on the keys when the
		dictionary is destroyed or a key-value pair is removed. If the
		copyDescription field is NULL, the dictionary will create a
		simple description for a key. If the equal field is NULL, the
		dictionary will use pointer equality to test for equality of
		keys. If the hash field is NULL, a key will be converted from
		a pointer to an integer to compute the hash code. This callbacks
		parameter itself may be NULL, which is treated as if a valid
		structure of version 0 with all fields NULL had been passed in.
		Otherwise, if any of the fields are not valid pointers to
		functions of the correct type, or this parameter is not a
		valid pointer to a CFDictionaryKeyCallBacks callbacks structure,
		the behavior is undefined. If any of the keys put into the
		dictionary is not one understood by one of the callback functions
		the behavior when that callback function is used is undefined.
	@param valueCallBacks A pointer to a CFDictionaryValueCallBacks structure
		initialized with the callbacks for the dictionary to use on
		each value in the dictionary. The retain callback will be used
		within this function, for example, to retain all of the new
		values from the values C array. A copy of the contents of the
		callbacks structure is made, so that a pointer to a structure
		on the stack can be passed in, or can be reused for multiple
		dictionary creations. If the version field of this callbacks
		structure is not one of the defined ones for CFDictionary, the
		behavior is undefined. The retain field may be NULL, in which
		case the CFDictionary will do nothing to add a retain to values
		as they are put into the dictionary. The release field may be
		NULL, in which case the CFDictionary will do nothing to remove
		the dictionary's retain (if any) on the values when the
		dictionary is destroyed or a key-value pair is removed. If the
		copyDescription field is NULL, the dictionary will create a
		simple description for a value. If the equal field is NULL, the
		dictionary will use pointer equality to test for equality of
		values. This callbacks parameter itself may be NULL, which is
		treated as if a valid structure of version 0 with all fields
		NULL had been passed in. Otherwise,
		if any of the fields are not valid pointers to functions
		of the correct type, or this parameter is not a valid
		pointer to a CFDictionaryValueCallBacks callbacks structure,
		the behavior is undefined. If any of the values put into the
		dictionary is not one understood by one of the callback functions
		the behavior when that callback function is used is undefined.
	@result A reference to the new mutable CFDictionary.
}
function CFDictionaryCreateMutable( allocator: CFAllocatorRef; capacity: CFIndex; {const} keyCallBacks: CFDictionaryKeyCallBacksPtr { can be NULL }; {const} valueCallBacks: CFDictionaryValueCallBacksPtr { can be NULL } ): CFMutableDictionaryRef; external name '_CFDictionaryCreateMutable';

{!
	@function CFDictionaryCreateMutableCopy
	Creates a new mutable dictionary with the key-value pairs from
		the given dictionary.
	@param allocator The CFAllocator which should be used to allocate
		memory for the dictionary and its storage for values. This
		parameter may be NULL in which case the current default
		CFAllocator is used. If this reference is not a valid
		CFAllocator, the behavior is undefined.
	@param capacity The maximum number of values that can be contained
		by the CFDictionary. The dictionary starts empty, and can grow
		to this number of values (and it can have less). If this
		parameter is 0, the dictionary's maximum capacity is unlimited
		(or rather, only limited by address space and available memory
		constraints). This parameter must be greater than or equal
		to the count of the dictionary which is to be copied, or the
		behavior is undefined. If this parameter is negative, the
		behavior is undefined.
	@param theDict The dictionary which is to be copied. The keys and values
		from the dictionary are copied as pointers into the new
		dictionary (that is, the values themselves are copied, not
		that which the values point to, if anything). However, the
		keys and values are also retained by the new dictionary using
		the retain function of the original dictionary.
		The count of the new dictionary will be the same as the
		given dictionary. The new dictionary uses the same callbacks
		as the dictionary to be copied. If this parameter is
		not a valid CFDictionary, the behavior is undefined.
	@result A reference to the new mutable CFDictionary.
}
function CFDictionaryCreateMutableCopy( allocator: CFAllocatorRef; capacity: CFIndex; theDict: CFDictionaryRef ): CFMutableDictionaryRef; external name '_CFDictionaryCreateMutableCopy';

{!
	@function CFDictionaryGetCount
	Returns the number of values currently in the dictionary.
	@param theDict The dictionary to be queried. If this parameter is
		not a valid CFDictionary, the behavior is undefined.
	@result The number of values in the dictionary.
}
function CFDictionaryGetCount( theDict: CFDictionaryRef ): CFIndex; external name '_CFDictionaryGetCount';

{!
	@function CFDictionaryGetCountOfKey
	Counts the number of times the given key occurs in the dictionary.
	@param theDict The dictionary to be searched. If this parameter is
		not a valid CFDictionary, the behavior is undefined.
	@param key The key for which to find matches in the dictionary. The
		hash() and equal() key callbacks provided when the dictionary
		was created are used to compare. If the hash() key callback
		was NULL, the key is treated as a pointer and converted to
		an integer. If the equal() key callback was NULL, pointer
		equality (in C, ==) is used. If key, or any of the keys in
		the dictionary, are not understood by the equal() callback,
		the behavior is undefined.
	@result Returns 1 if a matching key is used by the dictionary,
		0 otherwise.
}
function CFDictionaryGetCountOfKey( theDict: CFDictionaryRef; key: {const} UnivPtr ): CFIndex; external name '_CFDictionaryGetCountOfKey';

{!
	@function CFDictionaryGetCountOfValue
	Counts the number of times the given value occurs in the dictionary.
	@param theDict The dictionary to be searched. If this parameter is
		not a valid CFDictionary, the behavior is undefined.
	@param value The value for which to find matches in the dictionary. The
		equal() callback provided when the dictionary was created is
		used to compare. If the equal() value callback was NULL, pointer
		equality (in C, ==) is used. If value, or any of the values in
		the dictionary, are not understood by the equal() callback,
		the behavior is undefined.
	@result The number of times the given value occurs in the dictionary.
}
function CFDictionaryGetCountOfValue( theDict: CFDictionaryRef; value: {const} UnivPtr ): CFIndex; external name '_CFDictionaryGetCountOfValue';

{!
	@function CFDictionaryContainsKey
	Reports whether or not the key is in the dictionary.
	@param theDict The dictionary to be searched. If this parameter is
		not a valid CFDictionary, the behavior is undefined.
	@param key The key for which to find matches in the dictionary. The
		hash() and equal() key callbacks provided when the dictionary
		was created are used to compare. If the hash() key callback
		was NULL, the key is treated as a pointer and converted to
		an integer. If the equal() key callback was NULL, pointer
		equality (in C, ==) is used. If key, or any of the keys in
		the dictionary, are not understood by the equal() callback,
		the behavior is undefined.
	@result true, if the key is in the dictionary, otherwise false.
}
function CFDictionaryContainsKey( theDict: CFDictionaryRef; key: {const} UnivPtr ): Boolean; external name '_CFDictionaryContainsKey';

{!
	@function CFDictionaryContainsValue
	Reports whether or not the value is in the dictionary.
	@param theDict The dictionary to be searched. If this parameter is
		not a valid CFDictionary, the behavior is undefined.
	@param value The value for which to find matches in the dictionary. The
		equal() callback provided when the dictionary was created is
		used to compare. If the equal() callback was NULL, pointer
		equality (in C, ==) is used. If value, or any of the values
		in the dictionary, are not understood by the equal() callback,
		the behavior is undefined.
	@result true, if the value is in the dictionary, otherwise false.
}
function CFDictionaryContainsValue( theDict: CFDictionaryRef; value: {const} UnivPtr ): Boolean; external name '_CFDictionaryContainsValue';

{!
	@function CFDictionaryGetValue
	Retrieves the value associated with the given key.
	@param theDict The dictionary to be queried. If this parameter is
		not a valid CFDictionary, the behavior is undefined.
	@param key The key for which to find a match in the dictionary. The
		hash() and equal() key callbacks provided when the dictionary
		was created are used to compare. If the hash() key callback
		was NULL, the key is treated as a pointer and converted to
		an integer. If the equal() key callback was NULL, pointer
		equality (in C, ==) is used. If key, or any of the keys in
		the dictionary, are not understood by the equal() callback,
		the behavior is undefined.
	@result The value with the given key in the dictionary, or NULL if
		no key-value pair with a matching key exists. Since NULL
		can be a valid value in some dictionaries, the function
		CFDictionaryGetValueIfPresent() must be used to distinguish
		NULL-no-found from NULL-is-the-value.
}
function CFDictionaryGetValue( theDict: CFDictionaryRef; key: {const} UnivPtr ): UnivPtr; external name '_CFDictionaryGetValue';

{!
	@function CFDictionaryGetValueIfPresent
	Retrieves the value associated with the given key.
	@param theDict The dictionary to be queried. If this parameter is
		not a valid CFDictionary, the behavior is undefined.
	@param key The key for which to find a match in the dictionary. The
		hash() and equal() key callbacks provided when the dictionary
		was created are used to compare. If the hash() key callback
		was NULL, the key is treated as a pointer and converted to
		an integer. If the equal() key callback was NULL, pointer
		equality (in C, ==) is used. If key, or any of the keys in
		the dictionary, are not understood by the equal() callback,
		the behavior is undefined.
	@param value A pointer to memory which should be filled with the
		pointer-sized value if a matching key is found. If no key
		match is found, the contents of the storage pointed to by
		this parameter are undefined. This parameter may be NULL,
		in which case the value from the dictionary is not returned
		(but the return value of this function still indicates
		whether or not the key-value pair was present).
	@result true, if a matching key was found, false otherwise.
}
function CFDictionaryGetValueIfPresent( theDict: CFDictionaryRef; key: {const} UnivPtr; {const} value: UnivPtrPtr ): Boolean; external name '_CFDictionaryGetValueIfPresent';

{!
	@function CFDictionaryGetKeysAndValues
	Fills the two buffers with the keys and values from the dictionary.
	@param theDict The dictionary to be queried. If this parameter is
		not a valid CFDictionary, the behavior is undefined.
	@param keys A C array of pointer-sized values to be filled with keys
		from the dictionary. The keys and values C arrays are parallel
		to each other (that is, the items at the same indices form a
		key-value pair from the dictionary). This parameter may be NULL
		if the keys are not desired. If this parameter is not a valid
		pointer to a C array of at least CFDictionaryGetCount() pointers,
		or NULL, the behavior is undefined.
	@param values A C array of pointer-sized values to be filled with values
		from the dictionary. The keys and values C arrays are parallel
		to each other (that is, the items at the same indices form a
		key-value pair from the dictionary). This parameter may be NULL
		if the values are not desired. If this parameter is not a valid
		pointer to a C array of at least CFDictionaryGetCount() pointers,
		or NULL, the behavior is undefined.
}
procedure CFDictionaryGetKeysAndValues( theDict: CFDictionaryRef; {const} keys: UnivPtrPtr; {const} values: UnivPtrPtr ); external name '_CFDictionaryGetKeysAndValues';

{!
	@function CFDictionaryApplyFunction
	Calls a function once for each value in the dictionary.
	@param theDict The dictionary to be queried. If this parameter is
		not a valid CFDictionary, the behavior is undefined.
	@param applier The callback function to call once for each value in
		the dictionary. If this parameter is not a
		pointer to a function of the correct prototype, the behavior
		is undefined. If there are keys or values which the
		applier function does not expect or cannot properly apply
		to, the behavior is undefined. 
	@param context A pointer-sized user-defined value, which is passed
		as the third parameter to the applier function, but is
		otherwise unused by this function. If the context is not
		what is expected by the applier function, the behavior is
		undefined.
}
procedure CFDictionaryApplyFunction( theDict: CFDictionaryRef; applier: CFDictionaryApplierFunction; context: UnivPtr ); external name '_CFDictionaryApplyFunction';

{!
	@function CFDictionaryAddValue
	Adds the key-value pair to the dictionary if no such key already exists.
	@param theDict The dictionary to which the value is to be added. If this
		parameter is not a valid mutable CFDictionary, the behavior is
		undefined. If the dictionary is a fixed-capacity dictionary and
		it is full before this operation, the behavior is undefined.
	@param key The key of the value to add to the dictionary. The key is
		retained by the dictionary using the retain callback provided
		when the dictionary was created. If the key is not of the sort
		expected by the retain callback, the behavior is undefined. If
		a key which matches this key is already present in the dictionary,
		this function does nothing ("add if absent").
	@param value The value to add to the dictionary. The value is retained
		by the dictionary using the retain callback provided when the
		dictionary was created. If the value is not of the sort expected
		by the retain callback, the behavior is undefined.
}
procedure CFDictionaryAddValue( theDict: CFMutableDictionaryRef; key: {const} UnivPtr; value: {const} UnivPtr ); external name '_CFDictionaryAddValue';

{!
	@function CFDictionarySetValue
	Sets the value of the key in the dictionary.
	@param theDict The dictionary to which the value is to be set. If this
		parameter is not a valid mutable CFDictionary, the behavior is
		undefined. If the dictionary is a fixed-capacity dictionary and
		it is full before this operation, and the key does not exist in
		the dictionary, the behavior is undefined.
	@param key The key of the value to set into the dictionary. If a key 
		which matches this key is already present in the dictionary, only
		the value is changed ("add if absent, replace if present"). If
		no key matches the given key, the key-value pair is added to the
		dictionary. If added, the key is retained by the dictionary,
		using the retain callback provided
		when the dictionary was created. If the key is not of the sort
		expected by the key retain callback, the behavior is undefined.
	@param value The value to add to or replace into the dictionary. The value
		is retained by the dictionary using the retain callback provided
		when the dictionary was created, and the previous value if any is
		released. If the value is not of the sort expected by the
		retain or release callbacks, the behavior is undefined.
}
procedure CFDictionarySetValue( theDict: CFMutableDictionaryRef; key: {const} UnivPtr; value: {const} UnivPtr ); external name '_CFDictionarySetValue';

{!
	@function CFDictionaryReplaceValue
	Replaces the value of the key in the dictionary.
	@param theDict The dictionary to which the value is to be replaced. If this
		parameter is not a valid mutable CFDictionary, the behavior is
		undefined.
	@param key The key of the value to replace in the dictionary. If a key 
		which matches this key is present in the dictionary, the value
		is changed to the given value, otherwise this function does
		nothing ("replace if present").
	@param value The value to replace into the dictionary. The value
		is retained by the dictionary using the retain callback provided
		when the dictionary was created, and the previous value is
		released. If the value is not of the sort expected by the
		retain or release callbacks, the behavior is undefined.
}
procedure CFDictionaryReplaceValue( theDict: CFMutableDictionaryRef; key: {const} UnivPtr; value: {const} UnivPtr ); external name '_CFDictionaryReplaceValue';

{!
	@function CFDictionaryRemoveValue
	Removes the value of the key from the dictionary.
	@param theDict The dictionary from which the value is to be removed. If this
		parameter is not a valid mutable CFDictionary, the behavior is
		undefined.
	@param key The key of the value to remove from the dictionary. If a key 
		which matches this key is present in the dictionary, the key-value
		pair is removed from the dictionary, otherwise this function does
		nothing ("remove if present").
}
procedure CFDictionaryRemoveValue( theDict: CFMutableDictionaryRef; key: {const} UnivPtr ); external name '_CFDictionaryRemoveValue';

{!
	@function CFDictionaryRemoveAllValues
	Removes all the values from the dictionary, making it empty.
	@param theDict The dictionary from which all of the values are to be
		removed. If this parameter is not a valid mutable
		CFDictionary, the behavior is undefined.
}
procedure CFDictionaryRemoveAllValues( theDict: CFMutableDictionaryRef ); external name '_CFDictionaryRemoveAllValues';


{unit CFNotificationCenter}
{	CFNotificationCenter.h
	Copyright (c) 1998-2005, Apple, Inc. All rights reserved.
}
{	  Pascal Translation:  Peter N Lewis, <peter@stairways.com.au>, 2004 }
{	  Pascal Translation Updated:  Peter N Lewis, <peter@stairways.com.au>, September 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}


type
	CFNotificationCenterRef = ^SInt32; { an opaque 32-bit type }

type
	CFNotificationCallback = procedure( center: CFNotificationCenterRef; observer: UnivPtr; name: CFStringRef; objct: {const} UnivPtr; userInfo: CFDictionaryRef );

type
	CFNotificationSuspensionBehavior = SInt32;
const
    CFNotificationSuspensionBehaviorDrop = 1;
        // The server will not queue any notifications with this name and object while the process/app is in the background.
    CFNotificationSuspensionBehaviorCoalesce = 2;
        // The server will only queue the last notification of the specified name and object; earlier notifications are dropped. 
    CFNotificationSuspensionBehaviorHold = 3;
        // The server will hold all matching notifications until the queue has been filled (queue size determined by the server) at which point the server may flush queued notifications.
    CFNotificationSuspensionBehaviorDeliverImmediately = 4;
        // The server will deliver notifications matching this registration whether or not the process is in the background.  When a notification with this suspension behavior is matched, it has the effect of first flushing any queued notifications.

function CFNotificationCenterGetTypeID: CFTypeID; external name '_CFNotificationCenterGetTypeID';

function CFNotificationCenterGetLocalCenter: CFNotificationCenterRef; external name '_CFNotificationCenterGetLocalCenter';
(* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)

function CFNotificationCenterGetDistributedCenter: CFNotificationCenterRef; external name '_CFNotificationCenterGetDistributedCenter';

function CFNotificationCenterGetDarwinNotifyCenter: CFNotificationCenterRef; external name '_CFNotificationCenterGetDarwinNotifyCenter';
(* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)
// The Darwin Notify Center is based on the <notify.h> API.
// For this center, there are limitations in the API. There are no notification "objects",
// "userInfo" cannot be passed in the notification, and there are no suspension behaviors
// (always "deliver immediately"). Other limitations in the <notify.h> API as described in
// that header will also apply.
// - In the CFNotificationCallback, the 'object' and 'userInfo' parameters must be ignored.
// - CFNotificationCenterAddObserver(): the 'object' and 'suspensionBehavior' arguments are ignored.
// - CFNotificationCenterAddObserver(): the 'name' argument may not be NULL (for this center).
// - CFNotificationCenterRemoveObserver(): the 'object' argument is ignored.
// - CFNotificationCenterPostNotification(): the 'object', 'userInfo', and 'deliverImmediately' arguments are ignored.
// - CFNotificationCenterPostNotificationWithOptions(): the 'object', 'userInfo', and 'options' arguments are ignored.
// The Darwin Notify Center has no notion of per-user sessions, all notifications are system-wide.
// As with distributed notifications, the main thread's run loop must be running in one of the
// common modes (usually kCFRunLoopDefaultMode) for Darwin-style notifications to be delivered.
// NOTE: NULL or 0 should be passed for all ignored arguments to ensure future compatibility.


procedure CFNotificationCenterAddObserver( center: CFNotificationCenterRef; observer: {const} UnivPtr; callBack: CFNotificationCallback; name: CFStringRef; objct: {const} UnivPtr; suspensionBehavior: CFNotificationSuspensionBehavior ); external name '_CFNotificationCenterAddObserver';

procedure CFNotificationCenterRemoveObserver( center: CFNotificationCenterRef; observer: {const} UnivPtr; name: CFStringRef; objct: {const} UnivPtr ); external name '_CFNotificationCenterRemoveObserver';
procedure CFNotificationCenterRemoveEveryObserver( center: CFNotificationCenterRef; observer: {const} UnivPtr ); external name '_CFNotificationCenterRemoveEveryObserver';

procedure CFNotificationCenterPostNotification( center: CFNotificationCenterRef; name: CFStringRef; objct: {const} UnivPtr; userInfo: CFDictionaryRef; deliverImmediately: Boolean ); external name '_CFNotificationCenterPostNotification';

{#if MAC_OS_X_VERSION_10_3 <= MAC_OS_X_VERSION_MAX_ALLOWED}

const
	kCFNotificationDeliverImmediately = 1 shl 0;
	kCFNotificationPostToAllSessions = 1 shl 1;

procedure CFNotificationCenterPostNotificationWithOptions( center: CFNotificationCenterRef; name: CFStringRef; objct: {const} UnivPtr; userInfo: CFDictionaryRef; options: CFOptionFlags ); external name '_CFNotificationCenterPostNotificationWithOptions';
(* AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER *)

{#endif}


{unit CFNumber}
{	CFNumber.h
	Copyright (c) 1999-2005, Apple, Inc. All rights reserved.
}
{   Pascal Translation Updated:  Peter N Lewis, <peter@stairways.com.au>, September 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}


type
	CFBooleanRef = ^SInt32; { an opaque 32-bit type }
	CFBooleanRefPtr = ^CFBooleanRef;

var kCFBooleanTrue: CFBooleanRef; external name '_kCFBooleanTrue'; (* attribute const *)
var kCFBooleanFalse: CFBooleanRef; external name '_kCFBooleanFalse'; (* attribute const *)

function CFBooleanGetTypeID: CFTypeID; external name '_CFBooleanGetTypeID';

function CFBooleanGetValue( value: CFBooleanRef ): Boolean; external name '_CFBooleanGetValue';

type
	CFNumberType = SInt32;
const
																{  Types from MacTypes.h  }
	kCFNumberSInt8Type = 1;
	kCFNumberSInt16Type = 2;
	kCFNumberSInt32Type = 3;
	kCFNumberSInt64Type = 4;
	kCFNumberFloat32Type = 5;
	kCFNumberFloat64Type = 6;							{  64-bit IEEE 754  }
																{  Basic C types  }
	kCFNumberCharType = 7;
	kCFNumberShortType = 8;
	kCFNumberIntType = 9;
	kCFNumberLongType = 10;
	kCFNumberLongLongType = 11;
	kCFNumberFloatType = 12;
	kCFNumberDoubleType = 13;							{  Other  }
	kCFNumberCFIndexType = 14;
	kCFNumberMaxType = 14;

type
	CFNumberRef = ^SInt32; { an opaque 32-bit type }
	CFNumberRefPtr = ^CFNumberRef;

var kCFNumberPositiveInfinity: CFNumberRef; external name '_kCFNumberPositiveInfinity'; (* attribute const *)
var kCFNumberNegativeInfinity: CFNumberRef; external name '_kCFNumberNegativeInfinity'; (* attribute const *)
var kCFNumberNaN: CFNumberRef; external name '_kCFNumberNaN'; (* attribute const *)

function CFNumberGetTypeID: CFTypeID; external name '_CFNumberGetTypeID';

{
	Creates a CFNumber with the given value. The type of number pointed
	to by the valuePtr is specified by type. If type is a floating point
	type and the value represents one of the infinities or NaN, the
	well-defined CFNumber for that value is returned. If either of
	valuePtr or type is an invalid value, the result is undefined.
}
function CFNumberCreate( allocator: CFAllocatorRef; theType: CFNumberType; valuePtr: {const} UnivPtr ): CFNumberRef; external name '_CFNumberCreate';

{
	Returns the storage format of the CFNumber's value.  Note that
	this is not necessarily the type provided in CFNumberCreate().
}
function CFNumberGetType( number: CFNumberRef ): CFNumberType; external name '_CFNumberGetType';

{
	Returns the size in bytes of the type of the number.
}
function CFNumberGetByteSize( number: CFNumberRef ): CFIndex; external name '_CFNumberGetByteSize';

{
	Returns true if the type of the CFNumber's value is one of
	the defined floating point types.
}
function CFNumberIsFloatType( number: CFNumberRef ): Boolean; external name '_CFNumberIsFloatType';

{
	Copies the CFNumber's value into the space pointed to by
	valuePtr, as the specified type. If conversion needs to take
	place, the conversion rules follow human expectation and not
	C's promotion and truncation rules. If the conversion is
	lossy, or the value is out of range, false is returned. Best
	attempt at conversion will still be in *valuePtr.
}
function CFNumberGetValue( number: CFNumberRef; theType: CFNumberType; valuePtr: UnivPtr ): Boolean; external name '_CFNumberGetValue';

{
	Compares the two CFNumber instances. If conversion of the
	types of the values is needed, the conversion and comparison
	follow human expectations and not C's promotion and comparison
	rules. Negative zero compares less than positive zero.
	Positive infinity compares greater than everything except
	itself, to which it compares equal. Negative infinity compares
	less than everything except itself, to which it compares equal.
	Unlike standard practice, if both numbers are NaN, then they
	compare equal; if only one of the numbers is NaN, then the NaN
	compares greater than the other number if it is negative, and
	smaller than the other number if it is positive. (Note that in
	CFEqual() with two CFNumbers, if either or both of the numbers
	is NaN, true is returned.)
}
function CFNumberCompare( number: CFNumberRef; otherNumber: CFNumberRef; context: UnivPtr ): CFComparisonResult; external name '_CFNumberCompare';


{unit CFSet}
{	CFSet.h
	Copyright (c) 1998-2005, Apple, Inc. All rights reserved.
}
{   Pascal Translation Updated:  Peter N Lewis, <peter@stairways.com.au>, September 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}

{!
        @header CFSet
        CFSet implements a container which stores unique values.
}


{!
	@typedef CFSetRetainCallBack
	Type of the callback function used by CFSets for retaining values.
        @param allocator The allocator of the CFSet.
	@param value The value to retain.
        @result The value to store in the set, which is usually the value
		parameter passed to this callback, but may be a different
		value if a different value should be stored in the set.
}
type
	CFSetRetainCallBack = function( allocator: CFAllocatorRef; value: {const} UnivPtr ): UnivPtr;

{!
	@typedef CFSetReleaseCallBack
	Type of the callback function used by CFSets for releasing a retain on values.
        @param allocator The allocator of the CFSet.
	@param value The value to release.
}
type
	CFSetReleaseCallBack = procedure( allocator: CFAllocatorRef; value: {const} UnivPtr );

{!
	@typedef CFSetCopyDescriptionCallBack
	Type of the callback function used by CFSets for describing values.
	@param value The value to describe.
        @result A description of the specified value.
}
type
	CFSetCopyDescriptionCallBack = function( value: {const} UnivPtr ): CFStringRef;

{!
	@typedef CFSetEqualCallBack
	Type of the callback function used by CFSets for comparing values.
	@param value1 The first value to compare.
	@param value2 The second value to compare.
        @result True if the values are equal, otherwise false.
}
type
	CFSetEqualCallBack = function( value1: {const} UnivPtr; value2: {const} UnivPtr ): Boolean;

{!
	@typedef CFSetHashCallBack
	Type of the callback function used by CFSets for hashing values.
	@param value The value to hash.
        @result The hash of the value.
}
type
	CFSetHashCallBack = function( value: {const} UnivPtr ): CFHashCode;

{!
	@typedef CFSetCallBacks
	Structure containing the callbacks of a CFSet.
	@field version The version number of the structure type being passed
		in as a parameter to the CFSet creation functions. This
		structure is version 0.
	@field retain The callback used to add a retain for the set on
		values as they are put into the set. This callback returns
		the value to store in the set, which is usually the value
		parameter passed to this callback, but may be a different
		value if a different value should be stored in the set.
		The set's allocator is passed as the first argument.
	@field release The callback used to remove a retain previously added
		for the set from values as they are removed from the
		set. The set's allocator is passed as the first
		argument.
	@field copyDescription The callback used to create a descriptive
		string representation of each value in the set. This is
		used by the CFCopyDescription() function.
	@field equal The callback used to compare values in the set for
		equality for some operations.
	@field hash The callback used to compare values in the set for
		uniqueness for some operations.
}
type
	CFSetCallBacks = record
		version: CFIndex;
		retain: CFSetRetainCallBack;
		release: CFSetReleaseCallBack;
		copyDescription: CFSetCopyDescriptionCallBack;
		equal: CFSetEqualCallBack;
		hash: CFSetHashCallBack;
	end;
	CFSetCallBacksPtr = ^CFSetCallBacks;

{!
	@constant kCFTypeSetCallBacks
	Predefined CFSetCallBacks structure containing a set of callbacks
	appropriate for use when the values in a CFSet are all CFTypes.
}
var kCFTypeSetCallBacks: CFSetCallBacks; external name '_kCFTypeSetCallBacks'; (* attribute const *)

{!
	@constant kCFCopyStringSetCallBacks
	Predefined CFSetCallBacks structure containing a set of callbacks
	appropriate for use when the values in a CFSet should be copies
        of a CFString.
}
var kCFCopyStringSetCallBacks: CFSetCallBacks; external name '_kCFCopyStringSetCallBacks'; (* attribute const *)

{!
	@typedef CFSetApplierFunction
	Type of the callback function used by the apply functions of
		CFSets.
	@param value The current value from the set.
	@param context The user-defined context parameter given to the apply
		function.
}
type
	CFSetApplierFunction = procedure( value: {const} UnivPtr; context: UnivPtr );

{!
        @typedef CFSetRef
	This is the type of a reference to immutable CFSets.
}
type
	CFSetRef = ^SInt32; { an opaque 32-bit type }
	CFSetRefPtr = ^CFSetRef;

{!
        @typedef CFMutableSetRef
	This is the type of a reference to mutable CFSets.
}
type
	CFMutableSetRef = CFSetRef;
	CFMutableSetRefPtr = ^CFMutableSetRef;

{!
        @function CFSetGetTypeID
        Returns the type identifier of all CFSet instances.
}
function CFSetGetTypeID: CFTypeID; external name '_CFSetGetTypeID';

{!
        @function CFSetCreate
        Creates a new immutable set with the given values.
	@param allocator The CFAllocator which should be used to allocate
		memory for the set and its storage for values. This
		parameter may be NULL in which case the current default
		CFAllocator is used. If this reference is not a valid
		CFAllocator, the behavior is undefined.
	@param values A C array of the pointer-sized values to be in the
		set.  This C array is not changed or freed by this function. 
                If this parameter is not a valid pointer to a C array of at
                least numValues pointers, the behavior is undefined.
	@param numValues The number of values to copy from the values C
		array into the CFSet. This number will be the count of the
		set.  If this parameter is zero, negative, or greater than 
                the number of values actually in the values C array, the 
                behavior is undefined.
	@param callBacks A C pointer to a CFSetCallBacks structure
		initialized with the callbacks for the set to use on each
		value in the set. A copy of the contents of the
		callbacks structure is made, so that a pointer to a
		structure on the stack can be passed in, or can be reused
		for multiple set creations. If the version field of this
		callbacks structure is not one of the defined ones for
		CFSet, the behavior is undefined. The retain field may be
		NULL, in which case the CFSet will do nothing to add a
		retain to the contained values for the set. The release
		field may be NULL, in which case the CFSet will do nothing
		to remove the set's retain (if any) on the values when the
		set is destroyed. If the copyDescription field is NULL,
		the set will create a simple description for the value. If
		the equal field is NULL, the set will use pointer equality
		to test for equality of values. The hash field may be NULL,
                in which case the CFSet will determine uniqueness by pointer
                equality. This callbacks parameter
		itself may be NULL, which is treated as if a valid structure
		of version 0 with all fields NULL had been passed in.
		Otherwise, if any of the fields are not valid pointers to
		functions of the correct type, or this parameter is not a
		valid pointer to a  CFSetCallBacks callbacks structure,
		the behavior is undefined. If any of the values put into the
		set is not one understood by one of the callback functions
		the behavior when that callback function is used is
		undefined.
	@result A reference to the new immutable CFSet.
}
function CFSetCreate( allocator: CFAllocatorRef; {const} values: UnivPtrPtr; numValues: CFIndex; {const} callBacks: CFSetCallBacksPtr { can be NULL } ): CFSetRef; external name '_CFSetCreate';

{!
	@function CFSetCreateCopy
	Creates a new immutable set with the values from the given set.
	@param allocator The CFAllocator which should be used to allocate
		memory for the set and its storage for values. This
		parameter may be NULL in which case the current default
		CFAllocator is used. If this reference is not a valid
		CFAllocator, the behavior is undefined.
	@param theSet The set which is to be copied. The values from the
		set are copied as pointers into the new set (that is,
		the values themselves are copied, not that which the values
		point to, if anything). However, the values are also
		retained by the new set. The count of the new set will
		be the same as the copied set. The new set uses the same
		callbacks as the set to be copied. If this parameter is
		not a valid CFSet, the behavior is undefined.
	@result A reference to the new immutable CFSet.
}
function CFSetCreateCopy( allocator: CFAllocatorRef; theSet: CFSetRef ): CFSetRef; external name '_CFSetCreateCopy';

{!
	@function CFSetCreateMutable
	Creates a new empty mutable set.
	@param allocator The CFAllocator which should be used to allocate
		memory for the set and its storage for values. This
		parameter may be NULL in which case the current default
		CFAllocator is used. If this reference is not a valid
		CFAllocator, the behavior is undefined.
	@param capacity The maximum number of values that can be contained
		by the CFSet. The set starts empty, and can grow to this
		number of values (and it can have less). If this parameter
		is 0, the set's maximum capacity is unlimited (or rather,
		only limited by address space and available memory
		constraints). If this parameter is negative, the behavior is
		undefined.
	@param callBacks A C pointer to a CFSetCallBacks structure
		initialized with the callbacks for the set to use on each
		value in the set. A copy of the contents of the
		callbacks structure is made, so that a pointer to a
		structure on the stack can be passed in, or can be reused
		for multiple set creations. If the version field of this
		callbacks structure is not one of the defined ones for
		CFSet, the behavior is undefined. The retain field may be
		NULL, in which case the CFSet will do nothing to add a
		retain to the contained values for the set. The release
		field may be NULL, in which case the CFSet will do nothing
		to remove the set's retain (if any) on the values when the
		set is destroyed. If the copyDescription field is NULL,
		the set will create a simple description for the value. If
		the equal field is NULL, the set will use pointer equality
		to test for equality of values. The hash field may be NULL,
                in which case the CFSet will determine uniqueness by pointer
                equality. This callbacks parameter
		itself may be NULL, which is treated as if a valid structure
		of version 0 with all fields NULL had been passed in.
		Otherwise, if any of the fields are not valid pointers to
		functions of the correct type, or this parameter is not a
		valid pointer to a  CFSetCallBacks callbacks structure,
		the behavior is undefined. If any of the values put into the
		set is not one understood by one of the callback functions
		the behavior when that callback function is used is
		undefined.
	@result A reference to the new mutable CFSet.
}
function CFSetCreateMutable( allocator: CFAllocatorRef; capacity: CFIndex; {const} callBacks: CFSetCallBacksPtr { can be NULL } ): CFMutableSetRef; external name '_CFSetCreateMutable';

{!
	@function CFSetCreateMutableCopy
	Creates a new immutable set with the values from the given set.
	@param allocator The CFAllocator which should be used to allocate
		memory for the set and its storage for values. This
		parameter may be NULL in which case the current default
		CFAllocator is used. If this reference is not a valid
		CFAllocator, the behavior is undefined.
	@param capacity The maximum number of values that can be contained
		by the CFSet. The set starts with the same values as the
                set to be copied, and can grow to this number of values.
                If this parameter is 0, the set's maximum capacity is 
                unlimited (or rather, only limited by address space and 
                available memory constraints). This parameter must be 
                greater than or equal to the count of the set which is to
                be copied, or the behavior is undefined.
	@param theSet The set which is to be copied. The values from the
		set are copied as pointers into the new set (that is,
		the values themselves are copied, not that which the values
		point to, if anything). However, the values are also
		retained by the new set. The count of the new set will
		be the same as the copied set. The new set uses the same
		callbacks as the set to be copied. If this parameter is
		not a valid CFSet, the behavior is undefined.
	@result A reference to the new mutable CFSet.
}
function CFSetCreateMutableCopy( allocator: CFAllocatorRef; capacity: CFIndex; theSet: CFSetRef ): CFMutableSetRef; external name '_CFSetCreateMutableCopy';

{!
	@function CFSetGetCount
	Returns the number of values currently in the set.
	@param theSet The set to be queried. If this parameter is not a valid
		CFSet, the behavior is undefined.
	@result The number of values in the set.
}
function CFSetGetCount( theSet: CFSetRef ): CFIndex; external name '_CFSetGetCount';

{!
	@function CFSetGetCountOfValue
	Counts the number of times the given value occurs in the set. Since 
        sets by definition contain only one instance of a value, this function
        is synomous to SFSetContainsValue.
	@param theSet The set to be searched. If this parameter is not a
		valid CFSet, the behavior is undefined.
	@param value The value for which to find matches in the set. The
		equal() callback provided when the set was created is
		used to compare. If the equal() callback was NULL, pointer
		equality (in C, ==) is used. If value, or any of the values
		in the set, are not understood by the equal() callback,
		the behavior is undefined.
	@result The number of times the given value occurs in the set.
}
function CFSetGetCountOfValue( theSet: CFSetRef; value: {const} UnivPtr ): CFIndex; external name '_CFSetGetCountOfValue';

{!
	@function CFSetContainsValue
	Reports whether or not the value is in the set.
	@param theSet The set to be searched. If this parameter is not a
		valid CFSet, the behavior is undefined.
	@param value The value for which to find matches in the set. The
		equal() callback provided when the set was created is
		used to compare. If the equal() callback was NULL, pointer
		equality (in C, ==) is used. If value, or any of the values
		in the set, are not understood by the equal() callback,
		the behavior is undefined.
	@result true, if the value is in the set, otherwise false.
}
function CFSetContainsValue( theSet: CFSetRef; value: {const} UnivPtr ): Boolean; external name '_CFSetContainsValue';

{!
	@function CFSetGetValue
	Retrieves a value in the set which hashes the same as the specified value.
	@param theSet The set to be queried. If this parameter is not a
		valid CFSet, the behavior is undefined.
	@param value The value to retrieve. The equal() callback provided when
                the set was created is used to compare. If the equal() callback
                was NULL, pointer equality (in C, ==) is used. If a value, or
                any of the values in the set, are not understood by the equal()
                callback, the behavior is undefined.
        @result The value in the set with the given hash.
}
function CFSetGetValue( theSet: CFSetRef; value: {const} UnivPtr ): UnivPtr; external name '_CFSetGetValue';

{!
	@function CFSetGetValue
	Retrieves a value in the set which hashes the same as the specified value,
        if present.
	@param theSet The set to be queried. If this parameter is not a
		valid CFSet, the behavior is undefined.
	@param candidate This value is hashed and compared with values in the
                set to determine which value to retrieve. The equal() callback provided when
                the set was created is used to compare. If the equal() callback
                was NULL, pointer equality (in C, ==) is used. If a value, or
                any of the values in the set, are not understood by the equal()
                callback, the behavior is undefined.
	@param value A pointer to memory which should be filled with the
		pointer-sized value if a matching value is found. If no
		match is found, the contents of the storage pointed to by
		this parameter are undefined. This parameter may be NULL,
		in which case the value from the dictionary is not returned
		(but the return value of this function still indicates
		whether or not the value was present).
        @result True if the value was present in the set, otherwise false.
}
function CFSetGetValueIfPresent( theSet: CFSetRef; candidate: {const} UnivPtr; {const} value: UnivPtrPtr ): Boolean; external name '_CFSetGetValueIfPresent';

{!
	@function CFSetGetValues
	Fills the buffer with values from the set.
	@param theSet The set to be queried. If this parameter is not a
		valid CFSet, the behavior is undefined.
	@param values A C array of pointer-sized values to be filled with
		values from the set. The values in the C array are ordered
		in the same order in which they appear in the set. If this
		parameter is not a valid pointer to a C array of at least
		CFSetGetCount() pointers, the behavior is undefined.
}
procedure CFSetGetValues( theSet: CFSetRef; {const} values: UnivPtrPtr ); external name '_CFSetGetValues';

{!
	@function CFSetApplyFunction
	Calls a function once for each value in the set.
	@param theSet The set to be operated upon. If this parameter is not
		a valid CFSet, the behavior is undefined.
	@param applier The callback function to call once for each value in
		the given set. If this parameter is not a
		pointer to a function of the correct prototype, the behavior
		is undefined. If there are values in the set which the
		applier function does not expect or cannot properly apply
		to, the behavior is undefined. 
	@param context A pointer-sized user-defined value, which is passed
		as the second parameter to the applier function, but is
		otherwise unused by this function. If the context is not
		what is expected by the applier function, the behavior is
		undefined.
}
procedure CFSetApplyFunction( theSet: CFSetRef; applier: CFSetApplierFunction; context: UnivPtr ); external name '_CFSetApplyFunction';

{!
	@function CFSetAddValue
	Adds the value to the set if it is not already present.
	@param theSet The set to which the value is to be added. If this
		parameter is not a valid mutable CFSet, the behavior is
		undefined. If the set is a fixed-capacity set and it
		is full before this operation, the behavior is undefined.
	@param value The value to add to the set. The value is retained by
		the set using the retain callback provided when the set
		was created. If the value is not of the sort expected by the
		retain callback, the behavior is undefined. The count of the 
                set is increased by one.
}
procedure CFSetAddValue( theSet: CFMutableSetRef; value: {const} UnivPtr ); external name '_CFSetAddValue';

{!
	@function CFSetReplaceValue
	Replaces the value in the set if it is present.
	@param theSet The set to which the value is to be replaced. If this
		parameter is not a valid mutable CFSet, the behavior is
		undefined.
        @param value The value to replace in the set. The equal() callback provided when
                the set was created is used to compare. If the equal() callback
                was NULL, pointer equality (in C, ==) is used. If a value, or
                any of the values in the set, are not understood by the equal()
                callback, the behavior is undefined. The value is retained by
		the set using the retain callback provided when the set
		was created. If the value is not of the sort expected by the
		retain callback, the behavior is undefined. The count of the 
                set is increased by one.
}
procedure CFSetReplaceValue( theSet: CFMutableSetRef; value: {const} UnivPtr ); external name '_CFSetReplaceValue';

{!
	@function CFSetSetValue
	Replaces the value in the set if it is present, or adds the value to 
        the set if it is absent.
	@param theSet The set to which the value is to be replaced. If this
		parameter is not a valid mutable CFSet, the behavior is
		undefined.
        @param value The value to set in the CFSet. The equal() callback provided when
                the set was created is used to compare. If the equal() callback
                was NULL, pointer equality (in C, ==) is used. If a value, or
                any of the values in the set, are not understood by the equal()
                callback, the behavior is undefined. The value is retained by
		the set using the retain callback provided when the set
		was created. If the value is not of the sort expected by the
		retain callback, the behavior is undefined. The count of the 
                set is increased by one.
}
procedure CFSetSetValue( theSet: CFMutableSetRef; value: {const} UnivPtr ); external name '_CFSetSetValue';

{!
	@function CFSetRemoveValue
	Removes the specified value from the set.
	@param theSet The set from which the value is to be removed.
                If this parameter is not a valid mutable CFSet,
		the behavior is undefined.
        @param value The value to remove. The equal() callback provided when
                the set was created is used to compare. If the equal() callback
                was NULL, pointer equality (in C, ==) is used. If a value, or
                any of the values in the set, are not understood by the equal()
                callback, the behavior is undefined.
}
procedure CFSetRemoveValue( theSet: CFMutableSetRef; value: {const} UnivPtr ); external name '_CFSetRemoveValue';

{!
	@function CFSetRemoveAllValues
	Removes all the values from the set, making it empty.
	@param theSet The set from which all of the values are to be
		removed. If this parameter is not a valid mutable CFSet,
		the behavior is undefined.
}
procedure CFSetRemoveAllValues( theSet: CFMutableSetRef ); external name '_CFSetRemoveAllValues';


{unit CFStringEncodingExt}
{	CFStringEncodingExt.h
	Copyright (c) 1998-2005, Apple, Inc. All rights reserved.
}
{	  Pascal Translation Updated:  Peter N Lewis, <peter@stairways.com.au>, November 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}


type
	CFStringEncodings = SInt32;
const
{   kCFStringEncodingMacRoman = 0L, defined in CoreFoundation/CFString.h  }
	kCFStringEncodingMacJapanese = 1;
	kCFStringEncodingMacChineseTrad = 2;
	kCFStringEncodingMacKorean = 3;
	kCFStringEncodingMacArabic = 4;
	kCFStringEncodingMacHebrew = 5;
	kCFStringEncodingMacGreek = 6;
	kCFStringEncodingMacCyrillic = 7;
	kCFStringEncodingMacDevanagari = 9;
	kCFStringEncodingMacGurmukhi = 10;
	kCFStringEncodingMacGujarati = 11;
	kCFStringEncodingMacOriya = 12;
	kCFStringEncodingMacBengali = 13;
	kCFStringEncodingMacTamil = 14;
	kCFStringEncodingMacTelugu = 15;
	kCFStringEncodingMacKannada = 16;
	kCFStringEncodingMacMalayalam = 17;
	kCFStringEncodingMacSinhalese = 18;
	kCFStringEncodingMacBurmese = 19;
	kCFStringEncodingMacKhmer = 20;
	kCFStringEncodingMacThai = 21;
	kCFStringEncodingMacLaotian = 22;
	kCFStringEncodingMacGeorgian = 23;
	kCFStringEncodingMacArmenian = 24;
	kCFStringEncodingMacChineseSimp = 25;
	kCFStringEncodingMacTibetan = 26;
	kCFStringEncodingMacMongolian = 27;
	kCFStringEncodingMacEthiopic = 28;
	kCFStringEncodingMacCentralEurRoman = 29;
	kCFStringEncodingMacVietnamese = 30;
	kCFStringEncodingMacExtArabic = 31;
	{  The following use script code 0, smRoman  }
	kCFStringEncodingMacSymbol = 33;
	kCFStringEncodingMacDingbats = 34;
	kCFStringEncodingMacTurkish = 35;
	kCFStringEncodingMacCroatian = 36;
	kCFStringEncodingMacIcelandic = 37;
	kCFStringEncodingMacRomanian = 38;
	kCFStringEncodingMacCeltic = 39;
	kCFStringEncodingMacGaelic = 40;
	{  The following use script code 4, smArabic  }
	kCFStringEncodingMacFarsi = $8C; {  Like MacArabic but uses Farsi digits  }
	{  The following use script code 7, smCyrillic  }
	kCFStringEncodingMacUkrainian = $98;
	{  The following use script code 32, smUnimplemented  }
	kCFStringEncodingMacInuit = $EC;
	kCFStringEncodingMacVT100 = $FC; {  VT100/102 font from Comm Toolbox: Latin-1 repertoire + box drawing etc  }
	{  Special Mac OS encodings }
	kCFStringEncodingMacHFS = $FF; {  Meta-value, should never appear in a table  }
	
	{  Unicode & ISO UCS encodings begin at 0x100  }
	{  We don't use Unicode variations defined in TextEncoding; use the ones in CFString.h, instead.  }
	
	{  ISO 8-bit and 7-bit encodings begin at 0x200  }
	{   kCFStringEncodingISOLatin1 = 0x0201, defined in CoreFoundation/CFString.h  }
	kCFStringEncodingISOLatin2 = $0202;						{  ISO 8859-2  }
	kCFStringEncodingISOLatin3 = $0203;						{  ISO 8859-3  }
	kCFStringEncodingISOLatin4 = $0204;						{  ISO 8859-4  }
	kCFStringEncodingISOLatinCyrillic = $0205;					{  ISO 8859-5  }
	kCFStringEncodingISOLatinArabic = $0206;					{  ISO 8859-6, =ASMO 708, =DOS CP 708  }
	kCFStringEncodingISOLatinGreek = $0207;						{  ISO 8859-7  }
	kCFStringEncodingISOLatinHebrew = $0208;					{  ISO 8859-8  }
	kCFStringEncodingISOLatin5 = $0209;						{  ISO 8859-9  }
	kCFStringEncodingISOLatin6 = $020A;						{  ISO 8859-10  }
	kCFStringEncodingISOLatinThai = $020B;						{  ISO 8859-11  }
	kCFStringEncodingISOLatin7 = $020D;						{  ISO 8859-13  }
	kCFStringEncodingISOLatin8 = $020E;						{  ISO 8859-14  }
	kCFStringEncodingISOLatin9 = $020F;						{  ISO 8859-15  }
{#if MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_4}
    kCFStringEncodingISOLatin10 = $0210;	{ ISO 8859-16 }
{#endif} { MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_4 }

	{  MS-DOS & Windows encodings begin at 0x400  }
	kCFStringEncodingDOSLatinUS = $0400;						{  code page 437  }
	kCFStringEncodingDOSGreek = $0405;						{  code page 737 (formerly code page 437G)  }
	kCFStringEncodingDOSBalticRim = $0406;						{  code page 775  }
	kCFStringEncodingDOSLatin1 = $0410;						{  code page 850, "Multilingual"  }
	kCFStringEncodingDOSGreek1 = $0411;						{  code page 851  }
	kCFStringEncodingDOSLatin2 = $0412;						{  code page 852, Slavic  }
	kCFStringEncodingDOSCyrillic = $0413;						{  code page 855, IBM Cyrillic  }
	kCFStringEncodingDOSTurkish = $0414;						{  code page 857, IBM Turkish  }
	kCFStringEncodingDOSPortuguese = $0415;						{  code page 860  }
	kCFStringEncodingDOSIcelandic = $0416;						{  code page 861  }
	kCFStringEncodingDOSHebrew = $0417;						{  code page 862  }
	kCFStringEncodingDOSCanadianFrench = $0418;					{  code page 863  }
	kCFStringEncodingDOSArabic = $0419;						{  code page 864  }
	kCFStringEncodingDOSNordic = $041A;						{  code page 865  }
	kCFStringEncodingDOSRussian = $041B;						{  code page 866  }
	kCFStringEncodingDOSGreek2 = $041C;						{  code page 869, IBM Modern Greek  }
	kCFStringEncodingDOSThai = $041D;						{  code page 874, also for Windows  }
	kCFStringEncodingDOSJapanese = $0420;						{  code page 932, also for Windows  }
	kCFStringEncodingDOSChineseSimplif = $0421;					{  code page 936, also for Windows  }
	kCFStringEncodingDOSKorean = $0422;						{  code page 949, also for Windows; Unified Hangul Code  }
	kCFStringEncodingDOSChineseTrad = $0423;					{  code page 950, also for Windows  }
	{   kCFStringEncodingWindowsLatin1 = 0x0500, defined in CoreFoundation/CFString.h  }
	kCFStringEncodingWindowsLatin2 = $0501;						{  code page 1250, Central Europe  }
	kCFStringEncodingWindowsCyrillic = $0502;					{  code page 1251, Slavic Cyrillic  }
	kCFStringEncodingWindowsGreek = $0503;						{  code page 1253  }
	kCFStringEncodingWindowsLatin5 = $0504;						{  code page 1254, Turkish  }
	kCFStringEncodingWindowsHebrew = $0505;						{  code page 1255  }
	kCFStringEncodingWindowsArabic = $0506;						{  code page 1256  }
	kCFStringEncodingWindowsBalticRim = $0507;					{  code page 1257  }
	kCFStringEncodingWindowsVietnamese = $0508;					{  code page 1258  }
	kCFStringEncodingWindowsKoreanJohab = $0510;				{  code page 1361, for Windows NT  }

	{  Various national standards begin at 0x600  }
	{   kCFStringEncodingASCII = 0x0600, defined in CoreFoundation/CFString.h  }
{#if MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_4}
    kCFStringEncodingANSEL = $0601;	{ ANSEL (ANSI Z39.47) }
{#endif} { MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_4 }
	kCFStringEncodingJIS_X0201_76 = $0620;
	kCFStringEncodingJIS_X0208_83 = $0621;
	kCFStringEncodingJIS_X0208_90 = $0622;
	kCFStringEncodingJIS_X0212_90 = $0623;
	kCFStringEncodingJIS_C6226_78 = $0624;
	kCFStringEncodingShiftJIS_X0213_00 = $0628; { Shift-JIS format encoding of JIS X0213 planes 1 and 2}
{#if MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_4}
    kCFStringEncodingShiftJIS_X0213_MenKuTen = $0629;	{ JIS X0213 in plane-row-column notation }
{#endif} { MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_4 }
	kCFStringEncodingGB_2312_80 = $0630;
	kCFStringEncodingGBK_95 = $0631;						{  annex to GB 13000-93; for Windows 95  }
	kCFStringEncodingKSC_5601_87 = $0640;						{  same as KSC 5601-92 without Johab annex  }
	kCFStringEncodingKSC_5601_92_Johab = $0641;					{  KSC 5601-92 Johab annex  }
	kCFStringEncodingCNS_11643_92_P1 = $0651;					{  CNS 11643-1992 plane 1  }
	kCFStringEncodingCNS_11643_92_P2 = $0652;					{  CNS 11643-1992 plane 2  }
	kCFStringEncodingCNS_11643_92_P3 = $0653;					{  CNS 11643-1992 plane 3 (was plane 14 in 1986 version)  }

	{  ISO 2022 collections begin at 0x800  }
	kCFStringEncodingISO_2022_JP = $0820;
	kCFStringEncodingISO_2022_JP_2 = $0821;
	kCFStringEncodingISO_2022_JP_1 = $0822; { RFC 2237}
	kCFStringEncodingISO_2022_JP_3 = $0823; { JIS X0213}
	kCFStringEncodingISO_2022_CN = $0830;
	kCFStringEncodingISO_2022_CN_EXT = $0831;
	kCFStringEncodingISO_2022_KR = $0840;
	
	{  EUC collections begin at 0x900  }
	kCFStringEncodingEUC_JP = $0920;						{  ISO 646, 1-byte katakana, JIS 208, JIS 212  }
	kCFStringEncodingEUC_CN = $0930;						{  ISO 646, GB 2312-80  }
	kCFStringEncodingEUC_TW = $0931;						{  ISO 646, CNS 11643-1992 Planes 1-16  }
	kCFStringEncodingEUC_KR = $0940;						{  ISO 646, KS C 5601-1987  }

	{  Misc standards begin at 0xA00  }
	kCFStringEncodingShiftJIS = $0A01;						{  plain Shift-JIS  }
	kCFStringEncodingKOI8_R = $0A02;						{  Russian internet standard  }
	kCFStringEncodingBig5 = $0A03;						{  Big-5 (has variants)  }
	kCFStringEncodingMacRomanLatin1 = $0A04;					{  Mac OS Roman permuted to align with ISO Latin-1  }
	kCFStringEncodingHZ_GB_2312 = $0A05;						{  HZ (RFC 1842, for Chinese mail & news)  }
	kCFStringEncodingBig5_HKSCS_1999 = $0A06; { Big-5 with Hong Kong special char set supplement}
{#if MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_4}
	kCFStringEncodingVISCII = $0A07;	{ RFC 1456, Vietnamese }
	kCFStringEncodingKOI8_U = $0A08;	{ RFC 2319, Ukrainian }
	kCFStringEncodingBig5_E = $0A09;	{ Taiwan Big-5E standard }
{#endif} { MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_4 }

	{  Other platform encodings }
{  kCFStringEncodingNextStepLatin = 0x0B01, defined in CoreFoundation/CFString.h }
{#if MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_4}
	kCFStringEncodingNextStepJapanese = $0B02;	{ NextStep Japanese encoding }
{#endif} { MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_4 }
																{  EBCDIC & IBM host encodings begin at 0xC00  }
	kCFStringEncodingEBCDIC_US = $0C01;						{  basic EBCDIC-US  }
	kCFStringEncodingEBCDIC_CP037 = $0C02;						{  code page 037, extended EBCDIC (Latin-1 set) for US,Canada...  }


{unit CFTree}
{	CFTree.h
	Copyright (c) 1998-2005, Apple, Inc. All rights reserved.
}
{	  Pascal Translation Updated:  Peter N Lewis, <peter@stairways.com.au>, November 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}

{!
        @header CFTree
        CFTree implements a container which stores references to other CFTrees.
        Each tree may have a parent, and a variable number of children.
}


{!
        @typedef CFTreeRetainCallBack
        Type of the callback function used to add a retain to the user-specified
        info parameter.  This callback may returns the value to use whenever the
        info parameter is retained, which is usually the value parameter passed
        to this callback, but may be a different value if a different value
        should be used.
        @param info A user-supplied info parameter provided in a CFTreeContext.
        @result The retained info parameter.
}
type
	CFTreeRetainCallBack = function( info: {const} UnivPtr ): UnivPtr;

{!
        @typedef CFTreeReleaseCallBack
        Type of the callback function used to remove a retain previously
        added to the user-specified info parameter.
        @param info A user-supplied info parameter provided in a CFTreeContext.
}
type
	CFTreeReleaseCallBack = procedure( info: {const} UnivPtr );

{!
        @typedef CFTreeCopyDescriptionCallBack
        Type of the callback function used to provide a description of the
        user-specified info parameter.
        @param info A user-supplied info parameter provided in a CFTreeContext.
        @result A description of the info parameter.
}
type
	CFTreeCopyDescriptionCallBack = function( info: {const} UnivPtr ): CFStringRef;

{!
        @typedef CFTreeContext
        Structure containing user-specified data and callbacks for a CFTree.
        @field version The version number of the structure type being passed
                in as a parameter to the CFTree creation function.
                This structure is version 0.
        @field info A C pointer to a user-specified block of data.
        @field retain The callback used to add a retain for the info field.
                If this parameter is not a pointer to a function of the correct
                prototype, the behavior is undefined.  The value may be NULL.
        @field release The calllback used to remove a retain previously added
                for the info field.  If this parameter is not a pointer to a 
                function of the correct prototype, the behavior is undefined.
                The value may be NULL.
        @field copyDescription The callback used to provide a description of
                the info field.
}
type
	CFTreeContext = record
		version: CFIndex;
		info: UnivPtr;
		retain: CFTreeRetainCallBack;
		release: CFTreeReleaseCallBack;	
		copyDescription: CFTreeCopyDescriptionCallBack;
	end;
	CFTreeContextPtr = ^CFTreeContext;

{!
        @typedef CFTreeApplierFunction
        Type of the callback function used by the apply functions of
                CFTree.
        @param value The current value from the CFTree
        @param context The user-defined context parameter give to the apply
                function.
}
type
	CFTreeApplierFunction = procedure( value: {const} UnivPtr; context: UnivPtr );

{!
        @typedef CFTreeRef
        This is the type of a reference to CFTrees.
}
type
	CFTreeRef = ^SInt32; { an opaque 32-bit type }
	CFTreeRefPtr = ^CFTreeRef;

{!
        @function CFTreeGetTypeID
        Returns the type identifier of all CFTree instances.
}
function CFTreeGetTypeID: CFTypeID; external name '_CFTreeGetTypeID';

{!
        @function CFTreeCreate
        Creates a new mutable tree.
        @param allocator The CFAllocator which should be used to allocate
                memory for the tree and storage for its children.  This
                parameter may be NULL in which case the current default
                CFAllocator is used.  If this reference is not a valid
                CFAllocator, the behavior is undefined.
        @param context A C pointer to a CFTreeContext structure to be copied 
                and used as the context of the new tree.  The info parameter
                will be retained by the tree if a retain function is provided.
                If this value is not a valid C pointer to a CFTreeContext 
                structure-sized block of storage, the result is undefined. 
                If the version number of the storage is not a valid CFTreeContext
                version number, the result is undefined.
        @result A reference to the new CFTree.
}
function CFTreeCreate( allocator: CFAllocatorRef; const (*var*) context: CFTreeContext ): CFTreeRef; external name '_CFTreeCreate';

{!
        @function CFTreeGetParent
        Returns the parent of the specified tree.
        @param tree The tree to be queried.  If this parameter is not a valid
                CFTree, the behavior is undefined.
        @result The parent of the tree.
}
function CFTreeGetParent( tree: CFTreeRef ): CFTreeRef; external name '_CFTreeGetParent';

{!
        @function CFTreeGetNextSibling
        Returns the sibling after the specified tree in the parent tree's list.
        @param tree The tree to be queried.  If this parameter is not a valid
                CFTree, the behavior is undefined.
        @result The next sibling of the tree.
}
function CFTreeGetNextSibling( tree: CFTreeRef ): CFTreeRef; external name '_CFTreeGetNextSibling';

{!
        @function CFTreeGetFirstChild
        Returns the first child of the tree.
        @param tree The tree to be queried.  If this parameter is not a valid
                CFTree, the behavior is undefined.
        @result The first child of the tree.
}
function CFTreeGetFirstChild( tree: CFTreeRef ): CFTreeRef; external name '_CFTreeGetFirstChild';

{!
        @function CFTreeGetContext
        Returns the context of the specified tree.
        @param tree The tree to be queried.  If this parameter is not a valid
                CFTree, the behavior is undefined.
        @param context A C pointer to a CFTreeContext structure to be filled in with
                the context of the specified tree.  If this value is not a valid C
                pointer to a CFTreeContext structure-sized block of storage, the
                result is undefined.  If the version number of the storage is not
                a valid CFTreeContext version number, the result is undefined.
}
procedure CFTreeGetContext( tree: CFTreeRef; var context: CFTreeContext ); external name '_CFTreeGetContext';

{!
        @function CFTreeGetChildCount
        Returns the number of children of the specified tree.
        @param tree The tree to be queried.  If this parameter is not a valid
                CFTree, the behavior is undefined.
        @result The number of children.
}
function CFTreeGetChildCount( tree: CFTreeRef ): CFIndex; external name '_CFTreeGetChildCount';

{!
        @function CFTreeGetChildAtIndex
        Returns the nth child of the specified tree.
        @param tree The tree to be queried.  If this parameter is not a valid
                CFTree, the behavior is undefined.
        @param idx The index of the child tree to be returned.  If this parameter
                is less than zero or greater than the number of children of the
                tree, the result is undefined.
        @result A reference to the specified child tree.
}
function CFTreeGetChildAtIndex( tree: CFTreeRef; idx: CFIndex ): CFTreeRef; external name '_CFTreeGetChildAtIndex';

{!
        @function CFTreeGetChildren
        Fills the buffer with children from the tree.
        @param tree The tree to be queried.  If this parameter is not a valid
                CFTree, the behavior is undefined.
	@param children A C array of pointer-sized values to be filled with
		children from the tree.  If this parameter is not a valid pointer to a 
                C array of at least CFTreeGetChildCount() pointers, the behavior is undefined.
        @result A reference to the specified child tree.
}
procedure CFTreeGetChildren( tree: CFTreeRef; var children: CFTreeRef ); external name '_CFTreeGetChildren';

{!
	@function CFTreeApplyFunctionToChildren
	Calls a function once for each child of the tree.  Note that the applier
        only operates one level deep, and does not operate on descendents further
        removed than the immediate children of the tree.
        @param heap The tree to be operated upon.  If this parameter is not a
		valid CFTree, the behavior is undefined.
	@param applier The callback function to call once for each child of
		the given tree.  If this parameter is not a pointer to a 
                function of the correct prototype, the behavior is undefined.
                If there are values in the tree which the applier function does
                not expect or cannot properly apply to, the behavior is undefined.
	@param context A pointer-sized user-defined value, which is passed
		as the second parameter to the applier function, but is
		otherwise unused by this function.  If the context is not
		what is expected by the applier function, the behavior is
		undefined.
}
procedure CFTreeApplyFunctionToChildren( tree: CFTreeRef; applier: CFTreeApplierFunction; context: UnivPtr ); external name '_CFTreeApplyFunctionToChildren';

{!
        @function CFTreeFindRoot
        Returns the root tree of which the specified tree is a descendent.
        @param tree The tree to be queried.  If this parameter is not a valid
                CFTree, the behavior is undefined.
        @result A reference to the root of the tree.
}
function CFTreeFindRoot( tree: CFTreeRef ): CFTreeRef; external name '_CFTreeFindRoot';

{!
        @function CFTreeSetContext
        Replaces the context of a tree.  The tree releases its retain on the
        info of the previous context, and retains the info of the new context.
        @param tree The tree to be operated on.  If this parameter is not a valid
                CFTree, the behavior is undefined.
        @param context A C pointer to a CFTreeContext structure to be copied 
                and used as the context of the new tree.  The info parameter
                will be retained by the tree if a retain function is provided.
                If this value is not a valid C pointer to a CFTreeContext 
                structure-sized block of storage, the result is undefined. 
                If the version number of the storage is not a valid CFTreeContext
                version number, the result is undefined.
}
procedure CFTreeSetContext( tree: CFTreeRef; const (*var*) context: CFTreeContext ); external name '_CFTreeSetContext';

{!
        @function CFTreePrependChild
        Adds the newChild to the specified tree as the first in its list of children.
        @param tree The tree to be operated on.  If this parameter is not a valid
                CFTree, the behavior is undefined.
        @param newChild The child to be added.
                If this parameter is not a valid CFTree, the behavior is undefined.
                If this parameter is a tree which is already a child of any tree,
                the behavior is undefined.
}
procedure CFTreePrependChild( tree: CFTreeRef; newChild: CFTreeRef ); external name '_CFTreePrependChild';

{!
        @function CFTreeAppendChild
        Adds the newChild to the specified tree as the last in its list of children.
        @param tree The tree to be operated on.  If this parameter is not a valid
                CFTree, the behavior is undefined.
        @param newChild The child to be added.
                If this parameter is not a valid CFTree, the behavior is undefined.
                If this parameter is a tree which is already a child of any tree,
                the behavior is undefined.
}
procedure CFTreeAppendChild( tree: CFTreeRef; newChild: CFTreeRef ); external name '_CFTreeAppendChild';

{!
        @function CFTreeInsertSibling
        Inserts newSibling into the the parent tree's linked list of children after
        tree.  The newSibling will have the same parent as tree.
        @param tree The tree to insert newSibling after.  If this parameter is not a valid
                CFTree, the behavior is undefined.  If the tree does not have a
                parent, the behavior is undefined.
        @param newSibling The sibling to be added.
                If this parameter is not a valid CFTree, the behavior is undefined.
                If this parameter is a tree which is already a child of any tree,
                the behavior is undefined.  
}
procedure CFTreeInsertSibling( tree: CFTreeRef; newSibling: CFTreeRef ); external name '_CFTreeInsertSibling';

{!
        @function CFTreeRemove
        Removes the tree from its parent.
        @param tree The tree to be removed.  If this parameter is not a valid
                CFTree, the behavior is undefined.
}
procedure CFTreeRemove( tree: CFTreeRef ); external name '_CFTreeRemove';

{!
        @function CFTreeRemoveAllChildren
        Removes all the children of the tree.
        @param tree The tree to remove all children from.  If this parameter is not a valid
                CFTree, the behavior is undefined.
}
procedure CFTreeRemoveAllChildren( tree: CFTreeRef ); external name '_CFTreeRemoveAllChildren';

{!
        @function CFTreeSortChildren
        Sorts the children of the specified tree using the specified comparator function.
        @param tree The tree to be operated on.  If this parameter is not a valid
                CFTree, the behavior is undefined.
	@param comparator The function with the comparator function type
		signature which is used in the sort operation to compare
		children of the tree with the given value. If this parameter
		is not a pointer to a function of the correct prototype, the
		the behavior is undefined. The children of the tree are sorted 
                from least to greatest according to this function.
	@param context A pointer-sized user-defined value, which is passed
		as the third parameter to the comparator function, but is
		otherwise unused by this function. If the context is not
		what is expected by the comparator function, the behavior is
		undefined.
}
procedure CFTreeSortChildren( tree: CFTreeRef; comparator: CFComparatorFunction; context: UnivPtr ); external name '_CFTreeSortChildren';


{unit CGBase}
{ CoreGraphics - CGBase.h
 * Copyright (c) 2000 Apple Computer, Inc.
 * All rights reserved.
 }
{       Pascal Translation Updated:  Peter N Lewis, <peter@stairways.com.au>, August 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}


type
	size_t								= UInt32;
	boolean_t							= SInt32;

// Avoid cyclic dependencises by putting CGRefs here

type
	CGColorRef = ^SInt32; { an opaque 32-bit type }
	CGPatternRef = ^SInt32; { an opaque 32-bit type }
	CGPDFStringRef = ^SInt32; { an opaque 32-bit type }
	CGPDFStreamRef = ^SInt32; { an opaque 32-bit type }
	CGPDFScannerRef = ^SInt32; { an opaque 32-bit type }
	CGPDFContentStreamRef = ^SInt32; { an opaque 32-bit type }
	CGPDFOperatorTableRef = ^SInt32; { an opaque 32-bit type }
	CGPDFPageRef = ^SInt32; { an opaque 32-bit type }
	CGPDFDictionaryRef = ^SInt32; { an opaque 32-bit type }
	CGPDFArrayRef = ^SInt32; { an opaque 32-bit type }
	CGPSConverterRef = ^SInt32; { an opaque 32-bit type }

{unit CGErrors}
{
 *  CGError.h
 *  CoreGraphics
 *
 *  Copyright (c) 2000 Apple Computer, Inc. All rights reserved.
 *
 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}


{ Types used for error and error handler }
type
	CGError 					= SInt32;
const
	kCGErrorSuccess = 0;
	kCGErrorFirst = 1000;
	kCGErrorFailure = kCGErrorFirst;
	kCGErrorIllegalArgument = 1001;
	kCGErrorInvalidConnection = 1002;
	kCGErrorInvalidContext = 1003;
	kCGErrorCannotComplete = 1004;
	kCGErrorNameTooLong = 1005;
	kCGErrorNotImplemented = 1006;
	kCGErrorRangeCheck = 1007;
	kCGErrorTypeCheck = 1008;
	kCGErrorNoCurrentPoint = 1009;
	kCGErrorInvalidOperation = 1010;
	kCGErrorNoneAvailable = 1011;
    {	internal errors have taken 1012, 1013, and 1014 }

	kCGErrorApplicationRequiresNewerSystem = 1015;
		{	the application being launched says in it's bundle info that it requires a }
		{	newer version of the system than is currently running. }
	
	kCGErrorApplicationNotPermittedToExecute = 1016;
		{	Macintosh Manager is active, and this application is not permitted to run }
	
	kCGErrorApplicationIncorrectExecutableFormatFound = 1023;
		{	the application being launched does not have any executable code for the }
		{	current system. }
	
	kCGErrorApplicationIsLaunching = 1024;
		{ The application is in the process of launching, but hasn't checked in yet.
		   Any launch data provided will be given to the application when it does
		   check in. }
	
	kCGErrorApplicationAlreadyRunning = 1025;
		{	The application being launched was already running ( and had already checked
		    in ) and so any launch data provided can not be delivered to in by CPS }

	kCGErrorApplicationCanOnlyBeRunInOneSessionAtATime = 1026;
		{	The application being launched is incompatible with multiple user sessions,
			and is already running in another session by another user. }
			
	kCGErrorClassicApplicationsMustBeLaunchedByClassic = 1027;
		{	To avoid deadlock, Classic can't launch another Classic application by going
			thru CPS.  This error gets returned in that case, and it signals TruBlueEnvironment
			that it must handle this launch on its own. }

	kCGErrorForkFailed = 1028;
		{	CPS was unable to fork a new process in order to launch an application. }

	kCGErrorLast = kCGErrorForkFailed;


{unit CGFunction}
{ CoreGraphics - CGFunction.h
 * Copyright (c) 1999-2002 Apple Computer, Inc. (unpublished)
 * All rights reserved.
 }
{       Pascal Translation:  Peter N Lewis, <peter@stairways.com.au>, August 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}


{! @header CGFunction
 *   A general floating-point function evaluator, using a callback mapping
 *   an arbitrary number of float inputs to an arbitrary number of float
 *   outputs.
 }

type
	CGFunctionRef = ^SInt32; { an opaque 32-bit type }


{! @typedef CGFunctionEvaluateCallback
 *   This callback evaluates a function, using <tt>in</tt> as inputs, and
 *   places the result in <tt>out</tt>.
 *
 * @param info
 *   The info parameter passed to CGFunctionCreate.
 *
 * @param inData
 *   An array of <tt>domainDimension</tt> floats.
 *
 * @param outData
 *   An array of <tt>rangeDimension</tt> floats.
 }

type
	CGFunctionEvaluateCallback = procedure( info: UnivPtr; inp: {const} Float32Ptr; out: Float32Ptr );

{! @typedef CGFunctionReleaseInfoCallback
 *   This callback releases the info parameter passed to the CGFunction
 *   creation functions when the function is deallocated.
 *
 * @param info
 *   The info parameter passed to CGFunctionCreate.
 }

type
	CGFunctionReleaseInfoCallback = procedure( info: UnivPtr );

{! @typedef CGFunctionCallbacks
 *   Structure containing the callbacks of a CGFunction.
 *
 * @field version
 *   The version number of the structure passed to the CGFunction creation
 *   functions. This structure is version 0.
 *
 * @field evaluate
 *   The callback used to evaluate the function.
 *
 * @field releaseInfo
 *   If non-NULL, the callback used to release the info parameter passed to
 *   the CGFunction creation functions when the function is deallocated.
 }

type
	CGFunctionCallbacks = record
		version: UInt32;
		evaluate: CGFunctionEvaluateCallback;
		releaseInfo: CGFunctionReleaseInfoCallback;
	end;


{! @function CGFunctionGetTypeID
 *   Return the CFTypeID for CGFunctionRefs.
 }

function CGFunctionGetTypeID: CFTypeID; external name '_CGFunctionGetTypeID'; (* AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER *)

{! @function CGFunctionCreate
 *   Create a function.
 *
 * @param info
 *   The parameter passed to the callback functions.
 *
 * @param domainDimension
 *   The number of inputs to the function.
 *
 * @param domain
 *   An array of <tt>2*domainDimension</tt> floats used to specify the
 *   valid intervals of input values.  For each <tt>k</tt> from <tt>0</tt>
 *   to <tt>domainDimension - 1</tt>, <tt>domain[2*k]</tt> must be less
 *   than or equal to <tt>domain[2*k+1]</tt>, and the <tt>k</tt>'th input
 *   value <tt>in[k]</tt> will be clipped to lie in the interval
 *   <tt>domain[2*k] <= in[k] <= domain[2*k+1]</tt>.  If this parameter is
 *   NULL, then the input values are not clipped.  However, it's strongly
 *   recommended that this parameter be specified; each domain interval
 *   should specify reasonable values for the minimum and maximum in each
 *   dimension.
 *
 * @param rangeDimension
 *   The number of outputs from the function.
 *
 * @param range
 *   An array of <tt>2*rangeDimension</tt> floats used to specify the valid
 *   intervals of output values.  For each <tt>k</tt> from <tt>0</tt> to
 *   <tt>rangeDimension - 1</tt>, <tt>range[2*k]</tt> must be less than or
 *   equal to <tt>range[2*k+1]</tt>, and the <tt>k</tt>'th output value
 *   <tt>out[k]</tt> will be clipped to lie in the interval <tt>range[2*k]
 *   <= out[k] <= range[2*k+1]</tt>.  If this parameter is NULL, then the
 *   output values are not clipped.  However, it's strongly recommended
 *   that this parameter be specified; each range interval should specify
 *   reasonable values for the minimum and maximum in each dimension.
 *
 * @param callbacks
 *   A pointer to a CGFunctionCallbacks structure.  The function uses these
 *   callbacks to evaluate values.  The contents of the callbacks structure
 *   is copied, so, for example, a pointer to a structure on the stack can
 *   be passed in.  }

function CGFunctionCreate( info: UnivPtr; domainDimension: size_t; domain: {const} Float32Ptr; rangeDimension: size_t; range: {const} Float32Ptr; const (*var*) callbacks: CGFunctionCallbacks ): CGFunctionRef; external name '_CGFunctionCreate'; (* AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER *)

{! @function CGFunctionRetain
 *
 * Equivalent to <tt>CFRetain(function)</tt>.
 }

function CGFunctionRetain( func: CGFunctionRef ): CGFunctionRef; external name '_CGFunctionRetain'; (* AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER *)

{! @function CGFunctionRelease
 *
 * Equivalent to <tt>CFRelease(function)</tt>.
 }

procedure CGFunctionRelease( func: CGFunctionRef ); external name '_CGFunctionRelease'; (* AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER *)


{unit CGGeometry}
{ CoreGraphics - CGGeometry.h
 * Copyright (c) 1998-2003 Apple Computer, Inc.
 * All rights reserved.
 }
{       Pascal Translation Updated:  Peter N Lewis, <peter@stairways.com.au>, August 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}


{ Points. }

type
	CGPointPtr = ^CGPoint;
	CGPoint = record
		x: Float32;
		y: Float32;
	end;

{ Sizes. }

type
	CGSizePtr = ^CGSize;
	CGSize = record
		width: Float32;
		height: Float32;
	end;

{ Rectangles. }

type
	CGRectPtr = ^CGRect;
	CGRect = record
		origin: CGPoint;
		size: CGSize;
	end;

{ Rectangle edges. }

type
	CGRectEdge = SInt32;
const
	CGRectMinXEdge = 0;
	CGRectMinYEdge = 1;
	CGRectMaxXEdge = 2;
	CGRectMaxYEdge = 3;

{ The "zero" point -- equivalent to CGPointMake(0, 0). } 

var CGPointZero: CGPoint; external name '_CGPointZero'; (* attribute const *)

{ The "zero" size -- equivalent to CGSizeMake(0, 0). } 

var CGSizeZero: CGSize; external name '_CGSizeZero'; (* attribute const *)

{ The "zero" rectangle -- equivalent to CGRectMake(0, 0, 0, 0). } 

var CGRectZero: CGRect; external name '_CGRectZero'; (* attribute const *)

{ The "empty" rect.  This is the rectangle returned when, for example, we
 * intersect two disjoint rectangles.  Note that the null rect is not the
 * same as the zero rect. }

var CGRectNull: CGRect; external name '_CGRectNull'; (* attribute const *)

{ The infinite rectangle. }

var CGRectInfinite: CGRect; external name '_CGRectInfinite'; (* attribute const *) (* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)

{ Make a point from `(x, y)'. }
// CG_INLINE CGPoint CGPointMake(float x, float y);

{ Make a size from `(width, height)'. }
// CG_INLINE CGSize CGSizeMake(float width, float height);

{ Make a rect from `(x, y; width, height)'. }
// CG_INLINE CGRect CGRectMake(float x, float y, float width, float height);

{ Return the leftmost x-value of `rect'. }

function CGRectGetMinX( rect: CGRect ): Float32; external name '_CGRectGetMinX';

{ Return the midpoint x-value of `rect'. }

function CGRectGetMidX( rect: CGRect ): Float32; external name '_CGRectGetMidX';

{ Return the rightmost x-value of `rect'. }

function CGRectGetMaxX( rect: CGRect ): Float32; external name '_CGRectGetMaxX';

{ Return the bottommost y-value of `rect'. }

function CGRectGetMinY( rect: CGRect ): Float32; external name '_CGRectGetMinY';

{ Return the midpoint y-value of `rect'. }

function CGRectGetMidY( rect: CGRect ): Float32; external name '_CGRectGetMidY';

{ Return the topmost y-value of `rect'. }

function CGRectGetMaxY( rect: CGRect ): Float32; external name '_CGRectGetMaxY';

{ Return the width of `rect'. }

function CGRectGetWidth( rect: CGRect ): Float32; external name '_CGRectGetWidth';

{ Return the height of `rect'. }

function CGRectGetHeight( rect: CGRect ): Float32; external name '_CGRectGetHeight';

{ Return 1 if `point1' and `point2' are the same, 0 otherwise. }

function CGPointEqualToPoint( point1: CGPoint; point2: CGPoint ): SInt32; external name '_CGPointEqualToPoint';

{ Return 1 if `size1' and `size2' are the same, 0 otherwise. }

function CGSizeEqualToSize( size1: CGSize; size2: CGSize ): SInt32; external name '_CGSizeEqualToSize';

{ Return 1 if `rect1' and `rect2' are the same, 0 otherwise. }

function CGRectEqualToRect( rect1: CGRect; rect2: CGRect ): SInt32; external name '_CGRectEqualToRect';

{ Standardize `rect' -- i.e., convert it to an equivalent rect which has
 * positive width and height. }

function CGRectStandardize( rect: CGRect ): CGRect; external name '_CGRectStandardize';

{ Return 1 if `rect' is empty -- i.e., if it has zero width or height.  A
 * null rect is defined to be empty. }

function CGRectIsEmpty( rect: CGRect ): SInt32; external name '_CGRectIsEmpty';

{ Return 1 if `rect' is null -- e.g., the result of intersecting two
 * disjoint rectangles is a null rect. }

function CGRectIsNull( rect: CGRect ): SInt32; external name '_CGRectIsNull';

{ Return true if `rect' is the infinite rectangle, false otherwise. }

function CGRectIsInfinite( rect: CGRect ): CBool; external name '_CGRectIsInfinite'; (* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)

{ Inset `rect' by `(dx, dy)' -- i.e., offset its origin by `(dx, dy)', and
 * decrease its size by `(2*dx, 2*dy)'. }

function CGRectInset( rect: CGRect; dx: Float32; dy: Float32 ): CGRect; external name '_CGRectInset';

{ Expand `rect' to the smallest rect containing it with integral origin
 * and size. }

function CGRectIntegral( rect: CGRect ): CGRect; external name '_CGRectIntegral';

{ Return the union of `r1' and `r2'. }

function CGRectUnion( r1: CGRect; r2: CGRect ): CGRect; external name '_CGRectUnion';

{ Return the intersection of `r1' and `r2'.  This may return a null
 * rect. }

function CGRectIntersection( r1: CGRect; r2: CGRect ): CGRect; external name '_CGRectIntersection';

{ Offset `rect' by `(dx, dy)'. }

function CGRectOffset( rect: CGRect; dx: Float32; dy: Float32 ): CGRect; external name '_CGRectOffset';

{ Make two new rectangles, `slice' and `remainder', by dividing `rect'
 * with a line that's parallel to one of its sides, specified by `edge' --
 * either `CGRectMinXEdge', `CGRectMinYEdge', `CGRectMaxXEdge', or
 * `CGRectMaxYEdge'.  The size of `slice' is determined by `amount', which
 * measures the distance from the specified edge. }

procedure CGRectDivide( rect: CGRect; var slice: CGRect; var remainder: CGRect; amount: Float32; edge: CGRectEdge ); external name '_CGRectDivide';

{ Return 1 if `point' is contained in `rect', 0 otherwise. }

function CGRectContainsPoint( rect: CGRect; point: CGPoint ): SInt32; external name '_CGRectContainsPoint';

{ Return 1 if `rect2' is contained in `rect1', 0 otherwise.  `rect2' is
 * contained in `rect1' if the union of `rect1' and `rect2' is equal to
 * `rect1'. }

function CGRectContainsRect( rect1: CGRect; rect2: CGRect ): SInt32; external name '_CGRectContainsRect';

{ Return 1 if `rect1' intersects `rect2', 0 otherwise.  `rect1' intersects
 * `rect2' if the intersection of `rect1' and `rect2' is not the null
 * rect. }

function CGRectIntersectsRect( rect1: CGRect; rect2: CGRect ): SInt32; external name '_CGRectIntersectsRect';

(*
{** Definitions of inline functions. **}
// CG_INLINE CGPoint CGPointMake(float x, float y)
{
    CGPoint p; p.x = x; p.y = y; return p;
}
// CG_INLINE CGSize CGSizeMake(float width, float height)
{
    CGSize size; size.width = width; size.height = height; return size;
}
// CG_INLINE CGRect CGRectMake(float x, float y, float width, float height)
{
    CGRect rect;
    rect.origin.x = x; rect.origin.y = y;
    rect.size.width = width; rect.size.height = height;
    return rect;
}
*)

{unit CGPDFObject}
{ CoreGraphics - CGPDFObject.h
 * Copyright (c) 2002-2004 Apple Computer, Inc.
 * All rights reserved.
 }
{       Pascal Translation:  Peter N Lewis, <peter@stairways.com.au>, August 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}


{ A type for boolean values. }

type
	CGPDFBoolean = UInt8;

{ A type for integer values. }

type
	CGPDFInteger = SInt32;

{ A type for real values. }

type
	CGPDFReal = Float32;

{ A type to hold any object. }

type
	CGPDFObjectRef = ^SInt32; { an opaque 32-bit type }

{ An identifier to describe an object's type. }

type
	CGPDFObjectType = SInt32;
const
	kCGPDFObjectTypeNull = 1;
	kCGPDFObjectTypeBoolean = 2;
	kCGPDFObjectTypeInteger = 3;
	kCGPDFObjectTypeReal = 4;
	kCGPDFObjectTypeName = 5;
	kCGPDFObjectTypeString = 6;
	kCGPDFObjectTypeArray = 7;
	kCGPDFObjectTypeDictionary = 8;
	kCGPDFObjectTypeStream = 9;


{ Return the type of `object'. }

function CGPDFObjectGetType( objct: CGPDFObjectRef ): CGPDFObjectType; external name '_CGPDFObjectGetType'; (* AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER *)

{ Get the value of `object'.  If the type of `object' is equal to `type',
 * then copy the value of `object' to `value' (if it's non-NULL) and return
 * true.  Otherwise, if the type of `object' is `kCGPDFObjectTypeInteger'
 * and `type' is equal to `kCGPDFObjectTypeReal', then convert the value of
 * `object' to floating point and copy the result to `value' (if it's
 * non-NULL) and return true. Otherwise, return false. }

function CGPDFObjectGetValue( objct: CGPDFObjectRef; typ: CGPDFObjectType; value: UnivPtr ): CBool; external name '_CGPDFObjectGetValue'; (* AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER *)


{unit CGPDFOperatorTable}
{ CoreGraphics - CGPDFOperatorTable.h
 * Copyright (c) 2004 Apple Computer, Inc.
 * All rights reserved.
 }
{       Pascal Translation:  Peter N Lewis, <peter@stairways.com.au>, August 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}


// CGPDFOperatorTableRef defined in CGBase


type
	CGPDFOperatorCallback = procedure( scanner: CGPDFScannerRef; info: UnivPtr );


{ Return an empty operator table. }

function CGPDFOperatorTableCreate: CGPDFOperatorTableRef; external name '_CGPDFOperatorTableCreate'; (* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)

{ Increment the retain count of `table'. }

function CGPDFOperatorTableRetain( table: CGPDFOperatorTableRef ): CGPDFOperatorTableRef; external name '_CGPDFOperatorTableRetain'; (* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)

{ Decrement the retain count of `table'. }

procedure CGPDFOperatorTableRelease( table: CGPDFOperatorTableRef ); external name '_CGPDFOperatorTableRelease'; (* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)

{ Set the callback for the operator named `name' to `callback' }

procedure CGPDFOperatorTableSetCallback( table: CGPDFOperatorTableRef; name: ConstCStringPtr; callback: CGPDFOperatorCallback ); external name '_CGPDFOperatorTableSetCallback'; (* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)


{unit CGPDFScanner}
{ CoreGraphics - CGPDFScanner.h
 * Copyright (c) 2004 Apple Computer, Inc.
 * All rights reserved.
 }
{       Pascal Translation:  Peter N Lewis, <peter@stairways.com.au>, August 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}


// CGPDFScannerRef defined in CGBase


{ Create a scanner. }

function CGPDFScannerCreate( cs: CGPDFContentStreamRef; table: CGPDFOperatorTableRef; info: UnivPtr ): CGPDFScannerRef; external name '_CGPDFScannerCreate'; (* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)

{ Retain `scanner'. }

function CGPDFScannerRetain( scanner: CGPDFScannerRef ): CGPDFScannerRef; external name '_CGPDFScannerRetain'; (* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)

{ Release `scanner'. }

procedure CGPDFScannerRelease( scanner: CGPDFScannerRef ); external name '_CGPDFScannerRelease'; (* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)

{ Scan the content stream of `scanner'. Returns true if the entire stream
 * was scanned successfully; false if scanning failed for some reason (for
 * example, if the stream's data is corrupted). }

function CGPDFScannerScan( scanner: CGPDFScannerRef ): CBool; external name '_CGPDFScannerScan'; (* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)

{ Return the content stream associated with `scanner'. }

function CGPDFScannerGetContentStream( scanner: CGPDFScannerRef ): CGPDFContentStreamRef; external name '_CGPDFScannerGetContentStream'; (* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)

{ Pop an object from the stack of `scanner' and return it in `value'. }

function CGPDFScannerPopObject( scanner: CGPDFScannerRef; var value: CGPDFObjectRef ): CBool; external name '_CGPDFScannerPopObject'; (* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)

{ Pop an object from the stack of `scanner' and, if it's a boolean, return
 * it in `value'. Return false if the top of the stack isn't a boolean. }

function CGPDFScannerPopBoolean( scanner: CGPDFScannerRef; var value: CGPDFBoolean ): CBool; external name '_CGPDFScannerPopBoolean'; (* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)

{ Pop an object from the stack of `scanner' and, if it's an integer,
 * return it in `value'. Return false if the top of the stack isn't an
 * integer. }

function CGPDFScannerPopInteger( scanner: CGPDFScannerRef; var value: CGPDFInteger ): CBool; external name '_CGPDFScannerPopInteger'; (* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)

{ Pop an object from the stack of `scanner' and, if it's a number, return
 * it in `value'. Return false if the top of the stack isn't a number. }

function CGPDFScannerPopNumber( scanner: CGPDFScannerRef; var value: CGPDFReal ): CBool; external name '_CGPDFScannerPopNumber'; (* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)

{ Pop an object from the stack of `scanner' and, if it's a name, return it
 * in `value'. Return false if the top of the stack isn't a name. }

function CGPDFScannerPopName( scanner: CGPDFScannerRef; var value: ConstCStringPtr ): CBool; external name '_CGPDFScannerPopName'; (* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)

{ Pop an object from the stack of `scanner' and, if it's a string, return
 * it in `value'. Return false if the top of the stack isn't a string. }

function CGPDFScannerPopString( scanner: CGPDFScannerRef; var value: CGPDFStringRef ): CBool; external name '_CGPDFScannerPopString'; (* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)

{ Pop an object from the stack of `scanner' and, if it's an array, return
 * it in `value'. Return false if the top of the stack isn't an array. }

function CGPDFScannerPopArray( scanner: CGPDFScannerRef; var value: CGPDFArrayRef ): CBool; external name '_CGPDFScannerPopArray'; (* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)

{ Pop an object from the stack of `scanner' and, if it's a dictionary,
 * return it in `value'. Return false if the top of the stack isn't a
 * dictionary. }

function CGPDFScannerPopDictionary( scanner: CGPDFScannerRef; var value: CGPDFDictionaryRef ): CBool; external name '_CGPDFScannerPopDictionary'; (* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)

{ Pop an object from the stack of `scanner' and, if it's a stream, return
 * it in `value'. Return false if the top of the stack isn't a stream. }

function CGPDFScannerPopStream( scanner: CGPDFScannerRef; var value: CGPDFStreamRef ): CBool; external name '_CGPDFScannerPopStream'; (* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)


{unit CGPDFStream}
{ CoreGraphics - CGPDFStream.h
 * Copyright (c) 2002-2004 Apple Computer, Inc.
 * All rights reserved.
 }
{       Pascal Translation:  Peter N Lewis, <peter@stairways.com.au>, August 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}


// CGPDFStreamRef defined in CGBase

type
	CGPDFDataFormat = SInt32;
const
	CGPDFDataFormatRaw = 0;	CGPDFDataFormatJPEGEncoded = 1;	CGPDFDataFormatJPEG2000 = 2;


{ Return the dictionary of `stream'. }

function CGPDFStreamGetDictionary( stream: CGPDFStreamRef ): CGPDFDictionaryRef; external name '_CGPDFStreamGetDictionary'; (* AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER *)

{ Return the data of `stream'. }

function CGPDFStreamCopyData( stream: CGPDFStreamRef; var format: CGPDFDataFormat ): CFDataRef; external name '_CGPDFStreamCopyData'; (* AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER *)


{unit CGPDFString}
{ CoreGraphics - CGPDFString.h
 * Copyright (c) 2002-2004 Apple Computer, Inc.
 * All rights reserved.
 }
{       Pascal Translation:  Peter N Lewis, <peter@stairways.com.au>, August 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}


// CGPDFStringRef defined in CGBase


{ Return the length of `string'. }

function CGPDFStringGetLength( strng: CGPDFStringRef ): size_t; external name '_CGPDFStringGetLength'; (* AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER *)

{ Return a pointer to the bytes of `string'. }

function CGPDFStringGetBytePtr( strng: CGPDFStringRef ): UInt8Ptr; external name '_CGPDFStringGetBytePtr'; (* AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER *)

{ Return a CFString representing `string' as a "text string".  See Section
 * 3.8.1 "Text Strings", PDF Reference: Adobe PDF version 1.4 (3rd ed.)
 * for more information. }

function CGPDFStringCopyTextString( strng: CGPDFStringRef ): CFStringRef; external name '_CGPDFStringCopyTextString'; (* AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER *)

{ Convert `string' to a CFDate.  See Section 3.8.3 "Dates", PDF Reference:
 * Adobe PDF version 1.4 (3rd ed.)  for more information. }

function CGPDFStringCopyDate( strng: CGPDFStringRef ): CFDateRef; external name '_CGPDFStringCopyDate'; (* AVAILABLE_MAC_OS_X_VERSION_10_4_AND_LATER *)


{unit CGSession}
{
 *  CGSession.h
 *  CoreGraphics
 *
 *  Copyright (c) 2003 Apple Computer, Inc. All rights reserved.
 *
 }
{       Pascal Translation:  Peter N Lewis, <peter@stairways.com.au>, August 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}


{
 * Fetch the current session's dictionary
 * Returns NULL if the caller is not within a GUI session, as when the caller is a UNIX daemon,
 * or if a system is configured to not run a Quartz GUI (window server disabled)
 }
function CGSessionCopyCurrentDictionary: CFDictionaryRef; external name '_CGSessionCopyCurrentDictionary';

{
 * Predefined keys for the Session dictionaries
 * Values are provided as CFSTR() macros rather than extern C data for PEF/CFM support.
 * Constant values will remain unchanged in future releases for PEF/CFM compatibility.
 *
 * These keys are guaranteed by the system to be present in a session dictionary.
 * Additional keys and values may be defined and added to the dictionary by
 * other system components as needed.
 }
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kCGSessionUserIDKey CFSTRP('kCGSSessionUserIDKey')}
{$endc}
        { value is a CFNumber encoding a uid_t for the session's current user. }

{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kCGSessionUserNameKey CFSTRP('kCGSSessionUserNameKey')}
{$endc}
        { value is a CFString encoding the session's short user name as set by loginwindow }

{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kCGSessionConsoleSetKey CFSTRP('kCGSSessionConsoleSetKey')}
{$endc}
        { value is a CFNumber encoding a 32 bit unsigned  integer value representing a set of hardware composing a console }

{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kCGSessionOnConsoleKey CFSTRP('kCGSSessionOnConsoleKey')}
{$endc}
        { value is a CFBoolean, kCFBooleanTrue if the session is on a console, otherwise kCFBooleanFalse }

{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kCGSessionLoginDoneKey CFSTRP('kCGSessionLoginDoneKey')}
{$endc}
        { value is a CFBoolean, kCFBooleanTrue if login operation has been done, otherwise kCFBooleanFalse }

{
 * When the GUI session on a console changes, a notification
 * is posted via the notify_post() API.  See notify (3) and
 * notify.h for details.
 }
const
	kCGNotifyGUIConsoleSessionChanged = 'com.apple.coregraphics.GUIConsoleSessionChanged';
{ When a user logs in or out of a session we post a notification via notify_post() }
const
	kCGNotifyGUISessionUserChanged = 'com.apple.coregraphics.GUISessionUserChanged';


{unit CGWindowLevels}
{
 *  CGWindowLevel.h
 *  CoreGraphics
 *
 *  Copyright (c) 2000 Apple Computer, Inc. All rights reserved.
 *
 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN POWER}


{
 * Windows may be assigned to a particular level. When assigned to a level,
 * the window is ordered relative to all other windows in that level.
 * Windows with a higher level are sorted in front of windows with a lower
 * level.
 *
 * A common set of window levels is defined here for use within higher
 * level frameworks.  The levels are accessed via a key and function,
 * so that levels may be changed or adjusted in future releases without
 * breaking binary compatability.
 }

type
	CGWindowLevel = SInt32;
type
	CGWindowLevelKey = SInt32;

type
	_CGCommonWindowLevelKey = SInt32;
const
	kCGBaseWindowLevelKey = 0;
	kCGMinimumWindowLevelKey = 1;
	kCGDesktopWindowLevelKey = 2;
	kCGBackstopMenuLevelKey = 3;
	kCGNormalWindowLevelKey = 4;
	kCGFloatingWindowLevelKey = 5;
	kCGTornOffMenuWindowLevelKey = 6;
	kCGDockWindowLevelKey = 7;
	kCGMainMenuWindowLevelKey = 8;
	kCGStatusWindowLevelKey = 9;
	kCGModalPanelWindowLevelKey = 10;
	kCGPopUpMenuWindowLevelKey = 11;
	kCGDraggingWindowLevelKey = 12;
	kCGScreenSaverWindowLevelKey = 13;
	kCGMaximumWindowLevelKey = 14;
	kCGOverlayWindowLevelKey = 15;
	kCGHelpWindowLevelKey = 16;
	kCGUtilityWindowLevelKey = 17;
	kCGDesktopIconWindowLevelKey = 18;
	kCGCursorWindowLevelKey = 19;
	kCGAssistiveTechHighWindowLevelKey = 20;
	kCGNumberOfWindowLevelKeys = 21;	{ Internal bookkeeping; must be last }

function CGWindowLevelForKey( key: CGWindowLevelKey ): CGWindowLevel; external name '_CGWindowLevelForKey';

{ number of levels above kCGMaximumWindowLevel reserved for internal use }
const
	kCGNumReservedWindowLevels = 16;

(*
{ Definitions of older constant values as calls }
#define kCGBaseWindowLevel		CGWindowLevelForKey(kCGBaseWindowLevelKey)	{ LONG_MIN }
#define kCGMinimumWindowLevel 		CGWindowLevelForKey(kCGMinimumWindowLevelKey)	{ (kCGBaseWindowLevel + 1) }
#define kCGDesktopWindowLevel		CGWindowLevelForKey(kCGDesktopWindowLevelKey)	{ kCGMinimumWindowLevel }
#define kCGDesktopIconWindowLevel		CGWindowLevelForKey(kCGDesktopIconWindowLevelKey)	{ kCGMinimumWindowLevel + 20 }
#define kCGBackstopMenuLevel		CGWindowLevelForKey(kCGBackstopMenuLevelKey)	{ -20 }
#define kCGNormalWindowLevel		CGWindowLevelForKey(kCGNormalWindowLevelKey)	{ 0 }
#define kCGFloatingWindowLevel		CGWindowLevelForKey(kCGFloatingWindowLevelKey)	{ 3 }
#define kCGTornOffMenuWindowLevel	CGWindowLevelForKey(kCGTornOffMenuWindowLevelKey)	{ 3 }
#define kCGDockWindowLevel		CGWindowLevelForKey(kCGDockWindowLevelKey)	{ 20 }
#define kCGMainMenuWindowLevel		CGWindowLevelForKey(kCGMainMenuWindowLevelKey)	{ 24 }
#define kCGStatusWindowLevel		CGWindowLevelForKey(kCGStatusWindowLevelKey)	{ 25 }
#define kCGModalPanelWindowLevel	CGWindowLevelForKey(kCGModalPanelWindowLevelKey)	{ 8 }
#define kCGPopUpMenuWindowLevel		CGWindowLevelForKey(kCGPopUpMenuWindowLevelKey)	{ 101 }
#define kCGDraggingWindowLevel		CGWindowLevelForKey(kCGDraggingWindowLevelKey)	{ 500 }
#define kCGScreenSaverWindowLevel	CGWindowLevelForKey(kCGScreenSaverWindowLevelKey)	{ 1000 }
#define kCGCursorWindowLevel		CGWindowLevelForKey(kCGCursorWindowLevelKey)	{ 2000 }
#define kCGOverlayWindowLevel		CGWindowLevelForKey(kCGOverlayWindowLevelKey)	{ 102 }
#define kCGHelpWindowLevel		CGWindowLevelForKey(kCGHelpWindowLevelKey)	{ 102 }
#define kCGUtilityWindowLevel		CGWindowLevelForKey(kCGUtilityWindowLevelKey)	{ 19 }

#define kCGAssistiveTechHighWindowLevel		CGWindowLevelForKey(kCGAssistiveTechHighWindowLevelKey)	{ 1500 }

#define kCGMaximumWindowLevel 		CGWindowLevelForKey(kCGMaximumWindowLevelKey)	{ LONG_MAX - kCGNumReservedWindowLevels }
*)

{unit CMICCProfile}
{
     File:       CMICCProfile.p
 
     Contains:   ICC Profile Format Definitions
 
     Version:    Technology: ColorSync 2.5
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   1994-2002 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}

{ ICC Profile version constants  }

const
	cmICCProfileVersion2		= $02000000;
	cmICCProfileVersion21		= $02100000;
	cmCS2ProfileVersion			= $02000000;
	cmCS1ProfileVersion			= $00000100;					{  ColorSync 1.0 profile version  }

	{	 Current Major version number 	}
	cmProfileMajorVersionMask	= $FF000000;
	cmCurrentProfileMajorVersion = $02000000;

	{	 magic cookie number for anonymous file ID 	}
	cmMagicNumber				= $61637370 (* 'acsp' *);


	{	**********************************************************************	}
	{	************** ColorSync 2.0 profile specification *******************	}
	{	**********************************************************************	}
	{	*** flags field  ***	}
	cmICCReservedFlagsMask		= $0000FFFF;					{  these bits of the flags field are defined and reserved by ICC  }
	cmEmbeddedMask				= $00000001;					{  if bit 0 is 0 then not embedded profile, if 1 then embedded profile  }
	cmEmbeddedUseMask			= $00000002;					{  if bit 1 is 0 then ok to use anywhere, if 1 then ok to use as embedded profile only  }
	cmCMSReservedFlagsMask		= $FFFF0000;					{  these bits of the flags field are defined and reserved by CMS vendor  }
	cmQualityMask				= $00030000;					{  if bits 16-17 is 0 then normal, if 1 then draft, if 2 then best  }
	cmInterpolationMask			= $00040000;					{  if bit 18 is 0 then interpolation, if 1 then lookup only  }
	cmGamutCheckingMask			= $00080000;					{  if bit 19 is 0 then create gamut checking info, if 1 then no gamut checking info  }

	{	 copyright-protection flag options 	}
	cmEmbeddedProfile			= 0;							{  0 is not embedded profile, 1 is embedded profile  }
	cmEmbeddedUse				= 1;							{  0 is to use anywhere, 1 is to use as embedded profile only  }

	{	 speed and quality flag options 	}
	cmNormalMode				= 0;							{  it uses the least significent two bits in the high word of flag  }
	cmDraftMode					= 1;							{  it should be evaulated like this: right shift 16 bits first, mask off the  }
	cmBestMode					= 2;							{  high 14 bits, and then compare with the enum to determine the option value  }


	{	*** deviceAttributes fields ***	}
	{	 deviceAttributes[0] is defined by and reserved for device vendors 	}
	{	 deviceAttributes[1] is defined by and reserved for ICC 	}
	{	 The following bits of deviceAttributes[1] are currently defined 	}
	cmReflectiveTransparentMask	= $00000001;					{  if bit 0 is 0 then reflective media, if 1 then transparency media  }
	cmGlossyMatteMask			= $00000002;					{  if bit 1 is 0 then glossy, if 1 then matte  }

	{	 device/media attributes element values  	}
	cmReflective				= 0;							{  if bit 0 is 0 then reflective media, if 1 then transparency media  }
	cmGlossy					= 1;							{  if bit 1 is 0 then glossy, if 1 then matte  }


	{	*** renderingIntent field ***	}
	cmPerceptual				= 0;							{  Photographic images  }
	cmRelativeColorimetric		= 1;							{  Logo Colors  }
	cmSaturation				= 2;							{  Business graphics  }
	cmAbsoluteColorimetric		= 3;							{  Logo Colors  }


	{	 data type element values 	}
	cmAsciiData					= 0;
	cmBinaryData				= 1;

	{	 screen encodings  	}
	cmPrtrDefaultScreens		= 0;							{  Use printer default screens.  0 is false, 1 is ture  }
	cmLinesPer					= 1;							{  0 is LinesPerCm, 1 is LinesPerInch  }

	{	 2.0 tag type information 	}
	cmNumHeaderElements			= 10;

	{	 public tags 	}
	cmAToB0Tag					= $41324230 (* 'A2B0' *);
	cmAToB1Tag					= $41324231 (* 'A2B1' *);
	cmAToB2Tag					= $41324232 (* 'A2B2' *);
	cmBlueColorantTag			= $6258595A (* 'bXYZ' *);
	cmBlueTRCTag				= $62545243 (* 'bTRC' *);
	cmBToA0Tag					= $42324130 (* 'B2A0' *);
	cmBToA1Tag					= $42324131 (* 'B2A1' *);
	cmBToA2Tag					= $42324132 (* 'B2A2' *);
	cmCalibrationDateTimeTag	= $63616C74 (* 'calt' *);
	cmChromaticAdaptationTag	= $63686164 (* 'chad' *);
	cmCharTargetTag				= $74617267 (* 'targ' *);
	cmCopyrightTag				= $63707274 (* 'cprt' *);
	cmDeviceMfgDescTag			= $646D6E64 (* 'dmnd' *);
	cmDeviceModelDescTag		= $646D6464 (* 'dmdd' *);
	cmGamutTag					= $67616D74 (* 'gamt' *);
	cmGrayTRCTag				= $6B545243 (* 'kTRC' *);
	cmGreenColorantTag			= $6758595A (* 'gXYZ' *);
	cmGreenTRCTag				= $67545243 (* 'gTRC' *);
	cmLuminanceTag				= $6C756D69 (* 'lumi' *);
	cmMeasurementTag			= $6D656173 (* 'meas' *);
	cmMediaBlackPointTag		= $626B7074 (* 'bkpt' *);
	cmMediaWhitePointTag		= $77747074 (* 'wtpt' *);
	cmNamedColorTag				= $6E636F6C (* 'ncol' *);
	cmNamedColor2Tag			= $6E636C32 (* 'ncl2' *);
	cmPreview0Tag				= $70726530 (* 'pre0' *);
	cmPreview1Tag				= $70726531 (* 'pre1' *);
	cmPreview2Tag				= $70726532 (* 'pre2' *);
	cmProfileDescriptionTag		= $64657363 (* 'desc' *);
	cmProfileSequenceDescTag	= $70736571 (* 'pseq' *);
	cmPS2CRD0Tag				= $70736430 (* 'psd0' *);
	cmPS2CRD1Tag				= $70736431 (* 'psd1' *);
	cmPS2CRD2Tag				= $70736432 (* 'psd2' *);
	cmPS2CRD3Tag				= $70736433 (* 'psd3' *);
	cmPS2CSATag					= $70733273 (* 'ps2s' *);
	cmPS2RenderingIntentTag		= $70733269 (* 'ps2i' *);
	cmRedColorantTag			= $7258595A (* 'rXYZ' *);
	cmRedTRCTag					= $72545243 (* 'rTRC' *);
	cmScreeningDescTag			= $73637264 (* 'scrd' *);
	cmScreeningTag				= $7363726E (* 'scrn' *);
	cmTechnologyTag				= $74656368 (* 'tech' *);
	cmUcrBgTag					= $62666420 (* 'bfd ' *);
	cmViewingConditionsDescTag	= $76756564 (* 'vued' *);
	cmViewingConditionsTag		= $76696577 (* 'view' *);

	{	 custom tags 	}
	cmPS2CRDVMSizeTag			= $7073766D (* 'psvm' *);
	cmVideoCardGammaTag			= $76636774 (* 'vcgt' *);
	cmMakeAndModelTag			= $6D6D6F64 (* 'mmod' *);
	cmProfileDescriptionMLTag	= $6473636D (* 'dscm' *);

	{	 technology tag descriptions 	}
	cmTechnologyFilmScanner		= $6673636E (* 'fscn' *);
	cmTechnologyReflectiveScanner = $7273636E (* 'rscn' *);
	cmTechnologyInkJetPrinter	= $696A6574 (* 'ijet' *);
	cmTechnologyThermalWaxPrinter = $74776178 (* 'twax' *);
	cmTechnologyElectrophotographicPrinter = $6570686F (* 'epho' *);
	cmTechnologyElectrostaticPrinter = $65737461 (* 'esta' *);
	cmTechnologyDyeSublimationPrinter = $64737562 (* 'dsub' *);
	cmTechnologyPhotographicPaperPrinter = $7270686F (* 'rpho' *);
	cmTechnologyFilmWriter		= $6670726E (* 'fprn' *);
	cmTechnologyVideoMonitor	= $7669646D (* 'vidm' *);
	cmTechnologyVideoCamera		= $76696463 (* 'vidc' *);
	cmTechnologyProjectionTelevision = $706A7476 (* 'pjtv' *);
	cmTechnologyCRTDisplay		= $43525420 (* 'CRT ' *);
	cmTechnologyPMDisplay		= $504D4420 (* 'PMD ' *);
	cmTechnologyAMDisplay		= $414D4420 (* 'AMD ' *);
	cmTechnologyPhotoCD			= $4B504344 (* 'KPCD' *);
	cmTechnologyPhotoImageSetter = $696D6773 (* 'imgs' *);
	cmTechnologyGravure			= $67726176 (* 'grav' *);
	cmTechnologyOffsetLithography = $6F666673 (* 'offs' *);
	cmTechnologySilkscreen		= $73696C6B (* 'silk' *);
	cmTechnologyFlexography		= $666C6578 (* 'flex' *);

	{	 public type signatures 	}
	cmSigCurveType				= $63757276 (* 'curv' *);
	cmSigDataType				= $64617461 (* 'data' *);
	cmSigDateTimeType			= $6474696D (* 'dtim' *);
	cmSigLut16Type				= $6D667432 (* 'mft2' *);
	cmSigLut8Type				= $6D667431 (* 'mft1' *);
	cmSigMeasurementType		= $6D656173 (* 'meas' *);
	cmSigNamedColorType			= $6E636F6C (* 'ncol' *);
	cmSigNamedColor2Type		= $6E636C32 (* 'ncl2' *);
	cmSigProfileDescriptionType	= $64657363 (* 'desc' *);
	cmSigScreeningType			= $7363726E (* 'scrn' *);
	cmSigS15Fixed16Type			= $73663332 (* 'sf32' *);
	cmSigSignatureType			= $73696720 (* 'sig ' *);
	cmSigTextType				= $74657874 (* 'text' *);
	cmSigU16Fixed16Type			= $75663332 (* 'uf32' *);
	cmSigU1Fixed15Type			= $75663136 (* 'uf16' *);
	cmSigUInt8Type				= $75693038 (* 'ui08' *);
	cmSigUInt16Type				= $75693136 (* 'ui16' *);
	cmSigUInt32Type				= $75693332 (* 'ui32' *);
	cmSigUInt64Type				= $75693634 (* 'ui64' *);
	cmSigUcrBgType				= $62666420 (* 'bfd ' *);
	cmSigUnicodeTextType		= $75747874 (* 'utxt' *);
	cmSigViewingConditionsType	= $76696577 (* 'view' *);
	cmSigXYZType				= $58595A20 (* 'XYZ ' *);

	{	 custom type signatures 	}
	cmSigPS2CRDVMSizeType		= $7073766D (* 'psvm' *);
	cmSigVideoCardGammaType		= $76636774 (* 'vcgt' *);
	cmSigMakeAndModelType		= $6D6D6F64 (* 'mmod' *);
	cmSigMultiLocalizedUniCodeType = $6D6C7563 (* 'mluc' *);


	{	 Measurement type encodings 	}
	{	 Measurement Flare 	}
	cmFlare0					= $00000000;
	cmFlare100					= $00000001;

	{	 Measurement Geometry 	}
	cmGeometryUnknown			= $00000000;
	cmGeometry045or450			= $00000001;
	cmGeometry0dord0			= $00000002;

	{	 Standard Observer    	}
	cmStdobsUnknown				= $00000000;
	cmStdobs1931TwoDegrees		= $00000001;
	cmStdobs1964TenDegrees		= $00000002;

	{	 Standard Illuminant 	}
	cmIlluminantUnknown			= $00000000;
	cmIlluminantD50				= $00000001;
	cmIlluminantD65				= $00000002;
	cmIlluminantD93				= $00000003;
	cmIlluminantF2				= $00000004;
	cmIlluminantD55				= $00000005;
	cmIlluminantA				= $00000006;
	cmIlluminantEquiPower		= $00000007;
	cmIlluminantF8				= $00000008;

	{	 Spot Function Value 	}
	cmSpotFunctionUnknown		= 0;
	cmSpotFunctionDefault		= 1;
	cmSpotFunctionRound			= 2;
	cmSpotFunctionDiamond		= 3;
	cmSpotFunctionEllipse		= 4;
	cmSpotFunctionLine			= 5;
	cmSpotFunctionSquare		= 6;
	cmSpotFunctionCross			= 7;

	{	 Color Space Signatures 	}
	cmXYZData					= $58595A20 (* 'XYZ ' *);
	cmLabData					= $4C616220 (* 'Lab ' *);
	cmLuvData					= $4C757620 (* 'Luv ' *);
	cmYxyData					= $59787920 (* 'Yxy ' *);
	cmRGBData					= $52474220 (* 'RGB ' *);
	cmSRGBData					= $73524742 (* 'sRGB' *);
	cmGrayData					= $47524159 (* 'GRAY' *);
	cmHSVData					= $48535620 (* 'HSV ' *);
	cmHLSData					= $484C5320 (* 'HLS ' *);
	cmCMYKData					= $434D594B (* 'CMYK' *);
	cmCMYData					= $434D5920 (* 'CMY ' *);
	cmMCH5Data					= $4D434835 (* 'MCH5' *);
	cmMCH6Data					= $4D434836 (* 'MCH6' *);
	cmMCH7Data					= $4D434837 (* 'MCH7' *);
	cmMCH8Data					= $4D434838 (* 'MCH8' *);
	cm3CLRData					= $33434C52 (* '3CLR' *);
	cm4CLRData					= $34434C52 (* '4CLR' *);
	cm5CLRData					= $35434C52 (* '5CLR' *);
	cm6CLRData					= $36434C52 (* '6CLR' *);
	cm7CLRData					= $37434C52 (* '7CLR' *);
	cm8CLRData					= $38434C52 (* '8CLR' *);
	cmNamedData					= $4E414D45 (* 'NAME' *);

	{	 profileClass enumerations 	}
	cmInputClass				= $73636E72 (* 'scnr' *);
	cmDisplayClass				= $6D6E7472 (* 'mntr' *);
	cmOutputClass				= $70727472 (* 'prtr' *);
	cmLinkClass					= $6C696E6B (* 'link' *);
	cmAbstractClass				= $61627374 (* 'abst' *);
	cmColorSpaceClass			= $73706163 (* 'spac' *);
	cmNamedColorClass			= $6E6D636C (* 'nmcl' *);

	{	 platform enumerations 	}
	cmMacintosh					= $4150504C (* 'APPL' *);
	cmMicrosoft					= $4D534654 (* 'MSFT' *);
	cmSolaris					= $53554E57 (* 'SUNW' *);
	cmSiliconGraphics			= $53474920 (* 'SGI ' *);
	cmTaligent					= $54474E54 (* 'TGNT' *);

	{	 ColorSync 1.0 elements 	}
	cmCS1ChromTag				= $6368726D (* 'chrm' *);
	cmCS1TRCTag					= $74726320 (* 'trc ' *);
	cmCS1NameTag				= $6E616D65 (* 'name' *);
	cmCS1CustTag				= $63757374 (* 'cust' *);

	{	 General element data types 	}

type
	CMDateTimePtr = ^CMDateTime;
	CMDateTime = record
		year:					UInt16;
		month:					UInt16;
		dayOfTheMonth:			UInt16;
		hours:					UInt16;
		minutes:				UInt16;
		seconds:				UInt16;
	end;

	CMFixedXYZColorPtr = ^CMFixedXYZColor;
	CMFixedXYZColor = record
		X:						Fixed;
		Y:						Fixed;
		Z:						Fixed;
	end;

	CMXYZComponent						= UInt16;
	CMXYZColorPtr = ^CMXYZColor;
	CMXYZColor = record
		X:						CMXYZComponent;
		Y:						CMXYZComponent;
		Z:						CMXYZComponent;
	end;

	CM2HeaderPtr = ^CM2Header;
	CM2Header = record
		size:					UInt32;									{  This is the total size of the Profile  }
		CMMType:				OSType;									{  CMM signature,  Registered with CS2 consortium   }
		profileVersion:			UInt32;									{  Version of CMProfile format  }
		profileClass:			OSType;									{  input, display, output, devicelink, abstract, or color conversion profile type  }
		dataColorSpace:			OSType;									{  color space of data  }
		profileConnectionSpace:	OSType;									{  profile connection color space  }
		dateTime:				CMDateTime;								{  date and time of profile creation  }
		CS2profileSignature:	OSType;									{  'acsp' constant ColorSync 2.0 file ID  }
		platform:				OSType;									{  primary profile platform, Registered with CS2 consortium  }
		flags:					UInt32;									{  profile flags  }
		deviceManufacturer:		OSType;									{  Registered with ICC consortium  }
		deviceModel:			UInt32;									{  Registered with ICC consortium  }
		deviceAttributes:		array [0..1] of UInt32;					{  Attributes[0] is for device vendors, [1] is for ICC  }
		renderingIntent:		UInt32;									{  preferred rendering intent of tagged object  }
		white:					CMFixedXYZColor;						{  profile illuminant  }
		creator:				OSType;									{  profile creator  }
		reserved:				packed array [0..43] of char;			{  reserved for future use  }
	end;

	CMTagRecordPtr = ^CMTagRecord;
	CMTagRecord = record
		tag:					OSType;									{  Registered with CS2 consortium  }
		elementOffset:			UInt32;									{  Relative to start of CMProfile  }
		elementSize:			UInt32;
	end;

	CMTagElemTablePtr = ^CMTagElemTable;
	CMTagElemTable = record
		count:					UInt32;
		tagList:				array [0..0] of CMTagRecord;			{  variable size, determined by count  }
	end;

	CM2ProfilePtr = ^CM2Profile;
	CM2Profile = record
		header:					CM2Header;
		tagTable:				CMTagElemTable;
		elemData:				SInt8;									{  variable size data for tagged element storage  }
	end;

	CM2ProfileHandle					= ^CM2ProfilePtr;
	{	 Tag Type Definitions 	}
	CMAdaptationMatrixTypePtr = ^CMAdaptationMatrixType;
	CMAdaptationMatrixType = record
		typeDescriptor:			OSType;									{  'sf32' = cmSigS15Fixed16Type  }
		reserved:				UInt32;									{  fill with 0x00  }
		adaptationMatrix:		array [0..8] of Fixed;					{  fixed size of nine matrix entries  }
	end;

	CMCurveTypePtr = ^CMCurveType;
	CMCurveType = record
		typeDescriptor:			OSType;									{  'curv' = cmSigCurveType  }
		reserved:				UInt32;									{  fill with 0x00  }
		countValue:				UInt32;									{  number of entries in table that follows  }
		data:					array [0..0] of UInt16;					{  variable size, determined by countValue  }
	end;

	CMDataTypePtr = ^CMDataType;
	CMDataType = record
		typeDescriptor:			OSType;									{  'data' = cmSigDataType }
		reserved:				UInt32;									{  fill with 0x00  }
		dataFlag:				UInt32;									{  0 = ASCII, 1 = binary  }
		data:					SInt8;									{  variable size, determined by tag element size  }
	end;

	CMDateTimeTypePtr = ^CMDateTimeType;
	CMDateTimeType = record
		typeDescriptor:			OSType;									{  'dtim' = cmSigDateTimeType  }
		reserved:				UInt32;									{  fill with 0x00  }
		dateTime:				CMDateTime;								{   }
	end;

	CMLut16TypePtr = ^CMLut16Type;
	CMLut16Type = record
		typeDescriptor:			OSType;									{  'mft2' = cmSigLut16Type  }
		reserved:				UInt32;									{  fill with 0x00  }
		inputChannels:			SInt8;									{  Number of input channels  }
		outputChannels:			SInt8;									{  Number of output channels  }
		gridPoints:				SInt8;									{  Number of clutTable grid points  }
		reserved2:				SInt8;									{  fill with 0x00  }
		matrix:					array [0..2,0..2] of Fixed;				{   }
		inputTableEntries:		UInt16;									{  Number of entries in 1-D input luts  }
		outputTableEntries:		UInt16;									{  Number of entries in 1-D output luts  }
		inputTable:				array [0..0] of UInt16;					{  variable size, determined by inputChannels*inputTableEntries  }
	end;

	CMLut8TypePtr = ^CMLut8Type;
	CMLut8Type = record
		typeDescriptor:			OSType;									{  'mft1' = cmSigLut8Type  }
		reserved:				UInt32;									{  fill with 0x00  }
		inputChannels:			SInt8;									{  Number of input channels  }
		outputChannels:			SInt8;									{  Number of output channels  }
		gridPoints:				SInt8;									{  Number of clutTable grid points  }
		reserved2:				SInt8;									{  fill with 0x00  }
		matrix:					array [0..2,0..2] of Fixed;				{   }
		inputTable:				SInt8;									{  variable size, determined by inputChannels*256  }
	end;

	CMMeasurementTypePtr = ^CMMeasurementType;
	CMMeasurementType = record
		typeDescriptor:			OSType;									{  'meas' = cmSigMeasurementType  }
		reserved:				UInt32;									{  fill with 0x00  }
		standardObserver:		UInt32;									{  cmStdobsUnknown, cmStdobs1931TwoDegrees, cmStdobs1964TenDegrees  }
		backingXYZ:				CMFixedXYZColor;						{  absolute XYZ values of backing  }
		geometry:				UInt32;									{  cmGeometryUnknown, cmGeometry045or450 (0/45), cmGeometry0dord0 (0/d or d/0)  }
		flare:					UInt32;									{  cmFlare0, cmFlare100  }
		illuminant:				UInt32;									{  cmIlluminantUnknown, cmIlluminantD50, ...  }
	end;

	CMNamedColorTypePtr = ^CMNamedColorType;
	CMNamedColorType = record
		typeDescriptor:			OSType;									{  'ncol' = cmSigNamedColorType  }
		reserved:				UInt32;									{  fill with 0x00  }
		vendorFlag:				UInt32;									{   }
		count:					UInt32;									{  count of named colors in array that follows  }
		prefixName:				SInt8;									{  variable size, max = 32  }
	end;

	CMNamedColor2EntryTypePtr = ^CMNamedColor2EntryType;
	CMNamedColor2EntryType = record
		rootName:				packed array [0..31] of UInt8;			{  32 byte field.  7 bit ASCII null terminated  }
		PCSColorCoords:			array [0..2] of UInt16;					{  Lab or XYZ color  }
		DeviceColorCoords:		array [0..0] of UInt16;					{  variable size  }
	end;

	CMNamedColor2TypePtr = ^CMNamedColor2Type;
	CMNamedColor2Type = record
		typeDescriptor:			OSType;									{  'ncl2' = cmSigNamedColor2Type  }
		reserved:				UInt32;									{  fill with 0x00  }
		vendorFlag:				UInt32;									{  lower 16 bits reserved for ICC use  }
		count:					UInt32;									{  count of named colors in array that follows  }
		deviceChannelCount:		UInt32;									{  number of device channels, 0 indicates no device value available  }
		prefixName:				packed array [0..31] of UInt8;			{  Fixed 32 byte size.  7 bit ASCII null terminated  }
		suffixName:				packed array [0..31] of UInt8;			{  Fixed 32 byte size.  7 bit ASCII null terminated  }
		data:					SInt8;									{  variable size data for CMNamedColor2EntryType  }
	end;

	CMTextDescriptionTypePtr = ^CMTextDescriptionType;
	CMTextDescriptionType = packed record
		typeDescriptor:			OSType;									{  'desc' = cmSigProfileDescriptionType  }
		reserved:				UInt32;									{  fill with 0x00  }
		ASCIICount:				UInt32;									{  Count of bytes (including null terminator)   }
		ASCIIName:				packed array [0..1] of UInt8;			{  variable size, determined by ASCIICount.  7 bit ASCII null terminated  }
	end;

	CMTextTypePtr = ^CMTextType;
	CMTextType = record
		typeDescriptor:			OSType;									{  'text' = cmSigTextType  }
		reserved:				UInt32;									{  fill with 0x00  }
		text:					SInt8;									{  variable size, determined by tag element size  }
	end;

	CMUnicodeTextTypePtr = ^CMUnicodeTextType;
	CMUnicodeTextType = record
		typeDescriptor:			OSType;									{  'utxt' = cmSigUnicodeTextType  }
		reserved:				UInt32;									{  fill with 0x00  }
		text:					array [0..0] of UniChar;				{  variable size, determined by tag element size   }
	end;

	CMScreeningChannelRecPtr = ^CMScreeningChannelRec;
	CMScreeningChannelRec = record
		frequency:				Fixed;
		angle:					Fixed;
		spotFunction:			UInt32;
	end;

	CMScreeningTypePtr = ^CMScreeningType;
	CMScreeningType = record
		typeDescriptor:			OSType;									{  'scrn' = cmSigScreeningType  }
		reserved:				UInt32;									{  fill with 0x00  }
		screeningFlag:			UInt32;									{  bit 0 : use printer default screens, bit 1 : inch/cm  }
		channelCount:			UInt32;									{   }
		channelInfo:			array [0..0] of CMScreeningChannelRec;	{  variable size, determined by channelCount  }
	end;

	CMSignatureTypePtr = ^CMSignatureType;
	CMSignatureType = record
		typeDescriptor:			OSType;									{  'sig ' = cmSigSignatureType  }
		reserved:				UInt32;									{  fill with 0x00  }
		signature:				OSType;
	end;

	CMS15Fixed16ArrayTypePtr = ^CMS15Fixed16ArrayType;
	CMS15Fixed16ArrayType = record
		typeDescriptor:			OSType;									{  'sf32' = cmSigS15Fixed16Type  }
		reserved:				UInt32;									{  fill with 0x00  }
		value:					array [0..0] of Fixed;					{  variable size, determined by tag element size  }
	end;

	CMU16Fixed16ArrayTypePtr = ^CMU16Fixed16ArrayType;
	CMU16Fixed16ArrayType = record
		typeDescriptor:			OSType;									{  'uf32' = cmSigU16Fixed16Type  }
		reserved:				UInt32;									{  fill with 0x00  }
		value:					array [0..0] of UInt32;					{  variable size, determined by tag element size  }
	end;

	CMUInt8ArrayTypePtr = ^CMUInt8ArrayType;
	CMUInt8ArrayType = record
		typeDescriptor:			OSType;									{  'ui08' = cmSigUInt8Type  }
		reserved:				UInt32;									{  fill with 0x00  }
		value:					SInt8;									{  variable size, determined by tag element size  }
	end;

	CMUInt16ArrayTypePtr = ^CMUInt16ArrayType;
	CMUInt16ArrayType = record
		typeDescriptor:			OSType;									{  'ui16' = cmSigUInt16Type  }
		reserved:				UInt32;									{  fill with 0x00  }
		value:					array [0..0] of UInt16;					{  variable size, determined by tag element size  }
	end;

	CMUInt32ArrayTypePtr = ^CMUInt32ArrayType;
	CMUInt32ArrayType = record
		typeDescriptor:			OSType;									{  'ui32' = cmSigUInt32Type  }
		reserved:				UInt32;									{  fill with 0x00  }
		value:					array [0..0] of UInt32;					{  variable size, determined by tag element size  }
	end;

	CMUInt64ArrayTypePtr = ^CMUInt64ArrayType;
	CMUInt64ArrayType = record
		typeDescriptor:			OSType;									{  'ui64' = cmSigUInt64Type  }
		reserved:				UInt32;									{  fill with 0x00  }
		value:					array [0..0] of UInt32;					{  variable size, determined by tag element size  }
	end;

	CMViewingConditionsTypePtr = ^CMViewingConditionsType;
	CMViewingConditionsType = record
		typeDescriptor:			OSType;									{  'view' = cmSigViewingConditionsType  }
		reserved:				UInt32;									{  fill with 0x00  }
		illuminant:				CMFixedXYZColor;						{  absolute XYZs of illuminant  in cd/m^2  }
		surround:				CMFixedXYZColor;						{  absolute XYZs of surround in cd/m^2  }
		stdIlluminant:			UInt32;									{  see definitions of std illuminants  }
	end;

	CMXYZTypePtr = ^CMXYZType;
	CMXYZType = record
		typeDescriptor:			OSType;									{  'XYZ ' = cmSigXYZType  }
		reserved:				UInt32;									{  fill with 0x00  }
		XYZ:					array [0..0] of CMFixedXYZColor;		{  variable size, determined by tag element size  }
	end;

	CMProfileSequenceDescTypePtr = ^CMProfileSequenceDescType;
	CMProfileSequenceDescType = record
		typeDescriptor:			OSType;									{  'pseq' = cmProfileSequenceDescTag  }
		reserved:				UInt32;									{  fill with 0x00  }
		count:					UInt32;									{  Number of descriptions  }
		data:					SInt8;									{  variable size data explained in ICC spec  }
	end;

	CMUcrBgTypePtr = ^CMUcrBgType;
	CMUcrBgType = record
		typeDescriptor:			OSType;									{  'bfd ' = cmSigUcrBgType  }
		reserved:				UInt32;									{  fill with 0x00  }
		ucrCount:				UInt32;									{  Number of UCR entries  }
		ucrValues:				array [0..0] of UInt16;					{  variable size, determined by ucrCount  }
	end;

	{	 Private Tag Type Definitions 	}
	CMIntentCRDVMSizePtr = ^CMIntentCRDVMSize;
	CMIntentCRDVMSize = record
		renderingIntent:		SInt32;								{  rendering intent  }
		VMSize:					UInt32;									{  VM size taken up by the CRD  }
	end;

	CMPS2CRDVMSizeTypePtr = ^CMPS2CRDVMSizeType;
	CMPS2CRDVMSizeType = record
		typeDescriptor:			OSType;									{  'psvm' = cmSigPS2CRDVMSizeType  }
		reserved:				UInt32;									{  fill with 0x00  }
		count:					UInt32;									{  number of intent entries  }
		intentCRD:				array [0..0] of CMIntentCRDVMSize;		{  variable size, determined by count  }
	end;


const
	cmVideoCardGammaTableType	= 0;
	cmVideoCardGammaFormulaType	= 1;


type
	CMVideoCardGammaTablePtr = ^CMVideoCardGammaTable;
	CMVideoCardGammaTable = record
		channels:				UInt16;									{  # of gamma channels (1 or 3)  }
		entryCount:				UInt16;									{  1-based number of entries per channel  }
		entrySize:				UInt16;									{  size in bytes of each entry  }
		data:					SInt8;									{  variable size, determined by channels*entryCount*entrySize  }
	end;

	CMVideoCardGammaFormulaPtr = ^CMVideoCardGammaFormula;
	CMVideoCardGammaFormula = record
		redGamma:				Fixed;									{  must be > 0.0  }
		redMin:					Fixed;									{  must be > 0.0 and < 1.0  }
		redMax:					Fixed;									{  must be > 0.0 and < 1.0  }
		greenGamma:				Fixed;									{  must be > 0.0  }
		greenMin:				Fixed;									{  must be > 0.0 and < 1.0  }
		greenMax:				Fixed;									{  must be > 0.0 and < 1.0  }
		blueGamma:				Fixed;									{  must be > 0.0  }
		blueMin:				Fixed;									{  must be > 0.0 and < 1.0  }
		blueMax:				Fixed;									{  must be > 0.0 and < 1.0  }
	end;

	CMVideoCardGammaPtr = ^CMVideoCardGamma;
	CMVideoCardGamma = record
		tagType:				UInt32;
		case SInt16 of
		0: (
			table:				CMVideoCardGammaTable;
			);
		1: (
			formula:			CMVideoCardGammaFormula;
			);
	end;

	CMVideoCardGammaTypePtr = ^CMVideoCardGammaType;
	CMVideoCardGammaType = record
		typeDescriptor:			OSType;									{  'vcgt' = cmSigVideoCardGammaType  }
		reserved:				UInt32;									{  fill with 0x00  }
		gamma:					CMVideoCardGamma;
	end;

	CMMakeAndModelPtr = ^CMMakeAndModel;
	CMMakeAndModel = record
		manufacturer:			OSType;
		model:					UInt32;
		serialNumber:			UInt32;
		manufactureDate:		UInt32;
		reserved1:				UInt32;									{  fill with 0x00  }
		reserved2:				UInt32;									{  fill with 0x00  }
		reserved3:				UInt32;									{  fill with 0x00  }
		reserved4:				UInt32;									{  fill with 0x00  }
	end;

	CMMakeAndModelTypePtr = ^CMMakeAndModelType;
	CMMakeAndModelType = record
		typeDescriptor:			OSType;									{  'mmod' = cmSigMakeAndModelType  }
		reserved:				UInt32;									{  fill with 0x00  }
		makeAndModel:			CMMakeAndModel;
	end;

	CMMultiLocalizedUniCodeEntryRecPtr = ^CMMultiLocalizedUniCodeEntryRec;
	CMMultiLocalizedUniCodeEntryRec = record
		languageCode:			packed array [0..1] of char;			{  language code from ISO-639  }
		regionCode:				packed array [0..1] of char;			{  region code from ISO-3166  }
		textLength:				UInt32;									{  the length in bytes of the string  }
		textOffset:				UInt32;									{  the offset from the start of tag in bytes  }
	end;

	CMMultiLocalizedUniCodeTypePtr = ^CMMultiLocalizedUniCodeType;
	CMMultiLocalizedUniCodeType = record
		typeDescriptor:			OSType;									{  'mluc' = cmSigMultiLocalizedUniCodeType  }
		reserved:				UInt32;									{  fill with 0x00  }
		entryCount:				UInt32;									{  1-based number of name records that follow  }
		entrySize:				UInt32;									{  size in bytes of name records that follow  }
																		{  variable-length data for storage of CMMultiLocalizedUniCodeEntryRec  }
																		{  variable-length data for storage of Unicode strings }
	end;

	{	**********************************************************************	}
	{	************** ColorSync 1.0 profile specification *******************	}
	{	**********************************************************************	}

const
	cmGrayResponse				= 0;
	cmRedResponse				= 1;
	cmGreenResponse				= 2;
	cmBlueResponse				= 3;
	cmCyanResponse				= 4;
	cmMagentaResponse			= 5;
	cmYellowResponse			= 6;
	cmUcrResponse				= 7;
	cmBgResponse				= 8;
	cmOnePlusLastResponse		= 9;


	{	 Device types 	}
	cmMonitorDevice				= $6D6E7472 (* 'mntr' *);
	cmScannerDevice				= $73636E72 (* 'scnr' *);
	cmPrinterDevice				= $70727472 (* 'prtr' *);


type
	CMIStringPtr = ^CMIString;
	CMIString = record
		theScript:				ScriptCode;
		theString:				Str63;
	end;

	{	 Profile options 	}

const
	cmPerceptualMatch			= $0000;						{  Default. For photographic images  }
	cmColorimetricMatch			= $0001;						{  Exact matching when possible  }
	cmSaturationMatch			= $0002;						{  For solid colors  }

	{	 Profile flags 	}
	cmNativeMatchingPreferred	= $00000001;					{  Default to native not preferred  }
	cmTurnOffCache				= $00000002;					{  Default to turn on CMM cache  }


type
	CMMatchOption						= SInt32;
	CMMatchFlag							= SInt32;
	CMHeaderPtr = ^CMHeader;
	CMHeader = record
		size:					UInt32;
		CMMType:				OSType;
		applProfileVersion:		UInt32;
		dataType:				OSType;
		deviceType:				OSType;
		deviceManufacturer:		OSType;
		deviceModel:			UInt32;
		deviceAttributes:		array [0..1] of UInt32;
		profileNameOffset:		UInt32;
		customDataOffset:		UInt32;
		flags:					CMMatchFlag;
		options:				CMMatchOption;
		white:					CMXYZColor;
		black:					CMXYZColor;
	end;

	CMProfileChromaticitiesPtr = ^CMProfileChromaticities;
	CMProfileChromaticities = record
		red:					CMXYZColor;
		green:					CMXYZColor;
		blue:					CMXYZColor;
		cyan:					CMXYZColor;
		magenta:				CMXYZColor;
		yellow:					CMXYZColor;
	end;

	CMProfileResponsePtr = ^CMProfileResponse;
	CMProfileResponse = record
		counts:					array [0..8] of UInt16;
		data:					array [0..0] of UInt16;					{  Variable size  }
	end;

	CMProfilePtr = ^CMProfile;
	CMProfile = record
		header:					CMHeader;
		profile:				CMProfileChromaticities;
		response:				CMProfileResponse;
		profileName:			CMIString;
		customData:				SInt8;									{  Variable size  }
	end;

	CMProfileHandle						= ^CMProfilePtr;
{$ifc OLDROUTINENAMES}

const
	kCMApplProfileVersion		= $00000100;

	grayResponse				= 0;
	redResponse					= 1;
	greenResponse				= 2;
	blueResponse				= 3;
	cyanResponse				= 4;
	magentaResponse				= 5;
	yellowResponse				= 6;
	ucrResponse					= 7;
	bgResponse					= 8;
	onePlusLastResponse			= 9;

	rgbData						= $52474220 (* 'RGB ' *);
	cmykData					= $434D594B (* 'CMYK' *);
	grayData					= $47524159 (* 'GRAY' *);
	xyzData						= $58595A20 (* 'XYZ ' *);

	monitorDevice				= $6D6E7472 (* 'mntr' *);
	scannerDevice				= $73636E72 (* 'scnr' *);
	printerDevice				= $70727472 (* 'prtr' *);


type
	XYZComponent						= UInt16;
	XYZColor							= CMXYZColor;
	XYZColorPtr 						= ^XYZColor;
	CMResponseData						= UInt16;
	IString								= CMIString;
	IStringPtr 							= ^IString;
	CMResponseColor						= SInt32;
	responseColor						= CMResponseColor;
{$endc}  {OLDROUTINENAMES}


{$ALIGN MAC68K}


{unit CMTypes}
{
     File:       CMTypes.p
 
     Contains:   xxx put contents here xxx
 
     Version:    Technology: ColorSync 3
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   2000-2002 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{ Standard type for ColorSync and other system error codes }

{$ALIGN MAC68K}


type
	CMError								= SInt32;
	{	 Abstract data type for memory-based Profile 	}
	CMProfileRef    = ^SInt32; { an opaque 32-bit type }
	CMProfileRefPtr = ^CMProfileRef;  { when a var xx:CMProfileRef parameter can be nil, it is changed to xx: CMProfileRefPtr }
	{	 Abstract data type for Profile search result 	}
	CMProfileSearchRef    = ^SInt32; { an opaque 32-bit type }
	CMProfileSearchRefPtr = ^CMProfileSearchRef;  { when a var xx:CMProfileSearchRef parameter can be nil, it is changed to xx: CMProfileSearchRefPtr }
	{	 Abstract data type for BeginMatching() reference 	}
	CMMatchRef    = ^SInt32; { an opaque 32-bit type }
	CMMatchRefPtr = ^CMMatchRef;  { when a var xx:CMMatchRef parameter can be nil, it is changed to xx: CMMatchRefPtr }
	{	 Abstract data type for ColorWorld reference 	}
	CMWorldRef    = ^SInt32; { an opaque 32-bit type }
	CMWorldRefPtr = ^CMWorldRef;  { when a var xx:CMWorldRef parameter can be nil, it is changed to xx: CMWorldRefPtr }
	{	 Data type for ColorSync DisplayID reference 	}
	{	 On 8 & 9 this is a AVIDType 	}
	{	 On X this is a CGSDisplayID 	}
	CMDisplayIDType						= UInt32;

	{	 Caller-supplied flatten function 	}
{$ifc TYPED_FUNCTION_POINTERS}
	CMFlattenProcPtr = function(command: SInt32; var size: SInt32; data: UnivPtr; refCon: UnivPtr): OSErr;
{$elsec}
	CMFlattenProcPtr = ProcPtr;
{$endc}

	{	 Caller-supplied progress function for Bitmap & PixMap matching routines 	}
{$ifc TYPED_FUNCTION_POINTERS}
	CMBitmapCallBackProcPtr = function(progress: SInt32; refCon: UnivPtr): boolean;
{$elsec}
	CMBitmapCallBackProcPtr = ProcPtr;
{$endc}

	{	 Caller-supplied progress function for NCMMConcatInit & NCMMNewLinkProfile routines 	}
{$ifc TYPED_FUNCTION_POINTERS}
	CMConcatCallBackProcPtr = function(progress: SInt32; refCon: UnivPtr): boolean;
{$elsec}
	CMConcatCallBackProcPtr = ProcPtr;
{$endc}

	{	 Caller-supplied filter function for Profile search 	}
{$ifc TYPED_FUNCTION_POINTERS}
	CMProfileFilterProcPtr = function(prof: CMProfileRef; refCon: UnivPtr): boolean;
{$elsec}
	CMProfileFilterProcPtr = ProcPtr;
{$endc}

	{	 Caller-supplied function for profile access 	}
{$ifc TYPED_FUNCTION_POINTERS}
	CMProfileAccessProcPtr = function(command: SInt32; offset: SInt32; var size: SInt32; data: UnivPtr; refCon: UnivPtr): OSErr;
{$elsec}
	CMProfileAccessProcPtr = ProcPtr;
{$endc}

{$ifc OPAQUE_UPP_TYPES}
	CMFlattenUPP = ^SInt32; { an opaque UPP }
{$elsec}
	CMFlattenUPP = UniversalProcPtr;
{$endc}	
{$ifc OPAQUE_UPP_TYPES}
	CMBitmapCallBackUPP = ^SInt32; { an opaque UPP }
{$elsec}
	CMBitmapCallBackUPP = UniversalProcPtr;
{$endc}	
{$ifc OPAQUE_UPP_TYPES}
	CMConcatCallBackUPP = ^SInt32; { an opaque UPP }
{$elsec}
	CMConcatCallBackUPP = UniversalProcPtr;
{$endc}	
{$ifc OPAQUE_UPP_TYPES}
	CMProfileFilterUPP = ^SInt32; { an opaque UPP }
{$elsec}
	CMProfileFilterUPP = UniversalProcPtr;
{$endc}	
{$ifc OPAQUE_UPP_TYPES}
	CMProfileAccessUPP = ^SInt32; { an opaque UPP }
{$elsec}
	CMProfileAccessUPP = UniversalProcPtr;
{$endc}	

const
	uppCMFlattenProcInfo = $00003FE0;
	uppCMBitmapCallBackProcInfo = $000003D0;
	uppCMConcatCallBackProcInfo = $000003D0;
	uppCMProfileFilterProcInfo = $000003D0;
	uppCMProfileAccessProcInfo = $0000FFE0;
	{
	 *  NewCMFlattenUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in 3.0 and later
	 	}
function NewCMFlattenUPP(userRoutine: CMFlattenProcPtr): CMFlattenUPP; external name '_NewCMFlattenUPP'; { old name was NewCMFlattenProc }
{
 *  NewCMBitmapCallBackUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in 3.0 and later
 }
function NewCMBitmapCallBackUPP(userRoutine: CMBitmapCallBackProcPtr): CMBitmapCallBackUPP; external name '_NewCMBitmapCallBackUPP'; { old name was NewCMBitmapCallBackProc }
{
 *  NewCMConcatCallBackUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in 3.0 and later
 }
function NewCMConcatCallBackUPP(userRoutine: CMConcatCallBackProcPtr): CMConcatCallBackUPP; external name '_NewCMConcatCallBackUPP'; { old name was NewCMConcatCallBackProc }
{
 *  NewCMProfileFilterUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in 3.0 and later
 }
function NewCMProfileFilterUPP(userRoutine: CMProfileFilterProcPtr): CMProfileFilterUPP; external name '_NewCMProfileFilterUPP'; { old name was NewCMProfileFilterProc }
{
 *  NewCMProfileAccessUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in 3.0 and later
 }
function NewCMProfileAccessUPP(userRoutine: CMProfileAccessProcPtr): CMProfileAccessUPP; external name '_NewCMProfileAccessUPP'; { old name was NewCMProfileAccessProc }
{
 *  DisposeCMFlattenUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in 3.0 and later
 }
procedure DisposeCMFlattenUPP(userUPP: CMFlattenUPP); external name '_DisposeCMFlattenUPP';
{
 *  DisposeCMBitmapCallBackUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in 3.0 and later
 }
procedure DisposeCMBitmapCallBackUPP(userUPP: CMBitmapCallBackUPP); external name '_DisposeCMBitmapCallBackUPP';
{
 *  DisposeCMConcatCallBackUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in 3.0 and later
 }
procedure DisposeCMConcatCallBackUPP(userUPP: CMConcatCallBackUPP); external name '_DisposeCMConcatCallBackUPP';
{
 *  DisposeCMProfileFilterUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in 3.0 and later
 }
procedure DisposeCMProfileFilterUPP(userUPP: CMProfileFilterUPP); external name '_DisposeCMProfileFilterUPP';
{
 *  DisposeCMProfileAccessUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in 3.0 and later
 }
procedure DisposeCMProfileAccessUPP(userUPP: CMProfileAccessUPP); external name '_DisposeCMProfileAccessUPP';
{
 *  InvokeCMFlattenUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in 3.0 and later
 }
function InvokeCMFlattenUPP(command: SInt32; var size: SInt32; data: UnivPtr; refCon: UnivPtr; userRoutine: CMFlattenUPP): OSErr; external name '_InvokeCMFlattenUPP'; { old name was CallCMFlattenProc }
{
 *  InvokeCMBitmapCallBackUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in 3.0 and later
 }
function InvokeCMBitmapCallBackUPP(progress: SInt32; refCon: UnivPtr; userRoutine: CMBitmapCallBackUPP): boolean; external name '_InvokeCMBitmapCallBackUPP'; { old name was CallCMBitmapCallBackProc }
{
 *  InvokeCMConcatCallBackUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in 3.0 and later
 }
function InvokeCMConcatCallBackUPP(progress: SInt32; refCon: UnivPtr; userRoutine: CMConcatCallBackUPP): boolean; external name '_InvokeCMConcatCallBackUPP'; { old name was CallCMConcatCallBackProc }
{
 *  InvokeCMProfileFilterUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in 3.0 and later
 }
function InvokeCMProfileFilterUPP(prof: CMProfileRef; refCon: UnivPtr; userRoutine: CMProfileFilterUPP): boolean; external name '_InvokeCMProfileFilterUPP'; { old name was CallCMProfileFilterProc }
{
 *  InvokeCMProfileAccessUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in 3.0 and later
 }
function InvokeCMProfileAccessUPP(command: SInt32; offset: SInt32; var size: SInt32; data: UnivPtr; refCon: UnivPtr; userRoutine: CMProfileAccessUPP): OSErr; external name '_InvokeCMProfileAccessUPP'; { old name was CallCMProfileAccessProc }
{$ALIGN MAC68K}


{unit CarbonEventsCore}
{
     File:       HIToolbox/CarbonEventsCore.h
 
     Contains:   Carbon Event Manager
 
     Version:    HIToolbox-219.4.81~2
 
     Copyright:   1999-2005 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}
{       Pascal Translation:  Peter N Lewis, <peter@stairways.com.au>, August 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}

{======================================================================================}
{  The core data structure of the Carbon Event system                                  }
{======================================================================================}
type
	EventRef = ^SInt32; { an opaque 32-bit type }
{======================================================================================}
{  EVENT COMMON                                                                        }
{======================================================================================}


{
 *  Discussion:
 *    The following are all errors which can be returned from the
 *    routines contained in this file.
 }
const
{
   * This is returned from PostEventToQueue if the event in question is
   * already in the queue you are posting it to (or any other queue).
   }
	eventAlreadyPostedErr = -9860;

  {
   * You are attemtping to modify a target that is currently in use,
   * such as when dispatching.
   }
	eventTargetBusyErr = -9861;

  {
   * This is obsolete and will be removed.
   }
	eventClassInvalidErr = -9862;

  {
   * This is obsolete and will be removed.
   }
	eventClassIncorrectErr = -9864;

  {
   * This is what you should return from a kEventClassAccessibility
   * event handler when asked to process a directly dispached event
   * that would cause your handler proc to not return after more than a
   * split-second. This will cause the accessibility engine to defer
   * the event until a later time when your handler will be able to
   * take all the time it needs without causing timeout problems for
   * the assistive application. See kEventClassAccessibility and
   * kEventAccessiblePerformNamedAction for more information. You
   * should only return this on Mac OS X 10.3 and later; earlier
   * versions will treat this like a true failure, which prevents
   * assistive applications from getting the functionality they need.
   }
	eventDeferAccessibilityEventErr = -9865;

  {
   * Returned from InstallEventHandler if the handler proc you pass is
   * already installed for a given event type you are trying to
   * register.
   }
	eventHandlerAlreadyInstalledErr = -9866;

  {
   * A generic error.
   }
	eventInternalErr = -9868;

  {
   * This is obsolete and will be removed.
   }
	eventKindIncorrectErr = -9869;

  {
   * The piece of data you are requesting from an event is not present.
   }
	eventParameterNotFoundErr = -9870;

  {
   * This is what you should return from an event handler when your
   * handler has received an event it doesn't currently want to (or
   * isn't able to) handle. If you handle an event, you should return
   * noErr from your event handler. Any return value other than
   * eventNotHandledErr will cause event handling to stop; the event
   * will not be sent to any other event handler, and the return value
   * will be provided to the original caller of SendEventToTarget.
   }
	eventNotHandledErr = -9874;

  {
   * The event loop has timed out. This can be returned from calls to
   * ReceiveNextEvent or RunCurrentEventLoop.
   }
	eventLoopTimedOutErr = -9875;

  {
   * The event loop was quit, probably by a call to QuitEventLoop. This
   * can be returned from ReceiveNextEvent or RunCurrentEventLoop.
   }
	eventLoopQuitErr = -9876;

  {
   * Returned from RemoveEventFromQueue when trying to remove an event
   * that's not in any queue.
   }
	eventNotInQueueErr = -9877;

  {
   * Returned from RegisterEventHotKey when an attempt is made to
   * register a hotkey that is already registered in the current
   * process. (Note that it is not an error to register the same hotkey
   * in multiple processes.)
   }
	eventHotKeyExistsErr = -9878;

  {
   * This error code is not currently used.
   }
	eventHotKeyInvalidErr = -9879;

  {
   * When returned from an event handler, causes the event dispatcher
   * to abandon event dispatching on this target, and pass the event to
   * the first handler on the next event target. Any event handlers
   * installed beneath the current handler on the current target will
   * not receive the event. Although newly documented in Mac OS X 10.3,
   * this error code is actually available on Mac OS X 10.0 and
   * CarbonLib 1.3 and later.
   }
	eventPassToNextTargetErr = -9880;

{======================================================================================}
{  EVENT CORE                                                                          }
{======================================================================================}
{}
{   Core Event Parameters                                                             }
{}
const
	kEventParamDirectObject = $2D2D2D2D (* '----' *); { type varies depending on event}
	kEventParamDragRef = $64726167 (* 'drag' *); { typeDragRef}

{}
{   Core Event Types                                                                  }
{}
{
    Some Carbon event data types will be retained when added to an EventRef in
    Mac OS X 10.2 and later, and released when the EventRef is destroyed.
    
        Retained in 10.2 and later:
        
            typeCFStringRef
            typeCFMutableStringRef
            typeCFMutableArrayRef
            typeCFTypeRef
            typeHIAccessibleObjectRef
            
        Retained in Panther and later:
        
            typeEventRef
            typeCFArrayRef
            typeCFDictionaryRef:
            typeCFMutableDictionaryRef
            
        Retained in Tiger and later:
        
            typeHIShapeRef
            typeMenuRef
            
    Note that other data types may be retained in future releases of Mac OS X.
    Apple recommends that if you need to know whether a particular data type
    (other than the ones documented here) is retained, that you check the retain
    count of an instance of that data type before and after adding it to an EventRef.
}
const
	typeCFStringRef = $63667374 (* 'cfst' *); { CFStringRef}
	typeCFMutableStringRef = $63666D73 (* 'cfms' *); { CFMutableStringRef}
	typeCFArrayRef = $63666172 (* 'cfar' *); { CFArrayRef}
	typeCFMutableArrayRef = $63666D61 (* 'cfma' *); { CFMutableArrayRef}
	typeCFDictionaryRef = $63666463 (* 'cfdc' *); { CFDictionaryRef}
	typeCFMutableDictionaryRef = $63666D64 (* 'cfmd' *); { CFMutableDictionaryRef}
	typeCFTypeRef = $63667479 (* 'cfty' *); { CFTypeRef}
	typeDragRef = $64726167 (* 'drag' *); { DragRef}

{}
{   Event Flags, options                                                              }
{}

{
 *  EventPriority
 *  
 *  Discussion:
 *    These values define the relative priority of an event, and are
 *    used when posting events with PostEventToQueue. In general events
 *    are pulled from the queue in order of first posted to last
 *    posted. These priorities are a way to alter that when posting
 *    events. You can post a standard priority event and then a high
 *    priority event and the high priority event will be pulled from
 *    the queue first.
 }
type
	EventPriority = SInt16;
const
{
   * Lowest priority. Currently only window update events are posted at
   * this priority.
   }
	kEventPriorityLow = 0;

  {
   * Normal priority of events. Most events are standard priority.
   }
	kEventPriorityStandard = 1;

  {
   * Highest priority.
   }
	kEventPriorityHigh = 2;

const
	kEventLeaveInQueue = false;
	kEventRemoveFromQueue = true;

{}
{  Event Times                                                                        }
{ EventTime is in seconds since boot. Use the constants to make life easy.             }
{}
type
	EventTime = Float64;
	EventTimePtr = ^EventTime;
type
	EventTimeout = EventTime;
	EventTimeoutPtr = ^EventTimeout;
type
	EventTimerInterval = EventTime;
	EventTimerIntervalPtr = ^EventTimerInterval;

const
	kEventDurationSecond		= 1.0;
	kEventDurationMillisecond	= kEventDurationSecond/1000;
	kEventDurationMicrosecond	= kEventDurationSecond/1000000;
	kEventDurationNanosecond	= kEventDurationSecond/1000000000;
	kEventDurationMinute		= kEventDurationSecond*60;
	kEventDurationHour			= kEventDurationMinute*60;
	kEventDurationDay			= kEventDurationHour*24;
	kEventDurationNoWait		= 0.0;
	kEventDurationForever		= -1.0;

{ Helpful doodads to convert to and from ticks and event times}
//    #define TicksToEventTime( t )   ((EventTime)( (t) / 60.0 ))
//    #define EventTimeToTicks( t )   ((UInt32)( ((t) * 60) + 0.5 ))


{}
{ EventTypeSpec structure                                                              }
{ This structure is used in many routines to pass a list of event types to a function. }
{ You typically would declare a const array of these types to pass in.                 }
{}

{
 *  EventTypeSpec
 *  
 *  Discussion:
 *    This structure is used to specify an event. Typically, a static
 *    array of EventTypeSpecs are passed into functions such as
 *    InstallEventHandler, as well as routines such as
 *    FlushEventsMatchingListFromQueue.
 }
type
	EventTypeSpec = record
		eventClass: UInt32;
		eventKind: UInt32;
	end;
	EventTypeSpecPtr = ^EventTypeSpec;
{A helpful macro for dealing with EventTypeSpecs }
// #define GetEventTypeCount( t )  (sizeof( (t) ) / sizeof( EventTypeSpec ))

type
	EventParamName = OSType;
	EventParamNamePtr = ^EventParamName;
	EventParamType = OSType;
	EventParamTypePtr = ^EventParamType;
{}
{   EventLoop                                                                         }
{}

{
 *  EventLoopRef
 *  
 *  Discussion:
 *    An EventLoopRef represents an 'event loop', which is the
 *    conceptual entity that you 'run' to fetch events from hardware
 *    and other sources and also fires timers that might be installed
 *    with InstallEventLoopTimer. The term 'run' is a bit of a
 *    misnomer, as the event loop's goal is to stay as blocked as
 *    possible to minimize CPU usage for the current application. The
 *    event loop is run implicitly thru APIs like ReceiveNextEvent,
 *    RunApplicationEventLoop, or even WaitNextEvent. It can also be
 *    run explicitly thru a call to RunCurrentEventLoop. Each
 *    preemptive thread can have an event loop. Cooperative threads
 *    share the main thread's event loop.
 }
type
	EventLoopRef = ^SInt32; { an opaque 32-bit type }
{
 *  GetCurrentEventLoop()
 *  
 *  Discussion:
 *    Returns the current event loop for the current thread. If the
 *    current thread is a cooperative thread, the main event loop is
 *    returned.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Result:
 *    An event loop reference.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function GetCurrentEventLoop: EventLoopRef; external name '_GetCurrentEventLoop';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  GetMainEventLoop()
 *  
 *  Discussion:
 *    Returns the event loop object for the main application thread.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Result:
 *    An event loop reference.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function GetMainEventLoop: EventLoopRef; external name '_GetMainEventLoop';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  RunCurrentEventLoop()
 *  
 *  Discussion:
 *    This routine 'runs' the event loop, returning only if aborted or
 *    the timeout specified is reached. The event loop is mostly
 *    blocked while in this function, occasionally waking up to fire
 *    timers or pick up events. The typical use of this function is to
 *    cause the current thread to wait for some operation to complete,
 *    most likely on another thread of execution.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inTimeout:
 *      The time to wait until returning (can be kEventDurationForever).
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function RunCurrentEventLoop( inTimeout: EventTimeout ): OSStatus; external name '_RunCurrentEventLoop';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  QuitEventLoop()
 *  
 *  Discussion:
 *    Causes a specific event loop to terminate. Usage of this is
 *    similar to WakeUpProcess, in that it causes the eventloop
 *    specified to return immediately (as opposed to timing out).
 *    Typically this call is used in conjunction with
 *    RunCurrentEventLoop.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inEventLoop:
 *      The event loop to terminate.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function QuitEventLoop( inEventLoop: EventLoopRef ): OSStatus; external name '_QuitEventLoop';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  GetCFRunLoopFromEventLoop()
 *  
 *  Discussion:
 *    Returns the corresponding CFRunLoopRef for the given EventLoop.
 *    This is not necessarily a one-to-one mapping, hence the need for
 *    this function. In Carbon, all cooperative threads use the same
 *    run loop under the covers, so using CFRunLoopGetCurrent might
 *    yield the wrong result. In general, you would only need to use
 *    this function if you wished to add your own sources to the run
 *    loop. If you don't know what I'm talking about, then you probably
 *    don't need to use this.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inEventLoop:
 *      The event loop to get the CFRunLoop for.
 *  
 *  Result:
 *    The CFRunLoopRef for inEventLoop.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.1 and later in Carbon.framework
 *    CarbonLib:        not available in CarbonLib 1.x, is available on Mac OS X version 10.1 and later
 *    Non-Carbon CFM:   not available
 }
function GetCFRunLoopFromEventLoop( inEventLoop: EventLoopRef ): CFTypeRef; external name '_GetCFRunLoopFromEventLoop';
(* AVAILABLE_MAC_OS_X_VERSION_10_1_AND_LATER *)


{}
{   Low-level event fetching                                                          }
{}
{
 *  ReceiveNextEvent()
 *  
 *  Discussion:
 *    This routine tries to fetch the next event of a specified type.
 *    If no events in the event queue match, this routine will run the
 *    current event loop until an event that matches arrives, or the
 *    timeout expires. Except for timers firing, your application is
 *    blocked waiting for events to arrive when inside this function.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inNumTypes:
 *      The number of event types we are waiting for (0 if any event
 *      should cause this routine to return).
 *    
 *    inList:
 *      The list of event types we are waiting for (pass NULL if any
 *      event should cause this routine to return).
 *    
 *    inTimeout:
 *      The time to wait (passing kEventDurationForever is preferred).
 *    
 *    inPullEvent:
 *      Pass true for this parameter to actually remove the next
 *      matching event from the queue.
 *    
 *    outEvent:
 *      The next event that matches the list passed in. If inPullEvent
 *      is true, the event is owned by you, and you will need to
 *      release it when done.
 *  
 *  Result:
 *    A result indicating whether an event was received, the timeout
 *    expired, or the current event loop was quit.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function ReceiveNextEvent( inNumTypes: UInt32; {const} inList: {variable-size-array} EventTypeSpecPtr; inTimeout: EventTimeout; inPullEvent: Boolean; var outEvent: EventRef ): OSStatus; external name '_ReceiveNextEvent';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{}
{   Core event lifetime APIs                                                          }
{}

{
 *  EventAttributes
 *  
 *  Summary:
 *    Attributes of a Carbon event.
 }
type
	EventAttributes = UInt32;
const
{
   * The absence of any attributes.
   }
	kEventAttributeNone = 0;

  {
   * Indicates that the event is considered user input; for example, a
   * mouse event or keyboard event. Not appropriate for higher-level
   * events such as a window update or activate.
   }
	kEventAttributeUserEvent = 1 shl 0;

  {
   * This event was not originally targeted to this process, but has
   * been provided to this process because someone has installed an
   * event handler for this event type on the event monitoring target.
   * Events with this attribute are sent directly to the event monitor
   * target by the event dispatcher.
   }
	kEventAttributeMonitored = 1 shl 3;

{
 *  [Mac]CreateEvent()
 *  
 *  Summary:
 *    Creates a new Carbon event.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inAllocator:
 *      The CFAllocator to use to allocate the event data. You can pass
 *      NULL or kCFAllocatorDefault to use the standard allocator.
 *    
 *    inClassID:
 *      The event class for the event.
 *    
 *    inKind:
 *      The event kind for the event.
 *    
 *    inWhen:
 *      The event timestamp to be recorded in the event. You may pass 0
 *      to indicate the current time.
 *    
 *    inAttributes:
 *      The event attributes. Typically this should be
 *      kEventAttributeNone.
 *    
 *    outEvent:
 *      On exit, contains the new event.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function CreateEvent( inAllocator: CFAllocatorRef { can be NULL }; inClassID: UInt32; inKind: UInt32; inWhen: EventTime; inAttributes: EventAttributes; var outEvent: EventRef ): OSStatus; external name '_CreateEvent';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)
function MacCreateEvent__NAMED_CreateEvent( inAllocator: CFAllocatorRef { can be NULL }; inClassID: UInt32; inKind: UInt32; inWhen: EventTime; inAttributes: EventAttributes; var outEvent: EventRef ): OSStatus; external name '_MacCreateEvent__NAMED_CreateEvent';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  CopyEvent()
 *  
 *  Summary:
 *    Copies an existing event.
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Parameters:
 *    
 *    inOther:
 *      The original event to copy.
 *  
 *  Result:
 *    The newly created event, or NULL if either the input event was
 *    NULL or the memory for the event could not be allocated. The new
 *    event is allocated using the same allocator as the original event.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function CopyEvent( inOther: EventRef ): EventRef; external name '_CopyEvent';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  CopyEventAs()
 *  
 *  Summary:
 *    Copies an existing event, allowing you to change the class and
 *    kind of the event.
 *  
 *  Discussion:
 *    CopyEventAs may be useful during event flow and transformation.
 *    For example, this API is used when upgrading a raw mouse down to
 *    a window click event, to ensure that the window click event has
 *    exactly the same parameters as the original mouse down event.
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Parameters:
 *    
 *    inAllocator:
 *      The CFAllocator to use to allocate the event data. You can pass
 *      NULL or kCFAllocatorDefault to use the standard allocator.
 *    
 *    inOther:
 *      The original event to copy.
 *    
 *    inEventClass:
 *      The new event class for the copy of the event.
 *    
 *    inEventKind:
 *      The new event kind for the copy of the event.
 *  
 *  Result:
 *    The newly created event, or NULL if either the input event was
 *    NULL or the memory for the event could not be allocated.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.3 and later in Carbon.framework
 *    CarbonLib:        not available in CarbonLib 1.x, is available on Mac OS X version 10.3 and later
 *    Non-Carbon CFM:   not available
 }
function CopyEventAs( inAllocator: CFAllocatorRef { can be NULL }; inOther: EventRef; inEventClass: UInt32; inEventKind: UInt32 ): EventRef; external name '_CopyEventAs';
(* AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER *)


{
 *  RetainEvent()
 *  
 *  Summary:
 *    Increments the retain count of an event.
 *  
 *  Discussion:
 *    Note that EventRefs are not CoreFoundation types, and therefore
 *    you cannot use CFRetain on an EventRef; you must use RetainEvent.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inEvent:
 *      The event to retain.
 *  
 *  Result:
 *    The event that was retained.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function RetainEvent( inEvent: EventRef ): EventRef; external name '_RetainEvent';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  GetEventRetainCount()
 *  
 *  Summary:
 *    Returns the retain count of an event.
 *  
 *  Discussion:
 *    Note that EventRefs are not CoreFoundation types, and therefore
 *    you cannot use CFGetRetainCount on an EventRef; you must use
 *    GetEventRetainCount.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inEvent:
 *      The event whose retain count to return.
 *  
 *  Result:
 *    The event's retain count.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function GetEventRetainCount( inEvent: EventRef ): UInt32; external name '_GetEventRetainCount';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  ReleaseEvent()
 *  
 *  Summary:
 *    Decrements the retain count of an event. If the retain count
 *    reaches zero, the event is destroyed.
 *  
 *  Discussion:
 *    Note that EventRefs are not CoreFoundation types, and therefore
 *    you cannot use CFRelease on an EventRef; you must use
 *    ReleaseEvent.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inEvent:
 *      The event to release.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
procedure ReleaseEvent( inEvent: EventRef ); external name '_ReleaseEvent';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  SetEventParameter()
 *  
 *  Summary:
 *    Sets a piece of data for the given event.
 *  
 *  Discussion:
 *    SetEventParameter is thread-safe to the extent of allowing
 *    multiple threads to each modify a separate event, but it is not
 *    safe to have multiple threads call SetEventParameter on the same
 *    event. Multiple threads modifying the same event can cause
 *    corruption of the event data.
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Parameters:
 *    
 *    inEvent:
 *      The event to set the data for.
 *    
 *    inName:
 *      The symbolic name of the parameter.
 *    
 *    inType:
 *      The symbolic type of the parameter.
 *    
 *    inSize:
 *      The size of the parameter data.
 *    
 *    inDataPtr:
 *      The pointer to the parameter data.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function SetEventParameter( inEvent: EventRef; inName: EventParamName; inType: EventParamType; inSize: UInt32; inDataPtr: {const} UnivPtr ): OSStatus; external name '_SetEventParameter';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  GetEventParameter()
 *  
 *  Discussion:
 *    Gets a piece of data from the given event, if it exists.
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Parameters:
 *    
 *    inEvent:
 *      The event to get the parameter from.
 *    
 *    inName:
 *      The symbolic name of the parameter.
 *    
 *    inDesiredType:
 *      The desired type of the parameter. The Carbon Event Manager
 *      will automatically use AppleEvent coercion handlers to convert
 *      the data in the event into the desired type, if possible. You
 *      may also pass typeWildCard to request that the data be returned
 *      in its original format.
 *    
 *    outActualType:
 *      The actual type of the parameter, or NULL if you are not
 *      interested in receiving this information.
 *    
 *    inBufferSize:
 *      The size of the output buffer specified by ioBuffer. You may
 *      pass zero for this parameter and NULL for the outData parameter
 *      if you don't want the data returned.
 *    
 *    outActualSize:
 *      The actual size of the data, or NULL if you don't want this
 *      information.
 *    
 *    outData:
 *      The pointer to the buffer which will receive the parameter
 *      data, or NULL if you don't want the data returned. If you pass
 *      NULL, you must also pass zero for the inBufferSize parameter.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function GetEventParameter( inEvent: EventRef; inName: EventParamName; inDesiredType: EventParamType; outActualType: EventParamTypePtr { can be NULL }; inBufferSize: UInt32; outActualSize: UInt32Ptr { can be NULL }; outData: UnivPtr { can be NULL } ): OSStatus; external name '_GetEventParameter';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{}
{   Getters for 'base-class' event info                                               }
{}
{
 *  GetEventClass()
 *  
 *  Discussion:
 *    Returns the class of the given event, such as mouse, keyboard,
 *    etc.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inEvent:
 *      The event in question.
 *  
 *  Result:
 *    The class ID of the event.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function GetEventClass( inEvent: EventRef ): UInt32; external name '_GetEventClass';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  GetEventKind()
 *  
 *  Discussion:
 *    Returns the kind of the given event (mousedown, etc.). Event
 *    kinds overlap between event classes, e.g. kEventMouseDown and
 *    kEventAppActivated have the same value (1). The combination of
 *    class and kind is what determines an event signature.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inEvent:
 *      The event in question.
 *  
 *  Result:
 *    The kind of the event.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function GetEventKind( inEvent: EventRef ): UInt32; external name '_GetEventKind';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  GetEventTime()
 *  
 *  Discussion:
 *    Returns the time the event specified occurred, specified in
 *    EventTime, which is a floating point number representing seconds
 *    since the last system startup.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inEvent:
 *      The event in question.
 *  
 *  Result:
 *    The time the event occurred.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function GetEventTime( inEvent: EventRef ): EventTime; external name '_GetEventTime';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{}
{   Setters for 'base-class' event info                                               }
{}
{
 *  SetEventTime()
 *  
 *  Discussion:
 *    This routine allows you to set the time of a given event, if you
 *    so desire. In general, you would never use this routine, except
 *    for those special cases where you reuse an event from time to
 *    time instead of creating a new event each time.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inEvent:
 *      The event in question.
 *    
 *    inTime:
 *      The new time.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function SetEventTime( inEvent: EventRef; inTime: EventTime ): OSStatus; external name '_SetEventTime';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{}
{   Event Queue routines (posting, finding, flushing)                                 }
{}

type
	EventQueueRef = ^SInt32; { an opaque 32-bit type }
{
 *  GetCurrentEventQueue()
 *  
 *  Discussion:
 *    Returns the current event queue for the current thread. If the
 *    current thread is a cooperative thread, the main event queue is
 *    returned.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Result:
 *    An event queue reference.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function GetCurrentEventQueue: EventQueueRef; external name '_GetCurrentEventQueue';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  GetMainEventQueue()
 *  
 *  Discussion:
 *    Returns the event queue object for the main application thread.
 *    
 *    
 *    GetMainEventQueue is threadsafe in Mac OS X 10.4 and later. On
 *    earlier versions of Mac OS X, you should call GetMainEventQueue
 *    once before creating any other threads if those other threads
 *    will be calling GetMainEventQueue themselves.
 *  
 *  Mac OS X threading:
 *    Thread safe since version 10.4
 *  
 *  Result:
 *    An event queue reference.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function GetMainEventQueue: EventQueueRef; external name '_GetMainEventQueue';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  EventComparatorProcPtr
 *  
 *  Discussion:
 *    Type of a callback function used by queue searches.
 *  
 *  Parameters:
 *    
 *    inEvent:
 *      The event to compare.
 *    
 *    inCompareData:
 *      The data used to compare the event.
 *  
 *  Result:
 *    A boolean value indicating whether the event matches (true) or
 *    not (false).
 }
type
	EventComparatorProcPtr = function( inEvent: EventRef; inCompareData: UnivPtr ): Boolean;
type
	EventComparatorUPP = EventComparatorProcPtr;
{
 *  NewEventComparatorUPP()
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   available as macro/inline
 }
function NewEventComparatorUPP( userRoutine: EventComparatorProcPtr ): EventComparatorUPP; external name '_NewEventComparatorUPP';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)

{
 *  DisposeEventComparatorUPP()
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   available as macro/inline
 }
procedure DisposeEventComparatorUPP( userUPP: EventComparatorUPP ); external name '_DisposeEventComparatorUPP';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)

{
 *  InvokeEventComparatorUPP()
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   available as macro/inline
 }
function InvokeEventComparatorUPP( inEvent: EventRef; inCompareData: UnivPtr; userUPP: EventComparatorUPP ): Boolean; external name '_InvokeEventComparatorUPP';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)

{
 *  PostEventToQueue()
 *  
 *  Discussion:
 *    Posts an event to the specified queue and increments the event's
 *    retain count. This automatically wakes up the event loop of the
 *    thread the queue belongs to. After posting the event, you may
 *    release the event, since it is retained by the queue.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inQueue:
 *      The event queue to post the event onto.
 *    
 *    inEvent:
 *      The event to post.
 *    
 *    inPriority:
 *      The priority of the event.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function PostEventToQueue( inQueue: EventQueueRef; inEvent: EventRef; inPriority: EventPriority ): OSStatus; external name '_PostEventToQueue';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  FlushEventsMatchingListFromQueue()
 *  
 *  Discussion:
 *    Flushes events matching a specified list of classes and kinds
 *    from an event queue.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inQueue:
 *      The event queue to flush events from.
 *    
 *    inNumTypes:
 *      The number of event kinds to flush.
 *    
 *    inList:
 *      The list of event classes and kinds to flush from the queue.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function FlushEventsMatchingListFromQueue( inQueue: EventQueueRef; inNumTypes: UInt32; {const} inList: {variable-size-array} EventTypeSpecPtr ): OSStatus; external name '_FlushEventsMatchingListFromQueue';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  FlushSpecificEventsFromQueue()
 *  
 *  Discussion:
 *    Flushes events that match a comparator function.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inQueue:
 *      The event queue to flush events from.
 *    
 *    inComparator:
 *      The comparison function to invoke for each event in the queue.
 *    
 *    inCompareData:
 *      The data you wish to pass to your comparison function.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function FlushSpecificEventsFromQueue( inQueue: EventQueueRef; inComparator: EventComparatorUPP; inCompareData: UnivPtr ): OSStatus; external name '_FlushSpecificEventsFromQueue';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  FlushEventQueue()
 *  
 *  Discussion:
 *    Flushes all events from an event queue.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inQueue:
 *      The event queue to flush.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function FlushEventQueue( inQueue: EventQueueRef ): OSStatus; external name '_FlushEventQueue';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  FindSpecificEventInQueue()
 *  
 *  Discussion:
 *    Returns the first event that matches a comparator function, or
 *    NULL if no events match.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inQueue:
 *      The event queue to search.
 *    
 *    inComparator:
 *      The comparison function to invoke for each event in the queue.
 *    
 *    inCompareData:
 *      The data you wish to pass to your comparison function.
 *  
 *  Result:
 *    An event reference. The event is still in the queue when
 *    FindSpecificEventInQueue returns; you can remove it from the
 *    queue with RemoveEventFromQueue. The returned event does not need
 *    to be released by the caller.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function FindSpecificEventInQueue( inQueue: EventQueueRef; inComparator: EventComparatorUPP; inCompareData: UnivPtr ): EventRef; external name '_FindSpecificEventInQueue';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  GetNumEventsInQueue()
 *  
 *  Discussion:
 *    Returns the number of events in an event queue.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inQueue:
 *      The event queue to query.
 *  
 *  Result:
 *    The number of items in the queue.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function GetNumEventsInQueue( inQueue: EventQueueRef ): UInt32; external name '_GetNumEventsInQueue';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  RemoveEventFromQueue()
 *  
 *  Discussion:
 *    Removes the given event from the specified queue and decrements
 *    the event's retain count. If it was your intention to hold onto
 *    the event, you must retain the event before removing it from the
 *    queue.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inQueue:
 *      The queue to remove the event from.
 *    
 *    inEvent:
 *      The event to remove.
 *  
 *  Result:
 *    An operating system result code. eventNotInQueueErr is returned
 *    if the event is not actually contained in the specified queue.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function RemoveEventFromQueue( inQueue: EventQueueRef; inEvent: EventRef ): OSStatus; external name '_RemoveEventFromQueue';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  IsEventInQueue()
 *  
 *  Discussion:
 *    Returns true if the specified event is posted to a queue.
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Parameters:
 *    
 *    inQueue:
 *      The queue to check.
 *    
 *    inEvent:
 *      The event in question.
 *  
 *  Result:
 *    A boolean value.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function IsEventInQueue( inQueue: EventQueueRef; inEvent: EventRef ): Boolean; external name '_IsEventInQueue';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


const
{
   * Currently, the only value you can pass to
   * AcquireFirstMatchingEventInQueue in its inOptions parameter.
   }
	kEventQueueOptionsNone = 0;

{
 *  AcquireFirstMatchingEventInQueue()
 *  
 *  Discussion:
 *    Returns the first event that matches the list of event classes
 *    and kinds passed in. This call does not call the event loop, and
 *    hence no timers will fire nor will any window flushing occur when
 *    this API is called. New events will be pulled from the window
 *    server, however. Overall this API should have better performance
 *    characteristics than the older EventAvail API.
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Parameters:
 *    
 *    inQueue:
 *      The queue to check.
 *    
 *    inNumTypes:
 *      The number of event kinds to search for. You may pass zero for
 *      this parameter if you also pass NULL for inList.
 *    
 *    inList:
 *      The list of event classes and kinds to search for in the queue.
 *      You may pass NULL for this parameter if you also pass zero for
 *      inNumTypes. This effectively matches ANY event in the queue,
 *      and will merely return the first event in the queue.
 *    
 *    inOptions:
 *      Currently, you must pass kEventQueueOptionsNone for this
 *      parameter.
 *  
 *  Result:
 *    An event reference, or NULL if no events match the list passed.
 *    The event returned has had its refcount incremented (i.e. it has
 *    been retained). As a result, you must release this value
 *    (assuming it's non-NULL). The event is not removed from the queue
 *    by this API; you should call RemoveEventFromQueue if necessary.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.3 and later in Carbon.framework
 *    CarbonLib:        not available in CarbonLib 1.x, is available on Mac OS X version 10.3 and later
 *    Non-Carbon CFM:   not available
 }
function AcquireFirstMatchingEventInQueue( inQueue: EventQueueRef; inNumTypes: UInt32; {const} inList: {variable-size-array} EventTypeSpecPtr; inOptions: OptionBits ): EventRef; external name '_AcquireFirstMatchingEventInQueue';
(* AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER *)


{}
{  Queue-synchronized event state                                                      }
{}
{
 *  GetCurrentEvent()
 *  
 *  Summary:
 *    Returns the user input event currently being handled.
 *  
 *  Discussion:
 *    When an event with kEventAttributeUserEvent is dispatched by the
 *    event dispatcher target, it is recorded internally by the Event
 *    Manager. At any time during the handling of that event (or of any
 *    other event which is created and sent during the handling of the
 *    original event), GetCurrentEvent may be used to retrieve the
 *    original EventRef.
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Result:
 *    The user input (mouse or keyboard) event currently being handled.
 *    May be NULL if no event is currently being handled, or if the
 *    current event was not a user input event. The returned event is
 *    not retained, and its lifetime should be considered to be no
 *    longer than the current function; if you need to keep the event
 *    alive past that time, you should retain it.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.2 and later in Carbon.framework
 *    CarbonLib:        not available in CarbonLib 1.x, is available on Mac OS X version 10.2 and later
 *    Non-Carbon CFM:   not available
 }
function GetCurrentEvent: EventRef; external name '_GetCurrentEvent';
(* AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER *)


{
 *  GetCurrentEventButtonState()
 *  
 *  Summary:
 *    Returns the current queue-synchronized mouse button state on the
 *    primary input device.
 *  
 *  Discussion:
 *    At any point in the handling of user input, there are two
 *    different mouse button states: the queue-synchronized state and
 *    the hardware state. The hardware state reflects the actual
 *    current state of the mouse attached to the user's machine. The
 *    queue-synchronized state reflects the state according to the
 *    events that have been processed at that point by the application.
 *    These two states may be different if there are unprocessed events
 *    in the event queue, or if events are being artificially
 *    introduced into the event queue from an outside source.
 *    GetCurrentEventButtonState returns the queue-synchronized button
 *    state. This state is determined by user input events that are
 *    sent through the event dispatcher target; whenever a user input
 *    event (mouse or keyboard) is handled by the Carbon event
 *    dispatcher, its button state is recorded, and that button state
 *    will be returned by GetCurrentEventButtonState. 
 *    
 *    The "current event" referenced in the API name is the event most
 *    recently dispatched through the event dispatcher target, which is
 *    not necessarily the event that your event handler is handling.
 *    For example, if a mouse-down event occurs, and you have a handler
 *    for the kEventWindowHandleContentClick event that is generated
 *    from the mouse-down, then the button state will be that which was
 *    attached to the mouse-down. The ContentClick event itself does
 *    also have MouseButton and MouseChord parameters, which are copied
 *    from the the mouse-down event, but GetCurrentEventButtonState
 *    returns the button state from the mouse-down, not from the
 *    ContentClick event, since it was the mouse-down that was most
 *    recently dispatched through the event dispatcher. Usually, this
 *    is the behavior that you want anyways. 
 *    
 *    Note that events that are not sent through the event dispatcher
 *    target will not update the current event button state. Also, note
 *    that events arriving from outside the application, such as an
 *    AppleEvent or an Accessibility event, also will not update the
 *    modifiers. If your application modifies its behavior based on
 *    button state, we recommend that you parameterize your core code
 *    with the event buttons, and determine the button state based on
 *    the origin of the behavior request. For a request that originates
 *    directly from user input, you can use GetCurrentEventButtonState,
 *    but for a request that originates from an AppleEvent or
 *    Accessibility event, you would probably use no button state, or
 *    perhaps just left-button-pressed. 
 *    
 *    It is generally better to use this API than to use the Button
 *    function or the GetCurrentButtonState function (which return the
 *    hardware state). This gives a more consistent user experience
 *    when the user input queue is being remoted controlled or
 *    manipulated via non-hardware event sources such as speech or
 *    AppleEvents; using GetCurrentEventButtonState is also much faster
 *    than using Button or GetCurrentButtonState.
 *    
 *    Note that GetCurrentEventButtonState only returns a valid button
 *    state if your application is the active application. If your
 *    application is not active, then user input events are not flowing
 *    through the event dispatcher and the queue-synchronized state is
 *    not updated.
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Result:
 *    The queue-synchronized state of the mouse buttons. Bit zero
 *    indicates the state of the primary button, bit one the state of
 *    the secondary button, and so on.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.2 and later in Carbon.framework
 *    CarbonLib:        not available in CarbonLib 1.x, is available on Mac OS X version 10.2 and later
 *    Non-Carbon CFM:   not available
 }
function GetCurrentEventButtonState: UInt32; external name '_GetCurrentEventButtonState';
(* AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER *)


{
 *  GetCurrentEventKeyModifiers()
 *  
 *  Summary:
 *    Returns the current queue-synchronized keyboard modifier state.
 *  
 *  Discussion:
 *    At any point in the handling of user input, there are two
 *    different keyboard modifier states: the queue-synchronized state
 *    and the hardware state. The hardware state reflects the actual
 *    current state of the keyboard attached to the user's machine. The
 *    queue-synchronized state reflects the state according to the
 *    events that have been processed at that point by the application.
 *    These two states may be different if there are unprocessed events
 *    in the event queue, or if events are being artificially
 *    introduced into the event queue from an outside source.
 *    GetCurrentEventKeyModifiers returns the queue-synchronized
 *    modifier state. This state is determined by user input events
 *    that are sent through the event dispatcher target; whenever a
 *    user input event (mouse or keyboard) is handled by the Carbon
 *    event dispatcher, its modifiers are recorded, and those modifiers
 *    will be returned by GetCurrentEventKeyModifiers. 
 *    
 *    The "current event" referenced in the API name is the event most
 *    recently dispatched through the event dispatcher target, which is
 *    not necessarily the event that your event handler is handling.
 *    For example, if a mouse-down event occurs, and you have a handler
 *    for the kEventWindowHandleContentClick event that is generated
 *    from the mouse-down, then the modifiers will be those that were
 *    attached to the mouse-down. The ContentClick event itself does
 *    also have a KeyModifiers parameter, which is copied from the
 *    mouse-down event, but GetCurrentEventKeyModifiers returns the
 *    modifiers from the mouse-down, not from the ContentClick event,
 *    since it was the mouse-down that was most recently dispatched
 *    through the event dispatcher. Usually, this is the behavior that
 *    you want anyways. 
 *    
 *    Note that events that are not sent through the event dispatcher
 *    target will not update the current event key modifiers. Also,
 *    note that events arriving from outside the application, such as
 *    an AppleEvent or an Accessibility event, also will not update the
 *    modifiers. If your application modifies its behavior based on
 *    modifier state, we recommend that you parameterize your core code
 *    with the event modifiers, and determine the modifiers based on
 *    the origin of the behavior request. For a request that originates
 *    directly from user input, you can use
 *    GetCurrentEventKeyModifiers, but for a request that originates
 *    from an AppleEvent or Accessibility event, you would probably use
 *    no modifiers. 
 *    BR> It is generally better to use this API than to use the
 *    GetCurrentKeyModifiers API (which returns the hardware state).
 *    This gives a more consistent user experience when the user input
 *    queue is being remoted controlled or manipulated via non-hardware
 *    event sources such as speech or AppleEvents; using
 *    GetCurrentEventKeyModifiers is also much faster than using
 *    EventAvail(0, &eventRecord) or GetCurrentKeyModifiers.
 *    
 *    Note that GetCurrentEventKeyModifiers only returns a valid
 *    modifier state if your application is the active application. If
 *    your application is not active, then user input events are not
 *    flowing through the event dispatcher and the queue-synchronized
 *    state is not updated.
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Result:
 *    The queue-synchronized state of the keyboard modifiers. The
 *    format of the return value is the same as the modifiers field of
 *    an EventRecord (but only includes keyboard modifiers and not the
 *    other modifier flags included in an EventRecord).
 *  
 *  Availability:
 *    Mac OS X:         in version 10.2 and later in Carbon.framework
 *    CarbonLib:        not available in CarbonLib 1.x, is available on Mac OS X version 10.2 and later
 *    Non-Carbon CFM:   not available
 }
function GetCurrentEventKeyModifiers: UInt32; external name '_GetCurrentEventKeyModifiers';
(* AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER *)


{}
{  Multiple-button support                                                             }
{}
{
 *  GetCurrentButtonState()
 *  
 *  Summary:
 *    Returns the current hardware mouse button state on the primary
 *    input device.
 *  
 *  Discussion:
 *    In most cases, you should not use GetCurrentButtonState, but
 *    should use the GetCurrentEventButtonState function instead.
 *    GetCurrentEventButtonState is much faster than
 *    GetCurrentButtonState because it returns the locally cached
 *    button state; GetCurrentButtonState must get the mouse button
 *    state from the window server, which is slower. Using
 *    GetCurrentButtonState also can prevent your application from
 *    being operated by remote posting of events, since the hardware
 *    input device is not actually changing state in that case. Most
 *    commonly, you might need to use GetCurrentButtonState when your
 *    application is not the active application (as determined by the
 *    Process Manager function GetFrontProcess). In that case, the
 *    cached button state returned by GetCurrentEventButtonState is not
 *    valid because mouse button events are not flowing to your
 *    application, and you must use GetCurrentButtonState to determine
 *    the current hardware state.
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Result:
 *    The state of the mouse buttons on the mouse hardware. Bit zero
 *    indicates the state of the primary button, bit one the state of
 *    the secondary button, and so on.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.2 and later in Carbon.framework
 *    CarbonLib:        not available in CarbonLib 1.x, is available on Mac OS X version 10.2 and later
 *    Non-Carbon CFM:   not available
 }
function GetCurrentButtonState: UInt32; external name '_GetCurrentButtonState';
(* AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER *)


{}
{   Helpful utilities                                                                 }
{}

{
 *  GetCurrentEventTime()
 *  
 *  Discussion:
 *    Returns the current time since last system startup in seconds.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Result:
 *    EventTime.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function GetCurrentEventTime: EventTime; external name '_GetCurrentEventTime';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{}
{   Timers                                                                            }
{}

{
 *  EventLoopTimerRef
 *  
 *  Discussion:
 *    An EventLoopTimerRef represents what we term a 'timer'. A timer
 *    is a function that is called either once or at regular intervals.
 *    It executes at task level and should not be confused with Time
 *    Manager Tasks or any other interrupt-level callback. This means
 *    you can call Toolbox routines, allocate memory and draw. When a
 *    timer 'fires', it calls a callback that you specify when the
 *    timer is installed. Timers in general have two uses - as a
 *    timeout mechanism and as a periodic task. An everyday example of
 *    using a timer for a timeout might be a light that goes out if no
 *    motion is detected in a room for 5 minutes. For this, you might
 *    install a timer which will fire in 5 minutes. If motion is
 *    detected, you would reset the timer fire time and let the clock
 *    start over. If no motion is detected for the full 5 minutes, the
 *    timer will fire and you could power off the light. A periodic
 *    timer is one that fires at regular intervals (say every second or
 *    so). You might use such a timer to blink the insertion point in
 *    your editor, etc. One advantage of timers is that you can install
 *    the timer right from the code that wants the time. For example,
 *    the standard Toolbox Edit Text control can install a timer to
 *    blink the cursor when it's active, meaning that IdleControls is a
 *    no-op for that control and doesn't need to be called. When the
 *    control is inactive, it removes its timer and doesn't waste CPU
 *    time in that state. NOTE: Currently, if you do decide to draw
 *    when your timer is called, be sure to save and restore the
 *    current port so that calling your timer doesn't inadvertently
 *    change the port out from under someone.
 }
type
	EventLoopTimerRef = ^SInt32; { an opaque 32-bit type }

{
 *  EventLoopTimerProcPtr
 *  
 *  Discussion:
 *    Called when a timer fires.
 *  
 *  Parameters:
 *    
 *    inTimer:
 *      The timer that fired.
 *    
 *    inUserData:
 *      The data passed into InstallEventLoopTimer.
 }
type
	EventLoopTimerProcPtr = procedure( inTimer: EventLoopTimerRef; inUserData: UnivPtr );

{
 *  Discussion:
 *    Event Loop Idle Timer Messages
 }
const
{
   * The user has gone idle (not touched an input device) for the
   * duration specified in your idle timer. This is the first message
   * you will receive. Start your engines!
   }
	kEventLoopIdleTimerStarted = 1;

  {
   * If you specified an interval on your idle timer, your idle timer
   * proc will be called with this message, letting you know it is
   * merely firing at the interval specified. You will receive this
   * message for the first time at the specified interval after you
   * receive kEventLoopIdleTimerStarted. If you did not specify an
   * interval, this message is not sent.
   }
	kEventLoopIdleTimerIdling = 2;

  {
   * The user is back! Stop everything! This is your cue to stop any
   * processing if you need to.
   }
	kEventLoopIdleTimerStopped = 3;

type
	EventLoopIdleTimerMessage = UInt16;

{
 *  EventLoopIdleTimerProcPtr
 *  
 *  Discussion:
 *    Called when an idle timer fires.
 *  
 *  Parameters:
 *    
 *    inTimer:
 *      The timer that fired.
 *    
 *    inState:
 *      The current state of the timer.
 *    
 *    inUserData:
 *      The data passed into InstallEventLoopTimer.
 }
type
	EventLoopIdleTimerProcPtr = procedure( inTimer: EventLoopTimerRef; inState: EventLoopIdleTimerMessage; inUserData: UnivPtr );
type
	EventLoopTimerUPP = EventLoopTimerProcPtr;
type
	EventLoopIdleTimerUPP = EventLoopIdleTimerProcPtr;
{
 *  NewEventLoopTimerUPP()
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   available as macro/inline
 }
function NewEventLoopTimerUPP( userRoutine: EventLoopTimerProcPtr ): EventLoopTimerUPP; external name '_NewEventLoopTimerUPP';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)

{
 *  NewEventLoopIdleTimerUPP()
 *  
 *  Availability:
 *    Mac OS X:         in version 10.2 and later in Carbon.framework
 *    CarbonLib:        not available in CarbonLib 1.x, is available on Mac OS X version 10.2 and later
 *    Non-Carbon CFM:   available as macro/inline
 }
function NewEventLoopIdleTimerUPP( userRoutine: EventLoopIdleTimerProcPtr ): EventLoopIdleTimerUPP; external name '_NewEventLoopIdleTimerUPP';
(* AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER *)

{
 *  DisposeEventLoopTimerUPP()
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   available as macro/inline
 }
procedure DisposeEventLoopTimerUPP( userUPP: EventLoopTimerUPP ); external name '_DisposeEventLoopTimerUPP';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)

{
 *  DisposeEventLoopIdleTimerUPP()
 *  
 *  Availability:
 *    Mac OS X:         in version 10.2 and later in Carbon.framework
 *    CarbonLib:        not available in CarbonLib 1.x, is available on Mac OS X version 10.2 and later
 *    Non-Carbon CFM:   available as macro/inline
 }
procedure DisposeEventLoopIdleTimerUPP( userUPP: EventLoopIdleTimerUPP ); external name '_DisposeEventLoopIdleTimerUPP';
(* AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER *)

{
 *  InvokeEventLoopTimerUPP()
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   available as macro/inline
 }
procedure InvokeEventLoopTimerUPP( inTimer: EventLoopTimerRef; inUserData: UnivPtr; userUPP: EventLoopTimerUPP ); external name '_InvokeEventLoopTimerUPP';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)

{
 *  InvokeEventLoopIdleTimerUPP()
 *  
 *  Availability:
 *    Mac OS X:         in version 10.2 and later in Carbon.framework
 *    CarbonLib:        not available in CarbonLib 1.x, is available on Mac OS X version 10.2 and later
 *    Non-Carbon CFM:   available as macro/inline
 }
procedure InvokeEventLoopIdleTimerUPP( inTimer: EventLoopTimerRef; inState: EventLoopIdleTimerMessage; inUserData: UnivPtr; userUPP: EventLoopIdleTimerUPP ); external name '_InvokeEventLoopIdleTimerUPP';
(* AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER *)

{
 *  InstallEventLoopTimer()
 *  
 *  Discussion:
 *    Installs a timer onto the event loop specified. The timer can
 *    either fire once or repeatedly at a specified interval depending
 *    on the parameters passed to this function.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inEventLoop:
 *      The event loop to add the timer.
 *    
 *    inFireDelay:
 *      The delay before first firing this timer (can be 0, to request
 *      that the timer be fired as soon as control returns to your
 *      event loop). In Mac OS X and CarbonLib 1.5 and later, you may
 *      pass kEventDurationForever to stop the timer from firing at all
 *      until SetEventLoopTimerNextFireTime is used to start it; in
 *      earlier CarbonLibs, to achieve the same effect, just pass zero
 *      and then immediately call SetEventLoopTimerNextFireTime( timer,
 *      kEventDurationForever ) before returning control to your event
 *      loop.
 *    
 *    inInterval:
 *      The timer interval (pass 0 for a one-shot timer, which executes
 *      once but does not repeat). In Mac OS X and CarbonLib 1.5 and
 *      later, you may also pass kEventDurationForever to create a
 *      one-shot timer.
 *    
 *    inTimerProc:
 *      The routine to call when the timer fires.
 *    
 *    inTimerData:
 *      Data to pass to the timer proc when called.
 *    
 *    outTimer:
 *      A reference to the newly installed timer.
 *  
 *  Result:
 *    An operating system status code.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function InstallEventLoopTimer( inEventLoop: EventLoopRef; inFireDelay: EventTimerInterval; inInterval: EventTimerInterval; inTimerProc: EventLoopTimerUPP; inTimerData: UnivPtr; var outTimer: EventLoopTimerRef ): OSStatus; external name '_InstallEventLoopTimer';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  InstallEventLoopIdleTimer()
 *  
 *  Discussion:
 *    Installs a timer onto the event loop specified. Idle timers are
 *    only called when there is no user activity occuring in the
 *    application. This means that the user is not actively
 *    clicking/typing, and is also not in the middle of tracking a
 *    control, menu, or window. TrackMouseLocation actually disables
 *    all idle timers automatically for you.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inEventLoop:
 *      The event loop to add the timer.
 *    
 *    inDelay:
 *      The delay before firing this timer after a user input event has
 *      come in. For example, if you want to start your timer 2 seconds
 *      after the user stops typing, etc. you would pass 2.0 into this
 *      parameter. Each time the user types a key (or whatever), this
 *      timer is reset. If we are considered to be idle when an idle
 *      timer is installed, the first time it fires will be inDelay
 *      seconds from the time it is installed. So if you installed it
 *      in the middle of control tracking, say, it wouldn't fire until
 *      the user stopped tracking. But if you installed it at app
 *      startup and the user hasn't typed/clicked, it would fire in
 *      inDelay seconds. On Mac OS X 10.3 and earlier, the delay must
 *      be greater than zero. On Mac OS X 10.4 and later, the delay
 *      must be greather than or equal to zero. You cannot use
 *      kEventDurationForever for the delay.
 *    
 *    inInterval:
 *      The timer interval (pass 0 for a one-shot timer, which executes
 *      once but does not repeat). You may also pass
 *      kEventDurationForever to create a one-shot timer.
 *    
 *    inTimerProc:
 *      The routine to call when the timer fires.
 *    
 *    inTimerData:
 *      Data to pass to the timer proc when called.
 *    
 *    outTimer:
 *      A reference to the newly installed timer.
 *  
 *  Result:
 *    An operating system status code.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.2 and later in Carbon.framework
 *    CarbonLib:        not available in CarbonLib 1.x, is available on Mac OS X version 10.2 and later
 *    Non-Carbon CFM:   not available
 }
function InstallEventLoopIdleTimer( inEventLoop: EventLoopRef; inDelay: EventTimerInterval; inInterval: EventTimerInterval; inTimerProc: EventLoopIdleTimerUPP; inTimerData: UnivPtr; var outTimer: EventLoopTimerRef ): OSStatus; external name '_InstallEventLoopIdleTimer';
(* AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER *)


{
 *  RemoveEventLoopTimer()
 *  
 *  Discussion:
 *    Removes a timer that was previously installed by a call to
 *    InstallEventLoopTimer. You call this function when you are done
 *    using a timer.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inTimer:
 *      The timer to remove.
 *  
 *  Result:
 *    An operating system status code.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function RemoveEventLoopTimer( inTimer: EventLoopTimerRef ): OSStatus; external name '_RemoveEventLoopTimer';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  SetEventLoopTimerNextFireTime()
 *  
 *  Discussion:
 *    This routine is used to 'reset' a timer. It controls the next
 *    time the timer fires. This will override any interval you might
 *    have set. For example, if you have a timer that fires every
 *    second, and you call this function setting the next time to five
 *    seconds from now, the timer will sleep for five seconds, then
 *    fire. It will then resume its one-second interval after that. It
 *    is as if you removed the timer and reinstalled it with a new
 *    first-fire delay.
 *  
 *  Mac OS X threading:
 *    Thread safe
 *  
 *  Parameters:
 *    
 *    inTimer:
 *      The timer to adjust
 *    
 *    inNextFire:
 *      The interval from the current time to wait until firing the
 *      timer again. You may pass kEventDurationForever to stop the
 *      timer from firing at all.
 *  
 *  Result:
 *    An operating system status code.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function SetEventLoopTimerNextFireTime( inTimer: EventLoopTimerRef; inNextFire: EventTimerInterval ): OSStatus; external name '_SetEventLoopTimerNextFireTime';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{======================================================================================}
{  EVENT HANDLERS                                                                      }
{======================================================================================}

type
	EventHandlerRef = ^SInt32; { an opaque 32-bit type }
	EventHandlerRefPtr = ^EventHandlerRef;
	EventHandlerCallRef = ^SInt32; { an opaque 32-bit type }
	EventHandlerCallRefPtr = ^EventHandlerCallRef;

{}
{   EventHandler specification                                                        }
{}
{}
{   C++ Methods as Event Handlers                                                     }
{ To use a C++ method as an Event Handler callback, it must be declared in its class   }
{ as a static method.  Otherwise, the implicit "this" parameter will make the function }
{ not match the EventHandlerProcPtr prototype.                                         }
{}

{
 *  EventHandlerProcPtr
 *  
 *  Discussion:
 *    Callback for receiving events sent to a target this callback is
 *    installed on.
 *  
 *  Parameters:
 *    
 *    inHandlerCallRef:
 *      A reference to the current handler call chain. This is sent to
 *      your handler so that you can call CallNextEventHandler if you
 *      need to.
 *    
 *    inEvent:
 *      The Event.
 *    
 *    inUserData:
 *      The app-specified data you passed in a call to
 *      InstallEventHandler.
 *  
 *  Result:
 *    An operating system result code. Returning noErr indicates you
 *    handled the event. Returning eventNotHandledErr indicates you did
 *    not handle the event and perhaps the toolbox should take other
 *    action.
 }
type
	EventHandlerProcPtr = function( inHandlerCallRef: EventHandlerCallRef; inEvent: EventRef; inUserData: UnivPtr ): OSStatus;
type
	EventHandlerUPP = EventHandlerProcPtr;
{
 *  NewEventHandlerUPP()
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   available as macro/inline
 }
function NewEventHandlerUPP( userRoutine: EventHandlerProcPtr ): EventHandlerUPP; external name '_NewEventHandlerUPP';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)

{
 *  DisposeEventHandlerUPP()
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   available as macro/inline
 }
procedure DisposeEventHandlerUPP( userUPP: EventHandlerUPP ); external name '_DisposeEventHandlerUPP';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)

{
 *  InvokeEventHandlerUPP()
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   available as macro/inline
 }
function InvokeEventHandlerUPP( inHandlerCallRef: EventHandlerCallRef; inEvent: EventRef; inUserData: UnivPtr; userUPP: EventHandlerUPP ): OSStatus; external name '_InvokeEventHandlerUPP';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)

type
	EventTargetRef = ^SInt32; { an opaque 32-bit type }
{}
{   Installing Event Handlers                                                         }
{ Use these routines to install event handlers for a specific toolbox object. You may  }
{ pass zero for inNumTypes and NULL for inList if you need to be in a situation where  }
{ you know you will be receiving events, but not exactly which ones at the time you    }
{ are installing the handler. Later, your application can call the Add/Remove routines }
{ listed below this section.                                                           }
{ You can only install a specific handler once. The combination of inHandler and       }
{ inUserData is considered the 'signature' of a handler. Any attempt to install a new  }
{ handler with the same proc and user data as an already-installed handler will result }
{ in eventHandlerAlreadyInstalledErr. Installing the same proc and user data on a      }
{ different object is legal.                                                           }
{ Upon successful completion of this routine, you are returned an EventHandlerRef,     }
{ which you can use in various other calls. It is not possible to retrieve any         }
{ information from an EventHandlerRef about which object the handler is attached to;   }
{ to keep track of the target object of an event handler, use the inUserData paramter  }
{ to InstallEventHandler to specify the object.                                        }
{}
{
 *  InstallEventHandler()
 *  
 *  Discussion:
 *    Installs an event handler on a specified target. Your handler
 *    proc will be called with the events you registered with when an
 *    event of the corresponding type and class are send to the target
 *    you are installing your handler on.
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Parameters:
 *    
 *    inTarget:
 *      The target to register your handler with.
 *    
 *    inHandler:
 *      A pointer to your handler function.
 *    
 *    inNumTypes:
 *      The number of events you are registering for.
 *    
 *    inList:
 *      A pointer to an array of EventTypeSpec entries representing the
 *      events you are interested in.
 *    
 *    inUserData:
 *      The value passed in this parameter is passed on to your event
 *      handler proc when it is called.
 *    
 *    outRef:
 *      Receives an EventHandlerRef, which you can use later to remove
 *      the handler. You can pass null if you don't want the reference
 *      - when the target is disposed, the handler will be disposed as
 *      well.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function InstallEventHandler( inTarget: EventTargetRef; inHandler: EventHandlerUPP; inNumTypes: UInt32; {const} inList: {variable-size-array} EventTypeSpecPtr; inUserData: UnivPtr; outRef: EventHandlerRefPtr { can be NULL } ): OSStatus; external name '_InstallEventHandler';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  InstallStandardEventHandler()
 *  
 *  Summary:
 *    Installs the standard event handler (if any) for an event target.
 *  
 *  Discussion:
 *    All event targets have default handlers installed on them by the
 *    toolbox to perform certain basic operations common to that type
 *    of target. Some targets also have standard handlers which are not
 *    installed by default, but may be requested. A standard handler
 *    typically provides higher-level behavior for its target.
 *    Currently, only window event targets have a standard handler; the
 *    window standard event hander may also be installed by setting the
 *    kWindowStandardHandlerAttribute flag. Calling
 *    InstallStandardEventHandler on any other type of target
 *    (application, control, menu, etc.) has no effect.
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Parameters:
 *    
 *    inTarget:
 *      The target whose standard handler should be installed.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function InstallStandardEventHandler( inTarget: EventTargetRef ): OSStatus; external name '_InstallStandardEventHandler';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  RemoveEventHandler()
 *  
 *  Summary:
 *    Removes an event handler from the target it was bound to.
 *  
 *  Discussion:
 *    As of Mac OS X 10.1, it is safe to remove an event handler from
 *    inside the handler function. This is not safe to do in CarbonLib
 *    or earlier releases of Mac OS X.
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Parameters:
 *    
 *    inHandlerRef:
 *      The handler ref to remove (returned in a call to
 *      InstallEventHandler). After you call this function, the handler
 *      ref is considered to be invalid and can no longer be used.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function RemoveEventHandler( inHandlerRef: EventHandlerRef ): OSStatus; external name '_RemoveEventHandler';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{}
{   Adjusting set of event types after a handler is created                           }
{ After installing a handler with the routine above, you can adjust the event type     }
{ list telling the toolbox what events to send to that handler by calling the two      }
{ routines below. If you add an event type twice for the same handler, your handler    }
{ will only be called once, but it will take two RemoveEventType calls to stop your    }
{ handler from being called with that event type. In other words, the install count    }
{ for each event type is maintained by the toolbox. This might allow you, for example  }
{ to have subclasses of a window object register for types without caring if the base  }
{ class has already registered for that type. When the subclass removes its types, it  }
{ can successfully do so without affecting the base class's reception of its event     }
{ types, yielding eternal bliss.                                                       }
{}

{
 *  AddEventTypesToHandler()
 *  
 *  Discussion:
 *    Adds additional events to an event handler that has already been
 *    installed.
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Parameters:
 *    
 *    inHandlerRef:
 *      The event handler to add the additional events to.
 *    
 *    inNumTypes:
 *      The number of events to add.
 *    
 *    inList:
 *      A pointer to an array of EventTypeSpec entries.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function AddEventTypesToHandler( inHandlerRef: EventHandlerRef; inNumTypes: UInt32; {const} inList: {variable-size-array} EventTypeSpecPtr ): OSStatus; external name '_AddEventTypesToHandler';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  RemoveEventTypesFromHandler()
 *  
 *  Discussion:
 *    Removes events from an event handler that has already been
 *    installed.
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Parameters:
 *    
 *    inHandlerRef:
 *      The event handler to remove the events from.
 *    
 *    inNumTypes:
 *      The number of events to remove.
 *    
 *    inList:
 *      A pointer to an array of EventTypeSpec entries.
 *  
 *  Result:
 *    An operating system status code.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function RemoveEventTypesFromHandler( inHandlerRef: EventHandlerRef; inNumTypes: UInt32; {const} inList: {variable-size-array} EventTypeSpecPtr ): OSStatus; external name '_RemoveEventTypesFromHandler';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{}
{   Explicit Propagation                                                              }
{  CallNextEventHandler can be used to call thru to all handlers below the current     }
{  handler being called. You pass the EventHandlerCallRef passed to your EventHandler  }
{  into this call so that we know how to properly forward the event. The result of     }
{  this function should normally be the result of your own handler that you called     }
{  this API from. The typical use of this routine would be to allow the toolbox to do  }
{  its standard processing and then follow up with some type of embellishment.         }
{}

{
 *  CallNextEventHandler()
 *  
 *  Discussion:
 *    Calls thru to the event handlers below you in the event handler
 *    stack of the target to which your handler is bound. You might use
 *    this to call thru to the default toolbox handling in order to
 *    post-process the event. You can only call this routine from
 *    within an event handler.
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Parameters:
 *    
 *    inCallRef:
 *      The event handler call ref passed into your event handler.
 *    
 *    inEvent:
 *      The event to pass thru.
 *  
 *  Result:
 *    An operating system result code.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function CallNextEventHandler( inCallRef: EventHandlerCallRef; inEvent: EventRef ): OSStatus; external name '_CallNextEventHandler';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{}
{   Sending Events                                                                    }
{}

{
 *  Summary:
 *    Options for the SendEventToEventTargetWithOptions API.
 }
const
{
   * The event should be sent to the target given only, and should not
   * propagate to any other target. CallNextEventHandler, when passed
   * an event sent with this option, will only call other event
   * handlers installed on the current event target; it will not
   * propagate the event to other event targets.
   }
	kEventTargetDontPropagate = 1 shl 0;

  {
   * The event is a notification-style event, and should be received by
   * all handlers. The result is usually meaningless when sent in this
   * manner, though we do maintain the strongest result code while the
   * event falls through each handler. This means that if the first
   * handler to receive the event returned noErr, and the next returned
   * eventNotHandledErr, the result returned would actually be noErr.
   * No handler can stop this event from propagating; i.e., the result
   * code does not alter event flow.
   }
	kEventTargetSendToAllHandlers = 1 shl 1;

{
 *  SendEventToEventTarget()
 *  
 *  Discussion:
 *    Sends an event to the specified event target.
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Parameters:
 *    
 *    inEvent:
 *      The event to send.
 *    
 *    inTarget:
 *      The target to send it to.
 *  
 *  Result:
 *    An operating system result code. The result is determined by both
 *    the SendEventToEventTarget API and also the event handlers that
 *    receive the event. SendEventToEventTarget will return paramErr if
 *    the event or the target are invalid, or eventNotHandledErr if the
 *    event is not wanted by any handler. If the event is received by a
 *    handler, however, then the result code returned by the API is
 *    determined by the handler; a handler may return any error code,
 *    and your code should not make any assumptions about exactly which
 *    errors will be returned by SendEventToEventTarget.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.0 and later in Carbon.framework
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Non-Carbon CFM:   not available
 }
function SendEventToEventTarget( inEvent: EventRef; inTarget: EventTargetRef ): OSStatus; external name '_SendEventToEventTarget';
(* AVAILABLE_MAC_OS_X_VERSION_10_0_AND_LATER *)


{
 *  SendEventToEventTargetWithOptions()
 *  
 *  Discussion:
 *    Sends an event to the specified event target, optionally
 *    controlling how the event propagates. See the discussion of the
 *    event send options above for more detail.
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Parameters:
 *    
 *    inEvent:
 *      The event to send.
 *    
 *    inTarget:
 *      The target to send it to.
 *    
 *    inOptions:
 *      The options to modify the send behavior. Passing zero for this
 *      makes it behave just like SendEventToEventTarget.
 *  
 *  Result:
 *    An operating system result code. The result is determined by both
 *    the SendEventToEventTargetWithOptions API and also the event
 *    handlers that receive the event.
 *    SendEventToEventTargetWithOptions will return paramErr if the
 *    event or the target are invalid, or eventNotHandledErr if the
 *    event is not wanted by any handler. If the event is received by a
 *    handler, however, then the result code returned by the API is
 *    determined by the handler; a handler may return any error code,
 *    and your code should not make any assumptions about exactly which
 *    errors will be returned by SendEventToEventTargetWithOptions.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.2 and later in Carbon.framework
 *    CarbonLib:        not available in CarbonLib 1.x, is available on Mac OS X version 10.2 and later
 *    Non-Carbon CFM:   not available
 }
function SendEventToEventTargetWithOptions( inEvent: EventRef; inTarget: EventTargetRef; inOptions: OptionBits ): OSStatus; external name '_SendEventToEventTargetWithOptions';
(* AVAILABLE_MAC_OS_X_VERSION_10_2_AND_LATER *)


{}
{   Secure Event Input                                                                }
{}
{
 *  EnableSecureEventInput()
 *  
 *  Summary:
 *    Enables secure event input mode.
 *  
 *  Discussion:
 *    When secure event input is enabled, keyboard input will only go
 *    to the application with keyboard focus, and will not be echoed to
 *    other applications that might be using the event monitor target
 *    to watch keyboard input. The EditText and EditUnicodeText
 *    controls automatically enter secure input mode when a password
 *    control has the focus; if your application implements its own
 *    password entry, you should enable secure event input while the
 *    user is entering text.
 *    
 *    This API maintains a count of the number of times that it has
 *    been called. Secure event input is not disabled until
 *    DisableSecureEventInput has been called the same number of
 *    times.
 *    
 *    Be sure to disable secure event input if your application becomes
 *    inactive. If your application crashes, secure event input will
 *    automatically be disabled if no other application has enabled it.
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Availability:
 *    Mac OS X:         in version 10.3 and later in Carbon.framework
 *    CarbonLib:        not available in CarbonLib 1.x, is available on Mac OS X version 10.3 and later
 *    Non-Carbon CFM:   not available
 }
function EnableSecureEventInput: OSStatus; external name '_EnableSecureEventInput';
(* AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER *)


{
 *  DisableSecureEventInput()
 *  
 *  Summary:
 *    Disables secure event input mode.
 *  
 *  Discussion:
 *    When secure event input is enabled, keyboard input will only go
 *    to the application with keyboard focus, and will not be echoed to
 *    other applications that might be using the event monitor target
 *    to watch keyboard input. The EditText and EditUnicodeText
 *    controls automatically enter secure input mode when a password
 *    control has the focus; if your application implements its own
 *    password entry, you should enable secure event input while the
 *    user is entering text.
 *    
 *    The EnableSecureEventInput API maintains a count of the number of
 *    times that it has been called. Secure event input is not disabled
 *    until this API has been called the same number of times.
 *    
 *    Be sure to disable secure event input if your application becomes
 *    inactive. If your application crashes, secure event input will
 *    automatically be disabled if no other application has enabled it.
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Availability:
 *    Mac OS X:         in version 10.3 and later in Carbon.framework
 *    CarbonLib:        not available in CarbonLib 1.x, is available on Mac OS X version 10.3 and later
 *    Non-Carbon CFM:   not available
 }
function DisableSecureEventInput: OSStatus; external name '_DisableSecureEventInput';
(* AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER *)


{
 *  IsSecureEventInputEnabled()
 *  
 *  Summary:
 *    Indicates whether secure event input is currently enabled.
 *  
 *  Discussion:
 *    This API returns whether secure event input is enabled by any
 *    process, not just the current process. Secure event input may be
 *    disabled in the current process but enabled in some other
 *    process; in that case, this API will return true.
 *  
 *  Mac OS X threading:
 *    Not thread safe
 *  
 *  Availability:
 *    Mac OS X:         in version 10.3 and later in Carbon.framework
 *    CarbonLib:        not available in CarbonLib 1.x, is available on Mac OS X version 10.3 and later
 *    Non-Carbon CFM:   not available
 }
function IsSecureEventInputEnabled: Boolean; external name '_IsSecureEventInputEnabled';
(* AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER *)




{unit Collections}
{
     File:       Collections.p
 
     Contains:   Collection Manager Interfaces
 
     Version:    Technology: Carbon
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   1989-2002 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}

{***********}
{ Constants }
{***********}
{ Convenience constants for functions which optionally return values }

const
	kCollectionDontWantTag		= 0;
	kCollectionDontWantId		= 0;
	kCollectionDontWantSize		= 0;
	kCollectionDontWantAttributes = 0;
	kCollectionDontWantIndex	= 0;
	kCollectionDontWantData		= 0;


	{	 attributes bits 	}
	kCollectionNoAttributes		= $00000000;					{  no attributes bits set  }
	kCollectionAllAttributes	= $FFFFFFFF;					{  all attributes bits set  }
	kCollectionUserAttributes	= $0000FFFF;					{  user attributes bits  }
	kCollectionDefaultAttributes = $40000000;					{  default attributes - unlocked, persistent  }


	{	 
	    Attribute bits 0 through 15 (entire low word) are reserved for use by the application.
	    Attribute bits 16 through 31 (entire high word) are reserved for use by the Collection Manager.
	    Only bits 31 (kCollectionLockBit) and 30 (kCollectionPersistenceBit) currently have meaning.
		}
	kCollectionUser0Bit			= 0;
	kCollectionUser1Bit			= 1;
	kCollectionUser2Bit			= 2;
	kCollectionUser3Bit			= 3;
	kCollectionUser4Bit			= 4;
	kCollectionUser5Bit			= 5;
	kCollectionUser6Bit			= 6;
	kCollectionUser7Bit			= 7;
	kCollectionUser8Bit			= 8;
	kCollectionUser9Bit			= 9;
	kCollectionUser10Bit		= 10;
	kCollectionUser11Bit		= 11;
	kCollectionUser12Bit		= 12;
	kCollectionUser13Bit		= 13;
	kCollectionUser14Bit		= 14;
	kCollectionUser15Bit		= 15;
	kCollectionReserved0Bit		= 16;
	kCollectionReserved1Bit		= 17;
	kCollectionReserved2Bit		= 18;
	kCollectionReserved3Bit		= 19;
	kCollectionReserved4Bit		= 20;
	kCollectionReserved5Bit		= 21;
	kCollectionReserved6Bit		= 22;
	kCollectionReserved7Bit		= 23;
	kCollectionReserved8Bit		= 24;
	kCollectionReserved9Bit		= 25;
	kCollectionReserved10Bit	= 26;
	kCollectionReserved11Bit	= 27;
	kCollectionReserved12Bit	= 28;
	kCollectionReserved13Bit	= 29;
	kCollectionPersistenceBit	= 30;
	kCollectionLockBit			= 31;


	{	 attribute masks 	}
	kCollectionUser0Mask		= $00000001;
	kCollectionUser1Mask		= $00000002;
	kCollectionUser2Mask		= $00000004;
	kCollectionUser3Mask		= $00000008;
	kCollectionUser4Mask		= $00000010;
	kCollectionUser5Mask		= $00000020;
	kCollectionUser6Mask		= $00000040;
	kCollectionUser7Mask		= $00000080;
	kCollectionUser8Mask		= $00000100;
	kCollectionUser9Mask		= $00000200;
	kCollectionUser10Mask		= $00000400;
	kCollectionUser11Mask		= $00000800;
	kCollectionUser12Mask		= $00001000;
	kCollectionUser13Mask		= $00002000;
	kCollectionUser14Mask		= $00004000;
	kCollectionUser15Mask		= $00008000;
	kCollectionReserved0Mask	= $00010000;
	kCollectionReserved1Mask	= $00020000;
	kCollectionReserved2Mask	= $00040000;
	kCollectionReserved3Mask	= $00080000;
	kCollectionReserved4Mask	= $00100000;
	kCollectionReserved5Mask	= $00200000;
	kCollectionReserved6Mask	= $00400000;
	kCollectionReserved7Mask	= $00800000;
	kCollectionReserved8Mask	= $01000000;
	kCollectionReserved9Mask	= $02000000;
	kCollectionReserved10Mask	= $04000000;
	kCollectionReserved11Mask	= $08000000;
	kCollectionReserved12Mask	= $10000000;
	kCollectionReserved13Mask	= $20000000;
	kCollectionPersistenceMask	= $40000000;
	kCollectionLockMask			= $80000000;


	{	*********	}
	{	 Types   	}
	{	*********	}
	{	 abstract data type for a collection 	}

type
	Collection    = ^SInt32; { an opaque 32-bit type }
	CollectionPtr = ^Collection;  { when a var xx:Collection parameter can be nil, it is changed to xx: CollectionPtr }
	{	 collection member 4 byte tag 	}
	CollectionTag						= FourCharCode;
{$ifc TYPED_FUNCTION_POINTERS}
	CollectionFlattenProcPtr = function(size: SInt32; data: UnivPtr; refCon: UnivPtr): OSErr;
{$elsec}
	CollectionFlattenProcPtr = ProcPtr;
{$endc}

{$ifc TYPED_FUNCTION_POINTERS}
	CollectionExceptionProcPtr = function(c: Collection; status: OSErr): OSErr;
{$elsec}
	CollectionExceptionProcPtr = ProcPtr;
{$endc}

{$ifc OPAQUE_UPP_TYPES}
	CollectionFlattenUPP = ^SInt32; { an opaque UPP }
{$elsec}
	CollectionFlattenUPP = UniversalProcPtr;
{$endc}	
{$ifc OPAQUE_UPP_TYPES}
	CollectionExceptionUPP = ^SInt32; { an opaque UPP }
{$elsec}
	CollectionExceptionUPP = UniversalProcPtr;
{$endc}	

const
	uppCollectionFlattenProcInfo = $00000FE0;
	uppCollectionExceptionProcInfo = $000002E0;
	{
	 *  NewCollectionFlattenUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 and later
	 	}
function NewCollectionFlattenUPP(userRoutine: CollectionFlattenProcPtr): CollectionFlattenUPP; external name '_NewCollectionFlattenUPP'; { old name was NewCollectionFlattenProc }
{
 *  NewCollectionExceptionUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function NewCollectionExceptionUPP(userRoutine: CollectionExceptionProcPtr): CollectionExceptionUPP; external name '_NewCollectionExceptionUPP'; { old name was NewCollectionExceptionProc }
{
 *  DisposeCollectionFlattenUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure DisposeCollectionFlattenUPP(userUPP: CollectionFlattenUPP); external name '_DisposeCollectionFlattenUPP';
{
 *  DisposeCollectionExceptionUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure DisposeCollectionExceptionUPP(userUPP: CollectionExceptionUPP); external name '_DisposeCollectionExceptionUPP';
{
 *  InvokeCollectionFlattenUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function InvokeCollectionFlattenUPP(size: SInt32; data: UnivPtr; refCon: UnivPtr; userRoutine: CollectionFlattenUPP): OSErr; external name '_InvokeCollectionFlattenUPP'; { old name was CallCollectionFlattenProc }
{
 *  InvokeCollectionExceptionUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function InvokeCollectionExceptionUPP(c: Collection; status: OSErr; userRoutine: CollectionExceptionUPP): OSErr; external name '_InvokeCollectionExceptionUPP'; { old name was CallCollectionExceptionProc }
{*******************************************}
{************ Public interfaces ************}
{*******************************************}
{
 *  NewCollection()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function NewCollection: Collection; external name '_NewCollection';
{
 *  DisposeCollection()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure DisposeCollection(c: Collection); external name '_DisposeCollection';
{
 *  CloneCollection()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function CloneCollection(c: Collection): Collection; external name '_CloneCollection';
{
 *  CountCollectionOwners()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function CountCollectionOwners(c: Collection): SInt32; external name '_CountCollectionOwners';
{
 *  RetainCollection()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 and later
 }
function RetainCollection(c: Collection): OSStatus; external name '_RetainCollection';


{
 *  ReleaseCollection()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 and later
 }
function ReleaseCollection(c: Collection): OSStatus; external name '_ReleaseCollection';


{
 *  GetCollectionRetainCount()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.1 and later
 *    Mac OS X:         in version 10.0 and later
 }
function GetCollectionRetainCount(c: Collection): ItemCount; external name '_GetCollectionRetainCount';


{
 *  CopyCollection()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function CopyCollection(srcCollection: Collection; dstCollection: Collection): Collection; external name '_CopyCollection';
{
 *  GetCollectionDefaultAttributes()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function GetCollectionDefaultAttributes(c: Collection): SInt32; external name '_GetCollectionDefaultAttributes';
{
 *  SetCollectionDefaultAttributes()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure SetCollectionDefaultAttributes(c: Collection; whichAttributes: SInt32; newAttributes: SInt32); external name '_SetCollectionDefaultAttributes';
{
 *  CountCollectionItems()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function CountCollectionItems(c: Collection): SInt32; external name '_CountCollectionItems';
{
 *  AddCollectionItem()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AddCollectionItem(c: Collection; tag: CollectionTag; id: SInt32; itemSize: SInt32; itemData: UnivPtr): OSErr; external name '_AddCollectionItem';
{
 *  GetCollectionItem()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function GetCollectionItem(c: Collection; tag: CollectionTag; id: SInt32; var itemSize: SInt32; itemData: UnivPtr): OSErr; external name '_GetCollectionItem';
{
 *  RemoveCollectionItem()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function RemoveCollectionItem(c: Collection; tag: CollectionTag; id: SInt32): OSErr; external name '_RemoveCollectionItem';
{
 *  SetCollectionItemInfo()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function SetCollectionItemInfo(c: Collection; tag: CollectionTag; id: SInt32; whichAttributes: SInt32; newAttributes: SInt32): OSErr; external name '_SetCollectionItemInfo';
{
 *  GetCollectionItemInfo()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function GetCollectionItemInfo(c: Collection; tag: CollectionTag; id: SInt32; var index: SInt32; var itemSize: SInt32; var attributes: SInt32): OSErr; external name '_GetCollectionItemInfo';
{
 *  ReplaceIndexedCollectionItem()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function ReplaceIndexedCollectionItem(c: Collection; index: SInt32; itemSize: SInt32; itemData: UnivPtr): OSErr; external name '_ReplaceIndexedCollectionItem';
{
 *  GetIndexedCollectionItem()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function GetIndexedCollectionItem(c: Collection; index: SInt32; var itemSize: SInt32; itemData: UnivPtr): OSErr; external name '_GetIndexedCollectionItem';
{
 *  RemoveIndexedCollectionItem()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function RemoveIndexedCollectionItem(c: Collection; index: SInt32): OSErr; external name '_RemoveIndexedCollectionItem';
{
 *  SetIndexedCollectionItemInfo()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function SetIndexedCollectionItemInfo(c: Collection; index: SInt32; whichAttributes: SInt32; newAttributes: SInt32): OSErr; external name '_SetIndexedCollectionItemInfo';
{
 *  GetIndexedCollectionItemInfo()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function GetIndexedCollectionItemInfo(c: Collection; index: SInt32; var tag: CollectionTag; var id: SInt32; var itemSize: SInt32; var attributes: SInt32): OSErr; external name '_GetIndexedCollectionItemInfo';
{
 *  CollectionTagExists()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function CollectionTagExists(c: Collection; tag: CollectionTag): boolean; external name '_CollectionTagExists';
{
 *  CountCollectionTags()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function CountCollectionTags(c: Collection): SInt32; external name '_CountCollectionTags';
{
 *  GetIndexedCollectionTag()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function GetIndexedCollectionTag(c: Collection; tagIndex: SInt32; var tag: CollectionTag): OSErr; external name '_GetIndexedCollectionTag';
{
 *  CountTaggedCollectionItems()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function CountTaggedCollectionItems(c: Collection; tag: CollectionTag): SInt32; external name '_CountTaggedCollectionItems';
{
 *  GetTaggedCollectionItem()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function GetTaggedCollectionItem(c: Collection; tag: CollectionTag; whichItem: SInt32; var itemSize: SInt32; itemData: UnivPtr): OSErr; external name '_GetTaggedCollectionItem';
{
 *  GetTaggedCollectionItemInfo()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function GetTaggedCollectionItemInfo(c: Collection; tag: CollectionTag; whichItem: SInt32; var id: SInt32; var index: SInt32; var itemSize: SInt32; var attributes: SInt32): OSErr; external name '_GetTaggedCollectionItemInfo';
{
 *  PurgeCollection()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure PurgeCollection(c: Collection; whichAttributes: SInt32; matchingAttributes: SInt32); external name '_PurgeCollection';
{
 *  PurgeCollectionTag()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure PurgeCollectionTag(c: Collection; tag: CollectionTag); external name '_PurgeCollectionTag';
{
 *  EmptyCollection()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure EmptyCollection(c: Collection); external name '_EmptyCollection';
{
 *  FlattenCollection()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function FlattenCollection(c: Collection; flattenProc: CollectionFlattenUPP; refCon: UnivPtr): OSErr; external name '_FlattenCollection';
{
 *  FlattenPartialCollection()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function FlattenPartialCollection(c: Collection; flattenProc: CollectionFlattenUPP; refCon: UnivPtr; whichAttributes: SInt32; matchingAttributes: SInt32): OSErr; external name '_FlattenPartialCollection';
{
 *  UnflattenCollection()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function UnflattenCollection(c: Collection; flattenProc: CollectionFlattenUPP; refCon: UnivPtr): OSErr; external name '_UnflattenCollection';
{
 *  GetCollectionExceptionProc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function GetCollectionExceptionProc(c: Collection): CollectionExceptionUPP; external name '_GetCollectionExceptionProc';
{
 *  SetCollectionExceptionProc()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure SetCollectionExceptionProc(c: Collection; exceptionProc: CollectionExceptionUPP); external name '_SetCollectionExceptionProc';
{
 *  GetNewCollection()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function GetNewCollection(collectionID: SInt16): Collection; external name '_GetNewCollection';
{********************************************************************}
{************* Utility routines for handle-based access *************}
{********************************************************************}
{
 *  AddCollectionItemHdl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AddCollectionItemHdl(aCollection: Collection; tag: CollectionTag; id: SInt32; itemData: Handle): OSErr; external name '_AddCollectionItemHdl';
{
 *  GetCollectionItemHdl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function GetCollectionItemHdl(aCollection: Collection; tag: CollectionTag; id: SInt32; itemData: Handle): OSErr; external name '_GetCollectionItemHdl';
{
 *  ReplaceIndexedCollectionItemHdl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function ReplaceIndexedCollectionItemHdl(aCollection: Collection; index: SInt32; itemData: Handle): OSErr; external name '_ReplaceIndexedCollectionItemHdl';
{
 *  GetIndexedCollectionItemHdl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function GetIndexedCollectionItemHdl(aCollection: Collection; index: SInt32; itemData: Handle): OSErr; external name '_GetIndexedCollectionItemHdl';
{
 *  FlattenCollectionToHdl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function FlattenCollectionToHdl(aCollection: Collection; flattened: Handle): OSErr; external name '_FlattenCollectionToHdl';
{
 *  UnflattenCollectionFromHdl()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in CollectionsLib 1.0 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function UnflattenCollectionFromHdl(aCollection: Collection; flattened: Handle): OSErr; external name '_UnflattenCollectionFromHdl';
{$ifc OLDROUTINENAMES}

const
	dontWantTag					= 0;
	dontWantId					= 0;
	dontWantSize				= 0;
	dontWantAttributes			= 0;
	dontWantIndex				= 0;
	dontWantData				= 0;

	noCollectionAttributes		= $00000000;
	allCollectionAttributes		= $FFFFFFFF;
	userCollectionAttributes	= $0000FFFF;
	defaultCollectionAttributes	= $40000000;

	collectionUser0Bit			= 0;
	collectionUser1Bit			= 1;
	collectionUser2Bit			= 2;
	collectionUser3Bit			= 3;
	collectionUser4Bit			= 4;
	collectionUser5Bit			= 5;
	collectionUser6Bit			= 6;
	collectionUser7Bit			= 7;
	collectionUser8Bit			= 8;
	collectionUser9Bit			= 9;
	collectionUser10Bit			= 10;
	collectionUser11Bit			= 11;
	collectionUser12Bit			= 12;
	collectionUser13Bit			= 13;
	collectionUser14Bit			= 14;
	collectionUser15Bit			= 15;
	collectionReserved0Bit		= 16;
	collectionReserved1Bit		= 17;
	collectionReserved2Bit		= 18;
	collectionReserved3Bit		= 19;
	collectionReserved4Bit		= 20;
	collectionReserved5Bit		= 21;
	collectionReserved6Bit		= 22;
	collectionReserved7Bit		= 23;
	collectionReserved8Bit		= 24;
	collectionReserved9Bit		= 25;
	collectionReserved10Bit		= 26;
	collectionReserved11Bit		= 27;
	collectionReserved12Bit		= 28;
	collectionReserved13Bit		= 29;
	collectionPersistenceBit	= 30;
	collectionLockBit			= 31;

	collectionUser0Mask			= $00000001;
	collectionUser1Mask			= $00000002;
	collectionUser2Mask			= $00000004;
	collectionUser3Mask			= $00000008;
	collectionUser4Mask			= $00000010;
	collectionUser5Mask			= $00000020;
	collectionUser6Mask			= $00000040;
	collectionUser7Mask			= $00000080;
	collectionUser8Mask			= $00000100;
	collectionUser9Mask			= $00000200;
	collectionUser10Mask		= $00000400;
	collectionUser11Mask		= $00000800;
	collectionUser12Mask		= $00001000;
	collectionUser13Mask		= $00002000;
	collectionUser14Mask		= $00004000;
	collectionUser15Mask		= $00008000;
	collectionReserved0Mask		= $00010000;
	collectionReserved1Mask		= $00020000;
	collectionReserved2Mask		= $00040000;
	collectionReserved3Mask		= $00080000;
	collectionReserved4Mask		= $00100000;
	collectionReserved5Mask		= $00200000;
	collectionReserved6Mask		= $00400000;
	collectionReserved7Mask		= $00800000;
	collectionReserved8Mask		= $01000000;
	collectionReserved9Mask		= $02000000;
	collectionReserved10Mask	= $04000000;
	collectionReserved11Mask	= $08000000;
	collectionReserved12Mask	= $10000000;
	collectionReserved13Mask	= $20000000;
	collectionPersistenceMask	= $40000000;
	collectionLockMask			= $80000000;

{$endc}  {OLDROUTINENAMES}


{$ALIGN MAC68K}


{unit DHCPClientPreferences}
{
 * Copyright (c) 2001 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY of ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES of MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 }
{	  Pascal Translation:  Peter N Lewis, <peter@stairways.com.au>, 2004 }


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}


{$ALIGN MAC68K}

{!
	@header DHCPClientPreferences.h
 }

{!
	@function DHCPClientPreferencesSetApplicationOptions
	@discussion Updates the DHCP client preferences to include the
		given list of options for the given "applicationID".
	@param applicationID The application's preference ID, for example:
		"com.apple.SystemPreferences".
	@param options An array of 8-bit values containing the
		DHCP option codes (see RFC 2132) for this applicationID.
		A NULL value will clear the list of options for this
		application ID.
	@param count The number of elements in "options".
	@result TRUE if the operation succeeded, FALSE otherwise.
 }

function DHCPClientPreferencesSetApplicationOptions( applicationID: CFStringRef; options: UInt8Ptr; count: CFIndex ): Boolean; external name '_DHCPClientPreferencesSetApplicationOptions';

{!
	@function DHCPClientPreferencesCopyApplicationOptions
	@discussion Copies the requested DHCP options for the
		given "applicationID".
	@param applicationID The application's preference ID, for example
		"com.apple.SystemPreferences".
	@param count The number of elements in the returned array.
	@result The list of options for the given "applicationID", or
		NULL if no options are defined or an error occurred.

		When done, use free() to release a non-NULL return value.
 }

function DHCPClientPreferencesCopyApplicationOptions( applicationID: CFStringRef; var count: CFIndex ): UInt8Ptr; external name '_DHCPClientPreferencesCopyApplicationOptions';

{unit DateTimeUtils}
{
     File:       DateTimeUtils.p
 
     Contains:   International Date and Time Interfaces (previously in TextUtils)
 
     Version:    Technology: Mac OS 8.5
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   1994-2002 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}

{

    Here are the current routine names and the translations to the older forms.
    Please use the newer forms in all new code and migrate the older names out of existing
    code as maintainance permits.
    
    New Name                    Old Name(s)
    
    DateString                  IUDatePString IUDateString 
    InitDateCache
    LongDateString              IULDateString
    LongTimeString              IULTimeString
    StringToDate                String2Date
    StringToTime                                
    TimeString                  IUTimeString IUTimePString
    LongDateToSeconds           LongDate2Secs
    LongSecondsToDate           LongSecs2Date
    DateToSeconds               Date2Secs
    SecondsToDate               Secs2Date


    Carbon only supports the new names.  The old names are undefined for Carbon targets.
    This is true for C, Assembly and Pascal.
    
    InterfaceLib always has exported the old names.  For C macros have been defined to allow
    the use of the new names.  For Pascal and Assembly using the new names will result
    in link errors. 
    
}


type
	ToggleResults 				= SInt16;
const
																{  Toggle results  }
	toggleUndefined				= 0;
	toggleOK					= 1;
	toggleBadField				= 2;
	toggleBadDelta				= 3;
	toggleBadChar				= 4;
	toggleUnknown				= 5;
	toggleBadNum				= 6;
	toggleOutOfRange			= 7;							{ synonym for toggleErr3 }
	toggleErr3					= 7;
	toggleErr4					= 8;
	toggleErr5					= 9;

																{  Date equates  }
	smallDateBit				= 31;							{ Restrict valid date/time to range of Time global }
	togChar12HourBit			= 30;							{ If toggling hour by char, accept hours 1..12 only }
	togCharZCycleBit			= 29;							{ Modifier for togChar12HourBit: accept hours 0..11 only }
	togDelta12HourBit			= 28;							{ If toggling hour up/down, restrict to 12-hour range (am/pm) }
	genCdevRangeBit				= 27;							{ Restrict date/time to range used by genl CDEV }
	validDateFields				= -1;
	maxDateField				= 10;

	eraMask						= $0001;
	yearMask					= $0002;
	monthMask					= $0004;
	dayMask						= $0008;
	hourMask					= $0010;
	minuteMask					= $0020;
	secondMask					= $0040;
	dayOfWeekMask				= $0080;
	dayOfYearMask				= $0100;
	weekOfYearMask				= $0200;
	pmMask						= $0400;
	dateStdMask					= $007F;						{ default for ValidDate flags and ToggleDate TogglePB.togFlags }


type
	LongDateField 				= SInt8;
const
	eraField					= 0;
	yearField					= 1;
	monthField					= 2;
	dayField					= 3;
	hourField					= 4;
	minuteField					= 5;
	secondField					= 6;
	dayOfWeekField				= 7;
	dayOfYearField				= 8;
	weekOfYearField				= 9;
	pmField						= 10;
	res1Field					= 11;
	res2Field					= 12;
	res3Field					= 13;


type
	DateForm 					= SInt8;
const
	shortDate					= 0;
	longDate					= 1;
	abbrevDate					= 2;

																{  StringToDate status values  }
	fatalDateTime				= $8000;						{  StringToDate and String2Time mask to a fatal error  }
	longDateFound				= 1;							{  StringToDate mask to long date found  }
	leftOverChars				= 2;							{  StringToDate & Time mask to warn of left over characters  }
	sepNotIntlSep				= 4;							{  StringToDate & Time mask to warn of non-standard separators  }
	fieldOrderNotIntl			= 8;							{  StringToDate & Time mask to warn of non-standard field order  }
	extraneousStrings			= 16;							{  StringToDate & Time mask to warn of unparsable strings in text  }
	tooManySeps					= 32;							{  StringToDate & Time mask to warn of too many separators  }
	sepNotConsistent			= 64;							{  StringToDate & Time mask to warn of inconsistent separators  }
	tokenErr					= $8100;						{  StringToDate & Time mask for 'tokenizer err encountered'  }
	cantReadUtilities			= $8200;
	dateTimeNotFound			= $8400;
	dateTimeInvalid				= $8800;


type
	StringToDateStatus					= SInt16;
	String2DateStatus					= StringToDateStatus;
	DateCacheRecordPtr = ^DateCacheRecord;
	DateCacheRecord = packed record
		hidden:					array [0..255] of SInt16;				{  only for temporary use  }
	end;

	DateCachePtr						= ^DateCacheRecord;
	DateTimeRecPtr = ^DateTimeRec;
	DateTimeRec = record
		year:					SInt16;
		month:					SInt16;
		day:					SInt16;
		hour:					SInt16;
		minute:					SInt16;
		second:					SInt16;
		dayOfWeek:				SInt16;
	end;

	LongDateTime						= SInt64;
	LongDateTimePtr 					= ^LongDateTime;
{$ifc TARGET_RT_BIG_ENDIAN}
	LongDateCvt = record
		case SInt16 of
		0: (
			c:					SInt64;
			);
		1: (
			lHigh:				UInt32;
			lLow:				UInt32;
		   );
	end;
{$elsec}
	LongDateCvt = record
		case SInt16 of
		0: (
			c:					SInt64;
			);
		1: (
			lLow:				UInt32;
			lHigh:				UInt32;
		   );
	end;
{$endc}
	LongDateCvtPtr = ^LongDateCvt;

	LongDateRecPtr = ^LongDateRec;
	LongDateRec = record
		case SInt16 of
		0: (
			era:				SInt16;
			year:				SInt16;
			month:				SInt16;
			day:				SInt16;
			hour:				SInt16;
			minute:				SInt16;
			second:				SInt16;
			dayOfWeek:			SInt16;
			dayOfYear:			SInt16;
			weekOfYear:			SInt16;
			pm:					SInt16;
			res1:				SInt16;
			res2:				SInt16;
			res3:				SInt16;
		   );
		1: (
			list:				array [0..13] of SInt16;				{ Index by LongDateField! }
			);
		2: (
			eraAlt:				SInt16;
			oldDate:			DateTimeRec;
		   );
	end;

	DateDelta							= SInt8;
	TogglePBPtr = ^TogglePB;
	TogglePB = record
		togFlags:				SInt32;								{ caller normally sets low word to dateStdMask=$7F }
		amChars:				ResType;								{ from 'itl0', but uppercased }
		pmChars:				ResType;								{ from 'itl0', but uppercased }
		reserved:				array [0..3] of SInt32;
	end;

	{	
	    These routine are available in Carbon with their new name
		}
	{
	 *  DateString()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   not available
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 and later
	 	}
procedure DateString(dateTime: UInt32; longFlag: ByteParameter; var result: Str255; intlHandle: Handle); external name '_DateString';
{
 *  TimeString()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure TimeString(dateTime: UInt32; wantSeconds: boolean; var result: Str255; intlHandle: Handle); external name '_TimeString';
{
 *  LongDateString()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure LongDateString((*const*) var dateTime: LongDateTime; longFlag: ByteParameter; var result: Str255; intlHandle: Handle); external name '_LongDateString';
{
 *  LongTimeString()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure LongTimeString((*const*) var dateTime: LongDateTime; wantSeconds: boolean; var result: Str255; intlHandle: Handle); external name '_LongTimeString';
{
    These routine are available in Carbon and InterfaceLib with their new name
}
{
 *  InitDateCache()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function InitDateCache(theCache: DateCachePtr): OSErr; external name '_InitDateCache';
{
 *  StringToDate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function StringToDate(textPtr: Ptr; textLen: SInt32; theCache: DateCachePtr; var lengthUsed: SInt32; var dateTime: LongDateRec): StringToDateStatus; external name '_StringToDate';
{
 *  StringToTime()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function StringToTime(textPtr: Ptr; textLen: SInt32; theCache: DateCachePtr; var lengthUsed: SInt32; var dateTime: LongDateRec): StringToDateStatus; external name '_StringToTime';
{
 *  LongDateToSeconds()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure LongDateToSeconds(const (*var*) lDate: LongDateRec; var lSecs: LongDateTime); external name '_LongDateToSeconds';
{
 *  LongSecondsToDate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure LongSecondsToDate((*const*) var lSecs: LongDateTime; var lDate: LongDateRec); external name '_LongSecondsToDate';
{
 *  ToggleDate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function ToggleDate(var lSecs: LongDateTime; field: ByteParameter; delta: DateDelta; ch: SInt16; const (*var*) params: TogglePB): ToggleResults; external name '_ToggleDate';
{
 *  ValidDate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function ValidDate(const (*var*) vDate: LongDateRec; flags: SInt32; var newSecs: LongDateTime): SInt16; external name '_ValidDate';
{
 *  ReadDateTime()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function ReadDateTime(var time: UInt32): OSErr; external name '_ReadDateTime';
{
 *  GetDateTime()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure GetDateTime(var secs: UInt32); external name '_GetDateTime';
{
 *  SetDateTime()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function SetDateTime(time: UInt32): OSErr; external name '_SetDateTime';
{
 *  SetTime()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure SetTime(const (*var*) d: DateTimeRec); external name '_SetTime';
{
 *  GetTime()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure GetTime(var d: DateTimeRec); external name '_GetTime';
{
 *  DateToSeconds()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure DateToSeconds(const (*var*) d: DateTimeRec; var secs: UInt32); external name '_DateToSeconds';

{
 *  SecondsToDate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure SecondsToDate(secs: UInt32; var d: DateTimeRec); external name '_SecondsToDate';
{
    These routine are available in InterfaceLib using their old name.
    Macros allow using the new names in all source code.
}
{$ifc CALL_NOT_IN_CARBON}
{
 *  IUDateString()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
procedure IUDateString(dateTime: SInt32; longFlag: ByteParameter; var result: Str255); external name '_IUDateString';
{
 *  IUTimeString()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
procedure IUTimeString(dateTime: SInt32; wantSeconds: boolean; var result: Str255); external name '_IUTimeString';
{
 *  IUDatePString()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
procedure IUDatePString(dateTime: SInt32; longFlag: ByteParameter; var result: Str255; intlHandle: Handle); external name '_IUDatePString';
{
 *  IUTimePString()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
procedure IUTimePString(dateTime: SInt32; wantSeconds: boolean; var result: Str255; intlHandle: Handle); external name '_IUTimePString';
{
 *  IULDateString()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
procedure IULDateString(var dateTime: LongDateTime; longFlag: ByteParameter; var result: Str255; intlHandle: Handle); external name '_IULDateString';
{
 *  IULTimeString()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
procedure IULTimeString(var dateTime: LongDateTime; wantSeconds: boolean; var result: Str255; intlHandle: Handle); external name '_IULTimeString';
{$endc}  {CALL_NOT_IN_CARBON}

{$ifc OLDROUTINENAMES}
{$ifc CALL_NOT_IN_CARBON}
{
 *  LongDate2Secs()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
procedure LongDate2Secs(const (*var*) lDate: LongDateRec; var lSecs: LongDateTime); external name '_LongDate2Secs';
{
 *  LongSecs2Date()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
procedure LongSecs2Date(var lSecs: LongDateTime; var lDate: LongDateRec); external name '_LongSecs2Date';
{
 *  Date2Secs()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
procedure Date2Secs(const (*var*) d: DateTimeRec; var secs: UInt32); external name '_Date2Secs';

{
 *  Secs2Date()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
procedure Secs2Date(secs: UInt32; var d: DateTimeRec); external name '_Secs2Date';
{$endc}  {CALL_NOT_IN_CARBON}
{$endc}  {OLDROUTINENAMES}


{$ALIGN MAC68K}


{unit DriverSynchronization}
{
     File:       DriverSynchronization.p
 
     Contains:   Driver Synchronization Interfaces.
 
     Version:    Technology: MacOS 8
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   1985-2002 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}

{$ifc CALL_NOT_IN_CARBON}
{
 *  SynchronizeIO()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in DriverServicesLib 1.0 and later
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
procedure SynchronizeIO; external name '_SynchronizeIO';
{$endc}  {CALL_NOT_IN_CARBON}

{
 *  CompareAndSwap()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function CompareAndSwap(oldVvalue: UInt32; newValue: UInt32; var OldValueAdr: UInt32): boolean; external name '_CompareAndSwap';

{
 *  TestAndClear()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function TestAndClear(bit: UInt32; startAddress: UnivPtr): boolean; external name '_TestAndClear';

{
 *  TestAndSet()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function TestAndSet(bit: UInt32; startAddress: UnivPtr): boolean; external name '_TestAndSet';

{
 *  IncrementAtomic8()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function IncrementAtomic8(var value: SInt8): SInt8; external name '_IncrementAtomic8';

{
 *  DecrementAtomic8()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function DecrementAtomic8(var value: SInt8): SInt8; external name '_DecrementAtomic8';

{
 *  AddAtomic8()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AddAtomic8(amount: SInt32; var value: SInt8): SInt8; external name '_AddAtomic8';

{
 *  BitAndAtomic8()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function BitAndAtomic8(mask: UInt32; var value: UInt8): ByteParameter; external name '_BitAndAtomic8';

{
 *  BitOrAtomic8()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function BitOrAtomic8(mask: UInt32; var value: UInt8): ByteParameter; external name '_BitOrAtomic8';

{
 *  BitXorAtomic8()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function BitXorAtomic8(mask: UInt32; var value: UInt8): ByteParameter; external name '_BitXorAtomic8';

{
 *  IncrementAtomic16()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function IncrementAtomic16(var value: SInt16): SInt16; external name '_IncrementAtomic16';

{
 *  DecrementAtomic16()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function DecrementAtomic16(var value: SInt16): SInt16; external name '_DecrementAtomic16';

{
 *  AddAtomic16()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AddAtomic16(amount: SInt32; var value: SInt16): SInt16; external name '_AddAtomic16';

{
 *  BitAndAtomic16()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function BitAndAtomic16(mask: UInt32; var value: UInt16): UInt16; external name '_BitAndAtomic16';

{
 *  BitOrAtomic16()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function BitOrAtomic16(mask: UInt32; var value: UInt16): UInt16; external name '_BitOrAtomic16';

{
 *  BitXorAtomic16()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function BitXorAtomic16(mask: UInt32; var value: UInt16): UInt16; external name '_BitXorAtomic16';

{
 *  IncrementAtomic()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function IncrementAtomic(var value: SInt32): SInt32; external name '_IncrementAtomic';

{
 *  DecrementAtomic()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function DecrementAtomic(var value: SInt32): SInt32; external name '_DecrementAtomic';

{
 *  AddAtomic()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function AddAtomic(amount: SInt32; var value: SInt32): SInt32; external name '_AddAtomic';

{
 *  BitAndAtomic()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function BitAndAtomic(mask: UInt32; var value: UInt32): UInt32; external name '_BitAndAtomic';

{
 *  BitOrAtomic()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function BitOrAtomic(mask: UInt32; var value: UInt32): UInt32; external name '_BitOrAtomic';

{
 *  BitXorAtomic()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 8.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function BitXorAtomic(mask: UInt32; var value: UInt32): UInt32; external name '_BitXorAtomic';


{$ALIGN MAC68K}


{unit Endian}
{
     File:       CarbonCore/Endian.h
 
     Contains:   Endian swapping utilties
 
     Version:    CarbonCore-654.0.85~1
 
     Copyright:   1997-2005 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}
{   Pascal Translation Updated:  Peter N Lewis, <peter@stairways.com.au>, November 2005 }
{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}

{
    This file provides Endian Flipping routines for dealing with converting data
    between Big-Endian and Little-Endian machines.  These routines are useful
    when writing code to compile for both Big and Little Endian machines and  
    which must handle other endian number formats, such as reading or writing 
    to a file or network packet.
    
    These routines are named as follows:
    
        Endian<U><W>_<S>to<D>

    where
        <U> is whether the integer is signed ('S') or unsigned ('U')
        <W> is integer bit width: 16, 32, or 64 
        <S> is the source endian format: 'B' for big, 'L' for little, or 'N' for native
        <D> is the destination endian format: 'B' for big, 'L' for little, or 'N' for native
    
    For example, to convert a Big Endian 32-bit unsigned integer to the current native format use:
        
        long i = EndianU32_BtoN(data);
        
    This file is set up so that the function macro to nothing when the target runtime already
    is the desired format (e.g. on Big Endian machines, EndianU32_BtoN() macros away).
            
    If long long's are not supported, you cannot get 64-bit quantities as a single value.
    The macros are not defined in that case.

    For gcc, the macros build on top of the inline byte swapping
    routines from <libkern/OSByteOrder.h>, which may have better performance.
    
    
                                <<< W A R N I N G >>>
    
    It is very important not to put any autoincrements inside the macros.  This 
    will produce erroneous results because each time the address is accessed in the macro, 
    the increment occurs.
    
 }
 // Macros might be better solutions
function Endian16_Swap( arg: UInt16 ): UInt16; inline;
function Endian32_Swap( arg: UInt32 ): UInt32; inline;
function Endian64_Swap_Pascal( arg: UInt64 ): UInt64; inline;
function EndianS16_Swap( arg: SInt16 ): SInt16; inline;
function EndianS32_Swap( arg: SInt32 ): SInt32; inline;
function EndianS64_Swap( arg: SInt64 ): SInt64; inline;


function Endian64_Swap( arg: UInt64 ): UInt64; inline;
//  Macro away no-op functions

{$ifc TARGET_RT_BIG_ENDIAN}

function EndianS16_BtoN( arg: SInt16 ): SInt16; inline;
function EndianS16_NtoB( arg: SInt16 ): SInt16; inline;
function EndianU16_BtoN( arg: UInt16 ): UInt16; inline;
function EndianU16_NtoB( arg: UInt16 ): UInt16; inline;
function EndianS32_BtoN( arg: SInt32 ): SInt32; inline;
function EndianS32_NtoB( arg: SInt32 ): SInt32; inline;
function EndianU32_BtoN( arg: UInt32 ): UInt32; inline;
function EndianU32_NtoB( arg: UInt32 ): UInt32; inline;
function EndianS64_BtoN( arg: SInt64 ): SInt64; inline;
function EndianS64_NtoB( arg: SInt64 ): SInt64; inline;
function EndianU64_BtoN( arg: UInt64 ): UInt64; inline;
function EndianU64_NtoB( arg: UInt64 ): UInt64; inline;

{$elsec}

function EndianS16_LtoN( arg: SInt16 ): SInt16; inline;
function EndianS16_NtoL( arg: SInt16 ): SInt16; inline;
function EndianU16_LtoN( arg: UInt16 ): UInt16; inline;
function EndianU16_NtoL( arg: UInt16 ): UInt16; inline;
function EndianS32_LtoN( arg: SInt32 ): SInt32; inline;
function EndianS32_NtoL( arg: SInt32 ): SInt32; inline;
function EndianU32_LtoN( arg: UInt32 ): UInt32; inline;
function EndianU32_NtoL( arg: UInt32 ): UInt32; inline;
function EndianS64_LtoN( arg: SInt64 ): SInt64; inline;
function EndianS64_NtoL( arg: SInt64 ): SInt64; inline;
function EndianU64_LtoN( arg: UInt64 ): UInt64; inline;
function EndianU64_NtoL( arg: UInt64 ): UInt64; inline;

{$endc}

//  Map native to actual

{$ifc TARGET_RT_BIG_ENDIAN}

function EndianS16_LtoN( arg: SInt16 ): SInt16; inline;
function EndianS16_NtoL( arg: SInt16 ): SInt16; inline;
function EndianU16_LtoN( arg: UInt16 ): UInt16; inline;
function EndianU16_NtoL( arg: UInt16 ): UInt16; inline;
function EndianS32_LtoN( arg: SInt32 ): SInt32; inline;
function EndianS32_NtoL( arg: SInt32 ): SInt32; inline;
function EndianU32_LtoN( arg: UInt32 ): UInt32; inline;
function EndianU32_NtoL( arg: UInt32 ): UInt32; inline;
function EndianS64_LtoN( arg: SInt64 ): SInt64; inline;
function EndianS64_NtoL( arg: SInt64 ): SInt64; inline;
function EndianU64_LtoN( arg: UInt64 ): UInt64; inline;
function EndianU64_NtoL( arg: UInt64 ): UInt64; inline;

{$elsec}

function EndianS16_BtoN( arg: SInt16 ): SInt16; inline;
function EndianS16_NtoB( arg: SInt16 ): SInt16; inline;
function EndianU16_BtoN( arg: UInt16 ): UInt16; inline;
function EndianU16_NtoB( arg: UInt16 ): UInt16; inline;
function EndianS32_BtoN( arg: SInt32 ): SInt32; inline;
function EndianS32_NtoB( arg: SInt32 ): SInt32; inline;
function EndianU32_BtoN( arg: UInt32 ): UInt32; inline;
function EndianU32_NtoB( arg: UInt32 ): UInt32; inline;
function EndianS64_BtoN( arg: SInt64 ): SInt64; inline;
function EndianS64_NtoB( arg: SInt64 ): SInt64; inline;
function EndianU64_BtoN( arg: UInt64 ): UInt64; inline;
function EndianU64_NtoB( arg: UInt64 ): UInt64; inline;

{$endc}

//     Implement *LtoB and *BtoL

function EndianS16_LtoB( arg: SInt16 ): SInt16; inline;
function EndianS16_BtoL( arg: SInt16 ): SInt16; inline;
function EndianU16_LtoB( arg: UInt16 ): UInt16; inline;
function EndianU16_BtoL( arg: UInt16 ): UInt16; inline;
function EndianS32_LtoB( arg: SInt32 ): SInt32; inline;
function EndianS32_BtoL( arg: SInt32 ): SInt32; inline;
function EndianU32_LtoB( arg: UInt32 ): UInt32; inline;
function EndianU32_BtoL( arg: UInt32 ): UInt32; inline;
function EndianS64_LtoB( arg: SInt64 ): SInt64; inline;
function EndianS64_BtoL( arg: SInt64 ): SInt64; inline;
function EndianU64_LtoB( arg: UInt64 ): UInt64; inline;
function EndianU64_BtoL( arg: UInt64 ): UInt64; inline;

{
   These types are used for structures that contain data that is
   always in BigEndian format.  This extra typing prevents little
   endian code from directly changing the data, thus saving much
   time in the debugger.
}

{$ifc TARGET_RT_LITTLE_ENDIAN}

type
	BigEndianLong = record
		bigEndianValue: SInt32;
	end;

	BigEndianUnsignedLong = record
		bigEndianValue: UInt32;
	end;

	BigEndianShort = record
		bigEndianValue: SInt16;
	end;

	BigEndianUnsignedShort = record
		bigEndianValue: UInt16;
	end;

	BigEndianFixed = record
		bigEndianValue: Fixed;
	end;

	BigEndianUnsignedFixed = record
		bigEndianValue: UnsignedFixed;
	end;

	BigEndianOSType = record
		bigEndianValue: OSType;
	end;

{$elsec}

type
	BigEndianLong						= SInt32;
	BigEndianUnsignedLong				= UInt32;
	BigEndianShort						= SInt16;
	BigEndianUnsignedShort				= UInt16;
	BigEndianFixed						= Fixed;
	BigEndianUnsignedFixed				= UnsignedFixed;
	BigEndianOSType						= OSType;
{$endc}  {TARGET_RT_LITTLE_ENDIAN}

type
	BigEndianLongPtr = ^BigEndianLong;
	BigEndianUnsignedLongPtr = ^BigEndianUnsignedLong;
	BigEndianShortPtr = ^BigEndianShort;
	BigEndianUnsignedShortPtr = ^BigEndianUnsignedShort;
	BigEndianFixedPtr = ^BigEndianFixed;
	BigEndianUnsignedFixedPtr = ^BigEndianUnsignedFixed;
	BigEndianOSTypePtr = ^BigEndianOSType;

{
        CoreEndian flipping API.

        This API is used to generically massage data buffers, in
        place, from one endian architecture to another.  In effect,
        the API supports registering a set of callbacks that can
        effect this translation.  

        The data types have specific meanings within their domain,
        although some data types can be registered with the same
        callback in several domains.  There is no wildcard domain.

        A set of pre-defined flippers are implemented by the Carbon
        frameworks for most common resource manager and AppleEvent data
        types.
  }
const
	kCoreEndianResourceManagerDomain = $72737263 (* 'rsrc' *);
	kCoreEndianAppleEventManagerDomain = $61657674 (* 'aevt' *);


{
 *  CoreEndianFlipProc
 *  
 *  Discussion:
 *    Callback use to flip endian-ness of typed data
 *  
 *  Parameters:
 *    
 *    dataDomain:
 *      Domain of the data type
 *    
 *    dataType:
 *      Type of data being flipped
 *    
 *    id:
 *      resource id (if being flipped on behalf of the resource
 *      manager, otherwise will be zero)
 *    
 *    dataPtr:
 *      Pointer to the data
 *    
 *    dataSize:
 *      Length of the data
 *    
 *    currentlyNative:
 *      Boolean indicating which direction to flip: false means flip
 *      from disk big endian to native (from disk), true means flip
 *      from native to disk big endian (to disk)
 *    
 *    refcon:
 *      An optional user reference supplied when the flipper is
 *      installed
 *  
 *  Result:
 *    Error code indicating whether the data was flipped.  noErr would
 *    indicate that the data was flipped as appropriate; any other
 *    error will be propagated back to the caller.
 }
type
	CoreEndianFlipProc = function( dataDomain: OSType; dataType: OSType; id: SInt16; dataPtr: UnivPtr; dataSize: UInt32; currentlyNative: Boolean; refcon: UnivPtr ): OSStatus;
{
 * Install a flipper for this application
 }
{
 *  CoreEndianInstallFlipper()
 *  
 *  Summary:
 *    Installs a flipper proc for the given data type.  If the flipper
 *    is already registered, this flipper will take replace it.
 *  
 *  Mac OS X threading:
 *    Thread safe since version 10.3
 *  
 *  Parameters:
 *    
 *    dataDomain:
 *      Domain of the data type
 *    
 *    dataType:
 *      Type of data for which this flipper should be installed
 *    
 *    proc:
 *      Flipper callback to be called for data of this type
 *    
 *    refcon:
 *      Optional user reference for the flipper
 *  
 *  Result:
 *    Error code indicating whether or not the flipper could be
 *    installed
 *  
 *  Availability:
 *    Mac OS X:         in version 10.3 and later in CoreServices.framework
 *    CarbonLib:        not available
 *    Non-Carbon CFM:   not available
 }
function CoreEndianInstallFlipper( dataDomain: OSType; dataType: OSType; proc: CoreEndianFlipProc; refcon: UnivPtr { can be NULL } ): OSStatus; external name '_CoreEndianInstallFlipper';
(* AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER *)


{
 *  CoreEndianGetFlipper()
 *  
 *  Summary:
 *    Gets an existing data flipper proc for the given data type
 *  
 *  Mac OS X threading:
 *    Thread safe since version 10.3
 *  
 *  Parameters:
 *    
 *    dataDomain:
 *      Domain of the data type
 *    
 *    dataType:
 *      Type of the data for which this flipper should be installed
 *    
 *    proc:
 *      Pointer to a flipper callback
 *    
 *    refcon:
 *      Pointer to the callback refcon
 *  
 *  Result:
 *    noErr if the given flipper could be found; otherwise
 *    handlerNotFoundErr will be returned.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.3 and later in CoreServices.framework
 *    CarbonLib:        not available
 *    Non-Carbon CFM:   not available
 }
function CoreEndianGetFlipper( dataDomain: OSType; dataType: OSType; var proc: CoreEndianFlipProc; refcon: UnivPtrPtr ): OSStatus; external name '_CoreEndianGetFlipper';
(* AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER *)


{
 *  CoreEndianFlipData()
 *  
 *  Summary:
 *    Calls the flipper for the given data type with the associated data
 *  
 *  Mac OS X threading:
 *    Thread safe since version 10.3
 *  
 *  Parameters:
 *    
 *    dataDomain:
 *      Domain of the data type
 *    
 *    dataType:
 *      type of the data
 *    
 *    id:
 *      resource id (if not a resource, pass zero)
 *    
 *    data:
 *      a pointer to the data to be flipped (in place)
 *    
 *    dataLen:
 *      length of the data to flip
 *    
 *    currentlyNative:
 *      a boolean indicating the direction to flip (whether the data is
 *      currently native endian or big-endian)
 *  
 *  Result:
 *    Error code indicating whether the data was flipped.  If
 *    handlerNotFound is returned, then no flipping took place (which
 *    is not necessarily an error condtion)
 *  
 *  Availability:
 *    Mac OS X:         in version 10.3 and later in CoreServices.framework
 *    CarbonLib:        not available
 *    Non-Carbon CFM:   not available
 }
function CoreEndianFlipData( dataDomain: OSType; dataType: OSType; id: SInt16; data: UnivPtr; dataLen: UInt32; currentlyNative: Boolean ): OSStatus; external name '_CoreEndianFlipData';
(* AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER *)




{unit FileTypesAndCreators}
{
     File:       FileTypesAndCreators.p
 
     Contains:   Symbolic constants for FileTypes and signatures of popular documents.
 
     Version:    Technology: Macintosh Easy Open 1.1
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   1992-2002 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}

{

Motivation for FileTypesAndCreators.h

    The TranslationMgr (Macintosh Easy Open) uses FileTypes to express and manage
    translation capabilities.  This works well for most Macintosh applications.  It
    simply uses the file type stored in the catalog info by HFS.  But, the TranslationMgr
    needs to work with non-Macintosh files.  These do not have file types (or creators).
    Another problem is some Macintosh applications keep the same file type for a file
    after changing the file format from one version to the next.  Thus, the HFS file type
    cannot be used to distinguish between formats.

    This file is an effort to define FileTypes and creator codes for non-Macintosh file
    formats and define FileTypes that distinguish between formats.


There are two main categories of constants defined in FileTypesAndCreators.h.  One is
creator signatures of applications the other is file types.  To make this easier to use,
some style guidelines are provided.

Creators:

    The symbolic constant for all creator codes begin with sig. Following sig is the
    application name.  Example:

        sigSurfWriter = 'SURF'

    If the application name is localized for different markets, the name of the U.S.
    version is always used. It is optional to make symbolic constants for localized names.
    If a U.S. is not available, another Roman name is used (this is for ease of editing
    in MPW.)  Example:

        sigSurfWriter = 'SURF',
        sigSkiWriter =  'SURF'  // optional definition of Canadian name of app

    If multiple versions of an application exist, and the creator codes are different,
    then the version number is added to the end of the symbolic name, for the first version
    in which the signature changed.  Example:

        sigDirtWriter =     'DIRT', // version 1 and 2 used same signature
        sigDirtWriter3 =    'DRT3'

    If a developer has the same application on another platform as is on the Mac, then the
    creator for a file from the other platform should be the same as the creator of the
    Macintosh application.   Example:

        sigMicrosoftWord =  'MSWD'  // used for Mac and Windows documents

    If there is no similar Macintosh product, then the signature of the platform is used.
    Example:

        sigPCDOS =          'mdos', // for DOS and Windows
        sigAppleProDos =    'pdos'


FileTypes:

    The symbolic constant for all file types begin with ft. Following ft is the ideal
    kind for that document.  Example:

        ftSurfWriterDocument =  'SRFD'

    If the application name is localized for different markets, the kind string of the U.S.
    version is always used. It is optional to make symbolic constants for localized kind
    strings.  If a U.S. is not available, another Roman kind string is used (this is for
    ease of editing in MPW.)  Example:

        ftSurfWriterDocument =  'SRFD,
        ftSkiWriterDocument =   'SRFD'  // optional Canadian name

    If multiple versions of an application exist, and the document for files created by each
    are different (meaning one version of the app can not read the documents of a newer
    version), then the version number is added to the end of the symbolic name, for the
    first version in which the format changed.  Example:

       // version 1 and 2 docs have same format, version 3 has a different format
        ftDirtWriterDocument =          'DDRT',
        ftDirtWriter3Document =         '3DRT'

    If multiple versions of an application exist, and the document for files created by each
    are different, but the catInfo file type has always been the same, then constants are
    made for each unique format and one is made for the catInfo type actually used.

        ftWordDocument =        'WDBN',
        ftWord3Document =       'WDB3',
        ftWord4Document =       'WDB4',
        ftWord5Document =       'WDB5'

    If a developer has the same application on another platform as is on the Mac and the file
    formats are the same (binary interchangeable), then the file type for a file from the other
    platform should be the same as the file type of the Macintosh document.   Example:

        ftPageMakerPublication = 'ALB4' // used for Mac and PC documents

    If there is no similar Macintosh document format, then a file type is made up.  If the
    program is used on two different non-Mac platforms and their file formats are not the
    same, the platform name is added to the name.  Typically after the program name and before
    document.  Example:

        ftXyWriteIIIDocument =  'XyWr'  // XyWriteIII only has a PC format
        ftSurfWindowsDocument = 'SRFW'  // Surf Windows file format
        ftSurfPCDocument =      'SRFP'  // Surf PC file format
}

{************* Macintosh applications and FileTypes *************}


const
																{  Mac word processors  }
	sigWord						= $4D535744 (* 'MSWD' *);
	ftWord3Document				= $4D535733 (* 'MSW3' *);
	ftWord4Document				= $4D535734 (* 'MSW4' *);
	ftWord5Document				= $4D535735 (* 'MSW5' *);
	ftWordDocument				= $5744424E (* 'WDBN' *);
	ftWordDocumentPC			= $4D575043 (* 'MWPC' *);						{  not registered  }
	ftWord1DocumentWindows		= $57573120 (* 'WW1 ' *);						{  not registered  }
	ftWord2DocumentWindows		= $57573220 (* 'WW2 ' *);						{  not registered  }
	ftRTFDocument				= $52544620 (* 'RTF ' *);						{  not registered  }
	sigWordPerfect				= $53534957 (* 'SSIW' *);
	ftWordPerfectDocument		= $57504430 (* 'WPD0' *);
	sigWordPerfect2				= $57504332 (* 'WPC2' *);
	ftWordPerfect2Document		= $57504431 (* 'WPD1' *);
	ftWordPerfect21Document		= $57504432 (* 'WPD2' *);
	ftWordPerfect42DocumentPC	= $2E575034 (* '.WP4' *);						{  not registered  }
	ftWordPerfect50DocumentPC	= $2E575035 (* '.WP5' *);						{  not registered  }
	ftWordPerfect51DocumentPC	= $57503531 (* 'WP51' *);						{  not registered  }
	ftWordPerfectGraphicsPC		= $57504766 (* 'WPGf' *);						{  not registered  }
	sigMacWriteII				= $4D574949 (* 'MWII' *);
	ftMacWriteIIDocument		= $4D573244 (* 'MW2D' *);
	sigWriteNow					= $6E585E6E (* 'nX^n' *);
	ftWriteNow2Document			= $6E585E64 (* 'nX^d' *);
	ftWriteNow3Document			= $6E585E32 (* 'nX^2' *);
	sigMacWrite					= $4D414341 (* 'MACA' *);
	ftMacWrite5Document			= $574F5244 (* 'WORD' *);
	sigFrameMaker				= $4672616D (* 'Fram' *);
	ftFrameMakerDocument		= $4641534C (* 'FASL' *);
	ftFrameMakerMIFDocument		= $4D494620 (* 'MIF ' *);
	ftFrameMakerMIF2Document	= $4D494632 (* 'MIF2' *);
	ftFrameMakerMIF3Document	= $4D494633 (* 'MIF3' *);
	sigMSWrite					= $4D535754 (* 'MSWT' *);
	sigActa						= $41435441 (* 'ACTA' *);
	sigTHINKPascal				= $504A4D4D (* 'PJMM' *);
	sigTHINKC					= $4B41484C (* 'KAHL' *);
	sigFullWrite				= $46575254 (* 'FWRT' *);
	sigTeachText				= $74747874 (* 'ttxt' *);
	ftTeachTextDocument			= $7474726F (* 'ttro' *);
	sigSimpleText				= $74747874 (* 'ttxt' *);
	ftSimpleTextDocument		= $7474726F (* 'ttro' *);
	sigMPWShell					= $4D505320 (* 'MPS ' *);
	sigQuarkXPress				= $58505233 (* 'XPR3' *);
	sigNisus					= $4E495349 (* 'NISI' *);
	sigOmniPage					= $50525443 (* 'PRTC' *);
	sigPersonalPress			= $53435047 (* 'SCPG' *);
	sigPublishItEZ				= $32435459 (* '2CTY' *);
	sigReadySetGo				= $4D454D52 (* 'MEMR' *);
	sigRagTime					= $52232B41 (* 'R#+A' *);
	sigLetraStudio				= $4C535450 (* 'LSTP' *);
	sigLetterPerfect			= $57504349 (* 'WPCI' *);
	sigTheWritingCenter			= $0A1A5750;					{  this 'unprintable unprintable WP' One of the unprintables is a line feed.   }
	sigInstantUpdate			= $49554130 (* 'IUA0' *);

																{  databases  }
	sig4thDimension				= $34443033 (* '4D03' *);
	ft4thDimensionDB			= $42415333 (* 'BAS3' *);
	sigFileMakerPro				= $464D5052 (* 'FMPR' *);
	ftFileMakerProDatabase		= $464D5052 (* 'FMPR' *);
	sigHyperCard				= $57494C44 (* 'WILD' *);
	ftHyperCard					= $5354414B (* 'STAK' *);
	sigSmartFormAsst			= $4B43464D (* 'KCFM' *);
	ftSmartFormAsst				= $5354434B (* 'STCK' *);
	sigSmartFormDesign			= $4B434644 (* 'KCFD' *);
	ftSmartFormDesign			= $4346524D (* 'CFRM' *);
	sigFileForce				= $34443933 (* '4D93' *);
	ftFileForceDatabase			= $46494C33 (* 'FIL3' *);
	sigFileMaker2				= $464D4B34 (* 'FMK4' *);
	ftFileMaker2Database		= $464D4B24 (* 'FMK$' *);
	sigSuperCard				= $52554E54 (* 'RUNT' *);
	sigDoubleHelix				= $48454C58 (* 'HELX' *);
	sigGeoQuery					= $52476771 (* 'RGgq' *);
	sigFoxBASE					= $464F582B (* 'FOX+' *);
	sigINSPIRATION				= $43455233 (* 'CER3' *);
	sigPanorama					= $4B415331 (* 'KAS1' *);
	sigSilverrunLDM				= $43444D4C (* 'CDML' *);
	sigSilverrunDFD				= $43444446 (* 'CDDF' *);						{  finance  }
	sigQuicken					= $494E5455 (* 'INTU' *);
	sigMacInTax91				= $4D495431 (* 'MIT1' *);
	ftMacInTax91				= $4D495446 (* 'MITF' *);
	sigAccountantInc			= $4150524F (* 'APRO' *);
	sigAtOnce					= $4B495353 (* 'KISS' *);
	sigCAT3						= $74436174 (* 'tCat' *);
	sigDollarsNSense			= $45414750 (* 'EAGP' *);
	sigInsightExpert			= $4C53474C (* 'LSGL' *);
	sigMYOB						= $4D594F42 (* 'MYOB' *);
	sigMacMoney					= $53534C41 (* 'SSLA' *);
	sigManagingYourMoney		= $4D594D43 (* 'MYMC' *);
	sigPlainsAndSimple			= $50454747 (* 'PEGG' *);						{  scheduling  }
	sigMacProject2				= $4D505258 (* 'MPRX' *);
	ftMacProject				= $4D505244 (* 'MPRD' *);
	sigMSProject				= $4D53504A (* 'MSPJ' *);
	sigMacProjectPro			= $4D505250 (* 'MPRP' *);						{  utilities  }
	sigStuffIt					= $53495421 (* 'SIT!' *);
	ftStuffItArchive			= $53495421 (* 'SIT!' *);
	sigCompactPro				= $43504354 (* 'CPCT' *);
	ftCompactProArchive			= $50414354 (* 'PACT' *);
	sigFontographer				= $61436132 (* 'aCa2' *);
	sigMetamorphosis			= $4D457450 (* 'MEtP' *);
	sigCorrectGrammar			= $4C734347 (* 'LsCG' *);
	sigDynodex					= $44594E4F (* 'DYNO' *);
	sigMariah					= $4D617248 (* 'MarH' *);
	sigAddressBook				= $4164426B (* 'AdBk' *);
	sigThePrintShop				= $50534850 (* 'PSHP' *);
	sigQuicKeys2				= $516B7932 (* 'Qky2' *);
	sigReadStar2Plus			= $494E4F56 (* 'INOV' *);
	sigSoftPC					= $50435854 (* 'PCXT' *);
	sigMacMenlo					= $4D4E4C4F (* 'MNLO' *);
	sigDisinfectant				= $44324354 (* 'D2CT' *);						{  communications  }
	sigSmartcom2				= $53434F4D (* 'SCOM' *);
	sigVersaTermPRO				= $5650524F (* 'VPRO' *);
	sigVersaTerm				= $5641544D (* 'VATM' *);
	sigWhiteKnight				= $574B3131 (* 'WK11' *);
	sigNCSATelnet				= $4E435341 (* 'NCSA' *);
	sigDynaComm					= $50415232 (* 'PAR2' *);
	sigQMForms					= $4D4C544D (* 'MLTM' *);						{  math and statistics  }
	sigMathematica				= $4F4D4547 (* 'OMEG' *);
	sigMathCAD					= $4D434144 (* 'MCAD' *);
	sigStatView2				= $53544154 (* 'STAT' *);
	sigDataDesk					= $4444534B (* 'DDSK' *);
	sigPowerMath2				= $4D415448 (* 'MATH' *);
	sigSuperANOVA				= $53757041 (* 'SupA' *);
	sigSystat					= $53595431 (* 'SYT1' *);
	sigTheorist					= $5468656F (* 'Theo' *);

																{  spreadsheets  }
	sigExcel					= $5843454C (* 'XCEL' *);
	ftExcel2Spreadsheet			= $584C5320 (* 'XLS ' *);
	ftExcel2Macro				= $584C4D20 (* 'XLM ' *);
	ftExcel2Chart				= $584C4320 (* 'XLC ' *);
	ftExcel3Spreadsheet			= $584C5333 (* 'XLS3' *);
	ftExcel3Macro				= $584C4D33 (* 'XLM3' *);
	ftExcel3Chart				= $584C4333 (* 'XLC3' *);
	ftExcel4Spreadsheet			= $584C5334 (* 'XLS4' *);
	ftExcel4Macro				= $584C4D34 (* 'XLM4' *);
	ftSYLKSpreadsheet			= $53594C4B (* 'SYLK' *);
	sigLotus123					= $4C313233 (* 'L123' *);
	ft123Spreadsheet			= $4C574B53 (* 'LWKS' *);
	sigWingz					= $574E475A (* 'WNGZ' *);
	ftWingzSpreadsheet			= $575A5353 (* 'WZSS' *);
	ftWingzScript				= $575A5343 (* 'WZSC' *);
	sigResolve					= $52736C76 (* 'Rslv' *);
	ftResolve					= $52735773 (* 'RsWs' *);
	ftResolveScript				= $52735763 (* 'RsWc' *);
	sigFullImpact2				= $466C7632 (* 'Flv2' *);

																{  graphics  }
	sigIllustrator				= $41525435 (* 'ART5' *);
	ftPostScriptMac				= $45505346 (* 'EPSF' *);
	sigMacPaint					= $4D504E54 (* 'MPNT' *);
	ftMacPaintGraphic			= $504E5447 (* 'PNTG' *);
	sigSuperPaint				= $53504E54 (* 'SPNT' *);
	ftSuperPaintGraphic			= $53505447 (* 'SPTG' *);
	sigCanvas					= $44414432 (* 'DAD2' *);
	ftCanvasGraphic				= $64727732 (* 'drw2' *);
	sigUltraPaint				= $554C5452 (* 'ULTR' *);
	ftUltraPaint				= $55504E54 (* 'UPNT' *);
	sigPhotoshop				= $3842494D (* '8BIM' *);
	ftPhotoshopGraphic			= $3842494D (* '8BIM' *);
	sigMacDrawPro				= $6450726F (* 'dPro' *);
	ftMacDrawProDrawing			= $64446F63 (* 'dDoc' *);
	sigPageMaker				= $414C4434 (* 'ALD4' *);
	ftPageMakerPublication		= $414C4234 (* 'ALB4' *);
	sigFreeHand					= $46484133 (* 'FHA3' *);
	ftFreeHandDrawing			= $46484433 (* 'FHD3' *);
	sigClarisCAD				= $43434144 (* 'CCAD' *);
	ftClarisCAD					= $43414432 (* 'CAD2' *);
	sigMacDrawII				= $4D44504C (* 'MDPL' *);
	ftMacDrawIIDrawing			= $44525747 (* 'DRWG' *);
	sigMacroMindDirector		= $4D4D4452 (* 'MMDR' *);
	ftMMDirectorMovie			= $56574D44 (* 'VWMD' *);
	ftMMDirectorSound			= $4D4D5344 (* 'MMSD' *);
	sigOptix					= $5049584C (* 'PIXL' *);						{  was previously PixelPerfect  }
	sigPixelPaint				= $50495852 (* 'PIXR' *);
	ftPixelPaint				= $50583031 (* 'PX01' *);
	sigAldusSuper3D				= $53503344 (* 'SP3D' *);
	ftSuper3DDrawing			= $33444258 (* '3DBX' *);
	sigSwivel3D					= $5357564C (* 'SWVL' *);
	ftSwivel3DDrawing			= $534D444C (* 'SMDL' *);
	sigCricketDraw				= $43524457 (* 'CRDW' *);
	ftCricketDrawing			= $434B4454 (* 'CKDT' *);
	sigCricketGraph				= $43475246 (* 'CGRF' *);
	ftCricketChart				= $43475043 (* 'CGPC' *);
	sigDesignCAD				= $41534243 (* 'ASBC' *);
	ftDesignCADDrawing			= $44434144 (* 'DCAD' *);
	sigImageStudio				= $46535045 (* 'FSPE' *);
	ftImageStudioGraphic		= $52494646 (* 'RIFF' *);
	sigVersaCad					= $56434144 (* 'VCAD' *);
	ftVersaCADDrawing			= $32442020 (* '2D  ' *);
	sigAdobePremiere			= $50724D72 (* 'PrMr' *);						{  was previously misspelled as sigAdobePremier }
	ftAdobePremiereMovie		= $4D6F6F56 (* 'MooV' *);						{  was previously misspelled as ftAdobePremierMovie }
	sigAfterDark				= $4144726B (* 'ADrk' *);
	ftAfterDarkModule			= $4144676D (* 'ADgm' *);
	sigClip3D					= $455A3345 (* 'EZ3E' *);
	ftClip3Dgraphic				= $455A3344 (* 'EZ3D' *);
	sigKaleidaGraph				= $514B5054 (* 'QKPT' *);
	ftKaleidaGraphGraphic		= $51504354 (* 'QPCT' *);
	sigMacFlow					= $4D43464C (* 'MCFL' *);
	ftMacFlowChart				= $464C4348 (* 'FLCH' *);
	sigMoviePlayer				= $54564F44 (* 'TVOD' *);
	ftMoviePlayerMovie			= $4D6F6F56 (* 'MooV' *);
	sigMacSpin					= $44325350 (* 'D2SP' *);
	ftMacSpinDataSet			= $4432424E (* 'D2BN' *);
	sigAutoCAD					= $41434144 (* 'ACAD' *);
	sigLabVIEW					= $4C425657 (* 'LBVW' *);
	sigColorMacCheese			= $434D43E2 (* 'CMC' *);
	sigMiniCad					= $43445033 (* 'CDP3' *);
	sigDreams					= $50484E58 (* 'PHNX' *);
	sigOmnis5					= $51322424 (* 'Q2$$' *);
	sigPhotoMac					= $504D4143 (* 'PMAC' *);
	sigGraphMaster				= $4752414D (* 'GRAM' *);
	sigInfiniD					= $5349E288 (* 'SID' *);
	sigOfoto					= $41504C53 (* 'APLS' *);
	sigMacDraw					= $4D445257 (* 'MDRW' *);
	sigDeltagraphPro			= $44475248 (* 'DGRH' *);
	sigDesign2					= $44455347 (* 'DESG' *);
	sigDesignStudio				= $4D524A4E (* 'MRJN' *);
	sigDynaperspective			= $50455253 (* 'PERS' *);
	sigGenericCADD				= $43414433 (* 'CAD3' *);
	sigMacDraft					= $4D443230 (* 'MD20' *);
	sigModelShop				= $4D445350 (* 'MDSP' *);
	sigOasis					= $54414F41 (* 'TAOA' *);
	sigOBJECTMASTER				= $42524F57 (* 'BROW' *);
	sigMovieRecorder			= $6D726372 (* 'mrcr' *);
	sigPictureCompressor		= $70707869 (* 'ppxi' *);
	sigPICTViewer				= $4D445453 (* 'MDTS' *);
	sigSmoothie					= $536D6F6F (* 'Smoo' *);
	sigScreenPlay				= $53504C59 (* 'SPLY' *);
	sigStudio1					= $53542F31 (* 'ST/1' *);
	sigStudio32					= $53543332 (* 'ST32' *);
	sigStudio8					= $53542F38 (* 'ST/8' *);
	sigKidPix					= $4B696432 (* 'Kid2' *);
	sigDigDarkroom				= $44494452 (* 'DIDR' *);

																{  presentations  }
	sigMore						= $4D4F5232 (* 'MOR2' *);
	ftMore3Document				= $4D4F5233 (* 'MOR3' *);
	ftMore2Document				= $4D4F5232 (* 'MOR2' *);
	sigPersuasion				= $504C5032 (* 'PLP2' *);
	ftPersuasion1Presentation	= $50525331 (* 'PRS1' *);
	ftPersuasion2Presentation	= $50525332 (* 'PRS2' *);
	sigPowerPoint				= $50504E54 (* 'PPNT' *);
	ftPowerPointPresentation	= $534C4453 (* 'SLDS' *);
	sigCricketPresents			= $43525052 (* 'CRPR' *);
	ftCricketPresentation		= $50524446 (* 'PRDF' *);						{  works  }
	sigMSWorks					= $50534932 (* 'PSI2' *);
	sigMSWorks3					= $4D53574B (* 'MSWK' *);
	ftMSWorksWordProcessor		= $41575750 (* 'AWWP' *);
	ftMSWorksSpreadsheet		= $41575353 (* 'AWSS' *);
	ftMSWorksDataBase			= $41574442 (* 'AWDB' *);
	ftMSWorksComm				= $41574443 (* 'AWDC' *);
	ftMSWorksMacros				= $41574D43 (* 'AWMC' *);
	ftMSWorks1WordProcessor		= $41575731 (* 'AWW1' *);						{  not registered  }
	ftMSWorks1Spreadsheet		= $41575331 (* 'AWS1' *);						{  not registered  }
	ftMSWorks1DataBase			= $41574431 (* 'AWD1' *);						{  not registered  }
	ftMSWorks2WordProcessor		= $41575732 (* 'AWW2' *);						{  not registered  }
	ftMSWorks2Spreadsheet		= $41575332 (* 'AWS2' *);						{  not registered  }
	ftMSWorks2DataBase			= $41574432 (* 'AWD2' *);						{  not registered  }
	ftMSWorks3WordProcessor		= $41575733 (* 'AWW3' *);						{  not registered  }
	ftMSWorks3Spreadsheet		= $41575333 (* 'AWS3' *);						{  not registered  }
	ftMSWorks3DataBase			= $41574433 (* 'AWD3' *);						{  not registered  }
	ftMSWorks3Comm				= $41574333 (* 'AWC3' *);						{  not registered  }
	ftMSWorks3Macro				= $41574D33 (* 'AWM3' *);						{  not registered  }
	ftMSWorks3Draw				= $41575233 (* 'AWR3' *);						{  not registered  }
	ftMSWorks2WordProcessorPC	= $50575732 (* 'PWW2' *);						{  not registered  }
	ftMSWorks2DatabasePC		= $50574442 (* 'PWDB' *);						{  not registered  }
	sigGreatWorks				= $5A454252 (* 'ZEBR' *);
	ftGreatWorksWordProcessor	= $5A575254 (* 'ZWRT' *);
	ftGreatWorksSpreadsheet		= $5A43414C (* 'ZCAL' *);
	ftGreatWorksPaint			= $5A504E54 (* 'ZPNT' *);
	sigClarisWorks				= $424F424F (* 'BOBO' *);
	ftClarisWorksWordProcessor	= $43575750 (* 'CWWP' *);
	ftClarisWorksSpreadsheet	= $43575353 (* 'CWSS' *);
	ftClarisWorksGraphics		= $43574752 (* 'CWGR' *);
	sigBeagleWorks				= $42576B73 (* 'BWks' *);
	ftBeagleWorksWordProcessor	= $42577770 (* 'BWwp' *);
	ftBeagleWorksDatabase		= $42576462 (* 'BWdb' *);
	ftBeagleWorksSpreadsheet	= $42577373 (* 'BWss' *);
	ftBeagleWorksComm			= $4257636D (* 'BWcm' *);
	ftBeagleWorksDrawing		= $42576472 (* 'BWdr' *);
	ftBeagleWorksGraphic		= $42577074 (* 'BWpt' *);
	ftPICTFile					= $50494354 (* 'PICT' *);

																{  entertainment  }
	sigPGATourGolf				= $674F4C46 (* 'gOLF' *);
	sigSimCity					= $4D435250 (* 'MCRP' *);
	sigHellCats					= $48454C4C (* 'HELL' *);						{  education  }
	sigReaderRabbit3			= $52445233 (* 'RDR3' *);						{  Translation applications  }
	sigDataVizDesktop			= $44564454 (* 'DVDT' *);
	sigSotwareBridge			= $6D646F73 (* 'mdos' *);
	sigWordForWord				= $4D535452 (* 'MSTR' *);
	sigAppleFileExchange		= $50535054 (* 'PSPT' *);						{  Apple software  }
	sigAppleLink				= $47454F4C (* 'GEOL' *);
	ftAppleLinkAddressBook		= $41445253 (* 'ADRS' *);
	ftAppleLinkImageFile		= $53494D41 (* 'SIMA' *);
	ftAppleLinkPackage			= $48425346 (* 'HBSF' *);
	ftAppleLinkConnFile			= $50455445 (* 'PETE' *);
	ftAppleLinkHelp				= $484C5046 (* 'HLPF' *);
	sigInstaller				= $626A6263 (* 'bjbc' *);
	ftInstallerScript			= $626A6263 (* 'bjbc' *);
	sigDiskCopy					= $64437079 (* 'dCpy' *);
	ftDiskCopyImage				= $64496D67 (* 'dImg' *);
	sigResEdit					= $52534544 (* 'RSED' *);
	ftResEditResourceFile		= $72737263 (* 'rsrc' *);
	sigAardvark					= $41415244 (* 'AARD' *);
	sigCompatibilityChkr		= $776B7270 (* 'wkrp' *);
	sigMacTerminal				= $5465726D (* 'Term' *);
	sigSADE						= $73616465 (* 'sade' *);
	sigCurare					= $43757261 (* 'Cura' *);
	sigPCXChange				= $646F7361 (* 'dosa' *);
	sigAtEase					= $6D666472 (* 'mfdr' *);
	sigStockItToMe				= $5349544D (* 'SITM' *);
	sigAppleSearch				= $61736973 (* 'asis' *);
	sigAppleSearchToo			= $686F6273 (* 'hobs' *);						{  the following are files types for system files  }
	ftScriptSystemResourceCollection = $6966696C (* 'ifil' *);
	ftSoundFile					= $7366696C (* 'sfil' *);
	ftFontFile					= $6666696C (* 'ffil' *);
	ftTrueTypeFontFile			= $7466696C (* 'tfil' *);
	ftKeyboardLayout			= $6B66696C (* 'kfil' *);
	ftFontSuitcase				= $4646494C (* 'FFIL' *);
	ftDASuitcase				= $4446494C (* 'DFIL' *);
	ftSystemExtension			= $494E4954 (* 'INIT' *);
	ftDAMQueryDocument			= $71657279 (* 'qery' *);


	{	************* Special FileTypes and creators *************	}
	ftApplicationName			= $61706E6D (* 'apnm' *);						{  this is the type used to define the application name in a kind resource  }
	sigIndustryStandard			= $69737464 (* 'istd' *);						{  this is the creator used to define a kind string in a kind resource for a FileType that has many creators   }
	ftXTND13TextImport			= $78743133 (* 'xt13' *);						{  this is a pseduo-format used by "XTND for Apps". The taDstIsAppTranslation bit is set  }


	{	************* Apple][ applications and FileTypes *************	}
	sigAppleProDOS				= $70646F73 (* 'pdos' *);						{  not registered  }
	ftAppleWorksWordProcessor	= $31412020 (* '1A  ' *);						{  not registered  }
	ftAppleWorks1WordProcessor	= $31413120 (* '1A1 ' *);						{  not registered  }
	ftAppleWorks2WordProcessor	= $31413220 (* '1A2 ' *);						{  not registered  }
	ftAppleWorks3WordProcessor	= $31413320 (* '1A3 ' *);						{  not registered  }
	ftAppleWorksDataBase		= $31392020 (* '19  ' *);						{  not registered  }
	ftAppleWorks1DataBase		= $31393120 (* '191 ' *);						{  not registered  }
	ftAppleWorks2DataBase		= $31393220 (* '192 ' *);						{  not registered  }
	ftAppleWorks3DataBase		= $31393320 (* '193 ' *);						{  not registered  }
	ftAppleWorksSpreadsheet		= $31422020 (* '1B  ' *);						{  not registered  }
	ftAppleWorks1Spreadsheet	= $31423120 (* '1B1 ' *);						{  not registered  }
	ftAppleWorks2Spreadsheet	= $31423220 (* '1B2 ' *);						{  not registered  }
	ftAppleWorks3Spreadsheet	= $31423320 (* '1B3 ' *);						{  not registered  }
	ftAppleWorksWordProcessorGS	= $35302020 (* '50  ' *);						{  not registered  }
	ftApple2GS_SuperHiRes		= $41325355 (* 'A2SU' *);						{  not registered  }
	ftApple2GS_SuperHiResPacked	= $41325350 (* 'A2SP' *);						{  not registered  }
	ftApple2GS_PaintWorks		= $41325057 (* 'A2PW' *);						{  not registered  }
	ftApple2_DoubleHiRes		= $41324455 (* 'A2DU' *);						{  not registered  }
	ftApple2_DoubleHiResPacked	= $41324450 (* 'A2DP' *);						{  not registered  }
	ftApple2_DoubleHiRes16colors = $41324443 (* 'A2DC' *);						{  not registered  }
	ftApple2_SingleHiRes		= $41324855 (* 'A2HU' *);						{  not registered  }
	ftApple2_SingleHiResPacked	= $41324850 (* 'A2HP' *);						{  not registered  }
	ftApple2_SingleHiRes8colors	= $41324843 (* 'A2HC' *);						{  not registered  }


	{	************* PC-DOS applications and FileTypes *************	}
	sigPCDOS					= $6D646F73 (* 'mdos' *);						{  not registered  }
	ftGenericDocumentPC			= $54455854 (* 'TEXT' *);						{     word processor formats  }
	ftWordStarDocumentPC		= $57537472 (* 'WStr' *);						{  not registered  }
	ftWordStar4DocumentPC		= $57537434 (* 'WSt4' *);						{  not registered  }
	ftWordStar5DocumentPC		= $57537435 (* 'WSt5' *);						{  not registered  }
	ftWordStar55DocumentPC		= $57533535 (* 'WS55' *);						{  not registered  }
	ftWordStar6DocumentPC		= $57537436 (* 'WSt6' *);						{  not registered  }
	ftWordStar2000DocumentPC	= $57533230 (* 'WS20' *);						{  not registered  }
	ftXyWriteIIIDocumentPC		= $58795772 (* 'XyWr' *);						{  registered???  }
	ftDecDXDocumentPC			= $44582020 (* 'DX  ' *);						{  registered???  }
	ftDecWPSPlusDocumentPC		= $5750532B (* 'WPS+' *);						{  registered???  }
	ftDisplayWrite3DocumentPC	= $44573320 (* 'DW3 ' *);						{  registered???  }
	ftDisplayWrite4DocumentPC	= $44573420 (* 'DW4 ' *);						{  registered???  }
	ftDisplayWrite5DocumentPC	= $44573520 (* 'DW5 ' *);						{  registered???  }
	ftIBMWritingAsstDocumentPC	= $41535354 (* 'ASST' *);						{  registered???  }
	ftManuscript1DocumentPC		= $4D414E31 (* 'MAN1' *);						{  registered???  }
	ftManuscript2DocumentPC		= $4D414E32 (* 'MAN2' *);						{  registered???  }
	ftMass11PCDocumentPC		= $4D313150 (* 'M11P' *);						{  registered???  }
	ftMass11VaxDocumentPC		= $4D313156 (* 'M11V' *);						{  registered???  }
	ftMultiMateDocumentPC		= $4D4D4154 (* 'MMAT' *);						{  registered???  }
	ftMultiMate36DocumentPC		= $4D4D3336 (* 'MM36' *);						{  registered???  }
	ftMultiMate40DocumentPC		= $4D4D3430 (* 'MM40' *);						{  registered???  }
	ftMultiMateAdvDocumentPC	= $4D4D4144 (* 'MMAD' *);						{  registered???  }
	ftMultiMateNoteDocumentPC	= $4D4D4E54 (* 'MMNT' *);						{  registered???  }
	ftOfficeWriterDocumentPC	= $4F464657 (* 'OFFW' *);						{  registered???  }
	ftPCFileLetterDocumentPC	= $5043464C (* 'PCFL' *);						{  registered???  }
	ftPFSWriteADocumentPC		= $50465341 (* 'PFSA' *);						{  registered???  }
	ftPFSWriteBDocumentPC		= $50465342 (* 'PFSB' *);						{  registered???  }
	ftPFSPlanDocumentPC			= $50465350 (* 'PFSP' *);						{  registered???  }
	ftProWrite1DocumentPC		= $50573120 (* 'PW1 ' *);						{  registered???  }
	ftProWrite2DocumentPC		= $50573220 (* 'PW2 ' *);						{  registered???  }
	ftProWritePlusDocumentPC	= $50572B20 (* 'PW+ ' *);						{  registered???  }
	ftFirstChoiceDocumentPC		= $46434820 (* 'FCH ' *);						{  registered???  }
	ftFirstChoice3DocumentPC	= $46434833 (* 'FCH3' *);						{  registered???  }
	ftDCARFTDocumentPC			= $52465420 (* 'RFT ' *);						{  registered???  }
	ftSamnaDocumentPC			= $53414D4E (* 'SAMN' *);						{  registered???  }
	ftSmartDocumentPC			= $534D5254 (* 'SMRT' *);						{  registered???  }
	ftSprintDocumentPC			= $53505254 (* 'SPRT' *);						{  registered???  }
	ftTotalWordDocumentPC		= $544F544C (* 'TOTL' *);						{  registered???  }
	ftVolksWriterDocumentPC		= $564F4C4B (* 'VOLK' *);						{  registered???  }
	ftWangWPSDocumentPC			= $57505320 (* 'WPS ' *);						{  registered???  }
	ftWordMarcDocumentPC		= $4D415243 (* 'MARC' *);						{  registered???  }
	ftAmiDocumentPC				= $414D4920 (* 'AMI ' *);						{  registered???  }
	ftAmiProDocumentPC			= $4150524F (* 'APRO' *);						{  registered???  }
	ftAmiPro2DocumentPC			= $41505232 (* 'APR2' *);						{  registered???  }
	ftEnableDocumentPC			= $454E5750 (* 'ENWP' *);						{  registered???  }
																{     data base formats  }
	ftdBaseDatabasePC			= $44424620 (* 'DBF ' *);						{  registered???  }
	ftdBase3DatabasePC			= $44423320 (* 'DB3 ' *);						{  registered???  }
	ftdBase4DatabasePC			= $44423420 (* 'DB4 ' *);						{  registered???  }
	ftDataEaseDatabasePC		= $4454455A (* 'DTEZ' *);						{  registered???  }
	ftFrameWorkIIIDatabasePC	= $46574B33 (* 'FWK3' *);						{  registered???  }
	ftRBaseVDatabasePC			= $52427356 (* 'RBsV' *);						{  registered???  }
	ftRBase5000DatabasePC		= $52423530 (* 'RB50' *);						{  registered???  }
	ftRBaseFile1DatabasePC		= $52427331 (* 'RBs1' *);						{  registered???  }
	ftRBaseFile3DatabasePC		= $52427333 (* 'RBs3' *);						{  registered???  }
	ftReflexDatabasePC			= $52464C58 (* 'RFLX' *);						{  registered???  }
	ftQAWriteDatabasePC			= $51415754 (* 'QAWT' *);						{  registered???  }
	ftQADBaseDatabasePC			= $51414442 (* 'QADB' *);						{  registered???  }
	ftSmartDataBasePC			= $534D5444 (* 'SMTD' *);						{  registered???  }
	ftFirstChoiceDataBasePC		= $46434442 (* 'FCDB' *);						{  registered???  }

																{     spread sheet formats  }
	ftDIFSpreadsheetPC			= $44494620 (* 'DIF ' *);						{  registered???  }
	ftEnableSpreadsheetPC		= $454E4142 (* 'ENAB' *);						{  registered???  }
	ft123R1SpreadsheetPC		= $574B5331 (* 'WKS1' *);						{  registered???  }
	ft123R2SpreadsheetPC		= $574B5332 (* 'WKS2' *);						{  registered???  }
	ft123R3SpreadsheetPC		= $574B5333 (* 'WKS3' *);						{  registered???  }
	ftParadox3SpreadsheetPC		= $50445833 (* 'PDX3' *);						{  registered???  }
	ftParadox35SpreadsheetPC	= $50443335 (* 'PD35' *);						{  registered???  }
	ftQuattroSpreadsheetPC		= $5154524F (* 'QTRO' *);						{  registered???  }
	ftQuattroProSpreadsheetPC	= $51545235 (* 'QTR5' *);						{  registered???  }
	ftSuperCalc5SpreadsheetPC	= $53504335 (* 'SPC5' *);						{  registered???  }
	ftSymphony1SpreadsheetPC	= $53594D31 (* 'SYM1' *);						{  registered???  }
	ftTwinSpreadsheetPC			= $5457494E (* 'TWIN' *);						{  registered???  }
	ftVPPlannerSpreadsheetPC	= $5650504C (* 'VPPL' *);						{  registered???  }
	ftSmartSpeadsheetPC			= $534D5348 (* 'SMSH' *);						{  registered???  }
	ftFirstChoiceSpeadsheetPC	= $46435353 (* 'FCSS' *);						{  registered???  }
																{     graphics formats  }
	ftPCPaintBrushGraphicPC		= $50435820 (* 'PCX ' *);						{  not registered  }
	ftLotusPICGraphicPC			= $2E504943 (* '.PIC' *);						{  not registered  }
	ftCGMGraphicPC				= $2E43474D (* '.CGM' *);						{  not registered  }
	ftGEMGraphicPC				= $2E47454D (* '.GEM' *);						{  not registered  }
	ftIMGGraphicPC				= $2E494D47 (* '.IMG' *);						{  not registered  }
	ftDXFGraphicPC				= $2E445846 (* '.DXF' *);						{  not registered  }
	ftBitmapWindows				= $2E424D50 (* '.BMP' *);						{  not registered  }
	ftMetaFileWindows			= $2E574D46 (* '.WMF' *);						{  not registered  }
	ftTIFFGraphic				= $54494646 (* 'TIFF' *);						{  not registered  }
	ftPostScriptPC				= $45505350 (* 'EPSP' *);
	ftPostScriptWindows			= $45505357 (* 'EPSW' *);						{  not registered  }
	ftDigitalFX_TitleMan		= $5444494D (* 'TDIM' *);						{  registered???  }
	ftDigitalFX_VideoFX			= $47524146 (* 'GRAF' *);						{  registered???  }
	ftAutodeskFLIandFLC			= $464C4943 (* 'FLIC' *);						{  registered???  }
	ftGIF						= $47494666 (* 'GIFf' *);						{  registered???  }
	ftIFF						= $494C424D (* 'ILBM' *);						{  registered???  }
	ftMicrosoftPaint			= $2E4D5350 (* '.MSP' *);						{  registered???  }
	ftPixar						= $50584152 (* 'PXAR' *);						{  registered???  }
	ftQDV						= $2E514456 (* '.QDV' *);						{  registered???  }
	ftRLE_Compuserve			= $524C4543 (* 'RLEC' *);						{  registered???  }
																{     Generic vector formats  }
	ftIGESGraphicPC				= $49474553 (* 'IGES' *);						{  not registered  }
	ftDDES2GraphicPC			= $44444553 (* 'DDES' *);						{  not registered  }
	ft3DGFGraphicPC				= $33444746 (* '3DGF' *);						{  not registered  }
																{     Plotter formats  }
	ftHPGLGraphicPC				= $4850474C (* 'HPGL' *);						{  not registered  }
	ftDMPLGraphicPC				= $444D504C (* 'DMPL' *);						{  not registered  }
	ftCalComp906GraphicPC		= $43393036 (* 'C906' *);						{  not registered  }
	ftCalComp907GraphicPC		= $43393037 (* 'C907' *);						{  not registered  }
																{     Vendor-specific formats  }
	ftStereoLithographyGraphicPC = $53544C20 (* 'STL ' *);						{     3D Systems     - not registered  }
	ftZoomGraphicPC				= $5A4F4F4D (* 'ZOOM' *);						{     Abvent          - not registered  }
	ftFocusGraphicPC			= $464F4353 (* 'FOCS' *);						{     Abvent          - not registered  }
	ftWaveFrontGraphicPC		= $574F424A (* 'WOBJ' *);						{     WaveFront      - not registered  }
	ftSculpt4DGraphicPC			= $53636E32 (* 'Scn2' *);						{     Byte By Byte   - not registered  }
	ftMiniPascal3GraphicPC		= $4D505433 (* 'MPT3' *);						{     Graphsoft      - not registered  }
	ftMiniPascal4GraphicPC		= $4D505434 (* 'MPT4' *);						{     Graphsoft      - not registered  }
	ftWalkThroughGraphicPC		= $56574C4B (* 'VWLK' *);						{     Virtus          - not registered  }
	ftSiliconGraphics			= $2E534749 (* '.SGI' *);						{  registered???  }
	ftSunRaster					= $2E53554E (* '.SUN' *);						{  registered???  }
	ftTarga						= $54504943 (* 'TPIC' *);						{  registered???  }
																{  misc DOS   }
	ftDOSComPC					= $2E434F4D (* '.COM' *);						{  registered???  }
	ftDOSExecutablePC			= $2E455845 (* '.EXE' *);						{  registered???  }
	ftDOSArcPC					= $2E415243 (* '.ARC' *);						{  registered???  }
	ftAbekas					= $4142454B (* 'ABEK' *);						{  registered???  }
	ftDrHaloCUT					= $2E435554 (* '.CUT' *);						{  registered???  }
																{  misc Atari  }
	ftDegas						= $44454741 (* 'DEGA' *);						{  not registered  }
	ftNEO						= $2E4E454F (* '.NEO' *);						{  not registered  }


{$ALIGN MAC68K}


{unit Finder}
{
     File:       Finder.p
 
     Contains:   Finder flags and container types.
 
     Version:    Technology: Mac OS 8.5
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   1990-2002 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}

{ Creator and type of clipping files }

const
	kClippingCreator			= $64726167 (* 'drag' *);
	kClippingPictureType		= $636C7070 (* 'clpp' *);
	kClippingTextType			= $636C7074 (* 'clpt' *);
	kClippingSoundType			= $636C7073 (* 'clps' *);
	kClippingUnknownType		= $636C7075 (* 'clpu' *);


	{	 Creator and type of Internet Location files 	}
	kInternetLocationCreator	= $64726167 (* 'drag' *);
	kInternetLocationHTTP		= $696C6874 (* 'ilht' *);
	kInternetLocationFTP		= $696C6674 (* 'ilft' *);
	kInternetLocationFile		= $696C6669 (* 'ilfi' *);
	kInternetLocationMail		= $696C6D61 (* 'ilma' *);
	kInternetLocationNNTP		= $696C6E77 (* 'ilnw' *);
	kInternetLocationAFP		= $696C6166 (* 'ilaf' *);
	kInternetLocationAppleTalk	= $696C6174 (* 'ilat' *);
	kInternetLocationNSL		= $696C6E73 (* 'ilns' *);
	kInternetLocationGeneric	= $696C6765 (* 'ilge' *);


	kCustomIconResource			= -16455;						{  Custom icon family resource ID  }

	{	 In order to specify any of the information described in the 	}
	{	 CustomBadgeResource data structure you must clear the kExtendedFlagsAreInvalid 	}
	{	 and set kExtendedFlagHasCustomBadge of the FXInfo.fdXFlags or DXInfo.frXFlags field, 	}
	{	 and add a resource of type kCustomBadgeResourceType and ID kCustomBadgeResourceID to 	}
	{	 the file or to the "Icon/n" file for a folder 	}
	kCustomBadgeResourceType	= $62616467 (* 'badg' *);
	kCustomBadgeResourceID		= -16455;
	kCustomBadgeResourceVersion	= 0;


type
	CustomBadgeResourcePtr = ^CustomBadgeResource;
	CustomBadgeResource = record
		version:				SInt16;									{  This is version kCustomBadgeResourceVersion }
		customBadgeResourceID:	SInt16;									{  If not 0, the ID of a resource to use on top }
																		{  of the icon for this file or folder }
		customBadgeType:		OSType;									{  If not 0, the type and creator of an icon }
		customBadgeCreator:		OSType;									{  to use on top of the icon }
		windowBadgeType:		OSType;									{  If not 0, the type and creator of an icon }
		windowBadgeCreator:		OSType;									{  to display in the header of the window for this  }
																		{  file or folder }
		overrideType:			OSType;									{  If not 0, the type and creator of an icon to }
		overrideCreator:		OSType;									{  use INSTEAD of the icon for this file or folder }
	end;

	CustomBadgeResourceHandle			= ^CustomBadgeResourcePtr;
	{	 You can specify routing information for a file by including a 'rout' 0 
	    resource in it and setting the kExtendedFlagHasRoutingInfo bit in the extended 
	    Finder flags. 
	    The 'rout' resource is an array of RoutingResourceEntry. Each entry is considered
	    in turn. The first matching entry is used.
	    If the creator and fileType match the file being dropped and targetFolder match
	    the folder ID of the folder being dropped onto, then the file is rerouted 
	    into the specified destination folder.
	    The only target folder currently supported is the system folder, 
	    kSystemFolderType = 'macs'.
		}

const
	kRoutingResourceType		= $726F7574 (* 'rout' *);
	kRoutingResourceID			= 0;


type
	RoutingResourceEntryPtr = ^RoutingResourceEntry;
	RoutingResourceEntry = record
		creator:				OSType;									{  Use '****' or 0 to match any creator  }
		fileType:				OSType;									{  Use '****' or 0 to match any file type  }
		targetFolder:			OSType;									{  Folder ID of the folder this file was dropped onto  }
		destinationFolder:		OSType;									{  Folder that the source will be routed to  }
		reservedField:			OSType;									{  Set to 0  }
	end;

	RoutingResourcePtr					= ^RoutingResourceEntry;
	RoutingResourceHandle				= ^RoutingResourcePtr;

	{	 Types for special container aliases 	}

const
	kContainerFolderAliasType	= $66647270 (* 'fdrp' *);						{  type for folder aliases  }
	kContainerTrashAliasType	= $74727368 (* 'trsh' *);						{  type for trash folder aliases  }
	kContainerHardDiskAliasType	= $6864736B (* 'hdsk' *);						{  type for hard disk aliases  }
	kContainerFloppyAliasType	= $666C7079 (* 'flpy' *);						{  type for floppy aliases  }
	kContainerServerAliasType	= $73727672 (* 'srvr' *);						{  type for server aliases  }
	kApplicationAliasType		= $61647270 (* 'adrp' *);						{  type for application aliases  }
	kContainerAliasType			= $64726F70 (* 'drop' *);						{  type for all other containers  }
	kDesktopPrinterAliasType	= $64747061 (* 'dtpa' *);						{  type for Desktop Printer alias  }
	kContainerCDROMAliasType	= $63646472 (* 'cddr' *);						{  type for CD-ROM alias  }
	kApplicationCPAliasType		= $61636470 (* 'acdp' *);						{  type for application control panel alias  }
	kApplicationDAAliasType		= $61646470 (* 'addp' *);						{  type for application DA alias  }
	kPackageAliasType			= $66706B61 (* 'fpka' *);						{  type for plain package alias  }
	kAppPackageAliasType		= $66617061 (* 'fapa' *);						{  type for application package alias  }

	{	 Types for Special folder aliases 	}
	kSystemFolderAliasType		= $66617379 (* 'fasy' *);
	kAppleMenuFolderAliasType	= $6661616D (* 'faam' *);
	kStartupFolderAliasType		= $66617374 (* 'fast' *);
	kPrintMonitorDocsFolderAliasType = $6661706E (* 'fapn' *);
	kPreferencesFolderAliasType	= $66617066 (* 'fapf' *);
	kControlPanelFolderAliasType = $66616374 (* 'fact' *);
	kExtensionFolderAliasType	= $66616578 (* 'faex' *);

	{	 Types for AppleShare folder aliases 	}
	kExportedFolderAliasType	= $66616574 (* 'faet' *);
	kDropFolderAliasType		= $66616472 (* 'fadr' *);
	kSharedFolderAliasType		= $66617368 (* 'fash' *);
	kMountedFolderAliasType		= $66616D6E (* 'famn' *);

	{	 Finder flags (finderFlags, fdFlags and frFlags) 	}
	{	 Any flag reserved or not specified should be set to 0. 	}
	{	 If a flag applies to a file, but not to a folder, make sure to check 	}
	{	 that the item is not a folder by checking ((ParamBlockRec.ioFlAttrib & ioDirMask) == 0) 	}
	kIsOnDesk					= $0001;						{  Files and folders (System 6)  }
	kColor						= $000E;						{  Files and folders  }
																{  bit 0x0020 was kRequireSwitchLaunch, but is now reserved for future use }
	kIsShared					= $0040;						{  Files only (Applications only)  }
																{  If clear, the application needs to write to  }
																{  its resource fork, and therefore cannot be  }
																{  shared on a server  }
	kHasNoINITs					= $0080;						{  Files only (Extensions/Control Panels only)  }
																{  This file contains no INIT resource  }
	kHasBeenInited				= $0100;						{  Files only  }
																{  Clear if the file contains desktop database  }
																{  resources ('BNDL', 'FREF', 'open', 'kind'...)  }
																{  that have not been added yet. Set only by the Finder  }
																{  Reserved for folders - make sure this bit is cleared for folders  }
																{  bit 0x0200 was the letter bit for AOCE, but is now reserved for future use  }
	kHasCustomIcon				= $0400;						{  Files and folders  }
	kIsStationery				= $0800;						{  Files only  }
	kNameLocked					= $1000;						{  Files and folders  }
	kHasBundle					= $2000;						{  Files only  }
	kIsInvisible				= $4000;						{  Files and folders  }
	kIsAlias					= $8000;						{  Files only  }

	{	 Obsolete. Use names defined above. 	}
	fOnDesk						= $0001;
	fHasBundle					= $2000;
	fInvisible					= $4000;

	{	 Obsolete 	}
	fTrash						= -3;
	fDesktop					= -2;
	fDisk						= 0;

{$ifc OLDROUTINENAMES}
	kIsStationary				= $0800;

{$endc}  {OLDROUTINENAMES}

	{	 Extended flags (extendedFinderFlags, fdXFlags and frXFlags) 	}
	{	 Any flag not specified should be set to 0. 	}
	kExtendedFlagsAreInvalid	= $8000;						{  If set the other extended flags are ignored  }
	kExtendedFlagHasCustomBadge	= $0100;						{  Set if the file or folder has a badge resource  }
	kExtendedFlagHasRoutingInfo	= $0004;						{  Set if the file contains routing info resource  }


	{	 Use a filetype in this range to indicate that a file is temporarily busy 	}
	{	 (while it is being downloaded or installed, for example).  This prevents 	}
	{	 Finder 8.5 and later from trying to change the item's attributes before it 	}
	{	 is fully created. -- If you provide a series of 'BNDL' icons for your creator 	}
	{	 and some of these filetypes, you can achieve limited icon animation while 	}
	{	 the file creation progresses. 	}
	kFirstMagicBusyFiletype		= $627A7920 (* 'bzy ' *);
	kLastMagicBusyFiletype		= $627A793F (* 'bzy?' *);

	{	 Use this date as a file's or folder's creation date to indicate that it is 	}
	{	 temporarily busy (while it is being downloaded or installed, for example). 	}
	{	 This prevents Finder from trying to change the item's attributes before it 	}
	{	 is fully created (Finder 8.5 and 8.6 check file creation dates; later Finders 	}
	{	 may check folder creation dates as well). 	}
	kMagicBusyCreationDate		= $4F3AFDB0;


	{	------------------------------------------------------------------------	}
	{
	   The following data structures are binary compatible with FInfo, DInfo,
	   FXInfo and DXInfo but represent the Mac OS 8 semantic of the fields.
	   Use these data structures preferably to FInfo, etc...
	}
	{	------------------------------------------------------------------------	}


type
	FileInfoPtr = ^FileInfo;
	FileInfo = record
		fileType:				OSType;									{  The type of the file  }
		fileCreator:			OSType;									{  The file's creator  }
		finderFlags:			UInt16;									{  ex: kHasBundle, kIsInvisible...  }
		location:				Point;									{  File's location in the folder  }
																		{  If set to (0, 0), the Finder will place the item automatically  }
		reservedField:			UInt16;									{  (set to 0)  }
	end;

	FolderInfoPtr = ^FolderInfo;
	FolderInfo = record
		windowBounds:			Rect;									{  The position and dimension of the folder's window  }
		finderFlags:			UInt16;									{  ex. kIsInvisible, kNameLocked, etc. }
		location:				Point;									{  Folder's location in the parent folder  }
																		{  If set to (0, 0), the Finder will place the item automatically  }
		reservedField:			UInt16;									{  (set to 0)  }
	end;

	ExtendedFileInfoPtr = ^ExtendedFileInfo;
	ExtendedFileInfo = record
		reserved1:				array [0..3] of SInt16;					{  Reserved (set to 0)  }
		extendedFinderFlags:	UInt16;									{  Extended flags (custom badge, routing info...)  }
		reserved2:				SInt16;									{  Reserved (set to 0). Comment ID if high-bit is clear  }
		putAwayFolderID:		SInt32;									{  Put away folder ID  }
	end;

	ExtendedFolderInfoPtr = ^ExtendedFolderInfo;
	ExtendedFolderInfo = record
		scrollPosition:			Point;									{  Scroll position (for icon views)  }
		reserved1:				SInt32;									{  Reserved (set to 0)  }
		extendedFinderFlags:	UInt16;									{  Extended flags (custom badge, routing info...)  }
		reserved2:				SInt16;									{  Reserved (set to 0). Comment ID if high-bit is clear  }
		putAwayFolderID:		SInt32;									{  Put away folder ID  }
	end;

	{	------------------------------------------------------------------------	}
	{
	   The following data structures are here for compatibility.
	   Use the new data structures replacing them if possible (i.e. FileInfo 
	   instead of FInfo, etc...)
	}
	{	------------------------------------------------------------------------	}
	{	 File info 	}
	{
	     IMPORTANT:
	     In MacOS 8, the fdFldr field has become reserved for the Finder.
	}
	FInfoPtr = ^FInfo;
	FInfo = record
		fdType:					OSType;									{  The type of the file  }
		fdCreator:				OSType;									{  The file's creator  }
		fdFlags:				UInt16;									{  Flags ex. kHasBundle, kIsInvisible, etc.  }
		fdLocation:				Point;									{  File's location in folder.  }
																		{  If set to (0, 0), the Finder will place the item automatically  }
		fdFldr:					SInt16;									{  Reserved (set to 0)  }
	end;

	{	 Extended file info 	}
	{
	     IMPORTANT:
	     In MacOS 8, the fdIconID and fdComment fields were changed
	     to become reserved fields for the Finder.
	     The fdScript has become an extended flag.
	}
	FXInfoPtr = ^FXInfo;
	FXInfo = record
		fdIconID:				SInt16;									{  Reserved (set to 0)  }
		fdReserved:				array [0..2] of SInt16;					{  Reserved (set to 0)  }
		fdScript:				SInt8;									{  Extended flags. Script code if high-bit is set  }
		fdXFlags:				SInt8;									{  Extended flags  }
		fdComment:				SInt16;									{  Reserved (set to 0). Comment ID if high-bit is clear  }
		fdPutAway:				SInt32;									{  Put away folder ID  }
	end;

	{	 Folder info 	}
	{
	     IMPORTANT:
	     In MacOS 8, the frView field was changed to become reserved 
	     field for the Finder.
	}
	DInfoPtr = ^DInfo;
	DInfo = record
		frRect:					Rect;									{  Folder's window bounds  }
		frFlags:				UInt16;									{  Flags ex. kIsInvisible, kNameLocked, etc. }
		frLocation:				Point;									{  Folder's location in parent folder  }
																		{  If set to (0, 0), the Finder will place the item automatically  }
		frView:					SInt16;									{  Reserved (set to 0)  }
	end;

	{	 Extended folder info 	}
	{
	     IMPORTANT:
	     In MacOS 8, the frOpenChain and frComment fields were changed
	     to become reserved fields for the Finder.
	     The frScript has become an extended flag.
	}
	DXInfoPtr = ^DXInfo;
	DXInfo = record
		frScroll:				Point;									{  Scroll position  }
		frOpenChain:			SInt32;									{  Reserved (set to 0)  }
		frScript:				SInt8;									{  Extended flags. Script code if high-bit is set  }
		frXFlags:				SInt8;									{  Extended flags  }
		frComment:				SInt16;									{  Reserved (set to 0). Comment ID if high-bit is clear  }
		frPutAway:				SInt32;									{  Put away folder ID  }
	end;

	{  ControlPanelDefProcPtr and cdev constants have all been moved to Processes.i }
{$ALIGN MAC68K}


{unit FixMath}
{
     File:       FixMath.p
 
     Contains:   Fixed Math Interfaces.
 
     Version:    Technology: Mac OS 8
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   1985-2002 by Apple Computer, Inc., all rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}


const
	fixed1						= $00010000;
	fract1						= $40000000;
	positiveInfinity			= $7FFFFFFF;
	negativeInfinity			= $80000000;

	{	
	    FixRatio, FixMul, and FixRound were previously in ToolUtils.h
		}
	{
	 *  FixRatio()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 and later
	 	}
function FixRatio(numer: SInt16; denom: SInt16): Fixed; external name '_FixRatio';
{
 *  FixMul()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function FixMul(a: Fixed; b: Fixed): Fixed; external name '_FixMul';
{
 *  FixRound()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function FixRound(x: Fixed): SInt16; external name '_FixRound';
{
 *  Fix2Frac()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function Fix2Frac(x: Fixed): Fract; external name '_Fix2Frac';
{
 *  Fix2Long()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function Fix2Long(x: Fixed): SInt32; external name '_Fix2Long';
{
 *  Long2Fix()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function Long2Fix(x: SInt32): Fixed; external name '_Long2Fix';
{
 *  Frac2Fix()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function Frac2Fix(x: Fract): Fixed; external name '_Frac2Fix';
{
 *  FracMul()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function FracMul(x: Fract; y: Fract): Fract; external name '_FracMul';
{
 *  FixDiv()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function FixDiv(x: Fixed; y: Fixed): Fixed; external name '_FixDiv';
{
 *  FracDiv()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function FracDiv(x: Fract; y: Fract): Fract; external name '_FracDiv';
{
 *  FracSqrt()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function FracSqrt(x: Fract): Fract; external name '_FracSqrt';
{
 *  FracSin()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function FracSin(x: Fixed): Fract; external name '_FracSin';
{
 *  FracCos()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function FracCos(x: Fixed): Fract; external name '_FracCos';
{
 *  FixATan2()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function FixATan2(x: SInt32; y: SInt32): Fixed; external name '_FixATan2';
{
    Frac2X, Fix2X, X2Fix, and X2Frac translate to and from
    the floating point type "extended" (that's what the X is for).
    On the original Mac this was 80-bits and the functions could be
    accessed via A-Traps.  When the 68881 co-processor was added,
    it used 96-bit floating point types, so the A-Traps could not 
    be used.  When PowerPC was added, it used 64-bit floating point
    types, so yet another prototype was added.
}
{$ifc TARGET_CPU_68K}
{$ifc TARGET_RT_MAC_68881}
{$ifc CALL_NOT_IN_CARBON}
{
 *  Frac2X()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function Frac2X(x: Fract): extended; external name '_Frac2X';

{
 *  Fix2X()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function Fix2X(x: Fixed): extended; external name '_Fix2X';

{
 *  X2Fix()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function X2Fix(x: extended): Fixed; external name '_X2Fix';

{
 *  X2Frac()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function X2Frac(x: extended): Fract; external name '_X2Frac';

{$endc}  {CALL_NOT_IN_CARBON}
{$elsec}
{$ifc CALL_NOT_IN_CARBON}
{
 *  Frac2X()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function Frac2X(x: Fract): extended; external name '_Frac2X';
{
 *  Fix2X()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function Fix2X(x: Fixed): extended; external name '_Fix2X';
{
 *  X2Fix()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function X2Fix(x: extended): Fixed; external name '_X2Fix';
{
 *  X2Frac()
 *  
 *  Availability:
 *    Non-Carbon CFM:   not available
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function X2Frac(x: extended): Fract; external name '_X2Frac';
{$endc}  {CALL_NOT_IN_CARBON}
{$endc}  {TARGET_RT_MAC_68881}
{$elsec}
{
 *  Frac2X()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function Frac2X(x: Fract): Double; external name '_Frac2X';

{
 *  Fix2X()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function Fix2X(x: Fixed): Double; external name '_Fix2X';

{
 *  X2Fix()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function X2Fix(x: Double): Fixed; external name '_X2Fix';

{
 *  X2Frac()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function X2Frac(x: Double): Fract; external name '_X2Frac';

{$endc}  {TARGET_CPU_68K}

{  QuickTime 3.0 makes these Wide routines available on other platforms }
{$ifc TARGET_CPU_PPC OR NOT TARGET_OS_MAC}
{
 *  WideCompare()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function WideCompare(const (*var*) target: wide; const (*var*) source: wide): SInt16; external name '_WideCompare';

{
 *  WideAdd()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function WideAdd(var target: wide; const (*var*) source: wide): widePtr; external name '_WideAdd';

{
 *  WideSubtract()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function WideSubtract(var target: wide; const (*var*) source: wide): widePtr; external name '_WideSubtract';

{
 *  WideNegate()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function WideNegate(var target: wide): widePtr; external name '_WideNegate';

{
 *  WideShift()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function WideShift(var target: wide; shift: SInt32): widePtr; external name '_WideShift';

{
 *  WideSquareRoot()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function WideSquareRoot(const (*var*) source: wide): UInt32; external name '_WideSquareRoot';

{
 *  WideMultiply()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function WideMultiply(multiplicand: SInt32; multiplier: SInt32; var target: wide): widePtr; external name '_WideMultiply';

{ returns the quotient }
{
 *  WideDivide()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function WideDivide(const (*var*) dividend: wide; divisor: SInt32; var remainder: SInt32): SInt32; external name '_WideDivide';

{ quotient replaces dividend }
{
 *  WideWideDivide()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function WideWideDivide(var dividend: wide; divisor: SInt32; var remainder: SInt32): widePtr; external name '_WideWideDivide';

{
 *  WideBitShift()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function WideBitShift(var src: wide; shift: SInt32): widePtr; external name '_WideBitShift';

{$endc}


{$ALIGN MAC68K}


{unit GXTypes}
{
     File:       GXTypes.p
 
     Contains:   QuickDraw GX object and constant definitions
 
     Version:    Technology: Quickdraw GX 1.1
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   1994-2002 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}


type
	gxShape    = ^SInt32; { an opaque 32-bit type }
	gxShapePtr = ^gxShape;  { when a var xx:gxShape parameter can be nil, it is changed to xx: gxShapePtr }
	gxStyle    = ^SInt32; { an opaque 32-bit type }
	gxStylePtr = ^gxStyle;  { when a var xx:gxStyle parameter can be nil, it is changed to xx: gxStylePtr }
	gxInk    = ^SInt32; { an opaque 32-bit type }
	gxInkPtr = ^gxInk;  { when a var xx:gxInk parameter can be nil, it is changed to xx: gxInkPtr }
	gxTransform    = ^SInt32; { an opaque 32-bit type }
	gxTransformPtr = ^gxTransform;  { when a var xx:gxTransform parameter can be nil, it is changed to xx: gxTransformPtr }
	gxTag    = ^SInt32; { an opaque 32-bit type }
	gxTagPtr = ^gxTag;  { when a var xx:gxTag parameter can be nil, it is changed to xx: gxTagPtr }
	gxColorSet    = ^SInt32; { an opaque 32-bit type }
	gxColorSetPtr = ^gxColorSet;  { when a var xx:gxColorSet parameter can be nil, it is changed to xx: gxColorSetPtr }
	gxColorProfile    = ^SInt32; { an opaque 32-bit type }
	gxColorProfilePtr = ^gxColorProfile;  { when a var xx:gxColorProfile parameter can be nil, it is changed to xx: gxColorProfilePtr }
	gxGraphicsClient    = ^SInt32; { an opaque 32-bit type }
	gxGraphicsClientPtr = ^gxGraphicsClient;  { when a var xx:gxGraphicsClient parameter can be nil, it is changed to xx: gxGraphicsClientPtr }
	gxViewGroup    = ^SInt32; { an opaque 32-bit type }
	gxViewGroupPtr = ^gxViewGroup;  { when a var xx:gxViewGroup parameter can be nil, it is changed to xx: gxViewGroupPtr }
	gxViewPort    = ^SInt32; { an opaque 32-bit type }
	gxViewPortPtr = ^gxViewPort;  { when a var xx:gxViewPort parameter can be nil, it is changed to xx: gxViewPortPtr }
	gxViewDevice    = ^SInt32; { an opaque 32-bit type }
	gxViewDevicePtr = ^gxViewDevice;  { when a var xx:gxViewDevice parameter can be nil, it is changed to xx: gxViewDevicePtr }

	gxColorSpace						= SInt32;
	{	 gxShape enumerations 	}

const
	gxEmptyType					= 1;
	gxPointType					= 2;
	gxLineType					= 3;
	gxCurveType					= 4;
	gxRectangleType				= 5;
	gxPolygonType				= 6;
	gxPathType					= 7;
	gxBitmapType				= 8;
	gxTextType					= 9;
	gxGlyphType					= 10;
	gxLayoutType				= 11;
	gxFullType					= 12;
	gxPictureType				= 13;


type
	gxShapeType							= SInt32;

const
	gxNoFill					= 0;
	gxOpenFrameFill				= 1;
	gxFrameFill					= 1;
	gxClosedFrameFill			= 2;
	gxHollowFill				= 2;
	gxEvenOddFill				= 3;
	gxSolidFill					= 3;
	gxWindingFill				= 4;
	gxInverseEvenOddFill		= 5;
	gxInverseSolidFill			= 5;
	gxInverseFill				= 5;
	gxInverseWindingFill		= 6;


type
	gxShapeFill							= SInt32;

const
	gxNoAttributes				= 0;
	gxDirectShape				= $0001;
	gxRemoteShape				= $0002;
	gxCachedShape				= $0004;
	gxLockedShape				= $0008;
	gxGroupShape				= $0010;
	gxMapTransformShape			= $0020;
	gxUniqueItemsShape			= $0040;
	gxIgnorePlatformShape		= $0080;
	gxNoMetricsGridShape		= $0100;
	gxDiskShape					= $0200;
	gxMemoryShape				= $0400;


type
	gxShapeAttribute					= SInt32;
	{	 gxShape editing enumerations 	}

const
	gxBreakNeitherEdit			= 0;
	gxBreakLeftEdit				= $0001;
	gxBreakRightEdit			= $0002;
	gxRemoveDuplicatePointsEdit	= $0004;

	{	 if the new first (or last) point exactly matches the point before it in 	}
	{	 the same contour, then remove it) 	}

type
	gxEditShapeFlag						= SInt32;

const
	gxSelectToEnd				= -1;

	gxAnyNumber					= 1;
	gxSetToNil					= -1;

	gxCounterclockwiseDirection	= 0;
	gxClockwiseDirection		= 1;


type
	gxPointPtr = ^gxPoint;
	gxPoint = record
		x:						Fixed;
		y:						Fixed;
	end;
	gxColorValue						= UInt16;
	gxPolarPtr = ^gxPolar;
	gxPolar = record
		radius:					Fixed;
		angle:					Fixed;
	end;

	gxMappingPtr = ^gxMapping;
	gxMapping = record
		map:					array [0..2,0..2] OF Fixed;
	end;

type

	gxContourDirection					= SInt32;
	{	 gxShape structures 	}
	{	 The type 'gxPoint' is defined in "GXMath.h" 	}
	gxLinePtr = ^gxLine;
	gxLine = record
		first:					gxPoint;
		last:					gxPoint;
	end;

	gxCurvePtr = ^gxCurve;
	gxCurve = record
		first:					gxPoint;
		control:				gxPoint;
		last:					gxPoint;
	end;

	gxRectanglePtr = ^gxRectangle;
	gxRectangle = record
		left:					Fixed;
		top:					Fixed;
		right:					Fixed;
		bottom:					Fixed;
	end;

	gxPolygonPtr = ^gxPolygon;
	gxPolygon = record
		vectors:				SInt32;
		vector:					array [0..0] of gxPoint;
	end;

	gxPolygonsPtr = ^gxPolygons;
	gxPolygons = record
		contours:				SInt32;
		contour:				array [0..0] of gxPolygon;
	end;

	gxPathPtr = ^gxPath;
	gxPath = record
		vectors:				SInt32;
		controlBits:			array [0..0] of SInt32;
		vector:					array [0..0] of gxPoint;
	end;

	gxPathsPtr = ^gxPaths;
	gxPaths = record
		contours:				SInt32;
		contour:				array [0..0] of gxPath;
	end;

	gxBitmapPtr = ^gxBitmap;
	gxBitmap = record
		image:					CStringPtr;								{  pointer to pixels  }
		width:					SInt32;								{  width in pixels  }
		height:					SInt32;								{  height in pixels  }
		rowBytes:				SInt32;								{  width in bytes  }
		pixelSize:				SInt32;								{  physical bits per pixel  }
		space:					gxColorSpace;
		colorSet:				gxColorSet;
		profile:				gxColorProfile;
	end;

	gxLongRectanglePtr = ^gxLongRectangle;
	gxLongRectangle = record
		left:					SInt32;
		top:					SInt32;
		right:					SInt32;
		bottom:					SInt32;
	end;

	{	 gxStyle enumerations 	}

const
	gxCenterFrameStyle			= 0;
	gxSourceGridStyle			= $0001;
	gxDeviceGridStyle			= $0002;
	gxInsideFrameStyle			= $0004;
	gxOutsideFrameStyle			= $0008;
	gxAutoInsetStyle			= $0010;


type
	gxStyleAttribute					= SInt32;

const
	gxBendDash					= $0001;
	gxBreakDash					= $0002;
	gxClipDash					= $0004;
	gxLevelDash					= $0008;
	gxAutoAdvanceDash			= $0010;


type
	gxDashAttribute						= SInt32;

const
	gxPortAlignPattern			= $0001;
	gxPortMapPattern			= $0002;


type
	gxPatternAttribute					= SInt32;

const
	gxSharpJoin					= $0000;
	gxCurveJoin					= $0001;
	gxLevelJoin					= $0002;
	gxSnapJoin					= $0004;


type
	gxJoinAttribute						= SInt32;

const
	gxLevelStartCap				= $0001;
	gxLevelEndCap				= $0002;


type
	gxCapAttribute						= SInt32;

const
	gxAutoAdvanceText			= $0001;
	gxNoContourGridText			= $0002;
	gxNoMetricsGridText			= $0004;
	gxAnchorPointsText			= $0008;
	gxVerticalText				= $0010;
	gxNoOpticalScaleText		= $0020;


type
	gxTextAttribute						= SInt32;

const
	gxLeftJustify				= 0;
	gxCenterJustify				= $20000000;
	gxRightJustify				= $40000000;
	gxFillJustify				= -1;

	gxUnderlineAdvanceLayer		= $0001;						{  a gxLine is drawn through the advances  }
	gxSkipWhiteSpaceLayer		= $0002;						{  except characters describing white space  }
	gxUnderlineIntervalLayer	= $0004;						{  (+ gxStringLayer) a gxLine is drawn through the gaps between advances  }
	gxUnderlineContinuationLayer = $0008;						{  (+ gxStringLayer) join this underline with another face  }
	gxWhiteLayer				= $0010;						{  the layer draws to white instead of black  }
	gxClipLayer					= $0020;						{  the characters define a clip  }
	gxStringLayer				= $0040;						{  all characters in run are combined  }


type
	gxLayerFlag							= SInt32;
	{	 gxStyle structures 	}
	gxFaceLayerPtr = ^gxFaceLayer;
	gxFaceLayer = record
		outlineFill:			gxShapeFill;							{  outline framed or filled  }
		flags:					gxLayerFlag;							{  various additional effects  }
		outlineStyle:			gxStyle;								{  outline  }
		outlineTransform:		gxTransform;							{  italic, condense, extend  }
		boldOutset:				gxPoint;								{  bold  }
	end;

	gxTextFacePtr = ^gxTextFace;
	gxTextFace = record
		faceLayers:				SInt32;								{  layer to implement shadow  }
		advanceMapping:			gxMapping;								{  algorithmic change to advance width  }
		faceLayer:				array [0..0] of gxFaceLayer;			{  zero or more face layers describing the face  }
	end;

	gxJoinRecordPtr = ^gxJoinRecord;
	gxJoinRecord = record
		attributes:				gxJoinAttribute;
		join:					gxShape;
		miter:					Fixed;
	end;

	gxDashRecordPtr = ^gxDashRecord;
	gxDashRecord = record
		attributes:				gxDashAttribute;
		dash:					gxShape;								{  similar to pattern, except rotated to gxLine slope  }
		advance:				Fixed;									{  specifies repeating frequency of dash  }
		phase:					Fract;									{  specifies offset into the gxPath to start dashing  }
		scale:					Fixed;									{  specifies height of dash to be mapped to penWidth  }
	end;

	gxPatternRecordPtr = ^gxPatternRecord;
	gxPatternRecord = record
		attributes:				gxPatternAttribute;
		pattern:				gxShape;
		u:						gxPoint;
		v:						gxPoint;
	end;

	gxCapRecordPtr = ^gxCapRecord;
	gxCapRecord = record
		attributes:				gxCapAttribute;
		startCap:				gxShape;
		endCap:					gxShape;
	end;


	{	 gxInk enumerations 	}

const
	gxPortAlignDitherInk		= $0001;
	gxForceDitherInk			= $0002;
	gxSuppressDitherInk			= $0004;
	gxSuppressHalftoneInk		= $0008;


type
	gxInkAttribute						= SInt32;

const
	gxNoMode					= 0;
	gxCopyMode					= 1;
	gxAddMode					= 2;
	gxBlendMode					= 3;
	gxMigrateMode				= 4;
	gxMinimumMode				= 5;
	gxMaximumMode				= 6;
	gxHighlightMode				= 7;
	gxAndMode					= 8;
	gxOrMode					= 9;
	gxXorMode					= 10;
	gxRampAndMode				= 11;
	gxRampOrMode				= 12;
	gxRampXorMode				= 13;
	gxOverMode					= 14;							{  Alpha channel modes           }
	gxAtopMode					= 15;							{  Note: In England = Beta channel modes    }
	gxExcludeMode				= 16;
	gxFadeMode					= 17;


type
	gxComponentMode						= SInt8;

const
	gxRejectSourceTransfer		= $0001;						{  at least one component must be out of range        }
	gxRejectDeviceTransfer		= $0002;						{  at least one component must be out of range        }
	gxSingleComponentTransfer	= $0004;						{  duplicate gxTransferComponent[0] for all components in transfer  }


type
	gxTransferFlag						= SInt32;

const
	gxOverResultComponent		= $01;							{  & result gxColor with 0xFFFF before clamping    }
	gxReverseComponent			= $02;							{  reverse source and device before moding        }


type
	gxComponentFlag						= SInt8;
	{	 gxInk structures 	}
	gxTransferComponentPtr = ^gxTransferComponent;
	gxTransferComponent = record
		mode:					gxComponentMode;						{  how the component is operated upon  }
		flags:					gxComponentFlag;						{  flags for each component    }
		sourceMinimum:			gxColorValue;
		sourceMaximum:			gxColorValue;							{  input filter range  }
		deviceMinimum:			gxColorValue;
		deviceMaximum:			gxColorValue;							{  output filter range  }
		clampMinimum:			gxColorValue;
		clampMaximum:			gxColorValue;							{  output clamping range  }
		operand:				gxColorValue;							{  ratio for blend, step for migrate, gxColor for highlight    }
	end;

	gxTransferModePtr = ^gxTransferMode;
	gxTransferMode = record
		space:					gxColorSpace;							{  the gxColor-space the transfer mode is to operate in    }
		colorSet:				gxColorSet;
		profile:				gxColorProfile;
		sourceMatrix:			array [0..4,0..3] of Fixed;
		deviceMatrix:			array [0..4,0..3] of Fixed;
		resultMatrix:			array [0..4,0..3] of Fixed;
		flags:					gxTransferFlag;
		component:				array [0..3] of gxTransferComponent;	{  how each component is operated upon          }
	end;


	{	 gxColor space enumerations 	}

const
	gxNoColorPacking			= $0000;						{  16 bits per channel  }
	gxAlphaSpace				= $0080;						{  space includes alpha channel  }
	gxWord5ColorPacking			= $0500;						{  5 bits per channel, right-justified  }
	gxLong8ColorPacking			= $0800;						{  8 bits per channel, right-justified  }
	gxLong10ColorPacking		= $0A00;						{  10 bits per channel, right-justified  }
	gxAlphaFirstPacking			= $1000;						{  alpha channel is the first field in the packed space  }

	gxNoSpace					= 0;
	gxRGBSpace					= 1;
	gxCMYKSpace					= 2;
	gxHSVSpace					= 3;
	gxHLSSpace					= 4;
	gxYXYSpace					= 5;
	gxXYZSpace					= 6;
	gxLUVSpace					= 7;
	gxLABSpace					= 8;
	gxYIQSpace					= 9;
	gxNTSCSpace					= 9;
	gxPALSpace					= 9;
	gxGraySpace					= 10;
	gxIndexedSpace				= 11;
	gxRGBASpace					= 129;
	gxGrayASpace				= 138;
	gxRGB16Space				= $0501;
	gxRGB32Space				= $0801;
	gxARGB32Space				= $1881;
	gxCMYK32Space				= $0802;
	gxHSV32Space				= $0A03;
	gxHLS32Space				= $0A04;
	gxYXY32Space				= $0A05;
	gxXYZ32Space				= $0A06;
	gxLUV32Space				= $0A07;
	gxLAB32Space				= $0A08;
	gxYIQ32Space				= $0A09;
	gxNTSC32Space				= $0A09;
	gxPAL32Space				= $0A09;

	{	 gxColor space structures 	}

type
	gxRGBColorPtr = ^gxRGBColor;
	gxRGBColor = record
		red:					gxColorValue;
		green:					gxColorValue;
		blue:					gxColorValue;
	end;

	gxRGBAColorPtr = ^gxRGBAColor;
	gxRGBAColor = record
		red:					gxColorValue;
		green:					gxColorValue;
		blue:					gxColorValue;
		alpha:					gxColorValue;
	end;

	gxHSVColorPtr = ^gxHSVColor;
	gxHSVColor = record
		hue:					gxColorValue;
		saturation:				gxColorValue;
		value:					gxColorValue;
	end;

	gxHLSColorPtr = ^gxHLSColor;
	gxHLSColor = record
		hue:					gxColorValue;
		lightness:				gxColorValue;
		saturation:				gxColorValue;
	end;

	gxCMYKColorPtr = ^gxCMYKColor;
	gxCMYKColor = record
		cyan:					gxColorValue;
		magenta:				gxColorValue;
		yellow:					gxColorValue;
		black:					gxColorValue;
	end;

	gxXYZColorPtr = ^gxXYZColor;
	gxXYZColor = record
		x:						gxColorValue;
		y:						gxColorValue;
		z:						gxColorValue;
	end;

	gxYXYColorPtr = ^gxYXYColor;
	gxYXYColor = record
		capY:					gxColorValue;
		x:						gxColorValue;
		y:						gxColorValue;
	end;

	gxLUVColorPtr = ^gxLUVColor;
	gxLUVColor = record
		l:						gxColorValue;
		u:						gxColorValue;
		v:						gxColorValue;
	end;

	gxLABColorPtr = ^gxLABColor;
	gxLABColor = record
		l:						gxColorValue;
		a:						gxColorValue;
		b:						gxColorValue;
	end;

	gxYIQColorPtr = ^gxYIQColor;
	gxYIQColor = record
		y:						gxColorValue;
		i:						gxColorValue;
		q:						gxColorValue;
	end;

	gxGrayAColorPtr = ^gxGrayAColor;
	gxGrayAColor = record
		gray:					gxColorValue;
		alpha:					gxColorValue;
	end;

	gxColorIndex						= SInt32;
	gxIndexedColorPtr = ^gxIndexedColor;
	gxIndexedColor = record
		index:					gxColorIndex;
		colorSet:				gxColorSet;
	end;

	gxColorPtr = ^gxColor;
	gxColor = record
		space:					gxColorSpace;
		profile:				gxColorProfile;
		case SInt16 of
		0: (
			cmyk:				gxCMYKColor;
			);
		1: (
			rgb:				gxRGBColor;
			);
		2: (
			rgba:				gxRGBAColor;
			);
		3: (
			hsv:				gxHSVColor;
			);
		4: (
			hls:				gxHLSColor;
			);
		5: (
			xyz:				gxXYZColor;
			);
		6: (
			yxy:				gxYXYColor;
			);
		7: (
			luv:				gxLUVColor;
			);
		8: (
			lab:				gxLABColor;
			);
		9: (
			yiq:				gxYIQColor;
			);
		10: (
			gray:				gxColorValue;
			);
		11: (
			graya:				gxGrayAColor;
			);
		12: (
			pixel16:			UInt16;
			);
		13: (
			pixel32:			UInt32;
			);
		14: (
			indexed:			gxIndexedColor;
			);
		15: (
			component:			array [0..3] of gxColorValue;
			);
	end;


	{	 gxColorSet structures 	}
	gxSetColorPtr = ^gxSetColor;
	gxSetColor = record
		case SInt16 of
		0: (
			cmyk:				gxCMYKColor;
			);
		1: (
			rgb:				gxRGBColor;
			);
		2: (
			rgba:				gxRGBAColor;
			);
		3: (
			hsv:				gxHSVColor;
			);
		4: (
			hls:				gxHLSColor;
			);
		5: (
			xyz:				gxXYZColor;
			);
		6: (
			yxy:				gxYXYColor;
			);
		7: (
			luv:				gxLUVColor;
			);
		8: (
			lab:				gxLABColor;
			);
		9: (
			yiq:				gxYIQColor;
			);
		10: (
			gray:				gxColorValue;
			);
		11: (
			graya:				gxGrayAColor;
			);
		12: (
			pixel16:			UInt16;
			);
		13: (
			pixel32:			UInt32;
			);
		14: (
			component:			array [0..3] of gxColorValue;
			);
	end;

	{	 gxTransform enumerations 	}
	{	 parts of a gxShape considered in hit testing: 	}

const
	gxNoPart					= 0;							{  (in order of evaluation)  }
	gxBoundsPart				= $0001;
	gxGeometryPart				= $0002;
	gxPenPart					= $0004;
	gxCornerPointPart			= $0008;
	gxControlPointPart			= $0010;
	gxEdgePart					= $0020;
	gxJoinPart					= $0040;
	gxStartCapPart				= $0080;
	gxEndCapPart				= $0100;
	gxDashPart					= $0200;
	gxPatternPart				= $0400;
	gxGlyphBoundsPart			= $0040;
	gxGlyphFirstPart			= $0080;
	gxGlyphLastPart				= $0100;
	gxSideBearingPart			= $0200;
	gxAnyPart					= $07FF;


type
	gxShapePart							= SInt32;
	{	 gxTransform structures 	}
	gxHitTestInfoPtr = ^gxHitTestInfo;
	gxHitTestInfo = record
		what:					gxShapePart;							{  which part of gxShape  }
		index:					SInt32;								{  control gxPoint index  }
		distance:				Fixed;									{  how far from gxPoint or outside of area click was  }
																		{  these fields are only set by GXHitTestPicture  }
		which:					gxShape;
		containerPicture:		gxShape;								{  picture which contains gxShape hit  }
		containerIndex:			SInt32;								{  the index within that picture   }
		totalIndex:				SInt32;								{  the total index within the root picture  }
	end;

	{	 gxViewPort enumerations 	}

const
	gxGrayPort					= $0001;
	gxAlwaysGridPort			= $0002;
	gxEnableMatchPort			= $0004;


type
	gxPortAttribute						= SInt32;
	{	 gxViewDevice enumerations 	}

const
	gxDirectDevice				= $01;							{  for the device gxBitmap baseAddr pointer  }
	gxRemoteDevice				= $02;
	gxInactiveDevice			= $04;


type
	gxDeviceAttribute					= SInt32;

const
	gxRoundDot					= 1;
	gxSpiralDot					= 2;
	gxSquareDot					= 3;
	gxLineDot					= 4;
	gxEllipticDot				= 5;
	gxTriangleDot				= 6;
	gxDispersedDot				= 7;
	gxCustomDot					= 8;


type
	gxDotType							= SInt32;
	{	 gxViewPort structures 	}

const
	gxNoTint					= 0;
	gxLuminanceTint				= 1;							{  use the luminance of the gxColor  }
	gxAverageTint				= 2;							{  add all the components and divide by the number of components  }
	gxMixtureTint				= 3;							{  find the closest gxColor on the axis between the foreground and background  }
	gxComponent1Tint			= 4;							{  use the value of the first component of the gxColor  }
	gxComponent2Tint			= 5;							{  ... etc.  }
	gxComponent3Tint			= 6;
	gxComponent4Tint			= 7;


type
	gxTintType							= SInt32;
	gxHalftonePtr = ^gxHalftone;
	gxHalftone = record
		angle:					Fixed;
		frequency:				Fixed;
		method:					gxDotType;
		tinting:				gxTintType;
		dotColor:				gxColor;
		backgroundColor:		gxColor;
		tintSpace:				gxColorSpace;
	end;

	gxHalftoneMatrixPtr = ^gxHalftoneMatrix;
	gxHalftoneMatrix = record
		dpiX:					Fixed;									{  intended resolution  }
		dpiY:					Fixed;
		width:					SInt32;								{  width of matrix (in device pixels)  }
		height:					SInt32;								{  height of matrix (in device pixels)  }
		tileShift:				SInt32;								{  shift amount (in samples) for rectangular tiling  }
		samples:				array [0..0] of UInt16;					{  samples from 0..MAX(halftone tintSpace)  }
	end;

	{	 gxViewGroup enumerations 	}

const
	gxAllViewDevices			= 0;
	gxScreenViewDevices			= 1;

	{	 graphics stream constants and structures 	}
	gxOpenReadSpool				= 1;
	gxOpenWriteSpool			= 2;
	gxReadSpool					= 3;
	gxWriteSpool				= 4;
	gxCloseSpool				= 5;


type
	gxSpoolCommand						= SInt32;
	gxGraphicsOpcode					= SInt8;
	gxSpoolBlockPtr = ^gxSpoolBlock;
{$ifc TYPED_FUNCTION_POINTERS}
	gxSpoolProcPtr = function(command: gxSpoolCommand; block: gxSpoolBlockPtr): SInt32;
{$elsec}
	gxSpoolProcPtr = ProcPtr;
{$endc}

{$ifc OPAQUE_UPP_TYPES}
	gxSpoolUPP = ^SInt32; { an opaque UPP }
{$elsec}
	gxSpoolUPP = UniversalProcPtr;
{$endc}	
	gxSpoolBlock = record
		spoolProcedure:			gxSpoolUPP;								{  these fields are read only  }
		buffer:					Ptr;									{  source/destination pointer to data  }
		bufferSize:				SInt32;								{  how many bytes for the system to read (flatten) / write (unflatten)  }
																		{  these fields are written to (but are not read from)  }
		count:					SInt32;								{  how many bytes for the caller to read (unflatten) /write (flatten)  }
		operationSize:			SInt32;								{  operation size (including operand byte)  }
		operationOffset:		SInt32;								{  the data offset, if any, within the current operation  }
		lastTypeOpcode:			gxGraphicsOpcode;						{  type of last created object  }
		currentOperation:		gxGraphicsOpcode;						{  operation emitted by flatten, or intrepreted by last unflatten  }
		currentOperand:			gxGraphicsOpcode;						{  e.g., gxTransformTypeOpcode, gxInkTagOpcode  }
		compressed:				SInt8;									{  one of: gxTwoBitCompressionValues  }
	end;


const
	uppgxSpoolProcInfo = $000003F1;
{$ifc CALL_NOT_IN_CARBON}
	{
	 *  NewgxSpoolUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        not available
	 *    Mac OS X:         not available
	 	}
function NewgxSpoolUPP(userRoutine: gxSpoolProcPtr): gxSpoolUPP; external name '_NewgxSpoolUPP'; { old name was NewgxSpoolProc }
{
 *  DisposegxSpoolUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
procedure DisposegxSpoolUPP(userUPP: gxSpoolUPP); external name '_DisposegxSpoolUPP';
{
 *  InvokegxSpoolUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        not available
 *    Mac OS X:         not available
 }
function InvokegxSpoolUPP(command: gxSpoolCommand; block: gxSpoolBlockPtr; userRoutine: gxSpoolUPP): SInt32; external name '_InvokegxSpoolUPP'; { old name was CallgxSpoolProc }
{$endc}  {CALL_NOT_IN_CARBON}


const
	gxFontListFlatten			= $01;							{  if set, generate a gxTag containing list of each gxFont referenced  }
	gxFontGlyphsFlatten			= $02;							{  if set, generate a gxTag containing the list of glyphs referenced inside the gxFont  }
	gxFontVariationsFlatten		= $04;							{  if set, append the gxTag with separate [variation] coordinates  }
	gxBitmapAliasFlatten		= $08;							{  if set, open bitmap alias files and flatten out their image data  }


type
	gxFlattenFlag						= SInt32;
	{	 gxGraphicsClient constants 	}

const
	gxGraphicsSystemClient		= -1;

	gxStaticHeapClient			= $0001;


type
	gxClientAttribute					= SInt32;
	{	 graphics patching constants 	}

const
	gxOriginalGraphicsFunction	= -1;
	gxOriginalGraphicsIdentifier = $67726678 (* 'grfx' *);


type
	gxBitmapDataSourceAliasPtr = ^gxBitmapDataSourceAlias;
	gxBitmapDataSourceAlias = record
		fileOffset:				UInt32;									{  file offset (in bytes) of top-left pixel  }
		aliasRecordSize:		UInt32;									{  size of alias record below  }
		aliasRecord:			SInt8;									{  the actual alias record data  }
	end;


const
	gxBitmapFileAliasTagType	= $6266696C (* 'bfil' *);
	gxPICTFileAliasTagType		= $70696374 (* 'pict' *);
	gxBitmapFileAliasImageValue	= 1;


type
	gxFont    = ^SInt32; { an opaque 32-bit type }
	gxFontPtr = ^gxFont;  { when a var xx:gxFont parameter can be nil, it is changed to xx: gxFontPtr }

const
	gxNoPlatform				= 0;
	gxNoScript					= 0;
	gxNoLanguage				= 0;
	gxNoFontName				= 0;
	gxGlyphPlatform				= -1;

	gxUnicodePlatform			= 1;
	gxMacintoshPlatform			= 2;
	gxReservedPlatform			= 3;
	gxMicrosoftPlatform			= 4;
	gxCustomPlatform			= 5;


type
	gxFontPlatform						= SInt32;

const
	gxUnicodeDefaultSemantics	= 1;
	gxUnicodeV1_1Semantics		= 2;
	gxISO10646_1993Semantics	= 3;

	gxRomanScript				= 1;
	gxJapaneseScript			= 2;
	gxTraditionalChineseScript	= 3;
	gxChineseScript				= 3;
	gxKoreanScript				= 4;
	gxArabicScript				= 5;
	gxHebrewScript				= 6;
	gxGreekScript				= 7;
	gxCyrillicScript			= 8;
	gxRussian					= 8;
	gxRSymbolScript				= 9;
	gxDevanagariScript			= 10;
	gxGurmukhiScript			= 11;
	gxGujaratiScript			= 12;
	gxOriyaScript				= 13;
	gxBengaliScript				= 14;
	gxTamilScript				= 15;
	gxTeluguScript				= 16;
	gxKannadaScript				= 17;
	gxMalayalamScript			= 18;
	gxSinhaleseScript			= 19;
	gxBurmeseScript				= 20;
	gxKhmerScript				= 21;
	gxThaiScript				= 22;
	gxLaotianScript				= 23;
	gxGeorgianScript			= 24;
	gxArmenianScript			= 25;
	gxSimpleChineseScript		= 26;
	gxTibetanScript				= 27;
	gxMongolianScript			= 28;
	gxGeezScript				= 29;
	gxEthiopicScript			= 29;
	gxAmharicScript				= 29;
	gxSlavicScript				= 30;
	gxEastEuropeanRomanScript	= 30;
	gxVietnameseScript			= 31;
	gxExtendedArabicScript		= 32;
	gxSindhiScript				= 32;
	gxUninterpretedScript		= 33;

	gxMicrosoftSymbolScript		= 1;
	gxMicrosoftStandardScript	= 2;

	gxCustom8BitScript			= 1;
	gxCustom816BitScript		= 2;
	gxCustom16BitScript			= 3;


type
	gxFontScript						= SInt32;

const
	gxEnglishLanguage			= 1;
	gxFrenchLanguage			= 2;
	gxGermanLanguage			= 3;
	gxItalianLanguage			= 4;
	gxDutchLanguage				= 5;
	gxSwedishLanguage			= 6;
	gxSpanishLanguage			= 7;
	gxDanishLanguage			= 8;
	gxPortugueseLanguage		= 9;
	gxNorwegianLanguage			= 10;
	gxHebrewLanguage			= 11;
	gxJapaneseLanguage			= 12;
	gxArabicLanguage			= 13;
	gxFinnishLanguage			= 14;
	gxGreekLanguage				= 15;
	gxIcelandicLanguage			= 16;
	gxMalteseLanguage			= 17;
	gxTurkishLanguage			= 18;
	gxCroatianLanguage			= 19;
	gxTradChineseLanguage		= 20;
	gxUrduLanguage				= 21;
	gxHindiLanguage				= 22;
	gxThaiLanguage				= 23;
	gxKoreanLanguage			= 24;
	gxLithuanianLanguage		= 25;
	gxPolishLanguage			= 26;
	gxHungarianLanguage			= 27;
	gxEstonianLanguage			= 28;
	gxLettishLanguage			= 29;
	gxLatvianLanguage			= 29;
	gxSaamiskLanguage			= 30;
	gxLappishLanguage			= 30;
	gxFaeroeseLanguage			= 31;
	gxFarsiLanguage				= 32;
	gxPersianLanguage			= 32;
	gxRussianLanguage			= 33;
	gxSimpChineseLanguage		= 34;
	gxFlemishLanguage			= 35;
	gxIrishLanguage				= 36;
	gxAlbanianLanguage			= 37;
	gxRomanianLanguage			= 38;
	gxCzechLanguage				= 39;
	gxSlovakLanguage			= 40;
	gxSlovenianLanguage			= 41;
	gxYiddishLanguage			= 42;
	gxSerbianLanguage			= 43;
	gxMacedonianLanguage		= 44;
	gxBulgarianLanguage			= 45;
	gxUkrainianLanguage			= 46;
	gxByelorussianLanguage		= 47;
	gxUzbekLanguage				= 48;
	gxKazakhLanguage			= 49;
	gxAzerbaijaniLanguage		= 50;
	gxAzerbaijanArLanguage		= 51;
	gxArmenianLanguage			= 52;
	gxGeorgianLanguage			= 53;
	gxMoldavianLanguage			= 54;
	gxKirghizLanguage			= 55;
	gxTajikiLanguage			= 56;
	gxTurkmenLanguage			= 57;
	gxMongolianLanguage			= 58;
	gxMongolianCyrLanguage		= 59;
	gxPashtoLanguage			= 60;
	gxKurdishLanguage			= 61;
	gxKashmiriLanguage			= 62;
	gxSindhiLanguage			= 63;
	gxTibetanLanguage			= 64;
	gxNepaliLanguage			= 65;
	gxSanskritLanguage			= 66;
	gxMarathiLanguage			= 67;
	gxBengaliLanguage			= 68;
	gxAssameseLanguage			= 69;
	gxGujaratiLanguage			= 70;
	gxPunjabiLanguage			= 71;
	gxOriyaLanguage				= 72;
	gxMalayalamLanguage			= 73;
	gxKannadaLanguage			= 74;
	gxTamilLanguage				= 75;
	gxTeluguLanguage			= 76;
	gxSinhaleseLanguage			= 77;
	gxBurmeseLanguage			= 78;
	gxKhmerLanguage				= 79;
	gxLaoLanguage				= 80;
	gxVietnameseLanguage		= 81;
	gxIndonesianLanguage		= 82;
	gxTagalogLanguage			= 83;
	gxMalayRomanLanguage		= 84;
	gxMalayArabicLanguage		= 85;
	gxAmharicLanguage			= 86;
	gxTigrinyaLanguage			= 87;
	gxGallaLanguage				= 88;
	gxOromoLanguage				= 88;
	gxSomaliLanguage			= 89;
	gxSwahiliLanguage			= 90;
	gxRuandaLanguage			= 91;
	gxRundiLanguage				= 92;
	gxChewaLanguage				= 93;
	gxMalagasyLanguage			= 94;
	gxEsperantoLanguage			= 95;
	gxWelshLanguage				= 129;
	gxBasqueLanguage			= 130;
	gxCatalanLanguage			= 131;
	gxLatinLanguage				= 132;
	gxQuechuaLanguage			= 133;
	gxGuaraniLanguage			= 134;
	gxAymaraLanguage			= 135;
	gxTatarLanguage				= 136;
	gxUighurLanguage			= 137;
	gxDzongkhaLanguage			= 138;
	gxJavaneseRomLanguage		= 139;
	gxSundaneseRomLanguage		= 140;


type
	gxFontLanguage						= SInt32;

const
	gxCopyrightFontName			= 1;
	gxFamilyFontName			= 2;
	gxStyleFontName				= 3;
	gxUniqueFontName			= 4;
	gxFullFontName				= 5;
	gxVersionFontName			= 6;
	gxPostscriptFontName		= 7;
	gxTrademarkFontName			= 8;
	gxManufacturerFontName		= 9;
	gxLastReservedFontName		= 256;


type
	gxFontName							= SInt32;
	gxFontTableTag						= SInt32;
	gxFontVariationTag					= SInt32;
	gxFontFormatTag						= SInt32;
	gxFontStorageTag					= SInt32;
	gxFontDescriptorTag					= gxFontVariationTag;
	gxFontVariationPtr = ^gxFontVariation;
	gxFontVariation = record
		name:					gxFontVariationTag;
		value:					Fixed;
	end;

	gxFontDescriptor					= gxFontVariation;
	gxFontDescriptorPtr 				= ^gxFontDescriptor;
	gxFontFeatureSettingPtr = ^gxFontFeatureSetting;
	gxFontFeatureSetting = record
		setting:				UInt16;
		nameID:					UInt16;
	end;


const
	gxSystemFontAttribute		= $0001;
	gxReadOnlyFontAttribute		= $0002;


type
	gxFontAttribute						= SInt32;

const
	gxMutuallyExclusiveFeature	= $00008000;


type
	gxFontFeatureFlag					= SInt32;
	gxFontFeature						= SInt32;

const
	gxResourceFontStorage		= $72737263 (* 'rsrc' *);
	gxHandleFontStorage			= $686E646C (* 'hndl' *);
	gxFileFontStorage			= $62617373 (* 'bass' *);
	gxNfntFontStorage			= $6E666E74 (* 'nfnt' *);


type
	gxFontStorageReference				= Ptr;
	gxGlyphcode							= UInt16;
	{	 single glyph in a font 	}
	{	 byte offset within backing store 	}
	gxByteOffset						= SInt32;
	{	 The actual constants for feature types and selectors have been moved to a library. 	}
	gxRunFeatureType					= UInt16;
	gxRunFeatureSelector				= UInt16;
	{	 If tracking is not desired, specify the following value in the track field in the
	        gxRunControls record (note that a track of 0 does *not* mean to turn tracking off;
	        rather, it means to use normal tracking). 	}

const
	gxNoTracking				= $80000000;

	{	 The special "gxNoStake" value is returned by the GXGetLayoutBreakOffset call to
	        indicate the absence of a character offset that is stable with respect to
	        metamorphosis and contextual kerning. 	}
	gxNoStake					= -1;

	{	 A glyph's behavior with respect to other glyphs on its line is defined in part by its
	        gxBaselineType. These types allow correct alignment of the baselines of all glyphs on
	        the line. 	}
	gxRomanBaseline				= 0;
	gxIdeographicCenterBaseline	= 1;
	gxIdeographicLowBaseline	= 2;
	gxHangingBaseline			= 3;
	gxMathBaseline				= 4;
	gxLastBaseline				= 31;
	gxNumberOfBaselineTypes		= 32;
	gxNoOverrideBaseline		= 255;


type
	gxBaselineType						= UInt32;
	gxBaselineDeltas					= array [0..31] of Fixed;
	{	 gxJustificationPriority defines the point during the justification process at which a
	    glyph will begin to receive deltas before and after itself. 	}

const
	gxKashidaPriority			= 0;
	gxWhiteSpacePriority		= 1;
	gxInterCharPriority			= 2;
	gxNullJustificationPriority	= 3;
	gxNumberOfJustificationPriorities = 4;


type
	gxJustificationPriority				= UInt8;
	{	 gxJustificationFlags are used to control which fields of a gxWidthDeltaRecord are to
	        be overridden and which are not if a gxPriorityJustificationOverride or
	        gxGlyphJustificationOverride (qq.v.) is specified. 	}

const
	gxOverridePriority			= $8000;						{  use priority value from override  }
	gxOverrideLimits			= $4000;						{  use limits values from override  }
	gxOverrideUnlimited			= $2000;						{  use unlimited flag from override  }
	gxUnlimitedGapAbsorption	= $1000;						{  glyph can take unlimited gap  }
	gxJustificationPriorityMask	= $000F;						{  justification priority  }
	gxAllJustificationFlags		= $F00F;


type
	gxJustificationFlags				= UInt16;
	{	 The directional behavior of a glyph can be overridden using a gxDirectionOverride. 	}

const
	gxNoDirectionOverride		= 0;
	gxImposeLeftToRight			= 1;
	gxImposeRightToLeft			= 2;
	gxImposeArabic				= 3;


type
	gxDirectionOverride					= UInt16;
	{	 gxRunControlFlags describe the nonparametric layout options contained in a gxStyle. 	}

const
	gxNoCaretAngle				= $40000000;
	gxImposeWidth				= $20000000;
	gxNoCrossKerning			= $10000000;
	gxNoOpticalAlignment		= $08000000;
	gxForceHanging				= $04000000;
	gxNoSpecialJustification	= $02000000;
	gxDirectionOverrideMask		= $00000003;
	gxNoLigatureSplits			= $80000000;

	gxAllRunControlFlags		= $FE000003;


type
	gxRunControlFlags					= UInt32;
	{	 gxHighlightType is used to distinguish various highlighting methods, both in terms of
	        character offset based vs. visual based, and in terms of angled sides vs. non-angled
	        sides. 	}

const
	gxHighlightStraight			= 0;							{  straight-edged simple highlighting  }
	gxHighlightAverageAngle		= 1;							{  takes average of two edge angles  }


type
	gxHighlightType						= UInt32;
	{	 gxCaretType is used to control whether the caret that is returned from GXGetLayoutCaret
	        is a split caret or a (keyboard-syncronized) single caret. 	}

const
	gxSplitCaretType			= 0;							{  returns Mac-style split caret (default)  }
	gxLeftRightKeyboardCaret	= 1;							{  single caret in left-right position  }
	gxRightLeftKeyboardCaret	= 2;							{  single caret in right-left position  }


type
	gxCaretType							= UInt32;
	{	 gxLayoutOffsetState describes the characteristics of a given gxByteOffset in some
	        layout. It is returned by the GXGetOffsetGlyphs call. Note that the
	        gxOffsetInsideLigature value is returned in addition to the 8/16 (or invalid)
	        indication. 	}

const
	gxOffset8_8					= 0;
	gxOffset8_16				= 1;
	gxOffset16_8				= 2;
	gxOffset16_16				= 3;
	gxOffsetInvalid				= 4;

	gxOffsetInsideLigature		= $8000;


type
	gxLayoutOffsetState					= UInt16;
	{	 gxLayoutOptionsFlags are single-bit flags contained in a gxLayoutOptions record. We
	    also define here some utility constants that are useful in setting various fields in
	    the gxLayoutOptions record. 	}

const
	gxNoLayoutOptions			= 0;
	gxLineIsDisplayOnly			= $00000001;
	gxKeepSpacesInMargin		= $00000002;
	gxLimitReorderingToTwoLevels = $00000004;
	gxLineLeftEdgeNotAtMargin	= $00000008;
	gxLineRightEdgeNotAtMargin	= $00000010;
	gxAllLayoutOptionsFlags		= $0000001F;
	gxMaxRunLevel				= 15;
	gxFlushLeft					= 0;
	gxFlushCenter				= $20000000;
	gxFlushRight				= $40000000;
	gxNoJustification			= 0;
	gxFullJustification			= $40000000;


type
	gxLayoutOptionsFlags				= UInt32;
	{	 A gxRunFeature describes a feature and a level for that feature. 	}
	gxRunFeaturePtr = ^gxRunFeature;
	gxRunFeature = record
		featureType:			gxRunFeatureType;
		featureSelector:		gxRunFeatureSelector;
	end;

	{	 A gxWidthDeltaRecord contains all of the information needed to describe the behavior of one
	        class of glyphs during the justification process. 	}
	gxWidthDeltaRecordPtr = ^gxWidthDeltaRecord;
	gxWidthDeltaRecord = record
		beforeGrowLimit:		Fixed;									{  ems AW can grow by at most on LT  }
		beforeShrinkLimit:		Fixed;									{  ems AW can shrink by at most on LT  }
		afterGrowLimit:			Fixed;									{  ems AW can grow by at most on RB  }
		afterShrinkLimit:		Fixed;									{  ems AW can shrink by at most on RB  }
		growFlags:				gxJustificationFlags;					{  flags controlling grow case  }
		shrinkFlags:			gxJustificationFlags;					{  flags controlling shrink case  }
	end;

	{	 A gxPriorityJustificationOverride contains an array of WidthDeltaRecords, one for each
	        gxJustificationPriority. 	}
	gxPriorityJustificationOverridePtr = ^gxPriorityJustificationOverride;
	gxPriorityJustificationOverride = record
		deltas:					array [0..3] of gxWidthDeltaRecord;		{  overrides for each of the priorities  }
	end;

	{	 A gxGlyphJustificationOverride contains a gxWidthDeltaRecord that is to be used for a
	        specific glyph in a specific run (this limitation is because glyphcodes vary by font). 	}
	gxGlyphJustificationOverridePtr = ^gxGlyphJustificationOverride;
	gxGlyphJustificationOverride = record
		glyph:					gxGlyphcode;
		override:				gxWidthDeltaRecord;
	end;


	{	 gxRunControls contains flags, shifts, imposed widths and overrides for a run. 	}
	{	 NOTE: a value of "gxNoTracking" (see above) in track disables tracking 	}
	gxRunControlsPtr = ^gxRunControls;
	gxRunControls = record
		flags:					gxRunControlFlags;
		beforeWithStreamShift:	Fixed;
		afterWithStreamShift:	Fixed;
		crossStreamShift:		Fixed;
		imposedWidth:			Fixed;
		track:					Fixed;
		hangingInhibitFactor:	Fract;
		kerningInhibitFactor:	Fract;
		decompositionAdjustmentFactor: Fixed;
		baselineType:			gxBaselineType;
	end;

	{	 A gxGlyphSubstitution describes one client-provided substitution that occurs after all
	        other automatic glyph changes have happened. 	}
	gxGlyphSubstitutionPtr = ^gxGlyphSubstitution;
	gxGlyphSubstitution = record
		originalGlyph:			gxGlyphcode;							{  Whenever you see this glyph...  }
		substituteGlyph:		gxGlyphcode;							{  ...change it to this one.  }
	end;

	{	 gxKerningAdjustmentFactors specify an adjustment to automatic kerning. The adjustment
	        is ax + b where x is the automatic kerning value, a is scaleFactor, and b is
	        adjustmentPointSizeFactor times the run's point size. 	}
	gxKerningAdjustmentFactorsPtr = ^gxKerningAdjustmentFactors;
	gxKerningAdjustmentFactors = record
		scaleFactor:			Fract;
		adjustmentPointSizeFactor: Fixed;
	end;

	{	 A gxKerningAdjustment identifies with- and cross-stream kerning adjustments
	        for specific glyph pairs. 	}
	gxKerningAdjustmentPtr = ^gxKerningAdjustment;
	gxKerningAdjustment = record
		firstGlyph:				gxGlyphcode;
		secondGlyph:			gxGlyphcode;
		withStreamFactors:		gxKerningAdjustmentFactors;
		crossStreamFactors:		gxKerningAdjustmentFactors;
	end;

	{	 A value of gxResetCrossStreamFactor in crossStreamFactors.adjustmentPointSizeFactor
	        will reset the cross-stream kerning to the baseline. 	}

const
	gxResetCrossStreamFactor	= $80000000;

	{	 gxLayoutHitInfo contains the output from the GXHitTestLayout call. 	}

type
	gxLayoutHitInfoPtr = ^gxLayoutHitInfo;
	gxLayoutHitInfo = record
		firstPartialDist:		Fixed;
		lastPartialDist:		Fixed;
		hitSideOffset:			gxByteOffset;
		nonHitSideOffset:		gxByteOffset;
		leadingEdge:			boolean;
		inLoose:				boolean;
	end;

	{	 A gxLineBaselineRecord contains the deltas from 0 to all the different baselines for
	        the layout. It can be filled via a call to GetBaselineDeltas (q.v.). 	}
	gxLineBaselineRecordPtr = ^gxLineBaselineRecord;
	gxLineBaselineRecord = record
		deltas:					gxBaselineDeltas;
	end;

	{	 The gxLayoutOptions type contains information about the layout characteristics of the
	        whole line. 	}
	gxLayoutOptionsPtr = ^gxLayoutOptions;
	gxLayoutOptions = record
		width:					Fixed;
		flush:					Fract;
		just:					Fract;
		flags:					gxLayoutOptionsFlags;
		baselineRec:			gxLineBaselineRecordPtr;
	end;


const
	gxNewObjectOpcode			= $00;							{  create new object  }
	gxSetDataOpcode				= $40;							{  add reference to current object  }
	gxSetDefaultOpcode			= $80;							{  replace current default with this object  }
	gxReservedOpcode			= $C0;							{  (may be used in future expansion)  }
	gxNextOpcode				= $FF;							{  used by currentOperand field to say opcode is coming  }

	{	 new object types (new object opcode) 	}
	gxHeaderTypeOpcode			= $00;							{  byte following new object uses bottom 6 bits for type  }
																{  gxShape types use values 1 (gxEmptyType) through 13 (gxPictureType)  }
	gxStyleTypeOpcode			= $28;
	gxInkTypeOpcode				= $29;
	gxTransformTypeOpcode		= $2A;
	gxColorProfileTypeOpcode	= $2B;
	gxColorSetTypeOpcode		= $2C;
	gxTagTypeOpcode				= $2D;
	gxBitImageOpcode			= $2E;
	gxFontNameTypeOpcode		= $2F;
	gxTrailerTypeOpcode			= $3F;

	{	 fields of objects (set data opcodes) 	}
	gxShapeAttributesOpcode		= 0;
	gxShapeTagOpcode			= 1;
	gxShapeFillOpcode			= 2;

	gxOmitPathPositionXMask		= $C0;
	gxOmitPathPositionYMask		= $30;
	gxOmitPathDeltaXMask		= $0C;
	gxOmitPathDeltaYMask		= $03;

	gxOmitPathPositionXShift	= 6;
	gxOmitPathPositionYShift	= 4;
	gxOmitPathDeltaXShift		= 2;
	gxOmitPathDeltaYShift		= 0;

	gxOmitBitmapImageMask		= $C0;
	gxOmitBitmapWidthMask		= $30;
	gxOmitBitmapHeightMask		= $0C;
	gxOmitBitmapRowBytesMask	= $03;

	gxOmitBitmapImageShift		= 6;
	gxOmitBitmapWidthShift		= 4;
	gxOmitBitmapHeightShift		= 2;
	gxOmitBitmapRowBytesShift	= 0;

	gxOmitBitmapPixelSizeMask	= $C0;
	gxOmitBitmapSpaceMask		= $30;
	gxOmitBitmapSetMask			= $0C;
	gxOmitBitmapProfileMask		= $03;

	gxOmitBitmapPixelSizeShift	= 6;
	gxOmitBitmapSpaceShift		= 4;
	gxOmitBitmapSetShift		= 2;
	gxOmitBitmapProfileShift	= 0;

	gxOmitBitmapPositionXMask	= $C0;
	gxOmitBitmapPositionYMask	= $30;

	gxOmitBitmapPositionXShift	= 6;
	gxOmitBitmapPositionYShift	= 4;

	gxOmitBitImageRowBytesMask	= $C0;
	gxOmitBitImageHeightMask	= $30;
	gxOmitBitImageDataMask		= $08;

	gxOmitBitImageRowBytesShift	= 6;
	gxOmitBitImageHeightShift	= 4;
	gxOmitBitImageDataShift		= 3;

	gxCopyBitImageBytesOpcode	= $00;
	gxRepeatBitImageBytesOpcode	= $40;
	gxLookupBitImageBytesOpcode	= $80;
	gxRepeatBitImageScanOpcode	= $C0;

	gxOmitTextCharactersMask	= $C0;
	gxOmitTextPositionXMask		= $30;
	gxOmitTextPositionYMask		= $0C;
	gxOmitTextDataMask			= $02;

	gxOmitTextCharactersShift	= 6;
	gxOmitTextPositionXShift	= 4;
	gxOmitTextPositionYShift	= 2;
	gxOmitTextDataShift			= 1;

	gxOmitGlyphCharactersMask	= $C0;
	gxOmitGlyphLengthMask		= $30;
	gxOmitGlyphRunNumberMask	= $0C;
	gxOmitGlyphOnePositionMask	= $02;
	gxOmitGlyphDataMask			= $01;

	gxOmitGlyphCharactersShift	= 6;
	gxOmitGlyphLengthShift		= 4;
	gxOmitGlyphRunNumberShift	= 2;
	gxOmitGlyphOnePositionShift	= 1;
	gxOmitGlyphDataShift		= 0;

	gxOmitGlyphPositionsMask	= $C0;
	gxOmitGlyphAdvancesMask		= $20;
	gxOmitGlyphTangentsMask		= $18;
	gxOmitGlyphRunsMask			= $04;
	gxOmitGlyphStylesMask		= $03;

	gxOmitGlyphPositionsShift	= 6;
	gxOmitGlyphAdvancesShift	= 5;
	gxOmitGlyphTangentsShift	= 3;
	gxOmitGlyphRunsShift		= 2;
	gxOmitGlyphStylesShift		= 0;

	gxOmitLayoutLengthMask		= $C0;
	gxOmitLayoutPositionXMask	= $30;
	gxOmitLayoutPositionYMask	= $0C;
	gxOmitLayoutDataMask		= $02;

	gxOmitLayoutLengthShift		= 6;
	gxOmitLayoutPositionXShift	= 4;
	gxOmitLayoutPositionYShift	= 2;
	gxOmitLayoutDataShift		= 1;

	gxOmitLayoutWidthMask		= $C0;
	gxOmitLayoutFlushMask		= $30;
	gxOmitLayoutJustMask		= $0C;
	gxOmitLayoutOptionsMask		= $03;

	gxOmitLayoutWidthShift		= 6;
	gxOmitLayoutFlushShift		= 4;
	gxOmitLayoutJustShift		= 2;
	gxOmitLayoutOptionsShift	= 0;

	gxOmitLayoutStyleRunNumberMask = $C0;
	gxOmitLayoutLevelRunNumberMask = $30;
	gxOmitLayoutHasBaselineMask	= $08;
	gxOmitLayoutStyleRunsMask	= $04;
	gxOmitLayoutStylesMask		= $03;

	gxOmitLayoutStyleRunNumberShift = 6;
	gxOmitLayoutLevelRunNumberShift = 4;
	gxOmitLayoutHasBaselineShift = 3;
	gxOmitLayoutStyleRunsShift	= 2;
	gxOmitLayoutStylesShift		= 0;

	gxOmitLayoutLevelRunsMask	= $80;
	gxOmitLayoutLevelsMask		= $40;

	gxOmitLayoutLevelRunsShift	= 7;
	gxOmitLayoutLevelsShift		= 6;

	gxInkAttributesOpcode		= 0;
	gxInkTagOpcode				= 1;
	gxInkColorOpcode			= 2;
	gxInkTransferModeOpcode		= 3;

	gxOmitColorsSpaceMask		= $C0;
	gxOmitColorsProfileMask		= $30;
	gxOmitColorsComponentsMask	= $0F;
	gxOmitColorsIndexMask		= $0C;
	gxOmitColorsIndexSetMask	= $03;

	gxOmitColorsSpaceShift		= 6;
	gxOmitColorsProfileShift	= 4;
	gxOmitColorsComponentsShift	= 0;
	gxOmitColorsIndexShift		= 2;
	gxOmitColorsIndexSetShift	= 0;

	gxOmitTransferSpaceMask		= $C0;
	gxOmitTransferSetMask		= $30;
	gxOmitTransferProfileMask	= $0C;

	gxOmitTransferSpaceShift	= 6;
	gxOmitTransferSetShift		= 4;
	gxOmitTransferProfileShift	= 2;

	gxOmitTransferSourceMatrixMask = $C0;
	gxOmitTransferDeviceMatrixMask = $30;
	gxOmitTransferResultMatrixMask = $0C;
	gxOmitTransferFlagsMask		= $03;

	gxOmitTransferSourceMatrixShift = 6;
	gxOmitTransferDeviceMatrixShift = 4;
	gxOmitTransferResultMatrixShift = 2;
	gxOmitTransferFlagsShift	= 0;

	gxOmitTransferComponentModeMask = $80;
	gxOmitTransferComponentFlagsMask = $40;
	gxOmitTransferComponentSourceMinimumMask = $30;
	gxOmitTransferComponentSourceMaximumMask = $0C;
	gxOmitTransferComponentDeviceMinimumMask = $03;

	gxOmitTransferComponentModeShift = 7;
	gxOmitTransferComponentFlagsShift = 6;
	gxOmitTransferComponentSourceMinimumShift = 4;
	gxOmitTransferComponentSourceMaximumShift = 2;
	gxOmitTransferComponentDeviceMinimumShift = 0;

	gxOmitTransferComponentDeviceMaximumMask = $C0;
	gxOmitTransferComponentClampMinimumMask = $30;
	gxOmitTransferComponentClampMaximumMask = $0C;
	gxOmitTransferComponentOperandMask = $03;

	gxOmitTransferComponentDeviceMaximumShift = 6;
	gxOmitTransferComponentClampMinimumShift = 4;
	gxOmitTransferComponentClampMaximumShift = 2;
	gxOmitTransferComponentOperandShift = 0;

	gxStyleAttributesOpcode		= 0;
	gxStyleTagOpcode			= 1;
	gxStyleCurveErrorOpcode		= 2;
	gxStylePenOpcode			= 3;
	gxStyleJoinOpcode			= 4;
	gxStyleDashOpcode			= 5;
	gxStyleCapsOpcode			= 6;
	gxStylePatternOpcode		= 7;
	gxStyleTextAttributesOpcode	= 8;
	gxStyleTextSizeOpcode		= 9;
	gxStyleFontOpcode			= 10;
	gxStyleTextFaceOpcode		= 11;
	gxStylePlatformOpcode		= 12;
	gxStyleFontVariationsOpcode	= 13;
	gxStyleRunControlsOpcode	= 14;
	gxStyleRunPriorityJustOverrideOpcode = 15;
	gxStyleRunGlyphJustOverridesOpcode = 16;
	gxStyleRunGlyphSubstitutionsOpcode = 17;
	gxStyleRunFeaturesOpcode	= 18;
	gxStyleRunKerningAdjustmentsOpcode = 19;
	gxStyleJustificationOpcode	= 20;

	gxOmitDashAttributesMask	= $C0;
	gxOmitDashShapeMask			= $30;
	gxOmitDashAdvanceMask		= $0C;
	gxOmitDashPhaseMask			= $03;

	gxOmitDashAttributesShift	= 6;
	gxOmitDashShapeShift		= 4;
	gxOmitDashAdvanceShift		= 2;
	gxOmitDashPhaseShift		= 0;

	gxOmitDashScaleMask			= $C0;

	gxOmitDashScaleShift		= 6;

	gxOmitPatternAttributesMask	= $C0;
	gxOmitPatternShapeMask		= $30;
	gxOmitPatternUXMask			= $0C;
	gxOmitPatternUYMask			= $03;

	gxOmitPatternAttributesShift = 6;
	gxOmitPatternShapeShift		= 4;
	gxOmitPatternUXShift		= 2;
	gxOmitPatternUYShift		= 0;

	gxOmitPatternVXMask			= $C0;
	gxOmitPatternVYMask			= $30;

	gxOmitPatternVXShift		= 6;
	gxOmitPatternVYShift		= 4;

	gxOmitJoinAttributesMask	= $C0;
	gxOmitJoinShapeMask			= $30;
	gxOmitJoinMiterMask			= $0C;

	gxOmitJoinAttributesShift	= 6;
	gxOmitJoinShapeShift		= 4;
	gxOmitJoinMiterShift		= 2;

	gxOmitCapAttributesMask		= $C0;
	gxOmitCapStartShapeMask		= $30;
	gxOmitCapEndShapeMask		= $0C;

	gxOmitCapAttributesShift	= 6;
	gxOmitCapStartShapeShift	= 4;
	gxOmitCapEndShapeShift		= 2;

	gxOmitFaceLayersMask		= $C0;
	gxOmitFaceMappingMask		= $30;

	gxOmitFaceLayersShift		= 6;
	gxOmitFaceMappingShift		= 4;

	gxOmitFaceLayerFillMask		= $C0;
	gxOmitFaceLayerFlagsMask	= $30;
	gxOmitFaceLayerStyleMask	= $0C;
	gxOmitFaceLayerTransformMask = $03;

	gxOmitFaceLayerFillShift	= 6;
	gxOmitFaceLayerFlagsShift	= 4;
	gxOmitFaceLayerStyleShift	= 2;
	gxOmitFaceLayerTransformShift = 0;

	gxOmitFaceLayerBoldXMask	= $C0;
	gxOmitFaceLayerBoldYMask	= $30;

	gxOmitFaceLayerBoldXShift	= 6;
	gxOmitFaceLayerBoldYShift	= 4;

	gxColorSetReservedOpcode	= 0;
	gxColorSetTagOpcode			= 1;

	gxColorProfileReservedOpcode = 0;
	gxColorProfileTagOpcode		= 1;

	gxTransformReservedOpcode	= 0;
	gxTransformTagOpcode		= 1;
	gxTransformClipOpcode		= 2;
	gxTransformMappingOpcode	= 3;
	gxTransformPartMaskOpcode	= 4;
	gxTransformToleranceOpcode	= 5;

	gxTypeOpcode				= 0;
	gxSizeOpcode				= 1;

	{	 used by currentOperand when currentOperation is gxNextOpcode 	}
	{	    format of top byte:
	xx yyyyyy   xx == 0x00, 0x40, 0x80, 0xC0: defines graphics operation (see gxGraphicsOperationOpcode)
	            yyyyyy == size of operation in bytes
	            if (yyyyyy == 0), byte size follows. If byte following == 0, word size follows; if == 0, long follows
	            word and long, if present, are specified in high-endian order (first byte is largest magnitude)
	            
	format of byte following size specifiers, if any:
	xx yyyyyy   xx == 0x00, 0x40, 0x80, 0xC0: defines compression level (0 == none, 0xC0 == most)
	            exact method of compression is defined by type of data
	            yyyyyy == data type selector (0 to 63): see gxGraphicsNewOpcode, __DataOpcode
		}
	gxOpcodeShift				= 6;
	gxObjectSizeMask			= $3F;
	gxCompressionShift			= 6;
	gxObjectTypeMask			= $3F;
	gxBitImageOpcodeMask		= $C0;
	gxBitImageCountMask			= $3F;
	gxBitImageOpcodeShift		= 6;

	gxNoCompression				= 0;
	gxWordCompression			= 1;
	gxByteCompression			= 2;
	gxOmitCompression			= 3;
	gxCompressionMask			= $03;

	{	    the following structures define how primitives without a public geometry
	    are stored (their format mirrors that of the New call to create them)   	}

type
	gxFlatFontNamePtr = ^gxFlatFontName;
	gxFlatFontName = record
		name:					SInt8;									{  gxFontName  }
		platform:				SInt8;									{  gxFontPlatform  }
		script:					SInt8;									{  gxFontScript  }
		language:				SInt8;									{  gxFontLanguage  }
		length:					SInt16;								{  byte length  }
	end;


const
	gxFlatFontListItemTag		= $666C7374 (* 'flst' *);


type
	gxFlatFontListItemPtr = ^gxFlatFontListItem;
	gxFlatFontListItem = record
		fontID:					gxFont;									{ ** if we get rid of this, remove #include "font types.h", above  }
		name:					SInt8;									{  gxFontName  }
		platform:				SInt8;									{  gxFontPlatform  }
		script:					SInt8;									{  gxFontScript  }
		language:				SInt8;									{  gxFontLanguage  }
		length:					SInt16;								{  byte length of the name that follows  }
		glyphCount:				UInt16;									{  CountFontGlyphs or 0 if gxFontGlyphsFlatten is false  }
		axisCount:				UInt16;									{  CountFontVariations or 0 if gxFontVariationsFlatten is false  }
		variationCount:			UInt16;									{  number of bitsVariationPairs that follow the (optional) glyphBits  }
	end;

	gxFlatFontListPtr = ^gxFlatFontList;
	gxFlatFontList = record
		count:					SInt32;
		items:					array [0..0] of gxFlatFontListItem;
	end;

	gxFlattenHeaderPtr = ^gxFlattenHeader;
	gxFlattenHeader = record
		version:				Fixed;
		flatFlags:				SInt8;
		padding:				SInt8;
	end;


const
	gxOmitPictureShapeMask		= $C0;
	gxOmitOverrideStyleMask		= $30;
	gxOmitOverrideInkMask		= $0C;
	gxOmitOverrideTransformMask	= $03;

	gxOmitPictureShapeShift		= $06;
	gxOmitOverrideStyleShift	= $04;
	gxOmitOverrideInkShift		= $02;
	gxOmitOverrideTransformShift = $00;

	gxPostScriptTag				= $706F7374 (* 'post' *);
	gxPostControlTag			= $70736374 (* 'psct' *);

	gxNoSave					= 1;							{  don't do save-restore around PS data  }
	gxPSContinueNext			= 2;							{  next shape is continuation of this shape's PS -- only obeyed if gxNoSave is true  }


type
	gxPostControlPtr = ^gxPostControl;
	gxPostControl = record
		flags:					SInt32;								{  PostScript state flags  }
	end;


const
	gxDashSynonymTag			= $73647368 (* 'sdsh' *);


type
	gxDashSynonymPtr = ^gxDashSynonym;
	gxDashSynonym = record
		size:					SInt32;								{  number of elements in array  }
		dashLength:				array [0..0] of Fixed;					{  Array of dash lengths  }
	end;


const
	gxLineCapSynonymTag			= $6C636170 (* 'lcap' *);

	gxButtCap					= 0;
	gxRoundCap					= 1;
	gxSquareCap					= 2;
	gxTriangleCap				= 3;

	{	 gxLine cap type 	}

type
	gxLineCapSynonym					= SInt32;

const
	gxCubicSynonymTag			= $63756278 (* 'cubx' *);

	gxIgnoreFlag				= $0000;						{  Ignore this word, get next one  }
	gxLineToFlag				= $0001;						{  Draw a gxLine to gxPoint following this flag  }
	gxCurveToFlag				= $0002;						{  Draw a gxCurve through the 3 points following this flag  }
	gxMoveToFlag				= $0003;						{  Start a new contour at the gxPoint following this flag  }
	gxClosePathFlag				= $0004;						{  Close the contour  }


type
	gxCubicSynonym						= SInt32;

const
	gxCubicInstructionMask		= $000F;						{  low four bits are gxPoint instructions  }

	{	 Low four bits are instruction (moveto, lineto, curveto, closepath) 	}

type
	gxCubicSynonymFlags					= SInt16;

const
	gxPatternSynonymTag			= $7074726E (* 'ptrn' *);

	gxHatch						= 0;
	gxCrossHatch				= 1;


type
	gxPatternSynonymPtr = ^gxPatternSynonym;
	gxPatternSynonym = record
		patternType:			SInt32;								{  one of the gxPatterns: gxHatch or gxCrossHatch  }
		angle:					Fixed;									{  angle at which pattern is drawn  }
		spacing:				Fixed;									{  distance between two parallel pattern lines  }
		thickness:				Fixed;									{  thickness of the pattern  }
		anchorPoint:			gxPoint;								{  gxPoint with with respect to which pattern position is calculated  }
	end;


const
	gxURLTag					= $75726C74 (* 'urlt' *);

{$ALIGN MAC68K}


{unit GestaltEqu}
{
     File:       GestaltEqu.p
 
     Contains:   Gestalt Interfaces.
 
     Version:    Technology: Mac OS 9.1
                 Release:    Universal Interfaces 3.4.2
 
     Copyright:   1988-2002 by Apple Computer, Inc.  All rights reserved
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}




{$ALIGN MAC68K}


type
{$ifc TYPED_FUNCTION_POINTERS}
	SelectorFunctionProcPtr = function(selector: OSType; var response: SInt32): OSErr;
{$elsec}
	SelectorFunctionProcPtr = ProcPtr;
{$endc}

{$ifc OPAQUE_UPP_TYPES}
	SelectorFunctionUPP = ^SInt32; { an opaque UPP }
{$elsec}
	SelectorFunctionUPP = UniversalProcPtr;
{$endc}	
	{
	 *  Gestalt()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 and later
	 	}
function Gestalt(selector: OSType; var response: SInt32): OSErr; external name '_Gestalt';
{
 *  ReplaceGestalt()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function ReplaceGestalt(selector: OSType; gestaltFunction: SelectorFunctionUPP; var oldGestaltFunction: SelectorFunctionUPP): OSErr; external name '_ReplaceGestalt';
{
 *  NewGestalt()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.1 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function NewGestalt(selector: OSType; gestaltFunction: SelectorFunctionUPP): OSErr; external name '_NewGestalt';
{   The GestaltValue functions are available in System 7.5 and later }

{
 *  NewGestaltValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function NewGestaltValue(selector: OSType; newValue: SInt32): OSErr; external name '_NewGestaltValue';
{
 *  ReplaceGestaltValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function ReplaceGestaltValue(selector: OSType; replacementValue: SInt32): OSErr; external name '_ReplaceGestaltValue';
{
 *  SetGestaltValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function SetGestaltValue(selector: OSType; newValue: SInt32): OSErr; external name '_SetGestaltValue';
{
 *  DeleteGestaltValue()
 *  
 *  Availability:
 *    Non-Carbon CFM:   in InterfaceLib 7.5 and later
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function DeleteGestaltValue(selector: OSType): OSErr; external name '_DeleteGestaltValue';
const
	uppSelectorFunctionProcInfo = $000003E0;
	{
	 *  NewSelectorFunctionUPP()
	 *  
	 *  Availability:
	 *    Non-Carbon CFM:   available as macro/inline
	 *    CarbonLib:        in CarbonLib 1.0 and later
	 *    Mac OS X:         in version 10.0 and later
	 	}
function NewSelectorFunctionUPP(userRoutine: SelectorFunctionProcPtr): SelectorFunctionUPP; external name '_NewSelectorFunctionUPP'; { old name was NewSelectorFunctionProc }
{
 *  DisposeSelectorFunctionUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
procedure DisposeSelectorFunctionUPP(userUPP: SelectorFunctionUPP); external name '_DisposeSelectorFunctionUPP';
{
 *  InvokeSelectorFunctionUPP()
 *  
 *  Availability:
 *    Non-Carbon CFM:   available as macro/inline
 *    CarbonLib:        in CarbonLib 1.0 and later
 *    Mac OS X:         in version 10.0 and later
 }
function InvokeSelectorFunctionUPP(selector: OSType; var response: SInt32; userRoutine: SelectorFunctionUPP): OSErr; external name '_InvokeSelectorFunctionUPP'; { old name was CallSelectorFunctionProc }
{ Environment Selectors }

const
	gestaltAddressingModeAttr	= $61646472 (* 'addr' *);						{  addressing mode attributes  }
	gestalt32BitAddressing		= 0;							{  using 32-bit addressing mode  }
	gestalt32BitSysZone			= 1;							{  32-bit compatible system zone  }
	gestalt32BitCapable			= 2;							{  Machine is 32-bit capable  }

	gestaltAFPClient			= $61667073 (* 'afps' *);
	gestaltAFPClientVersionMask	= $0000FFFF;					{  low word of long is the  }
																{  client version 0x0001 -> 0x0007 }
	gestaltAFPClient3_5			= $0001;
	gestaltAFPClient3_6			= $0002;
	gestaltAFPClient3_6_1		= $0003;
	gestaltAFPClient3_6_2		= $0004;
	gestaltAFPClient3_6_3		= $0005;						{  including 3.6.4, 3.6.5 }
	gestaltAFPClient3_7			= $0006;						{  including 3.7.1 }
	gestaltAFPClient3_7_2		= $0007;						{  including 3.7.3, 3.7.4 }
	gestaltAFPClient3_8			= $0008;
	gestaltAFPClient3_8_1		= $0009;						{  including 3.8.2  }
	gestaltAFPClient3_8_3		= $000A;
	gestaltAFPClient3_8_4		= $000B;						{  including 3.8.5, 3.8.6  }
	gestaltAFPClientAttributeMask = $FFFF0000;					{  high word of long is a  }
																{  set of attribute bits }
	gestaltAFPClientCfgRsrc		= 16;							{  Client uses config resources }
	gestaltAFPClientSupportsIP	= 29;							{  Client supports AFP over TCP/IP }
	gestaltAFPClientVMUI		= 30;							{  Client can put up UI from the PBVolMount trap }
	gestaltAFPClientMultiReq	= 31;							{  Client supports multiple outstanding requests }


	gestaltAliasMgrAttr			= $616C6973 (* 'alis' *);						{  Alias Mgr Attributes  }
	gestaltAliasMgrPresent		= 0;							{  True if the Alias Mgr is present  }
	gestaltAliasMgrSupportsRemoteAppletalk = 1;					{  True if the Alias Mgr knows about Remote Appletalk  }
	gestaltAliasMgrSupportsAOCEKeychain = 2;					{  True if the Alias Mgr knows about the AOCE Keychain  }
	gestaltAliasMgrResolveAliasFileWithMountOptions = 3;		{  True if the Alias Mgr implements gestaltAliasMgrResolveAliasFileWithMountOptions() and IsAliasFile()  }
	gestaltAliasMgrFollowsAliasesWhenResolving = 4;
	gestaltAliasMgrSupportsExtendedCalls = 5;
	gestaltAliasMgrSupportsFSCalls = 6;							{  true if Alias Mgr supports HFS+ Calls  }

	{	 Gestalt selector and values for the Appearance Manager 	}
	gestaltAppearanceAttr		= $61707072 (* 'appr' *);
	gestaltAppearanceExists		= 0;
	gestaltAppearanceCompatMode	= 1;

	{	 Gestalt selector for determining Appearance Manager version   	}
	{	 If this selector does not exist, but gestaltAppearanceAttr    	}
	{	 does, it indicates that the 1.0 version is installed. This    	}
	{	 gestalt returns a BCD number representing the version of the  	}
	{	 Appearance Manager that is currently running, e.g. 0x0101 for 	}
	{	 version 1.0.1.                                                	}
	gestaltAppearanceVersion	= $61707672 (* 'apvr' *);

	gestaltArbitorAttr			= $61726220 (* 'arb ' *);
	gestaltSerialArbitrationExists = 0;							{  this bit if the serial port arbitrator exists }

	gestaltAppleScriptVersion	= $61736376 (* 'ascv' *);						{  AppleScript version }

	gestaltAppleScriptAttr		= $61736372 (* 'ascr' *);						{  AppleScript attributes }
	gestaltAppleScriptPresent	= 0;
	gestaltAppleScriptPowerPCSupport = 1;

	gestaltATAAttr				= $61746120 (* 'ata ' *);						{  ATA is the driver to support IDE hard disks  }
	gestaltATAPresent			= 0;							{  if set, ATA Manager is present  }

	gestaltATalkVersion			= $61746B76 (* 'atkv' *);						{  Detailed AppleTalk version; see comment above for format  }

	gestaltAppleTalkVersion		= $61746C6B (* 'atlk' *);						{  appletalk version  }

	{	
	    FORMAT of gestaltATalkVersion RESPONSE
	    --------------------------------------
	    The version is stored in the high three bytes of the response value.  Let us number
	    the bytes in the response value from 0 to 3, where 0 is the least-significant byte.
	
	        Byte#:     3 2 1 0
	        Value:  0xMMNNRR00
	
	    Byte 3 (MM) contains the major revision number, byte 2 (NN) contains the minor
	    revision number, and byte 1 (RR) contains a constant that represents the release
	    stage.  Byte 0 always contains 0x00.  The constants for the release stages are:
	
	        development = 0x20
	        alpha       = 0x40
	        beta        = 0x60
	        final       = 0x80
	        release     = 0x80
	
	    For example, if you call Gestalt with the 'atkv' selector when AppleTalk version 57
	    is loaded, you receive the long SInt16 response value 0x39008000.
		}
	gestaltAUXVersion			= $612F7578 (* 'a/ux' *);						{  a/ux version, if present  }

	gestaltMacOSCompatibilityBoxAttr = $62626F78 (* 'bbox' *);					{  Classic presence and features  }
	gestaltMacOSCompatibilityBoxPresent = 0;					{  True if running under the Classic  }
	gestaltMacOSCompatibilityBoxHasSerial = 1;					{  True if Classic serial support is implemented.  }
	gestaltMacOSCompatibilityBoxless = 2;						{  True if we're Boxless (screen shared with Carbon/Cocoa)  }

	gestaltBusClkSpeed			= $62636C6B (* 'bclk' *);						{  main I/O bus clock speed in hertz  }

	gestaltCloseViewAttr		= $42534461 (* 'BSDa' *);						{  CloseView attributes  }
	gestaltCloseViewEnabled		= 0;							{  Closeview enabled (dynamic bit - returns current state)  }
	gestaltCloseViewDisplayMgrFriendly = 1;						{  Closeview compatible with Display Manager (FUTURE)  }

	gestaltCarbonVersion		= $63626F6E (* 'cbon' *);						{  version of Carbon API present in system  }

	gestaltCFMAttr				= $63667267 (* 'cfrg' *);						{  Selector for information about the Code Fragment Manager  }
	gestaltCFMPresent			= 0;							{  True if the Code Fragment Manager is present  }
	gestaltCFMPresentMask		= $0001;
	gestaltCFM99Present			= 2;							{  True if the CFM-99 features are present.  }
	gestaltCFM99PresentMask		= $0004;

	gestaltCollectionMgrVersion	= $636C746E (* 'cltn' *);						{  Collection Manager version  }

	gestaltColorMatchingAttr	= $636D7461 (* 'cmta' *);						{  ColorSync attributes  }
	gestaltHighLevelMatching	= 0;
	gestaltColorMatchingLibLoaded = 1;

	gestaltColorMatchingVersion	= $636D7463 (* 'cmtc' *);
	gestaltColorSync10			= $0100;						{  0x0100 & 0x0110 _Gestalt versions for 1.0-1.0.3 product  }
	gestaltColorSync11			= $0110;						{    0x0100 == low-level matching only  }
	gestaltColorSync104			= $0104;						{  Real version, by popular demand  }
	gestaltColorSync105			= $0105;
	gestaltColorSync20			= $0200;						{  ColorSync 2.0  }
	gestaltColorSync21			= $0210;
	gestaltColorSync211			= $0211;
	gestaltColorSync212			= $0212;
	gestaltColorSync213			= $0213;
	gestaltColorSync25			= $0250;
	gestaltColorSync26			= $0260;
	gestaltColorSync261			= $0261;
	gestaltColorSync30			= $0300;

	gestaltControlMgrVersion	= $636D7672 (* 'cmvr' *);						{  NOTE: The first version we return is 3.0.1, on Mac OS X plus update 2 }

	gestaltControlMgrAttr		= $636E746C (* 'cntl' *);						{  Control Mgr }
	gestaltControlMgrPresent	= $00000001;					{  NOTE: this is a bit mask, whereas all other Gestalt constants of }
																{  this type are bit index values.   Universal Interfaces 3.2 slipped }
																{  out the door with this mistake. }
	gestaltControlMgrPresentBit	= 0;							{  bit number }
	gestaltControlMsgPresentMask = $00000001;

	gestaltConnMgrAttr			= $636F6E6E (* 'conn' *);						{  connection mgr attributes     }
	gestaltConnMgrPresent		= 0;
	gestaltConnMgrCMSearchFix	= 1;							{  Fix to CMAddSearch?      }
	gestaltConnMgrErrorString	= 2;							{  has CMGetErrorString()  }
	gestaltConnMgrMultiAsyncIO	= 3;							{  CMNewIOPB, CMDisposeIOPB, CMPBRead, CMPBWrite, CMPBIOKill  }

	gestaltColorPickerVersion	= $63706B72 (* 'cpkr' *);						{  returns version of ColorPicker  }
	gestaltColorPicker			= $63706B72 (* 'cpkr' *);						{  gestaltColorPicker is old name for gestaltColorPickerVersion  }

	gestaltComponentMgr			= $63706E74 (* 'cpnt' *);						{  Component Mgr version  }
	gestaltComponentPlatform	= $636F706C (* 'copl' *);						{  Component Platform number  }

	{	
	    The gestaltNativeCPUtype ('cput') selector can be used to determine the
	    native CPU type for all Macs running System 7.5 or later.
	
	    The 'cput' selector is not available when running System 7.0 (or earlier)
	    on most 68K machines.  If 'cput' is not available, then the 'proc' selector
	    should be used to determine the processor type.
	
	    An application should always try the 'cput' selector first.  This is because,
	    on PowerPC machines, the 'proc' selector will reflect the CPU type of the
	    emulator's "virtual processor" rather than the native CPU type.
	
	    The values specified below are accurate.  Prior versions of the Gestalt
	    interface file contained values that were off by one.
	
	    The Quadra 840AV and the Quadra 660AV contain a bug in the ROM code that
	    causes the 'cput' selector to respond with the value 5.  This behavior
	    occurs only when running System 7.1.  System 7.5 fixes the bug by replacing
	    the faulty 'cput' selector function with the correct one.
	
	    The gestaltNativeCPUfamily ('cpuf') selector can be used to determine the
	    general family the native CPU is in. This can be helpful for determing how
	    blitters and things should be written. In general, it is smarter to use this
	    selector (when available) than gestaltNativeCPUtype since newer processors
	    in the same family can be handled without revising your code.
	
	    gestaltNativeCPUfamily uses the same results as gestaltNativeCPUtype, but
	    will only return certain CPU values.
		}
	gestaltNativeCPUtype		= $63707574 (* 'cput' *);						{  Native CPU type                           }
	gestaltNativeCPUfamily		= $63707566 (* 'cpuf' *);						{  Native CPU family                       }
	gestaltCPU68000				= 0;							{  Various 68k CPUs...     }
	gestaltCPU68010				= 1;
	gestaltCPU68020				= 2;
	gestaltCPU68030				= 3;
	gestaltCPU68040				= 4;
	gestaltCPU601				= $0101;						{  IBM 601                                }
	gestaltCPU603				= $0103;
	gestaltCPU604				= $0104;
	gestaltCPU603e				= $0106;
	gestaltCPU603ev				= $0107;
	gestaltCPU750				= $0108;						{  Also 740 - "G3"  }
	gestaltCPU604e				= $0109;
	gestaltCPU604ev				= $010A;						{  Mach 5, 250Mhz and up  }
	gestaltCPUG4				= $010C;						{  Max  }
	gestaltCPUG47450			= $0110;						{  Vger , Altivec  }

{$ifc TARGET_OS_WIN32}
																{  x86 CPUs all start with 'i' in the high nybble  }
	gestaltCPU486				= $69343836 (* 'i486' *);
	gestaltCPUPentium			= $69353836 (* 'i586' *);
	gestaltCPUPentiumPro		= $69357072 (* 'i5pr' *);
	gestaltCPUPentiumII			= $69356969 (* 'i5ii' *);
	gestaltCPUX86				= $69787878 (* 'ixxx' *);

{$endc}  {TARGET_OS_WIN32}

	gestaltCRMAttr				= $63726D20 (* 'crm ' *);						{  comm resource mgr attributes  }
	gestaltCRMPresent			= 0;
	gestaltCRMPersistentFix		= 1;							{  fix for persistent tools  }
	gestaltCRMToolRsrcCalls		= 2;							{  has CRMGetToolResource/ReleaseToolResource  }

	gestaltControlStripVersion	= $63737672 (* 'csvr' *);						{  Control Strip version (was 'sdvr')  }

	gestaltCTBVersion			= $63746276 (* 'ctbv' *);						{  CommToolbox version  }

	gestaltDBAccessMgrAttr		= $64626163 (* 'dbac' *);						{  Database Access Mgr attributes  }
	gestaltDBAccessMgrPresent	= 0;							{  True if Database Access Mgr present  }

	gestaltDiskCacheSize		= $6463737A (* 'dcsz' *);						{  Size of disk cache's buffers, in bytes  }

	gestaltSDPFindVersion		= $64666E64 (* 'dfnd' *);						{  OCE Standard Directory Panel }

	gestaltDictionaryMgrAttr	= $64696374 (* 'dict' *);						{  Dictionary Manager attributes  }
	gestaltDictionaryMgrPresent	= 0;							{  Dictionary Manager attributes  }

	gestaltDITLExtAttr			= $6469746C (* 'ditl' *);						{  AppenDITL, etc. calls from CTB  }
	gestaltDITLExtPresent		= 0;							{  True if calls are present  }
	gestaltDITLExtSupportsIctb	= 1;							{  True if AppendDITL, ShortenDITL support 'ictb's  }

	gestaltDialogMgrAttr		= $646C6F67 (* 'dlog' *);						{  Dialog Mgr }
	gestaltDialogMgrPresent		= $00000001;					{  NOTE: this is a bit mask, whereas all other Gestalt constants of }
																{  this type are bit index values.   Universal Interfaces 3.2 slipped }
																{  out the door with this mistake. }
	gestaltDialogMgrPresentBit	= 0;							{  bit number }
	gestaltDialogMgrHasAquaAlertBit = 2;						{  bit number }
	gestaltDialogMgrPresentMask	= $00000001;
	gestaltDialogMgrHasAquaAlertMask = $00000004;
	gestaltDialogMsgPresentMask	= $00000001;					{  compatibility mask }

	gestaltDesktopPicturesAttr	= $646B7078 (* 'dkpx' *);						{  Desktop Pictures attributes  }
	gestaltDesktopPicturesInstalled = 0;						{  True if control panel is installed  }
	gestaltDesktopPicturesDisplayed = 1;						{  True if a picture is currently displayed  }

	gestaltDisplayMgrVers		= $64706C76 (* 'dplv' *);						{  Display Manager version  }

	gestaltDisplayMgrAttr		= $64706C79 (* 'dply' *);						{  Display Manager attributes  }
	gestaltDisplayMgrPresent	= 0;							{  True if Display Mgr is present  }
	gestaltDisplayMgrCanSwitchMirrored = 2;						{  True if Display Mgr can switch modes on mirrored displays  }
	gestaltDisplayMgrSetDepthNotifies = 3;						{  True SetDepth generates displays mgr notification  }
	gestaltDisplayMgrCanConfirm	= 4;							{  True Display Manager supports DMConfirmConfiguration  }
	gestaltDisplayMgrColorSyncAware = 5;						{  True if Display Manager supports profiles for displays  }
	gestaltDisplayMgrGeneratesProfiles = 6;						{  True if Display Manager will automatically generate profiles for displays  }

	gestaltDragMgrAttr			= $64726167 (* 'drag' *);						{  Drag Manager attributes  }
	gestaltDragMgrPresent		= 0;							{  Drag Manager is present  }
	gestaltDragMgrFloatingWind	= 1;							{  Drag Manager supports floating windows  }
	gestaltPPCDragLibPresent	= 2;							{  Drag Manager PPC DragLib is present  }
	gestaltDragMgrHasImageSupport = 3;							{  Drag Manager allows SetDragImage call  }
	gestaltCanStartDragInFloatWindow = 4;						{  Drag Manager supports starting a drag in a floating window  }
	gestaltSetDragImageUpdates	= 5;							{  Drag Manager supports drag image updating via SetDragImage  }

	gestaltDrawSprocketVersion	= $64737076 (* 'dspv' *);						{  Draw Sprocket version (as a NumVersion)  }

	gestaltDigitalSignatureVersion = $64736967 (* 'dsig' *);					{  returns Digital Signature Toolbox version in low-order word }

	{
	   Desktop Printing Feature Gestalt
	   Use this gestalt to check if third-party printer driver support is available
	}
	gestaltDTPFeatures			= $64747066 (* 'dtpf' *);
	kDTPThirdPartySupported		= $00000004;					{  mask for checking if third-party drivers are supported }


	{
	   Desktop Printer Info Gestalt
	   Use this gestalt to get a hold of information for all of the active desktop printers
	}
	gestaltDTPInfo				= $64747078 (* 'dtpx' *);						{  returns GestaltDTPInfoHdle }

	gestaltEasyAccessAttr		= $65617379 (* 'easy' *);						{  Easy Access attributes  }
	gestaltEasyAccessOff		= 0;							{  if Easy Access present, but off (no icon)  }
	gestaltEasyAccessOn			= 1;							{  if Easy Access "On"  }
	gestaltEasyAccessSticky		= 2;							{  if Easy Access "Sticky"  }
	gestaltEasyAccessLocked		= 3;							{  if Easy Access "Locked"  }

	gestaltEditionMgrAttr		= $6564746E (* 'edtn' *);						{  Edition Mgr attributes  }
	gestaltEditionMgrPresent	= 0;							{  True if Edition Mgr present  }
	gestaltEditionMgrTranslationAware = 1;						{  True if edition manager is translation manager aware  }

	gestaltAppleEventsAttr		= $65766E74 (* 'evnt' *);						{  Apple Events attributes  }
	gestaltAppleEventsPresent	= 0;							{  True if Apple Events present  }
	gestaltScriptingSupport		= 1;
	gestaltOSLInSystem			= 2;							{  OSL is in system so dont use the one linked in to app  }
	gestaltSupportsApplicationURL = 4;							{  Supports the typeApplicationURL addressing mode  }

	gestaltExtensionTableVersion = $6574626C (* 'etbl' *);						{  ExtensionTable version  }


	gestaltFBCIndexingState		= $66626369 (* 'fbci' *);						{  Find By Content indexing state }
	gestaltFBCindexingSafe		= 0;							{  any search will result in synchronous wait }
	gestaltFBCindexingCritical	= 1;							{  any search will execute immediately }

	gestaltFBCVersion			= $66626376 (* 'fbcv' *);						{  Find By Content version }
	gestaltFBCCurrentVersion	= $0011;						{  First release for OS 8/9 }
	gestaltOSXFBCCurrentVersion	= $0100;						{  First release for OS X }


	gestaltFileMappingAttr		= $666C6D70 (* 'flmp' *);						{  File mapping attributes }
	gestaltFileMappingPresent	= 0;							{  bit is set if file mapping APIs are present }
	gestaltFileMappingMultipleFilesFix = 1;						{  bit is set if multiple files per volume can be mapped }

	gestaltFloppyAttr			= $666C7079 (* 'flpy' *);						{  Floppy disk drive/driver attributes  }
	gestaltFloppyIsMFMOnly		= 0;							{  Floppy driver only supports MFM disk formats  }
	gestaltFloppyIsManualEject	= 1;							{  Floppy drive, driver, and file system are in manual-eject mode  }
	gestaltFloppyUsesDiskInPlace = 2;							{  Floppy drive must have special DISK-IN-PLACE output; standard DISK-CHANGED not used  }

	gestaltFinderAttr			= $666E6472 (* 'fndr' *);						{  Finder attributes  }
	gestaltFinderDropEvent		= 0;							{  Finder recognizes drop event  }
	gestaltFinderMagicPlacement	= 1;							{  Finder supports magic icon placement  }
	gestaltFinderCallsAEProcess	= 2;							{  Finder calls AEProcessAppleEvent  }
	gestaltOSLCompliantFinder	= 3;							{  Finder is scriptable and recordable  }
	gestaltFinderSupports4GBVolumes = 4;						{  Finder correctly handles 4GB volumes  }
	gestaltFinderHasClippings	= 6;							{  Finder supports Drag Manager clipping files  }
	gestaltFinderFullDragManagerSupport = 7;					{  Finder accepts 'hfs ' flavors properly  }
	gestaltFinderFloppyRootComments = 8;						{  in MacOS 8 and later, will be set if Finder ever supports comments on Floppy icons  }
	gestaltFinderLargeAndNotSavedFlavorsOK = 9;					{  in MacOS 8 and later, this bit is set if drags with >1024-byte flavors and flavorNotSaved flavors work reliably  }
	gestaltFinderUsesExtensibleFolderManager = 10;				{  Finder uses Extensible Folder Manager (for example, for Magic Routing)  }
	gestaltFinderUnderstandsRedirectedDesktopFolder = 11;		{  Finder deals with startup disk's desktop folder residing on another disk  }

	gestaltFindFolderAttr		= $666F6C64 (* 'fold' *);						{  Folder Mgr attributes  }
	gestaltFindFolderPresent	= 0;							{  True if Folder Mgr present  }
	gestaltFolderDescSupport	= 1;							{  True if Folder Mgr has FolderDesc calls  }
	gestaltFolderMgrFollowsAliasesWhenResolving = 2;			{  True if Folder Mgr follows folder aliases  }
	gestaltFolderMgrSupportsExtendedCalls = 3;					{  True if Folder Mgr supports the Extended calls  }
	gestaltFolderMgrSupportsDomains = 4;						{  True if Folder Mgr supports domains for the first parameter to FindFolder  }
	gestaltFolderMgrSupportsFSCalls = 5;						{  True if FOlder manager supports __FindFolderFSRef & __FindFolderExtendedFSRef  }

	gestaltFindFolderRedirectionAttr = $666F6C65 (* 'fole' *);


	gestaltFontMgrAttr			= $666F6E74 (* 'font' *);						{  Font Mgr attributes  }
	gestaltOutlineFonts			= 0;							{  True if Outline Fonts supported  }

	gestaltFPUType				= $66707520 (* 'fpu ' *);						{  fpu type  }
	gestaltNoFPU				= 0;							{  no FPU  }
	gestalt68881				= 1;							{  68881 FPU  }
	gestalt68882				= 2;							{  68882 FPU  }
	gestalt68040FPU				= 3;							{  68040 built-in FPU  }

	gestaltFSAttr				= $66732020 (* 'fs  ' *);						{  file system attributes  }
	gestaltFullExtFSDispatching	= 0;							{  has really cool new HFSDispatch dispatcher  }
	gestaltHasFSSpecCalls		= 1;							{  has FSSpec calls  }
	gestaltHasFileSystemManager	= 2;							{  has a file system manager  }
	gestaltFSMDoesDynamicLoad	= 3;							{  file system manager supports dynamic loading  }
	gestaltFSSupports4GBVols	= 4;							{  file system supports 4 gigabyte volumes  }
	gestaltFSSupports2TBVols	= 5;							{  file system supports 2 terabyte volumes  }
	gestaltHasExtendedDiskInit	= 6;							{  has extended Disk Initialization calls  }
	gestaltDTMgrSupportsFSM		= 7;							{  Desktop Manager support FSM-based foreign file systems  }
	gestaltFSNoMFSVols			= 8;							{  file system doesn't supports MFS volumes  }
	gestaltFSSupportsHFSPlusVols = 9;							{  file system supports HFS Plus volumes  }
	gestaltFSIncompatibleDFA82	= 10;							{  VCB and FCB structures changed; DFA 8.2 is incompatible  }

	gestaltHasHFSPlusAPIs		= 12;							{  file system supports HFS Plus APIs  }
	gestaltMustUseFCBAccessors	= 13;							{  FCBSPtr and FSFCBLen are invalid - must use FSM FCB accessor functions }
	gestaltFSUsesPOSIXPathsForConversion = 14;					{  The path interchange routines operate on POSIX paths instead of HFS paths  }

	gestaltAdminFeaturesFlagsAttr = $66726564 (* 'fred' *);						{  a set of admin flags, mostly useful internally.  }
	gestaltFinderUsesSpecialOpenFoldersFile = 0;				{  the Finder uses a special file to store the list of open folders  }

	gestaltFSMVersion			= $66736D20 (* 'fsm ' *);						{  returns version of HFS External File Systems Manager (FSM)  }

	gestaltFXfrMgrAttr			= $66786672 (* 'fxfr' *);						{  file transfer manager attributes  }
	gestaltFXfrMgrPresent		= 0;
	gestaltFXfrMgrMultiFile		= 1;							{  supports FTSend and FTReceive  }
	gestaltFXfrMgrErrorString	= 2;							{  supports FTGetErrorString  }
	gestaltFXfrMgrAsync			= 3;							{ supports FTSendAsync, FTReceiveAsync, FTCompletionAsync }

	gestaltGraphicsAttr			= $67667861 (* 'gfxa' *);						{  Quickdraw GX attributes selector  }
	gestaltGraphicsIsDebugging	= $00000001;
	gestaltGraphicsIsLoaded		= $00000002;
	gestaltGraphicsIsPowerPC	= $00000004;

	gestaltGraphicsVersion		= $67726678 (* 'grfx' *);						{  Quickdraw GX version selector  }
	gestaltCurrentGraphicsVersion = $00010200;					{  the version described in this set of headers  }

	gestaltHardwareAttr			= $68647772 (* 'hdwr' *);						{  hardware attributes  }
	gestaltHasVIA1				= 0;							{  VIA1 exists  }
	gestaltHasVIA2				= 1;							{  VIA2 exists  }
	gestaltHasASC				= 3;							{  Apple Sound Chip exists  }
	gestaltHasSCC				= 4;							{  SCC exists  }
	gestaltHasSCSI				= 7;							{  SCSI exists  }
	gestaltHasSoftPowerOff		= 19;							{  Capable of software power off  }
	gestaltHasSCSI961			= 21;							{  53C96 SCSI controller on internal bus  }
	gestaltHasSCSI962			= 22;							{  53C96 SCSI controller on external bus  }
	gestaltHasUniversalROM		= 24;							{  Do we have a Universal ROM?  }
	gestaltHasEnhancedLtalk		= 30;							{  Do we have Enhanced LocalTalk?  }

	gestaltHelpMgrAttr			= $68656C70 (* 'help' *);						{  Help Mgr Attributes  }
	gestaltHelpMgrPresent		= 0;							{  true if help mgr is present  }
	gestaltHelpMgrExtensions	= 1;							{  true if help mgr extensions are installed  }
	gestaltAppleGuideIsDebug	= 30;
	gestaltAppleGuidePresent	= 31;							{  true if AppleGuide is installed  }

	gestaltHardwareVendorCode	= $68726164 (* 'hrad' *);						{  Returns hardware vendor information  }
	gestaltHardwareVendorApple	= $4170706C (* 'Appl' *);						{  Hardware built by Apple  }

	gestaltCompressionMgr		= $69636D70 (* 'icmp' *);						{  returns version of the Image Compression Manager  }

	gestaltIconUtilitiesAttr	= $69636F6E (* 'icon' *);						{  Icon Utilities attributes  (Note: available in System 7.0, despite gestalt)  }
	gestaltIconUtilitiesPresent	= 0;							{  true if icon utilities are present  }
	gestaltIconUtilitiesHas48PixelIcons = 1;					{  true if 48x48 icons are supported by IconUtilities  }
	gestaltIconUtilitiesHas32BitIcons = 2;						{  true if 32-bit deep icons are supported  }
	gestaltIconUtilitiesHas8BitDeepMasks = 3;					{  true if 8-bit deep masks are supported  }
	gestaltIconUtilitiesHasIconServices = 4;					{  true if IconServices is present  }

	gestaltInternalDisplay		= $69647370 (* 'idsp' *);						{  slot number of internal display location  }

	{	
	    To obtain information about the connected keyboard(s), one should
	    use the ADB Manager API.  See Technical Note OV16 for details.
		}
	gestaltKeyboardType			= $6B626420 (* 'kbd ' *);						{  keyboard type  }
	gestaltMacKbd				= 1;
	gestaltMacAndPad			= 2;
	gestaltMacPlusKbd			= 3;
	gestaltExtADBKbd			= 4;
	gestaltStdADBKbd			= 5;
	gestaltPrtblADBKbd			= 6;
	gestaltPrtblISOKbd			= 7;
	gestaltStdISOADBKbd			= 8;
	gestaltExtISOADBKbd			= 9;
	gestaltADBKbdII				= 10;
	gestaltADBISOKbdII			= 11;
	gestaltPwrBookADBKbd		= 12;
	gestaltPwrBookISOADBKbd		= 13;
	gestaltAppleAdjustKeypad	= 14;
	gestaltAppleAdjustADBKbd	= 15;
	gestaltAppleAdjustISOKbd	= 16;
	gestaltJapanAdjustADBKbd	= 17;							{  Japan Adjustable Keyboard  }
	gestaltPwrBkExtISOKbd		= 20;							{  PowerBook Extended International Keyboard with function keys  }
	gestaltPwrBkExtJISKbd		= 21;							{  PowerBook Extended Japanese Keyboard with function keys       }
	gestaltPwrBkExtADBKbd		= 24;							{  PowerBook Extended Domestic Keyboard with function keys       }
	gestaltPS2Keyboard			= 27;							{  PS2 keyboard  }
	gestaltPwrBkSubDomKbd		= 28;							{  PowerBook Subnote Domestic Keyboard with function keys w/  inverted T   }
	gestaltPwrBkSubISOKbd		= 29;							{  PowerBook Subnote International Keyboard with function keys w/  inverted T      }
	gestaltPwrBkSubJISKbd		= 30;							{  PowerBook Subnote Japanese Keyboard with function keys w/ inverted T     }
	gestaltPwrBkEKDomKbd		= 195;							{  (0xC3) PowerBook Domestic Keyboard with Embedded Keypad, function keys & inverted T     }
	gestaltPwrBkEKISOKbd		= 196;							{  (0xC4) PowerBook International Keyboard with Embedded Keypad, function keys & inverted T    }
	gestaltPwrBkEKJISKbd		= 197;							{  (0xC5) PowerBook Japanese Keyboard with Embedded Keypad, function keys & inverted T       }
	gestaltUSBCosmoANSIKbd		= 198;							{  (0xC6) original USB Domestic (ANSI) Keyboard  }
	gestaltUSBCosmoISOKbd		= 199;							{  (0xC7) original USB International (ISO) Keyboard  }
	gestaltUSBCosmoJISKbd		= 200;							{  (0xC8) original USB Japanese (JIS) Keyboard  }
	gestaltPwrBk99JISKbd		= 201;							{  (0xC9) '99 PowerBook JIS Keyboard with Embedded Keypad, function keys & inverted T                }
	gestaltUSBAndyANSIKbd		= 204;							{  (0xCC) USB Pro Keyboard Domestic (ANSI) Keyboard                                  }
	gestaltUSBAndyISOKbd		= 205;							{  (0xCD) USB Pro Keyboard International (ISO) Keyboard                                }
	gestaltUSBAndyJISKbd		= 206;							{  (0xCE) USB Pro Keyboard Japanese (JIS) Keyboard                                     }


	{
	    This gestalt indicates the highest UDF version that the active UDF implementation supports.
	    The value should be assembled from a read version (upper word) and a write version (lower word)
	}
	gestaltUDFSupport			= $6B756466 (* 'kudf' *);						{     Used for communication between UDF implementations }

	gestaltLowMemorySize		= $6C6D656D (* 'lmem' *);						{  size of low memory area  }

	gestaltLogicalRAMSize		= $6C72616D (* 'lram' *);						{  logical ram size  }

	{	
	    MACHINE type CONSTANTS NAMING CONVENTION
	
	        All future machine type constant names take the following form:
	
	            gestalt<lineName><modelNumber>
	
	    Line Names
	
	        The following table contains the lines currently produced by Apple and the
	        lineName substrings associated with them:
	
	            Line                        lineName
	            -------------------------   ------------
	            Macintosh LC                "MacLC"
	            Macintosh Performa          "Performa"
	            Macintosh PowerBook         "PowerBook"
	            Macintosh PowerBook Duo     "PowerBookDuo"
	            Power Macintosh             "PowerMac"
	            Apple Workgroup Server      "AWS"
	
	        The following table contains lineNames for some discontinued lines:
	
	            Line                        lineName
	            -------------------------   ------------
	            Macintosh Quadra            "MacQuadra" (preferred)
	                                        "Quadra" (also used, but not preferred)
	            Macintosh Centris           "MacCentris"
	
	    Model Numbers
	
	        The modelNumber is a string representing the specific model of the machine
	        within its particular line.  For example, for the Power Macintosh 8100/80,
	        the modelNumber is "8100".
	
	        Some Performa & LC model numbers contain variations in the rightmost 1 or 2
	        digits to indicate different RAM and Hard Disk configurations.  A single
	        machine type is assigned for all variations of a specific model number.  In
	        this case, the modelNumber string consists of the constant leftmost part
	        of the model number with 0s for the variant digits.  For example, the
	        Performa 6115 and Performa 6116 are both return the same machine type
	        constant:  gestaltPerforma6100.
	
	
	    OLD NAMING CONVENTIONS
	
	    The "Underscore Speed" suffix
	
	        In the past, Apple differentiated between machines that had the same model
	        number but different speeds.  For example, the Power Macintosh 8100/80 and
	        Power Macintosh 8100/100 return different machine type constants.  This is
	        why some existing machine type constant names take the form:
	
	            gestalt<lineName><modelNumber>_<speed>
	
	        e.g.
	
	            gestaltPowerMac8100_110
	            gestaltPowerMac7100_80
	            gestaltPowerMac7100_66
	
	        It is no longer necessary to use the "underscore speed" suffix.  Starting with
	        the Power Surge machines (Power Macintosh 7200, 7500, 8500 and 9500), speed is
	        no longer used to differentiate between machine types.  This is why a Power
	        Macintosh 7200/75 and a Power Macintosh 7200/90 return the same machine type
	        constant:  gestaltPowerMac7200.
	
	    The "Screen Type" suffix
	
	        All PowerBook models prior to the PowerBook 190, and all PowerBook Duo models
	        before the PowerBook Duo 2300 take the form:
	
	            gestalt<lineName><modelNumber><screenType>
	
	        Where <screenType> is "c" or the empty string.
	
	        e.g.
	
	            gestaltPowerBook100
	            gestaltPowerBookDuo280
	            gestaltPowerBookDuo280c
	            gestaltPowerBook180
	            gestaltPowerBook180c
	
	        Starting with the PowerBook 190 series and the PowerBook Duo 2300 series, machine
	        types are no longer differentiated based on screen type.  This is why a PowerBook
	        5300cs/100 and a PowerBook 5300c/100 both return the same machine type constant:
	        gestaltPowerBook5300.
	
	        Macintosh LC 630                gestaltMacLC630
	        Macintosh Performa 6200         gestaltPerforma6200
	        Macintosh Quadra 700            gestaltQuadra700
	        Macintosh PowerBook 5300        gestaltPowerBook5300
	        Macintosh PowerBook Duo 2300    gestaltPowerBookDuo2300
	        Power Macintosh 8500            gestaltPowerMac8500
		}

	gestaltMachineType			= $6D616368 (* 'mach' *);						{  machine type  }
	gestaltClassic				= 1;
	gestaltMacXL				= 2;
	gestaltMac512KE				= 3;
	gestaltMacPlus				= 4;
	gestaltMacSE				= 5;
	gestaltMacII				= 6;
	gestaltMacIIx				= 7;
	gestaltMacIIcx				= 8;
	gestaltMacSE030				= 9;
	gestaltPortable				= 10;
	gestaltMacIIci				= 11;
	gestaltPowerMac8100_120		= 12;
	gestaltMacIIfx				= 13;
	gestaltMacClassic			= 17;
	gestaltMacIIsi				= 18;
	gestaltMacLC				= 19;
	gestaltMacQuadra900			= 20;
	gestaltPowerBook170			= 21;
	gestaltMacQuadra700			= 22;
	gestaltClassicII			= 23;
	gestaltPowerBook100			= 24;
	gestaltPowerBook140			= 25;
	gestaltMacQuadra950			= 26;
	gestaltMacLCIII				= 27;
	gestaltPerforma450			= 27;
	gestaltPowerBookDuo210		= 29;
	gestaltMacCentris650		= 30;
	gestaltPowerBookDuo230		= 32;
	gestaltPowerBook180			= 33;
	gestaltPowerBook160			= 34;
	gestaltMacQuadra800			= 35;
	gestaltMacQuadra650			= 36;
	gestaltMacLCII				= 37;
	gestaltPowerBookDuo250		= 38;
	gestaltAWS9150_80			= 39;
	gestaltPowerMac8100_110		= 40;
	gestaltAWS8150_110			= 40;
	gestaltPowerMac5200			= 41;
	gestaltPowerMac5260			= 41;
	gestaltPerforma5300			= 41;
	gestaltPowerMac6200			= 42;
	gestaltPerforma6300			= 42;
	gestaltMacIIvi				= 44;
	gestaltMacIIvm				= 45;
	gestaltPerforma600			= 45;
	gestaltPowerMac7100_80		= 47;
	gestaltMacIIvx				= 48;
	gestaltMacColorClassic		= 49;
	gestaltPerforma250			= 49;
	gestaltPowerBook165c		= 50;
	gestaltMacCentris610		= 52;
	gestaltMacQuadra610			= 53;
	gestaltPowerBook145			= 54;
	gestaltPowerMac8100_100		= 55;
	gestaltMacLC520				= 56;
	gestaltAWS9150_120			= 57;
	gestaltPowerMac6400			= 58;
	gestaltPerforma6400			= 58;
	gestaltPerforma6360			= 58;
	gestaltMacCentris660AV		= 60;
	gestaltMacQuadra660AV		= 60;
	gestaltPerforma46x			= 62;
	gestaltPowerMac8100_80		= 65;
	gestaltAWS8150_80			= 65;
	gestaltPowerMac9500			= 67;
	gestaltPowerMac9600			= 67;
	gestaltPowerMac7500			= 68;
	gestaltPowerMac7600			= 68;
	gestaltPowerMac8500			= 69;
	gestaltPowerMac8600			= 69;
	gestaltAWS8550				= 68;
	gestaltPowerBook180c		= 71;
	gestaltPowerBook520			= 72;
	gestaltPowerBook520c		= 72;
	gestaltPowerBook540			= 72;
	gestaltPowerBook540c		= 72;
	gestaltPowerMac5400			= 74;
	gestaltPowerMac6100_60		= 75;
	gestaltAWS6150_60			= 75;
	gestaltPowerBookDuo270c		= 77;
	gestaltMacQuadra840AV		= 78;
	gestaltPerforma550			= 80;
	gestaltPowerBook165			= 84;
	gestaltPowerBook190			= 85;
	gestaltMacTV				= 88;
	gestaltMacLC475				= 89;
	gestaltPerforma47x			= 89;
	gestaltMacLC575				= 92;
	gestaltMacQuadra605			= 94;
	gestaltMacQuadra630			= 98;
	gestaltMacLC580				= 99;
	gestaltPerforma580			= 99;
	gestaltPowerMac6100_66		= 100;
	gestaltAWS6150_66			= 100;
	gestaltPowerBookDuo280		= 102;
	gestaltPowerBookDuo280c		= 103;
	gestaltPowerMacLC475		= 104;							{  Mac LC 475 & PPC Processor Upgrade Card }
	gestaltPowerMacPerforma47x	= 104;
	gestaltPowerMacLC575		= 105;							{  Mac LC 575 & PPC Processor Upgrade Card  }
	gestaltPowerMacPerforma57x	= 105;
	gestaltPowerMacQuadra630	= 106;							{  Quadra 630 & PPC Processor Upgrade Card }
	gestaltPowerMacLC630		= 106;							{  Mac LC 630 & PPC Processor Upgrade Card }
	gestaltPowerMacPerforma63x	= 106;							{  Performa 63x & PPC Processor Upgrade Card }
	gestaltPowerMac7200			= 108;
	gestaltPowerMac7300			= 109;
	gestaltPowerMac7100_66		= 112;
	gestaltPowerBook150			= 115;
	gestaltPowerMacQuadra700	= 116;							{  Quadra 700 & Power PC Upgrade Card }
	gestaltPowerMacQuadra900	= 117;							{  Quadra 900 & Power PC Upgrade Card  }
	gestaltPowerMacQuadra950	= 118;							{  Quadra 950 & Power PC Upgrade Card  }
	gestaltPowerMacCentris610	= 119;							{  Centris 610 & Power PC Upgrade Card  }
	gestaltPowerMacCentris650	= 120;							{  Centris 650 & Power PC Upgrade Card  }
	gestaltPowerMacQuadra610	= 121;							{  Quadra 610 & Power PC Upgrade Card  }
	gestaltPowerMacQuadra650	= 122;							{  Quadra 650 & Power PC Upgrade Card  }
	gestaltPowerMacQuadra800	= 123;							{  Quadra 800 & Power PC Upgrade Card  }
	gestaltPowerBookDuo2300		= 124;
	gestaltPowerBook500PPCUpgrade = 126;
	gestaltPowerBook5300		= 128;
	gestaltPowerBook1400		= 310;
	gestaltPowerBook3400		= 306;
	gestaltPowerBook2400		= 307;
	gestaltPowerBookG3Series	= 312;
	gestaltPowerBookG3			= 313;
	gestaltPowerBookG3Series2	= 314;
	gestaltPowerMacNewWorld		= 406;							{  All NewWorld architecture Macs (iMac, blue G3, etc.) }
	gestaltPowerMacG3			= 510;
	gestaltPowerMac5500			= 512;
	gestalt20thAnniversary		= 512;
	gestaltPowerMac6500			= 513;
	gestaltPowerMac4400_160		= 514;							{  slower machine has different machine ID }
	gestaltPowerMac4400			= 515;
	gestaltMacOSCompatibility	= 1206;							{     Mac OS Compatibility on Mac OS X (Classic) }


	gestaltQuadra605			= 94;
	gestaltQuadra610			= 53;
	gestaltQuadra630			= 98;
	gestaltQuadra650			= 36;
	gestaltQuadra660AV			= 60;
	gestaltQuadra700			= 22;
	gestaltQuadra800			= 35;
	gestaltQuadra840AV			= 78;
	gestaltQuadra900			= 20;
	gestaltQuadra950			= 26;

	kMachineNameStrID			= -16395;

	gestaltSMPMailerVersion		= $6D616C72 (* 'malr' *);						{  OCE StandardMail }

	gestaltMediaBay				= $6D626568 (* 'mbeh' *);						{  media bay driver type  }
	gestaltMBLegacy				= 0;							{  media bay support in PCCard 2.0  }
	gestaltMBSingleBay			= 1;							{  single bay media bay driver  }
	gestaltMBMultipleBays		= 2;							{  multi-bay media bay driver  }

	gestaltMessageMgrVersion	= $6D657373 (* 'mess' *);						{  GX Printing Message Manager Gestalt Selector  }


	{   Menu Manager Gestalt (Mac OS 8.5 and later) }
	gestaltMenuMgrAttr			= $6D656E75 (* 'menu' *);						{  If this Gestalt exists, the Mac OS 8.5 Menu Manager is installed  }
	gestaltMenuMgrPresent		= $00000001;					{  NOTE: this is a bit mask, whereas all other Gestalt constants of this nature  }
																{  are bit index values. 3.2 interfaces slipped out with this mistake unnoticed.  }
																{  Sincere apologies for any inconvenience. }
	gestaltMenuMgrPresentBit	= 0;							{  bit number  }
	gestaltMenuMgrAquaLayoutBit	= 1;							{  menus have the Aqua 1.0 layout }
	gestaltMenuMgrMultipleItemsWithCommandIDBit = 2;			{  CountMenuItemsWithCommandID/GetIndMenuItemWithCommandID support multiple items with the same command ID }
	gestaltMenuMgrRetainsIconRefBit = 3;						{  SetMenuItemIconHandle, when passed an IconRef, calls AcquireIconRef }
	gestaltMenuMgrSendsMenuBoundsToDefProcBit = 4;				{  kMenuSizeMsg and kMenuPopUpMsg have menu bounding rect information }
																{  masks for the above bits }
	gestaltMenuMgrPresentMask	= $00000001;
	gestaltMenuMgrAquaLayoutMask = $00000002;
	gestaltMenuMgrMultipleItemsWithCommandIDMask = $00000004;
	gestaltMenuMgrRetainsIconRefMask = $00000008;
	gestaltMenuMgrSendsMenuBoundsToDefProcMask = $00000010;


	gestaltMultipleUsersState	= $6D666472 (* 'mfdr' *);						{  Gestalt selector returns MultiUserGestaltHandle (in Folders.h) }


	gestaltMachineIcon			= $6D69636E (* 'micn' *);						{  machine icon  }

	gestaltMiscAttr				= $6D697363 (* 'misc' *);						{  miscellaneous attributes  }
	gestaltScrollingThrottle	= 0;							{  true if scrolling throttle on  }
	gestaltSquareMenuBar		= 2;							{  true if menu bar is square  }


	{	
	    The name gestaltMixedModeVersion for the 'mixd' selector is semantically incorrect.
	    The same selector has been renamed gestaltMixedModeAttr to properly reflect the
	    Inside Mac: PowerPC System Software documentation.  The gestaltMixedModeVersion
	    symbol has been preserved only for backwards compatibility.
	
	    Developers are forewarned that gestaltMixedModeVersion has a limited lifespan and
	    will be removed in a future release of the Interfaces.
	
	    For the first version of Mixed Mode, both meanings of the 'mixd' selector are
	    functionally identical.  They both return 0x00000001.  In subsequent versions
	    of Mixed Mode, however, the 'mixd' selector will not respond with an increasing
	    version number, but rather, with 32 attribute bits with various meanings.
		}
	gestaltMixedModeVersion		= $6D697864 (* 'mixd' *);						{  returns version of Mixed Mode  }

	gestaltMixedModeAttr		= $6D697864 (* 'mixd' *);						{  returns Mixed Mode attributes  }
	gestaltMixedModePowerPC		= 0;							{  true if Mixed Mode supports PowerPC ABI calling conventions  }
	gestaltPowerPCAware			= 0;							{  old name for gestaltMixedModePowerPC  }
	gestaltMixedModeCFM68K		= 1;							{  true if Mixed Mode supports CFM-68K calling conventions  }
	gestaltMixedModeCFM68KHasTrap = 2;							{  true if CFM-68K Mixed Mode implements _MixedModeDispatch (versions 1.0.1 and prior did not)  }
	gestaltMixedModeCFM68KHasState = 3;							{  true if CFM-68K Mixed Mode exports Save/RestoreMixedModeState  }

	gestaltQuickTimeConferencing = $6D746C6B (* 'mtlk' *);						{  returns QuickTime Conferencing version  }

	gestaltMemoryMapAttr		= $6D6D6170 (* 'mmap' *);						{  Memory map type  }
	gestaltMemoryMapSparse		= 0;							{  Sparse memory is on  }

	gestaltMMUType				= $6D6D7520 (* 'mmu ' *);						{  mmu type  }
	gestaltNoMMU				= 0;							{  no MMU  }
	gestaltAMU					= 1;							{  address management unit  }
	gestalt68851				= 2;							{  68851 PMMU  }
	gestalt68030MMU				= 3;							{  68030 built-in MMU  }
	gestalt68040MMU				= 4;							{  68040 built-in MMU  }
	gestaltEMMU1				= 5;							{  Emulated MMU type 1   }

	gestaltUserVisibleMachineName = $6D6E616D (* 'mnam' *);						{  Coerce response into a StringPtr to get a user visible machine name  }

	gestaltMPCallableAPIsAttr	= $6D707363 (* 'mpsc' *);						{  Bitmap of toolbox/OS managers that can be called from MPLibrary MPTasks  }
	gestaltMPFileManager		= 0;							{  True if File Manager calls can be made from MPTasks  }
	gestaltMPDeviceManager		= 1;							{  True if synchronous Device Manager calls can be made from MPTasks  }
	gestaltMPTrapCalls			= 2;							{  True if most trap-based calls can be made from MPTasks  }

	gestaltStdNBPAttr			= $6E6C7570 (* 'nlup' *);						{  standard nbp attributes  }
	gestaltStdNBPPresent		= 0;
	gestaltStdNBPSupportsAutoPosition = 1;						{  StandardNBP takes (-1,-1) to mean alert position main screen  }

	gestaltNotificationMgrAttr	= $6E6D6772 (* 'nmgr' *);						{  notification manager attributes  }
	gestaltNotificationPresent	= 0;							{  notification manager exists  }

	gestaltNameRegistryVersion	= $6E726567 (* 'nreg' *);						{  NameRegistryLib version number, for System 7.5.2+ usage  }

	gestaltNuBusSlotCount		= $6E756273 (* 'nubs' *);						{  count of logical NuBus slots present  }

	gestaltOCEToolboxVersion	= $6F636574 (* 'ocet' *);						{  OCE Toolbox version  }
	gestaltOCETB				= $0102;						{  OCE Toolbox version 1.02  }
	gestaltSFServer				= $0100;						{  S&F Server version 1.0  }

	gestaltOCEToolboxAttr		= $6F636575 (* 'oceu' *);						{  OCE Toolbox attributes  }
	gestaltOCETBPresent			= $01;							{  OCE toolbox is present, not running  }
	gestaltOCETBAvailable		= $02;							{  OCE toolbox is running and available  }
	gestaltOCESFServerAvailable	= $04;							{  S&F Server is running and available  }
	gestaltOCETBNativeGlueAvailable = $10;						{  Native PowerPC Glue routines are availible  }

	gestaltOpenFirmwareInfo		= $6F706677 (* 'opfw' *);						{  Open Firmware info  }

	gestaltOSAttr				= $6F732020 (* 'os  ' *);						{  o/s attributes  }
	gestaltSysZoneGrowable		= 0;							{  system heap is growable  }
	gestaltLaunchCanReturn		= 1;							{  can return from launch  }
	gestaltLaunchFullFileSpec	= 2;							{  can launch from full file spec  }
	gestaltLaunchControl		= 3;							{  launch control support available  }
	gestaltTempMemSupport		= 4;							{  temp memory support  }
	gestaltRealTempMemory		= 5;							{  temp memory handles are real  }
	gestaltTempMemTracked		= 6;							{  temporary memory handles are tracked  }
	gestaltIPCSupport			= 7;							{  IPC support is present  }
	gestaltSysDebuggerSupport	= 8;							{  system debugger support is present  }
	gestaltNativeProcessMgrBit	= 19;							{  the process manager itself is native  }
	gestaltAltivecRegistersSwappedCorrectlyBit = 20;			{  Altivec registers are saved correctly on process switches  }

	gestaltOSTable				= $6F737474 (* 'ostt' *);						{   OS trap table base   }


	{	******************************************************************************
	*   Gestalt Selectors for Open Transport Network Setup
	*
	*   Note: possible values for the version "stage" byte are:
	*   development = 0x20, alpha = 0x40, beta = 0x60, final & release = 0x80
	*******************************************************************************	}
	gestaltOpenTptNetworkSetup	= $6F746366 (* 'otcf' *);
	gestaltOpenTptNetworkSetupLegacyImport = 0;
	gestaltOpenTptNetworkSetupLegacyExport = 1;
	gestaltOpenTptNetworkSetupSupportsMultihoming = 2;

	gestaltOpenTptNetworkSetupVersion = $6F746376 (* 'otcv' *);

	{	******************************************************************************
	*   Gestalt Selectors for Open Transport-based Remote Access/PPP
	*
	*   Note: possible values for the version "stage" byte are:
	*   development = 0x20, alpha = 0x40, beta = 0x60, final & release = 0x80
	*******************************************************************************	}
	gestaltOpenTptRemoteAccess	= $6F747261 (* 'otra' *);
	gestaltOpenTptRemoteAccessPresent = 0;
	gestaltOpenTptRemoteAccessLoaded = 1;
	gestaltOpenTptRemoteAccessClientOnly = 2;
	gestaltOpenTptRemoteAccessPServer = 3;
	gestaltOpenTptRemoteAccessMPServer = 4;
	gestaltOpenTptPPPPresent	= 5;
	gestaltOpenTptARAPPresent	= 6;

	gestaltOpenTptRemoteAccessVersion = $6F747276 (* 'otrv' *);


	{  ***** Open Transport Gestalt ***** }


	gestaltOpenTptVersions		= $6F747672 (* 'otvr' *);						{  Defined by OT 1.1 and higher, response is NumVersion. }

	gestaltOpenTpt				= $6F74616E (* 'otan' *);						{  Defined by all versions, response is defined below. }
	gestaltOpenTptPresentMask	= $00000001;
	gestaltOpenTptLoadedMask	= $00000002;
	gestaltOpenTptAppleTalkPresentMask = $00000004;
	gestaltOpenTptAppleTalkLoadedMask = $00000008;
	gestaltOpenTptTCPPresentMask = $00000010;
	gestaltOpenTptTCPLoadedMask	= $00000020;
	gestaltOpenTptIPXSPXPresentMask = $00000040;
	gestaltOpenTptIPXSPXLoadedMask = $00000080;
	gestaltOpenTptPresentBit	= 0;
	gestaltOpenTptLoadedBit		= 1;
	gestaltOpenTptAppleTalkPresentBit = 2;
	gestaltOpenTptAppleTalkLoadedBit = 3;
	gestaltOpenTptTCPPresentBit	= 4;
	gestaltOpenTptTCPLoadedBit	= 5;
	gestaltOpenTptIPXSPXPresentBit = 6;
	gestaltOpenTptIPXSPXLoadedBit = 7;


	gestaltPCCard				= $70636364 (* 'pccd' *);						{     PC Card attributes }
	gestaltCardServicesPresent	= 0;							{     PC Card 2.0 (68K) API is present }
	gestaltPCCardFamilyPresent	= 1;							{     PC Card 3.x (PowerPC) API is present }
	gestaltPCCardHasPowerControl = 2;							{     PCCardSetPowerLevel is supported }
	gestaltPCCardSupportsCardBus = 3;							{     CardBus is supported }

	gestaltProcClkSpeed			= $70636C6B (* 'pclk' *);						{  processor clock speed in hertz  }

	gestaltPCXAttr				= $70637867 (* 'pcxg' *);						{  PC Exchange attributes  }
	gestaltPCXHas8and16BitFAT	= 0;							{  PC Exchange supports both 8 and 16 bit FATs  }
	gestaltPCXHasProDOS			= 1;							{  PC Exchange supports ProDOS  }
	gestaltPCXNewUI				= 2;
	gestaltPCXUseICMapping		= 3;							{  PC Exchange uses InternetConfig for file mappings  }

	gestaltLogicalPageSize		= $7067737A (* 'pgsz' *);						{  logical page size  }

	{	    System 7.6 and later.  If gestaltScreenCaptureMain is not implemented,
	    PictWhap proceeds with screen capture in the usual way.
	
	    The high word of gestaltScreenCaptureMain is reserved (use 0).
	
	    To disable screen capture to disk, put zero in the low word.  To
	    specify a folder for captured pictures, put the vRefNum in the
	    low word of gestaltScreenCaptureMain, and put the directory ID in
	    gestaltScreenCaptureDir.
		}
	gestaltScreenCaptureMain	= $70696331 (* 'pic1' *);						{  Zero, or vRefNum of disk to hold picture  }
	gestaltScreenCaptureDir		= $70696332 (* 'pic2' *);						{  Directory ID of folder to hold picture  }

	gestaltGXPrintingMgrVersion	= $706D6772 (* 'pmgr' *);						{  QuickDraw GX Printing Manager Version }

	gestaltPopupAttr			= $706F7021 (* 'pop!' *);						{  popup cdef attributes  }
	gestaltPopupPresent			= 0;

	gestaltPowerMgrAttr			= $706F7772 (* 'powr' *);						{  power manager attributes  }
	gestaltPMgrExists			= 0;
	gestaltPMgrCPUIdle			= 1;
	gestaltPMgrSCC				= 2;
	gestaltPMgrSound			= 3;
	gestaltPMgrDispatchExists	= 4;
	gestaltPMgrSupportsAVPowerStateAtSleepWake = 5;

	gestaltPowerMgrVers			= $70777276 (* 'pwrv' *);						{  power manager version  }

	{	
	 * PPC will return the combination of following bit fields.
	 * e.g. gestaltPPCSupportsRealTime +gestaltPPCSupportsIncoming + gestaltPPCSupportsOutGoing
	 * indicates PPC is cuurently is only supports real time delivery
	 * and both incoming and outgoing network sessions are allowed.
	 * By default local real time delivery is supported as long as PPCInit has been called.	}
	gestaltPPCToolboxAttr		= $70706320 (* 'ppc ' *);						{  PPC toolbox attributes  }
	gestaltPPCToolboxPresent	= $0000;						{  PPC Toolbox is present  Requires PPCInit to be called  }
	gestaltPPCSupportsRealTime	= $1000;						{  PPC Supports real-time delivery  }
	gestaltPPCSupportsIncoming	= $0001;						{  PPC will allow incoming network requests  }
	gestaltPPCSupportsOutGoing	= $0002;						{  PPC will allow outgoing network requests  }
	gestaltPPCSupportsTCP_IP	= $0004;						{  PPC supports TCP/IP transport   }
	gestaltPPCSupportsIncomingAppleTalk = $0010;
	gestaltPPCSupportsIncomingTCP_IP = $0020;
	gestaltPPCSupportsOutgoingAppleTalk = $0100;
	gestaltPPCSupportsOutgoingTCP_IP = $0200;

	gestaltPowerPCProcessorFeatures = $70706366 (* 'ppcf' *);					{  Optional PowerPC processor features  }
	gestaltPowerPCHasGraphicsInstructions = 0;					{  has fres, frsqrte, and fsel instructions  }
	gestaltPowerPCHasSTFIWXInstruction = 1;						{  has stfiwx instruction  }
	gestaltPowerPCHasSquareRootInstructions = 2;				{  has fsqrt and fsqrts instructions  }
	gestaltPowerPCHasDCBAInstruction = 3;						{  has dcba instruction  }
	gestaltPowerPCHasVectorInstructions = 4;					{  has vector instructions  }
	gestaltPowerPCHasDataStreams = 5;							{  has dst, dstt, dstst, dss, and dssall instructions  }

	gestaltProcessorType		= $70726F63 (* 'proc' *);						{  processor type  }
	gestalt68000				= 1;
	gestalt68010				= 2;
	gestalt68020				= 3;
	gestalt68030				= 4;
	gestalt68040				= 5;

	gestaltSDPPromptVersion		= $70727076 (* 'prpv' *);						{  OCE Standard Directory Panel }

	gestaltParityAttr			= $70727479 (* 'prty' *);						{  parity attributes  }
	gestaltHasParityCapability	= 0;							{  has ability to check parity  }
	gestaltParityEnabled		= 1;							{  parity checking enabled  }

	gestaltQD3DVersion			= $71337620 (* 'q3v ' *);						{  Quickdraw 3D version in pack BCD }

	gestaltQD3DViewer			= $71337663 (* 'q3vc' *);						{  Quickdraw 3D viewer attributes }
	gestaltQD3DViewerPresent	= 0;							{  bit 0 set if QD3D Viewer is available }

{$ifc OLDROUTINENAMES}
	gestaltQD3DViewerNotPresent	= $00;
	gestaltQD3DViewerAvailable	= $01;

{$endc}  {OLDROUTINENAMES}

	gestaltQuickdrawVersion		= $71642020 (* 'qd  ' *);						{  quickdraw version  }
	gestaltOriginalQD			= $0000;						{  original 1-bit QD  }
	gestalt8BitQD				= $0100;						{  8-bit color QD  }
	gestalt32BitQD				= $0200;						{  32-bit color QD  }
	gestalt32BitQD11			= $0201;						{  32-bit color QDv1.1  }
	gestalt32BitQD12			= $0220;						{  32-bit color QDv1.2  }
	gestalt32BitQD13			= $0230;						{  32-bit color