{******************************************************************************}
{                                                                              }
{ BlueTooth API interface Unit for Object Pascal                               }
{                                                                              }
{ Portions created by Microsoft are Copyright (C) 1995-2001 Microsoft          }
{ Corporation. All Rights Reserved.                                            }
{                                                                              }
{ Portions created by Marcel van Brakel are Copyright (C) 1999-2001            }
{ Marcel van Brakel. All Rights Reserved.                                      }
{                                                                              }
{ Contributors: John Penman                                                    }
{                                                                              }
{ Obtained through: Joint Endeavour of Delphi Innovators (Project JEDI)        }
{                                                                              }
{ You may retrieve the latest version of this file at the Project JEDI         }
{ APILIB home page, located at http://jedi-apilib.sourceforge.net              }
{                                                                              }
{ The contents of this file are used with permission, subject to the Mozilla   }
{ Public License Version 1.1 (the "License"); you may not use this file except }
{ in compliance with the License. You may obtain a copy of the License at      }
{ http://www.mozilla.org/MPL/MPL-1.1.html                                      }
{                                                                              }
{ Software distributed under the License is distributed on an "AS IS" basis,   }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for }
{ the specific language governing rights and limitations under the License.    }
{                                                                              }
{ Alternatively, the contents of this file may be used under the terms of the  }
{ GNU Lesser General Public License (the  "LGPL License"), in which case the   }
{ provisions of the LGPL License are applicable instead of those above.        }
{ If you wish to allow use of your version of this file only under the terms   }
{ of the LGPL License and not to allow others to use your version of this file }
{ under the MPL, indicate your decision by deleting  the provisions above and  }
{ replace  them with the notice and other provisions required by the LGPL      }
{ License.  If you do not delete the provisions above, a recipient may use     }
{ your version of this file under either the MPL or the LGPL License.          }
{                                                                              }
{ For more information about the LGPL: http://www.gnu.org/copyleft/lesser.html }
{                                                                              }
{******************************************************************************}


unit JwaBtHDef;

{$WEAKPACKAGEUNIT}

{$HPPEMIT ''}
{$HPPEMIT '#include "bthdef.h"'}
{$HPPEMIT ''}

{$I jediapilib.inc}

interface

uses
  JwaWinType, JwaBthSdpDef;

const
  GUID_BTHPORT_DEVICE_INTERFACE: TGUID =     '{0850302A-B344-4FDA-9BE9-90576B8D46F0}';
  {$EXTERNALSYM GUID_BTHPORT_DEVICE_INTERFACE}
  GUID_BLUETOOTH_RADIO_IN_RANGE: TGUID =     '{EA3B5B82-26EE-450E-B0D8-D26FE30A3869}';
  {$EXTERNALSYM GUID_BLUETOOTH_RADIO_IN_RANGE}
  GUID_BLUETOOTH_RADIO_OUT_OF_RANGE: TGUID = '{E28867C9-C2AA-4CED-B969-4570866037C4}';
  {$EXTERNALSYM GUID_BLUETOOTH_RADIO_OUT_OF_RANGE}
  GUID_BLUETOOTH_PIN_REQUEST: TGUID =        '{BD198B7C-24AB-4B9A-8C0D-A8EA8349AA16}';
  {$EXTERNALSYM GUID_BLUETOOTH_PIN_REQUEST}
  GUID_BLUETOOTH_L2CAP_EVENT: TGUID =        '{7EAE4030-B709-4AA8-AC55-E953829C9DAA}';
  {$EXTERNALSYM GUID_BLUETOOTH_L2CAP_EVENT}
  GUID_BLUETOOTH_HCI_EVENT: TGUID =          '{FC240062-1541-49BE-B463-84C4DCD7BF7F}';
  {$EXTERNALSYM GUID_BLUETOOTH_HCI_EVENT}

//
// Bluetooth base UUID for service discovery
//

 BLUETOOTH_BASE_UUID = '{00000000-0000-1000-8000-00805F9B34FB}';
 {$EXTERNALSYM BLUETOOTH_BASE_UUID}

//
// UUID for the root of the browse group list
//

  SDP_PROTOCOL_UUID: TGUID        = '{00000001-0000-1000-8000-00805F9B34FB}';
  {$EXTERNALSYM SDP_PROTOCOL_UUID}
  UDP_PROTOCOL_UUID: TGUID        = '{00000002-0000-1000-8000-00805F9B34FB}';
  {$EXTERNALSYM UDP_PROTOCOL_UUID}
  RFCOMM_PROTOCOL_UUID: TGUID     = '{00000003-0000-1000-8000-00805F9B34FB}';
  {$EXTERNALSYM RFCOMM_PROTOCOL_UUID}
  TCP_PROTOCOL_UUID: TGUID        = '{00000004-0000-1000-8000-00805F9B34FB}';
  {$EXTERNALSYM TCP_PROTOCOL_UUID}
  TCSBIN_PROTOCOL_UUID: TGUID     = '{00000005-0000-1000-8000-00805F9B34FB}';
  {$EXTERNALSYM TCSBIN_PROTOCOL_UUID}
  TCSAT_PROTOCOL_UUID: TGUID      = '{00000006-0000-1000-8000-00805F9B34FB}';
  {$EXTERNALSYM TCSAT_PROTOCOL_UUID}
  OBEX_PROTOCOL_UUID: TGUID       = '{00000008-0000-1000-8000-00805F9B34FB}';
  {$EXTERNALSYM OBEX_PROTOCOL_UUID}
  IP_PROTOCOL_UUID: TGUID         = '{00000009-0000-1000-8000-00805F9B34FB}';
  {$EXTERNALSYM IP_PROTOCOL_UUID}
  FTP_PROTOCOL_UUID: TGUID        = '{0000000A-0000-1000-8000-00805F9B34FB}';
  {$EXTERNALSYM FTP_PROTOCOL_UUID}
  HTTP_PROTOCOL_UUID: TGUID       = '{0000000C-0000-1000-8000-00805F9B34FB}';
  {$EXTERNALSYM HTTP_PROTOCOL_UUID}
  WSP_PROTOCOL_UUID: TGUID        = '{0000000E-0000-1000-8000-00805F9B34FB}';
  {$EXTERNALSYM WSP_PROTOCOL_UUID}
  BNEP_PROTOCOL_UUID: TGUID       = '{0000000F-0000-1000-8000-00805F9B34FB}';
  {$EXTERNALSYM BNEP_PROTOCOL_UUID}
  UPNP_PROTOCOL_UUID: TGUID       = '{00000010-0000-1000-8000-00805F9B34FB}';
  {$EXTERNALSYM UPNP_PROTOCOL_UUID}
  HID_PROTOCOL_UUID: TGUID        = '{00000011-0000-1000-8000-00805F9B34FB}';
  {$EXTERNALSYM HID_PROTOCOL_UUID}
  HCCC_PROTOCOL_UUID: TGUID       = '{00000012-0000-1000-8000-00805F9B34FB}';
  {$EXTERNALSYM HCCC_PROTOCOL_UUID}
  HCDC_PROTOCOL_UUID: TGUID       = '{00000014-0000-1000-8000-00805F9B34FB}';
  {$EXTERNALSYM HCDC_PROTOCOL_UUID}
  HN_PROTOCOL_UUID: TGUID         = '{00000016-0000-1000-8000-00805F9B34FB}';
  {$EXTERNALSYM HN_PROTOCOL_UUID}
  AVCTP_PROTOCOL_UUID: TGUID      = '{00000017-0000-1000-8000-00805F9B34FB}';
  {$EXTERNALSYM AVCTP_PROTOCOL_UUID}
  AVDTP_PROTOCOL_UUID: TGUID      = '{00000019-0000-1000-8000-00805F9B34FB}';
  {$EXTERNALSYM AVDTP_PROTOCOL_UUID}
  CMPT_PROTOCOL_UUID: TGUID       = '{0000001B-0000-1000-8000-00805F9B34FB}';
  {$EXTERNALSYM CMPT_PROTOCOL_UUID}
  UDI_C_PLANE_PROTOCOL_UUID: TGUID= '{0000001D-0000-1000-8000-00805F9B34FB}';
  {$EXTERNALSYM UDI_C_PLANE_PROTOCOL_UUID}
  L2CAP_PROTOCOL_UUID: TGUID      = '{00000100-0000-1000-8000-00805F9B34FB}';
  {$EXTERNALSYM L2CAP_PROTOCOL_UUID}

  SDP_PROTOCOL_UUID16 = $0001;
  {$EXTERNALSYM SDP_PROTOCOL_UUID16}
  UDP_PROTOCOL_UUID16 = $0002;
  {$EXTERNALSYM UDP_PROTOCOL_UUID16}
  RFCOMM_PROTOCOL_UUID16 = $0003;
  {$EXTERNALSYM RFCOMM_PROTOCOL_UUID16}
  TCP_PROTOCOL_UUID16 = $0004;
  {$EXTERNALSYM TCP_PROTOCOL_UUID16}
  TCSBIN_PROTOCOL_UUID16 = $0005;
  {$EXTERNALSYM TCSBIN_PROTOCOL_UUID16}
  TCSAT_PROTOCOL_UUID16 = $0006;
  {$EXTERNALSYM TCSAT_PROTOCOL_UUID16}
  OBEX_PROTOCOL_UUID16 = $0008;
  {$EXTERNALSYM OBEX_PROTOCOL_UUID16}
  IP_PROTOCOL_UUID16 = $0009;
  {$EXTERNALSYM IP_PROTOCOL_UUID16}
  FTP_PROTOCOL_UUID16 = $000A;
  {$EXTERNALSYM FTP_PROTOCOL_UUID16}
  HTTP_PROTOCOL_UUID16 = $000C;
  {$EXTERNALSYM HTTP_PROTOCOL_UUID16}
  WSP_PROTOCOL_UUID16 = $000E;
  {$EXTERNALSYM WSP_PROTOCOL_UUID16}
  BNEP_PROTOCOL_UUID16 = $000;
  {$EXTERNALSYM BNEP_PROTOCOL_UUID16}
  UPNP_PROTOCOL_UUID16 = $0010;
  {$EXTERNALSYM UPNP_PROTOCOL_UUID16}
  HID_PROTOCOL_UUID16 = $0011;
  {$EXTERNALSYM HID_PROTOCOL_UUID16}
  HCCC_PROTOCOL_UUID16 = $0012;
  {$EXTERNALSYM HCCC_PROTOCOL_UUID16}
  HCDC_PROTOCOL_UUID16 = $0014;
  {$EXTERNALSYM HCDC_PROTOCOL_UUID16}
  HCN_PROTOCOL_UUID16 = $0016;
  {$EXTERNALSYM HCN_PROTOCOL_UUID16}
  AVCTP_PROTOCOL_UUID16 = $0017;
  {$EXTERNALSYM AVCTP_PROTOCOL_UUID16}
  AVDTP_PROTOCOL_UUID16 = $0019;
  {$EXTERNALSYM AVDTP_PROTOCOL_UUID16}
  CMPT_PROTOCOL_UUID16 = $001B;
  {$EXTERNALSYM CMPT_PROTOCOL_UUID16}
  UDI_C_PLANE_PROTOCOL_UUID16 = $001D;
  {$EXTERNALSYM UDI_C_PLANE_PROTOCOL_UUID16}
  L2CAP_PROTOCOL_UUID16 = $0100;
  {$EXTERNALSYM L2CAP_PROTOCOL_UUID16}

  ServiceDiscoveryServerServiceClassID_UUID: TGUID = '{00001000-0000-1000-8000-00805F9B34FB}';
  BrowseGroupDescriptorServiceClassID_UUID: TGUID = '{00001001-0000-1000-8000-00805F9B34FB}';
  PublicBrowseGroupServiceClass_UUID: TGUID = '{00001002-0000-1000-8000-00805F9B34FB}';
  SerialPortServiceClass_UUID: TGUID = '{00001101-0000-1000-8000-00805F9B34FB}';
  LANAccessUsingPPPServiceClass_UUID: TGUID = '{00001102-0000-1000-8000-00805F9B34FB}';
  DialupNetworkingServiceClass_UUID: TGUID = '{00001103-0000-1000-8000-00805F9B34FB}';
  IrMCSyncServiceClass_UUID: TGUID = '{00001104-0000-1000-8000-00805F9B34FB}';
  OBEXObjectPushServiceClass_UUID: TGUID = '{00001105-0000-1000-8000-00805F9B34FB}';
  OBEXFileTransferServiceClass_UUID: TGUID = '{00001106-0000-1000-8000-00805F9B34FB}';
  IrMCSyncCommandServiceClass_UUID: TGUID = '{00001107-0000-1000-8000-00805F9B34FB}';
  HeadsetServiceClass_UUID: TGUID = '{00001108-0000-1000-8000-00805F9B34FB}';
  CordlessTelephonyServiceClass_UUID: TGUID = '{00001109-0000-1000-8000-00805F9B34FB}';
  AudioSourceServiceClass_UUID: TGUID = '{0000110A-0000-1000-8000-00805F9B34FB}';
  AudioSinkServiceClass_UUID: TGUID = '{0000110B-0000-1000-8000-00805F9B34FB}';
  AVRemoteControlTargetServiceClass_UUID: TGUID = '{0000110C-0000-1000-8000-00805F9B34FB}';
  AdvancedAudioDistributionServiceClass_UUID: TGUID = '{0000110D-0000-1000-8000-00805F9B34FB}';
  AVRemoteControlServiceClass_UUID: TGUID = '{0000110E-0000-1000-8000-00805F9B34FB}';
  VideoConferencingServiceClass_UUID: TGUID = '{0000110F-0000-1000-8000-00805F9B34FB}';
  IntercomServiceClass_UUID: TGUID = '{00001110-0000-1000-8000-00805F9B34FB}';
  FaxServiceClass_UUID: TGUID = '{00001111-0000-1000-8000-00805F9B34FB}';
  HeadsetAudioGatewayServiceClass_UUID: TGUID = '{00001112-0000-1000-8000-00805F9B34FB}';
  WAPServiceClass_UUID: TGUID = '{00001113-0000-1000-8000-00805F9B34FB}';
  WAPClientServiceClass_UUID: TGUID = '{00001114-0000-1000-8000-00805F9B34FB}';
  PANUServiceClass_UUID: TGUID = '{00001115-0000-1000-8000-00805F9B34FB}';
  NAPServiceClass_UUID: TGUID = '{00001116-0000-1000-8000-00805F9B34FB}';
  GNServiceClass_UUID: TGUID = '{00001117-0000-1000-8000-00805F9B34FB}';
  DirectPrintingServiceClass_UUID: TGUID = '{00001118-0000-1000-8000-00805F9B34FB}';
  ReferencePrintingServiceClass_UUID: TGUID = '{00001119-0000-1000-8000-00805F9B34FB}';
  ImagingServiceClass_UUID: TGUID = '{0000111A-0000-1000-8000-00805F9B34FB}';
  ImagingResponderServiceClass_UUID: TGUID = '{0000111B-0000-1000-8000-00805F9B34FB}';
  ImagingAutomaticArchiveServiceClass_UUID: TGUID = '{0000111C-0000-1000-8000-00805F9B34FB}';
  ImagingReferenceObjectsServiceClass_UUID: TGUID = '{0000111D-0000-1000-8000-00805F9B34FB}';
  HandsfreeServiceClass_UUID: TGUID = '{0000111E-0000-1000-8000-00805F9B34FB}';
  HandsfreeAudioGatewayServiceClass_UUID: TGUID = '{0000111F-0000-1000-8000-00805F9B34FB}';
  DirectPrintingReferenceObjectsServiceClass_UUID: TGUID = '{00001120-0000-1000-8000-00805F9B34FB}';
  ReflectedUIServiceClass_UUID: TGUID = '{00001121-0000-1000-8000-00805F9B34FB}';
  BasicPringingServiceClass_UUID: TGUID = '{00001122-0000-1000-8000-00805F9B34FB}';
  PrintingStatusServiceClass_UUID: TGUID = '{00001123-0000-1000-8000-00805F9B34FB}';
  HumanInterfaceDeviceServiceClass_UUID: TGUID = '{00001124-0000-1000-8000-00805F9B34FB}';
  HardcopyCableReplacementServiceClass_UUID: TGUID = '{00001125-0000-1000-8000-00805F9B34FB}';
  HCRPrintServiceClass_UUID: TGUID = '{00001126-0000-1000-8000-00805F9B34FB}';
  HCRScanServiceClass_UUID: TGUID = '{00001127-0000-1000-8000-00805F9B34FB}';
  CommonISDNAccessServiceClass_UUID: TGUID = '{00001128-0000-1000-8000-00805F9B34FB}';
  VideoConferencingGWServiceClass_UUID: TGUID = '{00001129-0000-1000-8000-00805F9B34FB}';
  UDIMTServiceClass_UUID: TGUID = '{0000112A-0000-1000-8000-00805F9B34FB}';
  UDITAServiceClass_UUID: TGUID = '{0000112B-0000-1000-8000-00805F9B34FB}';
  AudioVideoServiceClass_UUID: TGUID = '{0000112C-0000-1000-8000-00805F9B34FB}';
  PnPInformationServiceClass_UUID: TGUID = '{00001200-0000-1000-8000-00805F9B34FB}';
  GenericNetworkingServiceClass_UUID: TGUID = '{00001201-0000-1000-8000-00805F9B34FB}';
  GenericFileTransferServiceClass_UUID: TGUID = '{00001202-0000-1000-8000-00805F9B34FB}';
  GenericAudioServiceClass_UUID: TGUID = '{00001203-0000-1000-8000-00805F9B34FB}';
  GenericTelephonyServiceClass_UUID: TGUID = '{00001204-0000-1000-8000-00805F9B34FB}';

  ServiceDiscoveryServerServiceClassID_UUID16 = $1000;
  BrowseGroupDescriptorServiceClassID_UUID16 = $1001;
  PublicBrowseGroupServiceClassID_UUID16 = $1002;
  SerialPortServiceClassID_UUID16 = $1101;
  LANAccessUsingPPPServiceClassID_UUID16 = $1102;
  DialupNetworkingServiceClassID_UUID16 = $1103;
  IrMCSyncServiceClassID_UUID16 = $1104;
  OBEXObjectPushServiceClassID_UUID16 = $1105;
  OBEXFileTransferServiceClassID_UUID16 = $1106;
  IrMcSyncCommandServiceClassID_UUID16 = $1107;
  HeadsetServiceClassID_UUID16 = $1108;
  CordlessServiceClassID_UUID16 = $1109;
  AudioSourceServiceClassID_UUID16 = $110A;
  AudioSinkSourceServiceClassID_UUID16 = $110B;
  AVRemoteControlTargetServiceClassID_UUID16 = $110C;
  AdvancedAudioDistributionServiceClassID_UUID16 = $110D;
  AVRemoteControlServiceClassID_UUID16 = $110E;
  VideoConferencingServiceClassID_UUID16 = $110;
  IntercomServiceClassID_UUID16 = $1110;
  FaxServiceClassID_UUID16 = $1111;
  HeadsetAudioGatewayServiceClassID_UUID16 = $1112;
  WAPServiceClassID_UUID16 = $1113;
  WAPClientServiceClassID_UUID16 = $1114;
  PANUServiceClassID_UUID16 = $1115;
  NAPServiceClassID_UUID16 = $1116;
  GNServiceClassID_UUID16 = $1117;
  DirectPrintingServiceClassID_UUID16 = $1118;
  ReferencePrintingServiceClassID_UUID16 = $1119;
  ImagingServiceClassID_UUID16 = $111A;
  ImagingResponderServiceClassID_UUID16 = $111B;
  ImagingAutomaticArchiveServiceClassID_UUID16 = $111C;
  ImagingReferenceObjectsServiceClassID_UUID16 = $111D;
  HandsfreeServiceClassID_UUID16 = $111E;
  HandsfreeAudioGatewayServiceClassID_UUID16 = $111F;
  DirectPrintingReferenceObjectsServiceClassID_UUID16 = $1120;
  ReflectsUIServiceClassID_UUID16 = $1121;
  BasicPrintingServiceClassID_UUID16 = $1122;
  PrintingStatusServiceClassID_UUID16 = $1123;
  HumanInterfaceDeviceServiceClassID_UUID16 = $1124;
  HardcopyCableReplacementServiceClassID_UUID16 = $1125;
  HCRPrintServiceClassID_UUID16 = $1126;
  HCRScanServiceClassID_UUID16 = $1127;
  CommonISDNAccessServiceClass_UUID16 = $1128;
  VideoConferencingGWServiceClass_UUID16 = $1129;
  UDIMTServiceClass_UUID16 = $112A;
  UDITAServiceClass_UUID16 = $112B;
  AudioVideoServiceClass_UUID16 = $112C;

  PnPInformationServiceClassID_UUID16 = $1200;
  {$EXTERNALSYM PnPInformationServiceClassID_UUID16}
  GenericNetworkingServiceClassID_UUID16 = $1201;
  {$EXTERNALSYM GenericNetworkingServiceClassID_UUID16}
  GenericFileTransferServiceClassID_UUID16 = $1202;
  {$EXTERNALSYM GenericFileTransferServiceClassID_UUID16}
  GenericAudioServiceClassID_UUID16 = $1203;
  {$EXTERNALSYM GenericAudioServiceClassID_UUID16}
  GenericTelephonyServiceClassID_UUID16 = $1204;
  {$EXTERNALSYM GenericTelephonyServiceClassID_UUID16}

//
// max length of device friendly name.
//

  BTH_MAX_NAME_SIZE = 248;
  {$EXTERNALSYM BTH_MAX_NAME_SIZE}

  BTH_MAX_PIN_SIZE = 16;
  {$EXTERNALSYM BTH_MAX_PIN_SIZE}
  BTH_LINK_KEY_LENGTH = 16;
  {$EXTERNALSYM BTH_LINK_KEY_LENGTH}

  BTH_MFG_ERICSSON = 0;
  {$EXTERNALSYM BTH_MFG_ERICSSON}
  BTH_MFG_NOKIA = 1;
  {$EXTERNALSYM BTH_MFG_NOKIA}
  BTH_MFG_INTEL = 2;
  {$EXTERNALSYM BTH_MFG_INTEL}
  BTH_MFG_IBM = 3;
  {$EXTERNALSYM BTH_MFG_IBM}
  BTH_MFG_TOSHIBA = 4;
  {$EXTERNALSYM BTH_MFG_TOSHIBA}
  BTH_MFG_3COM = 5;
  {$EXTERNALSYM BTH_MFG_3COM}
  BTH_MFG_MICROSOFT = 6;
  {$EXTERNALSYM BTH_MFG_MICROSOFT}
  BTH_MFG_LUCENT = 7;
  {$EXTERNALSYM BTH_MFG_LUCENT}
  BTH_MFG_MOTOROLA = 8;
  {$EXTERNALSYM BTH_MFG_MOTOROLA}
  BTH_MFG_INFINEON = 9;
  {$EXTERNALSYM BTH_MFG_INFINEON}
  BTH_MFG_CSR = 10;
  {$EXTERNALSYM BTH_MFG_CSR}
  BTH_MFG_SILICONWAVE = 11;
  {$EXTERNALSYM BTH_MFG_SILICONWAVE}
  BTH_MFG_DIGIANSWER = 12;
  {$EXTERNALSYM BTH_MFG_DIGIANSWER}
  BTH_MFG_TI = 13;
  {$EXTERNALSYM BTH_MFG_TI}
  BTH_MFG_PARTHUS = 14;
  {$EXTERNALSYM BTH_MFG_PARTHUS}
  BTH_MFG_BROADCOM = 15;
  {$EXTERNALSYM BTH_MFG_BROADCOM}
  BTH_MFG_MITEL = 16;
  {$EXTERNALSYM BTH_MFG_MITEL}
  BTH_MFG_WIDCOMM = 17;
  {$EXTERNALSYM BTH_MFG_WIDCOMM}
  BTH_MFG_ZEEVO = 18;
  {$EXTERNALSYM BTH_MFG_ZEEVO}
  BTH_MFG_ATMEL = 19;
  {$EXTERNALSYM BTH_MFG_ATMEL}
  BTH_MFG_MITSIBUSHI = 20;
  {$EXTERNALSYM BTH_MFG_MITSIBUSHI}
  BTH_MFG_RTX_TELECOM = 21;
  {$EXTERNALSYM BTH_MFG_RTX_TELECOM}
  BTH_MFG_KC_TECHNOLOGY = 22;
  {$EXTERNALSYM BTH_MFG_KC_TECHNOLOGY}
  BTH_MFG_NEWLOGIC = 23;
  {$EXTERNALSYM BTH_MFG_NEWLOGIC}
  BTH_MFG_TRANSILICA = 24;
  {$EXTERNALSYM BTH_MFG_TRANSILICA}
  BTH_MFG_ROHDE_SCHWARZ = 25;
  {$EXTERNALSYM BTH_MFG_ROHDE_SCHWARZ}
  BTH_MFG_TTPCOM = 26;
  {$EXTERNALSYM BTH_MFG_TTPCOM}
  BTH_MFG_SIGNIA = 27;
  {$EXTERNALSYM BTH_MFG_SIGNIA}
  BTH_MFG_CONEXANT = 28;
  {$EXTERNALSYM BTH_MFG_CONEXANT}
  BTH_MFG_QUALCOMM = 29;
  {$EXTERNALSYM BTH_MFG_QUALCOMM}
  BTH_MFG_INVENTEL = 30;
  {$EXTERNALSYM BTH_MFG_INVENTEL}
  BTH_MFG_AVM_BERLIN = 31;
  {$EXTERNALSYM BTH_MFG_AVM_BERLIN}
  BTH_MFG_BANDSPEED = 32;
  {$EXTERNALSYM BTH_MFG_BANDSPEED}
  BTH_MFG_MANSELLA = 33;
  {$EXTERNALSYM BTH_MFG_MANSELLA}
  BTH_MFG_NEC = 34;
  {$EXTERNALSYM BTH_MFG_NEC}
  BTH_MFG_WAVEPLUS_TECHNOLOGY_CO = 35;
  {$EXTERNALSYM BTH_MFG_WAVEPLUS_TECHNOLOGY_CO}
  BTH_MFG_ALCATEL = 36;
  {$EXTERNALSYM BTH_MFG_ALCATEL}
  BTH_MFG_PHILIPS_SEMICONDUCTOR = 37;
  {$EXTERNALSYM BTH_MFG_PHILIPS_SEMICONDUCTOR}
  BTH_MFG_C_TECHNOLOGIES = 38;
  {$EXTERNALSYM BTH_MFG_C_TECHNOLOGIES}
  BTH_MFG_OPEN_INTERFACE = 39;
  {$EXTERNALSYM BTH_MFG_OPEN_INTERFACE}
  BTH_MFG_RF_MICRO_DEVICES = 40;
  {$EXTERNALSYM BTH_MFG_RF_MICRO_DEVICES}
  BTH_MFG_HITACHI = 41;
  {$EXTERNALSYM BTH_MFG_HITACHI}
  BTH_MFG_SYMBOL_TECHNOLOGIES = 42;
  {$EXTERNALSYM BTH_MFG_SYMBOL_TECHNOLOGIES}
  BTH_MFG_TENOVIS = 43;
  {$EXTERNALSYM BTH_MFG_TENOVIS}
  BTH_MFG_MACRONIX_INTERNATIONAL = 44;
  {$EXTERNALSYM BTH_MFG_MACRONIX_INTERNATIONAL}
  BTH_MFG_INTERNAL_USE = 65535;
  {$EXTERNALSYM BTH_MFG_INTERNAL_USE}

type
  BTH_ADDR = Int64;
  {$EXTERNALSYM BTH_ADDR}
  PBTH_ADDR = ^BTH_ADDR;
  {$EXTERNALSYM PBTH_ADDR}
  BTH_COD = ULONG;
  {$EXTERNALSYM BTH_COD}
  PBTH_COD = ^BTH_COD;
  {$EXTERNALSYM PBTH_COD}
  BTH_LAP = ULONG;
  {$EXTERNALSYM BTH_LAP}
  PBTH_LAP = ^BTH_LAP;
  {$EXTERNALSYM PBTH_LAP}

const
  BTH_ADDR_NULL = Int64($0000000000000000);
  {$EXTERNALSYM BTH_ADDR_NULL}

  NAP_MASK = Int64($FFFF00000000);
  {$EXTERNALSYM NAP_MASK}
  SAP_MASK = Int64($0000FFFFFFFF);
  {$EXTERNALSYM SAP_MASK}

  NAP_BIT_OFFSET = 8 * 4;
  {$EXTERNALSYM NAP_BIT_OFFSET}
  SAP_BIT_OFFSET = 0;
  {$EXTERNALSYM SAP_BIT_OFFSET}

function GET_NAP(_bth_addr: BTH_ADDR): Word;
function GET_SAP(_bth_addr: BTH_ADDR): ULONG;
function SET_NAP(_nap: Word): Int64; //todo impl
function SET_SAP(_sap: ULONG): Int64; // todo impl
function SET_NAP_SAP(_nap, _sap: Word): Int64; // todo impl

const
  COD_FORMAT_BIT_OFFSET = 0;
  {$EXTERNALSYM COD_FORMAT_BIT_OFFSET}
  COD_MINOR_BIT_OFFSET = 2;
  {$EXTERNALSYM COD_MINOR_BIT_OFFSET}
  COD_MAJOR_BIT_OFFSET = 8 * 1;
  {$EXTERNALSYM COD_MAJOR_BIT_OFFSET}
  COD_SERVICE_BIT_OFFSET = 8 * 1 + 5;
  {$EXTERNALSYM COD_SERVICE_BIT_OFFSET}

  COD_FORMAT_MASK = $000003;
  {$EXTERNALSYM COD_FORMAT_MASK}
  COD_MINOR_MASK = $0000FC;
  {$EXTERNALSYM COD_MINOR_MASK}
  COD_MAJOR_MASK = $001F00;
  {$EXTERNALSYM COD_MAJOR_MASK}
  COD_SERVICE_MASK = $FFE000;
  {$EXTERNALSYM COD_SERVICE_MASK}

function GET_COD_FORMAT(_cod: BTH_COD): BTH_COD;
function GET_COD_MINOR(_cod: BTH_COD): BTH_COD;
function GET_COD_MAJOR(_cod: BTH_COD): BTH_COD;
function GET_COD_SERVICE(_cod: BTH_COD): BTH_COD;

procedure SET_COD_MINOR(var _cod: BTH_COD; _minor: BTH_COD);
procedure SET_COD_MAJOR(var _cod: BTH_COD; _major: BTH_COD);
procedure SET_COD_SERVICE(var _cod: BTH_COD; _service: BTH_COD);

const
  COD_VERSION = $0;
  {$EXTERNALSYM COD_VERSION}

  COD_SERVICE_LIMITED = $0001;
  {$EXTERNALSYM COD_SERVICE_LIMITED}
  COD_SERVICE_POSITIONING = $0008;
  {$EXTERNALSYM COD_SERVICE_POSITIONING}
  COD_SERVICE_NETWORKING = $0010;
  {$EXTERNALSYM COD_SERVICE_NETWORKING}
  COD_SERVICE_RENDERING = $0020;
  {$EXTERNALSYM COD_SERVICE_RENDERING}
  COD_SERVICE_CAPTURING = $0040;
  {$EXTERNALSYM COD_SERVICE_CAPTURING}
  COD_SERVICE_OBJECT_XFER = $0080;
  {$EXTERNALSYM COD_SERVICE_OBJECT_XFER}
  COD_SERVICE_AUDIO = $0100;
  {$EXTERNALSYM COD_SERVICE_AUDIO}
  COD_SERVICE_TELEPHONY = $0200;
  {$EXTERNALSYM COD_SERVICE_TELEPHONY}
  COD_SERVICE_INFORMATION = $0400;
  {$EXTERNALSYM COD_SERVICE_INFORMATION}

  COD_SERVICE_VALID_MASK = COD_SERVICE_LIMITED or COD_SERVICE_POSITIONING or
    COD_SERVICE_NETWORKING or COD_SERVICE_RENDERING or
    COD_SERVICE_CAPTURING or COD_SERVICE_OBJECT_XFER or
    COD_SERVICE_AUDIO or COD_SERVICE_TELEPHONY or
    COD_SERVICE_INFORMATION;   
  {$EXTERNALSYM COD_SERVICE_VALID_MASK}

  COD_SERVICE_MAX_COUNT = 9;
  {$EXTERNALSYM COD_SERVICE_MAX_COUNT}

//
// Major class codes
//

const
  COD_MAJOR_MISCELLANEOUS = $00;
  {$EXTERNALSYM COD_MAJOR_MISCELLANEOUS}
  COD_MAJOR_COMPUTER = $01;
  {$EXTERNALSYM COD_MAJOR_COMPUTER}
  COD_MAJOR_PHONE = $02;
  {$EXTERNALSYM COD_MAJOR_PHONE}
  COD_MAJOR_LAN_ACCESS = $03;
  {$EXTERNALSYM COD_MAJOR_LAN_ACCESS}
  COD_MAJOR_AUDIO = $04;
  {$EXTERNALSYM COD_MAJOR_AUDIO}
  COD_MAJOR_PERIPHERAL = $05;
  {$EXTERNALSYM COD_MAJOR_PERIPHERAL}
  COD_MAJOR_IMAGING = $06;
  {$EXTERNALSYM COD_MAJOR_IMAGING}
  COD_MAJOR_UNCLASSIFIED = $1;
  {$EXTERNALSYM COD_MAJOR_UNCLASSIFIED}

//
// Minor class codes specific to each major class
//

const
  COD_COMPUTER_MINOR_UNCLASSIFIED = $00;
  {$EXTERNALSYM COD_COMPUTER_MINOR_UNCLASSIFIED}
  COD_COMPUTER_MINOR_DESKTOP = $01;
  {$EXTERNALSYM COD_COMPUTER_MINOR_DESKTOP}
  COD_COMPUTER_MINOR_SERVER = $02;
  {$EXTERNALSYM COD_COMPUTER_MINOR_SERVER}
  COD_COMPUTER_MINOR_LAPTOP = $03;
  {$EXTERNALSYM COD_COMPUTER_MINOR_LAPTOP}
  COD_COMPUTER_MINOR_HANDHELD = $04;
  {$EXTERNALSYM COD_COMPUTER_MINOR_HANDHELD}
  COD_COMPUTER_MINOR_PALM = $05;
  {$EXTERNALSYM COD_COMPUTER_MINOR_PALM}
  COD_COMPUTER_MINOR_WEARABLE = $06;
  {$EXTERNALSYM COD_COMPUTER_MINOR_WEARABLE}

  COD_PHONE_MINOR_UNCLASSIFIED = $00;
  {$EXTERNALSYM COD_PHONE_MINOR_UNCLASSIFIED}
  COD_PHONE_MINOR_CELLULAR = $01;
  {$EXTERNALSYM COD_PHONE_MINOR_CELLULAR}
  COD_PHONE_MINOR_CORDLESS = $02;
  {$EXTERNALSYM COD_PHONE_MINOR_CORDLESS}
  COD_PHONE_MINOR_SMART = $03;
  {$EXTERNALSYM COD_PHONE_MINOR_SMART}
  COD_PHONE_MINOR_WIRED_MODEM = $04;
  {$EXTERNALSYM COD_PHONE_MINOR_WIRED_MODEM}

  COD_AUDIO_MINOR_UNCLASSIFIED = $00;
  {$EXTERNALSYM COD_AUDIO_MINOR_UNCLASSIFIED}
  COD_AUDIO_MINOR_HEADSET = $01;
  {$EXTERNALSYM COD_AUDIO_MINOR_HEADSET}
  COD_AUDIO_MINOR_HANDS_FREE = $02;
  {$EXTERNALSYM COD_AUDIO_MINOR_HANDS_FREE}
  COD_AUDIO_MINOR_HEADSET_HANDS_FREE = $03;
  {$EXTERNALSYM COD_AUDIO_MINOR_HEADSET_HANDS_FREE}
  COD_AUDIO_MINOR_MICROPHONE = $0;
  {$EXTERNALSYM COD_AUDIO_MINOR_MICROPHONE}
  COD_AUDIO_MINOR_LOUDSPEAKER = $05;
  {$EXTERNALSYM COD_AUDIO_MINOR_LOUDSPEAKER}
  COD_AUDIO_MINOR_HEADPHONES = $06;
  {$EXTERNALSYM COD_AUDIO_MINOR_HEADPHONES}
  COD_AUDIO_MINOR_PORTABLE_AUDIO = $07;
  {$EXTERNALSYM COD_AUDIO_MINOR_PORTABLE_AUDIO}
  COD_AUDIO_MINOR_CAR_AUDIO = $08;
  {$EXTERNALSYM COD_AUDIO_MINOR_CAR_AUDIO}
  COD_AUDIO_MINOR_SET_TOP_BOX = $09;
  {$EXTERNALSYM COD_AUDIO_MINOR_SET_TOP_BOX}
  COD_AUDIO_MINOR_HIFI_AUDIO = $0A;
  {$EXTERNALSYM COD_AUDIO_MINOR_HIFI_AUDIO}
  COD_AUDIO_MINOR_VCR = $0B;
  {$EXTERNALSYM COD_AUDIO_MINOR_VCR}
  COD_AUDIO_MINOR_VIDEO_CAMERA = $0C;
  {$EXTERNALSYM COD_AUDIO_MINOR_VIDEO_CAMERA}
  COD_AUDIO_MINOR_CAMCORDER = $0D;
  {$EXTERNALSYM COD_AUDIO_MINOR_CAMCORDER}
  COD_AUDIO_MINOR_VIDEO_MONITOR = $0E;
  {$EXTERNALSYM COD_AUDIO_MINOR_VIDEO_MONITOR}
  COD_AUDIO_MINOR_VIDEO_DISPLAY_LOUDSPEAKER = $0F;
  {$EXTERNALSYM COD_AUDIO_MINOR_VIDEO_DISPLAY_LOUDSPEAKER}
  COD_AUDIO_MINOR_VIDEO_DISPLAY_CONFERENCING = $10;
  {$EXTERNALSYM COD_AUDIO_MINOR_VIDEO_DISPLAY_CONFERENCING}  
  //COD_AUDIO_MINOR_RESERVED = $11:
  COD_AUDIO_MINOR_GAMING_TOY = $12;
  {$EXTERNALSYM COD_AUDIO_MINOR_GAMING_TOY}

  COD_PERIPHERAL_MINOR_KEYBOARD_MASK = $10;
  {$EXTERNALSYM COD_PERIPHERAL_MINOR_KEYBOARD_MASK}
  COD_PERIPHERAL_MINOR_POINTER_MASK = $20;
  {$EXTERNALSYM COD_PERIPHERAL_MINOR_POINTER_MASK}

  COD_PERIPHERAL_MINOR_NO_CATEGORY = $00;
  {$EXTERNALSYM COD_PERIPHERAL_MINOR_NO_CATEGORY}
  COD_PERIPHERAL_MINOR_JOYSTICK = $01;
  {$EXTERNALSYM COD_PERIPHERAL_MINOR_JOYSTICK}
  COD_PERIPHERAL_MINOR_GAMEPAD = $02;
  {$EXTERNALSYM COD_PERIPHERAL_MINOR_GAMEPAD}
  COD_PERIPHERAL_MINOR_REMOTE_CONTROL = $03;
  {$EXTERNALSYM COD_PERIPHERAL_MINOR_REMOTE_CONTROL}
  COD_PERIPHERAL_MINOR_SENSING = $04;
  {$EXTERNALSYM COD_PERIPHERAL_MINOR_SENSING}

  COD_IMAGING_MINOR_DISPLAY_MASK = $04;
  {$EXTERNALSYM COD_IMAGING_MINOR_DISPLAY_MASK}
  COD_IMAGING_MINOR_CAMERA_MASK = $08;
  {$EXTERNALSYM COD_IMAGING_MINOR_CAMERA_MASK}
  COD_IMAGING_MINOR_SCANNER_MASK = $10;
  {$EXTERNALSYM COD_IMAGING_MINOR_SCANNER_MASK}
  COD_IMAGING_MINOR_PRINTER_MASK = $20;
  {$EXTERNALSYM COD_IMAGING_MINOR_PRINTER_MASK}

//
// Cannot use GET_COD_MINOR for this b/c it is embedded in a different manner
// than the rest of the major classes
//

const
  COD_LAN_ACCESS_BIT_OFFSET = 5;
  {$EXTERNALSYM COD_LAN_ACCESS_BIT_OFFSET}

  COD_LAN_MINOR_MASK = $00001C;
  {$EXTERNALSYM COD_LAN_MINOR_MASK}
  COD_LAN_ACCESS_MASK = $0000E0;
  {$EXTERNALSYM COD_LAN_ACCESS_MASK}

function GET_COD_LAN_MINOR(_cod: DWORD): DWORD;
{$EXTERNALSYM GET_COD_LAN_MINOR}
function GET_COD_LAN_ACCESS(_cod: DWORD): DWORD;
{$EXTERNALSYM GET_COD_LAN_ACCESS}

//
// LAN access percent usage subcodes
//

const
  COD_LAN_MINOR_UNCLASSIFIED = $00;
  {$EXTERNALSYM COD_LAN_MINOR_UNCLASSIFIED}

  COD_LAN_ACCESS_0_USED  = $00;
  {$EXTERNALSYM COD_LAN_ACCESS_0_USED}
  COD_LAN_ACCESS_17_USED = $01;
  {$EXTERNALSYM COD_LAN_ACCESS_17_USED}
  COD_LAN_ACCESS_33_USED = $02;
  {$EXTERNALSYM COD_LAN_ACCESS_33_USED}
  COD_LAN_ACCESS_50_USED = $03;
  {$EXTERNALSYM COD_LAN_ACCESS_50_USED}
  COD_LAN_ACCESS_67_USED = $04;
  {$EXTERNALSYM COD_LAN_ACCESS_67_USED}
  COD_LAN_ACCESS_83_USED = $05;
  {$EXTERNALSYM COD_LAN_ACCESS_83_USED}
  COD_LAN_ACCESS_99_USED = $06;
  {$EXTERNALSYM COD_LAN_ACCESS_99_USED}
  COD_LAN_ACCESS_FULL    = $07;
  {$EXTERNALSYM COD_LAN_ACCESS_FULL}

//
// Used as an initializer of LAP_DATA
//

(* (rom) not implementable in Delphi
#define LAP_GIAC_INIT                   { 0x33, 0x8B, 0x9E }
#define LAP_LIAC_INIT                   { 0x00, 0x8B, 0x9E }
*)

//
// General Inquiry Access Code.
//

const
  LAP_GIAC_VALUE = $009E8B33;
  {$EXTERNALSYM LAP_GIAC_VALUE}

//
// Limited Inquiry Access Code.
//

const
  LAP_LIAC_VALUE = $009E8B00;
  {$EXTERNALSYM LAP_LIAC_VALUE}

  BTH_ADDR_IAC_FIRST = $9E8B00;
  {$EXTERNALSYM BTH_ADDR_IAC_FIRST}
  BTH_ADDR_IAC_LAST = $9E8B3;
  {$EXTERNALSYM BTH_ADDR_IAC_LAST}
  BTH_ADDR_LIAC = $9E8B00;
  {$EXTERNALSYM BTH_ADDR_LIAC}
  BTH_ADDR_GIAC = $9E8B33;
  {$EXTERNALSYM BTH_ADDR_GIAC}

type
  BTHSTATUS = UCHAR;
  {$EXTERNALSYM BTHSTATUS}
  PBTHSTATUS = ^BTHSTATUS;
  {$EXTERNALSYM PBTHSTATUS}

function BTH_ERROR(_btStatus: BTHSTATUS): BOOL;
{$EXTERNALSYM BTH_ERROR}
function BTH_SUCCESS(_btStatus: BTHSTATUS): BOOL;
{$EXTERNALSYM BTH_SUCCESS}

const
  BTH_ERROR_SUCCESS = $00;
  {$EXTERNALSYM BTH_ERROR_SUCCESS}
  BTH_ERROR_UNKNOWN_HCI_COMMAND = $01;
  {$EXTERNALSYM BTH_ERROR_UNKNOWN_HCI_COMMAND}
  BTH_ERROR_NO_CONNECTION = $02;
  {$EXTERNALSYM BTH_ERROR_NO_CONNECTION}
  BTH_ERROR_HARDWARE_FAILURE = $03;
  {$EXTERNALSYM BTH_ERROR_HARDWARE_FAILURE}
  BTH_ERROR_PAGE_TIMEOUT = $04;
  {$EXTERNALSYM BTH_ERROR_PAGE_TIMEOUT}
  BTH_ERROR_AUTHENTICATION_FAILURE = $05;
  {$EXTERNALSYM BTH_ERROR_AUTHENTICATION_FAILURE}
  BTH_ERROR_KEY_MISSING = $06;
  {$EXTERNALSYM BTH_ERROR_KEY_MISSING}
  BTH_ERROR_MEMORY_FULL = $07;
  {$EXTERNALSYM BTH_ERROR_MEMORY_FULL}
  BTH_ERROR_CONNECTION_TIMEOUT = $08;
  {$EXTERNALSYM BTH_ERROR_CONNECTION_TIMEOUT}
  BTH_ERROR_MAX_NUMBER_OF_CONNECTIONS = $09;
  {$EXTERNALSYM BTH_ERROR_MAX_NUMBER_OF_CONNECTIONS}
  BTH_ERROR_MAX_NUMBER_OF_SCO_CONNECTIONS = $0a;
  {$EXTERNALSYM BTH_ERROR_MAX_NUMBER_OF_SCO_CONNECTIONS}
  BTH_ERROR_ACL_CONNECTION_ALREADY_EXISTS = $0b;
  {$EXTERNALSYM BTH_ERROR_ACL_CONNECTION_ALREADY_EXISTS}
  BTH_ERROR_COMMAND_DISALLOWED = $0c;
  {$EXTERNALSYM BTH_ERROR_COMMAND_DISALLOWED}
  BTH_ERROR_HOST_REJECTED_LIMITED_RESOURCES = $0d;
  {$EXTERNALSYM BTH_ERROR_HOST_REJECTED_LIMITED_RESOURCES}
  BTH_ERROR_HOST_REJECTED_SECURITY_REASONS = $0e;
  {$EXTERNALSYM BTH_ERROR_HOST_REJECTED_SECURITY_REASONS}
  BTH_ERROR_HOST_REJECTED_PERSONAL_DEVICE = $0;
  {$EXTERNALSYM BTH_ERROR_HOST_REJECTED_PERSONAL_DEVICE}
  BTH_ERROR_HOST_TIMEOUT = $10;
  {$EXTERNALSYM BTH_ERROR_HOST_TIMEOUT}
  BTH_ERROR_UNSUPPORTED_FEATURE_OR_PARAMETER = $11;
  {$EXTERNALSYM BTH_ERROR_UNSUPPORTED_FEATURE_OR_PARAMETER}
  BTH_ERROR_INVALID_HCI_PARAMETER = $12;
  {$EXTERNALSYM BTH_ERROR_INVALID_HCI_PARAMETER}
  BTH_ERROR_REMOTE_USER_ENDED_CONNECTION = $13;
  {$EXTERNALSYM BTH_ERROR_REMOTE_USER_ENDED_CONNECTION}
  BTH_ERROR_REMOTE_LOW_RESOURCES = $14;
  {$EXTERNALSYM BTH_ERROR_REMOTE_LOW_RESOURCES}
  BTH_ERROR_REMOTE_POWERING_OFF = $15;
  {$EXTERNALSYM BTH_ERROR_REMOTE_POWERING_OFF}
  BTH_ERROR_LOCAL_HOST_TERMINATED_CONNECTION = $16;
  {$EXTERNALSYM BTH_ERROR_LOCAL_HOST_TERMINATED_CONNECTION}
  BTH_ERROR_REPEATED_ATTEMPTS = $17;
  {$EXTERNALSYM BTH_ERROR_REPEATED_ATTEMPTS}
  BTH_ERROR_PAIRING_NOT_ALLOWED = $18;
  {$EXTERNALSYM BTH_ERROR_PAIRING_NOT_ALLOWED}
  BTH_ERROR_UKNOWN_LMP_PDU = $19;
  {$EXTERNALSYM BTH_ERROR_UKNOWN_LMP_PDU}
  BTH_ERROR_UNSUPPORTED_REMOTE_FEATURE = $1a;
  {$EXTERNALSYM BTH_ERROR_UNSUPPORTED_REMOTE_FEATURE}
  BTH_ERROR_SCO_OFFSET_REJECTED = $1b;
  {$EXTERNALSYM BTH_ERROR_SCO_OFFSET_REJECTED}
  BTH_ERROR_SCO_INTERVAL_REJECTED = $1c;
  {$EXTERNALSYM BTH_ERROR_SCO_INTERVAL_REJECTED}
  BTH_ERROR_SCO_AIRMODE_REJECTED = $1d;
  {$EXTERNALSYM BTH_ERROR_SCO_AIRMODE_REJECTED}
  BTH_ERROR_INVALID_LMP_PARAMETERS = $1e;
  {$EXTERNALSYM BTH_ERROR_INVALID_LMP_PARAMETERS}
  BTH_ERROR_UNSPECIFIED_ERROR = $1;
  {$EXTERNALSYM BTH_ERROR_UNSPECIFIED_ERROR}
  BTH_ERROR_UNSUPPORTED_LMP_PARM_VALUE = $20;
  {$EXTERNALSYM BTH_ERROR_UNSUPPORTED_LMP_PARM_VALUE}
  BTH_ERROR_ROLE_CHANGE_NOT_ALLOWED = $21;
  {$EXTERNALSYM BTH_ERROR_ROLE_CHANGE_NOT_ALLOWED}
  BTH_ERROR_LMP_RESPONSE_TIMEOUT = $22;
  {$EXTERNALSYM BTH_ERROR_LMP_RESPONSE_TIMEOUT}
  BTH_ERROR_LMP_TRANSACTION_COLLISION = $23;
  {$EXTERNALSYM BTH_ERROR_LMP_TRANSACTION_COLLISION}
  BTH_ERROR_LMP_PDU_NOT_ALLOWED = $24;
  {$EXTERNALSYM BTH_ERROR_LMP_PDU_NOT_ALLOWED}
  BTH_ERROR_ENCRYPTION_MODE_NOT_ACCEPTABLE = $25;
  {$EXTERNALSYM BTH_ERROR_ENCRYPTION_MODE_NOT_ACCEPTABLE}
  BTH_ERROR_UNIT_KEY_NOT_USED = $26;
  {$EXTERNALSYM BTH_ERROR_UNIT_KEY_NOT_USED}
  BTH_ERROR_QOS_IS_NOT_SUPPORTED = $27;
  {$EXTERNALSYM BTH_ERROR_QOS_IS_NOT_SUPPORTED}
  BTH_ERROR_INSTANT_PASSED = $28;
  {$EXTERNALSYM BTH_ERROR_INSTANT_PASSED}
  BTH_ERROR_PAIRING_WITH_UNIT_KEY_NOT_SUPPORTED = $29;
  {$EXTERNALSYM BTH_ERROR_PAIRING_WITH_UNIT_KEY_NOT_SUPPORTED}  

  BTH_ERROR_UNSPECIFIED = $FF;
  {$EXTERNALSYM BTH_ERROR_UNSPECIFIED}

//
// Min, max, and default L2cap MTU.
//

const
  L2CAP_MIN_MTU = 48;
  {$EXTERNALSYM L2CAP_MIN_MTU}
  L2CAP_MAX_MTU = $FFFF;
  {$EXTERNALSYM L2CAP_MAX_MTU}
  L2CAP_DEFAULT_MTU = 672;
  {$EXTERNALSYM L2CAP_DEFAULT_MTU}

//
// Max l2cap signal size (48) - size of signal header (4)
//

const
  MAX_L2CAP_PING_DATA_LENGTH = 44;
  {$EXTERNALSYM MAX_L2CAP_PING_DATA_LENGTH}
  MAX_L2CAP_INFO_DATA_LENGTH = 44;
  {$EXTERNALSYM MAX_L2CAP_INFO_DATA_LENGTH}

//
// the following two structures provides information about
// disocvered remote radios.
//

const
  BDIF_ADDRESS = $00000001;
  {$EXTERNALSYM BDIF_ADDRESS}
  BDIF_COD = $00000002;
  {$EXTERNALSYM BDIF_COD}
  BDIF_NAME = $00000004;
  {$EXTERNALSYM BDIF_NAME}
  BDIF_PAIRED = $00000008;
  {$EXTERNALSYM BDIF_PAIRED}
  BDIF_PERSONAL = $00000010;
  {$EXTERNALSYM BDIF_PERSONAL}
  BDIF_CONNECTED = $00000020;
  {$EXTERNALSYM BDIF_CONNECTED}

const
  BDIF_VALID_FLAGS = BDIF_CONNECTED or BDIF_ADDRESS or BDIF_COD or BDIF_NAME or BDIF_PAIRED or BDIF_PERSONAL;
  {$EXTERNALSYM BDIF_VALID_FLAGS}

type
  _BTH_DEVICE_INFO = record

    //
    // Combination BDIF_Xxx flags
    //
    flags: ULONG;

    //
    // Address of remote device.
    //
    address: BTH_ADDR;

    //
    // Class Of Device.
    //
    classOfDevice: BTH_COD;

    //
    // name of the device
    //
    name: array [0..BTH_MAX_NAME_SIZE - 1] of CHAR;
  end;
  {$EXTERNALSYM _BTH_DEVICE_INFO}
  BTH_DEVICE_INFO = _BTH_DEVICE_INFO;
  {$EXTERNALSYM BTH_DEVICE_INFO}
  PBTH_DEVICE_INFO = ^BTH_DEVICE_INFO;
  {$EXTERNALSYM PBTH_DEVICE_INFO}
  TBthDeviceInfo = BTH_DEVICE_INFO;
  PBthDeviceInfo = PBTH_DEVICE_INFO;

//
// Buffer associated with GUID_BLUETOOTH_RADIO_IN_RANGE
//

type
  _BTH_RADIO_IN_RANGE = record
    //
    // Information about the remote radio
    //
    deviceInfo: BTH_DEVICE_INFO;
    //
    // The previous flags value for the BTH_DEVICE_INFO.  The receiver of this
    // notification can compare the deviceInfo.flags and previousDeviceFlags
    // to determine what has changed about this remote radio.
    //
    // For instance, if BDIF_NAME is set in deviceInfo.flags and not in
    // previousDeviceFlags, the remote radio's has just been retrieved.
    //
    previousDeviceFlags: ULONG;
  end;
  {$EXTERNALSYM _BTH_RADIO_IN_RANGE}
  BTH_RADIO_IN_RANGE = _BTH_RADIO_IN_RANGE;
  {$EXTERNALSYM BTH_RADIO_IN_RANGE}
  PBTH_RADIO_IN_RANGE = ^BTH_RADIO_IN_RANGE;
  {$EXTERNALSYM PBTH_RADIO_IN_RANGE}
  TBthRadioInRange = BTH_RADIO_IN_RANGE;
  PBthRadioInRange = PBTH_RADIO_IN_RANGE;

//
// Buffer associated with GUID_BLUETOOTH_L2CAP_EVENT
//

  _BTH_L2CAP_EVENT_INFO = record
    //
    // Remote radio address which the L2CAP event is associated with
    //
    bthAddress: BTH_ADDR;

    //
    // The PSM that is either being connected to or disconnected from
    //
    psm: Word;

    //
    // If != 0, then the channel has just been established.  If == 0, then the
    // channel has been destroyed.  Notifications for a destroyed channel will
    // only be sent for channels successfully established.
    //
    connected: UCHAR;

    //
    // If != 0, then the local host iniated the l2cap connection.  If == 0, then
    // the remote host initated the connection.  This field is only valid if
    // connect is != 0.
    //
    initiated: UCHAR;
  end;
  {$EXTERNALSYM _BTH_L2CAP_EVENT_INFO}
  BTH_L2CAP_EVENT_INFO = _BTH_L2CAP_EVENT_INFO;
  {$EXTERNALSYM BTH_L2CAP_EVENT_INFO}
  PBTH_L2CAP_EVENT_INFO = ^BTH_L2CAP_EVENT_INFO;
  {$EXTERNALSYM PBTH_L2CAP_EVENT_INFO}
  TBthL2CapEventInfo = BTH_L2CAP_EVENT_INFO;
  PBthL2CapEventInfo = PBTH_L2CAP_EVENT_INFO;

const
  HCI_CONNNECTION_TYPE_ACL = 1;
  {$EXTERNALSYM HCI_CONNNECTION_TYPE_ACL}
  HCI_CONNNECTION_TYPE_SCO = 2;
  {$EXTERNALSYM HCI_CONNNECTION_TYPE_SCO}

//
// Buffer associated with GUID_BLUETOOTH_HCI_EVENT
//

type
  _BTH_HCI_EVENT_INFO = record
    //
    // Remote radio address which the HCI event is associated with
    //
    bthAddress: BTH_ADDR;

    //
    // HCI_CONNNECTION_TYPE_XXX value
    //
    connectionType: UCHAR;

    //
    // If != 0, then the underlying connection to the remote radio has just
    // been estrablished.  If == 0, then the underlying conneciton has just been
    // destroyed.
    //
    connected: UCHAR;
  end;
  {$EXTERNALSYM _BTH_HCI_EVENT_INFO}
  BTH_HCI_EVENT_INFO = _BTH_HCI_EVENT_INFO;
  {$EXTERNALSYM BTH_HCI_EVENT_INFO}
  PBTH_HCI_EVENT_INFO = ^BTH_HCI_EVENT_INFO;
  {$EXTERNALSYM PBTH_HCI_EVENT_INFO}
  TBthHciEventInfo = BTH_HCI_EVENT_INFO;
  PBthHciEventInfo = PBTH_HCI_EVENT_INFO;

const
  MAX_UUIDS_IN_QUERY = 12;
  {$EXTERNALSYM MAX_UUIDS_IN_QUERY}

  BTH_VID_DEFAULT_VALUE = $FFFF;
  {$EXTERNALSYM BTH_VID_DEFAULT_VALUE}

  SDP_ERROR_INVALID_SDP_VERSION = $0001;
  {$EXTERNALSYM SDP_ERROR_INVALID_SDP_VERSION}
  SDP_ERROR_INVALID_RECORD_HANDLE = $0002;
  {$EXTERNALSYM SDP_ERROR_INVALID_RECORD_HANDLE}
  SDP_ERROR_INVALID_REQUEST_SYNTAX = $0003;
  {$EXTERNALSYM SDP_ERROR_INVALID_REQUEST_SYNTAX}
  SDP_ERROR_INVALID_PDU_SIZE = $0004;
  {$EXTERNALSYM SDP_ERROR_INVALID_PDU_SIZE}
  SDP_ERROR_INVALID_CONTINUATION_STATE = $0005;
  {$EXTERNALSYM SDP_ERROR_INVALID_CONTINUATION_STATE}
  SDP_ERROR_INSUFFICIENT_RESOURCES = $0006;
  {$EXTERNALSYM SDP_ERROR_INSUFFICIENT_RESOURCES}

//
// Defined by windows to handle server errors that are not described by the
// above errors.  Start at 0x0100 so we don't go anywhere near the spec
// defined values.
//

//
// Success, nothing went wrong
//

const
  SDP_ERROR_SUCCESS = SDP_ERROR($0000);
  {$EXTERNALSYM SDP_ERROR_SUCCESS}

//
// The SDP PDU or parameters other than the SDP stream response was not correct
//

  SDP_ERROR_SERVER_INVALID_RESPONSE = SDP_ERROR($0100);
  {$EXTERNALSYM SDP_ERROR_SERVER_INVALID_RESPONSE}

///
/// The SDP response stream did not parse correctly.
///

  SDP_ERROR_SERVER_RESPONSE_DID_NOT_PARSE = SDP_ERROR($0200);
  {$EXTERNALSYM SDP_ERROR_SERVER_RESPONSE_DID_NOT_PARSE}

///
/// The SDP response stream was successfully parsed, but did not match the
/// required format for the query.
///

  SDP_ERROR_SERVER_BAD_FORMAT = SDP_ERROR($0300);
  {$EXTERNALSYM SDP_ERROR_SERVER_BAD_FORMAT}

///
/// SDP was unable to send a continued query back to the server
///

  SDP_ERROR_COULD_NOT_SEND_CONTINUE = SDP_ERROR($0400);
  {$EXTERNALSYM SDP_ERROR_COULD_NOT_SEND_CONTINUE}

///
/// Server sent a response that was too large to fit in the caller's buffer.
///

  SDP_ERROR_RESPONSE_TOO_LARGE = SDP_ERROR($0500);
  {$EXTERNALSYM SDP_ERROR_RESPONSE_TOO_LARGE}

  SDP_ATTRIB_RECORD_HANDLE = $0000;
  {$EXTERNALSYM SDP_ATTRIB_RECORD_HANDLE}
  SDP_ATTRIB_CLASS_ID_LIST = $0001;
  {$EXTERNALSYM SDP_ATTRIB_CLASS_ID_LIST}
  SDP_ATTRIB_RECORD_STATE = $0002;
  {$EXTERNALSYM SDP_ATTRIB_RECORD_STATE}
  SDP_ATTRIB_SERVICE_ID = $0003;
  {$EXTERNALSYM SDP_ATTRIB_SERVICE_ID}
  SDP_ATTRIB_PROTOCOL_DESCRIPTOR_LIST = $0004;
  {$EXTERNALSYM SDP_ATTRIB_PROTOCOL_DESCRIPTOR_LIST}
  SDP_ATTRIB_BROWSE_GROUP_LIST = $0005;
  {$EXTERNALSYM SDP_ATTRIB_BROWSE_GROUP_LIST}
  SDP_ATTRIB_LANG_BASE_ATTRIB_ID_LIST = $0006;
  {$EXTERNALSYM SDP_ATTRIB_LANG_BASE_ATTRIB_ID_LIST}
  SDP_ATTRIB_INFO_TIME_TO_LIVE = $0007;
  {$EXTERNALSYM SDP_ATTRIB_INFO_TIME_TO_LIVE}
  SDP_ATTRIB_AVAILABILITY = $0008;
  {$EXTERNALSYM SDP_ATTRIB_AVAILABILITY}
  SDP_ATTRIB_PROFILE_DESCRIPTOR_LIST = $0009;
  {$EXTERNALSYM SDP_ATTRIB_PROFILE_DESCRIPTOR_LIST}
  SDP_ATTRIB_DOCUMENTATION_URL = $000A;
  {$EXTERNALSYM SDP_ATTRIB_DOCUMENTATION_URL}
  SDP_ATTRIB_CLIENT_EXECUTABLE_URL = $000B;
  {$EXTERNALSYM SDP_ATTRIB_CLIENT_EXECUTABLE_URL}
  SDP_ATTRIB_ICON_URL = $000C;
  {$EXTERNALSYM SDP_ATTRIB_ICON_URL}
  SDP_ATTRIB_ADDITIONAL_PROTOCOL_DESCRIPTOR_LIST = $000D;
  {$EXTERNALSYM SDP_ATTRIB_ADDITIONAL_PROTOCOL_DESCRIPTOR_LIST}

//
// Attribute IDs in the range of 0x000D - 0x01FF are reserved for future use
//

const
  SDP_ATTRIB_PROFILE_SPECIFIC = $0200;
  {$EXTERNALSYM SDP_ATTRIB_PROFILE_SPECIFIC}

  LANG_BASE_LANGUAGE_INDEX = $0000;
  {$EXTERNALSYM LANG_BASE_LANGUAGE_INDEX}
  LANG_BASE_ENCODING_INDEX = $0001;
  {$EXTERNALSYM LANG_BASE_ENCODING_INDEX}
  LANG_BASE_OFFSET_INDEX = $0002;
  {$EXTERNALSYM LANG_BASE_OFFSET_INDEX}
  LANG_DEFAULT_ID = $0100;
  {$EXTERNALSYM LANG_DEFAULT_ID}

  STRING_NAME_OFFSET = $0000;
  {$EXTERNALSYM STRING_NAME_OFFSET}
  STRING_DESCRIPTION_OFFSET = $0001;
  {$EXTERNALSYM STRING_DESCRIPTION_OFFSET}
  STRING_PROVIDER_NAME_OFFSET = $0002;
  {$EXTERNALSYM STRING_PROVIDER_NAME_OFFSET}

  SDP_ATTRIB_SDP_VERSION_NUMBER_LIST = $0200;
  {$EXTERNALSYM SDP_ATTRIB_SDP_VERSION_NUMBER_LIST}
  SDP_ATTRIB_SDP_DATABASE_STATE = $0201;
  {$EXTERNALSYM SDP_ATTRIB_SDP_DATABASE_STATE}

  SDP_ATTRIB_BROWSE_GROUP_ID = $0200;
  {$EXTERNALSYM SDP_ATTRIB_BROWSE_GROUP_ID}

  SDP_ATTRIB_CORDLESS_EXTERNAL_NETWORK = $0301;
  {$EXTERNALSYM SDP_ATTRIB_CORDLESS_EXTERNAL_NETWORK}

  SDP_ATTRIB_FAX_CLASS_1_SUPPORT = $0302;
  {$EXTERNALSYM SDP_ATTRIB_FAX_CLASS_1_SUPPORT}
  SDP_ATTRIB_FAX_CLASS_2_0_SUPPORT = $0303;
  {$EXTERNALSYM SDP_ATTRIB_FAX_CLASS_2_0_SUPPORT}
  SDP_ATTRIB_FAX_CLASS_2_SUPPORT = $0304;
  {$EXTERNALSYM SDP_ATTRIB_FAX_CLASS_2_SUPPORT}
  SDP_ATTRIB_FAX_AUDIO_FEEDBACK_SUPPORT = $0305;
  {$EXTERNALSYM SDP_ATTRIB_FAX_AUDIO_FEEDBACK_SUPPORT}

  SDP_ATTRIB_HEADSET_REMOTE_AUDIO_VOLUME_CONTROL = $0302;
  {$EXTERNALSYM SDP_ATTRIB_HEADSET_REMOTE_AUDIO_VOLUME_CONTROL}

  SDP_ATTRIB_LAN_LPSUBNET = $0200;
  {$EXTERNALSYM SDP_ATTRIB_LAN_LPSUBNET}

  SDP_ATTRIB_OBJECT_PUSH_SUPPORTED_FORMATS_LIST = $0303;
  {$EXTERNALSYM SDP_ATTRIB_OBJECT_PUSH_SUPPORTED_FORMATS_LIST}

  SDP_ATTRIB_SYNCH_SUPPORTED_DATA_STORES_LIST = $0301;
  {$EXTERNALSYM SDP_ATTRIB_SYNCH_SUPPORTED_DATA_STORES_LIST}

//  this is in the assigned numbers doc, but it does not show up in any profile

const
  SDP_ATTRIB_SERVICE_VERSION = $0300;
  {$EXTERNALSYM SDP_ATTRIB_SERVICE_VERSION}

  SDP_ATTRIB_PAN_NETWORK_ADDRESS = $0306;
  {$EXTERNALSYM SDP_ATTRIB_PAN_NETWORK_ADDRESS}
  SDP_ATTRIB_PAN_WAP_GATEWAY = $0307;
  {$EXTERNALSYM SDP_ATTRIB_PAN_WAP_GATEWAY}
  SDP_ATTRIB_PAN_HOME_PAGE_URL = $0308;
  {$EXTERNALSYM SDP_ATTRIB_PAN_HOME_PAGE_URL}
  SDP_ATTRIB_PAN_WAP_STACK_TYPE = $0309;
  {$EXTERNALSYM SDP_ATTRIB_PAN_WAP_STACK_TYPE}
  SDP_ATTRIB_PAN_SECURITY_DESCRIPTION = $030A;
  {$EXTERNALSYM SDP_ATTRIB_PAN_SECURITY_DESCRIPTION}
  SDP_ATTRIB_PAN_NET_ACCESS_TYPE = $030B;
  {$EXTERNALSYM SDP_ATTRIB_PAN_NET_ACCESS_TYPE}
  SDP_ATTRIB_PAN_MAX_NET_ACCESS_RATE = $030C;
  {$EXTERNALSYM SDP_ATTRIB_PAN_MAX_NET_ACCESS_RATE}

  SDP_ATTRIB_IMAGING_SUPPORTED_CAPABILITIES = $0310;
  {$EXTERNALSYM SDP_ATTRIB_IMAGING_SUPPORTED_CAPABILITIES}
  SDP_ATTRIB_IMAGING_SUPPORTED_FEATURES = $0311;
  {$EXTERNALSYM SDP_ATTRIB_IMAGING_SUPPORTED_FEATURES}
  SDP_ATTRIB_IMAGING_SUPPORTED_FUNCTIONS = $0312;
  {$EXTERNALSYM SDP_ATTRIB_IMAGING_SUPPORTED_FUNCTIONS}
  SDP_ATTRIB_IMAGING_TOTAL_DATA_CAPACITY = $0313;
  {$EXTERNALSYM SDP_ATTRIB_IMAGING_TOTAL_DATA_CAPACITY}

  SDP_ATTRIB_DI_SPECIFICATION_ID = $0200;
  {$EXTERNALSYM SDP_ATTRIB_DI_SPECIFICATION_ID}
  SDP_ATTRIB_DI_VENDOR_ID = $0201;
  {$EXTERNALSYM SDP_ATTRIB_DI_VENDOR_ID}
  SDP_ATTRIB_DI_PRODUCT_ID = $0202;
  {$EXTERNALSYM SDP_ATTRIB_DI_PRODUCT_ID}
  SDP_ATTRIB_DI_VERSION = $0203;
  {$EXTERNALSYM SDP_ATTRIB_DI_VERSION}
  SDP_ATTRIB_DI_PRIMARY_RECORD = $0204;
  {$EXTERNALSYM SDP_ATTRIB_DI_PRIMARY_RECORD}
  SDP_ATTRIB_DI_VENDOR_ID_SOURCE = $0205;
  {$EXTERNALSYM SDP_ATTRIB_DI_VENDOR_ID_SOURCE}

  SDP_ATTRIB_HID_DEVICE_RELEASE_NUMBER = $0200;
  {$EXTERNALSYM SDP_ATTRIB_HID_DEVICE_RELEASE_NUMBER}
  SDP_ATTRIB_HID_PARSER_VERSION = $0201;
  {$EXTERNALSYM SDP_ATTRIB_HID_PARSER_VERSION}
  SDP_ATTRIB_HID_DEVICE_SUBCLASS = $0202;
  {$EXTERNALSYM SDP_ATTRIB_HID_DEVICE_SUBCLASS}
  SDP_ATTRIB_HID_COUNTRY_CODE = $0203;
  {$EXTERNALSYM SDP_ATTRIB_HID_COUNTRY_CODE}
  SDP_ATTRIB_HID_VIRTUAL_CABLE = $0204;
  {$EXTERNALSYM SDP_ATTRIB_HID_VIRTUAL_CABLE}
  SDP_ATTRIB_HID_RECONNECT_INITIATE = $0205;
  {$EXTERNALSYM SDP_ATTRIB_HID_RECONNECT_INITIATE}
  SDP_ATTRIB_HID_DESCRIPTOR_LIST = $0206;
  {$EXTERNALSYM SDP_ATTRIB_HID_DESCRIPTOR_LIST}
  SDP_ATTRIB_HID_LANG_ID_BASE_LIST = $0207;
  {$EXTERNALSYM SDP_ATTRIB_HID_LANG_ID_BASE_LIST}
  SDP_ATTRIB_HID_SDP_DISABLE = $0208;
  {$EXTERNALSYM SDP_ATTRIB_HID_SDP_DISABLE}
  SDP_ATTRIB_HID_BATTERY_POWER = $0209;
  {$EXTERNALSYM SDP_ATTRIB_HID_BATTERY_POWER}
  SDP_ATTRIB_HID_REMOTE_WAKE = $020A;
  {$EXTERNALSYM SDP_ATTRIB_HID_REMOTE_WAKE}
  SDP_ATTRIB_HID_REPORT_LIST = $020B;
  {$EXTERNALSYM SDP_ATTRIB_HID_REPORT_LIST}
  SDP_ATTRIB_HID_SUPERVISION_TIMEOUT = $020C;
  {$EXTERNALSYM SDP_ATTRIB_HID_SUPERVISION_TIMEOUT}
  SDP_ATTRIB_HID_NORMALLY_CONNECTABLE = $020D;
  {$EXTERNALSYM SDP_ATTRIB_HID_NORMALLY_CONNECTABLE}
  SDP_ATTRIB_HID_BOOT_DEVICE = $020E;
  {$EXTERNALSYM SDP_ATTRIB_HID_BOOT_DEVICE}

//
// Profile specific values
//

  CORDLESS_EXTERNAL_NETWORK_PSTN = $01;
  {$EXTERNALSYM CORDLESS_EXTERNAL_NETWORK_PSTN}
  CORDLESS_EXTERNAL_NETWORK_ISDN = $02;
  {$EXTERNALSYM CORDLESS_EXTERNAL_NETWORK_ISDN}
  CORDLESS_EXTERNAL_NETWORK_GSM = $03;
  {$EXTERNALSYM CORDLESS_EXTERNAL_NETWORK_GSM}
  CORDLESS_EXTERNAL_NETWORK_CDMA = $04;
  {$EXTERNALSYM CORDLESS_EXTERNAL_NETWORK_CDMA}
  CORDLESS_EXTERNAL_NETWORK_ANALOG_CELLULAR = $05;
  {$EXTERNALSYM CORDLESS_EXTERNAL_NETWORK_ANALOG_CELLULAR}
  CORDLESS_EXTERNAL_NETWORK_PACKET_SWITCHED = $06;
  {$EXTERNALSYM CORDLESS_EXTERNAL_NETWORK_PACKET_SWITCHED}
  CORDLESS_EXTERNAL_NETWORK_OTHER = $07;
  {$EXTERNALSYM CORDLESS_EXTERNAL_NETWORK_OTHER}

  OBJECT_PUSH_FORMAT_VCARD_2_1 = $01;
  {$EXTERNALSYM OBJECT_PUSH_FORMAT_VCARD_2_1}
  OBJECT_PUSH_FORMAT_VCARD_3_0 = $02;
  {$EXTERNALSYM OBJECT_PUSH_FORMAT_VCARD_3_0}
  OBJECT_PUSH_FORMAT_VCAL_1_0 = $03;
  {$EXTERNALSYM OBJECT_PUSH_FORMAT_VCAL_1_0}
  OBJECT_PUSH_FORMAT_ICAL_2_0 = $04;
  {$EXTERNALSYM OBJECT_PUSH_FORMAT_ICAL_2_0}
  OBJECT_PUSH_FORMAT_VNOTE = $05;
  {$EXTERNALSYM OBJECT_PUSH_FORMAT_VNOTE}
  OBJECT_PUSH_FORMAT_VMESSAGE = $06;
  {$EXTERNALSYM OBJECT_PUSH_FORMAT_VMESSAGE}
  OBJECT_PUSH_FORMAT_ANY = $FF;
  {$EXTERNALSYM OBJECT_PUSH_FORMAT_ANY}

  SYNCH_DATA_STORE_PHONEBOOK = $01;
  {$EXTERNALSYM SYNCH_DATA_STORE_PHONEBOOK}
  SYNCH_DATA_STORE_CALENDAR = $03;
  {$EXTERNALSYM SYNCH_DATA_STORE_CALENDAR}
  SYNCH_DATA_STORE_NOTES = $05;
  {$EXTERNALSYM SYNCH_DATA_STORE_NOTES}
  SYNCH_DATA_STORE_MESSAGES = $06;
  {$EXTERNALSYM SYNCH_DATA_STORE_MESSAGES}

  DI_VENDOR_ID_SOURCE_BLUETOOTH_SIG = $0001;
  {$EXTERNALSYM DI_VENDOR_ID_SOURCE_BLUETOOTH_SIG}
  DI_VENDOR_ID_SOURCE_USB_IF = $0002;
  {$EXTERNALSYM DI_VENDOR_ID_SOURCE_USB_IF}

  PSM_SDP = $0001;
  {$EXTERNALSYM PSM_SDP}
  PSM_RFCOMM = $0003;
  {$EXTERNALSYM PSM_RFCOMM}
  PSM_TCS_BIN = $0005;
  {$EXTERNALSYM PSM_TCS_BIN}
  PSM_TCS_BIN_CORDLESS = $0007;
  {$EXTERNALSYM PSM_TCS_BIN_CORDLESS}
  PSM_BNEP = $000;
  {$EXTERNALSYM PSM_BNEP}
  PSM_HID_CONTROL = $0011;
  {$EXTERNALSYM PSM_HID_CONTROL}
  PSM_HID_INTERRUPT = $0013;
  {$EXTERNALSYM PSM_HID_INTERRUPT}
  PSM_AVCTP = $0017;
  {$EXTERNALSYM PSM_AVCTP}
  PSM_AVDTP = $0019;
  {$EXTERNALSYM PSM_AVDTP}
  PSM_UDI_C_PLANE = $001D;
  {$EXTERNALSYM PSM_UDI_C_PLANE}

//
// Strings
//

const
  STR_ADDR_FMTA = '(%02x:%02x:%02x:%02x:%02x:%02x)';
  {$EXTERNALSYM STR_ADDR_FMTA}
  STR_ADDR_FMTW = '(%02x:%02x:%02x:%02x:%02x:%02x)';
  {$EXTERNALSYM STR_ADDR_FMTW}

  STR_ADDR_SHORT_FMTA = '%04x%08x';
  {$EXTERNALSYM STR_ADDR_SHORT_FMTA}
  STR_ADDR_SHORT_FMTW = '%04x%08x';
  {$EXTERNALSYM STR_ADDR_SHORT_FMTW}

{$IFDEF UNICODE}
  STR_ADDR_FMT = STR_ADDR_FMTW;
  {$EXTERNALSYM STR_ADDR_FMT}
  STR_ADDR_SHORT_FMT = STR_ADDR_SHORT_FMTW;
  {$EXTERNALSYM STR_ADDR_SHORT_FMT}
{$ELSE}
  STR_ADDR_FMT = STR_ADDR_FMTA;
  {$EXTERNALSYM STR_ADDR_FMT}
  STR_ADDR_SHORT_FMT = STR_ADDR_SHORT_FMTA;
  {$EXTERNALSYM STR_ADDR_SHORT_FMT}
{$ENDIF UNICODE}

function GET_BITS(Field, Offset, Mask: Integer): Integer;
{$EXTERNALSYM GET_BITS}
function GET_BIT(Field, Offset: Integer): Integer;
{$EXTERNALSYM GET_BIT}

function LMP_3_SLOT_PACKETS(X: Integer): Integer;
{$EXTERNALSYM LMP_3_SLOT_PACKETS}
function LMP_5_SLOT_PACKETS(X: Integer): Integer;
{$EXTERNALSYM LMP_5_SLOT_PACKETS}
function LMP_ENCRYPTION(X: Integer): Integer;
{$EXTERNALSYM LMP_ENCRYPTION}
function LMP_SLOT_OFFSET(X: Integer): Integer;
{$EXTERNALSYM LMP_SLOT_OFFSET}
function LMP_TIMING_ACCURACY(X: Integer): Integer;
{$EXTERNALSYM LMP_TIMING_ACCURACY}
function LMP_SWITCH(X: Integer): Integer;
{$EXTERNALSYM LMP_SWITCH}
function LMP_HOLD_MODE(X: Integer): Integer;
{$EXTERNALSYM LMP_HOLD_MODE}
function LMP_SNIFF_MODE(X: Integer): Integer;
{$EXTERNALSYM LMP_SNIFF_MODE}
function LMP_PARK_MODE(X: Integer): Integer;
{$EXTERNALSYM LMP_PARK_MODE}
function LMP_RSSI(X: Integer): Integer;
{$EXTERNALSYM LMP_RSSI}
function LMP_CHANNEL_QUALITY_DRIVEN_MODE(X: Integer): Integer;
{$EXTERNALSYM LMP_CHANNEL_QUALITY_DRIVEN_MODE}
function LMP_SCO_LINK(X: Integer): Integer;
{$EXTERNALSYM LMP_SCO_LINK}
function LMP_HV2_PACKETS(X: Integer): Integer;
{$EXTERNALSYM LMP_HV2_PACKETS}
function LMP_HV3_PACKETS(X: Integer): Integer;
{$EXTERNALSYM LMP_HV3_PACKETS}
function LMP_MU_LAW_LOG(X: Integer): Integer;
{$EXTERNALSYM LMP_MU_LAW_LOG}
function LMP_A_LAW_LOG(X: Integer): Integer;
{$EXTERNALSYM LMP_A_LAW_LOG}
function LMP_CVSD(X: Integer): Integer;
{$EXTERNALSYM LMP_CVSD}
function LMP_PAGING_SCHEME(X: Integer): Integer;
{$EXTERNALSYM LMP_PAGING_SCHEME}
function LMP_POWER_CONTROL(X: Integer): Integer;
{$EXTERNALSYM LMP_POWER_CONTROL}
function LMP_TRANSPARENT_SCO_DATA(X: Integer): Integer;
{$EXTERNALSYM LMP_TRANSPARENT_SCO_DATA}
function LMP_FLOW_CONTROL_LAG(X: Integer): Integer;
{$EXTERNALSYM LMP_FLOW_CONTROL_LAG}

implementation

function GET_NAP(_bth_addr: BTH_ADDR): Word;
begin
  Result := ((_bth_addr and NAP_MASK) shr NAP_BIT_OFFSET);
end;

function GET_SAP(_bth_addr: BTH_ADDR): ULONG;
begin
  Result := ((_bth_addr and SAP_MASK) shr SAP_BIT_OFFSET);
end;

function SET_NAP(_nap: Word): Int64;
begin
  Result := (_nap shl NAP_BIT_OFFSET);
end;

function SET_SAP(_sap: ULONG): Int64;
begin
  Result := (_sap shl SAP_BIT_OFFSET);
end;

function SET_NAP_SAP(_nap, _sap: Word): Int64;
begin
  Result := (SET_NAP(_nap) or SET_SAP(_sap));
end;

function GET_COD_LAN_MINOR(_cod: DWORD): DWORD;
begin
  Result := ((_cod and COD_LAN_MINOR_MASK) shr COD_MINOR_BIT_OFFSET);
end;

function GET_COD_LAN_ACCESS(_cod: DWORD): DWORD;
begin
  Result := ((_cod and COD_LAN_ACCESS_MASK) shr COD_LAN_ACCESS_BIT_OFFSET);
end;

function BTH_ERROR(_btStatus: BTHSTATUS): BOOL;
begin
  Result := _btStatus <> BTH_ERROR_SUCCESS;
end;

function BTH_SUCCESS(_btStatus: BTHSTATUS): BOOL;
begin
  Result := _btStatus = BTH_ERROR_SUCCESS;
end;

function GET_BITS(Field, Offset, Mask: Integer): Integer;
begin
  Result := (Field shr Offset) and Mask;
end;

function GET_BIT(field,offset: Integer): Integer;
begin
  Result := GET_BITS(Field, Offset, $1);
end;

function LMP_3_SLOT_PACKETS(X: Integer): Integer;
begin
  Result := GET_BIT(x, 0);
end;

function LMP_5_SLOT_PACKETS(X: Integer): Integer;
begin
  Result := GET_BIT(x, 1);
end;

function LMP_ENCRYPTION(X: Integer): Integer;
begin
  Result := GET_BIT(x, 2);
end;

function LMP_SLOT_OFFSET(X: Integer): Integer;
begin
  Result := GET_BIT(x, 3);
end;

function LMP_TIMING_ACCURACY(X: Integer): Integer;
begin
  Result := GET_BIT(x, 4);
end;

function LMP_SWITCH(X: Integer): Integer;
begin
  Result := GET_BIT(x, 5);
end;

function LMP_HOLD_MODE(X: Integer): Integer;
begin
  Result := GET_BIT(x, 6);
end;

function LMP_SNIFF_MODE(X: Integer): Integer;
begin
  Result := GET_BIT(x, 7);
end;

function LMP_PARK_MODE(X: Integer): Integer;
begin
  Result := GET_BIT(x, 8);
end;

function LMP_RSSI(X: Integer): Integer;
begin
  Result := GET_BIT(x, 9);
end;

function LMP_CHANNEL_QUALITY_DRIVEN_MODE(X: Integer): Integer;
begin
  Result := GET_BIT(x, 10);
end;

function LMP_SCO_LINK(X: Integer): Integer;
begin
  Result := GET_BIT(x, 11);
end;

function LMP_HV2_PACKETS(X: Integer): Integer;
begin
  Result := GET_BIT(x, 12);
end;

function LMP_HV3_PACKETS(X: Integer): Integer;
begin
  Result := GET_BIT(x, 13);
end;

function LMP_MU_LAW_LOG(X: Integer): Integer;
begin
  Result := GET_BIT(x, 14);
end;

function LMP_A_LAW_LOG(X: Integer): Integer;
begin
  Result := GET_BIT(x, 15);
end;

function LMP_CVSD(X: Integer): Integer;
begin
  Result := GET_BIT(x, 16);
end;

function LMP_PAGING_SCHEME(X: Integer): Integer;
begin
  Result := GET_BIT(x, 17);
end;

function LMP_POWER_CONTROL(X: Integer): Integer;
begin
  Result := GET_BIT(x, 18);
end;

function LMP_TRANSPARENT_SCO_DATA(X: Integer): Integer;
begin
  Result := GET_BIT(x, 19);
end;

function LMP_FLOW_CONTROL_LAG(X: Integer): Integer;
begin
  Result := GET_BITS(x, 20, $3);
end;

function GET_COD_FORMAT(_cod: BTH_COD): BTH_COD;
begin
  Result := (_cod and COD_FORMAT_MASK) shr COD_FORMAT_BIT_OFFSET;
end;

function GET_COD_MINOR(_cod: BTH_COD): BTH_COD;
begin
  Result := (_cod and COD_MINOR_MASK) shr COD_MINOR_BIT_OFFSET;
end;

function GET_COD_MAJOR(_cod: BTH_COD): BTH_COD;
begin
  Result := (_cod and COD_MAJOR_MASK) shr COD_MAJOR_BIT_OFFSET;
end;

function GET_COD_SERVICE(_cod: BTH_COD): BTH_COD;
begin
  Result := (_cod and COD_SERVICE_MASK) shr COD_SERVICE_BIT_OFFSET;
end;

procedure SET_COD_MINOR(var _cod: BTH_COD; _minor: BTH_COD);
begin
  _cod := (_cod and not COD_MINOR_MASK) or (_minor shl COD_MINOR_BIT_OFFSET);
end;

procedure SET_COD_MAJOR(var _cod: BTH_COD; _major: BTH_COD);
begin
  _cod := (_cod and not COD_MAJOR_MASK) or (_major shl COD_MAJOR_BIT_OFFSET);
end;

procedure SET_COD_SERVICE(var _cod: BTH_COD; _service: BTH_COD);
begin
  _cod := (_cod and not COD_SERVICE_MASK) or (_service shl COD_SERVICE_BIT_OFFSET);
end;

end.
