/* FIGARO'S PASSWORD MANAGER (FPM)
 * Copyright (C) 2002, 2003 Manuel Estrada Sainz <ranty@debian.org>
 * 
 * FPM is open source / free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * FPM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * import_gpasman.c - import gpasman passwords
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "fpm.h"
#include "fpm_gpw.h"
#include "passfile.h"
#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "fpm_crypt.h"

#include "gpasman-1.3.0/file.h"
#include "import_gpasman.h"

static void
fpm_import_gpasman_passitem(GtkWidget** win_edit_ptr, fpm_data** data_ptr,
			    gchar *gpasman_entry[])
{
  fpm_data* new_data;
  gchar plaintext[FPM_PASSWORD_LEN+1]={0};
  char* blank_row[FPM_NUM_COL];
  gint row;

  g_print("adding entry from gpasman...\n");

  /* Set dirty flag so we know we need to save later. */
  glb_dirty = TRUE;

  new_data = g_malloc0(sizeof(fpm_data));

  strncpy(plaintext, gpasman_entry[2], FPM_PASSWORD_LEN);
  fpm_encrypt_field(	old_context, new_data->password,
			plaintext, FPM_PASSWORD_LEN);

  /* erase the plaintext password from memory */
  memset(gpasman_entry[2], 0, strlen(gpasman_entry[2]));

  new_data->title=g_strdup(gpasman_entry[0]);
  new_data->arg=g_strdup(gpasman_entry[0]);
  new_data->user=g_strdup(gpasman_entry[1]);
  new_data->notes=g_strdup(gpasman_entry[3]);
  new_data->category=g_strdup("gpasman");
  new_data->launcher=g_strdup("");
  new_data->default_list = TRUE;
  *data_ptr = new_data;

  
  /* Construct row */

  blank_row[FPM_COL_TITLE] = new_data->title;
  blank_row[FPM_COL_URL] = new_data->arg;
  blank_row[FPM_COL_USER] = new_data->user;

  /* Append row to end of CList */
  row = gtk_clist_append(glb_clist_main, blank_row);
  
  /* Keep track of the number of rows in the CList */
  glb_num_row++;
  
  /* Associate this row with the data structure. */
  gtk_clist_set_row_data(glb_clist_main, row, new_data);
  
  /* Also, add this row to our main GList */
  glb_pass_list=g_list_append(glb_pass_list, new_data);
  
  /* Update Category drop down list on main screen */
  fpm_clist_populate_cat_list();

  /*
    fpm_edit_passitem(win_edit_ptr, new_data);
    gtk_widget_hide(*win_edit_ptr);
    fpm_save_passitem(glb_win_edit, glb_edit_data, FALSE);
    gtk_widget_destroy(glb_win_edit);
    glb_win_edit=NULL;
    gtk_widget_set_sensitive(glb_win_app, TRUE);
  */
}
static gboolean
fpm_import_gpasman_file(gchar *gpasman_file, gchar *password)
{
  gchar *entry[4];
  gint retval, count;

  retval = load_init(gpasman_file, password);
  switch (retval) {
  case 1: /* everything went allright */
    break;
  case 0:
    g_print("Can't open file\n");
    return FALSE;
  case -1:
    g_print("File permissions bad, should be -rw------\n");
    return FALSE;
  case -2:
    g_print("File is a symlink\n");
    return FALSE;
  case -3:
    g_print("Can't get file status\n");
    return FALSE;
  default:
    g_print("Internal program error\n");
    return FALSE;
  }
  retval = load_entry(entry);
	 
  while (retval == 1) {
    fpm_import_gpasman_passitem(&glb_win_edit, &glb_edit_data, entry);

    while(glb_win_edit != NULL){
      gtk_main_iteration();
    }

    for (count = 0; count < 4; count++) {
      g_free(entry[count]);
    }
    retval = load_entry(entry);
  }
  load_finalize();
  if (retval != 2){
    g_print("load_file: error retval=%d\n", retval);
    return FALSE;
  }
  return TRUE;
}
static gchar *password = NULL;
GtkWidget *password_dialog = NULL;
static void
password_cb (gchar *string, gpointer data)
{
  password = g_strdup(string);
  password_dialog = NULL;
}

gint did_it_work = 2;

static void
did_it_work_cb (gint reply, gpointer data)
{
  switch (reply){
  case  1:
    did_it_work = FALSE;
    gtk_main_quit();
    break;
  case 0:
    g_print("it_workded\n");
    did_it_work = TRUE;
    break;
  default:
    g_assert(FALSE);
  } 
}

void
fpm_import_gpasman(gchar *fname)
{

  if(access(fname, R_OK)==0){
    password_dialog =
      gnome_request_dialog (TRUE,
			    "Please type your gpasman master password.\n",
			    NULL,
			    32, /*max password size */
			    password_cb,
			    NULL,
			    NULL);

    gtk_widget_show(password_dialog);
    while(password_dialog != NULL)
      gtk_main_iteration();

    if(password){
      if (!fpm_import_gpasman_file(fname, password)){
	did_it_work = FALSE;
      }

      if(did_it_work != FALSE)
	gnome_question_dialog_modal
	  (
	   "Because of a bug or feature of gpasman, \n"
	   "there is no automatic way of telling if you\n"
	   "typed the right master password.\n"
	   "\n"
	   "If you didn't you simply get garbage.\n"
	   "\n"
	   "If you answer NO to this question, I will\n"
	   "quit now so you can try again.\n"
	   "\n"
	   "Check your main password window and look for\n"
	   "your gpasman entries.\n"
	   "\n"
	   "Did you get your old password data?",
	   did_it_work_cb, NULL);
      
      while(did_it_work > 1){
	gtk_main_iteration();
      }

      if(did_it_work){
	if(glb_dirty)
	  gnome_question_dialog_modal("Do you want to save changes?",
				      fpm_dialog_answer_save, NULL);
      }
    }
  } else {
    #warning Should complaing about the file not being accessible
  }

  g_free(password);
}
