/* Freebirth
 * Copyright (C) 1999 topher lafata <topher@topher.com>,
 *		      Jake Donham <jake@bitmechanic.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#define __FILTER_H
#ifndef __SAMPLE_PRODUCER_H
 #include "sample_producer.h"
#endif

typedef struct filter filter;
struct filter {
  /*begin sample_producer interface */
  sample *(* get_buffer)(filter *);
  void (*next_buffer)(filter *);
  sample_producer **(*get_children)(filter *);
  char **(*get_header)(filter *);
  char **(*get_code)(filter *);
  char **(*get_footer)(filter *);
  void (* schedule)(sample_producer *sp, event *e, int offset);
  void (* trigger) (sample_producer *this);
  event **events;
  /*end sample_producer interface */

  sample_producer *sp;       /* filter effects this stream */
  sample_producer *filt_e;
  sample_producer *unused;   /* dummy to terminate list */
  sample *buffer;
  unsigned int length;       /* size of filter */
  double gain;
  float *history;            /* pointer to history in filter */
  float *coef;               /* pointer to coefficients of filter */
  float fc;                 /* filter cutoff */
  float Q;                   /* resonanse */
  int next;
};

filter *filter_new(double cutoff, double q, 
		   sample_producer *filt_e,
		   sample_producer *sp);

sample *filter_get_buffer(filter *this); 
void filter_set_cutoff(filter *this,double cutoff);
void filter_set_q(filter *this,double q);
void filter_set_gain(filter *this,double gain);
void filter_delete(filter *this);

void filter_set_coeffs(filter *this, int fc, float q);
sample filter_process_sample(filter *this, sample input);

/* values for the precalculated lookup table */
#define MIN_FC            0    /*this has to be 0, because of filter 
				 env closing down */
#define MAX_FC            5000
#define MIN_Q             1
#define MAX_Q             25.0
#define Q_INCREMENT       0.5

/* .1 of 32768 */
#define LIMIT 3277

/*
  Local Variables:
  mode: font-lock
  End:
*/
