//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: FFThread.cpp,v 1.14 2005/11/27 17:48:23 delpinux Exp $

#include <FFThread.hpp>

#include <StreamCenter.hpp>
#include <ThreadStaticCenter.hpp>
#include <Timer.hpp>

#include <ReferenceCounting.hpp>

#include <FFLexer.hpp>
#include <ParametersInitialization.hpp>

#include <RealExpression.hpp>

#include <Expression.hpp>
#include <Instruction.hpp>

#include <ErrorHandler.hpp>

#include <vector>
#include <fstream>

// The lexer pointer.
Lexer* fflexer;

// The parser function.
int ffparse();

std::vector<ReferenceCounting<Instruction> > iSet;
VariableList variableList;

void FFThread::run()
{

  ThreadStaticCenter threadStaticCenter;

  try {
    Timer totalTime;
    totalTime.start();
    ffout(1) << "FreeFEM3D computing thread: started\n";

    variableList.clear();
    iSet.clear();

    ffout(2) << "Parsing data\n";
    ParametersInitialization();
    {
      fflexer = new FFLexer(__in);
      ffparse();
      delete fflexer;
    }
    ffout(2) << "Parsing data: done\n";

    for (std::vector<ReferenceCounting<Instruction> >::iterator i = iSet.begin();
	 i != iSet.end(); ++i) {
      (*(*i)).execute();
    }
    totalTime.stop();
    ffout(1) << "FreeFEM3D computing thread: done [costs: " << totalTime << "]\n";
  }
  catch(ErrorHandler e) {
    e.writeErrorMessage();    
  }
  catch(...) {
    fferr(0) << "error: Unknown exception caught!\n";
    fferr(0) << "\nUNEXPECTED ERROR: this should not occure, please report it\n";
    fferr(0) << "\nBUG REPORT: Please send bug reports to:\n"
	     << "  ff3d-dev@nongnu.org or freefem@ann.jussieu.fr\n"
	     << "or better, use the Bug Tracking System:\n"
	     << "  http://savannah.nongnu.org/bugs/?group=ff3d\n";
  }

  variableList.clear();
  iSet.clear(); // cleans memory to avoid bad exit
}

FFThread::FFThread(std::istream& in)
  : __in(in)
{
  ;
}

FFThread::~FFThread()
{
  this->join();
}
