//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: MultiGridOptions.hpp,v 1.2 2003/12/23 18:24:54 uid68082 Exp $

#ifndef _MULTIGRID_OPTIONS_HPP_
#define _MULTIGRID_OPTIONS_HPP_

#include <ParametrizableObject.hpp>

class MultiGridOptions
  : public ParametrizableObject
{
private:
  std::ostream& put(std::ostream& os) const
  {
    os << this->identifier();
    return os;
  }

public:
  static const char* identifier()
  {
    // autodoc: "to change multigrid options (\textbf{Not working anymore!})"
    return "multigrid";
  }

  const real_t epsilon()
  {
    real_t __eps;
    get("epsilon",__eps);
    return __eps;
  }

  const real_t omega()
  {
    real_t __omega;
    get("omega",__omega);
    return __omega;
  }

  const int maxiter()
  {
    int __maxiter;
    get("maxiter",__maxiter);
    return __maxiter;
  }

  const int level()
  {
    int __level;
    get("level",__level);
    return __level;
  }

  const int mu1()
  {
    int __mu1;
    get("mu1",__mu1);
    return __mu1;
  }

  const int mu2()
  {
    int __mu2;
    get("mu2",__mu2);
    return __mu2;
  }

  const int nu1()
  {
    int __nu1;
    get("nu1",__nu1);
    return __nu1;
  }

  const int nu2()
  {
    int __nu2;
    get("nu2",__nu2);
    return __nu2;
  }

  explicit MultiGridOptions()
  {
    // autodoc: "maximum number of iterations"
    add(new IntegerParameter(1, "maxiter"));
    // autodoc: "grid level"
    add(new IntegerParameter(3, "level"));
    // autodoc: "$\nu_1$"
    add(new IntegerParameter(2, "nu1"));
    // autodoc: "$\nu_2$"
    add(new IntegerParameter(2, "nu2"));
    // autodoc: "$\mu_1$"
    add(new IntegerParameter(1, "mu1"));
    // autodoc: "$\mu_2$"
    add(new IntegerParameter(1, "mu2"));
    // autodoc: "the factor of reduction of the residu"
    add(new DoubleParameter (1E-4,"epsilon"));
    // autodoc: "$\omega$, the relaxation parameter for Jacobi solver"
    add(new DoubleParameter (2./3.,"omega"));
  }

  ~MultiGridOptions()
  {
    ;
  }

};

#endif // _MULTIGRID_OPTIONS_HPP_

