//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: Translation.hpp,v 1.2 2003/05/04 18:09:01 delpinux Exp $


#ifndef TRANSLATION
#define TRANSLATION

#include <Transform.hpp>
#include <TinyVector.hpp>
/*!
  \class Translation
  This class defines translations using the same description that \p POV-Ray.

  Shapes are translated by the vector \a vect.

  \author Stphane Del Pino
 */
class Translation
  : public Transform
{
private:
  //! The Translation vector.
  TinyVector<3> __vect;

public:

  //! Applies the Translation to the vector \a v.
  TinyVector<3>& operator()(TinyVector<3>& v) const;

  //! Applies the inverse Translation to the vector \a v.
  TinyVector<3>& inverse(TinyVector<3>& v) const;

  //! Prints Translation informations to a std::string.
  std::string povWrite() const;

  //! Default constructor.
  Translation();

  //! Constructs a Translation by vector \a v.
  Translation(const TinyVector<3>& v);

  //! Copy constructor.
  Translation(const Translation& T);

  //! Destructor.
  ~Translation()
  {
    ;
  }
};

#endif // TRANSLATION

