//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: Union.cpp,v 1.2 2003/02/28 14:56:55 delpinux Exp $


// This class provides a toolkit to manipulate Unions. It inherits
// from the Shape class.

#include <Union.hpp>

//! Prints the Union informations using the stream \a s.
std::ostream& Union::put(std::ostream& s) const
{
  s << "union {\n";
  for (Union::const_iterator i = begin();
       i != end(); ++i) {
    s << (*(*i));
  }
  for (size_t i=0; i<nbTransform(); i++) {
    s << (*__trans[i]).povWrite() << '\n';
  }
  s << "}\n";
  return s;
}

//! Default constructor.
Union::Union()
  : Shape(union_)
{
  ;
}

//! Copy constructor.
Union::Union(const Union& U)
  : Shape(U),
    __objects(U.__objects)
{
  ;
}

