//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: IntegratedExpression.hpp,v 1.2 2003/05/04 18:09:01 delpinux Exp $

#ifndef INTEGRATED_EXPRESSION_HPP
#define INTEGRATED_EXPRESSION_HPP

#include <Expression.hpp>

class IntegratedExpression
  : public Expression
{
public:
  enum IType {
    unknownFunction,
    testFunction,
    function
  };

private:
  IType __integratedExpressionType;

public:
  const IType& integratedExpressionType() const
  {
    return __integratedExpressionType;
  }

  IntegratedExpression(IntegratedExpression::IType t)
    : Expression(Expression::integrated),
      __integratedExpressionType(t)
  {
    ;
  }

  IntegratedExpression(const IntegratedExpression& I)
    : Expression(I),
      __integratedExpressionType(I.__integratedExpressionType)
  {
    ;
  }

  ~IntegratedExpression()
  {
    ;
  }
};

class IntegratedExpressionUnknown
  : public IntegratedExpression
{
private:
  ReferenceCounting<FunctionVariable> __variableUnknown;

  std::ostream& put(std::ostream& os) const
  {
    os << (*__variableUnknown).name();
    return os;
  }

public:
  void execute()
  {
    ;
  }

  ReferenceCounting<FunctionVariable> unknown()
  {
    return __variableUnknown;
  }

  IntegratedExpressionUnknown(ReferenceCounting<FunctionVariable> V)
    : IntegratedExpression(IntegratedExpression::unknownFunction),
      __variableUnknown(V)
  {
    ;
  }

  IntegratedExpressionUnknown(const IntegratedExpressionUnknown& I)
    : IntegratedExpression(I),
      __variableUnknown(I.__variableUnknown)
  {
    ;
  }

  ~IntegratedExpressionUnknown()
  {
    ;
  }
};


class IntegratedExpressionTest
  : public IntegratedExpression
{
private:
  ReferenceCounting<TestFunctionVariable> __variableTest;

  std::ostream& put(std::ostream& os) const
  {
    os << (*__variableTest).name();
    return os;
  }

public:
  void execute()
  {
    ;
  }

  ReferenceCounting<TestFunctionVariable> testFunction()
  {
    return __variableTest;
  }

  IntegratedExpressionTest(ReferenceCounting<TestFunctionVariable> V)
    : IntegratedExpression(IntegratedExpression::testFunction),
      __variableTest(V)
  {
    ;
  }

  IntegratedExpressionTest(const IntegratedExpressionTest& I)
    : IntegratedExpression(I),
      __variableTest(I.__variableTest)
  {
    ;
  }

  ~IntegratedExpressionTest()
  {
    ;
  }
};



class IntegratedExpressionFunctionExpression
  : public IntegratedExpression
{
private:
  ReferenceCounting<FunctionExpression> __function;

  std::ostream& put(std::ostream& os) const
  {
    os << (*__function);
    return os;
  }

public:
  void execute()
  {
    (*__function).execute();
  }

  ReferenceCounting<FunctionExpression> function()
  {
    return __function;
  }

  IntegratedExpressionFunctionExpression(ReferenceCounting<FunctionExpression> F)
    : IntegratedExpression(IntegratedExpression::function),
      __function(F)
  {
    ;
  }

  IntegratedExpressionFunctionExpression(const IntegratedExpressionFunctionExpression& I)
    : IntegratedExpression(I),
      __function(I.__function)
  {
    ;
  }

  ~IntegratedExpressionFunctionExpression()
  {
    ;
  }
};

#endif // INTEGRATED_EXPRESSION_HPP

