//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: PDEProblemExpression.hpp,v 1.2 2003/05/04 18:09:01 delpinux Exp $

#ifndef _PDEPROBLEM_EXPRESSION_HPP_
#define _PDEPROBLEM_EXPRESSION_HPP_

#include <Expression.hpp>
#include <Variable.hpp>

#include <PDEEquationExpression.hpp>
#include <BoundaryConditionListExpression.hpp>
/*!
  \class PdeproblemExpression

  This class defines the base class of Pdeproblem expressions.

  \author Stephane Del Pino
 */
class PDEProblem;
class PDEProblemExpression
  : public Expression
{
public:
  enum PDEProblemType {
    description,
    undefined,
    variable
  };

private:
  PDEProblemExpression::PDEProblemType __pdeProblemType;

protected:
  ReferenceCounting<PDEProblem> __pdeProblem;

public:
  ReferenceCounting<PDEProblem> pdeProblem();

  const PDEProblemExpression::PDEProblemType& pdeProblemType() const
  {
    return __pdeProblemType;
  }

  PDEProblemExpression(const PDEProblemExpression& e);

  PDEProblemExpression(const PDEProblemExpression::PDEProblemType& t);

  virtual ~PDEProblemExpression();
};

class PDEProblemExpressionDescription
  : public PDEProblemExpression
{
private:
  std::ostream& put(std::ostream& os) const;

  ReferenceCounting<FunctionVariable> __unknown;
  ReferenceCounting<PDEEquationExpression> __pdeEquation;
  ReferenceCounting<BoundaryConditionListExpression> __bcList;

public:
  void execute();

  ReferenceCounting<PDEEquationExpression> pdeEquation();

  ReferenceCounting<BoundaryConditionListExpression> bcList();

  PDEProblemExpressionDescription(ReferenceCounting<FunctionVariable> unknown,
				  ReferenceCounting<PDEEquationExpression> pdeEquation,
				  ReferenceCounting<BoundaryConditionListExpression> bcList);

  PDEProblemExpressionDescription(const PDEProblemExpressionDescription& e);

  ~PDEProblemExpressionDescription();
};

class PDEProblemExpressionVariable
  : public PDEProblemExpression
{
private:
  ReferenceCounting<PDEProblemVariable> __pdeproblemVariable;

  std::ostream& put(std::ostream& os) const
  {
    os << (*__pdeproblemVariable).name() << ": " << (*(*__pdeproblemVariable).expression());
    return os;
  }

public:
  void execute()
  {
    ;
  }

  PDEProblemExpressionVariable(ReferenceCounting<PDEProblemVariable> r);

  PDEProblemExpressionVariable(const PDEProblemExpressionVariable& e);

  ~PDEProblemExpressionVariable();
};

class PDEProblemExpressionUndefined
  : public PDEProblemExpression
{
private:
  std::ostream& put(std::ostream& os) const
  {
    os << "undefined pdeproblem";
    return os;
  }

public:

  void execute()
  {
    ;
  }

  PDEProblemExpressionUndefined()
    : PDEProblemExpression(PDEProblemExpression::undefined)
  {
    ;
  }

  PDEProblemExpressionUndefined(const PDEProblemExpressionUndefined& m)
    : PDEProblemExpression(m)
  {
    ;
  }

  ~PDEProblemExpressionUndefined()
  {
    ;
  }
};

#endif // _PDEPROBLEM_EXPRESSION_HPP_

