//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: TestFunctionExpression.cpp,v 1.1.1.1 2003/02/17 16:32:53 delpinux Exp $

#include <VariableList.hpp>
#include <TestFunctionExpression.hpp>

// A pointer to the lexer.
extern VariableList variableList;


void TestFunctionExpressionList::subscribe()
{
  for(ListType::iterator i = __list.begin();
      i != __list.end(); ++i) {

    bool isVariable = (variableList.find((*(*i)).name()) != 0);

    if (!isVariable) {
      ReferenceCounting<Variable> newVariable
	= &dynamic_cast<TestFunctionVariable&>(*(*i));
      variableList.add(newVariable);
    } else {
      fferr(2) << __FILE__ << ':' << __LINE__
	       << ":variable already defined should do something no?\n";
    }
  }
}

void TestFunctionExpressionList::unSubscribe()
{
  for(ListType::iterator i = __list.begin();
      i != __list.end(); ++i) {
      variableList.remove((*(*i)).name());
  }
}

