#ifndef BOUNDARY_LIST_HPP
#define BOUNDARY_LIST_HPP

#include <Boundary.hpp>
#include <list>

/**
 * @file   BoundaryList.hpp
 * @author Stephane Del Pino
 * @date   Fri Apr 16 16:45:01 2004
 * 
 * @brief  list of boundaries of various type
 * 
 * 
 */
class BoundaryList
  : public Boundary
{
public:
  typedef std::list<ReferenceCounting<Boundary> > List;

private:
  std::list<ReferenceCounting<Boundary> > __list;

  void put(std::ostream& os) const
  {
    for (List::const_iterator i = __list.begin();
	 i != __list.end(); ++i) {
      os << **i << ',';
    }
    os << "\b ";
  }

public:
  const List& list() const
  {
    return __list;
  }

  void add(ReferenceCounting<Boundary> b)
  {
    __list.push_back(b);
  }

  BoundaryList(const BoundaryList& B)
    : Boundary(B),
      __list(B.__list)
  {
    ;
  }

  BoundaryList()
    : Boundary(Boundary::list)
  {
    ;
  }

  ~BoundaryList()
  {
    ;
  }
};

#endif // BOUNDARY_LIST_HPP
