//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: PDESolution.hpp,v 1.5 2005/09/25 14:27:13 delpinux Exp $

#ifndef PDE_SOLUTION_HPP
#define PDE_SOLUTION_HPP

#include <Solution.hpp>
#include <BaseVector.hpp>

#include <ReferenceCounting.hpp>

#include <DegreeOfFreedomSet.hpp>

#include <vector>

#include <UserFunction.hpp>
#include <FEMFunction.hpp>

class PDESolution 
  : public Solution
{
private:
  const DegreeOfFreedomSet& __degreeOfFreedomSet;

  BaseVector* pValue;

  //! Not copy constructor ?
  PDESolution(const PDESolution& pdeSolution)
    : __degreeOfFreedomSet(pdeSolution.__degreeOfFreedomSet)
  {
    ;
  }

public:

  void setUserFunction (const std::vector<ReferenceCounting<FEMFunctionBase> >& U)
  {
    Vector<real_t>& v = static_cast<Vector<real_t>& >(*pValue);
    for(size_t j=0; j<__degreeOfFreedomSet.numberOfDOFPositions(); ++j) {
      if (__degreeOfFreedomSet.isDOFVertex(j)) {
	for (size_t i=0; i<__degreeOfFreedomSet.numberOfVariables(); ++i) {
	  v[__degreeOfFreedomSet(i,j)]=(*U[i])[j];
	}
      }
    }
  }

  void getUserFunction(std::vector<ReferenceCounting<FEMFunctionBase> >& U) const
  {
    Vector<real_t>& v = static_cast<Vector<real_t>& >(*pValue);
    for(size_t j=0; j<__degreeOfFreedomSet.numberOfDOFPositions(); ++j) {
      if (__degreeOfFreedomSet.isDOFVertex(j)) {
	for (size_t i=0; i<__degreeOfFreedomSet.numberOfVariables(); ++i) {
	  (*U[i])[j] =  v[__degreeOfFreedomSet(i,j)];
	}
      } else {
	for (size_t i=0; i<__degreeOfFreedomSet.numberOfVariables(); ++i) {
	  (*U[i])[j] =  0;
	}
      }
    }
  }

  BaseVector& values()
  {
    return *pValue;
  }

  const BaseVector& values() const
  {
    return *pValue;
  }

  inline size_t size() const
  {
    return __degreeOfFreedomSet.size();
  }

  PDESolution(const DegreeOfFreedomSet& d)
    : __degreeOfFreedomSet(d)
  {
    pValue = new Vector<real_t>(__degreeOfFreedomSet.size());
  }

  ~PDESolution()
  {
    delete pValue;
  }
};

#endif // PDE_SOLUTION_HPP
